
/* !!!! AUTOGENERATED FILE generated by blend.rb !!!!! 
 *
 *  Copyright 2006 Øyvind Kolås <pippin@gimp.org>
 *
 * !!!! AUTOGENERATED FILE !!!!!
 *
 * The formulas used for the blend modes are from:
 *     http://www.pegtop.net/delphi/articles/blendmodes/
 *
 */
#if GEGL_CHANT_PROPERTIES
/* no properties */
#else

#define GEGL_CHANT_NAME          soft_dodge
#define GEGL_CHANT_SELF          "soft_dodge.c"
#define GEGL_CHANT_CATEGORIES    "compositors:blend"
#define GEGL_CHANT_DESCRIPTION   "Image blending operation 'soft_dodge' (<tt>c = (cA+cB<1.0)?0.5*cA / (1.0 - cB):1.0-0.5*(1.0 - cB)/cA</tt>)"

#define GEGL_CHANT_POINT_COMPOSER
#define GEGL_CHANT_PREPARE

#include "gegl-chant.h"
#include "math.h"

static void prepare (GeglOperation *self,
                     gpointer       context_id)
{
  Babl *format = babl_format ("RaGaBaA float");

  gegl_operation_set_format (self, "input", format);
  gegl_operation_set_format (self, "aux", format);
  gegl_operation_set_format (self, "output", format);
}



static gboolean
process (GeglOperation *op,
          void          *in_buf,
          void          *aux_buf,
          void          *out_buf,
          glong          n_pixels)
{
  gint i;
  gfloat *in = in_buf;
  gfloat *aux = aux_buf;
  gfloat *out = out_buf;

  if (aux==NULL)
    return TRUE;

  for (i=0; i<n_pixels; i++)
    {
      int  j;
      gfloat aA, aB;

      aA=in[3];
      aB=aux[3];
      for (j=0; j<3; j++)
          {
              gfloat cA, cB;

              cA=in[j];
              cB=aux[j];
              out[j] = cA + ((cA+cB<1.0)?0.5*cA / (1.0 - cB):1.0-0.5*(1.0 - cB)/cA-cA) * cB;
          }
      out[j] = aA;
      in  += 4;
      aux += 4;
      out += 4;
    }
  return TRUE;
}

#endif
