/****
   globals.h:  The external global variables for "omni_interp".
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */


extern int type;			/* Ascii or binary ? */
extern int bytes;			/* Number of bytes per data item */
extern int style;			/* Style of interpolation */

extern int skip;			/* Number of lines to skip in ascii */
					/* file, number of bytes to skip in */
					/* binary file. */

extern int file_chunk;			/* Max number of elements of data to */
					/* read from files before processing */
extern int data_chunk;			/* Number of data elements passed to */
					/* interpolation routines at a time. */

extern int integer;			/* Regard integers in ascii files */
					/* as floats. */

extern char suffix[40];			/* Suffix to add to out files */
extern char *progname;			/* Name of this program, for error */
					/* messages. */
extern int number;			/* Number of out files to write */

extern int num_in, num_out;		/* Number of input and output times. */
extern double *in_time,*out_time;	/* Timing sequences. */

#ifdef USER_FUN
extern double A, B, C, D, E, F;		/* User function parameters. */
#endif /* USER_FUN */

extern struct file_entry *in_file_array, *out_file_array;
					/* Arrays of file descriptions. */
