/* Box menu choice source created by BoxTool.*/

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include "link_edit_types.h"
#include "link_edit_global.h"

LinkEditMenuChoice(gnrc,num,choice)

LinkEditStatus *gnrc;
int num,*choice;

{
  char strng[80],*ch_ptr; 
  int rtrn,set;
  char **namesv;
  char *dir;
  int namesc;
  int writeorread;

  if(num < 1) return(-1);

  switch(choice[num-1]) {
     case LINK_EDIT_SAVE_FILE:
       clearsuff();
       addsuff("*.lnkp");
       writeorread = 1;
       namesc = 0;
       choosefile(&namesc,&namesv,&dir,".",writeorread);
       if(namesc != 1) {
           LinkPublicPrintMessage(gnrc->link_status,
                      "Must select one filename.");
           break;
         }
       sprintf(strng,"%s/%s",dir,namesv[0]);
       ch_ptr = strrchr(strng,'.');
       if(ch_ptr == NULL || strcmp(ch_ptr,".lnkp") != 0) /* Append suffix */
          strcat(strng,".lnkp");

       if(LinkSaveAll(gnrc->link_status,strng) == 0) {
           LinkPublicPrintMessage(gnrc->link_status,"Link saved.");
         }
       chfree(&namesc,&namesv);
       break;

     case LINK_EDIT_SAVE_PS:
       clearsuff();
       addsuff("*.ps");
       writeorread = 1;
       namesc = 0;
       choosefile(&namesc,&namesv,&dir,".",writeorread);
       if(namesc != 1) {
           LinkPublicPrintMessage(gnrc->link_status,
                      "Must select one filename.");
           break;
         }
       sprintf(strng,"%s/%s",dir,namesv[0]);
       ch_ptr = strrchr(strng,'.');
       if(ch_ptr == NULL || strcmp(ch_ptr,".ps") != 0) /* Append suffix */
          strcat(strng,".ps");

       if(LinkSavePS(gnrc->link_status,strng) == 0) {
           LinkPublicPrintMessage(gnrc->link_status,"Postscript file saved.");
         }
       chfree(&namesc,&namesv);

       break;

     case LINK_EDIT_SAVE_THREE_D_FILE:
       clearsuff();
       addsuff("*.lnk");
       writeorread = 1;
       namesc = 0;
       choosefile(&namesc,&namesv,&dir,".",writeorread);
       if(namesc != 1) {
           LinkPublicPrintMessage(gnrc->link_status,
                      "Must select one filename.");
           break;
         }
       sprintf(strng,"%s/%s",dir,namesv[0]);
       ch_ptr = strrchr(strng,'.');
       if(ch_ptr == NULL || strcmp(ch_ptr,".lnk") != 0) /* Append suffix */
          strcat(strng,".lnk");

       if(LinkSaveThreeD(gnrc->link_status,strng) == 0) {
           LinkPublicPrintMessage(gnrc->link_status,"3DLink saved.");
         }
       chfree(&namesc,&namesv);

       break;

     case LINK_EDIT_SELECT_STRAND:
       LinkModeSelectLink(gnrc->link_status);
       break;

     case LINK_EDIT_QUIT: 
       rtrn = LinkPublicUrgentWindowDialogue(gnrc->link_status,
                                     "Exit Link Editor (y/n)? ",strng);
       if(rtrn > 0 && strng[0] == 'y') {
          LinkEditExit((VOID *) gnrc);
          exit(0);
         }
       LinkPublicPrintMessage(gnrc->link_status,"Whew!");
       break;

     case LINK_EDIT_CLOSE_STRAND: 
       LinkModeCloseStrand(gnrc->link_status);
       break;

     case LINK_EDIT_OPEN_STRAND: 
       LinkModeOpenStrand(gnrc->link_status);
       break;

     case LINK_EDIT_ADD_POINT: 
       LinkModeAddPoint(gnrc->link_status);
       break;

     case LINK_EDIT_MOVE_POINT: 
       LinkModeMovePoint(gnrc->link_status);
       break;

     case LINK_EDIT_DELETE_POINT: 
       LinkModeDeletePoint(gnrc->link_status);
       break;

     case LINK_EDIT_MOVE_STRAND: 
       LinkModeTranslateLink(gnrc->link_status);
       break;

     case LINK_EDIT_SHIFT_VIEW: 
       LinkModeShiftView(gnrc->link_status);
       break;

     case LINK_EDIT_ZOOM_VIEW: 
       LinkModeZoomView(gnrc->link_status);
       break;

     case LINK_EDIT_CENTER_VIEW: 
       LinkCenterView(gnrc->link_status);
       break;

     case LINK_EDIT_HIDE_STRAND:
       LinkModeHideLink(gnrc->link_status);
       break;

     case LINK_EDIT_SHOW_ALL:
       LinkShowAll(gnrc->link_status);
       break;

     case LINK_EDIT_FLIP_CROSSING: 
       LinkModeFlipCrossing(gnrc->link_status);
       break;

     case LINK_EDIT_JOIN_STRANDS: 
       LinkModeJoinLinks(gnrc->link_status);
       break;

     case LINK_EDIT_SETTINGS_OK:
       ExtractBoxToggleState(gnrc->box_status,LINK_EDIT_SETTINGS_AXES,&set);
       LinkSetAxes(gnrc->link_status,set);

       ExtractBoxToggleState(gnrc->box_status,LINK_EDIT_SETTINGS_RULERS,&set);
       LinkSetRulers(gnrc->link_status,set);

       ExtractBoxToggleState(gnrc->box_status,LINK_EDIT_SETTINGS_ARROWS,&set);
       LinkSetArrows(gnrc->link_status,set);

       ExtractBoxToggleState(gnrc->box_status,LINK_EDIT_SETTINGS_VERTICES,&set);
       LinkSetVertices(gnrc->link_status,set);

       LinkPublicReDraw(gnrc->link_status);
       break; 

     case LINK_EDIT_GET_LINK_FILE: 
       clearsuff();
       addsuff("*.lnkp");
       writeorread = 1;
       namesc = 0;
       choosefile(&namesc,&namesv,&dir,".",writeorread);
       if(namesc != 1) {
           LinkPublicPrintMessage(gnrc->link_status,
                      "Must select one filename.");
           break;
         }
       sprintf(strng,"%s/%s",dir,namesv[0]);
       ch_ptr = strrchr(strng,'.');
       if(ch_ptr == NULL || strcmp(ch_ptr,".lnkp") != 0) /* Append suffix */
          strcat(strng,".lnkp");

       if(LinkGetFile(gnrc->link_status,strng) == 0) {
           LinkPublicPrintMessage(gnrc->link_status,"Link read.");
         }
       chfree(&namesc,&namesv);
       LinkPublicReDraw(gnrc->link_status);
       break;

     case LINK_EDIT_ADD_STRAND: 
       LinkCreateNewLink(gnrc->link_status);
       LinkModeAddPoint(gnrc->link_status);
       ChangeBoxToggleState(gnrc->box_status, LINK_EDIT_ADD_POINT,1);
       LinkPublicReDraw(gnrc->link_status);
       break;

     case LINK_EDIT_DELETE_STRAND: 
       LinkModeDeleteStrand(gnrc->link_status);
       break;

     case LINK_EDIT_CLEAR: 
       rtrn = LinkPublicUrgentWindowDialogue(gnrc->link_status,
                                     "Clear everything (y/n)? ",strng);
       if(rtrn > 0 && strng[0] == 'y') {
          LinkPublicDeleteAll(gnrc->link_status);
          LinkPublicReDraw(gnrc->link_status);
         }
       else {
          LinkPublicPrintMessage(gnrc->link_status,"Whew!");
         }
       break;

     case LINK_EDIT_REVERSE_ARROWS:
       LinkModeReverseArrows(gnrc->link_status);
       break;

    }
}
