/* rd.c: File containing all the redrawing routines */


#include <stdio.h>
#include<X11/Xlib.h>
#include "box_types.h"
#include "box_global.h"

ReDrawBoxTitleWindow(gnrc)

BoxStatus *gnrc;

{
  XWindowAttributes xwa;
  XWindowChanges xwc;
  int x,y;

  if(gnrc->TitleWindow == (Window) 0) return(0);

  /* Redraw title */
  /* Get information on TopWindow */

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  /* Change size of Title Bar to conform to new Top Window size */

  xwc.width = xwa.width;

  XConfigureWindow(dpy,gnrc->TitleWindow,(CWWidth),&xwc);

  x = (xwa.width - XTextWidth(gnrc->fontstruct,
                                gnrc->title,strlen(gnrc->title)))/2;
  y = BOX_PAD + gnrc->fth;

  XDrawString(dpy,gnrc->TitleWindow,
              gnrc->gc,x,y,gnrc->title,strlen(gnrc->title));


}

ReDrawBoxMessageWindow(gnrc)

BoxStatus *gnrc;

{

  XWindowAttributes xwa;
  XWindowChanges xwc;
  int x,y;

  if(gnrc->MessageWindow == (Window) 0) return(0);

  /* Get information on TopWindow */

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  /* Change size of Message Bar to conform to new Top Window size */

  xwc.width = xwa.width;

  XConfigureWindow(dpy,gnrc->MessageWindow,(CWWidth),&xwc);

  x = BOX_PAD;
  y = BOX_PAD + gnrc->fth;

  XDrawString(dpy,gnrc->MessageWindow,gnrc->reverse_gc,
              x,y,gnrc->message,strlen(gnrc->message));

}

BoxPrintMessage(gnrc,s)

BoxStatus *gnrc;
char *s;

{
  fprintf(stderr,"%s\n",s);
  if(gnrc->MessageWindow == (Window) 0) return(0);
  strcpy(gnrc->message,s);
  XClearWindow(dpy,gnrc->MessageWindow);

  XDrawString(dpy,gnrc->MessageWindow,gnrc->reverse_gc,
              BOX_PAD,BOX_PAD+gnrc->fth,s,strlen(s));
}

ReDrawBoxTopWindow(gnrc)

BoxStatus *gnrc;

{
  BoxList *bx;

  bx = gnrc->box.next;
  while(bx != NULL) {
     if(bx->visible == BOX_YES || 
              (bx->always_visible == BOX_YES)) {
        DrawBox(gnrc,bx);
       }
     bx = bx->next;
    }
}
