/* SCCS @(#)preenhfdfgau.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      preenhfdfgau.layout.c                           */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   preenhfdfgau.layout.c                               */
/*                                                                      */
/* DESCRIPTION  :   Preprocessing enhancement (Gauss filter)            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "preenhfdfgau.layout.h"

#define MAX_ARGS 100
#define MIN(A,B)    ((A)<(B)?(A):(B))

extern XmFontList gFontlist, gSmall_fontlist;


static void 
param_SET_callb (options_OK, Paramprepro, callData)
     Widget options_OK;
     xs_struc_paramprepro *Paramprepro;
     caddr_t callData;
{
  char stitre[30];
  int radius;
  
  radius = (int) ((MIN(dir_desc[index_image[0]].nligne, dir_desc[index_image[0]].ncolonne) + 1)/10);
  sprintf (stitre, "%d", radius); 
  XmTextSetString (Paramprepro->diameter, stitre);
}


/********************************************************
/   Creation Function for PREPRO_gaussian_param_widget 
/*******************************************************/

xs_struc_paramprepro
* build_PREPRO_gaussian_param_widget(PREPRO_gaussian_filter_param)
	Widget PREPRO_gaussian_filter_param;
{
	Widget PREPRO_gaussian_param_widget;
	Widget param_SET;
	Widget gaussian_diameter_Label_2;
	Widget Diameter_text;
	Widget PREPRO_gaussian_Label_3;
	Widget diameter_max_Label_1;
	Widget diameter_min_Label_0;
	Widget Sigma_Label_4;
	Widget sigma_Text_5;
	xs_struc_paramprepro *Paramprepro;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PREPRO_gaussian_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,240); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,199); n++;
	XtSetArg(args[n],XmNx,1); n++;

	PREPRO_gaussian_param_widget = 
	       XmCreateForm(PREPRO_gaussian_filter_param,
			    "PREPRO_gaussian_param_widget",args,n);
	XtManageChild(PREPRO_gaussian_param_widget);

	Paramprepro->parent = PREPRO_gaussian_param_widget;

	/* Creating param_SET Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition,96); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[106],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 20); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 80); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 84); n++;


	param_SET = XmCreatePushButton(PREPRO_gaussian_param_widget, 
				       "param_SET",args,n);

	XtManageChild(param_SET);

	
	/* Adding Callbacks for param_SET */ 

	XtAddCallback(param_SET,XmNactivateCallback,
		      param_SET_callb, Paramprepro);


	/* Creating gaussian_diameter_Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[489],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,5); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	gaussian_diameter_Label_2 = 
	         XmCreateLabel(PREPRO_gaussian_param_widget,
			       "gaussian_diameter_Label_2",args,n);
	XtManageChild(gaussian_diameter_Label_2);

	/* Creating Diameter_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,15); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,53); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Diameter_text = 
	   XmCreateText(PREPRO_gaussian_param_widget,"Diameter_text",args,n);
	XtManageChild(Diameter_text);

	Paramprepro->diameter = Diameter_text;

	/* Creating PREPRO_gaussian_Label_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[500],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_gaussian_Label_3 = 
	       XmCreateLabel(PREPRO_gaussian_param_widget,
			     "PREPRO_gaussian_Label_3",args,n);
	XtManageChild(PREPRO_gaussian_Label_3);

	/* Creating diameter_max_Label_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("< (size img)",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,55); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	diameter_max_Label_1 = 
	       XmCreateLabel(PREPRO_gaussian_param_widget,
			     "diameter_max_Label_1",args,n);
	XtManageChild(diameter_max_Label_1);

	/* Creating diameter_min_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0 <",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,13); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,50); n++;

	diameter_min_Label_0 = 
	         XmCreateLabel(PREPRO_gaussian_param_widget,
			       "diameter_min_Label_0",args,n);
	XtManageChild(diameter_min_Label_0);

	/* Creating Sigma_Label_4 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("sigma (eg: 0.01) :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,70); n++;

	Sigma_Label_4 = 
	   XmCreateLabel(PREPRO_gaussian_param_widget,"Sigma_Label_4",args,n);
	XtManageChild(Sigma_Label_4);

	/* Creating sigma_Text_5 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,Sigma_Label_4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,70); n++;
	XtSetArg(args[n],XmNvalue, "0.05"); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	sigma_Text_5 = 
	   XmCreateText(PREPRO_gaussian_param_widget,"sigma_Text_5",args,n);
	XtManageChild(sigma_Text_5);

	Paramprepro->alpha = sigma_Text_5;

	return(Paramprepro);
}
