/* SCCS @(#)maskparameter.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                        maskparameter.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   maskparameter.layout.c                              */
/*                                                                      */
/* DESCRIPTION  :   Convolution Create mask                             */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "maskparameter.layout.h"

#define MAX_ARGS 100
#define  MIN(A,B)    ((A)<(B)?(A):(B))

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PRO_create_mask_FormDialog_1 
/*******************************************************/

Widget
build_PRO_create_mask_widget(PRO_create_mask_param22, lines, columns, Paramprepro)
	Widget PRO_create_mask_param22;
	int lines;
	int columns;
	xs_struc_paramprepro *Paramprepro;
{
	Widget PRO_create_mask_FormDialog_1;
	Widget PRO_create_mask_separator;
	Widget PRO_create_mask_command;
	Widget PRO_create_mask_OK;
	Widget PRO_create_mask_CANCEL;
	Widget PRO_create_mask_ScrolledWindow_2;
	Widget PRO_create_mask_WorkRegion_3;
	Widget PRO_create_mask_Form_31;
	Widget * Text;
	Widget * Label;
	char repint[10];
	Arg args[MAX_ARGS];
	int i,j,n;

	/* Creating PRO_create_mask_FormDialog_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight, 35*lines + 115); n++;
	XtSetArg(args[n],XmNwidth, 40*columns + 65); n++;
	XtSetArg(args[n],XmNmaxWidth,700); n++;
	XtSetArg(args[n],XmNmaxHeight,700); n++;
	XtSetArg(args[n],XmNtitle, panel_titres[100]); n++;
	PRO_create_mask_FormDialog_1 = 
		XmCreateFormDialog(PRO_create_mask_param22,
					"PRO_create_mask_FormDialog_1",args,n);


	/* Creating PRO_create_mask_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	PRO_create_mask_command = 
		XmCreateForm(PRO_create_mask_FormDialog_1,
				"PRO_create_mask_command",args,n);

	XtManageChild(PRO_create_mask_command);

	/* Creating PRO_create_mask_CANCEL Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[398],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,58); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	PRO_create_mask_CANCEL = 
		XmCreatePushButton(PRO_create_mask_command,
			"PRO_create_mask_CANCEL",args,n);
	XtManageChild(PRO_create_mask_CANCEL);

	/* Adding Callbacks for PRO_create_mask_CANCEL */ 

	XtAddCallback(PRO_create_mask_CANCEL,XmNactivateCallback,
		PRO_create_mask_CANCEL_callb, PRO_create_mask_FormDialog_1);

	/* Creating PRO_create_mask_OK Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OK",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,42); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	PRO_create_mask_OK = 
		XmCreatePushButton(PRO_create_mask_command,
			"PRO_create_mask_OK",args,n);
	XtManageChild(PRO_create_mask_OK);

	/* Adding Callbacks for PRO_create_mask_OK */ 

	XtAddCallback(PRO_create_mask_OK,XmNactivateCallback,
		PRO_create_mask_OK_callb,PRO_create_mask_FormDialog_1);  /*a voir***/

	/* Creating PRO_create_mask_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,PRO_create_mask_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	PRO_create_mask_separator = 
		XmCreateSeparator(PRO_create_mask_FormDialog_1,
			"PRO_create_mask_separator",args,n);

	XtManageChild(PRO_create_mask_separator);


	/* Creating PRO_create_mask_ScrolledWindow_2 Widget */ 

	n = 0;
        XtSetArg(args[n],XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,PRO_create_mask_separator); n++;
	XtSetArg(args[n],XmNscrollingPolicy,XmAUTOMATIC); n++;

	PRO_create_mask_ScrolledWindow_2 = 
		XmCreateScrolledWindow(PRO_create_mask_FormDialog_1,
				"PRO_create_mask_ScrolledWindow_2",args,n);
	XtManageChild(PRO_create_mask_ScrolledWindow_2);

	/* Creating PRO_create_mask_WorkRegion_3 Widget */ 

/* depend du nombre de lines et columns*/

	n = 0;
	XtSetArg(args[n],XmNheight,40*lines + 60); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,40*columns + 60); n++;

	PRO_create_mask_WorkRegion_3 = 
		CreateWorkRegion(PRO_create_mask_ScrolledWindow_2,
					"PRO_create_mask_WorkRegion_3",args,n);
	XtManageChild(PRO_create_mask_WorkRegion_3);


	/* Creating PRO_create_mask_Form_31 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNnumColumns,columns+1); n++;
	XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;
	XtSetArg(args[n],XmNpacking,XmPACK_COLUMN); n++;
	XtSetArg(args[n],XmNadjustLast,False); n++;	

	PRO_create_mask_Form_31 = XmCreateRowColumn(PRO_create_mask_WorkRegion_3,
					"PRO_create_mask_Form_31",args,n);

	XtManageChild(PRO_create_mask_Form_31);


	Label = (Widget *) malloc ((columns+lines+1)*(sizeof (Widget)));
	Text = (Widget *) malloc (columns*lines*(sizeof (Widget)));

	Paramprepro->Text = Text;

	n=0;
	XtSetArg(args[n],XmNheight, 40); n++;
	XtSetArg(args[n],XmNwidth, 40); n++;
	XtSetArg(args[n],XmNalignment, XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNlabelString,
	  	 XmStringLtoRCreate("", XmSTRING_DEFAULT_CHARSET)); n++;
	*Label = XmCreateLabel(PRO_create_mask_Form_31,"Label",args,n);
	XtManageChild(*Label);
	Label++;

	for (i=1; i <= lines; i++){
	  n = 3;
	  sprintf (repint, "%d", i);
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
	  	XmStringLtoRCreate(repint, XmSTRING_DEFAULT_CHARSET)); n++;
 	  *Label = XmCreateLabel(PRO_create_mask_Form_31,"Label",args,n);
	  XtManageChild(*Label);
	  Label++;
	}

	for (i=1; i <= columns; i++){
	  n = 2;
	  sprintf (repint, "%d", i);
          XtSetArg(args[n],XmNalignment, XmALIGNMENT_END); n++;
	  XtSetArg(args[n],XmNfontList, gFontlist); n++;
	  XtSetArg(args[n],XmNlabelString,
	  	XmStringLtoRCreate(repint, XmSTRING_DEFAULT_CHARSET)); n++;
	  *Label = XmCreateLabel(PRO_create_mask_Form_31,"Label",args,n);
	  XtManageChild(*Label);
	  Label++;
	  for (j=0; j < lines; j++){
	     n = 2;
	     XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	     XtSetArg(args[n],XmNvalue,"1"); n++;
	     *Text = XmCreateText(PRO_create_mask_Form_31,"Text",args,n);
	     XtManageChild(*Text);
	     Text++;
	  }
	}

	XtManageChild(PRO_create_mask_FormDialog_1);

	return(PRO_create_mask_FormDialog_1);
}


