;**************************************************************************
;** bindings.lisp                                                        **
;**                                                                      **
;**      Les "bindings" sont des liens pour des appariements partiels ou **
;**totales des faits avec la partie gauche des regles de production. Ils **
;**peuvent dependre de nodes join-node, de nodes rule ou de nodes not-   **
;**node. Ce programme a les declarations, fonctions et methodes pour le  **
;**traitement des "bindings".                                            **
;**                                                                      **
;** Claudia Coiteux-Rosu  juillet                                   1989 **
;**************************************************************************
;** Fonctions,macros et metodes:                                         **
;** Definition d'un binding:                                             **
;**  :init                                                               **
;**                                                                      **
;** Tests sur les modeles:                                               **
;**  build-test-list          usable-tests          check-test-list      **
;**  run-tests                                                           **
;**                                                                      **
;** Comparaison des bindings:                                            **
;**  are-joined               not-exist-binding     match-bindings       **
;**                                                                      **
;**************************************************************************

(eval-when (compile) (load "varenv")
                     (load "ps-util")
                     (load "psmacs"))

;**************************************************************************
;** Definition d'un "binding"                                            **
;**************************************************************************
;** Sorte de `frame' definant un binding                                 **
(defflavor binding (
	(fact-list nil)	; liste de faits deja apparies
	(values	nil)	; les valeurs de variables appariees aux faits
	(back-link nil)	; pointeur au parent join-node, pointeur a la re-
                        ; gle si l'appariement etait totale ou au not-node
	(age-list nil)	; liste des ages des faits en ordre descendent
	)
  nil
  (:init-keywords :how)
  :initable-instance-variables)


;** Ajoute le pointeur au binding dans le node parent                    **
(defmethod (binding :init) (inits)
  (funcall back-link 'add-binding self (cadr (memq :how inits))))


;**************************************************************************
;** Fonctions qui aident a ajouter les tests aux nodes bind-node, join-  **
;** node et not-nodes.                                                   **
;**************************************************************************
;** Construit une liste de sous-listes de la forme (test variables) pour **
;** chaque test dans `tsts'.                                             **
(defun build-test-list (tsts)
  (car (for tst in tsts tcollect (cons tst (get-vars tst)))))


;** A partir d'une liste comme celle construit par la fonction precedente**
;** (build-test-list) retourne une liste de tests figurant dans les sous-**
;** listes de la liste de depart dont toutes les variables sont presentes**
;** dans `vars'.                                                         **
(defun usable-tests (tsts vars)
   (for tst in tsts
        when (and tst (allmemq (cdr tst) vars))
        collect (car tst)))


;** Cette fonction sera appelle apres avoir ajoutes les tests aux noeuds  **
;** de type bind-node ou join-node. Quand un test est ajoute un noeud de  **
;** ce type il est reemplace par nil dans la liste de tests a ajouter,    **
;** donc la presence d'un element non vide dans la liste resultante reve- **
;** le une inconsistence qui est decele par cette fonction.               **
(defun check-test-list (tsts)
   (and (for tst in tsts thereis tst)
	(psy-warn "Ces tests a des variables inconnues:"
	  #\N #\T (car (for tst in tsts
			when tst
			tcollect (car tst))))))


;** Evalue les tests                                                     **
(defun run-tests (vars values test-list)
   (apply `(lambda ,vars (and ,@test-list)) values))



;**************************************************************************
;** Fonctions de verifications sur les bindings                          **
;**************************************************************************
;** Verifie si n'existe pas un binding dans la liste `bdgs' pour `fait'  **
(defun not-exist-binding (fait bdgs)
   (cond ((null bdgs) t)
         ((memq fait (symeval-in-instance (car bdgs) 'fact-list)) nil)
         (t (not-exist-binding fait (cdr bdgs)))))


;** Verifie si les bindings bi1 et bi2 se joignent dans le noued suivant **
(defun are-joined (bi1 bi2 next)
   (let ((list-facts (append (symeval-in-instance bi2 'fact-list)
                             (symeval-in-instance bi1 'fact-list))))
      (cond ((typep next 'rule)
                (or
                  (for bi in (symeval-in-instance *psy-db* 'conflict-set)
                       thereis (and (eq next 
                                      (symeval-in-instance bi 'back-link))
                                    (equal list-facts
                                     (symeval-in-instance bi 'fact-list))))
                  (for nn in (symeval-in-instance next 'not-nodes)
                       thereis (for pair in (symeval-in-instance nn 
                                                     'blocked-assoc)
                                    thereis (equal list-facts
                                                   (symeval-in-instance
                                                       (car pair)
                                                       'fact-list))))))
            ((typep next 'join-node)
               (for bi in (symeval-in-instance next 'left-assoc)
                    thereis (equal list-facts
                                (symeval-in-instance bi 'fact-list)))))))


;** Teste si deux bindings ont les memes valeurs pour le memes variables **
(defun match-bindings (b1 vars1 b2 vars2 test-list all-vars)
 (attempt
  (let ((values (for var2 in vars2
		     value2 in (symeval-in-instance b2 'values)
		     unless (for var1 in vars1
				 value1 in (symeval-in-instance b1 'values)
				 thereis (and (eq var1 var2)
					      (or (equal value1 value2)
						  (fail))))
		     tcollect value2)))
   (setq values (car (lconc values (symeval-in-instance b1 'values))))
   (if (or (null test-list) (run-tests all-vars values test-list))
       values
       '$$FAIL))))
