/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.PathSearchingVirtualMachine;
import java.util.Iterator;
import jde.debugger.JDEException;
import jde.debugger.LispForm;
import jde.debugger.Protocol;
import jde.debugger.command.DebugProcessCommand;
import jde.debugger.command.Finish;

public class GetPathInfo
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (!(this.proc.getVM() instanceof PathSearchingVirtualMachine)) {
            throw new JDEException("VM doesn't search paths");
        }
        PathSearchingVirtualMachine vm = (PathSearchingVirtualMachine)this.proc.getVM();
        String bootClassPathString = "(list";
        Iterator<String> it = vm.bootClassPath().iterator();
        while (it.hasNext()) {
            bootClassPathString = bootClassPathString + " \"" + it.next() + "\"";
        }
        bootClassPathString = bootClassPathString + ")";
        bootClassPathString = bootClassPathString.replace('\\', '/');
        String classPathString = "(list";
        it = vm.classPath().iterator();
        while (it.hasNext()) {
            classPathString = classPathString + " \"" + it.next() + "\"";
        }
        classPathString = classPathString + ")";
        classPathString = classPathString.replace('\\', '/');
        this.jde.signalCommandResult(this.procID, this.cmdID, new LispForm("\"" + vm.baseDirectory().replace('\\', '/') + "\"" + Protocol.BR + bootClassPathString + Protocol.BR + classPathString));
    }

    public Object clone() {
        return new Finish();
    }
}

