/*
 *  This file is part of gpw.
 *
 *  Copyright (C) 2013-2016 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  gpw is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  gpw is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This file is generated.  gnu-pw-mgr is built with most all symbols
 * having static scope and is compiled all at once.  So all the static
 * functions are declared here and all the C files that are part of it
 * are #included here at the bottom (with two exceptions: the main code
 * gnu-pw-mgr.c and gpw-str.c, which is needed early).
 */

#ifndef GPW_FWD_GUARD
#define GPW_FWD_GUARD 1
#include "gpw-str.h"
#include "scribble.h"
#include "set-opt.h"

/*
 * FILE: gnu-pw-mgr.c
 */
static void
adjust_pw(char * buf, size_t bsz, unsigned char * data, size_t d_len);

#if SIZEOF_CHARP > 4
#endif
static void
get_dft_pw(char * buf, size_t bsz,
           char const * tag, char const * txt, char const * nam);

static void
get_pbkdf2_pw(char * buf, size_t bsz,
              char const * tag, char const * txt, char const * nam);

static void
print_pwid_header(char const * name);

static void
print_pwid_status(char const * name);

static void
select_chars(unsigned char * txtbuf);

static bool
print_one_pwid(tOptionValue const * seed_opt, char const * name);

static void
print_pwid(char const * name);

static char const *
assemble_arg(int argc, char ** argv);

static char *
trim(char * in);

static void
stdin_pwid(void);


/*
 * FILE: cclass.c
 */
static void
reprocess_cclass(tOptDesc * od, str_list_t * str_list);

static void
adjust_pin_n_alnum(tOptDesc * od);

static void
fix_cclass_bits(tOptDesc * od);

static void
sanity_check_cclass(void);


/*
 * FILE: cfg-file.c
 */
#ifndef SORT_PW_CFG // code for gnu-pw-mgr only
static char const *
access_config_file(void);

static void
set_config_name(char const * nm);

static void
secure_cfg_file(void);

static char const *
load_config_file(void);

#endif // not SORT_PW_CFG only
static char const *
find_home(void);

static char *
find_cfg_name(void);


/*
 * FILE: fix-pw.c
 */
static void
clean_triplets(char * pw);

static void
fix_no_alpha_pw(char * pw);

static void
fix_lower_only_pw(char * pw);

static uintptr_t
pick_something(uintptr_t ccls, char * pch, int * cta);

static uintptr_t
count_pw_class(char * pw, bool no_spec, int * cta);

static char *
find_upper(char * pw);

static char *
find_lower(char * pw);

static char *
find_digit(char * pw);

static char *
find_special(char * pw);

static void
add_upper(char * pw, int * cta);

static void
add_lower(char * pw, int * cta);

static void
add_digit(char * pw, int * cta);

static void
add_special(char * pw, int * cta);

static void
fix_std_pw(char * pw);

static void
fix_digit_pw(char * pw, uintptr_t * sums);


/*
 * FILE: pw-opts.c
 */
static char *
make_pwid_mark(char const * name, size_t * len);

static void
set_pwid_opts(char const * name);

static void
remove_opt(char const * txt, char const * mark, size_t m_len,
           set_opt_enum_t typ);

static bool
removed_old_opts(char const * cfg_text, char const * name, char ** mark_p);

static void
update_pwid_opts(char const * name);

static void
remove_pwid(char const * name);

static char const *
next_pwid_opt(char const * scan, char const * mark, size_t mark_len);

static void
fix_options(int * ac, char *** av);


/*
 * FILE: seed.c
 */
static void
randomize_seed(int wiggle);

static char const *
get_seed_text(void);

static uint32_t
ver_str_to_number(void);

static inline void
print_new_seed(FILE * fp, char const * cfg_text);

static void
add_seed(void);

static void
rm_seed(void);


/*
 * FILE: wrap-libnettle.c
 */
#ifdef HAVE_LIBNETTLE
static void
gpw_init_ctx(struct sha256_ctx *ctx);

static void
gpw_process(const void *buffer, size_t len, struct sha256_ctx *ctx);

static void *
gpw_finish(struct sha256_ctx *ctx, void *resbuf);

#endif /* HAVE_LIBNETTLE */

#include "cclass.c"
#include "cfg-file.c"
#include "fix-pw.c"
#include "opts.c"
#include "pw-opts.c"
#include "scribble.c"
#include "seed.c"
#include "set-opt.c"
#include "wrap-libnettle.c"
#endif /* GPW_FWD_GUARD */
