/* CSL - Common Sound Layer
 * Copyright (C) 1997, 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include	"cslutils.h"

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<stdarg.h>


/* --- functions --- */
void
csl_error (const char *format,
	   ...)
{
  va_list args;

  va_start (args, format);
  fprintf (stderr, "\n** CSL-Error **: ");
  vfprintf (stderr, format, args);
  fprintf (stderr, "\n");
  va_end (args);
  abort ();
}

void
csl_warning (const char *format,
	     ...)
{
  va_list args;

  va_start (args, format);
  fprintf (stderr, "\n** CSL-Warning **: ");
  vfprintf (stderr, format, args);
  fprintf (stderr, "\n");
  va_end (args);
}

void
csl_message (const char *format,
	     ...)
{
  va_list args;

  va_start (args, format);
  fprintf (stderr, "\nCSL-Message: ");
  vfprintf (stderr, format, args);
  fprintf (stderr, "\n");
  va_end (args);
}

static unsigned int csl_debug_mask = 0;

void
csl_set_debug_mask (unsigned int debug_mask)
{
  csl_debug_mask = debug_mask;
}

CslBool
csl_check_debug (unsigned int debug_key)
{
  return csl_debug_mask & debug_key;
}

void
csl_free (void *mem)
{
  if (mem)
    free (mem);
}

void*
csl_malloc (unsigned int n_bytes)
{
  void *mem = NULL;

  if (n_bytes)
    {
      mem = malloc (n_bytes);
      if (!mem)
	csl_error ("unable to allocate %u bytes", n_bytes);
    }
  return mem;
}

void*
csl_malloc0 (unsigned int n_bytes)
{
  void *mem = NULL;

  if (n_bytes)
    {
      mem = malloc (n_bytes);
      if (!mem)
	csl_error ("unable to allocate %u bytes", n_bytes);
      memset (mem, 0, n_bytes);
    }
  return mem;
}

void*
csl_realloc (void         *mem,
	     unsigned int  n_bytes)
{
  if (n_bytes && mem)
    {
      mem = realloc (mem, n_bytes);
      if (!mem)
	csl_error ("unable to allocate %u bytes", n_bytes);
    }
  else if (n_bytes)	/* some systems fail for realloc (0, n); */
    {
      mem = malloc (n_bytes);
      if (!mem)
	csl_error ("unable to allocate %u bytes", n_bytes);
    }
  else if (mem)
    {
      free (mem);
      mem = NULL;
    }
  
  return mem;
}

char*
csl_strdup (const char *string)
{
  return string ? strdup (string) : NULL;
}

void
csl_strfreevn (unsigned int n,
	       char       **str_p)
{
  unsigned int i;

  for (i = 0; i < n; i++)
    csl_free (str_p[i]);
  csl_free (str_p);
}
