/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __CSL_DEFS_H__
#define __CSL_DEFS_H__


#include <csl/cslconfig.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* --- compat defines --- */
#ifndef NULL
#define NULL ((void*) 0)
#endif
#ifndef TRUE
#define TRUE	(!FALSE)
#endif
#ifndef FALSE
#define FALSE	(0)
#endif
#ifndef MAX
#define MAX(a, b)	((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a, b)	((a) > (b) ? (b) : (a))
#endif
#ifndef	CLAMP
#define CLAMP(x, low, high)  (((x) > (high)) ? (high) : (((x) < (low)) ? (low) : (x)))
#endif
#define CSL_BREAKPOINT()   ((void)  raise (5 /* SIGTRAP */))


/* --- typedefs --- */
typedef int		          CslBool;
typedef int		          CslByte;



#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CSL_DEFS_H__ */
