#include "cslarts.h"
#include "soundserver.h"
#include "debug.h"
#include <stdio.h>

using namespace Arts;

/* obsolete:
void clientWaitBufferLevel(CSL::Adapter adapter, long id, long level)
{
	CSL::StreamStatus status;
		
	for(;;) {
		status = adapter.status(id);
		//printf("streambufferused = %d\n", status.streamBufferUsed);

		if(status.streamBufferUsed <= level) return;
		usleep(100000);
	}
}	*/

int main()
{
	Dispatcher dispatcher;
	SoundServer server = Reference("global:Arts_SoundServer");
	arts_return_val_if_fail(!server.isNull(),1);

	Object obj = server.createObject("CSL::Adapter");
	arts_return_val_if_fail(!obj.isNull(),1);

	CSL::Adapter adapter = DynamicCast(obj);
	arts_return_val_if_fail(!adapter.isNull(),1);

	long id = adapter.open("csltest", CSL::dirOutput);
	arts_return_val_if_fail(id > 0,1);

	CSL::StreamParams params(44100, 2, CSL::sf_s16_le);
	bool paramsOk = adapter.setParams(id, params);
	arts_return_val_if_fail(paramsOk,1);

	adapter.activate(id);

	char buffer[4096];
	long l;
	while((l = fread(buffer, 1, sizeof(buffer), stdin)) > 0)
	{
		vector<mcopbyte> data;
		data.resize(l);
		copy(buffer, buffer+l, data.begin());
			
		adapter.waitBufferLevel(id, 1024*128);
		adapter.write(id, data);
	}

	adapter.waitBufferLevel(id, 0);
	adapter.suspend(id);
	adapter.close(id);
	return 0;
}

// vim:ts=4:sts=4:sw=4
