
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesong.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesong.h>
#include <bse/bsepart.h>
#include <bse/bsetrack.h>
#include "bsemidireceiver.h"
#include "bseundostack.h"
#include "bseproject.h"
#include "gslcommon.h"
#include "gslengine.h"

#line 32 "bsesong.proc"


/* --- create-part --- */
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 34 "bsesong.proc"
 {
#line 36 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 40 "bsesong.proc"
}  }
static BseErrorType
#line 40 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 43 "bsesong.proc"
{
#line 44 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 49 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 53 "bsesong.proc"
  
  ustack = bse_item_undo_open (self, "create-part");
  child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_PART, NULL);
  bse_item_push_undo_proc (self, "remove-part", child);
  bse_item_undo_close (ustack);
  
#line 59 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 65 "bsesong.proc"
 {
#line 67 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 71 "bsesong.proc"
}  }
static BseErrorType
#line 71 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 74 "bsesong.proc"
{
#line 75 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 80 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 84 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 90 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 92 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-part", child);
#line 94 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 96 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- create-track --- */
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 103 "bsesong.proc"
 {
#line 105 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 109 "bsesong.proc"
}  }
static BseErrorType
#line 109 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 112 "bsesong.proc"
{
#line 113 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseItem *child = NULL;

#line 118 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 122 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "create-track");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
      bse_item_push_undo_proc (self, "remove-track", child);
      bse_item_undo_close (ustack);
    }

#line 133 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-track --- */
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 139 "bsesong.proc"
 {
#line 141 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 145 "bsesong.proc"
}  }
static BseErrorType
#line 145 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 148 "bsesong.proc"
{
#line 149 "bsesong.proc"
  
  BseSong *self  = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 154 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (child) ||
      BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 159 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 165 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 167 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-track", child);
#line 169 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 171 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- find-track-for-part --- */
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 178 "bsesong.proc"
 {
#line 180 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 186 "bsesong.proc"
}  }
static BseErrorType
#line 186 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 189 "bsesong.proc"
{
#line 190 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;

#line 197 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 202 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }
  if (!track)
    track = self->tracks_SL ? self->tracks_SL->data : NULL;

#line 217 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return BSE_ERROR_NONE;
}

/* --- synthesize-note --- */
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 223 "bsesong.proc"
 {
#line 225 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
#line 237 "bsesong.proc"
}  }
static BseErrorType
#line 237 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 240 "bsesong.proc"
{
#line 241 "bsesong.proc"
  
  BseSong *self      = bse_value_get_object (in_values++);
  BseTrack *track    = bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  
#line 249 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 254 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && self->midi_receiver_SL)
    {
      gfloat freq = BSE_KAMMER_FREQUENCY_f *
		    BSE_SEMITONE_FACTOR (note) *
		    BSE_FINE_TUNE_FACTOR (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + gsl_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (track->midi_channel_SL, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (track->midi_channel_SL, tstamp + duration, freq);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (self->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 273 "bsesong.proc"
 {
#line 275 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 278 "bsesong.proc"
}  }
static BseErrorType
#line 278 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 281 "bsesong.proc"
{
#line 282 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };

#line 287 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 291 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);

#line 294 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a new Part in a Song";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_part = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSong+create-part", 
    NULL,
    "/Methods/BseSong/General/Create Part",
    NULL,
    __enode_create_part__fill_strings,
  },
  0, create_part_setup, create_part_exec, 
};
static void
__enode_remove_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete a Part from a Song";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_part = {
  { (BseExportNode*) &__enode_create_part, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-part", 
    NULL,
    "/Methods/BseSong/General/Remove Part",
    NULL,
    __enode_remove_part__fill_strings,
  },
  0, remove_part_setup, remove_part_exec, 
};
static void
__enode_create_track__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a new Track for a Song";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_track = {
  { (BseExportNode*) &__enode_remove_part, BSE_EXPORT_NODE_PROC,
    "BseSong+create-track", 
    NULL,
    "/Methods/BseSong/General/Create Track",
    NULL,
    __enode_create_track__fill_strings,
  },
  0, create_track_setup, create_track_exec, 
};
static void
__enode_remove_track__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete a Track from a Song";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_track = {
  { (BseExportNode*) &__enode_create_track, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-track", 
    NULL,
    "/Methods/BseSong/General/Remove Track",
    NULL,
    __enode_remove_track__fill_strings,
  },
  0, remove_track_setup, remove_track_exec, 
};
static void
__enode_find_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = "Find a track suitable for playing notes of a given part.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_track_for_part = {
  { (BseExportNode*) &__enode_remove_track, BSE_EXPORT_NODE_PROC,
    "BseSong+find-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Track For Part",
    NULL,
    __enode_find_track_for_part__fill_strings,
  },
  0, find_track_for_part_setup, find_track_for_part_exec, 
};
static void
__enode_synthesize_note__fill_strings (BseExportStrings *es)
{
  es->blurb = "Synthesize a note on a song of an active project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_synthesize_note = {
  { (BseExportNode*) &__enode_find_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+synthesize-note", 
    NULL,
    "/Methods/BseSong/General/Synthesize Note",
    NULL,
    __enode_synthesize_note__fill_strings,
  },
  0, synthesize_note_setup, synthesize_note_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve song timing information at a specific tick.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_synthesize_note, BSE_EXPORT_NODE_PROC,
    "BseSong+get-timing", 
    NULL,
    "/Methods/BseSong/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
BseExportNode* bse__builtin_init_bsesong_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsesong_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/**
 ** Generated data ends here
 **/
