/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * This file is part of unity-chromium-extension
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QCoreApplication>
#include <QDebug>
#include "connection.h"

class Handler: public QObject
{
    Q_OBJECT

public:
    Handler(): QObject() {}

    bool openConnection();

public Q_SLOTS:
    void onMessageReceived(const QVariantMap &message);

private:
    UnityWebapps::Connection m_connection;
};

bool Handler::openConnection()
{
    QObject::connect(&m_connection,
                     SIGNAL(messageReceived(const QVariantMap &)),
                     this,
                     SLOT(onMessageReceived(const QVariantMap &)));
    return m_connection.open();
}

void Handler::onMessageReceived(const QVariantMap &message)
{
    // Generate a predictable reply
    QVariantMap reply;
    reply.insert("count", message.count());
    QStringList keys = message.uniqueKeys();
    reply.insert("keys", keys);
    m_connection.postMessage(reply);
}

int main(int argc, char **argv)
{
    QCoreApplication app(argc, argv);
    Handler handler;

    if (!handler.openConnection()) {
        qCritical() << "Connection::open() failed!";
        return EXIT_FAILURE;
    }

    return app.exec();
}

#include "connection-host.moc"
