//! Generated by `cargo codegen lint-definitions`, do not edit by hand.

#[derive(Clone)]
pub struct Lint {
    pub label: &'static str,
    pub description: &'static str,
}

pub struct LintGroup {
    pub lint: Lint,
    pub children: &'static [&'static str],
}

pub const DEFAULT_LINTS: &[Lint] = &[
    Lint {
        label: "absolute_paths_not_starting_with_crate",
        description: r##"fully qualified paths that start with a module name instead of `crate`, `self`, or an extern crate name"##,
    },
    Lint { label: "ambiguous_associated_items", description: r##"ambiguous associated items"## },
    Lint {
        label: "ambiguous_glob_imports",
        description: r##"detects certain glob imports that require reporting an ambiguity error"##,
    },
    Lint { label: "ambiguous_glob_reexports", description: r##"ambiguous glob re-exports"## },
    Lint {
        label: "ambiguous_wide_pointer_comparisons",
        description: r##"detects ambiguous wide pointer comparisons"##,
    },
    Lint { label: "anonymous_parameters", description: r##"detects anonymous parameters"## },
    Lint { label: "arithmetic_overflow", description: r##"arithmetic operation overflows"## },
    Lint {
        label: "array_into_iter",
        description: r##"detects calling `into_iter` on arrays in Rust 2015 and 2018"##,
    },
    Lint {
        label: "asm_sub_register",
        description: r##"using only a subset of a register for inline asm inputs"##,
    },
    Lint {
        label: "async_fn_in_trait",
        description: r##"use of `async fn` in definition of a publicly-reachable trait"##,
    },
    Lint { label: "bad_asm_style", description: r##"incorrect use of inline assembly"## },
    Lint {
        label: "bare_trait_objects",
        description: r##"suggest using `dyn Trait` for trait objects"##,
    },
    Lint {
        label: "bindings_with_variant_name",
        description: r##"detects pattern bindings with the same name as one of the matched variants"##,
    },
    Lint {
        label: "boxed_slice_into_iter",
        description: r##"detects calling `into_iter` on boxed slices in Rust 2015, 2018, and 2021"##,
    },
    Lint {
        label: "break_with_label_and_loop",
        description: r##"`break` expression with label and unlabeled loop as value expression"##,
    },
    Lint {
        label: "byte_slice_in_packed_struct_with_derive",
        description: r##"`[u8]` or `str` used in a packed struct with `derive`"##,
    },
    Lint {
        label: "cenum_impl_drop_cast",
        description: r##"a C-like enum implementing Drop is cast"##,
    },
    Lint {
        label: "clashing_extern_declarations",
        description: r##"detects when an extern fn has been declared with the same name but different types"##,
    },
    Lint {
        label: "coherence_leak_check",
        description: r##"distinct impls distinguished only by the leak-check code"##,
    },
    Lint {
        label: "conflicting_repr_hints",
        description: r##"conflicts between `#[repr(..)]` hints that were previously accepted and used in practice"##,
    },
    Lint {
        label: "confusable_idents",
        description: r##"detects visually confusable pairs between identifiers"##,
    },
    Lint {
        label: "const_eval_mutable_ptr_in_final_value",
        description: r##"detects a mutable pointer that has leaked into final value of a const expression"##,
    },
    Lint {
        label: "const_evaluatable_unchecked",
        description: r##"detects a generic constant is used in a type without a emitting a warning"##,
    },
    Lint {
        label: "const_item_mutation",
        description: r##"detects attempts to mutate a `const` item"##,
    },
    Lint { label: "dead_code", description: r##"detect unused, unexported items"## },
    Lint {
        label: "dependency_on_unit_never_type_fallback",
        description: r##"never type fallback affecting unsafe function calls"##,
    },
    Lint { label: "deprecated", description: r##"detects use of deprecated items"## },
    Lint {
        label: "deprecated_cfg_attr_crate_type_name",
        description: r##"detects usage of `#![cfg_attr(..., crate_type/crate_name = "...")]`"##,
    },
    Lint {
        label: "deprecated_in_future",
        description: r##"detects use of items that will be deprecated in a future version"##,
    },
    Lint {
        label: "deprecated_safe",
        description: r##"detects unsafe functions being used as safe functions"##,
    },
    Lint {
        label: "deprecated_where_clause_location",
        description: r##"deprecated where clause location"##,
    },
    Lint {
        label: "deref_into_dyn_supertrait",
        description: r##"`Deref` implementation usage with a supertrait trait object for output might be shadowed in the future"##,
    },
    Lint {
        label: "deref_nullptr",
        description: r##"detects when an null pointer is dereferenced"##,
    },
    Lint {
        label: "drop_bounds",
        description: r##"bounds of the form `T: Drop` are most likely incorrect"##,
    },
    Lint {
        label: "dropping_copy_types",
        description: r##"calls to `std::mem::drop` with a value that implements Copy"##,
    },
    Lint {
        label: "dropping_references",
        description: r##"calls to `std::mem::drop` with a reference instead of an owned value"##,
    },
    Lint { label: "duplicate_macro_attributes", description: r##"duplicated attribute"## },
    Lint {
        label: "dyn_drop",
        description: r##"trait objects of the form `dyn Drop` are useless"##,
    },
    Lint {
        label: "elided_lifetimes_in_associated_constant",
        description: r##"elided lifetimes cannot be used in associated constants in impls"##,
    },
    Lint {
        label: "elided_lifetimes_in_paths",
        description: r##"hidden lifetime parameters in types are deprecated"##,
    },
    Lint {
        label: "ellipsis_inclusive_range_patterns",
        description: r##"`...` range patterns are deprecated"##,
    },
    Lint {
        label: "enum_intrinsics_non_enums",
        description: r##"detects calls to `core::mem::discriminant` and `core::mem::variant_count` with non-enum types"##,
    },
    Lint {
        label: "explicit_outlives_requirements",
        description: r##"outlives requirements can be inferred"##,
    },
    Lint {
        label: "exported_private_dependencies",
        description: r##"public interface leaks type from a private dependency"##,
    },
    Lint {
        label: "ffi_unwind_calls",
        description: r##"call to foreign functions or function pointers with FFI-unwind ABI"##,
    },
    Lint {
        label: "for_loops_over_fallibles",
        description: r##"for-looping over an `Option` or a `Result`, which is more clearly expressed as an `if let`"##,
    },
    Lint { label: "forbidden_lint_groups", description: r##"applying forbid to lint-groups"## },
    Lint {
        label: "forgetting_copy_types",
        description: r##"calls to `std::mem::forget` with a value that implements Copy"##,
    },
    Lint {
        label: "forgetting_references",
        description: r##"calls to `std::mem::forget` with a reference instead of an owned value"##,
    },
    Lint {
        label: "function_item_references",
        description: r##"suggest casting to a function pointer when attempting to take references to function items"##,
    },
    Lint {
        label: "future_incompatible",
        description: r##"lint group for: deref-into-dyn-supertrait, ambiguous-associated-items, ambiguous-glob-imports, byte-slice-in-packed-struct-with-derive, cenum-impl-drop-cast, coherence-leak-check, conflicting-repr-hints, const-eval-mutable-ptr-in-final-value, const-evaluatable-unchecked, dependency-on-unit-never-type-fallback, deprecated-cfg-attr-crate-type-name, elided-lifetimes-in-associated-constant, forbidden-lint-groups, ill-formed-attribute-input, invalid-type-param-default, late-bound-lifetime-arguments, legacy-derive-helpers, macro-expanded-macro-exports-accessed-by-absolute-paths, missing-fragment-specifier, never-type-fallback-flowing-into-unsafe, order-dependent-trait-objects, patterns-in-fns-without-body, proc-macro-derive-resolution-fallback, pub-use-of-private-extern-crate, repr-transparent-external-private-fields, self-constructor-from-outer-item, semicolon-in-expressions-from-macros, soft-unstable, uncovered-param-in-projection, uninhabited-static, unstable-name-collisions, unstable-syntax-pre-expansion, unsupported-calling-conventions, wasm-c-abi, writes-through-immutable-pointer"##,
    },
    Lint {
        label: "fuzzy_provenance_casts",
        description: r##"a fuzzy integer to pointer cast is used"##,
    },
    Lint {
        label: "hidden_glob_reexports",
        description: r##"name introduced by a private item shadows a name introduced by a public glob re-export"##,
    },
    Lint {
        label: "ill_formed_attribute_input",
        description: r##"ill-formed attribute inputs that were previously accepted and used in practice"##,
    },
    Lint {
        label: "impl_trait_overcaptures",
        description: r##"`impl Trait` will capture more lifetimes than possibly intended in edition 2024"##,
    },
    Lint {
        label: "impl_trait_redundant_captures",
        description: r##"redundant precise-capturing `use<...>` syntax on an `impl Trait`"##,
    },
    Lint {
        label: "improper_ctypes",
        description: r##"proper use of libc types in foreign modules"##,
    },
    Lint {
        label: "improper_ctypes_definitions",
        description: r##"proper use of libc types in foreign item definitions"##,
    },
    Lint {
        label: "incomplete_features",
        description: r##"incomplete features that may function improperly in some or all cases"##,
    },
    Lint { label: "incomplete_include", description: r##"trailing content in included file"## },
    Lint {
        label: "ineffective_unstable_trait_impl",
        description: r##"detects `#[unstable]` on stable trait implementations for stable types"##,
    },
    Lint {
        label: "inline_no_sanitize",
        description: r##"detects incompatible use of `#[inline(always)]` and `#[no_sanitize(...)]`"##,
    },
    Lint {
        label: "internal_features",
        description: r##"internal features are not supposed to be used"##,
    },
    Lint {
        label: "invalid_atomic_ordering",
        description: r##"usage of invalid atomic ordering in atomic operations and memory fences"##,
    },
    Lint {
        label: "invalid_doc_attributes",
        description: r##"detects invalid `#[doc(...)]` attributes"##,
    },
    Lint {
        label: "invalid_from_utf8",
        description: r##"using a non UTF-8 literal in `std::str::from_utf8`"##,
    },
    Lint {
        label: "invalid_from_utf8_unchecked",
        description: r##"using a non UTF-8 literal in `std::str::from_utf8_unchecked`"##,
    },
    Lint {
        label: "invalid_macro_export_arguments",
        description: r##""invalid_parameter" isn't a valid argument for `#[macro_export]`"##,
    },
    Lint {
        label: "invalid_nan_comparisons",
        description: r##"detects invalid floating point NaN comparisons"##,
    },
    Lint {
        label: "invalid_reference_casting",
        description: r##"casts of `&T` to `&mut T` without interior mutability"##,
    },
    Lint {
        label: "invalid_type_param_default",
        description: r##"type parameter default erroneously allowed in invalid location"##,
    },
    Lint {
        label: "invalid_value",
        description: r##"an invalid value is being created (such as a null reference)"##,
    },
    Lint {
        label: "irrefutable_let_patterns",
        description: r##"detects irrefutable patterns in `if let` and `while let` statements"##,
    },
    Lint {
        label: "keyword_idents",
        description: r##"lint group for: keyword-idents-2018, keyword-idents-2024"##,
    },
    Lint {
        label: "keyword_idents_2018",
        description: r##"detects edition keywords being used as an identifier"##,
    },
    Lint {
        label: "keyword_idents_2024",
        description: r##"detects edition keywords being used as an identifier"##,
    },
    Lint { label: "large_assignments", description: r##"detects large moves or copies"## },
    Lint {
        label: "late_bound_lifetime_arguments",
        description: r##"detects generic lifetime arguments in path segments with late bound lifetime parameters"##,
    },
    Lint {
        label: "legacy_derive_helpers",
        description: r##"detects derive helper attributes that are used before they are introduced"##,
    },
    Lint {
        label: "let_underscore",
        description: r##"lint group for: let-underscore-drop, let-underscore-lock"##,
    },
    Lint {
        label: "let_underscore_drop",
        description: r##"non-binding let on a type that implements `Drop`"##,
    },
    Lint {
        label: "let_underscore_lock",
        description: r##"non-binding let on a synchronization lock"##,
    },
    Lint {
        label: "long_running_const_eval",
        description: r##"detects long const eval operations"##,
    },
    Lint {
        label: "lossy_provenance_casts",
        description: r##"a lossy pointer to integer cast is used"##,
    },
    Lint {
        label: "macro_expanded_macro_exports_accessed_by_absolute_paths",
        description: r##"macro-expanded `macro_export` macros from the current crate cannot be referred to by absolute paths"##,
    },
    Lint {
        label: "macro_use_extern_crate",
        description: r##"the `#[macro_use]` attribute is now deprecated in favor of using macros via the module system"##,
    },
    Lint {
        label: "map_unit_fn",
        description: r##"`Iterator::map` call that discard the iterator's values"##,
    },
    Lint {
        label: "meta_variable_misuse",
        description: r##"possible meta-variable misuse at macro definition"##,
    },
    Lint { label: "missing_abi", description: r##"No declared ABI for extern declaration"## },
    Lint {
        label: "missing_copy_implementations",
        description: r##"detects potentially-forgotten implementations of `Copy`"##,
    },
    Lint {
        label: "missing_debug_implementations",
        description: r##"detects missing implementations of Debug"##,
    },
    Lint {
        label: "missing_docs",
        description: r##"detects missing documentation for public members"##,
    },
    Lint {
        label: "missing_fragment_specifier",
        description: r##"detects missing fragment specifiers in unused `macro_rules!` patterns"##,
    },
    Lint {
        label: "missing_unsafe_on_extern",
        description: r##"detects missing unsafe keyword on extern declarations"##,
    },
    Lint {
        label: "mixed_script_confusables",
        description: r##"detects Unicode scripts whose mixed script confusables codepoints are solely used"##,
    },
    Lint {
        label: "multiple_supertrait_upcastable",
        description: r##"detect when an object-safe trait has multiple supertraits"##,
    },
    Lint {
        label: "must_not_suspend",
        description: r##"use of a `#[must_not_suspend]` value across a yield point"##,
    },
    Lint {
        label: "mutable_transmutes",
        description: r##"transmuting &T to &mut T is undefined behavior, even if the reference is unused"##,
    },
    Lint {
        label: "named_arguments_used_positionally",
        description: r##"named arguments in format used positionally"##,
    },
    Lint { label: "named_asm_labels", description: r##"named labels in inline assembly"## },
    Lint {
        label: "never_type_fallback_flowing_into_unsafe",
        description: r##"never type fallback affecting unsafe function calls"##,
    },
    Lint {
        label: "no_mangle_const_items",
        description: r##"const items will not have their symbols exported"##,
    },
    Lint { label: "no_mangle_generic_items", description: r##"generic items must be mangled"## },
    Lint { label: "non_ascii_idents", description: r##"detects non-ASCII identifiers"## },
    Lint {
        label: "non_camel_case_types",
        description: r##"types, variants, traits and type parameters should have camel case names"##,
    },
    Lint {
        label: "non_contiguous_range_endpoints",
        description: r##"detects off-by-one errors with exclusive range patterns"##,
    },
    Lint {
        label: "non_exhaustive_omitted_patterns",
        description: r##"detect when patterns of types marked `non_exhaustive` are missed"##,
    },
    Lint {
        label: "non_fmt_panics",
        description: r##"detect single-argument panic!() invocations in which the argument is not a format string"##,
    },
    Lint { label: "non_local_definitions", description: r##"checks for non-local definitions"## },
    Lint {
        label: "non_shorthand_field_patterns",
        description: r##"using `Struct { x: x }` instead of `Struct { x }` in a pattern"##,
    },
    Lint {
        label: "non_snake_case",
        description: r##"variables, methods, functions, lifetime parameters and modules should have snake case names"##,
    },
    Lint {
        label: "non_upper_case_globals",
        description: r##"static constants should have uppercase identifiers"##,
    },
    Lint {
        label: "nonstandard_style",
        description: r##"lint group for: non-camel-case-types, non-snake-case, non-upper-case-globals"##,
    },
    Lint {
        label: "noop_method_call",
        description: r##"detects the use of well-known noop methods"##,
    },
    Lint {
        label: "opaque_hidden_inferred_bound",
        description: r##"detects the use of nested `impl Trait` types in associated type bounds that are not general enough"##,
    },
    Lint {
        label: "order_dependent_trait_objects",
        description: r##"trait-object types were treated as different depending on marker-trait order"##,
    },
    Lint { label: "overflowing_literals", description: r##"literal out of range for its type"## },
    Lint {
        label: "overlapping_range_endpoints",
        description: r##"detects range patterns with overlapping endpoints"##,
    },
    Lint { label: "path_statements", description: r##"path statements with no effect"## },
    Lint {
        label: "patterns_in_fns_without_body",
        description: r##"patterns in functions without body were erroneously allowed"##,
    },
    Lint {
        label: "private_bounds",
        description: r##"private type in secondary interface of an item"##,
    },
    Lint {
        label: "private_interfaces",
        description: r##"private type in primary interface of an item"##,
    },
    Lint {
        label: "proc_macro_derive_resolution_fallback",
        description: r##"detects proc macro derives using inaccessible names from parent modules"##,
    },
    Lint {
        label: "pub_use_of_private_extern_crate",
        description: r##"detect public re-exports of private extern crates"##,
    },
    Lint {
        label: "redundant_lifetimes",
        description: r##"detects lifetime parameters that are redundant because they are equal to some other named lifetime"##,
    },
    Lint {
        label: "redundant_semicolons",
        description: r##"detects unnecessary trailing semicolons"##,
    },
    Lint {
        label: "refining_impl_trait",
        description: r##"lint group for: refining-impl-trait-reachable, refining-impl-trait-internal"##,
    },
    Lint {
        label: "refining_impl_trait_internal",
        description: r##"impl trait in impl method signature does not match trait method signature"##,
    },
    Lint {
        label: "refining_impl_trait_reachable",
        description: r##"impl trait in impl method signature does not match trait method signature"##,
    },
    Lint {
        label: "renamed_and_removed_lints",
        description: r##"lints that have been renamed or removed"##,
    },
    Lint {
        label: "repr_transparent_external_private_fields",
        description: r##"transparent type contains an external ZST that is marked #[non_exhaustive] or contains private fields"##,
    },
    Lint {
        label: "rust_2018_compatibility",
        description: r##"lint group for: keyword-idents-2018, anonymous-parameters, absolute-paths-not-starting-with-crate, tyvar-behind-raw-pointer"##,
    },
    Lint {
        label: "rust_2018_idioms",
        description: r##"lint group for: bare-trait-objects, unused-extern-crates, ellipsis-inclusive-range-patterns, elided-lifetimes-in-paths, explicit-outlives-requirements"##,
    },
    Lint {
        label: "rust_2021_compatibility",
        description: r##"lint group for: ellipsis-inclusive-range-patterns, bare-trait-objects, rust-2021-incompatible-closure-captures, rust-2021-incompatible-or-patterns, rust-2021-prefixes-incompatible-syntax, rust-2021-prelude-collisions, array-into-iter, non-fmt-panics"##,
    },
    Lint {
        label: "rust_2021_incompatible_closure_captures",
        description: r##"detects closures affected by Rust 2021 changes"##,
    },
    Lint {
        label: "rust_2021_incompatible_or_patterns",
        description: r##"detects usage of old versions of or-patterns"##,
    },
    Lint {
        label: "rust_2021_prefixes_incompatible_syntax",
        description: r##"identifiers that will be parsed as a prefix in Rust 2021"##,
    },
    Lint {
        label: "rust_2021_prelude_collisions",
        description: r##"detects the usage of trait methods which are ambiguous with traits added to the prelude in future editions"##,
    },
    Lint {
        label: "rust_2024_compatibility",
        description: r##"lint group for: keyword-idents-2024, deprecated-safe, missing-unsafe-on-extern, static-mut-refs, unsafe-attr-outside-unsafe, unsafe-op-in-unsafe-fn, boxed-slice-into-iter"##,
    },
    Lint {
        label: "rust_2024_incompatible_pat",
        description: r##"detects patterns whose meaning will change in Rust 2024"##,
    },
    Lint {
        label: "self_constructor_from_outer_item",
        description: r##"detect unsupported use of `Self` from outer item"##,
    },
    Lint {
        label: "semicolon_in_expressions_from_macros",
        description: r##"trailing semicolon in macro body used as expression"##,
    },
    Lint {
        label: "single_use_lifetimes",
        description: r##"detects lifetime parameters that are only used once"##,
    },
    Lint {
        label: "soft_unstable",
        description: r##"a feature gate that doesn't break dependent crates"##,
    },
    Lint {
        label: "special_module_name",
        description: r##"module declarations for files with a special meaning"##,
    },
    Lint {
        label: "stable_features",
        description: r##"stable features found in `#[feature]` directive"##,
    },
    Lint {
        label: "static_mut_refs",
        description: r##"shared references or mutable references of mutable static is discouraged"##,
    },
    Lint {
        label: "suspicious_double_ref_op",
        description: r##"suspicious call of trait method on `&&T`"##,
    },
    Lint {
        label: "temporary_cstring_as_ptr",
        description: r##"detects getting the inner pointer of a temporary `CString`"##,
    },
    Lint {
        label: "test_unstable_lint",
        description: r##"this unstable lint is only for testing"##,
    },
    Lint {
        label: "text_direction_codepoint_in_comment",
        description: r##"invisible directionality-changing codepoints in comment"##,
    },
    Lint {
        label: "text_direction_codepoint_in_literal",
        description: r##"detect special Unicode codepoints that affect the visual representation of text on screen, changing the direction in which text flows"##,
    },
    Lint {
        label: "trivial_bounds",
        description: r##"these bounds don't depend on an type parameters"##,
    },
    Lint {
        label: "trivial_casts",
        description: r##"detects trivial casts which could be removed"##,
    },
    Lint {
        label: "trivial_numeric_casts",
        description: r##"detects trivial casts of numeric types which could be removed"##,
    },
    Lint {
        label: "type_alias_bounds",
        description: r##"bounds in type aliases are not enforced"##,
    },
    Lint {
        label: "tyvar_behind_raw_pointer",
        description: r##"raw pointer to an inference variable"##,
    },
    Lint {
        label: "uncommon_codepoints",
        description: r##"detects uncommon Unicode codepoints in identifiers"##,
    },
    Lint {
        label: "unconditional_panic",
        description: r##"operation will cause a panic at runtime"##,
    },
    Lint {
        label: "unconditional_recursion",
        description: r##"functions that cannot return without calling themselves"##,
    },
    Lint {
        label: "uncovered_param_in_projection",
        description: r##"impl contains type parameters that are not covered"##,
    },
    Lint {
        label: "undefined_naked_function_abi",
        description: r##"undefined naked function ABI"##,
    },
    Lint {
        label: "undropped_manually_drops",
        description: r##"calls to `std::mem::drop` with `std::mem::ManuallyDrop` instead of it's inner value"##,
    },
    Lint {
        label: "unexpected_cfgs",
        description: r##"detects unexpected names and values in `#[cfg]` conditions"##,
    },
    Lint {
        label: "unfulfilled_lint_expectations",
        description: r##"unfulfilled lint expectation"##,
    },
    Lint {
        label: "ungated_async_fn_track_caller",
        description: r##"enabling track_caller on an async fn is a no-op unless the async_fn_track_caller feature is enabled"##,
    },
    Lint { label: "uninhabited_static", description: r##"uninhabited static"## },
    Lint {
        label: "unit_bindings",
        description: r##"binding is useless because it has the unit `()` type"##,
    },
    Lint {
        label: "unknown_crate_types",
        description: r##"unknown crate type found in `#[crate_type]` directive"##,
    },
    Lint { label: "unknown_lints", description: r##"unrecognized lint attribute"## },
    Lint {
        label: "unknown_or_malformed_diagnostic_attributes",
        description: r##"unrecognized or malformed diagnostic attribute"##,
    },
    Lint {
        label: "unnameable_test_items",
        description: r##"detects an item that cannot be named being marked as `#[test_case]`"##,
    },
    Lint {
        label: "unnameable_types",
        description: r##"effective visibility of a type is larger than the area in which it can be named"##,
    },
    Lint { label: "unreachable_code", description: r##"detects unreachable code paths"## },
    Lint { label: "unreachable_patterns", description: r##"detects unreachable patterns"## },
    Lint {
        label: "unreachable_pub",
        description: r##"`pub` items not reachable from crate root"##,
    },
    Lint {
        label: "unsafe_attr_outside_unsafe",
        description: r##"detects unsafe attributes outside of unsafe"##,
    },
    Lint {
        label: "unsafe_code",
        description: r##"usage of `unsafe` code and other potentially unsound constructs"##,
    },
    Lint {
        label: "unsafe_op_in_unsafe_fn",
        description: r##"unsafe operations in unsafe functions without an explicit unsafe block are deprecated"##,
    },
    Lint { label: "unstable_features", description: r##"enabling unstable features"## },
    Lint {
        label: "unstable_name_collisions",
        description: r##"detects name collision with an existing but unstable method"##,
    },
    Lint {
        label: "unstable_syntax_pre_expansion",
        description: r##"unstable syntax can change at any point in the future, causing a hard error!"##,
    },
    Lint {
        label: "unsupported_calling_conventions",
        description: r##"use of unsupported calling convention"##,
    },
    Lint {
        label: "unused",
        description: r##"lint group for: unused-imports, unused-variables, unused-assignments, dead-code, unused-mut, unreachable-code, unreachable-patterns, unused-must-use, unused-unsafe, path-statements, unused-attributes, unused-macros, unused-macro-rules, unused-allocation, unused-doc-comments, unused-extern-crates, unused-features, unused-labels, unused-parens, unused-braces, redundant-semicolons, map-unit-fn"##,
    },
    Lint {
        label: "unused_allocation",
        description: r##"detects unnecessary allocations that can be eliminated"##,
    },
    Lint {
        label: "unused_assignments",
        description: r##"detect assignments that will never be read"##,
    },
    Lint {
        label: "unused_associated_type_bounds",
        description: r##"detects unused `Foo = Bar` bounds in `dyn Trait<Foo = Bar>`"##,
    },
    Lint {
        label: "unused_attributes",
        description: r##"detects attributes that were not used by the compiler"##,
    },
    Lint { label: "unused_braces", description: r##"unnecessary braces around an expression"## },
    Lint {
        label: "unused_comparisons",
        description: r##"comparisons made useless by limits of the types involved"##,
    },
    Lint {
        label: "unused_crate_dependencies",
        description: r##"crate dependencies that are never used"##,
    },
    Lint {
        label: "unused_doc_comments",
        description: r##"detects doc comments that aren't used by rustdoc"##,
    },
    Lint { label: "unused_extern_crates", description: r##"extern crates that are never used"## },
    Lint {
        label: "unused_features",
        description: r##"unused features found in crate-level `#[feature]` directives"##,
    },
    Lint {
        label: "unused_import_braces",
        description: r##"unnecessary braces around an imported item"##,
    },
    Lint { label: "unused_imports", description: r##"imports that are never used"## },
    Lint { label: "unused_labels", description: r##"detects labels that are never used"## },
    Lint {
        label: "unused_lifetimes",
        description: r##"detects lifetime parameters that are never used"##,
    },
    Lint {
        label: "unused_macro_rules",
        description: r##"detects macro rules that were not used"##,
    },
    Lint { label: "unused_macros", description: r##"detects macros that were not used"## },
    Lint {
        label: "unused_must_use",
        description: r##"unused result of a type flagged as `#[must_use]`"##,
    },
    Lint {
        label: "unused_mut",
        description: r##"detect mut variables which don't need to be mutable"##,
    },
    Lint {
        label: "unused_parens",
        description: r##"`if`, `match`, `while` and `return` do not need parentheses"##,
    },
    Lint {
        label: "unused_qualifications",
        description: r##"detects unnecessarily qualified names"##,
    },
    Lint {
        label: "unused_results",
        description: r##"unused result of an expression in a statement"##,
    },
    Lint { label: "unused_unsafe", description: r##"unnecessary use of an `unsafe` block"## },
    Lint {
        label: "unused_variables",
        description: r##"detect variables which are not used in any way"##,
    },
    Lint {
        label: "useless_deprecated",
        description: r##"detects deprecation attributes with no effect"##,
    },
    Lint {
        label: "useless_ptr_null_checks",
        description: r##"useless checking of non-null-typed pointer"##,
    },
    Lint {
        label: "variant_size_differences",
        description: r##"detects enums with widely varying variant sizes"##,
    },
    Lint {
        label: "warnings",
        description: r##"mass-change the level for lints which produce warnings"##,
    },
    Lint {
        label: "warnings",
        description: r##"lint group for: all lints that are set to issue warnings"##,
    },
    Lint {
        label: "wasm_c_abi",
        description: r##"detects dependencies that are incompatible with the Wasm C ABI"##,
    },
    Lint {
        label: "while_true",
        description: r##"suggest using `loop { }` instead of `while true { }`"##,
    },
    Lint {
        label: "writes_through_immutable_pointer",
        description: r##"shared references are immutable, and pointers derived from them must not be written to"##,
    },
];

pub const DEFAULT_LINT_GROUPS: &[LintGroup] = &[
    LintGroup {
        lint: Lint {
            label: "future_incompatible",
            description: r##"lint group for: deref-into-dyn-supertrait, ambiguous-associated-items, ambiguous-glob-imports, byte-slice-in-packed-struct-with-derive, cenum-impl-drop-cast, coherence-leak-check, conflicting-repr-hints, const-eval-mutable-ptr-in-final-value, const-evaluatable-unchecked, dependency-on-unit-never-type-fallback, deprecated-cfg-attr-crate-type-name, elided-lifetimes-in-associated-constant, forbidden-lint-groups, ill-formed-attribute-input, invalid-type-param-default, late-bound-lifetime-arguments, legacy-derive-helpers, macro-expanded-macro-exports-accessed-by-absolute-paths, missing-fragment-specifier, never-type-fallback-flowing-into-unsafe, order-dependent-trait-objects, patterns-in-fns-without-body, proc-macro-derive-resolution-fallback, pub-use-of-private-extern-crate, repr-transparent-external-private-fields, self-constructor-from-outer-item, semicolon-in-expressions-from-macros, soft-unstable, uncovered-param-in-projection, uninhabited-static, unstable-name-collisions, unstable-syntax-pre-expansion, unsupported-calling-conventions, wasm-c-abi, writes-through-immutable-pointer"##,
        },
        children: &[
            "deref_into_dyn_supertrait",
            "ambiguous_associated_items",
            "ambiguous_glob_imports",
            "byte_slice_in_packed_struct_with_derive",
            "cenum_impl_drop_cast",
            "coherence_leak_check",
            "conflicting_repr_hints",
            "const_eval_mutable_ptr_in_final_value",
            "const_evaluatable_unchecked",
            "dependency_on_unit_never_type_fallback",
            "deprecated_cfg_attr_crate_type_name",
            "elided_lifetimes_in_associated_constant",
            "forbidden_lint_groups",
            "ill_formed_attribute_input",
            "invalid_type_param_default",
            "late_bound_lifetime_arguments",
            "legacy_derive_helpers",
            "macro_expanded_macro_exports_accessed_by_absolute_paths",
            "missing_fragment_specifier",
            "never_type_fallback_flowing_into_unsafe",
            "order_dependent_trait_objects",
            "patterns_in_fns_without_body",
            "proc_macro_derive_resolution_fallback",
            "pub_use_of_private_extern_crate",
            "repr_transparent_external_private_fields",
            "self_constructor_from_outer_item",
            "semicolon_in_expressions_from_macros",
            "soft_unstable",
            "uncovered_param_in_projection",
            "uninhabited_static",
            "unstable_name_collisions",
            "unstable_syntax_pre_expansion",
            "unsupported_calling_conventions",
            "wasm_c_abi",
            "writes_through_immutable_pointer",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "keyword_idents",
            description: r##"lint group for: keyword-idents-2018, keyword-idents-2024"##,
        },
        children: &["keyword_idents_2018", "keyword_idents_2024"],
    },
    LintGroup {
        lint: Lint {
            label: "let_underscore",
            description: r##"lint group for: let-underscore-drop, let-underscore-lock"##,
        },
        children: &["let_underscore_drop", "let_underscore_lock"],
    },
    LintGroup {
        lint: Lint {
            label: "nonstandard_style",
            description: r##"lint group for: non-camel-case-types, non-snake-case, non-upper-case-globals"##,
        },
        children: &["non_camel_case_types", "non_snake_case", "non_upper_case_globals"],
    },
    LintGroup {
        lint: Lint {
            label: "refining_impl_trait",
            description: r##"lint group for: refining-impl-trait-reachable, refining-impl-trait-internal"##,
        },
        children: &["refining_impl_trait_reachable", "refining_impl_trait_internal"],
    },
    LintGroup {
        lint: Lint {
            label: "rust_2018_compatibility",
            description: r##"lint group for: keyword-idents-2018, anonymous-parameters, absolute-paths-not-starting-with-crate, tyvar-behind-raw-pointer"##,
        },
        children: &[
            "keyword_idents_2018",
            "anonymous_parameters",
            "absolute_paths_not_starting_with_crate",
            "tyvar_behind_raw_pointer",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "rust_2018_idioms",
            description: r##"lint group for: bare-trait-objects, unused-extern-crates, ellipsis-inclusive-range-patterns, elided-lifetimes-in-paths, explicit-outlives-requirements"##,
        },
        children: &[
            "bare_trait_objects",
            "unused_extern_crates",
            "ellipsis_inclusive_range_patterns",
            "elided_lifetimes_in_paths",
            "explicit_outlives_requirements",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "rust_2021_compatibility",
            description: r##"lint group for: ellipsis-inclusive-range-patterns, bare-trait-objects, rust-2021-incompatible-closure-captures, rust-2021-incompatible-or-patterns, rust-2021-prefixes-incompatible-syntax, rust-2021-prelude-collisions, array-into-iter, non-fmt-panics"##,
        },
        children: &[
            "ellipsis_inclusive_range_patterns",
            "bare_trait_objects",
            "rust_2021_incompatible_closure_captures",
            "rust_2021_incompatible_or_patterns",
            "rust_2021_prefixes_incompatible_syntax",
            "rust_2021_prelude_collisions",
            "array_into_iter",
            "non_fmt_panics",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "rust_2024_compatibility",
            description: r##"lint group for: keyword-idents-2024, deprecated-safe, missing-unsafe-on-extern, static-mut-refs, unsafe-attr-outside-unsafe, unsafe-op-in-unsafe-fn, boxed-slice-into-iter"##,
        },
        children: &[
            "keyword_idents_2024",
            "deprecated_safe",
            "missing_unsafe_on_extern",
            "static_mut_refs",
            "unsafe_attr_outside_unsafe",
            "unsafe_op_in_unsafe_fn",
            "boxed_slice_into_iter",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "unused",
            description: r##"lint group for: unused-imports, unused-variables, unused-assignments, dead-code, unused-mut, unreachable-code, unreachable-patterns, unused-must-use, unused-unsafe, path-statements, unused-attributes, unused-macros, unused-macro-rules, unused-allocation, unused-doc-comments, unused-extern-crates, unused-features, unused-labels, unused-parens, unused-braces, redundant-semicolons, map-unit-fn"##,
        },
        children: &[
            "unused_imports",
            "unused_variables",
            "unused_assignments",
            "dead_code",
            "unused_mut",
            "unreachable_code",
            "unreachable_patterns",
            "unused_must_use",
            "unused_unsafe",
            "path_statements",
            "unused_attributes",
            "unused_macros",
            "unused_macro_rules",
            "unused_allocation",
            "unused_doc_comments",
            "unused_extern_crates",
            "unused_features",
            "unused_labels",
            "unused_parens",
            "unused_braces",
            "redundant_semicolons",
            "map_unit_fn",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "warnings",
            description: r##"lint group for: all lints that are set to issue warnings"##,
        },
        children: &[],
    },
];

pub const RUSTDOC_LINTS: &[Lint] = &[
    Lint {
        label: "rustdoc::all",
        description: r##"lint group for: rustdoc::broken-intra-doc-links, rustdoc::private-intra-doc-links, rustdoc::private-doc-tests, rustdoc::invalid-codeblock-attributes, rustdoc::invalid-rust-codeblocks, rustdoc::invalid-html-tags, rustdoc::bare-urls, rustdoc::missing-crate-level-docs, rustdoc::unescaped-backticks, rustdoc::redundant-explicit-links"##,
    },
    Lint { label: "rustdoc::bare_urls", description: r##"detects URLs that are not hyperlinks"## },
    Lint {
        label: "rustdoc::broken_intra_doc_links",
        description: r##"failures in resolving intra-doc link targets"##,
    },
    Lint {
        label: "rustdoc::invalid_codeblock_attributes",
        description: r##"codeblock attribute looks a lot like a known one"##,
    },
    Lint {
        label: "rustdoc::invalid_html_tags",
        description: r##"detects invalid HTML tags in doc comments"##,
    },
    Lint {
        label: "rustdoc::invalid_rust_codeblocks",
        description: r##"codeblock could not be parsed as valid Rust or is empty"##,
    },
    Lint {
        label: "rustdoc::missing_crate_level_docs",
        description: r##"detects crates with no crate-level documentation"##,
    },
    Lint {
        label: "rustdoc::missing_doc_code_examples",
        description: r##"detects publicly-exported items without code samples in their documentation"##,
    },
    Lint {
        label: "rustdoc::private_doc_tests",
        description: r##"detects code samples in docs of private items not documented by rustdoc"##,
    },
    Lint {
        label: "rustdoc::private_intra_doc_links",
        description: r##"linking from a public item to a private one"##,
    },
    Lint {
        label: "rustdoc::redundant_explicit_links",
        description: r##"detects redundant explicit links in doc comments"##,
    },
    Lint {
        label: "rustdoc::unescaped_backticks",
        description: r##"detects unescaped backticks in doc comments"##,
    },
];

pub const RUSTDOC_LINT_GROUPS: &[LintGroup] = &[LintGroup {
    lint: Lint {
        label: "rustdoc::all",
        description: r##"lint group for: rustdoc::broken-intra-doc-links, rustdoc::private-intra-doc-links, rustdoc::private-doc-tests, rustdoc::invalid-codeblock-attributes, rustdoc::invalid-rust-codeblocks, rustdoc::invalid-html-tags, rustdoc::bare-urls, rustdoc::missing-crate-level-docs, rustdoc::unescaped-backticks, rustdoc::redundant-explicit-links"##,
    },
    children: &[
        "rustdoc::broken_intra_doc_links",
        "rustdoc::private_intra_doc_links",
        "rustdoc::private_doc_tests",
        "rustdoc::invalid_codeblock_attributes",
        "rustdoc::invalid_rust_codeblocks",
        "rustdoc::invalid_html_tags",
        "rustdoc::bare_urls",
        "rustdoc::missing_crate_level_docs",
        "rustdoc::unescaped_backticks",
        "rustdoc::redundant_explicit_links",
    ],
}];

pub const FEATURES: &[Lint] = &[
    Lint {
        label: "aarch64_ver_target_feature",
        description: r##"# `aarch64_ver_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "abi_avr_interrupt",
        description: r##"# `abi_avr_interrupt`

The tracking issue for this feature is: [#69664]

[#69664]: https://github.com/rust-lang/rust/issues/69664

------------------------
"##,
    },
    Lint {
        label: "abi_c_cmse_nonsecure_call",
        description: r##"# `abi_c_cmse_nonsecure_call`

The tracking issue for this feature is: [#81391]

[#81391]: https://github.com/rust-lang/rust/issues/81391

------------------------

The [TrustZone-M
feature](https://developer.arm.com/documentation/100690/latest/) is available
for targets with the Armv8-M architecture profile (`thumbv8m` in their target
name).
LLVM, the Rust compiler and the linker are providing
[support](https://developer.arm.com/documentation/ecm0359818/latest/) for the
TrustZone-M feature.

One of the things provided, with this unstable feature, is the
`C-cmse-nonsecure-call` function ABI. This ABI is used on function pointers to
non-secure code to mark a non-secure function call (see [section
5.5](https://developer.arm.com/documentation/ecm0359818/latest/) for details).

With this ABI, the compiler will do the following to perform the call:
* save registers needed after the call to Secure memory
* clear all registers that might contain confidential information
* clear the Least Significant Bit of the function address
* branches using the BLXNS instruction

To avoid using the non-secure stack, the compiler will constrain the number and
type of parameters/return value.

The `extern "C-cmse-nonsecure-call"` ABI is otherwise equivalent to the
`extern "C"` ABI.

<!-- NOTE(ignore) this example is specific to thumbv8m targets -->

``` rust,ignore
#![no_std]
#![feature(abi_c_cmse_nonsecure_call)]

#[no_mangle]
pub fn call_nonsecure_function(addr: usize) -> u32 {
    let non_secure_function =
        unsafe { core::mem::transmute::<usize, extern "C-cmse-nonsecure-call" fn() -> u32>(addr) };
    non_secure_function()
}
```

``` text
$ rustc --emit asm --crate-type lib --target thumbv8m.main-none-eabi function.rs

call_nonsecure_function:
        .fnstart
        .save   {r7, lr}
        push    {r7, lr}
        .setfp  r7, sp
        mov     r7, sp
        .pad    #16
        sub     sp, #16
        str     r0, [sp, #12]
        ldr     r0, [sp, #12]
        str     r0, [sp, #8]
        b       .LBB0_1
.LBB0_1:
        ldr     r0, [sp, #8]
        push.w  {r4, r5, r6, r7, r8, r9, r10, r11}
        bic     r0, r0, #1
        mov     r1, r0
        mov     r2, r0
        mov     r3, r0
        mov     r4, r0
        mov     r5, r0
        mov     r6, r0
        mov     r7, r0
        mov     r8, r0
        mov     r9, r0
        mov     r10, r0
        mov     r11, r0
        mov     r12, r0
        msr     apsr_nzcvq, r0
        blxns   r0
        pop.w   {r4, r5, r6, r7, r8, r9, r10, r11}
        str     r0, [sp, #4]
        b       .LBB0_2
.LBB0_2:
        ldr     r0, [sp, #4]
        add     sp, #16
        pop     {r7, pc}
```
"##,
    },
    Lint {
        label: "abi_msp430_interrupt",
        description: r##"# `abi_msp430_interrupt`

The tracking issue for this feature is: [#38487]

[#38487]: https://github.com/rust-lang/rust/issues/38487

------------------------

In the MSP430 architecture, interrupt handlers have a special calling
convention. You can use the `"msp430-interrupt"` ABI to make the compiler apply
the right calling convention to the interrupt handlers you define.

<!-- NOTE(ignore) this example is specific to the msp430 target -->

``` rust,ignore
#![feature(abi_msp430_interrupt)]
#![no_std]

// Place the interrupt handler at the appropriate memory address
// (Alternatively, you can use `#[used]` and remove `pub` and `#[no_mangle]`)
#[link_section = "__interrupt_vector_10"]
#[no_mangle]
pub static TIM0_VECTOR: extern "msp430-interrupt" fn() = tim0;

// The interrupt handler
extern "msp430-interrupt" fn tim0() {
    // ..
}
```

``` text
$ msp430-elf-objdump -CD ./target/msp430/release/app
Disassembly of section __interrupt_vector_10:

0000fff2 <TIM0_VECTOR>:
    fff2:       00 c0           interrupt service routine at 0xc000

Disassembly of section .text:

0000c000 <int::tim0>:
    c000:       00 13           reti
```
"##,
    },
    Lint {
        label: "abi_ptx",
        description: r##"# `abi_ptx`

The tracking issue for this feature is: [#38788]

[#38788]: https://github.com/rust-lang/rust/issues/38788

------------------------

When emitting PTX code, all vanilla Rust functions (`fn`) get translated to
"device" functions. These functions are *not* callable from the host via the
CUDA API so a crate with only device functions is not too useful!

OTOH, "global" functions *can* be called by the host; you can think of them
as the real public API of your crate. To produce a global function use the
`"ptx-kernel"` ABI.

<!-- NOTE(ignore) this example is specific to the nvptx targets -->

``` rust,ignore
#![feature(abi_ptx)]
#![no_std]

pub unsafe extern "ptx-kernel" fn global_function() {
    device_function();
}

pub fn device_function() {
    // ..
}
```

``` text
$ xargo rustc --target nvptx64-nvidia-cuda --release -- --emit=asm

$ cat $(find -name '*.s')
//
// Generated by LLVM NVPTX Back-End
//

.version 3.2
.target sm_20
.address_size 64

        // .globl       _ZN6kernel15global_function17h46111ebe6516b382E

.visible .entry _ZN6kernel15global_function17h46111ebe6516b382E()
{


        ret;
}

        // .globl       _ZN6kernel15device_function17hd6a0e4993bbf3f78E
.visible .func _ZN6kernel15device_function17hd6a0e4993bbf3f78E()
{


        ret;
}
```
"##,
    },
    Lint {
        label: "abi_riscv_interrupt",
        description: r##"# `abi_riscv_interrupt`

The tracking issue for this feature is: [#111889]

[#111889]: https://github.com/rust-lang/rust/issues/111889

------------------------
"##,
    },
    Lint {
        label: "abi_unadjusted",
        description: r##"# `abi_unadjusted`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "abi_vectorcall",
        description: r##"# `abi_vectorcall`

The tracking issue for this feature is: [#124485]

[#124485]: https://github.com/rust-lang/rust/issues/124485

------------------------

Adds support for the Windows `"vectorcall"` ABI, the equivalent of `__vectorcall` in MSVC.

```rust,ignore (only-windows-or-x86-or-x86-64)
extern "vectorcall" {
    fn add_f64s(x: f64, y: f64) -> f64;
}

fn main() {
    println!("{}", add_f64s(2.0, 4.0));
}
```
"##,
    },
    Lint {
        label: "abi_x86_interrupt",
        description: r##"# `abi_x86_interrupt`

The tracking issue for this feature is: [#40180]

[#40180]: https://github.com/rust-lang/rust/issues/40180

------------------------
"##,
    },
    Lint {
        label: "acceptfilter",
        description: r##"# `acceptfilter`

The tracking issue for this feature is: [#121891]

[#121891]: https://github.com/rust-lang/rust/issues/121891

------------------------
"##,
    },
    Lint {
        label: "addr_parse_ascii",
        description: r##"# `addr_parse_ascii`

The tracking issue for this feature is: [#101035]

[#101035]: https://github.com/rust-lang/rust/issues/101035

------------------------
"##,
    },
    Lint {
        label: "adt_const_params",
        description: r##"# `adt_const_params`

The tracking issue for this feature is: [#95174]

[#95174]: https://github.com/rust-lang/rust/issues/95174

------------------------

Allows for using more complex types for const parameters, such as structs or enums.

```rust
#![feature(adt_const_params)]
#![allow(incomplete_features)]

use std::marker::ConstParamTy;

#[derive(ConstParamTy, PartialEq, Eq)]
enum Foo {
    A,
    B,
    C,
}

#[derive(ConstParamTy, PartialEq, Eq)]
struct Bar {
    flag: bool,
}

fn is_foo_a_and_bar_true<const F: Foo, const B: Bar>() -> bool {
    match (F, B.flag) {
        (Foo::A, true) => true,
        _ => false,
    }
}
```
"##,
    },
    Lint {
        label: "alloc_error_handler",
        description: r##"# `alloc_error_handler`

The tracking issue for this feature is: [#51540]

[#51540]: https://github.com/rust-lang/rust/issues/51540

------------------------
"##,
    },
    Lint {
        label: "alloc_error_hook",
        description: r##"# `alloc_error_hook`

The tracking issue for this feature is: [#51245]

[#51245]: https://github.com/rust-lang/rust/issues/51245

------------------------
"##,
    },
    Lint {
        label: "alloc_internals",
        description: r##"# `alloc_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "alloc_layout_extra",
        description: r##"# `alloc_layout_extra`

The tracking issue for this feature is: [#55724]

[#55724]: https://github.com/rust-lang/rust/issues/55724

------------------------
"##,
    },
    Lint {
        label: "allocator_api",
        description: r##"# `allocator_api`

The tracking issue for this feature is [#32838]

[#32838]: https://github.com/rust-lang/rust/issues/32838

------------------------

Sometimes you want the memory for one collection to use a different
allocator than the memory for another collection. In this case,
replacing the global allocator is not a workable option. Instead,
you need to pass in an instance of an `AllocRef` to each collection
for which you want a custom allocator.

TBD
"##,
    },
    Lint {
        label: "allocator_internals",
        description: r##"# `allocator_internals`

This feature does not have a tracking issue, it is an unstable implementation
detail of the `global_allocator` feature not intended for use outside the
compiler.

------------------------
"##,
    },
    Lint {
        label: "allow_internal_unsafe",
        description: r##"# `allow_internal_unsafe`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "allow_internal_unstable",
        description: r##"# `allow_internal_unstable`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "anonymous_lifetime_in_impl_trait",
        description: r##"# `anonymous_lifetime_in_impl_trait`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "arbitrary_self_types",
        description: r##"# `arbitrary_self_types`

The tracking issue for this feature is: [#44874]

[#44874]: https://github.com/rust-lang/rust/issues/44874

------------------------
"##,
    },
    Lint {
        label: "arm_target_feature",
        description: r##"# `arm_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "array_chunks",
        description: r##"# `array_chunks`

The tracking issue for this feature is: [#74985]

[#74985]: https://github.com/rust-lang/rust/issues/74985

------------------------
"##,
    },
    Lint {
        label: "array_into_iter_constructors",
        description: r##"# `array_into_iter_constructors`

The tracking issue for this feature is: [#91583]

[#91583]: https://github.com/rust-lang/rust/issues/91583

------------------------
"##,
    },
    Lint {
        label: "array_ptr_get",
        description: r##"# `array_ptr_get`

The tracking issue for this feature is: [#119834]

[#119834]: https://github.com/rust-lang/rust/issues/119834

------------------------
"##,
    },
    Lint {
        label: "array_repeat",
        description: r##"# `array_repeat`

The tracking issue for this feature is: [#126695]

[#126695]: https://github.com/rust-lang/rust/issues/126695

------------------------
"##,
    },
    Lint {
        label: "array_try_from_fn",
        description: r##"# `array_try_from_fn`

The tracking issue for this feature is: [#89379]

[#89379]: https://github.com/rust-lang/rust/issues/89379

------------------------
"##,
    },
    Lint {
        label: "array_try_map",
        description: r##"# `array_try_map`

The tracking issue for this feature is: [#79711]

[#79711]: https://github.com/rust-lang/rust/issues/79711

------------------------
"##,
    },
    Lint {
        label: "array_windows",
        description: r##"# `array_windows`

The tracking issue for this feature is: [#75027]

[#75027]: https://github.com/rust-lang/rust/issues/75027

------------------------
"##,
    },
    Lint {
        label: "as_array_of_cells",
        description: r##"# `as_array_of_cells`

The tracking issue for this feature is: [#88248]

[#88248]: https://github.com/rust-lang/rust/issues/88248

------------------------
"##,
    },
    Lint {
        label: "ascii_char",
        description: r##"# `ascii_char`

The tracking issue for this feature is: [#110998]

[#110998]: https://github.com/rust-lang/rust/issues/110998

------------------------
"##,
    },
    Lint {
        label: "ascii_char_variants",
        description: r##"# `ascii_char_variants`

The tracking issue for this feature is: [#110998]

[#110998]: https://github.com/rust-lang/rust/issues/110998

------------------------
"##,
    },
    Lint {
        label: "asm_const",
        description: r##"# `asm_const`

The tracking issue for this feature is: [#93332]

[#93332]: https://github.com/rust-lang/rust/issues/93332

------------------------

This feature adds a `const <expr>` operand type to `asm!` and `global_asm!`.
- `<expr>` must be an integer constant expression.
- The value of the expression is formatted as a string and substituted directly into the asm template string.
"##,
    },
    Lint {
        label: "asm_experimental_arch",
        description: r##"# `asm_experimental_arch`

The tracking issue for this feature is: [#93335]

[#93335]: https://github.com/rust-lang/rust/issues/93335

------------------------

This feature tracks `asm!` and `global_asm!` support for the following architectures:
- NVPTX
- PowerPC
- Hexagon
- MIPS32r2 and MIPS64r2
- wasm32
- BPF
- SPIR-V
- AVR
- MSP430
- M68k
- CSKY
- s390x
- Arm64EC

## Register classes

| Architecture | Register class | Registers                          | LLVM constraint code |
| ------------ | -------------- | ---------------------------------- | -------------------- |
| MIPS         | `reg`          | `$[2-25]`                          | `r`                  |
| MIPS         | `freg`         | `$f[0-31]`                         | `f`                  |
| NVPTX        | `reg16`        | None\*                             | `h`                  |
| NVPTX        | `reg32`        | None\*                             | `r`                  |
| NVPTX        | `reg64`        | None\*                             | `l`                  |
| Hexagon      | `reg`          | `r[0-28]`                          | `r`                  |
| PowerPC      | `reg`          | `r[0-31]`                          | `r`                  |
| PowerPC      | `reg_nonzero`  | `r[1-31]`                          | `b`                  |
| PowerPC      | `freg`         | `f[0-31]`                          | `f`                  |
| PowerPC      | `cr`           | `cr[0-7]`, `cr`                    | Only clobbers        |
| PowerPC      | `xer`          | `xer`                              | Only clobbers        |
| wasm32       | `local`        | None\*                             | `r`                  |
| BPF          | `reg`          | `r[0-10]`                          | `r`                  |
| BPF          | `wreg`         | `w[0-10]`                          | `w`                  |
| AVR          | `reg`          | `r[2-25]`, `XH`, `XL`, `ZH`, `ZL`  | `r`                  |
| AVR          | `reg_upper`    | `r[16-25]`, `XH`, `XL`, `ZH`, `ZL` | `d`                  |
| AVR          | `reg_pair`     | `r3r2` .. `r25r24`, `X`, `Z`       | `r`                  |
| AVR          | `reg_iw`       | `r25r24`, `X`, `Z`                 | `w`                  |
| AVR          | `reg_ptr`      | `X`, `Z`                           | `e`                  |
| MSP430       | `reg`          | `r[0-15]`                          | `r`                  |
| M68k         | `reg`          | `d[0-7]`, `a[0-7]`                 | `r`                  |
| M68k         | `reg_data`     | `d[0-7]`                           | `d`                  |
| M68k         | `reg_addr`     | `a[0-3]`                           | `a`                  |
| CSKY         | `reg`          | `r[0-31]`                          | `r`                  |
| CSKY         | `freg`         | `f[0-31]`                          | `f`                  |
| s390x        | `reg`          | `r[0-10]`, `r[12-14]`              | `r`                  |
| s390x        | `freg`         | `f[0-15]`                          | `f`                  |
| Arm64EC      | `reg`          | `x[0-12]`, `x[15-22]`, `x[25-27]`, `x30` | `r`            |
| Arm64EC      | `vreg`         | `v[0-15]`                          | `w`                  |
| Arm64EC      | `vreg_low16`   | `v[0-15]`                          | `x`                  |

> **Notes**:
> - NVPTX doesn't have a fixed register set, so named registers are not supported.
>
> - WebAssembly doesn't have registers, so named registers are not supported.

# Register class supported types

| Architecture | Register class                  | Target feature | Allowed types                           |
| ------------ | ------------------------------- | -------------- | --------------------------------------- |
| MIPS32       | `reg`                           | None           | `i8`, `i16`, `i32`, `f32`               |
| MIPS32       | `freg`                          | None           | `f32`, `f64`                            |
| MIPS64       | `reg`                           | None           | `i8`, `i16`, `i32`, `i64`, `f32`, `f64` |
| MIPS64       | `freg`                          | None           | `f32`, `f64`                            |
| NVPTX        | `reg16`                         | None           | `i8`, `i16`                             |
| NVPTX        | `reg32`                         | None           | `i8`, `i16`, `i32`, `f32`               |
| NVPTX        | `reg64`                         | None           | `i8`, `i16`, `i32`, `f32`, `i64`, `f64` |
| Hexagon      | `reg`                           | None           | `i8`, `i16`, `i32`, `f32`               |
| PowerPC      | `reg`                           | None           | `i8`, `i16`, `i32`                      |
| PowerPC      | `reg_nonzero`                   | None           | `i8`, `i16`, `i32`                      |
| PowerPC      | `freg`                          | None           | `f32`, `f64`                            |
| PowerPC      | `cr`                            | N/A            | Only clobbers                           |
| PowerPC      | `xer`                           | N/A            | Only clobbers                           |
| wasm32       | `local`                         | None           | `i8` `i16` `i32` `i64` `f32` `f64`      |
| BPF          | `reg`                           | None           | `i8` `i16` `i32` `i64`                  |
| BPF          | `wreg`                          | `alu32`        | `i8` `i16` `i32`                        |
| AVR          | `reg`, `reg_upper`              | None           | `i8`                                    |
| AVR          | `reg_pair`, `reg_iw`, `reg_ptr` | None           | `i16`                                   |
| MSP430       | `reg`                           | None           | `i8`, `i16`                             |
| M68k         | `reg`, `reg_addr`               | None           | `i16`, `i32`                            |
| M68k         | `reg_data`                      | None           | `i8`, `i16`, `i32`                      |
| CSKY         | `reg`                           | None           | `i8`, `i16`, `i32`                      |
| CSKY         | `freg`                          | None           | `f32`,                                  |
| s390x        | `reg`, `reg_addr`               | None           | `i8`, `i16`, `i32`, `i64`               |
| s390x        | `freg`                          | None           | `f32`, `f64`                            |
| Arm64EC      | `reg`                           | None           | `i8`, `i16`, `i32`, `f32`, `i64`, `f64` |
| Arm64EC      | `vreg`                          | None           | `i8`, `i16`, `i32`, `f32`, `i64`, `f64`, <br> `i8x8`, `i16x4`, `i32x2`, `i64x1`, `f32x2`, `f64x1`, <br> `i8x16`, `i16x8`, `i32x4`, `i64x2`, `f32x4`, `f64x2` |

## Register aliases

| Architecture | Base register | Aliases   |
| ------------ | ------------- | --------- |
| Hexagon      | `r29`         | `sp`      |
| Hexagon      | `r30`         | `fr`      |
| Hexagon      | `r31`         | `lr`      |
| BPF          | `r[0-10]`     | `w[0-10]` |
| AVR          | `XH`          | `r27`     |
| AVR          | `XL`          | `r26`     |
| AVR          | `ZH`          | `r31`     |
| AVR          | `ZL`          | `r30`     |
| MSP430       | `r0`          | `pc`      |
| MSP430       | `r1`          | `sp`      |
| MSP430       | `r2`          | `sr`      |
| MSP430       | `r3`          | `cg`      |
| MSP430       | `r4`          | `fp`      |
| M68k         | `a5`          | `bp`      |
| M68k         | `a6`          | `fp`      |
| M68k         | `a7`          | `sp`, `usp`, `ssp`, `isp` |
| CSKY         | `r[0-3]`      | `a[0-3]`  |
| CSKY         | `r[4-11]`     | `l[0-7]`  |
| CSKY         | `r[12-13]`    | `t[0-1]`  |
| CSKY         | `r14`         | `sp`      |
| CSKY         | `r15`         | `lr`      |
| CSKY         | `r[16-17]`    | `l[8-9]`  |
| CSKY         | `r[18-25]`    | `t[2-9]`  |
| CSKY         | `r28`         | `rgb`     |
| CSKY         | `r29`         | `rtb`     |
| CSKY         | `r30`         | `svbr`    |
| CSKY         | `r31`         | `tls`     |
| Arm64EC      | `x[0-30]`     | `w[0-30]` |
| Arm64EC      | `x29`         | `fp`      |
| Arm64EC      | `x30`         | `lr`      |
| Arm64EC      | `sp`          | `wsp`     |
| Arm64EC      | `xzr`         | `wzr`     |
| Arm64EC      | `v[0-15]`     | `b[0-15]`, `h[0-15]`, `s[0-15]`, `d[0-15]`, `q[0-15]` |

> **Notes**:
> - TI does not mandate a frame pointer for MSP430, but toolchains are allowed
    to use one; LLVM uses `r4`.

## Unsupported registers

| Architecture | Unsupported register                    | Reason                                                                                                                                                                              |
| ------------ | --------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| All          | `sp`, `r15` (s390x)                     | The stack pointer must be restored to its original value at the end of an asm code block.                                                                                           |
| All          | `fr` (Hexagon), `$fp` (MIPS), `Y` (AVR), `r4` (MSP430), `a6` (M68k), `r11` (s390x), `x29` (Arm64EC) | The frame pointer cannot be used as an input or output.                                                                                                                             |
| All          | `r19` (Hexagon), `x19` (Arm64EC)        | This is used internally by LLVM as a "base pointer" for functions with complex stack frames.                                                                                        |
| MIPS         | `$0` or `$zero`                         | This is a constant zero register which can't be modified.                                                                                                                           |
| MIPS         | `$1` or `$at`                           | Reserved for assembler.                                                                                                                                                             |
| MIPS         | `$26`/`$k0`, `$27`/`$k1`                | OS-reserved registers.                                                                                                                                                              |
| MIPS         | `$28`/`$gp`                             | Global pointer cannot be used as inputs or outputs.                                                                                                                                 |
| MIPS         | `$ra`                                   | Return address cannot be used as inputs or outputs.                                                                                                                                 |
| Hexagon      | `lr`                                    | This is the link register which cannot be used as an input or output.                                                                                                               |
| AVR          | `r0`, `r1`, `r1r0`                      | Due to an issue in LLVM, the `r0` and `r1` registers cannot be used as inputs or outputs.  If modified, they must be restored to their original values before the end of the block. |
|MSP430        | `r0`, `r2`, `r3`                        | These are the program counter, status register, and constant generator respectively. Neither the status register nor constant generator can be written to.                          |
| M68k         | `a4`, `a5`                              | Used internally by LLVM for the base pointer and global base pointer. |
| CSKY         | `r7`, `r28`                             | Used internally by LLVM for the base pointer and global base pointer. |
| CSKY         | `r8`                                    | Used internally by LLVM for the frame pointer. |
| CSKY         | `r14`                                   | Used internally by LLVM for the stack pointer. |
| CSKY         | `r15`                                   | This is the link register. |
| CSKY         | `r[26-30]`                              | Reserved by its ABI.       |
| CSKY         | `r31`                                   | This is the TLS register.  |
| Arm64EC      | `xzr`                                   | This is a constant zero register which can't be modified. |
| Arm64EC      | `x18`                                   | This is an OS-reserved register. |
| Arm64EC      | `x13`, `x14`, `x23`, `x24`, `x28`, `v[16-31]` | These are AArch64 registers that are not supported for Arm64EC. |


## Template modifiers

| Architecture | Register class | Modifier | Example output | LLVM modifier |
| ------------ | -------------- | -------- | -------------- | ------------- |
| MIPS         | `reg`          | None     | `$2`           | None          |
| MIPS         | `freg`         | None     | `$f0`          | None          |
| NVPTX        | `reg16`        | None     | `rs0`          | None          |
| NVPTX        | `reg32`        | None     | `r0`           | None          |
| NVPTX        | `reg64`        | None     | `rd0`          | None          |
| Hexagon      | `reg`          | None     | `r0`           | None          |
| PowerPC      | `reg`          | None     | `0`            | None          |
| PowerPC      | `reg_nonzero`  | None     | `3`            | None          |
| PowerPC      | `freg`         | None     | `0`            | None          |
| s390x        | `reg`          | None     | `%r0`          | None          |
| s390x        | `reg_addr`     | None     | `%r1`          | None          |
| s390x        | `freg`         | None     | `%f0`          | None          |
| CSKY         | `reg`          | None     | `r0`           | None          |
| CSKY         | `freg`         | None     | `f0`           | None          |
| Arm64EC      | `reg`          | None     | `x0`           | `x`           |
| Arm64EC      | `reg`          | `w`      | `w0`           | `w`           |
| Arm64EC      | `reg`          | `x`      | `x0`           | `x`           |
| Arm64EC      | `vreg`         | None     | `v0`           | None          |
| Arm64EC      | `vreg`         | `v`      | `v0`           | None          |
| Arm64EC      | `vreg`         | `b`      | `b0`           | `b`           |
| Arm64EC      | `vreg`         | `h`      | `h0`           | `h`           |
| Arm64EC      | `vreg`         | `s`      | `s0`           | `s`           |
| Arm64EC      | `vreg`         | `d`      | `d0`           | `d`           |
| Arm64EC      | `vreg`         | `q`      | `q0`           | `q`           |

# Flags covered by `preserves_flags`

These flags registers must be restored upon exiting the asm block if the `preserves_flags` option is set:
- AVR
  - The status register `SREG`.
- MSP430
  - The status register `r2`.
- M68k
  - The condition code register `ccr`.
- s390x
  - The condition code register `cc`.
- Arm64EC
  - Condition flags (`NZCV` register).
  - Floating-point status (`FPSR` register).
"##,
    },
    Lint {
        label: "asm_goto",
        description: r##"# `asm_goto`

The tracking issue for this feature is: [#119364]

[#119364]: https://github.com/rust-lang/rust/issues/119364

------------------------

This feature adds a `label <block>` operand type to `asm!`.

Example:
```rust,ignore (partial-example, x86-only)

unsafe {
    asm!(
        "jmp {}",
        label {
            println!("Jumped from asm!");
        }
    );
}
```

The block must have unit type or diverge.

When `label <block>` is used together with `noreturn` option, it means that the
assembly will not fallthrough. It's allowed to jump to a label within the
assembly. In this case, the entire `asm!` expression will have an unit type as
opposed to diverging, if not all label blocks diverge. The `asm!` expression
still diverges if `noreturn` option is used and all label blocks diverge.
"##,
    },
    Lint {
        label: "asm_unwind",
        description: r##"# `asm_unwind`

The tracking issue for this feature is: [#93334]

[#93334]: https://github.com/rust-lang/rust/issues/93334

------------------------

This feature adds a `may_unwind` option to `asm!` which allows an `asm` block to unwind stack and be part of the stack unwinding process. This option is only supported by the LLVM backend right now.
"##,
    },
    Lint {
        label: "assert_matches",
        description: r##"# `assert_matches`

The tracking issue for this feature is: [#82775]

[#82775]: https://github.com/rust-lang/rust/issues/82775

------------------------
"##,
    },
    Lint {
        label: "associated_const_equality",
        description: r##"# `associated_const_equality`

The tracking issue for this feature is: [#92827]

[#92827]: https://github.com/rust-lang/rust/issues/92827

------------------------
"##,
    },
    Lint {
        label: "associated_type_defaults",
        description: r##"# `associated_type_defaults`

The tracking issue for this feature is: [#29661]

[#29661]: https://github.com/rust-lang/rust/issues/29661

------------------------
"##,
    },
    Lint {
        label: "async_closure",
        description: r##"# `async_closure`

The tracking issue for this feature is: [#62290]

[#62290]: https://github.com/rust-lang/rust/issues/62290

------------------------
"##,
    },
    Lint {
        label: "async_drop",
        description: r##"# `async_drop`

The tracking issue for this feature is: [#126482]

[#126482]: https://github.com/rust-lang/rust/issues/126482

------------------------
"##,
    },
    Lint {
        label: "async_fn_track_caller",
        description: r##"# `async_fn_track_caller`

The tracking issue for this feature is: [#110011]

[#110011]: https://github.com/rust-lang/rust/issues/110011

------------------------
"##,
    },
    Lint {
        label: "async_fn_traits",
        description: r##"# `async_fn_traits`

See Also: [`fn_traits`](../library-features/fn-traits.md)

----

The `async_fn_traits` feature allows for implementation of the [`AsyncFn*`] traits
for creating custom closure-like types that return futures.

[`AsyncFn*`]: ../../std/ops/trait.AsyncFn.html

The main difference to the `Fn*` family of traits is that `AsyncFn` can return a future
that borrows from itself (`FnOnce::Output` has no lifetime parameters, while `AsyncFnMut::CallRefFuture` does).
"##,
    },
    Lint {
        label: "async_for_loop",
        description: r##"# `async_for_loop`

The tracking issue for this feature is: [#118898]

[#118898]: https://github.com/rust-lang/rust/issues/118898

------------------------
"##,
    },
    Lint {
        label: "async_gen_internals",
        description: r##"# `async_gen_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "async_iter_from_iter",
        description: r##"# `async_iter_from_iter`

The tracking issue for this feature is: [#81798]

[#81798]: https://github.com/rust-lang/rust/issues/81798

------------------------
"##,
    },
    Lint {
        label: "async_iterator",
        description: r##"# `async_iterator`

The tracking issue for this feature is: [#79024]

[#79024]: https://github.com/rust-lang/rust/issues/79024

------------------------
"##,
    },
    Lint {
        label: "atomic_from_mut",
        description: r##"# `atomic_from_mut`

The tracking issue for this feature is: [#76314]

[#76314]: https://github.com/rust-lang/rust/issues/76314

------------------------
"##,
    },
    Lint {
        label: "auto_traits",
        description: r##"# `auto_traits`

The tracking issue for this feature is [#13231]

[#13231]: https://github.com/rust-lang/rust/issues/13231

----

The `auto_traits` feature gate allows you to define auto traits.

Auto traits, like [`Send`] or [`Sync`] in the standard library, are marker traits
that are automatically implemented for every type, unless the type, or a type it contains,
has explicitly opted out via a negative impl. (Negative impls are separately controlled
by the `negative_impls` feature.)

[`Send`]: ../../std/marker/trait.Send.html
[`Sync`]: ../../std/marker/trait.Sync.html

```rust,ignore (partial-example)
impl !Trait for Type {}
```

Example:

```rust
#![feature(negative_impls)]
#![feature(auto_traits)]

auto trait Valid {}

struct True;
struct False;

impl !Valid for False {}

struct MaybeValid<T>(T);

fn must_be_valid<T: Valid>(_t: T) { }

fn main() {
    // works
    must_be_valid( MaybeValid(True) );

    // compiler error - trait bound not satisfied
    // must_be_valid( MaybeValid(False) );
}
```

## Automatic trait implementations

When a type is declared as an `auto trait`, we will automatically
create impls for every struct/enum/union, unless an explicit impl is
provided. These automatic impls contain a where clause for each field
of the form `T: AutoTrait`, where `T` is the type of the field and
`AutoTrait` is the auto trait in question. As an example, consider the
struct `List` and the auto trait `Send`:

```rust
struct List<T> {
  data: T,
  next: Option<Box<List<T>>>,
}
```

Presuming that there is no explicit impl of `Send` for `List`, the
compiler will supply an automatic impl of the form:

```rust
struct List<T> {
  data: T,
  next: Option<Box<List<T>>>,
}

unsafe impl<T> Send for List<T>
where
  T: Send, // from the field `data`
  Option<Box<List<T>>>: Send, // from the field `next`
{ }
```

Explicit impls may be either positive or negative. They take the form:

```rust,ignore (partial-example)
impl<...> AutoTrait for StructName<..> { }
impl<...> !AutoTrait for StructName<..> { }
```

## Coinduction: Auto traits permit cyclic matching

Unlike ordinary trait matching, auto traits are **coinductive**. This
means, in short, that cycles which occur in trait matching are
considered ok. As an example, consider the recursive struct `List`
introduced in the previous section. In attempting to determine whether
`List: Send`, we would wind up in a cycle: to apply the impl, we must
show that `Option<Box<List>>: Send`, which will in turn require
`Box<List>: Send` and then finally `List: Send` again. Under ordinary
trait matching, this cycle would be an error, but for an auto trait it
is considered a successful match.

## Items

Auto traits cannot have any trait items, such as methods or associated types. This ensures that we can generate default implementations.

## Supertraits

Auto traits cannot have supertraits. This is for soundness reasons, as the interaction of coinduction with implied bounds is difficult to reconcile.
"##,
    },
    Lint {
        label: "avx512_target_feature",
        description: r##"# `avx512_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "backtrace_frames",
        description: r##"# `backtrace_frames`

The tracking issue for this feature is: [#79676]

[#79676]: https://github.com/rust-lang/rust/issues/79676

------------------------
"##,
    },
    Lint {
        label: "bigint_helper_methods",
        description: r##"# `bigint_helper_methods`

The tracking issue for this feature is: [#85532]

[#85532]: https://github.com/rust-lang/rust/issues/85532

------------------------
"##,
    },
    Lint {
        label: "binary_heap_drain_sorted",
        description: r##"# `binary_heap_drain_sorted`

The tracking issue for this feature is: [#59278]

[#59278]: https://github.com/rust-lang/rust/issues/59278

------------------------
"##,
    },
    Lint {
        label: "binary_heap_into_iter_sorted",
        description: r##"# `binary_heap_into_iter_sorted`

The tracking issue for this feature is: [#59278]

[#59278]: https://github.com/rust-lang/rust/issues/59278

------------------------
"##,
    },
    Lint {
        label: "bound_as_ref",
        description: r##"# `bound_as_ref`

The tracking issue for this feature is: [#80996]

[#80996]: https://github.com/rust-lang/rust/issues/80996

------------------------
"##,
    },
    Lint {
        label: "box_into_boxed_slice",
        description: r##"# `box_into_boxed_slice`

The tracking issue for this feature is: [#71582]

[#71582]: https://github.com/rust-lang/rust/issues/71582

------------------------
"##,
    },
    Lint {
        label: "box_into_inner",
        description: r##"# `box_into_inner`

The tracking issue for this feature is: [#80437]

[#80437]: https://github.com/rust-lang/rust/issues/80437

------------------------
"##,
    },
    Lint {
        label: "box_patterns",
        description: r##"# `box_patterns`

The tracking issue for this feature is: [#29641]

[#29641]: https://github.com/rust-lang/rust/issues/29641

------------------------

Box patterns let you match on `Box<T>`s:


```rust
#![feature(box_patterns)]

fn main() {
    let b = Some(Box::new(5));
    match b {
        Some(box n) if n < 0 => {
            println!("Box contains negative number {n}");
        },
        Some(box n) if n >= 0 => {
            println!("Box contains non-negative number {n}");
        },
        None => {
            println!("No box");
        },
        _ => unreachable!()
    }
}
```
"##,
    },
    Lint {
        label: "bpf_target_feature",
        description: r##"# `bpf_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "btree_cursors",
        description: r##"# `btree_cursors`

The tracking issue for this feature is: [#107540]

[#107540]: https://github.com/rust-lang/rust/issues/107540

------------------------
"##,
    },
    Lint {
        label: "btree_extract_if",
        description: r##"# `btree_extract_if`

The tracking issue for this feature is: [#70530]

[#70530]: https://github.com/rust-lang/rust/issues/70530

------------------------
"##,
    },
    Lint {
        label: "btreemap_alloc",
        description: r##"# `btreemap_alloc`

The tracking issue for this feature is: [#32838]

[#32838]: https://github.com/rust-lang/rust/issues/32838

------------------------
"##,
    },
    Lint {
        label: "buf_read_has_data_left",
        description: r##"# `buf_read_has_data_left`

The tracking issue for this feature is: [#86423]

[#86423]: https://github.com/rust-lang/rust/issues/86423

------------------------
"##,
    },
    Lint {
        label: "bufread_skip_until",
        description: r##"# `bufread_skip_until`

The tracking issue for this feature is: [#111735]

[#111735]: https://github.com/rust-lang/rust/issues/111735

------------------------
"##,
    },
    Lint {
        label: "build_hasher_default_const_new",
        description: r##"# `build_hasher_default_const_new`

The tracking issue for this feature is: [#123197]

[#123197]: https://github.com/rust-lang/rust/issues/123197

------------------------
"##,
    },
    Lint {
        label: "builtin_syntax",
        description: r##"# `builtin_syntax`

The tracking issue for this feature is: [#110680]

[#110680]: https://github.com/rust-lang/rust/issues/110680

------------------------
"##,
    },
    Lint {
        label: "c_size_t",
        description: r##"# `c_size_t`

The tracking issue for this feature is: [#88345]

[#88345]: https://github.com/rust-lang/rust/issues/88345

------------------------
"##,
    },
    Lint {
        label: "c_str_module",
        description: r##"# `c_str_module`

The tracking issue for this feature is: [#112134]

[#112134]: https://github.com/rust-lang/rust/issues/112134

------------------------
"##,
    },
    Lint {
        label: "c_variadic",
        description: r##"# `c_variadic`

The tracking issue for this feature is: [#44930]

[#44930]: https://github.com/rust-lang/rust/issues/44930

------------------------

The `c_variadic` language feature enables C-variadic functions to be
defined in Rust. They may be called both from within Rust and via FFI.

## Examples

```rust
#![feature(c_variadic)]

pub unsafe extern "C" fn add(n: usize, mut args: ...) -> usize {
    let mut sum = 0;
    for _ in 0..n {
        sum += args.arg::<usize>();
    }
    sum
}
```
"##,
    },
    Lint {
        label: "c_variadic",
        description: r##"# `c_variadic`

The tracking issue for this feature is: [#44930]

[#44930]: https://github.com/rust-lang/rust/issues/44930

------------------------

The `c_variadic` library feature exposes the `VaList` structure,
Rust's analogue of C's `va_list` type.

## Examples

```rust
#![feature(c_variadic)]

use std::ffi::VaList;

pub unsafe extern "C" fn vadd(n: usize, mut args: VaList) -> usize {
    let mut sum = 0;
    for _ in 0..n {
        sum += args.arg::<usize>();
    }
    sum
}
```
"##,
    },
    Lint {
        label: "c_void_variant",
        description: r##"# `c_void_variant`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "can_vector",
        description: r##"# `can_vector`

The tracking issue for this feature is: [#69941]

[#69941]: https://github.com/rust-lang/rust/issues/69941

------------------------
"##,
    },
    Lint {
        label: "cell_leak",
        description: r##"# `cell_leak`

The tracking issue for this feature is: [#69099]

[#69099]: https://github.com/rust-lang/rust/issues/69099

------------------------
"##,
    },
    Lint {
        label: "cell_update",
        description: r##"# `cell_update`

The tracking issue for this feature is: [#50186]

[#50186]: https://github.com/rust-lang/rust/issues/50186

------------------------
"##,
    },
    Lint {
        label: "cfg_accessible",
        description: r##"# `cfg_accessible`

The tracking issue for this feature is: [#64797]

[#64797]: https://github.com/rust-lang/rust/issues/64797

------------------------
"##,
    },
    Lint {
        label: "cfg_eval",
        description: r##"# `cfg_eval`

The tracking issue for this feature is: [#82679]

[#82679]: https://github.com/rust-lang/rust/issues/82679

------------------------
"##,
    },
    Lint {
        label: "cfg_match",
        description: r##"# `cfg_match`

The tracking issue for this feature is: [#115585]

[#115585]: https://github.com/rust-lang/rust/issues/115585

------------------------
"##,
    },
    Lint {
        label: "cfg_overflow_checks",
        description: r##"# `cfg_overflow_checks`

The tracking issue for this feature is: [#111466]

[#111466]: https://github.com/rust-lang/rust/issues/111466

------------------------
"##,
    },
    Lint {
        label: "cfg_relocation_model",
        description: r##"# `cfg_relocation_model`

The tracking issue for this feature is: [#114929]

[#114929]: https://github.com/rust-lang/rust/issues/114929

------------------------
"##,
    },
    Lint {
        label: "cfg_sanitize",
        description: r##"# `cfg_sanitize`

The tracking issue for this feature is: [#39699]

[#39699]: https://github.com/rust-lang/rust/issues/39699

------------------------

The `cfg_sanitize` feature makes it possible to execute different code
depending on whether a particular sanitizer is enabled or not.

## Examples

```rust
#![feature(cfg_sanitize)]

#[cfg(sanitize = "thread")]
fn a() {
    // ...
}

#[cfg(not(sanitize = "thread"))]
fn a() {
    // ...
}

fn b() {
    if cfg!(sanitize = "leak") {
        // ...
    } else {
        // ...
    }
}
```
"##,
    },
    Lint {
        label: "cfg_sanitizer_cfi",
        description: r##"# `cfg_sanitizer_cfi`

The tracking issue for this feature is: [#89653]

[#89653]: https://github.com/rust-lang/rust/issues/89653

------------------------
"##,
    },
    Lint {
        label: "cfg_target_compact",
        description: r##"# `cfg_target_compact`

The tracking issue for this feature is: [#96901]

[#96901]: https://github.com/rust-lang/rust/issues/96901

------------------------
"##,
    },
    Lint {
        label: "cfg_target_has_atomic",
        description: r##"# `cfg_target_has_atomic`

The tracking issue for this feature is: [#94039]

[#94039]: https://github.com/rust-lang/rust/issues/94039

------------------------
"##,
    },
    Lint {
        label: "cfg_target_has_atomic_equal_alignment",
        description: r##"# `cfg_target_has_atomic_equal_alignment`

The tracking issue for this feature is: [#93822]

[#93822]: https://github.com/rust-lang/rust/issues/93822

------------------------
"##,
    },
    Lint {
        label: "cfg_target_thread_local",
        description: r##"# `cfg_target_thread_local`

The tracking issue for this feature is: [#29594]

[#29594]: https://github.com/rust-lang/rust/issues/29594

------------------------
"##,
    },
    Lint {
        label: "cfg_ub_checks",
        description: r##"# `cfg_ub_checks`

The tracking issue for this feature is: [#123499]

[#123499]: https://github.com/rust-lang/rust/issues/123499

------------------------
"##,
    },
    Lint {
        label: "cfg_version",
        description: r##"# `cfg_version`

The tracking issue for this feature is: [#64796]

[#64796]: https://github.com/rust-lang/rust/issues/64796

------------------------

The `cfg_version` feature makes it possible to execute different code
depending on the compiler version. It will return true if the compiler
version is greater than or equal to the specified version.

## Examples

```rust
#![feature(cfg_version)]

#[cfg(version("1.42"))] // 1.42 and above
fn a() {
    // ...
}

#[cfg(not(version("1.42")))] // 1.41 and below
fn a() {
    // ...
}

fn b() {
    if cfg!(version("1.42")) {
        // ...
    } else {
        // ...
    }
}
```
"##,
    },
    Lint {
        label: "cfi_encoding",
        description: r##"# `cfi_encoding`

The tracking issue for this feature is: [#89653]

[#89653]: https://github.com/rust-lang/rust/issues/89653

------------------------

The `cfi_encoding` feature allows the user to define a CFI encoding for a type.
It allows the user to use a different names for types that otherwise would be
required to have the same name as used in externally defined C functions.

## Examples

```rust
#![feature(cfi_encoding, extern_types)]

#[cfi_encoding = "3Foo"]
pub struct Type1(i32);

extern {
    #[cfi_encoding = "3Bar"]
    type Type2;
}
```
"##,
    },
    Lint {
        label: "char_indices_offset",
        description: r##"# `char_indices_offset`

The tracking issue for this feature is: [#83871]

[#83871]: https://github.com/rust-lang/rust/issues/83871

------------------------
"##,
    },
    Lint {
        label: "char_internals",
        description: r##"# `char_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "char_min",
        description: r##"# `char_min`

The tracking issue for this feature is: [#114298]

[#114298]: https://github.com/rust-lang/rust/issues/114298

------------------------
"##,
    },
    Lint {
        label: "clone_to_uninit",
        description: r##"# `clone_to_uninit`

The tracking issue for this feature is: [#126799]

[#126799]: https://github.com/rust-lang/rust/issues/126799

------------------------
"##,
    },
    Lint {
        label: "closure_lifetime_binder",
        description: r##"# `closure_lifetime_binder`

The tracking issue for this feature is: [#97362]

[#97362]: https://github.com/rust-lang/rust/issues/97362

------------------------
"##,
    },
    Lint {
        label: "closure_track_caller",
        description: r##"# `closure_track_caller`

The tracking issue for this feature is: [#87417]

[#87417]: https://github.com/rust-lang/rust/issues/87417

------------------------

Allows using the `#[track_caller]` attribute on closures and coroutines.
Calls made to the closure or coroutine will have caller information
available through `std::panic::Location::caller()`, just like using
`#[track_caller]` on a function.
"##,
    },
    Lint {
        label: "cmp_minmax",
        description: r##"# `cmp_minmax`

The tracking issue for this feature is: [#115939]

[#115939]: https://github.com/rust-lang/rust/issues/115939

------------------------
"##,
    },
    Lint {
        label: "cmse_nonsecure_entry",
        description: r##"# `cmse_nonsecure_entry`

The tracking issue for this feature is: [#75835]

[#75835]: https://github.com/rust-lang/rust/issues/75835

------------------------

The [TrustZone-M
feature](https://developer.arm.com/documentation/100690/latest/) is available
for targets with the Armv8-M architecture profile (`thumbv8m` in their target
name).
LLVM, the Rust compiler and the linker are providing
[support](https://developer.arm.com/documentation/ecm0359818/latest/) for the
TrustZone-M feature.

One of the things provided, with this unstable feature, is the
`cmse_nonsecure_entry` attribute.  This attribute marks a Secure function as an
entry function (see [section
5.4](https://developer.arm.com/documentation/ecm0359818/latest/) for details).
With this attribute, the compiler will do the following:
* add a special symbol on the function which is the `__acle_se_` prefix and the
  standard function name
* constrain the number of parameters to avoid using the Non-Secure stack
* before returning from the function, clear registers that might contain Secure
  information
* use the `BXNS` instruction to return

Because the stack can not be used to pass parameters, there will be compilation
errors if:
* the total size of all parameters is too big (for example more than four 32
  bits integers)
* the entry function is not using a C ABI

The special symbol `__acle_se_` will be used by the linker to generate a secure
gateway veneer.

<!-- NOTE(ignore) this example is specific to thumbv8m targets -->

``` rust,ignore
#![feature(cmse_nonsecure_entry)]

#[no_mangle]
#[cmse_nonsecure_entry]
pub extern "C" fn entry_function(input: u32) -> u32 {
    input + 6
}
```

``` text
$ rustc --emit obj --crate-type lib --target thumbv8m.main-none-eabi function.rs
$ arm-none-eabi-objdump -D function.o

00000000 <entry_function>:
   0:   b580            push    {r7, lr}
   2:   466f            mov     r7, sp
   4:   b082            sub     sp, #8
   6:   9001            str     r0, [sp, #4]
   8:   1d81            adds    r1, r0, #6
   a:   460a            mov     r2, r1
   c:   4281            cmp     r1, r0
   e:   9200            str     r2, [sp, #0]
  10:   d30b            bcc.n   2a <entry_function+0x2a>
  12:   e7ff            b.n     14 <entry_function+0x14>
  14:   9800            ldr     r0, [sp, #0]
  16:   b002            add     sp, #8
  18:   e8bd 4080       ldmia.w sp!, {r7, lr}
  1c:   4671            mov     r1, lr
  1e:   4672            mov     r2, lr
  20:   4673            mov     r3, lr
  22:   46f4            mov     ip, lr
  24:   f38e 8800       msr     CPSR_f, lr
  28:   4774            bxns    lr
  2a:   f240 0000       movw    r0, #0
  2e:   f2c0 0000       movt    r0, #0
  32:   f240 0200       movw    r2, #0
  36:   f2c0 0200       movt    r2, #0
  3a:   211c            movs    r1, #28
  3c:   f7ff fffe       bl      0 <_ZN4core9panicking5panic17h5c028258ca2fb3f5E>
  40:   defe            udf     #254    ; 0xfe
```
"##,
    },
    Lint {
        label: "coerce_unsized",
        description: r##"# `coerce_unsized`

The tracking issue for this feature is: [#18598]

[#18598]: https://github.com/rust-lang/rust/issues/18598

------------------------
"##,
    },
    Lint {
        label: "compiler_builtins",
        description: r##"# `compiler_builtins`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "concat_bytes",
        description: r##"# `concat_bytes`

The tracking issue for this feature is: [#87555]

[#87555]: https://github.com/rust-lang/rust/issues/87555

------------------------
"##,
    },
    Lint {
        label: "concat_idents",
        description: r##"# `concat_idents`

The tracking issue for this feature is: [#29599]

[#29599]: https://github.com/rust-lang/rust/issues/29599

------------------------

The `concat_idents` feature adds a macro for concatenating multiple identifiers
into one identifier.

## Examples

```rust
#![feature(concat_idents)]

fn main() {
    fn foobar() -> u32 { 23 }
    let f = concat_idents!(foo, bar);
    assert_eq!(f(), 23);
}
```
"##,
    },
    Lint {
        label: "const_align_of_val",
        description: r##"# `const_align_of_val`

The tracking issue for this feature is: [#46571]

[#46571]: https://github.com/rust-lang/rust/issues/46571

------------------------
"##,
    },
    Lint {
        label: "const_align_of_val_raw",
        description: r##"# `const_align_of_val_raw`

The tracking issue for this feature is: [#46571]

[#46571]: https://github.com/rust-lang/rust/issues/46571

------------------------
"##,
    },
    Lint {
        label: "const_align_offset",
        description: r##"# `const_align_offset`

The tracking issue for this feature is: [#90962]

[#90962]: https://github.com/rust-lang/rust/issues/90962

------------------------
"##,
    },
    Lint {
        label: "const_alloc_error",
        description: r##"# `const_alloc_error`

The tracking issue for this feature is: [#92523]

[#92523]: https://github.com/rust-lang/rust/issues/92523

------------------------
"##,
    },
    Lint {
        label: "const_alloc_layout",
        description: r##"# `const_alloc_layout`

The tracking issue for this feature is: [#67521]

[#67521]: https://github.com/rust-lang/rust/issues/67521

------------------------
"##,
    },
    Lint {
        label: "const_arguments_as_str",
        description: r##"# `const_arguments_as_str`

The tracking issue for this feature is: [#103900]

[#103900]: https://github.com/rust-lang/rust/issues/103900

------------------------
"##,
    },
    Lint {
        label: "const_array_from_ref",
        description: r##"# `const_array_from_ref`

The tracking issue for this feature is: [#90206]

[#90206]: https://github.com/rust-lang/rust/issues/90206

------------------------
"##,
    },
    Lint {
        label: "const_array_into_iter_constructors",
        description: r##"# `const_array_into_iter_constructors`

The tracking issue for this feature is: [#91583]

[#91583]: https://github.com/rust-lang/rust/issues/91583

------------------------
"##,
    },
    Lint {
        label: "const_async_blocks",
        description: r##"# `const_async_blocks`

The tracking issue for this feature is: [#85368]

[#85368]: https://github.com/rust-lang/rust/issues/85368

------------------------
"##,
    },
    Lint {
        label: "const_atomic_from_ptr",
        description: r##"# `const_atomic_from_ptr`

The tracking issue for this feature is: [#108652]

[#108652]: https://github.com/rust-lang/rust/issues/108652

------------------------
"##,
    },
    Lint {
        label: "const_bigint_helper_methods",
        description: r##"# `const_bigint_helper_methods`

The tracking issue for this feature is: [#85532]

[#85532]: https://github.com/rust-lang/rust/issues/85532

------------------------
"##,
    },
    Lint {
        label: "const_binary_heap_new_in",
        description: r##"# `const_binary_heap_new_in`

The tracking issue for this feature is: [#112353]

[#112353]: https://github.com/rust-lang/rust/issues/112353

------------------------
"##,
    },
    Lint {
        label: "const_black_box",
        description: r##"# `const_black_box`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_box",
        description: r##"# `const_box`

The tracking issue for this feature is: [#92521]

[#92521]: https://github.com/rust-lang/rust/issues/92521

------------------------
"##,
    },
    Lint {
        label: "const_btree_len",
        description: r##"# `const_btree_len`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_cell_into_inner",
        description: r##"# `const_cell_into_inner`

The tracking issue for this feature is: [#78729]

[#78729]: https://github.com/rust-lang/rust/issues/78729

------------------------
"##,
    },
    Lint {
        label: "const_char_from_u32_unchecked",
        description: r##"# `const_char_from_u32_unchecked`

The tracking issue for this feature is: [#89259]

[#89259]: https://github.com/rust-lang/rust/issues/89259

------------------------
"##,
    },
    Lint {
        label: "const_closures",
        description: r##"# `const_closures`

The tracking issue for this feature is: [#106003]

[#106003]: https://github.com/rust-lang/rust/issues/106003

------------------------
"##,
    },
    Lint {
        label: "const_collections_with_hasher",
        description: r##"# `const_collections_with_hasher`

The tracking issue for this feature is: [#102575]

[#102575]: https://github.com/rust-lang/rust/issues/102575

------------------------
"##,
    },
    Lint {
        label: "const_cow_is_borrowed",
        description: r##"# `const_cow_is_borrowed`

The tracking issue for this feature is: [#65143]

[#65143]: https://github.com/rust-lang/rust/issues/65143

------------------------
"##,
    },
    Lint {
        label: "const_cstr_from_ptr",
        description: r##"# `const_cstr_from_ptr`

The tracking issue for this feature is: [#113219]

[#113219]: https://github.com/rust-lang/rust/issues/113219

------------------------
"##,
    },
    Lint {
        label: "const_eval_select",
        description: r##"# `const_eval_select`

The tracking issue for this feature is: [#124625]

[#124625]: https://github.com/rust-lang/rust/issues/124625

------------------------
"##,
    },
    Lint {
        label: "const_exact_div",
        description: r##"# `const_exact_div`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_extern_fn",
        description: r##"# `const_extern_fn`

The tracking issue for this feature is: [#64926]

[#64926]: https://github.com/rust-lang/rust/issues/64926

------------------------
"##,
    },
    Lint {
        label: "const_float_bits_conv",
        description: r##"# `const_float_bits_conv`

The tracking issue for this feature is: [#72447]

[#72447]: https://github.com/rust-lang/rust/issues/72447

------------------------
"##,
    },
    Lint {
        label: "const_float_classify",
        description: r##"# `const_float_classify`

The tracking issue for this feature is: [#72505]

[#72505]: https://github.com/rust-lang/rust/issues/72505

------------------------
"##,
    },
    Lint {
        label: "const_fmt_arguments_new",
        description: r##"# `const_fmt_arguments_new`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_fn_floating_point_arithmetic",
        description: r##"# `const_fn_floating_point_arithmetic`

The tracking issue for this feature is: [#57241]

[#57241]: https://github.com/rust-lang/rust/issues/57241

------------------------
"##,
    },
    Lint {
        label: "const_for",
        description: r##"# `const_for`

The tracking issue for this feature is: [#87575]

[#87575]: https://github.com/rust-lang/rust/issues/87575

------------------------
"##,
    },
    Lint {
        label: "const_format_args",
        description: r##"# `const_format_args`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_hash",
        description: r##"# `const_hash`

The tracking issue for this feature is: [#104061]

[#104061]: https://github.com/rust-lang/rust/issues/104061

------------------------
"##,
    },
    Lint {
        label: "const_heap",
        description: r##"# `const_heap`

The tracking issue for this feature is: [#79597]

[#79597]: https://github.com/rust-lang/rust/issues/79597

------------------------
"##,
    },
    Lint {
        label: "const_index_range_slice_index",
        description: r##"# `const_index_range_slice_index`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_int_from_str",
        description: r##"# `const_int_from_str`

The tracking issue for this feature is: [#59133]

[#59133]: https://github.com/rust-lang/rust/issues/59133

------------------------
"##,
    },
    Lint {
        label: "const_intoiterator_identity",
        description: r##"# `const_intoiterator_identity`

The tracking issue for this feature is: [#90603]

[#90603]: https://github.com/rust-lang/rust/issues/90603

------------------------
"##,
    },
    Lint {
        label: "const_intrinsic_compare_bytes",
        description: r##"# `const_intrinsic_compare_bytes`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_intrinsic_copy",
        description: r##"# `const_intrinsic_copy`

The tracking issue for this feature is: [#80697]

[#80697]: https://github.com/rust-lang/rust/issues/80697

------------------------
"##,
    },
    Lint {
        label: "const_intrinsic_forget",
        description: r##"# `const_intrinsic_forget`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_intrinsic_raw_eq",
        description: r##"# `const_intrinsic_raw_eq`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_ip",
        description: r##"# `const_ip`

The tracking issue for this feature is: [#76205]

[#76205]: https://github.com/rust-lang/rust/issues/76205

------------------------
"##,
    },
    Lint {
        label: "const_ipv4",
        description: r##"# `const_ipv4`

The tracking issue for this feature is: [#76205]

[#76205]: https://github.com/rust-lang/rust/issues/76205

------------------------
"##,
    },
    Lint {
        label: "const_ipv6",
        description: r##"# `const_ipv6`

The tracking issue for this feature is: [#76205]

[#76205]: https://github.com/rust-lang/rust/issues/76205

------------------------
"##,
    },
    Lint {
        label: "const_likely",
        description: r##"# `const_likely`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_maybe_uninit_array_assume_init",
        description: r##"# `const_maybe_uninit_array_assume_init`

The tracking issue for this feature is: [#96097]

[#96097]: https://github.com/rust-lang/rust/issues/96097

------------------------
"##,
    },
    Lint {
        label: "const_maybe_uninit_as_mut_ptr",
        description: r##"# `const_maybe_uninit_as_mut_ptr`

The tracking issue for this feature is: [#75251]

[#75251]: https://github.com/rust-lang/rust/issues/75251

------------------------
"##,
    },
    Lint {
        label: "const_maybe_uninit_assume_init",
        description: r##"# `const_maybe_uninit_assume_init`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_maybe_uninit_uninit_array",
        description: r##"# `const_maybe_uninit_uninit_array`

The tracking issue for this feature is: [#96097]

[#96097]: https://github.com/rust-lang/rust/issues/96097

------------------------
"##,
    },
    Lint {
        label: "const_maybe_uninit_write",
        description: r##"# `const_maybe_uninit_write`

The tracking issue for this feature is: [#63567]

[#63567]: https://github.com/rust-lang/rust/issues/63567

------------------------
"##,
    },
    Lint {
        label: "const_mut_refs",
        description: r##"# `const_mut_refs`

The tracking issue for this feature is: [#57349]

[#57349]: https://github.com/rust-lang/rust/issues/57349

------------------------
"##,
    },
    Lint {
        label: "const_nonnull_new",
        description: r##"# `const_nonnull_new`

The tracking issue for this feature is: [#93235]

[#93235]: https://github.com/rust-lang/rust/issues/93235

------------------------
"##,
    },
    Lint {
        label: "const_num_midpoint",
        description: r##"# `const_num_midpoint`

The tracking issue for this feature is: [#110840]

[#110840]: https://github.com/rust-lang/rust/issues/110840

------------------------
"##,
    },
    Lint {
        label: "const_option",
        description: r##"# `const_option`

The tracking issue for this feature is: [#67441]

[#67441]: https://github.com/rust-lang/rust/issues/67441

------------------------
"##,
    },
    Lint {
        label: "const_option_ext",
        description: r##"# `const_option_ext`

The tracking issue for this feature is: [#91930]

[#91930]: https://github.com/rust-lang/rust/issues/91930

------------------------
"##,
    },
    Lint {
        label: "const_pin",
        description: r##"# `const_pin`

The tracking issue for this feature is: [#76654]

[#76654]: https://github.com/rust-lang/rust/issues/76654

------------------------
"##,
    },
    Lint {
        label: "const_pointer_is_aligned",
        description: r##"# `const_pointer_is_aligned`

The tracking issue for this feature is: [#104203]

[#104203]: https://github.com/rust-lang/rust/issues/104203

------------------------
"##,
    },
    Lint {
        label: "const_precise_live_drops",
        description: r##"# `const_precise_live_drops`

The tracking issue for this feature is: [#73255]

[#73255]: https://github.com/rust-lang/rust/issues/73255

------------------------
"##,
    },
    Lint {
        label: "const_pref_align_of",
        description: r##"# `const_pref_align_of`

The tracking issue for this feature is: [#91971]

[#91971]: https://github.com/rust-lang/rust/issues/91971

------------------------
"##,
    },
    Lint {
        label: "const_ptr_as_ref",
        description: r##"# `const_ptr_as_ref`

The tracking issue for this feature is: [#91822]

[#91822]: https://github.com/rust-lang/rust/issues/91822

------------------------
"##,
    },
    Lint {
        label: "const_ptr_is_null",
        description: r##"# `const_ptr_is_null`

The tracking issue for this feature is: [#74939]

[#74939]: https://github.com/rust-lang/rust/issues/74939

------------------------
"##,
    },
    Lint {
        label: "const_ptr_sub_ptr",
        description: r##"# `const_ptr_sub_ptr`

The tracking issue for this feature is: [#95892]

[#95892]: https://github.com/rust-lang/rust/issues/95892

------------------------
"##,
    },
    Lint {
        label: "const_ptr_write",
        description: r##"# `const_ptr_write`

The tracking issue for this feature is: [#86302]

[#86302]: https://github.com/rust-lang/rust/issues/86302

------------------------
"##,
    },
    Lint {
        label: "const_range_bounds",
        description: r##"# `const_range_bounds`

The tracking issue for this feature is: [#108082]

[#108082]: https://github.com/rust-lang/rust/issues/108082

------------------------
"##,
    },
    Lint {
        label: "const_raw_ptr_comparison",
        description: r##"# `const_raw_ptr_comparison`

The tracking issue for this feature is: [#53020]

[#53020]: https://github.com/rust-lang/rust/issues/53020

------------------------
"##,
    },
    Lint {
        label: "const_refs_to_cell",
        description: r##"# `const_refs_to_cell`

The tracking issue for this feature is: [#80384]

[#80384]: https://github.com/rust-lang/rust/issues/80384

------------------------
"##,
    },
    Lint {
        label: "const_refs_to_static",
        description: r##"# `const_refs_to_static`

The tracking issue for this feature is: [#119618]

[#119618]: https://github.com/rust-lang/rust/issues/119618

------------------------
"##,
    },
    Lint {
        label: "const_replace",
        description: r##"# `const_replace`

The tracking issue for this feature is: [#83164]

[#83164]: https://github.com/rust-lang/rust/issues/83164

------------------------
"##,
    },
    Lint {
        label: "const_result",
        description: r##"# `const_result`

The tracking issue for this feature is: [#82814]

[#82814]: https://github.com/rust-lang/rust/issues/82814

------------------------
"##,
    },
    Lint {
        label: "const_size_of_val",
        description: r##"# `const_size_of_val`

The tracking issue for this feature is: [#46571]

[#46571]: https://github.com/rust-lang/rust/issues/46571

------------------------
"##,
    },
    Lint {
        label: "const_size_of_val_raw",
        description: r##"# `const_size_of_val_raw`

The tracking issue for this feature is: [#46571]

[#46571]: https://github.com/rust-lang/rust/issues/46571

------------------------
"##,
    },
    Lint {
        label: "const_slice_first_last",
        description: r##"# `const_slice_first_last`

The tracking issue for this feature is: [#83570]

[#83570]: https://github.com/rust-lang/rust/issues/83570

------------------------
"##,
    },
    Lint {
        label: "const_slice_first_last_chunk",
        description: r##"# `const_slice_first_last_chunk`

The tracking issue for this feature is: [#111774]

[#111774]: https://github.com/rust-lang/rust/issues/111774

------------------------
"##,
    },
    Lint {
        label: "const_slice_flatten",
        description: r##"# `const_slice_flatten`

The tracking issue for this feature is: [#95629]

[#95629]: https://github.com/rust-lang/rust/issues/95629

------------------------
"##,
    },
    Lint {
        label: "const_slice_from_mut_ptr_range",
        description: r##"# `const_slice_from_mut_ptr_range`

The tracking issue for this feature is: [#89792]

[#89792]: https://github.com/rust-lang/rust/issues/89792

------------------------
"##,
    },
    Lint {
        label: "const_slice_from_ptr_range",
        description: r##"# `const_slice_from_ptr_range`

The tracking issue for this feature is: [#89792]

[#89792]: https://github.com/rust-lang/rust/issues/89792

------------------------
"##,
    },
    Lint {
        label: "const_slice_from_raw_parts_mut",
        description: r##"# `const_slice_from_raw_parts_mut`

The tracking issue for this feature is: [#67456]

[#67456]: https://github.com/rust-lang/rust/issues/67456

------------------------
"##,
    },
    Lint {
        label: "const_slice_from_ref",
        description: r##"# `const_slice_from_ref`

The tracking issue for this feature is: [#90206]

[#90206]: https://github.com/rust-lang/rust/issues/90206

------------------------
"##,
    },
    Lint {
        label: "const_slice_index",
        description: r##"# `const_slice_index`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_slice_split_at_mut",
        description: r##"# `const_slice_split_at_mut`

The tracking issue for this feature is: [#101804]

[#101804]: https://github.com/rust-lang/rust/issues/101804

------------------------
"##,
    },
    Lint {
        label: "const_str_from_raw_parts_mut",
        description: r##"# `const_str_from_raw_parts_mut`

The tracking issue for this feature is: [#119206]

[#119206]: https://github.com/rust-lang/rust/issues/119206

------------------------
"##,
    },
    Lint {
        label: "const_str_from_utf8",
        description: r##"# `const_str_from_utf8`

The tracking issue for this feature is: [#91006]

[#91006]: https://github.com/rust-lang/rust/issues/91006

------------------------
"##,
    },
    Lint {
        label: "const_str_from_utf8_unchecked_mut",
        description: r##"# `const_str_from_utf8_unchecked_mut`

The tracking issue for this feature is: [#91005]

[#91005]: https://github.com/rust-lang/rust/issues/91005

------------------------
"##,
    },
    Lint {
        label: "const_strict_overflow_ops",
        description: r##"# `const_strict_overflow_ops`

The tracking issue for this feature is: [#118260]

[#118260]: https://github.com/rust-lang/rust/issues/118260

------------------------
"##,
    },
    Lint {
        label: "const_swap",
        description: r##"# `const_swap`

The tracking issue for this feature is: [#83163]

[#83163]: https://github.com/rust-lang/rust/issues/83163

------------------------
"##,
    },
    Lint {
        label: "const_three_way_compare",
        description: r##"# `const_three_way_compare`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_trait_impl",
        description: r##"# `const_trait_impl`

The tracking issue for this feature is: [#67792]

[#67792]: https://github.com/rust-lang/rust/issues/67792

------------------------
"##,
    },
    Lint {
        label: "const_try",
        description: r##"# `const_try`

The tracking issue for this feature is: [#74935]

[#74935]: https://github.com/rust-lang/rust/issues/74935

------------------------
"##,
    },
    Lint {
        label: "const_type_id",
        description: r##"# `const_type_id`

The tracking issue for this feature is: [#77125]

[#77125]: https://github.com/rust-lang/rust/issues/77125

------------------------
"##,
    },
    Lint {
        label: "const_type_name",
        description: r##"# `const_type_name`

The tracking issue for this feature is: [#63084]

[#63084]: https://github.com/rust-lang/rust/issues/63084

------------------------
"##,
    },
    Lint {
        label: "const_typed_swap",
        description: r##"# `const_typed_swap`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_ub_checks",
        description: r##"# `const_ub_checks`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "const_unicode_case_lookup",
        description: r##"# `const_unicode_case_lookup`

The tracking issue for this feature is: [#101400]

[#101400]: https://github.com/rust-lang/rust/issues/101400

------------------------
"##,
    },
    Lint {
        label: "const_unsafecell_get_mut",
        description: r##"# `const_unsafecell_get_mut`

The tracking issue for this feature is: [#88836]

[#88836]: https://github.com/rust-lang/rust/issues/88836

------------------------
"##,
    },
    Lint {
        label: "const_waker",
        description: r##"# `const_waker`

The tracking issue for this feature is: [#102012]

[#102012]: https://github.com/rust-lang/rust/issues/102012

------------------------
"##,
    },
    Lint {
        label: "container_error_extra",
        description: r##"# `container_error_extra`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "context_ext",
        description: r##"# `context_ext`

The tracking issue for this feature is: [#123392]

[#123392]: https://github.com/rust-lang/rust/issues/123392

------------------------
"##,
    },
    Lint {
        label: "control_flow_enum",
        description: r##"# `control_flow_enum`

The tracking issue for this feature is: [#75744]

[#75744]: https://github.com/rust-lang/rust/issues/75744

------------------------
"##,
    },
    Lint {
        label: "convert_float_to_int",
        description: r##"# `convert_float_to_int`

The tracking issue for this feature is: [#67057]

[#67057]: https://github.com/rust-lang/rust/issues/67057

------------------------
"##,
    },
    Lint {
        label: "core_intrinsics",
        description: r##"# `core_intrinsics`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "core_io_borrowed_buf",
        description: r##"# `core_io_borrowed_buf`

The tracking issue for this feature is: [#117693]

[#117693]: https://github.com/rust-lang/rust/issues/117693

------------------------
"##,
    },
    Lint {
        label: "core_pattern_type",
        description: r##"# `core_pattern_type`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "core_pattern_types",
        description: r##"# `core_pattern_types`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "core_private_bignum",
        description: r##"# `core_private_bignum`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "core_private_diy_float",
        description: r##"# `core_private_diy_float`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "coroutine_clone",
        description: r##"# `coroutine_clone`

The tracking issue for this feature is: [#95360]

[#95360]: https://github.com/rust-lang/rust/issues/95360

------------------------
"##,
    },
    Lint {
        label: "coroutine_trait",
        description: r##"# `coroutine_trait`

The tracking issue for this feature is: [#43122]

[#43122]: https://github.com/rust-lang/rust/issues/43122

------------------------
"##,
    },
    Lint {
        label: "coroutines",
        description: r##"# `coroutines`

The tracking issue for this feature is: [#43122]

[#43122]: https://github.com/rust-lang/rust/issues/43122

------------------------

The `coroutines` feature gate in Rust allows you to define coroutine or
coroutine literals. A coroutine is a "resumable function" that syntactically
resembles a closure but compiles to much different semantics in the compiler
itself. The primary feature of a coroutine is that it can be suspended during
execution to be resumed at a later date. Coroutines use the `yield` keyword to
"return", and then the caller can `resume` a coroutine to resume execution just
after the `yield` keyword.

Coroutines are an extra-unstable feature in the compiler right now. Added in
[RFC 2033] they're mostly intended right now as a information/constraint
gathering phase. The intent is that experimentation can happen on the nightly
compiler before actual stabilization. A further RFC will be required to
stabilize coroutines and will likely contain at least a few small
tweaks to the overall design.

[RFC 2033]: https://github.com/rust-lang/rfcs/pull/2033

A syntactical example of a coroutine is:

```rust
#![feature(coroutines, coroutine_trait, stmt_expr_attributes)]

use std::ops::{Coroutine, CoroutineState};
use std::pin::Pin;

fn main() {
    let mut coroutine = #[coroutine] || {
        yield 1;
        return "foo"
    };

    match Pin::new(&mut coroutine).resume(()) {
        CoroutineState::Yielded(1) => {}
        _ => panic!("unexpected value from resume"),
    }
    match Pin::new(&mut coroutine).resume(()) {
        CoroutineState::Complete("foo") => {}
        _ => panic!("unexpected value from resume"),
    }
}
```

Coroutines are closure-like literals which are annotated with `#[coroutine]`
and can contain a `yield` statement. The
`yield` statement takes an optional expression of a value to yield out of the
coroutine. All coroutine literals implement the `Coroutine` trait in the
`std::ops` module. The `Coroutine` trait has one main method, `resume`, which
resumes execution of the coroutine at the previous suspension point.

An example of the control flow of coroutines is that the following example
prints all numbers in order:

```rust
#![feature(coroutines, coroutine_trait, stmt_expr_attributes)]

use std::ops::Coroutine;
use std::pin::Pin;

fn main() {
    let mut coroutine = #[coroutine] || {
        println!("2");
        yield;
        println!("4");
    };

    println!("1");
    Pin::new(&mut coroutine).resume(());
    println!("3");
    Pin::new(&mut coroutine).resume(());
    println!("5");
}
```

At this time the main use case of coroutines is an implementation
primitive for `async`/`await` and `gen` syntax, but coroutines
will likely be extended to other primitives in the future.
Feedback on the design and usage is always appreciated!

### The `Coroutine` trait

The `Coroutine` trait in `std::ops` currently looks like:

```rust
# #![feature(arbitrary_self_types, coroutine_trait)]
# use std::ops::CoroutineState;
# use std::pin::Pin;

pub trait Coroutine<R = ()> {
    type Yield;
    type Return;
    fn resume(self: Pin<&mut Self>, resume: R) -> CoroutineState<Self::Yield, Self::Return>;
}
```

The `Coroutine::Yield` type is the type of values that can be yielded with the
`yield` statement. The `Coroutine::Return` type is the returned type of the
coroutine. This is typically the last expression in a coroutine's definition or
any value passed to `return` in a coroutine. The `resume` function is the entry
point for executing the `Coroutine` itself.

The return value of `resume`, `CoroutineState`, looks like:

```rust
pub enum CoroutineState<Y, R> {
    Yielded(Y),
    Complete(R),
}
```

The `Yielded` variant indicates that the coroutine can later be resumed. This
corresponds to a `yield` point in a coroutine. The `Complete` variant indicates
that the coroutine is complete and cannot be resumed again. Calling `resume`
after a coroutine has returned `Complete` will likely result in a panic of the
program.

### Closure-like semantics

The closure-like syntax for coroutines alludes to the fact that they also have
closure-like semantics. Namely:

* When created, a coroutine executes no code. A closure literal does not
  actually execute any of the closure's code on construction, and similarly a
  coroutine literal does not execute any code inside the coroutine when
  constructed.

* Coroutines can capture outer variables by reference or by move, and this can
  be tweaked with the `move` keyword at the beginning of the closure. Like
  closures all coroutines will have an implicit environment which is inferred by
  the compiler. Outer variables can be moved into a coroutine for use as the
  coroutine progresses.

* Coroutine literals produce a value with a unique type which implements the
  `std::ops::Coroutine` trait. This allows actual execution of the coroutine
  through the `Coroutine::resume` method as well as also naming it in return
  types and such.

* Traits like `Send` and `Sync` are automatically implemented for a `Coroutine`
  depending on the captured variables of the environment. Unlike closures,
  coroutines also depend on variables live across suspension points. This means
  that although the ambient environment may be `Send` or `Sync`, the coroutine
  itself may not be due to internal variables live across `yield` points being
  not-`Send` or not-`Sync`. Note that coroutines do
  not implement traits like `Copy` or `Clone` automatically.

* Whenever a coroutine is dropped it will drop all captured environment
  variables.

### Coroutines as state machines

In the compiler, coroutines are currently compiled as state machines. Each
`yield` expression will correspond to a different state that stores all live
variables over that suspension point. Resumption of a coroutine will dispatch on
the current state and then execute internally until a `yield` is reached, at
which point all state is saved off in the coroutine and a value is returned.

Let's take a look at an example to see what's going on here:

```rust
#![feature(coroutines, coroutine_trait, stmt_expr_attributes)]

use std::ops::Coroutine;
use std::pin::Pin;

fn main() {
    let ret = "foo";
    let mut coroutine = #[coroutine] move || {
        yield 1;
        return ret
    };

    Pin::new(&mut coroutine).resume(());
    Pin::new(&mut coroutine).resume(());
}
```

This coroutine literal will compile down to something similar to:

```rust
#![feature(arbitrary_self_types, coroutine_trait)]

use std::ops::{Coroutine, CoroutineState};
use std::pin::Pin;

fn main() {
    let ret = "foo";
    let mut coroutine = {
        enum __Coroutine {
            Start(&'static str),
            Yield1(&'static str),
            Done,
        }

        impl Coroutine for __Coroutine {
            type Yield = i32;
            type Return = &'static str;

            fn resume(mut self: Pin<&mut Self>, resume: ()) -> CoroutineState<i32, &'static str> {
                use std::mem;
                match mem::replace(&mut *self, __Coroutine::Done) {
                    __Coroutine::Start(s) => {
                        *self = __Coroutine::Yield1(s);
                        CoroutineState::Yielded(1)
                    }

                    __Coroutine::Yield1(s) => {
                        *self = __Coroutine::Done;
                        CoroutineState::Complete(s)
                    }

                    __Coroutine::Done => {
                        panic!("coroutine resumed after completion")
                    }
                }
            }
        }

        __Coroutine::Start(ret)
    };

    Pin::new(&mut coroutine).resume(());
    Pin::new(&mut coroutine).resume(());
}
```

Notably here we can see that the compiler is generating a fresh type,
`__Coroutine` in this case. This type has a number of states (represented here
as an `enum`) corresponding to each of the conceptual states of the coroutine.
At the beginning we're closing over our outer variable `foo` and then that
variable is also live over the `yield` point, so it's stored in both states.

When the coroutine starts it'll immediately yield 1, but it saves off its state
just before it does so indicating that it has reached the yield point. Upon
resuming again we'll execute the `return ret` which returns the `Complete`
state.

Here we can also note that the `Done` state, if resumed, panics immediately as
it's invalid to resume a completed coroutine. It's also worth noting that this
is just a rough desugaring, not a normative specification for what the compiler
does.
"##,
    },
    Lint {
        label: "coverage_attribute",
        description: r##"# `coverage_attribute`

The tracking issue for this feature is: [#84605]

[#84605]: https://github.com/rust-lang/rust/issues/84605

---

The `coverage` attribute can be used to selectively disable coverage
instrumentation in an annotated function. This might be useful to:

-   Avoid instrumentation overhead in a performance critical function
-   Avoid generating coverage for a function that is not meant to be executed,
    but still target 100% coverage for the rest of the program.

## Example

```rust
#![feature(coverage_attribute)]

// `foo()` will get coverage instrumentation (by default)
fn foo() {
  // ...
}

#[coverage(off)]
fn bar() {
  // ...
}
```
"##,
    },
    Lint {
        label: "cow_is_borrowed",
        description: r##"# `cow_is_borrowed`

The tracking issue for this feature is: [#65143]

[#65143]: https://github.com/rust-lang/rust/issues/65143

------------------------
"##,
    },
    Lint {
        label: "csky_target_feature",
        description: r##"# `csky_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "cstr_bytes",
        description: r##"# `cstr_bytes`

The tracking issue for this feature is: [#112115]

[#112115]: https://github.com/rust-lang/rust/issues/112115

------------------------
"##,
    },
    Lint {
        label: "cursor_remaining",
        description: r##"# `cursor_remaining`

The tracking issue for this feature is: [#86369]

[#86369]: https://github.com/rust-lang/rust/issues/86369

------------------------
"##,
    },
    Lint {
        label: "custom_inner_attributes",
        description: r##"# `custom_inner_attributes`

The tracking issue for this feature is: [#54726]

[#54726]: https://github.com/rust-lang/rust/issues/54726

------------------------
"##,
    },
    Lint {
        label: "custom_mir",
        description: r##"# `custom_mir`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "custom_test_frameworks",
        description: r##"# `custom_test_frameworks`

The tracking issue for this feature is: [#50297]

[#50297]: https://github.com/rust-lang/rust/issues/50297

------------------------

The `custom_test_frameworks` feature allows the use of `#[test_case]` and `#![test_runner]`.
Any function, const, or static can be annotated with `#[test_case]` causing it to be aggregated (like `#[test]`)
and be passed to the test runner determined by the `#![test_runner]` crate attribute.

```rust
#![feature(custom_test_frameworks)]
#![test_runner(my_runner)]

fn my_runner(tests: &[&i32]) {
    for t in tests {
        if **t == 0 {
            println!("PASSED");
        } else {
            println!("FAILED");
        }
    }
}

#[test_case]
const WILL_PASS: i32 = 0;

#[test_case]
const WILL_FAIL: i32 = 4;
```
"##,
    },
    Lint {
        label: "deadline_api",
        description: r##"# `deadline_api`

The tracking issue for this feature is: [#46316]

[#46316]: https://github.com/rust-lang/rust/issues/46316

------------------------
"##,
    },
    Lint {
        label: "debug_closure_helpers",
        description: r##"# `debug_closure_helpers`

The tracking issue for this feature is: [#117729]

[#117729]: https://github.com/rust-lang/rust/issues/117729

------------------------
"##,
    },
    Lint {
        label: "dec2flt",
        description: r##"# `dec2flt`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "decl_macro",
        description: r##"# `decl_macro`

The tracking issue for this feature is: [#39412]

[#39412]: https://github.com/rust-lang/rust/issues/39412

------------------------
"##,
    },
    Lint {
        label: "default_type_parameter_fallback",
        description: r##"# `default_type_parameter_fallback`

The tracking issue for this feature is: [#27336]

[#27336]: https://github.com/rust-lang/rust/issues/27336

------------------------
"##,
    },
    Lint {
        label: "deprecated_safe",
        description: r##"# `deprecated_safe`

The tracking issue for this feature is: [#94978]

[#94978]: https://github.com/rust-lang/rust/issues/94978

------------------------
"##,
    },
    Lint {
        label: "deprecated_suggestion",
        description: r##"# `deprecated_suggestion`

The tracking issue for this feature is: [#94785]

[#94785]: https://github.com/rust-lang/rust/issues/94785

------------------------
"##,
    },
    Lint {
        label: "deref_patterns",
        description: r##"# `deref_patterns`

The tracking issue for this feature is: [#87121]

[#87121]: https://github.com/rust-lang/rust/issues/87121

------------------------
"##,
    },
    Lint {
        label: "deref_pure_trait",
        description: r##"# `deref_pure_trait`

The tracking issue for this feature is: [#87121]

[#87121]: https://github.com/rust-lang/rust/issues/87121

------------------------
"##,
    },
    Lint {
        label: "derive_clone_copy",
        description: r##"# `derive_clone_copy`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "derive_const",
        description: r##"# `derive_const`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "derive_eq",
        description: r##"# `derive_eq`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "derive_smart_pointer",
        description: r##"# `derive_smart_pointer`

The tracking issue for this feature is: [#123430]

[#123430]: https://github.com/rust-lang/rust/issues/123430

------------------------
"##,
    },
    Lint {
        label: "dir_entry_ext2",
        description: r##"# `dir_entry_ext2`

The tracking issue for this feature is: [#85573]

[#85573]: https://github.com/rust-lang/rust/issues/85573

------------------------
"##,
    },
    Lint {
        label: "discriminant_kind",
        description: r##"# `discriminant_kind`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "dispatch_from_dyn",
        description: r##"# `dispatch_from_dyn`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "do_not_recommend",
        description: r##"# `do_not_recommend`

The tracking issue for this feature is: [#51992]

[#51992]: https://github.com/rust-lang/rust/issues/51992

------------------------
"##,
    },
    Lint {
        label: "doc_auto_cfg",
        description: r##"# `doc_auto_cfg`

The tracking issue for this feature is: [#43781]

[#43781]: https://github.com/rust-lang/rust/issues/43781

------------------------
"##,
    },
    Lint {
        label: "doc_cfg",
        description: r##"# `doc_cfg`

The tracking issue for this feature is: [#43781]

------

The `doc_cfg` feature allows an API be documented as only available in some specific platforms.
This attribute has two effects:

1. In the annotated item's documentation, there will be a message saying "Available on
    (platform) only".

2. The item's doc-tests will only run on the specific platform.

In addition to allowing the use of the `#[doc(cfg)]` attribute, this feature enables the use of a
special conditional compilation flag, `#[cfg(doc)]`, set whenever building documentation on your
crate.

This feature was introduced as part of PR [#43348] to allow the platform-specific parts of the
standard library be documented.

```rust
#![feature(doc_cfg)]

#[cfg(any(windows, doc))]
#[doc(cfg(windows))]
/// The application's icon in the notification area (a.k.a. system tray).
///
/// # Examples
///
/// ```no_run
/// extern crate my_awesome_ui_library;
/// use my_awesome_ui_library::current_app;
/// use my_awesome_ui_library::windows::notification;
///
/// let icon = current_app().get::<notification::Icon>();
/// icon.show();
/// icon.show_message("Hello");
/// ```
pub struct Icon {
    // ...
}
```

[#43781]: https://github.com/rust-lang/rust/issues/43781
[#43348]: https://github.com/rust-lang/rust/issues/43348
"##,
    },
    Lint {
        label: "doc_cfg_hide",
        description: r##"# `doc_cfg_hide`

The tracking issue for this feature is: [#43781]

[#43781]: https://github.com/rust-lang/rust/issues/43781

------------------------
"##,
    },
    Lint {
        label: "doc_masked",
        description: r##"# `doc_masked`

The tracking issue for this feature is: [#44027]

-----

The `doc_masked` feature allows a crate to exclude types from a given crate from appearing in lists
of trait implementations. The specifics of the feature are as follows:

1. When rustdoc encounters an `extern crate` statement annotated with a `#[doc(masked)]` attribute,
   it marks the crate as being masked.

2. When listing traits a given type implements, rustdoc ensures that traits from masked crates are
   not emitted into the documentation.

3. When listing types that implement a given trait, rustdoc ensures that types from masked crates
   are not emitted into the documentation.

This feature was introduced in PR [#44026] to ensure that compiler-internal and
implementation-specific types and traits were not included in the standard library's documentation.
Such types would introduce broken links into the documentation.

[#44026]: https://github.com/rust-lang/rust/pull/44026
[#44027]: https://github.com/rust-lang/rust/pull/44027
"##,
    },
    Lint {
        label: "doc_notable_trait",
        description: r##"# `doc_notable_trait`

The tracking issue for this feature is: [#45040]

The `doc_notable_trait` feature allows the use of the `#[doc(notable_trait)]`
attribute, which will display the trait in a "Notable traits" dialog for
functions returning types that implement the trait. For example, this attribute
is applied to the `Iterator`, `Future`, `io::Read`, and `io::Write` traits in
the standard library.

You can do this on your own traits like so:

```
#![feature(doc_notable_trait)]

#[doc(notable_trait)]
pub trait MyTrait {}

pub struct MyStruct;
impl MyTrait for MyStruct {}

/// The docs for this function will have a button that displays a dialog about
/// `MyStruct` implementing `MyTrait`.
pub fn my_fn() -> MyStruct { MyStruct }
```

This feature was originally implemented in PR [#45039].

See also its documentation in [the rustdoc book][rustdoc-book-notable_trait].

[#45040]: https://github.com/rust-lang/rust/issues/45040
[#45039]: https://github.com/rust-lang/rust/pull/45039
[rustdoc-book-notable_trait]: ../../rustdoc/unstable-features.html#adding-your-trait-to-the-notable-traits-dialog
"##,
    },
    Lint {
        label: "downcast_unchecked",
        description: r##"# `downcast_unchecked`

The tracking issue for this feature is: [#90850]

[#90850]: https://github.com/rust-lang/rust/issues/90850

------------------------
"##,
    },
    Lint {
        label: "drain_keep_rest",
        description: r##"# `drain_keep_rest`

The tracking issue for this feature is: [#101122]

[#101122]: https://github.com/rust-lang/rust/issues/101122

------------------------
"##,
    },
    Lint {
        label: "dropck_eyepatch",
        description: r##"# `dropck_eyepatch`

The tracking issue for this feature is: [#34761]

[#34761]: https://github.com/rust-lang/rust/issues/34761

------------------------
"##,
    },
    Lint {
        label: "duration_constants",
        description: r##"# `duration_constants`

The tracking issue for this feature is: [#57391]

[#57391]: https://github.com/rust-lang/rust/issues/57391

------------------------
"##,
    },
    Lint {
        label: "duration_constructors",
        description: r##"# `duration_constructors`

The tracking issue for this feature is: [#120301]

[#120301]: https://github.com/rust-lang/rust/issues/120301

------------------------

Add the methods `from_mins`, `from_hours` and `from_days` to `Duration`.
"##,
    },
    Lint {
        label: "duration_consts_float",
        description: r##"# `duration_consts_float`

The tracking issue for this feature is: [#72440]

[#72440]: https://github.com/rust-lang/rust/issues/72440

------------------------
"##,
    },
    Lint {
        label: "duration_millis_float",
        description: r##"# `duration_millis_float`

The tracking issue for this feature is: [#122451]

[#122451]: https://github.com/rust-lang/rust/issues/122451

------------------------
"##,
    },
    Lint {
        label: "duration_units",
        description: r##"# `duration_units`

The tracking issue for this feature is: [#120301]

[#120301]: https://github.com/rust-lang/rust/issues/120301

------------------------
"##,
    },
    Lint {
        label: "dyn_star",
        description: r##"# `dyn_star`

The tracking issue for this feature is: [#102425]

[#102425]: https://github.com/rust-lang/rust/issues/102425

------------------------
"##,
    },
    Lint {
        label: "edition_panic",
        description: r##"# `edition_panic`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "effect_types",
        description: r##"# `effect_types`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "effects",
        description: r##"# `effects`

The tracking issue for this feature is: [#102090]

[#102090]: https://github.com/rust-lang/rust/issues/102090

------------------------
"##,
    },
    Lint {
        label: "entry_insert",
        description: r##"# `entry_insert`

The tracking issue for this feature is: [#65225]

[#65225]: https://github.com/rust-lang/rust/issues/65225

------------------------
"##,
    },
    Lint {
        label: "ermsb_target_feature",
        description: r##"# `ermsb_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "error_generic_member_access",
        description: r##"# `error_generic_member_access`

The tracking issue for this feature is: [#99301]

[#99301]: https://github.com/rust-lang/rust/issues/99301

------------------------
"##,
    },
    Lint {
        label: "error_iter",
        description: r##"# `error_iter`

The tracking issue for this feature is: [#58520]

[#58520]: https://github.com/rust-lang/rust/issues/58520

------------------------
"##,
    },
    Lint {
        label: "error_reporter",
        description: r##"# `error_reporter`

The tracking issue for this feature is: [#90172]

[#90172]: https://github.com/rust-lang/rust/issues/90172

------------------------
"##,
    },
    Lint {
        label: "error_type_id",
        description: r##"# `error_type_id`

The tracking issue for this feature is: [#60784]

[#60784]: https://github.com/rust-lang/rust/issues/60784

------------------------
"##,
    },
    Lint {
        label: "exact_size_is_empty",
        description: r##"# `exact_size_is_empty`

The tracking issue for this feature is: [#35428]

[#35428]: https://github.com/rust-lang/rust/issues/35428

------------------------
"##,
    },
    Lint {
        label: "exclusive_wrapper",
        description: r##"# `exclusive_wrapper`

The tracking issue for this feature is: [#98407]

[#98407]: https://github.com/rust-lang/rust/issues/98407

------------------------
"##,
    },
    Lint {
        label: "exhaustive_patterns",
        description: r##"# `exhaustive_patterns`

The tracking issue for this feature is: [#51085]

[#51085]: https://github.com/rust-lang/rust/issues/51085

------------------------
"##,
    },
    Lint {
        label: "exit_status_error",
        description: r##"# `exit_status_error`

The tracking issue for this feature is: [#84908]

[#84908]: https://github.com/rust-lang/rust/issues/84908

------------------------
"##,
    },
    Lint {
        label: "exitcode_exit_method",
        description: r##"# `exitcode_exit_method`

The tracking issue for this feature is: [#97100]

[#97100]: https://github.com/rust-lang/rust/issues/97100

------------------------
"##,
    },
    Lint {
        label: "explicit_tail_calls",
        description: r##"# `explicit_tail_calls`

The tracking issue for this feature is: [#112788]

[#112788]: https://github.com/rust-lang/rust/issues/112788

------------------------
"##,
    },
    Lint {
        label: "exposed_provenance",
        description: r##"# `exposed_provenance`

The tracking issue for this feature is: [#95228]

[#95228]: https://github.com/rust-lang/rust/issues/95228

------------------------
"##,
    },
    Lint {
        label: "expr_fragment_specifier_2024",
        description: r##"# `expr_fragment_specifier_2024`

The tracking issue for this feature is: [#123742]

[#123742]: https://github.com/rust-lang/rust/issues/123742

------------------------
"##,
    },
    Lint {
        label: "extend_one",
        description: r##"# `extend_one`

The tracking issue for this feature is: [#72631]

[#72631]: https://github.com/rust-lang/rust/issues/72631

------------------------
"##,
    },
    Lint {
        label: "extended_varargs_abi_support",
        description: r##"# `extended_varargs_abi_support`

The tracking issue for this feature is: [#100189]

[#100189]: https://github.com/rust-lang/rust/issues/100189

------------------------

This feature adds the possibility of using `sysv64`, `win64` or `efiapi` calling
conventions on functions with varargs.
"##,
    },
    Lint {
        label: "extern_types",
        description: r##"# `extern_types`

The tracking issue for this feature is: [#43467]

[#43467]: https://github.com/rust-lang/rust/issues/43467

------------------------
"##,
    },
    Lint {
        label: "extract_if",
        description: r##"# `extract_if`

The tracking issue for this feature is: [#43244]

[#43244]: https://github.com/rust-lang/rust/issues/43244

------------------------
"##,
    },
    Lint {
        label: "f128",
        description: r##"# `f128`

The tracking issue for this feature is: [#116909]

[#116909]: https://github.com/rust-lang/rust/issues/116909

---

Enable the `f128` type for  IEEE 128-bit floating numbers (quad precision).
"##,
    },
    Lint {
        label: "f16",
        description: r##"# `f16`

The tracking issue for this feature is: [#116909]

[#116909]: https://github.com/rust-lang/rust/issues/116909

---

Enable the `f16` type for  IEEE 16-bit floating numbers (half precision).
"##,
    },
    Lint {
        label: "fd",
        description: r##"# `fd`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "fd_read",
        description: r##"# `fd_read`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "ffi_const",
        description: r##"# `ffi_const`

The tracking issue for this feature is: [#58328]

------

The `#[ffi_const]` attribute applies clang's `const` attribute to foreign
functions declarations.

That is, `#[ffi_const]` functions shall have no effects except for its return
value, which can only depend on the values of the function parameters, and is
not affected by changes to the observable state of the program.

Applying the `#[ffi_const]` attribute to a function that violates these
requirements is undefined behaviour.

This attribute enables Rust to perform common optimizations, like sub-expression
elimination, and it can avoid emitting some calls in repeated invocations of the
function with the same argument values regardless of other operations being
performed in between these functions calls (as opposed to `#[ffi_pure]`
functions).

## Pitfalls

A `#[ffi_const]` function can only read global memory that would not affect
its return value for the whole execution of the program (e.g. immutable global
memory). `#[ffi_const]` functions are referentially-transparent and therefore
more strict than `#[ffi_pure]` functions.

A common pitfall involves applying the `#[ffi_const]` attribute to a
function that reads memory through pointer arguments which do not necessarily
point to immutable global memory.

A `#[ffi_const]` function that returns unit has no effect on the abstract
machine's state, and a `#[ffi_const]` function cannot be `#[ffi_pure]`.

A `#[ffi_const]` function must not diverge, neither via a side effect (e.g. a
call to `abort`) nor by infinite loops.

When translating C headers to Rust FFI, it is worth verifying for which targets
the `const` attribute is enabled in those headers, and using the appropriate
`cfg` macros in the Rust side to match those definitions. While the semantics of
`const` are implemented identically by many C and C++ compilers, e.g., clang,
[GCC], [ARM C/C++ compiler], [IBM ILE C/C++], etc. they are not necessarily
implemented in this way on all of them. It is therefore also worth verifying
that the semantics of the C toolchain used to compile the binary being linked
against are compatible with those of the `#[ffi_const]`.

[#58328]: https://github.com/rust-lang/rust/issues/58328
[ARM C/C++ compiler]: http://infocenter.arm.com/help/index.jsp?topic=/com.arm.doc.dui0491c/Cacgigch.html
[GCC]: https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html#index-const-function-attribute
[IBM ILE C/C++]: https://www.ibm.com/support/knowledgecenter/fr/ssw_ibm_i_71/rzarg/fn_attrib_const.htm
"##,
    },
    Lint {
        label: "ffi_pure",
        description: r##"# `ffi_pure`

The tracking issue for this feature is: [#58329]

------

The `#[ffi_pure]` attribute applies clang's `pure` attribute to foreign
functions declarations.

That is, `#[ffi_pure]` functions shall have no effects except for its return
value, which shall not change across two consecutive function calls with
the same parameters.

Applying the `#[ffi_pure]` attribute to a function that violates these
requirements is undefined behavior.

This attribute enables Rust to perform common optimizations, like sub-expression
elimination and loop optimizations. Some common examples of pure functions are
`strlen` or `memcmp`.

These optimizations are only applicable when the compiler can prove that no
program state observable by the `#[ffi_pure]` function has changed between calls
of the function, which could alter the result. See also the `#[ffi_const]`
attribute, which provides stronger guarantees regarding the allowable behavior
of a function, enabling further optimization.

## Pitfalls

A `#[ffi_pure]` function can read global memory through the function
parameters (e.g. pointers), globals, etc. `#[ffi_pure]` functions are not
referentially-transparent, and are therefore more relaxed than `#[ffi_const]`
functions.

However, accessing global memory through volatile or atomic reads can violate the
requirement that two consecutive function calls shall return the same value.

A `pure` function that returns unit has no effect on the abstract machine's
state.

A `#[ffi_pure]` function must not diverge, neither via a side effect (e.g. a
call to `abort`) nor by infinite loops.

When translating C headers to Rust FFI, it is worth verifying for which targets
the `pure` attribute is enabled in those headers, and using the appropriate
`cfg` macros in the Rust side to match those definitions. While the semantics of
`pure` are implemented identically by many C and C++ compilers, e.g., clang,
[GCC], [ARM C/C++ compiler], [IBM ILE C/C++], etc. they are not necessarily
implemented in this way on all of them. It is therefore also worth verifying
that the semantics of the C toolchain used to compile the binary being linked
against are compatible with those of the `#[ffi_pure]`.


[#58329]: https://github.com/rust-lang/rust/issues/58329
[ARM C/C++ compiler]: http://infocenter.arm.com/help/index.jsp?topic=/com.arm.doc.dui0491c/Cacigdac.html
[GCC]: https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html#index-pure-function-attribute
[IBM ILE C/C++]: https://www.ibm.com/support/knowledgecenter/fr/ssw_ibm_i_71/rzarg/fn_attrib_pure.htm
"##,
    },
    Lint {
        label: "float_gamma",
        description: r##"# `float_gamma`

The tracking issue for this feature is: [#99842]

[#99842]: https://github.com/rust-lang/rust/issues/99842

------------------------
"##,
    },
    Lint {
        label: "float_minimum_maximum",
        description: r##"# `float_minimum_maximum`

The tracking issue for this feature is: [#91079]

[#91079]: https://github.com/rust-lang/rust/issues/91079

------------------------
"##,
    },
    Lint {
        label: "float_next_up_down",
        description: r##"# `float_next_up_down`

The tracking issue for this feature is: [#91399]

[#91399]: https://github.com/rust-lang/rust/issues/91399

------------------------
"##,
    },
    Lint {
        label: "flt2dec",
        description: r##"# `flt2dec`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "fmt_helpers_for_derive",
        description: r##"# `fmt_helpers_for_derive`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "fmt_internals",
        description: r##"# `fmt_internals`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "fn_align",
        description: r##"# `fn_align`

The tracking issue for this feature is: [#82232]

[#82232]: https://github.com/rust-lang/rust/issues/82232

------------------------
"##,
    },
    Lint {
        label: "fn_delegation",
        description: r##"# `fn_delegation`

The tracking issue for this feature is: [#118212]

[#118212]: https://github.com/rust-lang/rust/issues/118212

------------------------
"##,
    },
    Lint {
        label: "fn_ptr_trait",
        description: r##"# `fn_ptr_trait`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "fn_traits",
        description: r##"# `fn_traits`

The tracking issue for this feature is [#29625]

See Also: [`unboxed_closures`](../language-features/unboxed-closures.md)

[#29625]: https://github.com/rust-lang/rust/issues/29625

----

The `fn_traits` feature allows for implementation of the [`Fn*`] traits
for creating custom closure-like types.

[`Fn*`]: ../../std/ops/trait.Fn.html

```rust
#![feature(unboxed_closures)]
#![feature(fn_traits)]

struct Adder {
    a: u32
}

impl FnOnce<(u32, )> for Adder {
    type Output = u32;
    extern "rust-call" fn call_once(self, b: (u32, )) -> Self::Output {
        self.a + b.0
    }
}

fn main() {
    let adder = Adder { a: 3 };
    assert_eq!(adder(2), 5);
}
```
"##,
    },
    Lint {
        label: "forget_unsized",
        description: r##"# `forget_unsized`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "format_args_nl",
        description: r##"# `format_args_nl`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "freeze",
        description: r##"# `freeze`

The tracking issue for this feature is: [#121675]

[#121675]: https://github.com/rust-lang/rust/issues/121675

------------------------
"##,
    },
    Lint {
        label: "freeze_impls",
        description: r##"# `freeze_impls`

The tracking issue for this feature is: [#121675]

[#121675]: https://github.com/rust-lang/rust/issues/121675

------------------------
"##,
    },
    Lint {
        label: "fundamental",
        description: r##"# `fundamental`

The tracking issue for this feature is: [#29635]

[#29635]: https://github.com/rust-lang/rust/issues/29635

------------------------
"##,
    },
    Lint {
        label: "future_join",
        description: r##"# `future_join`

The tracking issue for this feature is: [#91642]

[#91642]: https://github.com/rust-lang/rust/issues/91642

------------------------
"##,
    },
    Lint {
        label: "gen_blocks",
        description: r##"# `gen_blocks`

The tracking issue for this feature is: [#117078]

[#117078]: https://github.com/rust-lang/rust/issues/117078

------------------------
"##,
    },
    Lint {
        label: "gen_future",
        description: r##"# `gen_future`

The tracking issue for this feature is: [#50547]

[#50547]: https://github.com/rust-lang/rust/issues/50547

------------------------
"##,
    },
    Lint {
        label: "generic_arg_infer",
        description: r##"# `generic_arg_infer`

The tracking issue for this feature is: [#85077]

[#85077]: https://github.com/rust-lang/rust/issues/85077

------------------------
"##,
    },
    Lint {
        label: "generic_assert",
        description: r##"# `generic_assert`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "generic_assert_internals",
        description: r##"# `generic_assert_internals`

The tracking issue for this feature is: [#44838]

[#44838]: https://github.com/rust-lang/rust/issues/44838

------------------------
"##,
    },
    Lint {
        label: "generic_associated_types_extended",
        description: r##"# `generic_associated_types_extended`

The tracking issue for this feature is: [#95451]

[#95451]: https://github.com/rust-lang/rust/issues/95451

------------------------
"##,
    },
    Lint {
        label: "generic_const_exprs",
        description: r##"# `generic_const_exprs`

The tracking issue for this feature is: [#76560]

[#76560]: https://github.com/rust-lang/rust/issues/76560

------------------------
"##,
    },
    Lint {
        label: "generic_const_items",
        description: r##"# `generic_const_items`

The tracking issue for this feature is: [#113521]

[#113521]: https://github.com/rust-lang/rust/issues/113521

------------------------
"##,
    },
    Lint {
        label: "get_many_mut",
        description: r##"# `get_many_mut`

The tracking issue for this feature is: [#104642]

[#104642]: https://github.com/rust-lang/rust/issues/104642

------------------------
"##,
    },
    Lint {
        label: "get_mut_unchecked",
        description: r##"# `get_mut_unchecked`

The tracking issue for this feature is: [#63292]

[#63292]: https://github.com/rust-lang/rust/issues/63292

------------------------
"##,
    },
    Lint {
        label: "global_registration",
        description: r##"# `global_registration`

The tracking issue for this feature is: [#125119]

[#125119]: https://github.com/rust-lang/rust/issues/125119

------------------------
"##,
    },
    Lint {
        label: "half_open_range_patterns_in_slices",
        description: r##"# `half_open_range_patterns_in_slices`

The tracking issue for this feature is: [#67264]
It is a future part of the `exclusive_range_pattern` feature,
tracked at [#37854].

[#67264]: https://github.com/rust-lang/rust/issues/67264
[#37854]: https://github.com/rust-lang/rust/issues/37854
-----

This feature allow using top-level half-open range patterns in slices.

```rust
#![feature(half_open_range_patterns_in_slices)]

fn main() {
    let xs = [13, 1, 5, 2, 3, 1, 21, 8];
    let [a @ 3.., b @ ..3, c @ 4..6, ..] = xs else { return; };
}
```

Note that this feature is not required if the patterns are wrapped between parenthesis.

```rust
fn main() {
    let xs = [13, 1];
    let [(a @ 3..), c] = xs else { return; };
}
```
"##,
    },
    Lint {
        label: "hash_extract_if",
        description: r##"# `hash_extract_if`

The tracking issue for this feature is: [#59618]

[#59618]: https://github.com/rust-lang/rust/issues/59618

------------------------
"##,
    },
    Lint {
        label: "hash_raw_entry",
        description: r##"# `hash_raw_entry`

The tracking issue for this feature is: [#56167]

[#56167]: https://github.com/rust-lang/rust/issues/56167

------------------------
"##,
    },
    Lint {
        label: "hash_set_entry",
        description: r##"# `hash_set_entry`

The tracking issue for this feature is: [#60896]

[#60896]: https://github.com/rust-lang/rust/issues/60896

------------------------
"##,
    },
    Lint {
        label: "hasher_prefixfree_extras",
        description: r##"# `hasher_prefixfree_extras`

The tracking issue for this feature is: [#96762]

[#96762]: https://github.com/rust-lang/rust/issues/96762

------------------------
"##,
    },
    Lint {
        label: "hashmap_internals",
        description: r##"# `hashmap_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "hexagon_target_feature",
        description: r##"# `hexagon_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "hint_must_use",
        description: r##"# `hint_must_use`

The tracking issue for this feature is: [#94745]

[#94745]: https://github.com/rust-lang/rust/issues/94745

------------------------
"##,
    },
    Lint {
        label: "if_let_guard",
        description: r##"# `if_let_guard`

The tracking issue for this feature is: [#51114]

[#51114]: https://github.com/rust-lang/rust/issues/51114

------------------------
"##,
    },
    Lint {
        label: "impl_trait_in_assoc_type",
        description: r##"# `impl_trait_in_assoc_type`

The tracking issue for this feature is: [#63063]

[#63063]: https://github.com/rust-lang/rust/issues/63063

------------------------
"##,
    },
    Lint {
        label: "impl_trait_in_fn_trait_return",
        description: r##"# `impl_trait_in_fn_trait_return`

The tracking issue for this feature is: [#99697]

[#99697]: https://github.com/rust-lang/rust/issues/99697

------------------------
"##,
    },
    Lint {
        label: "inherent_associated_types",
        description: r##"# `inherent_associated_types`

The tracking issue for this feature is: [#8995]

[#8995]: https://github.com/rust-lang/rust/issues/8995

------------------------
"##,
    },
    Lint {
        label: "inline_const_pat",
        description: r##"# `inline_const_pat`

The tracking issue for this feature is: [#76001]

------

This feature allows you to use inline constant expressions in pattern position:

```rust
#![feature(inline_const_pat)]

const fn one() -> i32 { 1 }

let some_int = 3;
match some_int {
    const { 1 + 2 } => println!("Matched 1 + 2"),
    const { one() } => println!("Matched const fn returning 1"),
    _ => println!("Didn't match anything :("),
}
```

[#76001]: https://github.com/rust-lang/rust/issues/76001
"##,
    },
    Lint {
        label: "inplace_iteration",
        description: r##"# `inplace_iteration`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "int_roundings",
        description: r##"# `int_roundings`

The tracking issue for this feature is: [#88581]

[#88581]: https://github.com/rust-lang/rust/issues/88581

------------------------
"##,
    },
    Lint {
        label: "integer_atomics",
        description: r##"# `integer_atomics`

The tracking issue for this feature is: [#99069]

[#99069]: https://github.com/rust-lang/rust/issues/99069

------------------------
"##,
    },
    Lint {
        label: "integer_sign_cast",
        description: r##"# `integer_sign_cast`

The tracking issue for this feature is: [#125882]

[#125882]: https://github.com/rust-lang/rust/issues/125882

------------------------
"##,
    },
    Lint {
        label: "internal_impls_macro",
        description: r##"# `internal_impls_macro`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "internal_output_capture",
        description: r##"# `internal_output_capture`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "intra_doc_pointers",
        description: r##"# `intra-doc-pointers`

The tracking issue for this feature is: [#80896]

[#80896]: https://github.com/rust-lang/rust/issues/80896

------------------------

Rustdoc does not currently allow disambiguating between `*const` and `*mut`, and
raw pointers in intra-doc links are unstable until it does.

```rust
#![feature(intra_doc_pointers)]
//! [pointer::add]
```
"##,
    },
    Lint {
        label: "intrinsics",
        description: r##"# `intrinsics`

The tracking issue for this feature is: None.

Intrinsics are rarely intended to be stable directly, but are usually
exported in some sort of stable manner. Prefer using the stable interfaces to
the intrinsic directly when you can.

------------------------


## Intrinsics with fallback logic

Many intrinsics can be written in pure rust, albeit inefficiently or without supporting
some features that only exist on some backends. Backends can simply not implement those
intrinsics without causing any code miscompilations or failures to compile.
All intrinsic fallback bodies are automatically made cross-crate inlineable (like `#[inline]`)
by the codegen backend, but not the MIR inliner.

```rust
#![feature(rustc_attrs)]
#![allow(internal_features)]

#[rustc_intrinsic]
const unsafe fn const_deallocate(_ptr: *mut u8, _size: usize, _align: usize) {}
```

Since these are just regular functions, it is perfectly ok to create the intrinsic twice:

```rust
#![feature(rustc_attrs)]
#![allow(internal_features)]

#[rustc_intrinsic]
const unsafe fn const_deallocate(_ptr: *mut u8, _size: usize, _align: usize) {}

mod foo {
    #[rustc_intrinsic]
    const unsafe fn const_deallocate(_ptr: *mut u8, _size: usize, _align: usize) {
        panic!("noisy const dealloc")
    }
}

```

The behaviour on backends that override the intrinsic is exactly the same. On other
backends, the intrinsic behaviour depends on which implementation is called, just like
with any regular function.

## Intrinsics lowered to MIR instructions

Various intrinsics have native MIR operations that they correspond to. Instead of requiring
backends to implement both the intrinsic and the MIR operation, the `lower_intrinsics` pass
will convert the calls to the MIR operation. Backends do not need to know about these intrinsics
at all. These intrinsics only make sense without a body, and can either be declared as a "rust-intrinsic"
or as a `#[rustc_intrinsic]`. The body is never used, as calls to the intrinsic do not exist
anymore after MIR analyses.

## Intrinsics without fallback logic

These must be implemented by all backends.

### `#[rustc_intrinsic]` declarations

These are written like intrinsics with fallback bodies, but the body is irrelevant.
Use `loop {}` for the body or call the intrinsic recursively and add
`#[rustc_intrinsic_must_be_overridden]` to the function to ensure that backends don't
invoke the body.

### Legacy extern ABI based intrinsics

These are imported as if they were FFI functions, with the special
`rust-intrinsic` ABI. For example, if one was in a freestanding
context, but wished to be able to `transmute` between types, and
perform efficient pointer arithmetic, one would import those functions
via a declaration like

```rust
#![feature(intrinsics)]
#![allow(internal_features)]
# fn main() {}

extern "rust-intrinsic" {
    fn transmute<T, U>(x: T) -> U;

    fn arith_offset<T>(dst: *const T, offset: isize) -> *const T;
}
```

As with any other FFI functions, these are by default always `unsafe` to call.
You can add `#[rustc_safe_intrinsic]` to the intrinsic to make it safe to call.
"##,
    },
    Lint {
        label: "io_error_more",
        description: r##"# `io_error_more`

The tracking issue for this feature is: [#86442]

[#86442]: https://github.com/rust-lang/rust/issues/86442

------------------------
"##,
    },
    Lint {
        label: "io_error_uncategorized",
        description: r##"# `io_error_uncategorized`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "io_slice_advance",
        description: r##"# `io_slice_advance`

The tracking issue for this feature is: [#62726]

[#62726]: https://github.com/rust-lang/rust/issues/62726

------------------------
"##,
    },
    Lint {
        label: "ip",
        description: r##"# `ip`

The tracking issue for this feature is: [#27709]

[#27709]: https://github.com/rust-lang/rust/issues/27709

------------------------
"##,
    },
    Lint {
        label: "is_ascii_octdigit",
        description: r##"# `is_ascii_octdigit`

The tracking issue for this feature is: [#101288]

[#101288]: https://github.com/rust-lang/rust/issues/101288

------------------------
"##,
    },
    Lint {
        label: "is_none_or",
        description: r##"# `is_none_or`

The tracking issue for this feature is: [#126383]

[#126383]: https://github.com/rust-lang/rust/issues/126383

------------------------
"##,
    },
    Lint {
        label: "is_riscv_feature_detected",
        description: r##"# `is_riscv_feature_detected`

The tracking issue for this feature is: [#111192]

[#111192]: https://github.com/rust-lang/rust/issues/111192

------------------------
"##,
    },
    Lint {
        label: "is_sorted",
        description: r##"# `is_sorted`

The tracking issue for this feature is: [#53485]

[#53485]: https://github.com/rust-lang/rust/issues/53485

------------------------

Add the methods `is_sorted`, `is_sorted_by` and `is_sorted_by_key` to `[T]`;
add the methods `is_sorted`, `is_sorted_by` and `is_sorted_by_key` to
`Iterator`.
"##,
    },
    Lint {
        label: "is_val_statically_known",
        description: r##"# `is_val_statically_known`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "isqrt",
        description: r##"# `isqrt`

The tracking issue for this feature is: [#116226]

[#116226]: https://github.com/rust-lang/rust/issues/116226

------------------------
"##,
    },
    Lint {
        label: "iter_advance_by",
        description: r##"# `iter_advance_by`

The tracking issue for this feature is: [#77404]

[#77404]: https://github.com/rust-lang/rust/issues/77404

------------------------
"##,
    },
    Lint {
        label: "iter_array_chunks",
        description: r##"# `iter_array_chunks`

The tracking issue for this feature is: [#100450]

[#100450]: https://github.com/rust-lang/rust/issues/100450

------------------------
"##,
    },
    Lint {
        label: "iter_chain",
        description: r##"# `iter_chain`

The tracking issue for this feature is: [#125964]

[#125964]: https://github.com/rust-lang/rust/issues/125964

------------------------
"##,
    },
    Lint {
        label: "iter_collect_into",
        description: r##"# `iter_collect_into`

The tracking issue for this feature is: [#94780]

[#94780]: https://github.com/rust-lang/rust/issues/94780

------------------------
"##,
    },
    Lint {
        label: "iter_from_coroutine",
        description: r##"# `iter_from_coroutine`

The tracking issue for this feature is: [#43122]

[#43122]: https://github.com/rust-lang/rust/issues/43122

------------------------
"##,
    },
    Lint {
        label: "iter_intersperse",
        description: r##"# `iter_intersperse`

The tracking issue for this feature is: [#79524]

[#79524]: https://github.com/rust-lang/rust/issues/79524

------------------------
"##,
    },
    Lint {
        label: "iter_is_partitioned",
        description: r##"# `iter_is_partitioned`

The tracking issue for this feature is: [#62544]

[#62544]: https://github.com/rust-lang/rust/issues/62544

------------------------
"##,
    },
    Lint {
        label: "iter_map_windows",
        description: r##"# `iter_map_windows`

The tracking issue for this feature is: [#87155]

[#87155]: https://github.com/rust-lang/rust/issues/87155

------------------------
"##,
    },
    Lint {
        label: "iter_next_chunk",
        description: r##"# `iter_next_chunk`

The tracking issue for this feature is: [#98326]

[#98326]: https://github.com/rust-lang/rust/issues/98326

------------------------
"##,
    },
    Lint {
        label: "iter_order_by",
        description: r##"# `iter_order_by`

The tracking issue for this feature is: [#64295]

[#64295]: https://github.com/rust-lang/rust/issues/64295

------------------------
"##,
    },
    Lint {
        label: "iter_partition_in_place",
        description: r##"# `iter_partition_in_place`

The tracking issue for this feature is: [#62543]

[#62543]: https://github.com/rust-lang/rust/issues/62543

------------------------
"##,
    },
    Lint {
        label: "iter_repeat_n",
        description: r##"# `iter_repeat_n`

The tracking issue for this feature is: [#104434]

[#104434]: https://github.com/rust-lang/rust/issues/104434

------------------------
"##,
    },
    Lint {
        label: "iterator_try_collect",
        description: r##"# `iterator_try_collect`

The tracking issue for this feature is: [#94047]

[#94047]: https://github.com/rust-lang/rust/issues/94047

------------------------
"##,
    },
    Lint {
        label: "iterator_try_reduce",
        description: r##"# `iterator_try_reduce`

The tracking issue for this feature is: [#87053]

[#87053]: https://github.com/rust-lang/rust/issues/87053

------------------------
"##,
    },
    Lint {
        label: "junction_point",
        description: r##"# `junction_point`

The tracking issue for this feature is: [#121709]

[#121709]: https://github.com/rust-lang/rust/issues/121709

------------------------
"##,
    },
    Lint {
        label: "lahfsahf_target_feature",
        description: r##"# `lahfsahf_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "lang_items",
        description: r##"# `lang_items`

The tracking issue for this feature is: None.

------------------------

The `rustc` compiler has certain pluggable operations, that is,
functionality that isn't hard-coded into the language, but is
implemented in libraries, with a special marker to tell the compiler
it exists. The marker is the attribute `#[lang = "..."]` and there are
various different values of `...`, i.e. various different 'lang
items'. Most of them can only be defined once.

Lang items are loaded lazily by the compiler; e.g. if one never uses `Box`
then there is no need to define a function for `exchange_malloc`.
`rustc` will emit an error when an item is needed but not found in the current
crate or any that it depends on.

Some features provided by lang items:

- overloadable operators via traits: the traits corresponding to the
  `==`, `<`, dereferencing (`*`) and `+` (etc.) operators are all
  marked with lang items; those specific four are `eq`, `partial_ord`,
  `deref`/`deref_mut`, and `add` respectively.
- panicking: the `panic` and `panic_impl` lang items, among others.
- stack unwinding: the lang item `eh_personality` is a function used by the
  failure mechanisms of the compiler. This is often mapped to GCC's personality
  function (see the [`std` implementation][personality] for more information),
  but programs which don't trigger a panic can be assured that this function is
  never called. Additionally, a `eh_catch_typeinfo` static is needed for certain
  targets which implement Rust panics on top of C++ exceptions.
- the traits in `core::marker` used to indicate types of
  various kinds; e.g. lang items `sized`, `sync` and `copy`.
- memory allocation, see below.

Most lang items are defined by `core`, but if you're trying to build
an executable without the `std` crate, you might run into the need
for lang item definitions.

[personality]: https://github.com/rust-lang/rust/blob/master/library/std/src/sys/personality/gcc.rs

## Example: Implementing a `Box`

`Box` pointers require two lang items: one for the type itself and one for
allocation. A freestanding program that uses the `Box` sugar for dynamic
allocations via `malloc` and `free`:

```rust,ignore (libc-is-finicky)
#![feature(lang_items, start, core_intrinsics, rustc_private, panic_unwind, rustc_attrs)]
#![allow(internal_features)]
#![no_std]

extern crate libc;
extern crate unwind;

use core::ffi::c_void;
use core::intrinsics;
use core::panic::PanicInfo;
use core::ptr::NonNull;

pub struct Global; // the global allocator
struct Unique<T>(NonNull<T>);

#[lang = "owned_box"]
pub struct Box<T, A = Global>(Unique<T>, A);

impl<T> Box<T> {
    pub fn new(x: T) -> Self {
        #[rustc_box]
        Box::new(x)
    }
}

impl<T, A> Drop for Box<T, A> {
    fn drop(&mut self) {
        unsafe {
            libc::free(self.0.0.as_ptr() as *mut c_void);
        }
    }
}

#[lang = "exchange_malloc"]
unsafe fn allocate(size: usize, _align: usize) -> *mut u8 {
    let p = libc::malloc(size) as *mut u8;

    // Check if `malloc` failed:
    if p.is_null() {
        intrinsics::abort();
    }

    p
}

#[start]
fn main(_argc: isize, _argv: *const *const u8) -> isize {
    let _x = Box::new(1);

    0
}

#[lang = "eh_personality"]
fn rust_eh_personality() {}

#[panic_handler]
fn panic_handler(_info: &PanicInfo) -> ! { intrinsics::abort() }
```

Note the use of `abort`: the `exchange_malloc` lang item is assumed to
return a valid pointer, and so needs to do the check internally.

## List of all language items

An up-to-date list of all language items can be found [here] in the compiler code.

[here]: https://github.com/rust-lang/rust/blob/master/compiler/rustc_hir/src/lang_items.rs
"##,
    },
    Lint {
        label: "large_assignments",
        description: r##"# `large_assignments`

The tracking issue for this feature is: [#83518]

[#83518]: https://github.com/rust-lang/rust/issues/83518

------------------------
"##,
    },
    Lint {
        label: "layout_for_ptr",
        description: r##"# `layout_for_ptr`

The tracking issue for this feature is: [#69835]

[#69835]: https://github.com/rust-lang/rust/issues/69835

------------------------
"##,
    },
    Lint {
        label: "lazy_cell_consume",
        description: r##"# `lazy_cell_consume`

The tracking issue for this feature is: [#125623]

[#125623]: https://github.com/rust-lang/rust/issues/125623

------------------------
"##,
    },
    Lint {
        label: "lazy_type_alias",
        description: r##"# `lazy_type_alias`

The tracking issue for this feature is: [#112792]

[#112792]: https://github.com/rust-lang/rust/issues/112792

------------------------
"##,
    },
    Lint {
        label: "let_chains",
        description: r##"# `let_chains`

The tracking issue for this feature is: [#53667]

[#53667]: https://github.com/rust-lang/rust/issues/53667

------------------------
"##,
    },
    Lint {
        label: "liballoc_internals",
        description: r##"# `liballoc_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "libstd_sys_internals",
        description: r##"# `libstd_sys_internals`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "lifetime_capture_rules_2024",
        description: r##"# `lifetime_capture_rules_2024`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "link_arg_attribute",
        description: r##"# `link_arg_attribute`

The tracking issue for this feature is: [#99427]

------

The `link_arg_attribute` feature allows passing arguments into the linker
from inside of the source code. Order is preserved for link attributes as
they were defined on a single extern block:

```rust,no_run
#![feature(link_arg_attribute)]

#[link(kind = "link-arg", name = "--start-group")]
#[link(kind = "static", name = "c")]
#[link(kind = "static", name = "gcc")]
#[link(kind = "link-arg", name = "--end-group")]
extern "C" {}
```

[#99427]: https://github.com/rust-lang/rust/issues/99427
"##,
    },
    Lint {
        label: "link_cfg",
        description: r##"# `link_cfg`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "link_llvm_intrinsics",
        description: r##"# `link_llvm_intrinsics`

The tracking issue for this feature is: [#29602]

[#29602]: https://github.com/rust-lang/rust/issues/29602

------------------------
"##,
    },
    Lint {
        label: "linkage",
        description: r##"# `linkage`

The tracking issue for this feature is: [#29603]

[#29603]: https://github.com/rust-lang/rust/issues/29603

------------------------
"##,
    },
    Lint {
        label: "linked_list_cursors",
        description: r##"# `linked_list_cursors`

The tracking issue for this feature is: [#58533]

[#58533]: https://github.com/rust-lang/rust/issues/58533

------------------------
"##,
    },
    Lint {
        label: "linked_list_remove",
        description: r##"# `linked_list_remove`

The tracking issue for this feature is: [#69210]

[#69210]: https://github.com/rust-lang/rust/issues/69210

------------------------
"##,
    },
    Lint {
        label: "linked_list_retain",
        description: r##"# `linked_list_retain`

The tracking issue for this feature is: [#114135]

[#114135]: https://github.com/rust-lang/rust/issues/114135

------------------------
"##,
    },
    Lint {
        label: "linux_pidfd",
        description: r##"# `linux_pidfd`

The tracking issue for this feature is: [#82971]

[#82971]: https://github.com/rust-lang/rust/issues/82971

------------------------
"##,
    },
    Lint {
        label: "local_waker",
        description: r##"# `local_waker`

The tracking issue for this feature is: [#118959]

[#118959]: https://github.com/rust-lang/rust/issues/118959

------------------------
"##,
    },
    Lint {
        label: "log_syntax",
        description: r##"# `log_syntax`

The tracking issue for this feature is: [#29598]

[#29598]: https://github.com/rust-lang/rust/issues/29598

------------------------
"##,
    },
    Lint {
        label: "loongarch_target_feature",
        description: r##"# `loongarch_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "macro_metavar_expr",
        description: r##"# `macro_metavar_expr`

The tracking issue for this feature is: [#83527]

[#83527]: https://github.com/rust-lang/rust/issues/83527

------------------------
"##,
    },
    Lint {
        label: "macro_metavar_expr_concat",
        description: r##"# `macro_metavar_expr_concat`

The tracking issue for this feature is: [#124225]

[#124225]: https://github.com/rust-lang/rust/issues/124225

------------------------
"##,
    },
    Lint {
        label: "map_entry_replace",
        description: r##"# `map_entry_replace`

The tracking issue for this feature is: [#44286]

[#44286]: https://github.com/rust-lang/rust/issues/44286

------------------------
"##,
    },
    Lint {
        label: "map_many_mut",
        description: r##"# `map_many_mut`

The tracking issue for this feature is: [#97601]

[#97601]: https://github.com/rust-lang/rust/issues/97601

------------------------
"##,
    },
    Lint {
        label: "map_try_insert",
        description: r##"# `map_try_insert`

The tracking issue for this feature is: [#82766]

[#82766]: https://github.com/rust-lang/rust/issues/82766

------------------------
"##,
    },
    Lint {
        label: "mapped_lock_guards",
        description: r##"# `mapped_lock_guards`

The tracking issue for this feature is: [#117108]

[#117108]: https://github.com/rust-lang/rust/issues/117108

------------------------
"##,
    },
    Lint {
        label: "marker_trait_attr",
        description: r##"# `marker_trait_attr`

The tracking issue for this feature is: [#29864]

[#29864]: https://github.com/rust-lang/rust/issues/29864

------------------------

Normally, Rust keeps you from adding trait implementations that could
overlap with each other, as it would be ambiguous which to use.  This
feature, however, carves out an exception to that rule: a trait can
opt-in to having overlapping implementations, at the cost that those
implementations are not allowed to override anything (and thus the
trait itself cannot have any associated items, as they're pointless
when they'd need to do the same thing for every type anyway).

```rust
#![feature(marker_trait_attr)]

#[marker] trait CheapToClone: Clone {}

impl<T: Copy> CheapToClone for T {}

// These could potentially overlap with the blanket implementation above,
// so are only allowed because CheapToClone is a marker trait.
impl<T: CheapToClone, U: CheapToClone> CheapToClone for (T, U) {}
impl<T: CheapToClone> CheapToClone for std::ops::Range<T> {}

fn cheap_clone<T: CheapToClone>(t: T) -> T {
    t.clone()
}
```

This is expected to replace the unstable `overlapping_marker_traits`
feature, which applied to all empty traits (without needing an opt-in).
"##,
    },
    Lint {
        label: "maybe_uninit_array_assume_init",
        description: r##"# `maybe_uninit_array_assume_init`

The tracking issue for this feature is: [#96097]

[#96097]: https://github.com/rust-lang/rust/issues/96097

------------------------
"##,
    },
    Lint {
        label: "maybe_uninit_as_bytes",
        description: r##"# `maybe_uninit_as_bytes`

The tracking issue for this feature is: [#93092]

[#93092]: https://github.com/rust-lang/rust/issues/93092

------------------------
"##,
    },
    Lint {
        label: "maybe_uninit_fill",
        description: r##"# `maybe_uninit_fill`

The tracking issue for this feature is: [#117428]

[#117428]: https://github.com/rust-lang/rust/issues/117428

------------------------
"##,
    },
    Lint {
        label: "maybe_uninit_slice",
        description: r##"# `maybe_uninit_slice`

The tracking issue for this feature is: [#63569]

[#63569]: https://github.com/rust-lang/rust/issues/63569

------------------------
"##,
    },
    Lint {
        label: "maybe_uninit_uninit_array",
        description: r##"# `maybe_uninit_uninit_array`

The tracking issue for this feature is: [#96097]

[#96097]: https://github.com/rust-lang/rust/issues/96097

------------------------
"##,
    },
    Lint {
        label: "maybe_uninit_uninit_array_transpose",
        description: r##"# `maybe_uninit_uninit_array_transpose`

The tracking issue for this feature is: [#96097]

[#96097]: https://github.com/rust-lang/rust/issues/96097

------------------------
"##,
    },
    Lint {
        label: "maybe_uninit_write_slice",
        description: r##"# `maybe_uninit_write_slice`

The tracking issue for this feature is: [#79995]

[#79995]: https://github.com/rust-lang/rust/issues/79995

------------------------
"##,
    },
    Lint {
        label: "mem_copy_fn",
        description: r##"# `mem_copy_fn`

The tracking issue for this feature is: [#98262]

[#98262]: https://github.com/rust-lang/rust/issues/98262

------------------------
"##,
    },
    Lint {
        label: "min_exhaustive_patterns",
        description: r##"# `min_exhaustive_patterns`

The tracking issue for this feature is: [#119612]

[#119612]: https://github.com/rust-lang/rust/issues/119612

------------------------
"##,
    },
    Lint {
        label: "min_specialization",
        description: r##"# `min_specialization`

The tracking issue for this feature is: [#31844]

[#31844]: https://github.com/rust-lang/rust/issues/31844

------------------------
"##,
    },
    Lint {
        label: "mips_target_feature",
        description: r##"# `mips_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "more_float_constants",
        description: r##"# `more_float_constants`

The tracking issue for this feature is: [#103883]

[#103883]: https://github.com/rust-lang/rust/issues/103883

------------------------
"##,
    },
    Lint {
        label: "more_qualified_paths",
        description: r##"# `more_qualified_paths`

The `more_qualified_paths` feature can be used in order to enable the
use of qualified paths in patterns.

## Example

```rust
#![feature(more_qualified_paths)]

fn main() {
    // destructure through a qualified path
    let <Foo as A>::Assoc { br } = StructStruct { br: 2 };
}

struct StructStruct {
    br: i8,
}

struct Foo;

trait A {
    type Assoc;
}

impl A for Foo {
    type Assoc = StructStruct;
}
```
"##,
    },
    Lint {
        label: "multiple_supertrait_upcastable",
        description: r##"# `multiple_supertrait_upcastable`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "must_not_suspend",
        description: r##"# `must_not_suspend`

The tracking issue for this feature is: [#83310]

[#83310]: https://github.com/rust-lang/rust/issues/83310

------------------------
"##,
    },
    Lint {
        label: "mut_ref",
        description: r##"# `mut_ref`

The tracking issue for this feature is: [#123076]

[#123076]: https://github.com/rust-lang/rust/issues/123076

------------------------
"##,
    },
    Lint {
        label: "naked_functions",
        description: r##"# `naked_functions`

The tracking issue for this feature is: [#90957]

[#90957]: https://github.com/rust-lang/rust/issues/90957

------------------------
"##,
    },
    Lint {
        label: "native_link_modifiers_as_needed",
        description: r##"# `native_link_modifiers_as_needed`

The tracking issue for this feature is: [#81490]

[#81490]: https://github.com/rust-lang/rust/issues/81490

------------------------

The `native_link_modifiers_as_needed` feature allows you to use the `as-needed` modifier.

`as-needed` is only compatible with the `dynamic` and `framework` linking kinds. Using any other kind will result in a compiler error.

`+as-needed` means that the library will be actually linked only if it satisfies some undefined symbols at the point at which it is specified on the command line, making it similar to static libraries in this regard.

This modifier translates to `--as-needed` for ld-like linkers, and to `-dead_strip_dylibs` / `-needed_library` / `-needed_framework` for ld64.
The modifier does nothing for linkers that don't support it (e.g. `link.exe`).

The default for this modifier is unclear, some targets currently specify it as `+as-needed`, some do not. We may want to try making `+as-needed` a default for all targets.
"##,
    },
    Lint {
        label: "needs_panic_runtime",
        description: r##"# `needs_panic_runtime`

The tracking issue for this feature is: [#32837]

[#32837]: https://github.com/rust-lang/rust/issues/32837

------------------------
"##,
    },
    Lint {
        label: "negative_bounds",
        description: r##"# `negative_bounds`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "negative_impls",
        description: r##"# `negative_impls`

The tracking issue for this feature is [#68318].

[#68318]: https://github.com/rust-lang/rust/issues/68318

----

With the feature gate `negative_impls`, you can write negative impls as well as positive ones:

```rust
#![feature(negative_impls)]
trait DerefMut { }
impl<T: ?Sized> !DerefMut for &T { }
```

Negative impls indicate a semver guarantee that the given trait will not be implemented for the given types. Negative impls play an additional purpose for auto traits, described below.

Negative impls have the following characteristics:

* They do not have any items.
* They must obey the orphan rules as if they were a positive impl.
* They cannot "overlap" with any positive impls.

## Semver interaction

It is a breaking change to remove a negative impl. Negative impls are a commitment not to implement the given trait for the named types.

## Orphan and overlap rules

Negative impls must obey the same orphan rules as a positive impl. This implies you cannot add a negative impl for types defined in upstream crates and so forth.

Similarly, negative impls cannot overlap with positive impls, again using the same "overlap" check that we ordinarily use to determine if two impls overlap. (Note that positive impls typically cannot overlap with one another either, except as permitted by specialization.)

## Interaction with auto traits

Declaring a negative impl `impl !SomeAutoTrait for SomeType` for an
auto-trait serves two purposes:

* as with any trait, it declares that `SomeType` will never implement `SomeAutoTrait`;
* it disables the automatic `SomeType: SomeAutoTrait` impl that would otherwise have been generated.

Note that, at present, there is no way to indicate that a given type
does not implement an auto trait *but that it may do so in the
future*. For ordinary types, this is done by simply not declaring any
impl at all, but that is not an option for auto traits. A workaround
is that one could embed a marker type as one of the fields, where the
marker type is `!AutoTrait`.

## Immediate uses

Negative impls are used to declare that `&T: !DerefMut`  and `&mut T: !Clone`, as required to fix the soundness of `Pin` described in [#66544](https://github.com/rust-lang/rust/issues/66544).

This serves two purposes:

* For proving the correctness of unsafe code, we can use that impl as evidence that no `DerefMut` or `Clone` impl exists.
* It prevents downstream crates from creating such impls.
"##,
    },
    Lint {
        label: "never_patterns",
        description: r##"# `never_patterns`

The tracking issue for this feature is: [#118155]

[#118155]: https://github.com/rust-lang/rust/issues/118155

------------------------
"##,
    },
    Lint {
        label: "never_type",
        description: r##"# `never_type`

The tracking issue for this feature is: [#35121]

[#35121]: https://github.com/rust-lang/rust/issues/35121

------------------------
"##,
    },
    Lint {
        label: "never_type_fallback",
        description: r##"# `never_type_fallback`

The tracking issue for this feature is: [#65992]

[#65992]: https://github.com/rust-lang/rust/issues/65992

------------------------
"##,
    },
    Lint {
        label: "new_range_api",
        description: r##"# `new_range_api`

The tracking issue for this feature is: [#125687]

[#125687]: https://github.com/rust-lang/rust/issues/125687

------------------------
"##,
    },
    Lint {
        label: "new_uninit",
        description: r##"# `new_uninit`

The tracking issue for this feature is: [#63291]

[#63291]: https://github.com/rust-lang/rust/issues/63291

------------------------
"##,
    },
    Lint {
        label: "no_core",
        description: r##"# `no_core`

The tracking issue for this feature is: [#29639]

[#29639]: https://github.com/rust-lang/rust/issues/29639

------------------------
"##,
    },
    Lint {
        label: "no_sanitize",
        description: r##"# `no_sanitize`

The tracking issue for this feature is: [#39699]

[#39699]: https://github.com/rust-lang/rust/issues/39699

------------------------

The `no_sanitize` attribute can be used to selectively disable sanitizer
instrumentation in an annotated function. This might be useful to: avoid
instrumentation overhead in a performance critical function, or avoid
instrumenting code that contains constructs unsupported by given sanitizer.

The precise effect of this annotation depends on particular sanitizer in use.
For example, with `no_sanitize(thread)`, the thread sanitizer will no longer
instrument non-atomic store / load operations, but it will instrument atomic
operations to avoid reporting false positives and provide meaning full stack
traces.

## Examples

``` rust
#![feature(no_sanitize)]

#[no_sanitize(address)]
fn foo() {
  // ...
}
```
"##,
    },
    Lint {
        label: "non_exhaustive_omitted_patterns_lint",
        description: r##"# `non_exhaustive_omitted_patterns_lint`

The tracking issue for this feature is: [#89554]

[#89554]: https://github.com/rust-lang/rust/issues/89554

------------------------
"##,
    },
    Lint {
        label: "non_lifetime_binders",
        description: r##"# `non_lifetime_binders`

The tracking issue for this feature is: [#108185]

[#108185]: https://github.com/rust-lang/rust/issues/108185

------------------------
"##,
    },
    Lint {
        label: "non_zero_count_ones",
        description: r##"# `non_zero_count_ones`

The tracking issue for this feature is: [#120287]

[#120287]: https://github.com/rust-lang/rust/issues/120287

------------------------
"##,
    },
    Lint {
        label: "nonzero_from_mut",
        description: r##"# `nonzero_from_mut`

The tracking issue for this feature is: [#106290]

[#106290]: https://github.com/rust-lang/rust/issues/106290

------------------------
"##,
    },
    Lint {
        label: "nonzero_internals",
        description: r##"# `nonzero_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "nonzero_ops",
        description: r##"# `nonzero_ops`

The tracking issue for this feature is: [#84186]

[#84186]: https://github.com/rust-lang/rust/issues/84186

------------------------
"##,
    },
    Lint {
        label: "noop_waker",
        description: r##"# `noop_waker`

The tracking issue for this feature is: [#98286]

[#98286]: https://github.com/rust-lang/rust/issues/98286

------------------------
"##,
    },
    Lint {
        label: "num_midpoint",
        description: r##"# `num_midpoint`

The tracking issue for this feature is: [#110840]

[#110840]: https://github.com/rust-lang/rust/issues/110840

------------------------
"##,
    },
    Lint {
        label: "numfmt",
        description: r##"# `numfmt`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "object_safe_for_dispatch",
        description: r##"# `object_safe_for_dispatch`

The tracking issue for this feature is: [#43561]

[#43561]: https://github.com/rust-lang/rust/issues/43561

------------------------
"##,
    },
    Lint {
        label: "offset_of_enum",
        description: r##"# `offset_of_enum`

The tracking issue for this feature is: [#120141]

[#120141]: https://github.com/rust-lang/rust/issues/120141

------------------------
"##,
    },
    Lint {
        label: "offset_of_nested",
        description: r##"# `offset_of_nested`

The tracking issue for this feature is: [#120140]

[#120140]: https://github.com/rust-lang/rust/issues/120140

------------------------
"##,
    },
    Lint {
        label: "offset_of_slice",
        description: r##"# `offset_of_slice`

The tracking issue for this feature is: [#126151]

[#126151]: https://github.com/rust-lang/rust/issues/126151

------------------------
"##,
    },
    Lint {
        label: "omit_gdb_pretty_printer_section",
        description: r##"# `omit_gdb_pretty_printer_section`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "once_cell_get_mut",
        description: r##"# `once_cell_get_mut`

The tracking issue for this feature is: [#121641]

[#121641]: https://github.com/rust-lang/rust/issues/121641

------------------------
"##,
    },
    Lint {
        label: "once_cell_try",
        description: r##"# `once_cell_try`

The tracking issue for this feature is: [#109737]

[#109737]: https://github.com/rust-lang/rust/issues/109737

------------------------
"##,
    },
    Lint {
        label: "once_cell_try_insert",
        description: r##"# `once_cell_try_insert`

The tracking issue for this feature is: [#116693]

[#116693]: https://github.com/rust-lang/rust/issues/116693

------------------------
"##,
    },
    Lint {
        label: "one_sided_range",
        description: r##"# `one_sided_range`

The tracking issue for this feature is: [#69780]

[#69780]: https://github.com/rust-lang/rust/issues/69780

------------------------
"##,
    },
    Lint {
        label: "optimize_attribute",
        description: r##"# `optimize_attribute`

The tracking issue for this feature is: [#54882]

[#54882]: https://github.com/rust-lang/rust/issues/54882

------------------------
"##,
    },
    Lint {
        label: "option_get_or_insert_default",
        description: r##"# `option_get_or_insert_default`

The tracking issue for this feature is: [#82901]

[#82901]: https://github.com/rust-lang/rust/issues/82901

------------------------
"##,
    },
    Lint {
        label: "option_zip",
        description: r##"# `option_zip`

The tracking issue for this feature is: [#70086]

[#70086]: https://github.com/rust-lang/rust/issues/70086

------------------------
"##,
    },
    Lint {
        label: "os_str_display",
        description: r##"# `os_str_display`

The tracking issue for this feature is: [#120048]

[#120048]: https://github.com/rust-lang/rust/issues/120048

------------------------
"##,
    },
    Lint {
        label: "os_str_slice",
        description: r##"# `os_str_slice`

The tracking issue for this feature is: [#118485]

[#118485]: https://github.com/rust-lang/rust/issues/118485

------------------------
"##,
    },
    Lint {
        label: "os_string_pathbuf_leak",
        description: r##"# `os_string_pathbuf_leak`

The tracking issue for this feature is: [#125965]

[#125965]: https://github.com/rust-lang/rust/issues/125965

------------------------
"##,
    },
    Lint {
        label: "panic_abort",
        description: r##"# `panic_abort`

The tracking issue for this feature is: [#32837]

[#32837]: https://github.com/rust-lang/rust/issues/32837

------------------------
"##,
    },
    Lint {
        label: "panic_always_abort",
        description: r##"# `panic_always_abort`

The tracking issue for this feature is: [#84438]

[#84438]: https://github.com/rust-lang/rust/issues/84438

------------------------
"##,
    },
    Lint {
        label: "panic_backtrace_config",
        description: r##"# `panic_backtrace_config`

The tracking issue for this feature is: [#93346]

[#93346]: https://github.com/rust-lang/rust/issues/93346

------------------------
"##,
    },
    Lint {
        label: "panic_can_unwind",
        description: r##"# `panic_can_unwind`

The tracking issue for this feature is: [#92988]

[#92988]: https://github.com/rust-lang/rust/issues/92988

------------------------
"##,
    },
    Lint {
        label: "panic_internals",
        description: r##"# `panic_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "panic_payload_as_str",
        description: r##"# `panic_payload_as_str`

The tracking issue for this feature is: [#125175]

[#125175]: https://github.com/rust-lang/rust/issues/125175

------------------------
"##,
    },
    Lint {
        label: "panic_runtime",
        description: r##"# `panic_runtime`

The tracking issue for this feature is: [#32837]

[#32837]: https://github.com/rust-lang/rust/issues/32837

------------------------
"##,
    },
    Lint {
        label: "panic_unwind",
        description: r##"# `panic_unwind`

The tracking issue for this feature is: [#32837]

[#32837]: https://github.com/rust-lang/rust/issues/32837

------------------------
"##,
    },
    Lint {
        label: "panic_update_hook",
        description: r##"# `panic_update_hook`

The tracking issue for this feature is: [#92649]

[#92649]: https://github.com/rust-lang/rust/issues/92649

------------------------
"##,
    },
    Lint {
        label: "patchable_function_entry",
        description: r##"# `patchable_function_entry`

The tracking issue for this feature is: [#123115]

[#123115]: https://github.com/rust-lang/rust/issues/123115

------------------------
"##,
    },
    Lint {
        label: "path_add_extension",
        description: r##"# `path_add_extension`

The tracking issue for this feature is: [#127292]

[#127292]: https://github.com/rust-lang/rust/issues/127292

------------------------
"##,
    },
    Lint {
        label: "path_file_prefix",
        description: r##"# `path_file_prefix`

The tracking issue for this feature is: [#86319]

[#86319]: https://github.com/rust-lang/rust/issues/86319

------------------------
"##,
    },
    Lint {
        label: "pattern",
        description: r##"# `pattern`

The tracking issue for this feature is: [#27721]

[#27721]: https://github.com/rust-lang/rust/issues/27721

------------------------
"##,
    },
    Lint {
        label: "pattern_complexity",
        description: r##"# `pattern_complexity`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "pattern_types",
        description: r##"# `pattern_types`

The tracking issue for this feature is: [#123646]

[#123646]: https://github.com/rust-lang/rust/issues/123646

------------------------
"##,
    },
    Lint {
        label: "peer_credentials_unix_socket",
        description: r##"# `peer_credentials_unix_socket`

The tracking issue for this feature is: [#42839]

[#42839]: https://github.com/rust-lang/rust/issues/42839

------------------------
"##,
    },
    Lint {
        label: "pin_deref_mut",
        description: r##"# `pin_deref_mut`

The tracking issue for this feature is: [#86918]

[#86918]: https://github.com/rust-lang/rust/issues/86918

------------------------
"##,
    },
    Lint {
        label: "pointer_is_aligned_to",
        description: r##"# `pointer_is_aligned_to`

The tracking issue for this feature is: [#96284]

[#96284]: https://github.com/rust-lang/rust/issues/96284

------------------------
"##,
    },
    Lint {
        label: "pointer_like_trait",
        description: r##"# `pointer_like_trait`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "portable_simd",
        description: r##"# `portable_simd`

The tracking issue for this feature is: [#86656]

[#86656]: https://github.com/rust-lang/rust/issues/86656

------------------------
"##,
    },
    Lint {
        label: "postfix_match",
        description: r##"# `postfix-match`

`postfix-match` adds the feature for matching upon values postfix
the expressions that generate the values.

```rust,edition2021
#![feature(postfix_match)]

enum Foo {
    Bar,
    Baz
}

fn get_foo() -> Foo {
    Foo::Bar
}

get_foo().match {
    Foo::Bar => {},
    Foo::Baz => panic!(),
}
```
"##,
    },
    Lint {
        label: "powerpc_target_feature",
        description: r##"# `powerpc_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "precise_capturing",
        description: r##"# `precise_capturing`

The tracking issue for this feature is: [#123432]

[#123432]: https://github.com/rust-lang/rust/issues/123432

------------------------
"##,
    },
    Lint {
        label: "prelude_2024",
        description: r##"# `prelude_2024`

The tracking issue for this feature is: [#121042]

[#121042]: https://github.com/rust-lang/rust/issues/121042

------------------------
"##,
    },
    Lint {
        label: "prelude_import",
        description: r##"# `prelude_import`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "prfchw_target_feature",
        description: r##"# `prfchw_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "print_internals",
        description: r##"# `print_internals`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "proc_macro_def_site",
        description: r##"# `proc_macro_def_site`

The tracking issue for this feature is: [#54724]

[#54724]: https://github.com/rust-lang/rust/issues/54724

------------------------
"##,
    },
    Lint {
        label: "proc_macro_diagnostic",
        description: r##"# `proc_macro_diagnostic`

The tracking issue for this feature is: [#54140]

[#54140]: https://github.com/rust-lang/rust/issues/54140

------------------------
"##,
    },
    Lint {
        label: "proc_macro_expand",
        description: r##"# `proc_macro_expand`

The tracking issue for this feature is: [#90765]

[#90765]: https://github.com/rust-lang/rust/issues/90765

------------------------
"##,
    },
    Lint {
        label: "proc_macro_hygiene",
        description: r##"# `proc_macro_hygiene`

The tracking issue for this feature is: [#54727]

[#54727]: https://github.com/rust-lang/rust/issues/54727

------------------------
"##,
    },
    Lint {
        label: "proc_macro_internals",
        description: r##"# `proc_macro_internals`

The tracking issue for this feature is: [#27812]

[#27812]: https://github.com/rust-lang/rust/issues/27812

------------------------
"##,
    },
    Lint {
        label: "proc_macro_quote",
        description: r##"# `proc_macro_quote`

The tracking issue for this feature is: [#54722]

[#54722]: https://github.com/rust-lang/rust/issues/54722

------------------------
"##,
    },
    Lint {
        label: "proc_macro_span",
        description: r##"# `proc_macro_span`

The tracking issue for this feature is: [#54725]

[#54725]: https://github.com/rust-lang/rust/issues/54725

------------------------
"##,
    },
    Lint {
        label: "proc_macro_tracked_env",
        description: r##"# `proc_macro_tracked_env`

The tracking issue for this feature is: [#99515]

[#99515]: https://github.com/rust-lang/rust/issues/99515

------------------------
"##,
    },
    Lint {
        label: "process_exitcode_internals",
        description: r##"# `process_exitcode_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "process_internals",
        description: r##"# `process_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "profiler_runtime",
        description: r##"# `profiler_runtime`

The tracking issue for this feature is: [#42524](https://github.com/rust-lang/rust/issues/42524).

------------------------
"##,
    },
    Lint {
        label: "profiler_runtime_lib",
        description: r##"# `profiler_runtime_lib`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "ptr_alignment_type",
        description: r##"# `ptr_alignment_type`

The tracking issue for this feature is: [#102070]

[#102070]: https://github.com/rust-lang/rust/issues/102070

------------------------
"##,
    },
    Lint {
        label: "ptr_as_ref_unchecked",
        description: r##"# `ptr_as_ref_unchecked`

The tracking issue for this feature is: [#122034]

[#122034]: https://github.com/rust-lang/rust/issues/122034

------------------------
"##,
    },
    Lint {
        label: "ptr_as_uninit",
        description: r##"# `ptr_as_uninit`

The tracking issue for this feature is: [#75402]

[#75402]: https://github.com/rust-lang/rust/issues/75402

------------------------
"##,
    },
    Lint {
        label: "ptr_internals",
        description: r##"# `ptr_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "ptr_mask",
        description: r##"# `ptr_mask`

The tracking issue for this feature is: [#98290]

[#98290]: https://github.com/rust-lang/rust/issues/98290

------------------------
"##,
    },
    Lint {
        label: "ptr_metadata",
        description: r##"# `ptr_metadata`

The tracking issue for this feature is: [#81513]

[#81513]: https://github.com/rust-lang/rust/issues/81513

------------------------
"##,
    },
    Lint {
        label: "ptr_sub_ptr",
        description: r##"# `ptr_sub_ptr`

The tracking issue for this feature is: [#95892]

[#95892]: https://github.com/rust-lang/rust/issues/95892

------------------------
"##,
    },
    Lint {
        label: "pub_crate_should_not_need_unstable_attr",
        description: r##"# `pub_crate_should_not_need_unstable_attr`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "raw_os_error_ty",
        description: r##"# `raw_os_error_ty`

The tracking issue for this feature is: [#107792]

[#107792]: https://github.com/rust-lang/rust/issues/107792

------------------------
"##,
    },
    Lint {
        label: "raw_ref_op",
        description: r##"# `raw_ref_op`

The tracking issue for this feature is: [#64490]

[#64490]: https://github.com/rust-lang/rust/issues/64490

------------------------
"##,
    },
    Lint {
        label: "raw_slice_split",
        description: r##"# `raw_slice_split`

The tracking issue for this feature is: [#95595]

[#95595]: https://github.com/rust-lang/rust/issues/95595

------------------------
"##,
    },
    Lint {
        label: "raw_vec_internals",
        description: r##"# `raw_vec_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "read_buf",
        description: r##"# `read_buf`

The tracking issue for this feature is: [#78485]

[#78485]: https://github.com/rust-lang/rust/issues/78485

------------------------
"##,
    },
    Lint {
        label: "ready_into_inner",
        description: r##"# `ready_into_inner`

The tracking issue for this feature is: [#101196]

[#101196]: https://github.com/rust-lang/rust/issues/101196

------------------------
"##,
    },
    Lint {
        label: "receiver_trait",
        description: r##"# `receiver_trait`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "reentrant_lock",
        description: r##"# `reentrant_lock`

The tracking issue for this feature is: [#121440]

[#121440]: https://github.com/rust-lang/rust/issues/121440

------------------------
"##,
    },
    Lint {
        label: "ref_pat_eat_one_layer_2024",
        description: r##"# `ref_pat_eat_one_layer_2024`

The tracking issue for this feature is: [#123076]

[#123076]: https://github.com/rust-lang/rust/issues/123076

------------------------
"##,
    },
    Lint {
        label: "ref_pat_eat_one_layer_2024_structural",
        description: r##"# `ref_pat_eat_one_layer_2024_structural`

The tracking issue for this feature is: [#123076]

[#123076]: https://github.com/rust-lang/rust/issues/123076

------------------------
"##,
    },
    Lint {
        label: "register_tool",
        description: r##"# `register_tool`

The tracking issue for this feature is: [#66079]

[#66079]: https://github.com/rust-lang/rust/issues/66079

------------------------
"##,
    },
    Lint {
        label: "repr128",
        description: r##"# `repr128`

The tracking issue for this feature is: [#56071]

[#56071]: https://github.com/rust-lang/rust/issues/56071

------------------------

The `repr128` feature adds support for `#[repr(u128)]` on `enum`s.

```rust
#![feature(repr128)]

#[repr(u128)]
enum Foo {
    Bar(u64),
}
```
"##,
    },
    Lint {
        label: "repr_simd",
        description: r##"# `repr_simd`

The tracking issue for this feature is: [#27731]

[#27731]: https://github.com/rust-lang/rust/issues/27731

------------------------
"##,
    },
    Lint {
        label: "restricted_std",
        description: r##"# `restricted_std`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "result_ffi_guarantees",
        description: r##"# `result_ffi_guarantees`

The tracking issue for this feature is: [#110503]

[#110503]: https://github.com/rust-lang/rust/issues/110503

------------------------

This feature adds the possibility of using `Result<T, E>` in FFI if T's niche
value can be used to describe E or vise-versa.

See [RFC 3391] for more information.

[RFC 3391]: https://github.com/rust-lang/rfcs/blob/master/text/3391-result_ffi_guarantees.md
"##,
    },
    Lint {
        label: "result_flattening",
        description: r##"# `result_flattening`

The tracking issue for this feature is: [#70142]

[#70142]: https://github.com/rust-lang/rust/issues/70142

------------------------
"##,
    },
    Lint {
        label: "return_type_notation",
        description: r##"# `return_type_notation`

The tracking issue for this feature is: [#109417]

[#109417]: https://github.com/rust-lang/rust/issues/109417

------------------------
"##,
    },
    Lint {
        label: "riscv_target_feature",
        description: r##"# `riscv_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "round_char_boundary",
        description: r##"# `round_char_boundary`

The tracking issue for this feature is: [#93743]

[#93743]: https://github.com/rust-lang/rust/issues/93743

------------------------
"##,
    },
    Lint {
        label: "rt",
        description: r##"# `rt`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "rtm_target_feature",
        description: r##"# `rtm_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "rust_cold_cc",
        description: r##"# `rust_cold_cc`

The tracking issue for this feature is: [#97544]

[#97544]: https://github.com/rust-lang/rust/issues/97544

------------------------
"##,
    },
    Lint {
        label: "rustc_allow_const_fn_unstable",
        description: r##"# `rustc_allow_const_fn_unstable`

The tracking issue for this feature is: [#69399]

[#69399]: https://github.com/rust-lang/rust/issues/69399

------------------------
"##,
    },
    Lint {
        label: "rustc_attrs",
        description: r##"# `rustc_attrs`

This feature has no tracking issue, and is therefore internal to
the compiler, not being intended for general use.

Note: `rustc_attrs` enables many rustc-internal attributes and this page
only discuss a few of them.

------------------------

The `rustc_attrs` feature allows debugging rustc type layouts by using
`#[rustc_layout(...)]` to debug layout at compile time (it even works
with `cargo check`) as an alternative to `rustc -Z print-type-sizes`
that is way more verbose.

Options provided by `#[rustc_layout(...)]` are `debug`, `size`, `align`,
`abi`. Note that it only works on sized types without generics.

## Examples

```rust,compile_fail
#![feature(rustc_attrs)]

#[rustc_layout(abi, size)]
pub enum X {
    Y(u8, u8, u8),
    Z(isize),
}
```

When that is compiled, the compiler will error with something like

```text
error: abi: Aggregate { sized: true }
 --> src/lib.rs:4:1
  |
4 | / pub enum T {
5 | |     Y(u8, u8, u8),
6 | |     Z(isize),
7 | | }
  | |_^

error: size: Size { raw: 16 }
 --> src/lib.rs:4:1
  |
4 | / pub enum T {
5 | |     Y(u8, u8, u8),
6 | |     Z(isize),
7 | | }
  | |_^

error: aborting due to 2 previous errors
```
"##,
    },
    Lint {
        label: "rustc_encodable_decodable",
        description: r##"# `rustc_encodable_decodable`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "rustc_private",
        description: r##"# `rustc_private`

The tracking issue for this feature is: [#27812]

[#27812]: https://github.com/rust-lang/rust/issues/27812

------------------------
"##,
    },
    Lint {
        label: "rustdoc_internals",
        description: r##"# `rustdoc_internals`

The tracking issue for this feature is: [#90418]

[#90418]: https://github.com/rust-lang/rust/issues/90418

------------------------
"##,
    },
    Lint {
        label: "rustdoc_missing_doc_code_examples",
        description: r##"# `rustdoc_missing_doc_code_examples`

The tracking issue for this feature is: [#101730]

[#101730]: https://github.com/rust-lang/rust/issues/101730

------------------------
"##,
    },
    Lint {
        label: "sealed",
        description: r##"# `sealed`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "seek_stream_len",
        description: r##"# `seek_stream_len`

The tracking issue for this feature is: [#59359]

[#59359]: https://github.com/rust-lang/rust/issues/59359

------------------------
"##,
    },
    Lint {
        label: "set_ptr_value",
        description: r##"# `set_ptr_value`

The tracking issue for this feature is: [#75091]

[#75091]: https://github.com/rust-lang/rust/issues/75091

------------------------
"##,
    },
    Lint {
        label: "setgroups",
        description: r##"# `setgroups`

The tracking issue for this feature is: [#90747]

[#90747]: https://github.com/rust-lang/rust/issues/90747

------------------------
"##,
    },
    Lint {
        label: "sgx_platform",
        description: r##"# `sgx_platform`

The tracking issue for this feature is: [#56975]

[#56975]: https://github.com/rust-lang/rust/issues/56975

------------------------
"##,
    },
    Lint {
        label: "shorter_tail_lifetimes",
        description: r##"# `shorter_tail_lifetimes`

The tracking issue for this feature is: [#123739]

[#123739]: https://github.com/rust-lang/rust/issues/123739

------------------------
"##,
    },
    Lint {
        label: "simd_ffi",
        description: r##"# `simd_ffi`

The tracking issue for this feature is: [#27731]

[#27731]: https://github.com/rust-lang/rust/issues/27731

------------------------
"##,
    },
    Lint {
        label: "sized_type_properties",
        description: r##"# `sized_type_properties`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "slice_as_chunks",
        description: r##"# `slice_as_chunks`

The tracking issue for this feature is: [#74985]

[#74985]: https://github.com/rust-lang/rust/issues/74985

------------------------
"##,
    },
    Lint {
        label: "slice_concat_ext",
        description: r##"# `slice_concat_ext`

The tracking issue for this feature is: [#27747]

[#27747]: https://github.com/rust-lang/rust/issues/27747

------------------------
"##,
    },
    Lint {
        label: "slice_concat_trait",
        description: r##"# `slice_concat_trait`

The tracking issue for this feature is: [#27747]

[#27747]: https://github.com/rust-lang/rust/issues/27747

------------------------
"##,
    },
    Lint {
        label: "slice_from_ptr_range",
        description: r##"# `slice_from_ptr_range`

The tracking issue for this feature is: [#89792]

[#89792]: https://github.com/rust-lang/rust/issues/89792

------------------------
"##,
    },
    Lint {
        label: "slice_index_methods",
        description: r##"# `slice_index_methods`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "slice_internals",
        description: r##"# `slice_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "slice_iter_mut_as_mut_slice",
        description: r##"# `slice_iter_mut_as_mut_slice`

The tracking issue for this feature is: [#93079]

[#93079]: https://github.com/rust-lang/rust/issues/93079

------------------------
"##,
    },
    Lint {
        label: "slice_partition_dedup",
        description: r##"# `slice_partition_dedup`

The tracking issue for this feature is: [#54279]

[#54279]: https://github.com/rust-lang/rust/issues/54279

------------------------
"##,
    },
    Lint {
        label: "slice_pattern",
        description: r##"# `slice_pattern`

The tracking issue for this feature is: [#56345]

[#56345]: https://github.com/rust-lang/rust/issues/56345

------------------------
"##,
    },
    Lint {
        label: "slice_ptr_get",
        description: r##"# `slice_ptr_get`

The tracking issue for this feature is: [#74265]

[#74265]: https://github.com/rust-lang/rust/issues/74265

------------------------
"##,
    },
    Lint {
        label: "slice_range",
        description: r##"# `slice_range`

The tracking issue for this feature is: [#76393]

[#76393]: https://github.com/rust-lang/rust/issues/76393

------------------------
"##,
    },
    Lint {
        label: "slice_split_once",
        description: r##"# `slice_split_once`

The tracking issue for this feature is: [#112811]

[#112811]: https://github.com/rust-lang/rust/issues/112811

------------------------
"##,
    },
    Lint {
        label: "slice_swap_unchecked",
        description: r##"# `slice_swap_unchecked`

The tracking issue for this feature is: [#88539]

[#88539]: https://github.com/rust-lang/rust/issues/88539

------------------------
"##,
    },
    Lint {
        label: "slice_take",
        description: r##"# `slice_take`

The tracking issue for this feature is: [#62280]

[#62280]: https://github.com/rust-lang/rust/issues/62280

------------------------
"##,
    },
    Lint {
        label: "solid_ext",
        description: r##"# `solid_ext`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "sort_floats",
        description: r##"# `sort_floats`

The tracking issue for this feature is: [#93396]

[#93396]: https://github.com/rust-lang/rust/issues/93396

------------------------
"##,
    },
    Lint {
        label: "specialization",
        description: r##"# `specialization`

The tracking issue for this feature is: [#31844]

[#31844]: https://github.com/rust-lang/rust/issues/31844

------------------------
"##,
    },
    Lint {
        label: "split_array",
        description: r##"# `split_array`

The tracking issue for this feature is: [#90091]

[#90091]: https://github.com/rust-lang/rust/issues/90091

------------------------
"##,
    },
    Lint {
        label: "split_as_slice",
        description: r##"# `split_as_slice`

The tracking issue for this feature is: [#96137]

[#96137]: https://github.com/rust-lang/rust/issues/96137

------------------------
"##,
    },
    Lint {
        label: "sse4a_target_feature",
        description: r##"# `sse4a_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "staged_api",
        description: r##"# `staged_api`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "start",
        description: r##"# `start`

The tracking issue for this feature is: [#29633]

[#29633]: https://github.com/rust-lang/rust/issues/29633

------------------------

Allows you to mark a function as the entry point of the executable, which is
necessary in `#![no_std]` environments.

The function marked `#[start]` is passed the command line parameters in the same
format as the C main function (aside from the integer types being used).
It has to be non-generic and have the following signature:

```rust,ignore (only-for-syntax-highlight)
# let _:
fn(isize, *const *const u8) -> isize
# ;
```

This feature should not be confused with the `start` *lang item* which is
defined by the `std` crate and is written `#[lang = "start"]`.

## Usage together with the `std` crate

`#[start]` can be used in combination with the `std` crate, in which case the
normal `main` function (which would get called from the `std` crate) won't be
used as an entry point.
The initialization code in `std` will be skipped this way.

Example:

```rust
#![feature(start)]

#[start]
fn start(_argc: isize, _argv: *const *const u8) -> isize {
    0
}
```

Unwinding the stack past the `#[start]` function is currently considered
Undefined Behavior (for any unwinding implementation):

```rust,ignore (UB)
#![feature(start)]

#[start]
fn start(_argc: isize, _argv: *const *const u8) -> isize {
    std::panic::catch_unwind(|| {
        panic!(); // panic safely gets caught or safely aborts execution
    });

    panic!(); // UB!

    0
}
```
"##,
    },
    Lint {
        label: "std_internals",
        description: r##"# `std_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "stdarch_arm_feature_detection",
        description: r##"# `stdarch_arm_feature_detection`

The tracking issue for this feature is: [#111190]

[#111190]: https://github.com/rust-lang/rust/issues/111190

------------------------
"##,
    },
    Lint {
        label: "stdarch_mips_feature_detection",
        description: r##"# `stdarch_mips_feature_detection`

The tracking issue for this feature is: [#111188]

[#111188]: https://github.com/rust-lang/rust/issues/111188

------------------------
"##,
    },
    Lint {
        label: "stdarch_powerpc_feature_detection",
        description: r##"# `stdarch_powerpc_feature_detection`

The tracking issue for this feature is: [#111191]

[#111191]: https://github.com/rust-lang/rust/issues/111191

------------------------
"##,
    },
    Lint {
        label: "stdio_makes_pipe",
        description: r##"# `stdio_makes_pipe`

The tracking issue for this feature is: [#98288]

[#98288]: https://github.com/rust-lang/rust/issues/98288

------------------------
"##,
    },
    Lint {
        label: "step_trait",
        description: r##"# `step_trait`

The tracking issue for this feature is: [#42168]

[#42168]: https://github.com/rust-lang/rust/issues/42168

------------------------
"##,
    },
    Lint {
        label: "stmt_expr_attributes",
        description: r##"# `stmt_expr_attributes`

The tracking issue for this feature is: [#15701]

[#15701]: https://github.com/rust-lang/rust/issues/15701

------------------------
"##,
    },
    Lint {
        label: "str_from_raw_parts",
        description: r##"# `str_from_raw_parts`

The tracking issue for this feature is: [#119206]

[#119206]: https://github.com/rust-lang/rust/issues/119206

------------------------
"##,
    },
    Lint {
        label: "str_from_utf16_endian",
        description: r##"# `str_from_utf16_endian`

The tracking issue for this feature is: [#116258]

[#116258]: https://github.com/rust-lang/rust/issues/116258

------------------------
"##,
    },
    Lint {
        label: "str_internals",
        description: r##"# `str_internals`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "str_lines_remainder",
        description: r##"# `str_lines_remainder`

The tracking issue for this feature is: [#77998]

[#77998]: https://github.com/rust-lang/rust/issues/77998

------------------------
"##,
    },
    Lint {
        label: "str_split_inclusive_remainder",
        description: r##"# `str_split_inclusive_remainder`

The tracking issue for this feature is: [#77998]

[#77998]: https://github.com/rust-lang/rust/issues/77998

------------------------
"##,
    },
    Lint {
        label: "str_split_remainder",
        description: r##"# `str_split_remainder`

The tracking issue for this feature is: [#77998]

[#77998]: https://github.com/rust-lang/rust/issues/77998

------------------------
"##,
    },
    Lint {
        label: "str_split_whitespace_remainder",
        description: r##"# `str_split_whitespace_remainder`

The tracking issue for this feature is: [#77998]

[#77998]: https://github.com/rust-lang/rust/issues/77998

------------------------
"##,
    },
    Lint {
        label: "strict_overflow_ops",
        description: r##"# `strict_overflow_ops`

The tracking issue for this feature is: [#118260]

[#118260]: https://github.com/rust-lang/rust/issues/118260

------------------------
"##,
    },
    Lint {
        label: "strict_provenance",
        description: r##"# `strict_provenance`

The tracking issue for this feature is: [#95228]

[#95228]: https://github.com/rust-lang/rust/issues/95228
-----

The `strict_provenance` feature allows to enable the `fuzzy_provenance_casts` and `lossy_provenance_casts` lints.
These lint on casts between integers and pointers, that are recommended against or invalid in the strict provenance model.
The same feature gate is also used for the experimental strict provenance API in `std` (actually `core`).

## Example

```rust
#![feature(strict_provenance)]
#![warn(fuzzy_provenance_casts)]

fn main() {
    let _dangling = 16_usize as *const u8;
    //~^ WARNING: strict provenance disallows casting integer `usize` to pointer `*const u8`
}
```
"##,
    },
    Lint {
        label: "strict_provenance_atomic_ptr",
        description: r##"# `strict_provenance_atomic_ptr`

The tracking issue for this feature is: [#99108]

[#99108]: https://github.com/rust-lang/rust/issues/99108

------------------------
"##,
    },
    Lint {
        label: "string_deref_patterns",
        description: r##"# `string_deref_patterns`

The tracking issue for this feature is: [#87121]

[#87121]: https://github.com/rust-lang/rust/issues/87121

------------------------

This feature permits pattern matching `String` to `&str` through [its `Deref` implementation].

```rust
#![feature(string_deref_patterns)]

pub enum Value {
    String(String),
    Number(u32),
}

pub fn is_it_the_answer(value: Value) -> bool {
    match value {
        Value::String("42") => true,
        Value::Number(42) => true,
        _ => false,
    }
}
```

Without this feature other constructs such as match guards have to be used.

```rust
# pub enum Value {
#    String(String),
#    Number(u32),
# }
#
pub fn is_it_the_answer(value: Value) -> bool {
    match value {
        Value::String(s) if s == "42" => true,
        Value::Number(42) => true,
        _ => false,
    }
}
```

[its `Deref` implementation]: https://doc.rust-lang.org/std/string/struct.String.html#impl-Deref-for-String
"##,
    },
    Lint {
        label: "string_extend_from_within",
        description: r##"# `string_extend_from_within`

The tracking issue for this feature is: [#103806]

[#103806]: https://github.com/rust-lang/rust/issues/103806

------------------------
"##,
    },
    Lint {
        label: "string_remove_matches",
        description: r##"# `string_remove_matches`

The tracking issue for this feature is: [#72826]

[#72826]: https://github.com/rust-lang/rust/issues/72826

------------------------
"##,
    },
    Lint {
        label: "structural_match",
        description: r##"# `structural_match`

The tracking issue for this feature is: [#31434]

[#31434]: https://github.com/rust-lang/rust/issues/31434

------------------------
"##,
    },
    Lint {
        label: "sync_unsafe_cell",
        description: r##"# `sync_unsafe_cell`

The tracking issue for this feature is: [#95439]

[#95439]: https://github.com/rust-lang/rust/issues/95439

------------------------
"##,
    },
    Lint {
        label: "target_feature_11",
        description: r##"# `target_feature_11`

The tracking issue for this feature is: [#69098]

[#69098]: https://github.com/rust-lang/rust/issues/69098

------------------------
"##,
    },
    Lint {
        label: "tbm_target_feature",
        description: r##"# `tbm_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "tcp_deferaccept",
        description: r##"# `tcp_deferaccept`

The tracking issue for this feature is: [#119639]

[#119639]: https://github.com/rust-lang/rust/issues/119639

------------------------
"##,
    },
    Lint {
        label: "tcp_linger",
        description: r##"# `tcp_linger`

The tracking issue for this feature is: [#88494]

[#88494]: https://github.com/rust-lang/rust/issues/88494

------------------------
"##,
    },
    Lint {
        label: "tcp_quickack",
        description: r##"# `tcp_quickack`

The tracking issue for this feature is: [#96256]

[#96256]: https://github.com/rust-lang/rust/issues/96256

------------------------
"##,
    },
    Lint {
        label: "tcplistener_into_incoming",
        description: r##"# `tcplistener_into_incoming`

The tracking issue for this feature is: [#88373]

[#88373]: https://github.com/rust-lang/rust/issues/88373

------------------------
"##,
    },
    Lint {
        label: "test",
        description: r##"# `test`

The tracking issue for this feature is: None.

------------------------

The internals of the `test` crate are unstable, behind the `test` flag.  The
most widely used part of the `test` crate are benchmark tests, which can test
the performance of your code.  Let's make our `src/lib.rs` look like this
(comments elided):

```rust,no_run
#![feature(test)]

extern crate test;

pub fn add_two(a: i32) -> i32 {
    a + 2
}

#[cfg(test)]
mod tests {
    use super::*;
    use test::Bencher;

    #[test]
    fn it_works() {
        assert_eq!(4, add_two(2));
    }

    #[bench]
    fn bench_add_two(b: &mut Bencher) {
        b.iter(|| add_two(2));
    }
}
```

Note the `test` feature gate, which enables this unstable feature.

We've imported the `test` crate, which contains our benchmarking support.
We have a new function as well, with the `bench` attribute. Unlike regular
tests, which take no arguments, benchmark tests take a `&mut Bencher`. This
`Bencher` provides an `iter` method, which takes a closure. This closure
contains the code we'd like to benchmark.

We can run benchmark tests with `cargo bench`:

```bash
$ cargo bench
   Compiling adder v0.0.1 (file:///home/steve/tmp/adder)
     Running target/release/adder-91b3e234d4ed382a

running 2 tests
test tests::it_works ... ignored
test tests::bench_add_two ... bench:         1 ns/iter (+/- 0)

test result: ok. 0 passed; 0 failed; 1 ignored; 1 measured
```

Our non-benchmark test was ignored. You may have noticed that `cargo bench`
takes a bit longer than `cargo test`. This is because Rust runs our benchmark
a number of times, and then takes the average. Because we're doing so little
work in this example, we have a `1 ns/iter (+/- 0)`, but this would show
the variance if there was one.

Advice on writing benchmarks:


* Move setup code outside the `iter` loop; only put the part you want to measure inside
* Make the code do "the same thing" on each iteration; do not accumulate or change state
* Make the outer function idempotent too; the benchmark runner is likely to run
  it many times
*  Make the inner `iter` loop short and fast so benchmark runs are fast and the
   calibrator can adjust the run-length at fine resolution
* Make the code in the `iter` loop do something simple, to assist in pinpointing
  performance improvements (or regressions)

## Gotcha: optimizations

There's another tricky part to writing benchmarks: benchmarks compiled with
optimizations activated can be dramatically changed by the optimizer so that
the benchmark is no longer benchmarking what one expects. For example, the
compiler might recognize that some calculation has no external effects and
remove it entirely.

```rust,no_run
#![feature(test)]

extern crate test;
use test::Bencher;

#[bench]
fn bench_xor_1000_ints(b: &mut Bencher) {
    b.iter(|| {
        (0..1000).fold(0, |old, new| old ^ new);
    });
}
```

gives the following results

```text
running 1 test
test bench_xor_1000_ints ... bench:         0 ns/iter (+/- 0)

test result: ok. 0 passed; 0 failed; 0 ignored; 1 measured
```

The benchmarking runner offers two ways to avoid this. Either, the closure that
the `iter` method receives can return an arbitrary value which forces the
optimizer to consider the result used and ensures it cannot remove the
computation entirely. This could be done for the example above by adjusting the
`b.iter` call to

```rust
# struct X;
# impl X { fn iter<T, F>(&self, _: F) where F: FnMut() -> T {} } let b = X;
b.iter(|| {
    // Note lack of `;` (could also use an explicit `return`).
    (0..1000).fold(0, |old, new| old ^ new)
});
```

Or, the other option is to call the generic `test::black_box` function, which
is an opaque "black box" to the optimizer and so forces it to consider any
argument as used.

```rust
#![feature(test)]

extern crate test;

# fn main() {
# struct X;
# impl X { fn iter<T, F>(&self, _: F) where F: FnMut() -> T {} } let b = X;
b.iter(|| {
    let n = test::black_box(1000);

    (0..n).fold(0, |a, b| a ^ b)
})
# }
```

Neither of these read or modify the value, and are very cheap for small values.
Larger values can be passed indirectly to reduce overhead (e.g.
`black_box(&huge_struct)`).

Performing either of the above changes gives the following benchmarking results

```text
running 1 test
test bench_xor_1000_ints ... bench:       131 ns/iter (+/- 3)

test result: ok. 0 passed; 0 failed; 0 ignored; 1 measured
```

However, the optimizer can still modify a testcase in an undesirable manner
even when using either of the above.
"##,
    },
    Lint {
        label: "test_unstable_lint",
        description: r##"# `test_unstable_lint`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "thin_box",
        description: r##"# `thin_box`

The tracking issue for this feature is: [#92791]

[#92791]: https://github.com/rust-lang/rust/issues/92791

------------------------
"##,
    },
    Lint {
        label: "thread_id_value",
        description: r##"# `thread_id_value`

The tracking issue for this feature is: [#67939]

[#67939]: https://github.com/rust-lang/rust/issues/67939

------------------------
"##,
    },
    Lint {
        label: "thread_local",
        description: r##"# `thread_local`

The tracking issue for this feature is: [#29594]

[#29594]: https://github.com/rust-lang/rust/issues/29594

------------------------
"##,
    },
    Lint {
        label: "thread_local_internals",
        description: r##"# `thread_local_internals`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "thread_sleep_until",
        description: r##"# `thread_sleep_until`

The tracking issue for this feature is: [#113752]

[#113752]: https://github.com/rust-lang/rust/issues/113752

------------------------
"##,
    },
    Lint {
        label: "thread_spawn_unchecked",
        description: r##"# `thread_spawn_unchecked`

The tracking issue for this feature is: [#55132]

[#55132]: https://github.com/rust-lang/rust/issues/55132

------------------------
"##,
    },
    Lint {
        label: "trace_macros",
        description: r##"# `trace_macros`

The tracking issue for this feature is [#29598].

[#29598]: https://github.com/rust-lang/rust/issues/29598

------------------------

With `trace_macros` you can trace the expansion of macros in your code.

## Examples

```rust
#![feature(trace_macros)]

fn main() {
    trace_macros!(true);
    println!("Hello, Rust!");
    trace_macros!(false);
}
```

The `cargo build` output:

```txt
note: trace_macro
 --> src/main.rs:5:5
  |
5 |     println!("Hello, Rust!");
  |     ^^^^^^^^^^^^^^^^^^^^^^^^^
  |
  = note: expanding `println! { "Hello, Rust!" }`
  = note: to `print ! ( concat ! ( "Hello, Rust!" , "\n" ) )`
  = note: expanding `print! { concat ! ( "Hello, Rust!" , "\n" ) }`
  = note: to `$crate :: io :: _print ( format_args ! ( concat ! ( "Hello, Rust!" , "\n" ) )
          )`

    Finished dev [unoptimized + debuginfo] target(s) in 0.60 secs
```
"##,
    },
    Lint {
        label: "track_path",
        description: r##"# `track_path`

The tracking issue for this feature is: [#99515]

[#99515]: https://github.com/rust-lang/rust/issues/99515

------------------------
"##,
    },
    Lint {
        label: "trait_alias",
        description: r##"# `trait_alias`

The tracking issue for this feature is: [#41517]

[#41517]: https://github.com/rust-lang/rust/issues/41517

------------------------

The `trait_alias` feature adds support for trait aliases. These allow aliases
to be created for one or more traits (currently just a single regular trait plus
any number of auto-traits), and used wherever traits would normally be used as
either bounds or trait objects.

```rust
#![feature(trait_alias)]

trait Foo = std::fmt::Debug + Send;
trait Bar = Foo + Sync;

// Use trait alias as bound on type parameter.
fn foo<T: Foo>(v: &T) {
    println!("{:?}", v);
}

pub fn main() {
    foo(&1);

    // Use trait alias for trait objects.
    let a: &Bar = &123;
    println!("{:?}", a);
    let b = Box::new(456) as Box<dyn Foo>;
    println!("{:?}", b);
}
```
"##,
    },
    Lint {
        label: "trait_upcasting",
        description: r##"# `trait_upcasting`

The tracking issue for this feature is: [#65991]

[#65991]: https://github.com/rust-lang/rust/issues/65991

------------------------

The `trait_upcasting` feature adds support for trait upcasting coercion. This allows a
trait object of type `dyn Bar` to be cast to a trait object of type `dyn Foo`
so long as `Bar: Foo`.

```rust,edition2018
#![feature(trait_upcasting)]
#![allow(incomplete_features)]

trait Foo {}

trait Bar: Foo {}

impl Foo for i32 {}

impl<T: Foo + ?Sized> Bar for T {}

let bar: &dyn Bar = &123;
let foo: &dyn Foo = bar;
```
"##,
    },
    Lint {
        label: "transmutability",
        description: r##"# `transmutability`

The tracking issue for this feature is: [#99571]

[#99571]: https://github.com/rust-lang/rust/issues/99571

------------------------
"##,
    },
    Lint {
        label: "transmute_generic_consts",
        description: r##"# `transmute_generic_consts`

The tracking issue for this feature is: [#109929]

[#109929]: https://github.com/rust-lang/rust/issues/109929

------------------------
"##,
    },
    Lint {
        label: "transparent_unions",
        description: r##"# `transparent_unions`

The tracking issue for this feature is [#60405]

[#60405]: https://github.com/rust-lang/rust/issues/60405

----

The `transparent_unions` feature allows you mark `union`s as
`#[repr(transparent)]`. A `union` may be `#[repr(transparent)]` in exactly the
same conditions in which a `struct` may be `#[repr(transparent)]` (generally,
this means the `union` must have exactly one non-zero-sized field). Some
concrete illustrations follow.

```rust
#![feature(transparent_unions)]

// This union has the same representation as `f32`.
#[repr(transparent)]
union SingleFieldUnion {
    field: f32,
}

// This union has the same representation as `usize`.
#[repr(transparent)]
union MultiFieldUnion {
    field: usize,
    nothing: (),
}
```

For consistency with transparent `struct`s, `union`s must have exactly one
non-zero-sized field. If all fields are zero-sized, the `union` must not be
`#[repr(transparent)]`:

```rust
#![feature(transparent_unions)]

// This (non-transparent) union is already valid in stable Rust:
pub union GoodUnion {
    pub nothing: (),
}

// Error: transparent union needs exactly one non-zero-sized field, but has 0
// #[repr(transparent)]
// pub union BadUnion {
//     pub nothing: (),
// }
```

The one exception is if the `union` is generic over `T` and has a field of type
`T`, it may be `#[repr(transparent)]` even if `T` is a zero-sized type:

```rust
#![feature(transparent_unions)]

// This union has the same representation as `T`.
#[repr(transparent)]
pub union GenericUnion<T: Copy> { // Unions with non-`Copy` fields are unstable.
    pub field: T,
    pub nothing: (),
}

// This is okay even though `()` is a zero-sized type.
pub const THIS_IS_OKAY: GenericUnion<()> = GenericUnion { field: () };
```

Like transparent `struct`s, a transparent `union` of type `U` has the same
layout, size, and ABI as its single non-ZST field. If it is generic over a type
`T`, and all its fields are ZSTs except for exactly one field of type `T`, then
it has the same layout and ABI as `T` (even if `T` is a ZST when monomorphized).

Like transparent `struct`s, transparent `union`s are FFI-safe if and only if
their underlying representation type is also FFI-safe.

A `union` may not be eligible for the same nonnull-style optimizations that a
`struct` or `enum` (with the same fields) are eligible for. Adding
`#[repr(transparent)]` to  `union` does not change this. To give a more concrete
example, it is unspecified whether `size_of::<T>()` is equal to
`size_of::<Option<T>>()`, where `T` is a `union` (regardless of whether or not
it is transparent). The Rust compiler is free to perform this optimization if
possible, but is not required to, and different compiler versions may differ in
their application of these optimizations.
"##,
    },
    Lint {
        label: "trivial_bounds",
        description: r##"# `trivial_bounds`

The tracking issue for this feature is: [#48214]

[#48214]: https://github.com/rust-lang/rust/issues/48214

------------------------
"##,
    },
    Lint {
        label: "trusted_fused",
        description: r##"# `trusted_fused`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "trusted_len",
        description: r##"# `trusted_len`

The tracking issue for this feature is: [#37572]

[#37572]: https://github.com/rust-lang/rust/issues/37572

------------------------
"##,
    },
    Lint {
        label: "trusted_len_next_unchecked",
        description: r##"# `trusted_len_next_unchecked`

The tracking issue for this feature is: [#37572]

[#37572]: https://github.com/rust-lang/rust/issues/37572

------------------------
"##,
    },
    Lint {
        label: "trusted_random_access",
        description: r##"# `trusted_random_access`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "trusted_step",
        description: r##"# `trusted_step`

The tracking issue for this feature is: [#85731]

[#85731]: https://github.com/rust-lang/rust/issues/85731

------------------------
"##,
    },
    Lint {
        label: "try_blocks",
        description: r##"# `try_blocks`

The tracking issue for this feature is: [#31436]

[#31436]: https://github.com/rust-lang/rust/issues/31436

------------------------

The `try_blocks` feature adds support for `try` blocks. A `try`
block creates a new scope one can use the `?` operator in.

```rust,edition2018
#![feature(try_blocks)]

use std::num::ParseIntError;

let result: Result<i32, ParseIntError> = try {
    "1".parse::<i32>()?
        + "2".parse::<i32>()?
        + "3".parse::<i32>()?
};
assert_eq!(result, Ok(6));

let result: Result<i32, ParseIntError> = try {
    "1".parse::<i32>()?
        + "foo".parse::<i32>()?
        + "3".parse::<i32>()?
};
assert!(result.is_err());
```
"##,
    },
    Lint {
        label: "try_find",
        description: r##"# `try_find`

The tracking issue for this feature is: [#63178]

[#63178]: https://github.com/rust-lang/rust/issues/63178

------------------------
"##,
    },
    Lint {
        label: "try_reserve_kind",
        description: r##"# `try_reserve_kind`

The tracking issue for this feature is: [#48043]

[#48043]: https://github.com/rust-lang/rust/issues/48043

------------------------
"##,
    },
    Lint {
        label: "try_trait_v2",
        description: r##"# `try_trait_v2`

The tracking issue for this feature is: [#84277]

[#84277]: https://github.com/rust-lang/rust/issues/84277

------------------------
"##,
    },
    Lint {
        label: "try_trait_v2_residual",
        description: r##"# `try_trait_v2_residual`

The tracking issue for this feature is: [#91285]

[#91285]: https://github.com/rust-lang/rust/issues/91285

------------------------
"##,
    },
    Lint {
        label: "try_trait_v2_yeet",
        description: r##"# `try_trait_v2_yeet`

The tracking issue for this feature is: [#96374]

[#96374]: https://github.com/rust-lang/rust/issues/96374

------------------------
"##,
    },
    Lint {
        label: "try_with_capacity",
        description: r##"# `try_with_capacity`

The tracking issue for this feature is: [#91913]

[#91913]: https://github.com/rust-lang/rust/issues/91913

------------------------
"##,
    },
    Lint {
        label: "tuple_trait",
        description: r##"# `tuple_trait`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "type_alias_impl_trait",
        description: r##"# `type_alias_impl_trait`

The tracking issue for this feature is: [#63063]

[#63063]: https://github.com/rust-lang/rust/issues/63063

------------------------
"##,
    },
    Lint {
        label: "type_ascription",
        description: r##"# `type_ascription`

The tracking issue for this feature is: [#23416]

[#23416]: https://github.com/rust-lang/rust/issues/23416

------------------------
"##,
    },
    Lint {
        label: "type_changing_struct_update",
        description: r##"# `type_changing_struct_update`

The tracking issue for this feature is: [#86555]

[#86555]: https://github.com/rust-lang/rust/issues/86555

------------------------

This implements [RFC2528]. When turned on, you can create instances of the same struct
that have different generic type or lifetime parameters.

[RFC2528]: https://github.com/rust-lang/rfcs/blob/master/text/2528-type-changing-struct-update-syntax.md

```rust
#![allow(unused_variables, dead_code)]
#![feature(type_changing_struct_update)]

fn main () {
    struct Foo<T, U> {
        field1: T,
        field2: U,
    }

    let base: Foo<String, i32> = Foo {
        field1: String::from("hello"),
        field2: 1234,
    };
    let updated: Foo<f64, i32> = Foo {
        field1: 3.14,
        ..base
    };
}
```
"##,
    },
    Lint {
        label: "ub_checks",
        description: r##"# `ub_checks`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "uefi_std",
        description: r##"# `uefi_std`

The tracking issue for this feature is: [#100499]

[#100499]: https://github.com/rust-lang/rust/issues/100499

------------------------
"##,
    },
    Lint {
        label: "unboxed_closures",
        description: r##"# `unboxed_closures`

The tracking issue for this feature is [#29625]

See Also: [`fn_traits`](../library-features/fn-traits.md)

[#29625]: https://github.com/rust-lang/rust/issues/29625

----

The `unboxed_closures` feature allows you to write functions using the `"rust-call"` ABI,
required for implementing the [`Fn*`] family of traits. `"rust-call"` functions must have
exactly one (non self) argument, a tuple representing the argument list.

[`Fn*`]: ../../std/ops/trait.Fn.html

```rust
#![feature(unboxed_closures)]

extern "rust-call" fn add_args(args: (u32, u32)) -> u32 {
    args.0 + args.1
}

fn main() {}
```
"##,
    },
    Lint {
        label: "unchecked_neg",
        description: r##"# `unchecked_neg`

The tracking issue for this feature is: [#85122]

[#85122]: https://github.com/rust-lang/rust/issues/85122

------------------------
"##,
    },
    Lint {
        label: "unchecked_shifts",
        description: r##"# `unchecked_shifts`

The tracking issue for this feature is: [#85122]

[#85122]: https://github.com/rust-lang/rust/issues/85122

------------------------
"##,
    },
    Lint {
        label: "unicode_internals",
        description: r##"# `unicode_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "unique_rc_arc",
        description: r##"# `unique_rc_arc`

The tracking issue for this feature is: [#112566]

[#112566]: https://github.com/rust-lang/rust/issues/112566

------------------------
"##,
    },
    Lint {
        label: "unix_file_vectored_at",
        description: r##"# `unix_file_vectored_at`

The tracking issue for this feature is: [#89517]

[#89517]: https://github.com/rust-lang/rust/issues/89517

------------------------
"##,
    },
    Lint {
        label: "unix_set_mark",
        description: r##"# `unix_set_mark`

The tracking issue for this feature is: [#96467]

[#96467]: https://github.com/rust-lang/rust/issues/96467

------------------------
"##,
    },
    Lint {
        label: "unix_socket_ancillary_data",
        description: r##"# `unix_socket_ancillary_data`

The tracking issue for this feature is: [#76915]

[#76915]: https://github.com/rust-lang/rust/issues/76915

------------------------
"##,
    },
    Lint {
        label: "unix_socket_peek",
        description: r##"# `unix_socket_peek`

The tracking issue for this feature is: [#76923]

[#76923]: https://github.com/rust-lang/rust/issues/76923

------------------------
"##,
    },
    Lint {
        label: "unnamed_fields",
        description: r##"# `unnamed_fields`

The tracking issue for this feature is: [#49804]

[#49804]: https://github.com/rust-lang/rust/issues/49804

------------------------
"##,
    },
    Lint {
        label: "unsafe_attributes",
        description: r##"# `unsafe_attributes`

The tracking issue for this feature is: [#123757]

[#123757]: https://github.com/rust-lang/rust/issues/123757

------------------------
"##,
    },
    Lint {
        label: "unsafe_cell_from_mut",
        description: r##"# `unsafe_cell_from_mut`

The tracking issue for this feature is: [#111645]

[#111645]: https://github.com/rust-lang/rust/issues/111645

------------------------
"##,
    },
    Lint {
        label: "unsafe_extern_blocks",
        description: r##"# `unsafe_extern_blocks`

The tracking issue for this feature is: [#123743]

[#123743]: https://github.com/rust-lang/rust/issues/123743

------------------------
"##,
    },
    Lint {
        label: "unsafe_pin_internals",
        description: r##"# `unsafe_pin_internals`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "unsize",
        description: r##"# `unsize`

The tracking issue for this feature is: [#18598]

[#18598]: https://github.com/rust-lang/rust/issues/18598

------------------------
"##,
    },
    Lint {
        label: "unsized_fn_params",
        description: r##"# `unsized_fn_params`

The tracking issue for this feature is: [#48055]

[#48055]: https://github.com/rust-lang/rust/issues/48055

------------------------
"##,
    },
    Lint {
        label: "unsized_locals",
        description: r##"# `unsized_locals`

The tracking issue for this feature is: [#48055]

[#48055]: https://github.com/rust-lang/rust/issues/48055

------------------------

This implements [RFC1909]. When turned on, you can have unsized arguments and locals:

[RFC1909]: https://github.com/rust-lang/rfcs/blob/master/text/1909-unsized-rvalues.md

```rust
#![allow(incomplete_features)]
#![feature(unsized_locals, unsized_fn_params)]

use std::any::Any;

fn main() {
    let x: Box<dyn Any> = Box::new(42);
    let x: dyn Any = *x;
    //  ^ unsized local variable
    //               ^^ unsized temporary
    foo(x);
}

fn foo(_: dyn Any) {}
//     ^^^^^^ unsized argument
```

The RFC still forbids the following unsized expressions:

```rust,compile_fail
#![feature(unsized_locals)]

use std::any::Any;

struct MyStruct<T: ?Sized> {
    content: T,
}

struct MyTupleStruct<T: ?Sized>(T);

fn answer() -> Box<dyn Any> {
    Box::new(42)
}

fn main() {
    // You CANNOT have unsized statics.
    static X: dyn Any = *answer();  // ERROR
    const Y: dyn Any = *answer();  // ERROR

    // You CANNOT have struct initialized unsized.
    MyStruct { content: *answer() };  // ERROR
    MyTupleStruct(*answer());  // ERROR
    (42, *answer());  // ERROR

    // You CANNOT have unsized return types.
    fn my_function() -> dyn Any { *answer() }  // ERROR

    // You CAN have unsized local variables...
    let mut x: dyn Any = *answer();  // OK
    // ...but you CANNOT reassign to them.
    x = *answer();  // ERROR

    // You CANNOT even initialize them separately.
    let y: dyn Any;  // OK
    y = *answer();  // ERROR

    // Not mentioned in the RFC, but by-move captured variables are also Sized.
    let x: dyn Any = *answer();
    (move || {  // ERROR
        let y = x;
    })();

    // You CAN create a closure with unsized arguments,
    // but you CANNOT call it.
    // This is an implementation detail and may be changed in the future.
    let f = |x: dyn Any| {};
    f(*answer());  // ERROR
}
```

## By-value trait objects

With this feature, you can have by-value `self` arguments without `Self: Sized` bounds.

```rust
#![feature(unsized_fn_params)]

trait Foo {
    fn foo(self) {}
}

impl<T: ?Sized> Foo for T {}

fn main() {
    let slice: Box<[i32]> = Box::new([1, 2, 3]);
    <[i32] as Foo>::foo(*slice);
}
```

And `Foo` will also be object-safe.

```rust
#![feature(unsized_fn_params)]

trait Foo {
    fn foo(self) {}
}

impl<T: ?Sized> Foo for T {}

fn main () {
    let slice: Box<dyn Foo> = Box::new([1, 2, 3]);
    // doesn't compile yet
    <dyn Foo as Foo>::foo(*slice);
}
```

One of the objectives of this feature is to allow `Box<dyn FnOnce>`.

## Variable length arrays

The RFC also describes an extension to the array literal syntax: `[e; dyn n]`. In the syntax, `n` isn't necessarily a constant expression. The array is dynamically allocated on the stack and has the type of `[T]`, instead of `[T; n]`.

```rust,ignore (not-yet-implemented)
#![feature(unsized_locals)]

fn mergesort<T: Ord>(a: &mut [T]) {
    let mut tmp = [T; dyn a.len()];
    // ...
}

fn main() {
    let mut a = [3, 1, 5, 6];
    mergesort(&mut a);
    assert_eq!(a, [1, 3, 5, 6]);
}
```

VLAs are not implemented yet. The syntax isn't final, either. We may need an alternative syntax for Rust 2015 because, in Rust 2015, expressions like `[e; dyn(1)]` would be ambiguous. One possible alternative proposed in the RFC is `[e; n]`: if `n` captures one or more local variables, then it is considered as `[e; dyn n]`.

## Advisory on stack usage

It's advised not to casually use the `#![feature(unsized_locals)]` feature. Typical use-cases are:

- When you need a by-value trait objects.
- When you really need a fast allocation of small temporary arrays.

Another pitfall is repetitive allocation and temporaries. Currently the compiler simply extends the stack frame every time it encounters an unsized assignment. So for example, the code

```rust
#![feature(unsized_locals)]

fn main() {
    let x: Box<[i32]> = Box::new([1, 2, 3, 4, 5]);
    let _x = {{{{{{{{{{*x}}}}}}}}}};
}
```

and the code

```rust
#![feature(unsized_locals)]

fn main() {
    for _ in 0..10 {
        let x: Box<[i32]> = Box::new([1, 2, 3, 4, 5]);
        let _x = *x;
    }
}
```

will unnecessarily extend the stack frame.
"##,
    },
    Lint {
        label: "unsized_tuple_coercion",
        description: r##"# `unsized_tuple_coercion`

The tracking issue for this feature is: [#42877]

[#42877]: https://github.com/rust-lang/rust/issues/42877

------------------------

This is a part of [RFC0401]. According to the RFC, there should be an implementation like this:

```rust,ignore (partial-example)
impl<..., T, U: ?Sized> Unsized<(..., U)> for (..., T) where T: Unsized<U> {}
```

This implementation is currently gated behind `#[feature(unsized_tuple_coercion)]` to avoid insta-stability. Therefore you can use it like this:

```rust
#![feature(unsized_tuple_coercion)]

fn main() {
    let x : ([i32; 3], [i32; 3]) = ([1, 2, 3], [4, 5, 6]);
    let y : &([i32; 3], [i32]) = &x;
    assert_eq!(y.1[0], 4);
}
```

[RFC0401]: https://github.com/rust-lang/rfcs/blob/master/text/0401-coercions.md
"##,
    },
    Lint {
        label: "unwrap_infallible",
        description: r##"# `unwrap_infallible`

The tracking issue for this feature is: [#61695]

[#61695]: https://github.com/rust-lang/rust/issues/61695

------------------------
"##,
    },
    Lint {
        label: "update_panic_count",
        description: r##"# `update_panic_count`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "used_with_arg",
        description: r##"# `used_with_arg`

The tracking issue for this feature is: [#93798]

[#93798]: https://github.com/rust-lang/rust/issues/93798

------------------------
"##,
    },
    Lint {
        label: "utf16_extra",
        description: r##"# `utf16_extra`

The tracking issue for this feature is: [#94919]

[#94919]: https://github.com/rust-lang/rust/issues/94919

------------------------
"##,
    },
    Lint {
        label: "utf16_extra_const",
        description: r##"# `utf16_extra_const`

The tracking issue for this feature is: [#94919]

[#94919]: https://github.com/rust-lang/rust/issues/94919

------------------------
"##,
    },
    Lint {
        label: "variant_count",
        description: r##"# `variant_count`

The tracking issue for this feature is: [#73662]

[#73662]: https://github.com/rust-lang/rust/issues/73662

------------------------
"##,
    },
    Lint {
        label: "vec_into_raw_parts",
        description: r##"# `vec_into_raw_parts`

The tracking issue for this feature is: [#65816]

[#65816]: https://github.com/rust-lang/rust/issues/65816

------------------------
"##,
    },
    Lint {
        label: "vec_pop_if",
        description: r##"# `vec_pop_if`

The tracking issue for this feature is: [#122741]

[#122741]: https://github.com/rust-lang/rust/issues/122741

------------------------
"##,
    },
    Lint {
        label: "vec_push_within_capacity",
        description: r##"# `vec_push_within_capacity`

The tracking issue for this feature is: [#100486]

[#100486]: https://github.com/rust-lang/rust/issues/100486

------------------------
"##,
    },
    Lint {
        label: "vec_split_at_spare",
        description: r##"# `vec_split_at_spare`

The tracking issue for this feature is: [#81944]

[#81944]: https://github.com/rust-lang/rust/issues/81944

------------------------
"##,
    },
    Lint {
        label: "waker_getters",
        description: r##"# `waker_getters`

The tracking issue for this feature is: [#96992]

[#96992]: https://github.com/rust-lang/rust/issues/96992

------------------------
"##,
    },
    Lint {
        label: "wasi_ext",
        description: r##"# `wasi_ext`

The tracking issue for this feature is: [#71213]

[#71213]: https://github.com/rust-lang/rust/issues/71213

------------------------
"##,
    },
    Lint {
        label: "wasm_abi",
        description: r##"# `wasm_abi`

The tracking issue for this feature is: [#83788]

[#83788]: https://github.com/rust-lang/rust/issues/83788

------------------------
"##,
    },
    Lint {
        label: "wasm_target_feature",
        description: r##"# `wasm_target_feature`

The tracking issue for this feature is: [#44839]

[#44839]: https://github.com/rust-lang/rust/issues/44839

------------------------
"##,
    },
    Lint {
        label: "windows_by_handle",
        description: r##"# `windows_by_handle`

The tracking issue for this feature is: [#63010]

[#63010]: https://github.com/rust-lang/rust/issues/63010

------------------------
"##,
    },
    Lint {
        label: "windows_c",
        description: r##"# `windows_c`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "windows_handle",
        description: r##"# `windows_handle`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "windows_net",
        description: r##"# `windows_net`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "windows_process_exit_code_from",
        description: r##"# `windows_process_exit_code_from`

The tracking issue for this feature is: [#111688]

[#111688]: https://github.com/rust-lang/rust/issues/111688

------------------------
"##,
    },
    Lint {
        label: "windows_process_extensions_async_pipes",
        description: r##"# `windows_process_extensions_async_pipes`

The tracking issue for this feature is: [#98289]

[#98289]: https://github.com/rust-lang/rust/issues/98289

------------------------
"##,
    },
    Lint {
        label: "windows_process_extensions_force_quotes",
        description: r##"# `windows_process_extensions_force_quotes`

The tracking issue for this feature is: [#82227]

[#82227]: https://github.com/rust-lang/rust/issues/82227

------------------------
"##,
    },
    Lint {
        label: "windows_process_extensions_main_thread_handle",
        description: r##"# `windows_process_extensions_main_thread_handle`

The tracking issue for this feature is: [#96723]

[#96723]: https://github.com/rust-lang/rust/issues/96723

------------------------
"##,
    },
    Lint {
        label: "windows_process_extensions_raw_attribute",
        description: r##"# `windows_process_extensions_raw_attribute`

The tracking issue for this feature is: [#114854]

[#114854]: https://github.com/rust-lang/rust/issues/114854

------------------------
"##,
    },
    Lint {
        label: "windows_stdio",
        description: r##"# `windows_stdio`

This feature is internal to the Rust compiler and is not intended for general use.

------------------------
"##,
    },
    Lint {
        label: "with_negative_coherence",
        description: r##"# `with_negative_coherence`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "wrapping_int_impl",
        description: r##"# `wrapping_int_impl`

The tracking issue for this feature is: [#32463]

[#32463]: https://github.com/rust-lang/rust/issues/32463

------------------------
"##,
    },
    Lint {
        label: "wrapping_next_power_of_two",
        description: r##"# `wrapping_next_power_of_two`

The tracking issue for this feature is: [#32463]

[#32463]: https://github.com/rust-lang/rust/issues/32463

------------------------
"##,
    },
    Lint {
        label: "write_all_vectored",
        description: r##"# `write_all_vectored`

The tracking issue for this feature is: [#70436]

[#70436]: https://github.com/rust-lang/rust/issues/70436

------------------------
"##,
    },
    Lint {
        label: "yeet_desugar_details",
        description: r##"# `yeet_desugar_details`

This feature has no tracking issue, and is therefore likely internal to the compiler, not being intended for general use.

------------------------
"##,
    },
    Lint {
        label: "yeet_expr",
        description: r##"# `yeet_expr`

The tracking issue for this feature is: [#96373]

[#96373]: https://github.com/rust-lang/rust/issues/96373

------------------------

The `yeet_expr` feature adds support for `do yeet` expressions,
which can be used to early-exit from a function or `try` block.

These are highly experimental, thus the placeholder syntax.

```rust,edition2021
#![feature(yeet_expr)]

fn foo() -> Result<String, i32> {
    do yeet 4;
}
assert_eq!(foo(), Err(4));

fn bar() -> Option<String> {
    do yeet;
}
assert_eq!(bar(), None);
```
"##,
    },
];

pub const CLIPPY_LINTS: &[Lint] = &[
    Lint {
        label: "clippy::absolute_paths",
        description: r##"Checks for usage of items through absolute paths, like `std::env::current_dir`."##,
    },
    Lint {
        label: "clippy::absurd_extreme_comparisons",
        description: r##"Checks for comparisons where one side of the relation is
either the minimum or maximum value for its type and warns if it involves a
case that is always true or always false. Only integer and boolean types are
checked."##,
    },
    Lint {
        label: "clippy::alloc_instead_of_core",
        description: r##"Finds items imported through `alloc` when available through `core`."##,
    },
    Lint {
        label: "clippy::allow_attributes",
        description: r##"Checks for usage of the `#[allow]` attribute and suggests replacing it with
the `#[expect]` (See [RFC 2383](https://rust-lang.github.io/rfcs/2383-lint-reasons.html))

This lint only warns outer attributes (`#[allow]`), as inner attributes
(`#![allow]`) are usually used to enable or disable lints on a global scale."##,
    },
    Lint {
        label: "clippy::allow_attributes_without_reason",
        description: r##"Checks for attributes that allow lints without a reason."##,
    },
    Lint {
        label: "clippy::almost_complete_range",
        description: r##"Checks for ranges which almost include the entire range of letters from 'a' to 'z'
or digits from '0' to '9', but don't because they're a half open range."##,
    },
    Lint {
        label: "clippy::almost_swapped",
        description: r##"Checks for `foo = bar; bar = foo` sequences."##,
    },
    Lint {
        label: "clippy::approx_constant",
        description: r##"Checks for floating point literals that approximate
constants which are defined in
[`std::f32::consts`](https://doc.rust-lang.org/stable/std/f32/consts/#constants)
or
[`std::f64::consts`](https://doc.rust-lang.org/stable/std/f64/consts/#constants),
respectively, suggesting to use the predefined constant."##,
    },
    Lint {
        label: "clippy::arc_with_non_send_sync",
        description: r##".
This lint warns when you use `Arc` with a type that does not implement `Send` or `Sync`."##,
    },
    Lint {
        label: "clippy::arithmetic_side_effects",
        description: r##"Checks any kind of arithmetic operation of any type.

Operators like `+`, `-`, `*` or `<<` are usually capable of overflowing according to the [Rust
Reference](https://doc.rust-lang.org/reference/expressions/operator-expr.html#overflow),
or can panic (`/`, `%`).

Known safe built-in types like `Wrapping` or `Saturating`, floats, operations in constant
environments, allowed types and non-constant operations that won't overflow are ignored."##,
    },
    Lint {
        label: "clippy::as_conversions",
        description: r##"Checks for usage of `as` conversions.

Note that this lint is specialized in linting *every single* use of `as`
regardless of whether good alternatives exist or not.
If you want more precise lints for `as`, please consider using these separate lints:
`unnecessary_cast`, `cast_lossless/cast_possible_truncation/cast_possible_wrap/cast_precision_loss/cast_sign_loss`,
`fn_to_numeric_cast(_with_truncation)`, `char_lit_as_u8`, `ref_to_mut` and `ptr_as_ptr`.
There is a good explanation the reason why this lint should work in this way and how it is useful
[in this issue](https://github.com/rust-lang/rust-clippy/issues/5122)."##,
    },
    Lint {
        label: "clippy::as_ptr_cast_mut",
        description: r##"Checks for the result of a `&self`-taking `as_ptr` being cast to a mutable pointer"##,
    },
    Lint {
        label: "clippy::as_underscore",
        description: r##"Checks for the usage of `as _` conversion using inferred type."##,
    },
    Lint {
        label: "clippy::assertions_on_constants",
        description: r##"Checks for `assert!(true)` and `assert!(false)` calls."##,
    },
    Lint {
        label: "clippy::assertions_on_result_states",
        description: r##"Checks for `assert!(r.is_ok())` or `assert!(r.is_err())` calls."##,
    },
    Lint {
        label: "clippy::assign_op_pattern",
        description: r##"Checks for `a = a op b` or `a = b commutative_op a`
patterns."##,
    },
    Lint {
        label: "clippy::assign_ops",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::assigning_clones",
        description: r##"Checks for code like `foo = bar.clone();`"##,
    },
    Lint {
        label: "clippy::async_yields_async",
        description: r##"Checks for async blocks that yield values of types
that can themselves be awaited."##,
    },
    Lint {
        label: "clippy::await_holding_invalid_type",
        description: r##"Allows users to configure types which should not be held across `await`
suspension points."##,
    },
    Lint {
        label: "clippy::await_holding_lock",
        description: r##"Checks for calls to await while holding a non-async-aware MutexGuard."##,
    },
    Lint {
        label: "clippy::await_holding_refcell_ref",
        description: r##"Checks for calls to await while holding a `RefCell` `Ref` or `RefMut`."##,
    },
    Lint {
        label: "clippy::bad_bit_mask",
        description: r##"Checks for incompatible bit masks in comparisons.

The formula for detecting if an expression of the type `_ <bit_op> m
<cmp_op> c` (where `<bit_op>` is one of {`&`, `|`} and `<cmp_op>` is one of
{`!=`, `>=`, `>`, `!=`, `>=`, `>`}) can be determined from the following
table:

|Comparison  |Bit Op|Example      |is always|Formula               |
|------------|------|-------------|---------|----------------------|
|`==` or `!=`| `&`  |`x & 2 == 3` |`false`  |`c & m != c`          |
|`<`  or `>=`| `&`  |`x & 2 < 3`  |`true`   |`m < c`               |
|`>`  or `<=`| `&`  |`x & 1 > 1`  |`false`  |`m <= c`              |
|`==` or `!=`| `\\|` |`x \\| 1 == 0`|`false`  |`c \\| m != c`         |
|`<`  or `>=`| `\\|` |`x \\| 1 < 1` |`false`  |`m >= c`              |
|`<=` or `>` | `\\|` |`x \\| 1 > 0` |`true`   |`m > c`               |"##,
    },
    Lint {
        label: "clippy::big_endian_bytes",
        description: r##"Checks for the usage of the `to_be_bytes` method and/or the function `from_be_bytes`."##,
    },
    Lint {
        label: "clippy::bind_instead_of_map",
        description: r##"Checks for usage of `_.and_then(|x| Some(y))`, `_.and_then(|x| Ok(y))` or
`_.or_else(|x| Err(y))`."##,
    },
    Lint {
        label: "clippy::blanket_clippy_restriction_lints",
        description: r##"Checks for `warn`/`deny`/`forbid` attributes targeting the whole clippy::restriction category."##,
    },
    Lint {
        label: "clippy::blocks_in_conditions",
        description: r##"Checks for `if` and `match` conditions that use blocks containing an
expression, statements or conditions that use closures with blocks."##,
    },
    Lint {
        label: "clippy::bool_assert_comparison",
        description: r##"This lint warns about boolean comparisons in assert-like macros."##,
    },
    Lint {
        label: "clippy::bool_comparison",
        description: r##"Checks for expressions of the form `x == true`,
`x != true` and order comparisons such as `x < true` (or vice versa) and
suggest using the variable directly."##,
    },
    Lint {
        label: "clippy::bool_to_int_with_if",
        description: r##"Instead of using an if statement to convert a bool to an int,
this lint suggests using a `from()` function or an `as` coercion."##,
    },
    Lint {
        label: "clippy::borrow_as_ptr",
        description: r##"Checks for the usage of `&expr as *const T` or
`&mut expr as *mut T`, and suggest using `ptr::addr_of` or
`ptr::addr_of_mut` instead."##,
    },
    Lint { label: "clippy::borrow_deref_ref", description: r##"Checks for `&*(&T)`."## },
    Lint {
        label: "clippy::borrow_interior_mutable_const",
        description: r##"Checks if `const` items which is interior mutable (e.g.,
contains a `Cell`, `Mutex`, `AtomicXxxx`, etc.) has been borrowed directly."##,
    },
    Lint {
        label: "clippy::borrowed_box",
        description: r##"Checks for usage of `&Box<T>` anywhere in the code.
Check the [Box documentation](https://doc.rust-lang.org/std/boxed/index.html) for more information."##,
    },
    Lint {
        label: "clippy::box_collection",
        description: r##"Checks for usage of `Box<T>` where T is a collection such as Vec anywhere in the code.
Check the [Box documentation](https://doc.rust-lang.org/std/boxed/index.html) for more information."##,
    },
    Lint {
        label: "clippy::box_default",
        description: r##"checks for `Box::new(Default::default())`, which can be written as
`Box::default()`."##,
    },
    Lint {
        label: "clippy::boxed_local",
        description: r##"Checks for usage of `Box<T>` where an unboxed `T` would
work fine."##,
    },
    Lint {
        label: "clippy::branches_sharing_code",
        description: r##"Checks if the `if` and `else` block contain shared code that can be
moved out of the blocks."##,
    },
    Lint {
        label: "clippy::builtin_type_shadow",
        description: r##"Warns if a generic shadows a built-in type."##,
    },
    Lint {
        label: "clippy::byte_char_slices",
        description: r##"Checks for hard to read slices of byte characters, that could be more easily expressed as a
byte string."##,
    },
    Lint {
        label: "clippy::bytes_count_to_len",
        description: r##"It checks for `str::bytes().count()` and suggests replacing it with
`str::len()`."##,
    },
    Lint {
        label: "clippy::bytes_nth",
        description: r##"Checks for the use of `.bytes().nth()`."##,
    },
    Lint {
        label: "clippy::cargo_common_metadata",
        description: r##"Checks to see if all common metadata is defined in
`Cargo.toml`. See: https://rust-lang-nursery.github.io/api-guidelines/documentation.html#cargotoml-includes-all-common-metadata-c-metadata"##,
    },
    Lint {
        label: "clippy::case_sensitive_file_extension_comparisons",
        description: r##"Checks for calls to `ends_with` with possible file extensions
and suggests to use a case-insensitive approach instead."##,
    },
    Lint {
        label: "clippy::cast_abs_to_unsigned",
        description: r##"Checks for usage of the `abs()` method that cast the result to unsigned."##,
    },
    Lint {
        label: "clippy::cast_enum_constructor",
        description: r##"Checks for casts from an enum tuple constructor to an integer."##,
    },
    Lint {
        label: "clippy::cast_enum_truncation",
        description: r##"Checks for casts from an enum type to an integral type which will definitely truncate the
value."##,
    },
    Lint {
        label: "clippy::cast_lossless",
        description: r##"Checks for casts between numerical types that may
be replaced by safe conversion functions."##,
    },
    Lint {
        label: "clippy::cast_nan_to_int",
        description: r##"Checks for a known NaN float being cast to an integer"##,
    },
    Lint {
        label: "clippy::cast_possible_truncation",
        description: r##"Checks for casts between numerical types that may
truncate large values. This is expected behavior, so the cast is `Allow` by
default. It suggests user either explicitly ignore the lint,
or use `try_from()` and handle the truncation, default, or panic explicitly."##,
    },
    Lint {
        label: "clippy::cast_possible_wrap",
        description: r##"Checks for casts from an unsigned type to a signed type of
the same size, or possibly smaller due to target dependent integers.
Performing such a cast is a 'no-op' for the compiler, i.e., nothing is
changed at the bit level, and the binary representation of the value is
reinterpreted. This can cause wrapping if the value is too big
for the target signed type. However, the cast works as defined, so this lint
is `Allow` by default."##,
    },
    Lint {
        label: "clippy::cast_precision_loss",
        description: r##"Checks for casts from any numerical to a float type where
the receiving type cannot store all values from the original type without
rounding errors. This possible rounding is to be expected, so this lint is
`Allow` by default.

Basically, this warns on casting any integer with 32 or more bits to `f32`
or any 64-bit integer to `f64`."##,
    },
    Lint {
        label: "clippy::cast_ptr_alignment",
        description: r##"Checks for casts, using `as` or `pointer::cast`,
from a less-strictly-aligned pointer to a more-strictly-aligned pointer"##,
    },
    Lint {
        label: "clippy::cast_sign_loss",
        description: r##"Checks for casts from a signed to an unsigned numerical
type. In this case, negative values wrap around to large positive values,
which can be quite surprising in practice. However, as the cast works as
defined, this lint is `Allow` by default."##,
    },
    Lint {
        label: "clippy::cast_slice_different_sizes",
        description: r##"Checks for `as` casts between raw pointers to slices with differently sized elements."##,
    },
    Lint {
        label: "clippy::cast_slice_from_raw_parts",
        description: r##"Checks for a raw slice being cast to a slice pointer"##,
    },
    Lint {
        label: "clippy::cfg_not_test",
        description: r##"Checks for usage of `cfg` that excludes code from `test` builds. (i.e., `#{cfg(not(test))]`)"##,
    },
    Lint {
        label: "clippy::char_lit_as_u8",
        description: r##"Checks for expressions where a character literal is cast
to `u8` and suggests using a byte literal instead."##,
    },
    Lint {
        label: "clippy::chars_last_cmp",
        description: r##"Checks for usage of `_.chars().last()` or
`_.chars().next_back()` on a `str` to check if it ends with a given char."##,
    },
    Lint {
        label: "clippy::chars_next_cmp",
        description: r##"Checks for usage of `.chars().next()` on a `str` to check
if it starts with a given char."##,
    },
    Lint {
        label: "clippy::checked_conversions",
        description: r##"Checks for explicit bounds checking when casting."##,
    },
    Lint {
        label: "clippy::clear_with_drain",
        description: r##"Checks for usage of `.drain(..)` for the sole purpose of clearing a container."##,
    },
    Lint {
        label: "clippy::clone_on_copy",
        description: r##"Checks for usage of `.clone()` on a `Copy` type."##,
    },
    Lint {
        label: "clippy::clone_on_ref_ptr",
        description: r##"Checks for usage of `.clone()` on a ref-counted pointer,
(`Rc`, `Arc`, `rc::Weak`, or `sync::Weak`), and suggests calling Clone via unified
function syntax instead (e.g., `Rc::clone(foo)`)."##,
    },
    Lint {
        label: "clippy::cloned_instead_of_copied",
        description: r##"Checks for usage of `cloned()` on an `Iterator` or `Option` where
`copied()` could be used instead."##,
    },
    Lint {
        label: "clippy::cmp_null",
        description: r##"This lint checks for equality comparisons with `ptr::null`"##,
    },
    Lint {
        label: "clippy::cmp_owned",
        description: r##"Checks for conversions to owned values just for the sake
of a comparison."##,
    },
    Lint {
        label: "clippy::cognitive_complexity",
        description: r##"Checks for methods with high cognitive complexity."##,
    },
    Lint {
        label: "clippy::collapsible_else_if",
        description: r##"Checks for collapsible `else { if ... }` expressions
that can be collapsed to `else if ...`."##,
    },
    Lint {
        label: "clippy::collapsible_if",
        description: r##"Checks for nested `if` statements which can be collapsed
by `&&`-combining their conditions."##,
    },
    Lint {
        label: "clippy::collapsible_match",
        description: r##"Finds nested `match` or `if let` expressions where the patterns may be collapsed together
without adding any branches.

Note that this lint is not intended to find _all_ cases where nested match patterns can be merged, but only
cases where merging would most likely make the code more readable."##,
    },
    Lint {
        label: "clippy::collapsible_str_replace",
        description: r##"Checks for consecutive calls to `str::replace` (2 or more)
that can be collapsed into a single call."##,
    },
    Lint {
        label: "clippy::collection_is_never_read",
        description: r##"Checks for collections that are never queried."##,
    },
    Lint {
        label: "clippy::comparison_chain",
        description: r##"Checks comparison chains written with `if` that can be
rewritten with `match` and `cmp`."##,
    },
    Lint {
        label: "clippy::comparison_to_empty",
        description: r##"Checks for comparing to an empty slice such as `` or `[]`,
and suggests using `.is_empty()` where applicable."##,
    },
    Lint {
        label: "clippy::const_is_empty",
        description: r##"It identifies calls to `.is_empty()` on constant values."##,
    },
    Lint {
        label: "clippy::copy_iterator",
        description: r##"Checks for types that implement `Copy` as well as
`Iterator`."##,
    },
    Lint {
        label: "clippy::crate_in_macro_def",
        description: r##"Checks for usage of `crate` as opposed to `$crate` in a macro definition."##,
    },
    Lint {
        label: "clippy::create_dir",
        description: r##"Checks usage of `std::fs::create_dir` and suggest using `std::fs::create_dir_all` instead."##,
    },
    Lint {
        label: "clippy::crosspointer_transmute",
        description: r##"Checks for transmutes between a type `T` and `*T`."##,
    },
    Lint {
        label: "clippy::dbg_macro",
        description: r##"Checks for usage of the [`dbg!`](https://doc.rust-lang.org/std/macro.dbg.html) macro."##,
    },
    Lint {
        label: "clippy::debug_assert_with_mut_call",
        description: r##"Checks for function/method calls with a mutable
parameter in `debug_assert!`, `debug_assert_eq!` and `debug_assert_ne!` macros."##,
    },
    Lint {
        label: "clippy::decimal_literal_representation",
        description: r##"Warns if there is a better representation for a numeric literal."##,
    },
    Lint {
        label: "clippy::declare_interior_mutable_const",
        description: r##"Checks for declaration of `const` items which is interior
mutable (e.g., contains a `Cell`, `Mutex`, `AtomicXxxx`, etc.)."##,
    },
    Lint {
        label: "clippy::default_constructed_unit_structs",
        description: r##"Checks for construction on unit struct using `default`."##,
    },
    Lint {
        label: "clippy::default_instead_of_iter_empty",
        description: r##"It checks for `std::iter::Empty::default()` and suggests replacing it with
`std::iter::empty()`."##,
    },
    Lint {
        label: "clippy::default_numeric_fallback",
        description: r##"Checks for usage of unconstrained numeric literals which may cause default numeric fallback in type
inference.

Default numeric fallback means that if numeric types have not yet been bound to concrete
types at the end of type inference, then integer type is bound to `i32`, and similarly
floating type is bound to `f64`.

See [RFC0212](https://github.com/rust-lang/rfcs/blob/master/text/0212-restore-int-fallback.md) for more information about the fallback."##,
    },
    Lint {
        label: "clippy::default_trait_access",
        description: r##"Checks for literal calls to `Default::default()`."##,
    },
    Lint {
        label: "clippy::default_union_representation",
        description: r##"Displays a warning when a union is declared with the default representation (without a `#[repr(C)]` attribute)."##,
    },
    Lint {
        label: "clippy::deprecated_cfg_attr",
        description: r##"Checks for `#[cfg_attr(rustfmt, rustfmt_skip)]` and suggests to replace it
with `#[rustfmt::skip]`."##,
    },
    Lint {
        label: "clippy::deprecated_clippy_cfg_attr",
        description: r##"Checks for `#[cfg_attr(feature = cargo-clippy, ...)]` and for
`#[cfg(feature = cargo-clippy)]` and suggests to replace it with
`#[cfg_attr(clippy, ...)]` or `#[cfg(clippy)]`."##,
    },
    Lint {
        label: "clippy::deprecated_semver",
        description: r##"Checks for `#[deprecated]` annotations with a `since`
field that is not a valid semantic version. Also allows TBD to signal
future deprecation."##,
    },
    Lint {
        label: "clippy::deref_addrof",
        description: r##"Checks for usage of `*&` and `*&mut` in expressions."##,
    },
    Lint {
        label: "clippy::deref_by_slicing",
        description: r##"Checks for slicing expressions which are equivalent to dereferencing the
value."##,
    },
    Lint {
        label: "clippy::derivable_impls",
        description: r##"Detects manual `std::default::Default` implementations that are identical to a derived implementation."##,
    },
    Lint {
        label: "clippy::derive_ord_xor_partial_ord",
        description: r##"Lints against manual `PartialOrd` and `Ord` implementations for types with a derived `Ord`
or `PartialOrd` implementation."##,
    },
    Lint {
        label: "clippy::derive_partial_eq_without_eq",
        description: r##"Checks for types that derive `PartialEq` and could implement `Eq`."##,
    },
    Lint {
        label: "clippy::derived_hash_with_manual_eq",
        description: r##"Lints against manual `PartialEq` implementations for types with a derived `Hash`
implementation."##,
    },
    Lint {
        label: "clippy::disallowed_macros",
        description: r##"Denies the configured macros in clippy.toml

Note: Even though this lint is warn-by-default, it will only trigger if
macros are defined in the clippy.toml file."##,
    },
    Lint {
        label: "clippy::disallowed_methods",
        description: r##"Denies the configured methods and functions in clippy.toml

Note: Even though this lint is warn-by-default, it will only trigger if
methods are defined in the clippy.toml file."##,
    },
    Lint {
        label: "clippy::disallowed_names",
        description: r##"Checks for usage of disallowed names for variables, such
as `foo`."##,
    },
    Lint {
        label: "clippy::disallowed_script_idents",
        description: r##"Checks for usage of unicode scripts other than those explicitly allowed
by the lint config.

This lint doesn't take into account non-text scripts such as `Unknown` and `Linear_A`.
It also ignores the `Common` script type.
While configuring, be sure to use official script name [aliases] from
[the list of supported scripts][supported_scripts].

See also: [`non_ascii_idents`].

[aliases]: http://www.unicode.org/reports/tr24/tr24-31.html#Script_Value_Aliases
[supported_scripts]: https://www.unicode.org/iso15924/iso15924-codes.html"##,
    },
    Lint {
        label: "clippy::disallowed_types",
        description: r##"Denies the configured types in clippy.toml.

Note: Even though this lint is warn-by-default, it will only trigger if
types are defined in the clippy.toml file."##,
    },
    Lint {
        label: "clippy::diverging_sub_expression",
        description: r##"Checks for diverging calls that are not match arms or
statements."##,
    },
    Lint {
        label: "clippy::doc_lazy_continuation",
        description: r##"In CommonMark Markdown, the language used to write doc comments, a
paragraph nested within a list or block quote does not need any line
after the first one to be indented or marked. The specification calls
this a lazy paragraph continuation."##,
    },
    Lint {
        label: "clippy::doc_link_with_quotes",
        description: r##"Detects the syntax `['foo']` in documentation comments (notice quotes instead of backticks)
outside of code blocks"##,
    },
    Lint {
        label: "clippy::doc_markdown",
        description: r##"Checks for the presence of `_`, `::` or camel-case words
outside ticks in documentation."##,
    },
    Lint {
        label: "clippy::double_comparisons",
        description: r##"Checks for double comparisons that could be simplified to a single expression."##,
    },
    Lint {
        label: "clippy::double_must_use",
        description: r##"Checks for a `#[must_use]` attribute without
further information on functions and methods that return a type already
marked as `#[must_use]`."##,
    },
    Lint {
        label: "clippy::double_neg",
        description: r##"Detects expressions of the form `--x`."##,
    },
    Lint {
        label: "clippy::double_parens",
        description: r##"Checks for unnecessary double parentheses."##,
    },
    Lint {
        label: "clippy::drain_collect",
        description: r##"Checks for calls to `.drain()` that clear the collection, immediately followed by a call to `.collect()`.

> Collection in this context refers to any type with a `drain` method:
> `Vec`, `VecDeque`, `BinaryHeap`, `HashSet`,`HashMap`, `String`"##,
    },
    Lint {
        label: "clippy::drop_non_drop",
        description: r##"Checks for calls to `std::mem::drop` with a value that does not implement `Drop`."##,
    },
    Lint {
        label: "clippy::duplicate_mod",
        description: r##"Checks for files that are included as modules multiple times."##,
    },
    Lint {
        label: "clippy::duplicate_underscore_argument",
        description: r##"Checks for function arguments having the similar names
differing by an underscore."##,
    },
    Lint {
        label: "clippy::duplicated_attributes",
        description: r##"Checks for attributes that appear two or more times."##,
    },
    Lint {
        label: "clippy::duration_subsec",
        description: r##"Checks for calculation of subsecond microseconds or milliseconds
from other `Duration` methods."##,
    },
    Lint {
        label: "clippy::eager_transmute",
        description: r##"Checks for integer validity checks, followed by a transmute that is (incorrectly) evaluated
eagerly (e.g. using `bool::then_some`)."##,
    },
    Lint {
        label: "clippy::else_if_without_else",
        description: r##"Checks for usage of if expressions with an `else if` branch,
but without a final `else` branch."##,
    },
    Lint { label: "clippy::empty_docs", description: r##"Detects documentation that is empty."## },
    Lint {
        label: "clippy::empty_drop",
        description: r##"Checks for empty `Drop` implementations."##,
    },
    Lint {
        label: "clippy::empty_enum",
        description: r##"Checks for `enum`s with no variants, which therefore are uninhabited types
(cannot be instantiated).

As of this writing, the `never_type` is still a nightly-only experimental API.
Therefore, this lint is only triggered if `#![feature(never_type)]` is enabled."##,
    },
    Lint {
        label: "clippy::empty_enum_variants_with_brackets",
        description: r##"Finds enum variants without fields that are declared with empty brackets."##,
    },
    Lint {
        label: "clippy::empty_line_after_doc_comments",
        description: r##"Checks for empty lines after documentation comments."##,
    },
    Lint {
        label: "clippy::empty_line_after_outer_attr",
        description: r##"Checks for empty lines after outer attributes"##,
    },
    Lint { label: "clippy::empty_loop", description: r##"Checks for empty `loop` expressions."## },
    Lint {
        label: "clippy::empty_structs_with_brackets",
        description: r##"Finds structs without fields (a so-called empty struct) that are declared with brackets."##,
    },
    Lint {
        label: "clippy::enum_clike_unportable_variant",
        description: r##"Checks for C-like enumerations that are
`repr(isize/usize)` and have values that don't fit into an `i32`."##,
    },
    Lint { label: "clippy::enum_glob_use", description: r##"Checks for `use Enum::*`."## },
    Lint {
        label: "clippy::enum_variant_names",
        description: r##"Detects enumeration variants that are prefixed or suffixed
by the same characters."##,
    },
    Lint {
        label: "clippy::eq_op",
        description: r##"Checks for equal operands to comparison, logical and
bitwise, difference and division binary operators (`==`, `>`, etc., `&&`,
`||`, `&`, `|`, `^`, `-` and `/`)."##,
    },
    Lint {
        label: "clippy::equatable_if_let",
        description: r##"Checks for pattern matchings that can be expressed using equality."##,
    },
    Lint {
        label: "clippy::erasing_op",
        description: r##"Checks for erasing operations, e.g., `x * 0`."##,
    },
    Lint {
        label: "clippy::err_expect",
        description: r##"Checks for `.err().expect()` calls on the `Result` type."##,
    },
    Lint {
        label: "clippy::error_impl_error",
        description: r##"Checks for types named `Error` that implement `Error`."##,
    },
    Lint {
        label: "clippy::excessive_nesting",
        description: r##"Checks for blocks which are nested beyond a certain threshold.

Note: Even though this lint is warn-by-default, it will only trigger if a maximum nesting level is defined in the clippy.toml file."##,
    },
    Lint {
        label: "clippy::excessive_precision",
        description: r##"Checks for float literals with a precision greater
than that supported by the underlying type."##,
    },
    Lint {
        label: "clippy::exhaustive_enums",
        description: r##"Warns on any exported `enum`s that are not tagged `#[non_exhaustive]`"##,
    },
    Lint {
        label: "clippy::exhaustive_structs",
        description: r##"Warns on any exported `struct`s that are not tagged `#[non_exhaustive]`"##,
    },
    Lint {
        label: "clippy::exit",
        description: r##"Detects calls to the `exit()` function which terminates the program."##,
    },
    Lint {
        label: "clippy::expect_fun_call",
        description: r##"Checks for calls to `.expect(&format!(...))`, `.expect(foo(..))`,
etc., and suggests to use `unwrap_or_else` instead"##,
    },
    Lint {
        label: "clippy::expect_used",
        description: r##"Checks for `.expect()` or `.expect_err()` calls on `Result`s and `.expect()` call on `Option`s."##,
    },
    Lint {
        label: "clippy::expl_impl_clone_on_copy",
        description: r##"Checks for explicit `Clone` implementations for `Copy`
types."##,
    },
    Lint {
        label: "clippy::explicit_auto_deref",
        description: r##"Checks for dereferencing expressions which would be covered by auto-deref."##,
    },
    Lint {
        label: "clippy::explicit_counter_loop",
        description: r##"Checks `for` loops over slices with an explicit counter
and suggests the use of `.enumerate()`."##,
    },
    Lint {
        label: "clippy::explicit_deref_methods",
        description: r##"Checks for explicit `deref()` or `deref_mut()` method calls."##,
    },
    Lint {
        label: "clippy::explicit_into_iter_loop",
        description: r##"Checks for loops on `y.into_iter()` where `y` will do, and
suggests the latter."##,
    },
    Lint {
        label: "clippy::explicit_iter_loop",
        description: r##"Checks for loops on `x.iter()` where `&x` will do, and
suggests the latter."##,
    },
    Lint {
        label: "clippy::explicit_write",
        description: r##"Checks for usage of `write!()` / `writeln()!` which can be
replaced with `(e)print!()` / `(e)println!()`"##,
    },
    Lint {
        label: "clippy::extend_from_slice",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::extend_with_drain",
        description: r##"Checks for occurrences where one vector gets extended instead of append"##,
    },
    Lint {
        label: "clippy::extra_unused_lifetimes",
        description: r##"Checks for lifetimes in generics that are never used
anywhere else."##,
    },
    Lint {
        label: "clippy::extra_unused_type_parameters",
        description: r##"Checks for type parameters in generics that are never used anywhere else."##,
    },
    Lint {
        label: "clippy::fallible_impl_from",
        description: r##"Checks for impls of `From<..>` that contain `panic!()` or `unwrap()`"##,
    },
    Lint {
        label: "clippy::field_reassign_with_default",
        description: r##"Checks for immediate reassignment of fields initialized
with Default::default()."##,
    },
    Lint {
        label: "clippy::field_scoped_visibility_modifiers",
        description: r##"Checks for usage of scoped visibility modifiers, like `pub(crate)`, on fields. These
make a field visible within a scope between public and private."##,
    },
    Lint {
        label: "clippy::filetype_is_file",
        description: r##"Checks for `FileType::is_file()`."##,
    },
    Lint {
        label: "clippy::filter_map",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::filter_map_bool_then",
        description: r##"Checks for usage of `bool::then` in `Iterator::filter_map`."##,
    },
    Lint {
        label: "clippy::filter_map_identity",
        description: r##"Checks for usage of `filter_map(|x| x)`."##,
    },
    Lint {
        label: "clippy::filter_map_next",
        description: r##"Checks for usage of `_.filter_map(_).next()`."##,
    },
    Lint {
        label: "clippy::filter_next",
        description: r##"Checks for usage of `_.filter(_).next()`."##,
    },
    Lint { label: "clippy::find_map", description: r##"Nothing. This lint has been deprecated."## },
    Lint {
        label: "clippy::flat_map_identity",
        description: r##"Checks for usage of `flat_map(|x| x)`."##,
    },
    Lint {
        label: "clippy::flat_map_option",
        description: r##"Checks for usage of `Iterator::flat_map()` where `filter_map()` could be
used instead."##,
    },
    Lint { label: "clippy::float_arithmetic", description: r##"Checks for float arithmetic."## },
    Lint {
        label: "clippy::float_cmp",
        description: r##"Checks for (in-)equality comparisons on floating-point
values (apart from zero), except in functions called `*eq*` (which probably
implement equality for a type involving floats)."##,
    },
    Lint {
        label: "clippy::float_cmp_const",
        description: r##"Checks for (in-)equality comparisons on floating-point
value and constant, except in functions called `*eq*` (which probably
implement equality for a type involving floats)."##,
    },
    Lint {
        label: "clippy::float_equality_without_abs",
        description: r##"Checks for statements of the form `(a - b) < f32::EPSILON` or
`(a - b) < f64::EPSILON`. Notes the missing `.abs()`."##,
    },
    Lint {
        label: "clippy::fn_address_comparisons",
        description: r##"Checks for comparisons with an address of a function item."##,
    },
    Lint {
        label: "clippy::fn_params_excessive_bools",
        description: r##"Checks for excessive use of
bools in function definitions."##,
    },
    Lint {
        label: "clippy::fn_to_numeric_cast",
        description: r##"Checks for casts of function pointers to something other than usize"##,
    },
    Lint {
        label: "clippy::fn_to_numeric_cast_any",
        description: r##"Checks for casts of a function pointer to any integer type."##,
    },
    Lint {
        label: "clippy::fn_to_numeric_cast_with_truncation",
        description: r##"Checks for casts of a function pointer to a numeric type not wide enough to
store address."##,
    },
    Lint {
        label: "clippy::for_kv_map",
        description: r##"Checks for iterating a map (`HashMap` or `BTreeMap`) and
ignoring either the keys or values."##,
    },
    Lint {
        label: "clippy::forget_non_drop",
        description: r##"Checks for calls to `std::mem::forget` with a value that does not implement `Drop`."##,
    },
    Lint {
        label: "clippy::format_collect",
        description: r##"Checks for usage of `.map(|_| format!(..)).collect::<String>()`."##,
    },
    Lint {
        label: "clippy::format_in_format_args",
        description: r##"Detects `format!` within the arguments of another macro that does
formatting such as `format!` itself, `write!` or `println!`. Suggests
inlining the `format!` call."##,
    },
    Lint {
        label: "clippy::format_push_string",
        description: r##"Detects cases where the result of a `format!` call is
appended to an existing `String`."##,
    },
    Lint {
        label: "clippy::four_forward_slashes",
        description: r##"Checks for outer doc comments written with 4 forward slashes (`////`)."##,
    },
    Lint {
        label: "clippy::from_iter_instead_of_collect",
        description: r##"Checks for `from_iter()` function calls on types that implement the `FromIterator`
trait."##,
    },
    Lint {
        label: "clippy::from_over_into",
        description: r##"Searches for implementations of the `Into<..>` trait and suggests to implement `From<..>` instead."##,
    },
    Lint {
        label: "clippy::from_raw_with_void_ptr",
        description: r##"Checks if we're passing a `c_void` raw pointer to `{Box,Rc,Arc,Weak}::from_raw(_)`"##,
    },
    Lint {
        label: "clippy::from_str_radix_10",
        description: r##"Checks for function invocations of the form `primitive::from_str_radix(s, 10)`"##,
    },
    Lint {
        label: "clippy::future_not_send",
        description: r##"This lint requires Future implementations returned from
functions and methods to implement the `Send` marker trait. It is mostly
used by library authors (public and internal) that target an audience where
multithreaded executors are likely to be used for running these Futures."##,
    },
    Lint {
        label: "clippy::get_first",
        description: r##"Checks for usage of `x.get(0)` instead of
`x.first()` or `x.front()`."##,
    },
    Lint {
        label: "clippy::get_last_with_len",
        description: r##"Checks for usage of `x.get(x.len() - 1)` instead of
`x.last()`."##,
    },
    Lint {
        label: "clippy::get_unwrap",
        description: r##"Checks for usage of `.get().unwrap()` (or
`.get_mut().unwrap`) on a standard library type which implements `Index`"##,
    },
    Lint {
        label: "clippy::host_endian_bytes",
        description: r##"Checks for the usage of the `to_ne_bytes` method and/or the function `from_ne_bytes`."##,
    },
    Lint {
        label: "clippy::identity_op",
        description: r##"Checks for identity operations, e.g., `x + 0`."##,
    },
    Lint {
        label: "clippy::if_let_mutex",
        description: r##"Checks for `Mutex::lock` calls in `if let` expression
with lock calls in any of the else blocks."##,
    },
    Lint {
        label: "clippy::if_let_redundant_pattern_matching",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::if_not_else",
        description: r##"Checks for usage of `!` or `!=` in an if condition with an
else branch."##,
    },
    Lint {
        label: "clippy::if_same_then_else",
        description: r##"Checks for `if/else` with the same body as the *then* part
and the *else* part."##,
    },
    Lint {
        label: "clippy::if_then_some_else_none",
        description: r##"Checks for if-else that could be written using either `bool::then` or `bool::then_some`."##,
    },
    Lint {
        label: "clippy::ifs_same_cond",
        description: r##"Checks for consecutive `if`s with the same condition."##,
    },
    Lint {
        label: "clippy::ignored_unit_patterns",
        description: r##"Checks for usage of `_` in patterns of type `()`."##,
    },
    Lint {
        label: "clippy::impl_hash_borrow_with_str_and_bytes",
        description: r##"This lint is concerned with the semantics of `Borrow` and `Hash` for a
type that implements all three of `Hash`, `Borrow<str>` and `Borrow<[u8]>`
as it is impossible to satisfy the semantics of Borrow and `Hash` for
both `Borrow<str>` and `Borrow<[u8]>`."##,
    },
    Lint {
        label: "clippy::impl_trait_in_params",
        description: r##"Lints when `impl Trait` is being used in a function's parameters."##,
    },
    Lint {
        label: "clippy::implicit_clone",
        description: r##"Checks for the usage of `_.to_owned()`, `vec.to_vec()`, or similar when calling `_.clone()` would be clearer."##,
    },
    Lint {
        label: "clippy::implicit_hasher",
        description: r##"Checks for public `impl` or `fn` missing generalization
over different hashers and implicitly defaulting to the default hashing
algorithm (`SipHash`)."##,
    },
    Lint {
        label: "clippy::implicit_return",
        description: r##"Checks for missing return statements at the end of a block."##,
    },
    Lint {
        label: "clippy::implicit_saturating_add",
        description: r##"Checks for implicit saturating addition."##,
    },
    Lint {
        label: "clippy::implicit_saturating_sub",
        description: r##"Checks for implicit saturating subtraction."##,
    },
    Lint {
        label: "clippy::implied_bounds_in_impls",
        description: r##"Looks for bounds in `impl Trait` in return position that are implied by other bounds.
This can happen when a trait is specified that another trait already has as a supertrait
(e.g. `fn() -> impl Deref + DerefMut<Target = i32>` has an unnecessary `Deref` bound,
because `Deref` is a supertrait of `DerefMut`)"##,
    },
    Lint {
        label: "clippy::impossible_comparisons",
        description: r##"Checks for double comparisons that can never succeed"##,
    },
    Lint {
        label: "clippy::imprecise_flops",
        description: r##"Looks for floating-point expressions that
can be expressed using built-in methods to improve accuracy
at the cost of performance."##,
    },
    Lint {
        label: "clippy::incompatible_msrv",
        description: r##"This lint checks that no function newer than the defined MSRV (minimum
supported rust version) is used in the crate."##,
    },
    Lint {
        label: "clippy::inconsistent_digit_grouping",
        description: r##"Warns if an integral or floating-point constant is
grouped inconsistently with underscores."##,
    },
    Lint {
        label: "clippy::inconsistent_struct_constructor",
        description: r##"Checks for struct constructors where all fields are shorthand and
the order of the field init shorthand in the constructor is inconsistent
with the order in the struct definition."##,
    },
    Lint {
        label: "clippy::index_refutable_slice",
        description: r##"The lint checks for slice bindings in patterns that are only used to
access individual slice values."##,
    },
    Lint {
        label: "clippy::indexing_slicing",
        description: r##"Checks for usage of indexing or slicing. Arrays are special cases, this lint
does report on arrays if we can tell that slicing operations are in bounds and does not
lint on constant `usize` indexing on arrays because that is handled by rustc's `const_err` lint."##,
    },
    Lint {
        label: "clippy::ineffective_bit_mask",
        description: r##"Checks for bit masks in comparisons which can be removed
without changing the outcome. The basic structure can be seen in the
following table:

|Comparison| Bit Op   |Example     |equals |
|----------|----------|------------|-------|
|`>` / `<=`|`\\|` / `^`|`x \\| 2 > 3`|`x > 3`|
|`<` / `>=`|`\\|` / `^`|`x ^ 1 < 4` |`x < 4`|"##,
    },
    Lint {
        label: "clippy::ineffective_open_options",
        description: r##"Checks if both `.write(true)` and `.append(true)` methods are called
on a same `OpenOptions`."##,
    },
    Lint {
        label: "clippy::inefficient_to_string",
        description: r##"Checks for usage of `.to_string()` on an `&&T` where
`T` implements `ToString` directly (like `&&str` or `&&String`)."##,
    },
    Lint {
        label: "clippy::infallible_destructuring_match",
        description: r##"Checks for matches being used to destructure a single-variant enum
or tuple struct where a `let` will suffice."##,
    },
    Lint {
        label: "clippy::infinite_iter",
        description: r##"Checks for iteration that is guaranteed to be infinite."##,
    },
    Lint {
        label: "clippy::infinite_loop",
        description: r##"Checks for infinite loops in a function where the return type is not `!`
and lint accordingly."##,
    },
    Lint {
        label: "clippy::inherent_to_string",
        description: r##"Checks for the definition of inherent methods with a signature of `to_string(&self) -> String`."##,
    },
    Lint {
        label: "clippy::inherent_to_string_shadow_display",
        description: r##"Checks for the definition of inherent methods with a signature of `to_string(&self) -> String` and if the type implementing this method also implements the `Display` trait."##,
    },
    Lint {
        label: "clippy::init_numbered_fields",
        description: r##"Checks for tuple structs initialized with field syntax.
It will however not lint if a base initializer is present.
The lint will also ignore code in macros."##,
    },
    Lint {
        label: "clippy::inline_always",
        description: r##"Checks for items annotated with `#[inline(always)]`,
unless the annotated function is empty or simply panics."##,
    },
    Lint {
        label: "clippy::inline_asm_x86_att_syntax",
        description: r##"Checks for usage of AT&T x86 assembly syntax."##,
    },
    Lint {
        label: "clippy::inline_asm_x86_intel_syntax",
        description: r##"Checks for usage of Intel x86 assembly syntax."##,
    },
    Lint {
        label: "clippy::inline_fn_without_body",
        description: r##"Checks for `#[inline]` on trait methods without bodies"##,
    },
    Lint {
        label: "clippy::inspect_for_each",
        description: r##"Checks for usage of `inspect().for_each()`."##,
    },
    Lint {
        label: "clippy::int_plus_one",
        description: r##"Checks for usage of `x >= y + 1` or `x - 1 >= y` (and `<=`) in a block"##,
    },
    Lint { label: "clippy::integer_division", description: r##"Checks for division of integers"## },
    Lint {
        label: "clippy::integer_division_remainder_used",
        description: r##"Checks for the usage of division (`/`) and remainder (`%`) operations
when performed on any integer types using the default `Div` and `Rem` trait implementations."##,
    },
    Lint {
        label: "clippy::into_iter_on_ref",
        description: r##"Checks for `into_iter` calls on references which should be replaced by `iter`
or `iter_mut`."##,
    },
    Lint {
        label: "clippy::into_iter_without_iter",
        description: r##"This is the opposite of the `iter_without_into_iter` lint.
It looks for `IntoIterator for (&|&mut) Type` implementations without an inherent `iter` or `iter_mut` method
on the type or on any of the types in its `Deref` chain."##,
    },
    Lint {
        label: "clippy::invalid_null_ptr_usage",
        description: r##"This lint checks for invalid usages of `ptr::null`."##,
    },
    Lint {
        label: "clippy::invalid_regex",
        description: r##"Checks [regex](https://crates.io/crates/regex) creation
(with `Regex::new`, `RegexBuilder::new`, or `RegexSet::new`) for correct
regex syntax."##,
    },
    Lint {
        label: "clippy::invalid_upcast_comparisons",
        description: r##"Checks for comparisons where the relation is always either
true or false, but where one side has been upcast so that the comparison is
necessary. Only integer types are checked."##,
    },
    Lint {
        label: "clippy::invisible_characters",
        description: r##"Checks for invisible Unicode characters in the code."##,
    },
    Lint {
        label: "clippy::is_digit_ascii_radix",
        description: r##"Finds usages of [`char::is_digit`](https://doc.rust-lang.org/stable/std/primitive.char.html#method.is_digit) that
can be replaced with [`is_ascii_digit`](https://doc.rust-lang.org/stable/std/primitive.char.html#method.is_ascii_digit) or
[`is_ascii_hexdigit`](https://doc.rust-lang.org/stable/std/primitive.char.html#method.is_ascii_hexdigit)."##,
    },
    Lint {
        label: "clippy::items_after_statements",
        description: r##"Checks for items declared after some statement in a block."##,
    },
    Lint {
        label: "clippy::items_after_test_module",
        description: r##"Triggers if an item is declared after the testing module marked with `#[cfg(test)]`."##,
    },
    Lint {
        label: "clippy::iter_cloned_collect",
        description: r##"Checks for the use of `.cloned().collect()` on slice to
create a `Vec`."##,
    },
    Lint {
        label: "clippy::iter_count",
        description: r##"Checks for the use of `.iter().count()`."##,
    },
    Lint {
        label: "clippy::iter_filter_is_ok",
        description: r##"Checks for usage of `.filter(Result::is_ok)` that may be replaced with a `.flatten()` call.
This lint will require additional changes to the follow-up calls as it affects the type."##,
    },
    Lint {
        label: "clippy::iter_filter_is_some",
        description: r##"Checks for usage of `.filter(Option::is_some)` that may be replaced with a `.flatten()` call.
This lint will require additional changes to the follow-up calls as it affects the type."##,
    },
    Lint {
        label: "clippy::iter_kv_map",
        description: r##"Checks for iterating a map (`HashMap` or `BTreeMap`) and
ignoring either the keys or values."##,
    },
    Lint { label: "clippy::iter_next_loop", description: r##"Checks for loops on `x.next()`."## },
    Lint {
        label: "clippy::iter_next_slice",
        description: r##"Checks for usage of `iter().next()` on a Slice or an Array"##,
    },
    Lint {
        label: "clippy::iter_not_returning_iterator",
        description: r##"Detects methods named `iter` or `iter_mut` that do not have a return type that implements `Iterator`."##,
    },
    Lint {
        label: "clippy::iter_nth",
        description: r##"Checks for usage of `.iter().nth()`/`.iter_mut().nth()` on standard library types that have
equivalent `.get()`/`.get_mut()` methods."##,
    },
    Lint {
        label: "clippy::iter_nth_zero",
        description: r##"Checks for the use of `iter.nth(0)`."##,
    },
    Lint {
        label: "clippy::iter_on_empty_collections",
        description: r##"Checks for calls to `iter`, `iter_mut` or `into_iter` on empty collections"##,
    },
    Lint {
        label: "clippy::iter_on_single_items",
        description: r##"Checks for calls to `iter`, `iter_mut` or `into_iter` on collections containing a single item"##,
    },
    Lint {
        label: "clippy::iter_out_of_bounds",
        description: r##"Looks for iterator combinator calls such as `.take(x)` or `.skip(x)`
where `x` is greater than the amount of items that an iterator will produce."##,
    },
    Lint {
        label: "clippy::iter_over_hash_type",
        description: r##"This is a restriction lint which prevents the use of hash types (i.e., `HashSet` and `HashMap`) in for loops."##,
    },
    Lint {
        label: "clippy::iter_overeager_cloned",
        description: r##"Checks for usage of `_.cloned().<func>()` where call to `.cloned()` can be postponed."##,
    },
    Lint {
        label: "clippy::iter_skip_next",
        description: r##"Checks for usage of `.skip(x).next()` on iterators."##,
    },
    Lint {
        label: "clippy::iter_skip_zero",
        description: r##"Checks for usage of `.skip(0)` on iterators."##,
    },
    Lint {
        label: "clippy::iter_with_drain",
        description: r##"Checks for usage of `.drain(..)` on `Vec` and `VecDeque` for iteration."##,
    },
    Lint {
        label: "clippy::iter_without_into_iter",
        description: r##"Looks for `iter` and `iter_mut` methods without an associated `IntoIterator for (&|&mut) Type` implementation."##,
    },
    Lint {
        label: "clippy::iterator_step_by_zero",
        description: r##"Checks for calling `.step_by(0)` on iterators which panics."##,
    },
    Lint {
        label: "clippy::join_absolute_paths",
        description: r##"Checks for calls to `Path::join` that start with a path separator (`\\\\` or `/`)."##,
    },
    Lint {
        label: "clippy::just_underscores_and_digits",
        description: r##"Checks if you have variables whose name consists of just
underscores and digits."##,
    },
    Lint {
        label: "clippy::large_const_arrays",
        description: r##"Checks for large `const` arrays that should
be defined as `static` instead."##,
    },
    Lint {
        label: "clippy::large_digit_groups",
        description: r##"Warns if the digits of an integral or floating-point
constant are grouped into groups that
are too large."##,
    },
    Lint {
        label: "clippy::large_enum_variant",
        description: r##"Checks for large size differences between variants on
`enum`s."##,
    },
    Lint {
        label: "clippy::large_futures",
        description: r##"It checks for the size of a `Future` created by `async fn` or `async {}`."##,
    },
    Lint {
        label: "clippy::large_include_file",
        description: r##"Checks for the inclusion of large files via `include_bytes!()`
or `include_str!()`."##,
    },
    Lint {
        label: "clippy::large_stack_arrays",
        description: r##"Checks for local arrays that may be too large."##,
    },
    Lint {
        label: "clippy::large_stack_frames",
        description: r##"Checks for functions that use a lot of stack space.

This often happens when constructing a large type, such as an array with a lot of elements,
or constructing *many* smaller-but-still-large structs, or copying around a lot of large types.

This lint is a more general version of [`large_stack_arrays`](https://rust-lang.github.io/rust-clippy/master/#large_stack_arrays)
that is intended to look at functions as a whole instead of only individual array expressions inside of a function."##,
    },
    Lint {
        label: "clippy::large_types_passed_by_value",
        description: r##"Checks for functions taking arguments by value, where
the argument type is `Copy` and large enough to be worth considering
passing by reference. Does not trigger if the function is being exported,
because that might induce API breakage, if the parameter is declared as mutable,
or if the argument is a `self`."##,
    },
    Lint {
        label: "clippy::legacy_numeric_constants",
        description: r##"Checks for usage of `<integer>::max_value()`, `std::<integer>::MAX`,
`std::<float>::EPSILON`, etc."##,
    },
    Lint {
        label: "clippy::len_without_is_empty",
        description: r##"Checks for items that implement `.len()` but not
`.is_empty()`."##,
    },
    Lint {
        label: "clippy::len_zero",
        description: r##"Checks for getting the length of something via `.len()`
just to compare to zero, and suggests using `.is_empty()` where applicable."##,
    },
    Lint {
        label: "clippy::let_and_return",
        description: r##"Checks for `let`-bindings, which are subsequently
returned."##,
    },
    Lint {
        label: "clippy::let_underscore_future",
        description: r##"Checks for `let _ = <expr>` where the resulting type of expr implements `Future`"##,
    },
    Lint {
        label: "clippy::let_underscore_lock",
        description: r##"Checks for `let _ = sync_lock`. This supports `mutex` and `rwlock` in
`parking_lot`. For `std` locks see the `rustc` lint
[`let_underscore_lock`](https://doc.rust-lang.org/nightly/rustc/lints/listing/deny-by-default.html#let-underscore-lock)"##,
    },
    Lint {
        label: "clippy::let_underscore_must_use",
        description: r##"Checks for `let _ = <expr>` where expr is `#[must_use]`"##,
    },
    Lint {
        label: "clippy::let_underscore_untyped",
        description: r##"Checks for `let _ = <expr>` without a type annotation, and suggests to either provide one,
or remove the `let` keyword altogether."##,
    },
    Lint { label: "clippy::let_unit_value", description: r##"Checks for binding a unit value."## },
    Lint {
        label: "clippy::let_with_type_underscore",
        description: r##"Detects when a variable is declared with an explicit type of `_`."##,
    },
    Lint {
        label: "clippy::lines_filter_map_ok",
        description: r##"Checks for usage of `lines.filter_map(Result::ok)` or `lines.flat_map(Result::ok)`
when `lines` has type `std::io::Lines`."##,
    },
    Lint {
        label: "clippy::linkedlist",
        description: r##"Checks for usage of any `LinkedList`, suggesting to use a
`Vec` or a `VecDeque` (formerly called `RingBuf`)."##,
    },
    Lint {
        label: "clippy::lint_groups_priority",
        description: r##"Checks for lint groups with the same priority as lints in the `Cargo.toml`
[`[lints]` table](https://doc.rust-lang.org/cargo/reference/manifest.html#the-lints-section).

This lint will be removed once [cargo#12918](https://github.com/rust-lang/cargo/issues/12918)
is resolved."##,
    },
    Lint {
        label: "clippy::little_endian_bytes",
        description: r##"Checks for the usage of the `to_le_bytes` method and/or the function `from_le_bytes`."##,
    },
    Lint {
        label: "clippy::lossy_float_literal",
        description: r##"Checks for whole number float literals that
cannot be represented as the underlying type without loss."##,
    },
    Lint {
        label: "clippy::macro_metavars_in_unsafe",
        description: r##"Looks for macros that expand metavariables in an unsafe block."##,
    },
    Lint {
        label: "clippy::macro_use_imports",
        description: r##"Checks for `#[macro_use] use...`."##,
    },
    Lint {
        label: "clippy::main_recursion",
        description: r##"Checks for recursion using the entrypoint."##,
    },
    Lint {
        label: "clippy::manual_assert",
        description: r##"Detects `if`-then-`panic!` that can be replaced with `assert!`."##,
    },
    Lint {
        label: "clippy::manual_async_fn",
        description: r##"It checks for manual implementations of `async` functions."##,
    },
    Lint {
        label: "clippy::manual_bits",
        description: r##"Checks for usage of `std::mem::size_of::<T>() * 8` when
`T::BITS` is available."##,
    },
    Lint {
        label: "clippy::manual_c_str_literals",
        description: r##"Checks for the manual creation of C strings (a string with a `NUL` byte at the end), either
through one of the `CStr` constructor functions, or more plainly by calling `.as_ptr()`
on a (byte) string literal with a hardcoded `\\0` byte at the end."##,
    },
    Lint {
        label: "clippy::manual_clamp",
        description: r##"Identifies good opportunities for a clamp function from std or core, and suggests using it."##,
    },
    Lint {
        label: "clippy::manual_filter",
        description: r##"Checks for usage of `match` which could be implemented using `filter`"##,
    },
    Lint {
        label: "clippy::manual_filter_map",
        description: r##"Checks for usage of `_.filter(_).map(_)` that can be written more simply
as `filter_map(_)`."##,
    },
    Lint {
        label: "clippy::manual_find",
        description: r##"Checks for manual implementations of Iterator::find"##,
    },
    Lint {
        label: "clippy::manual_find_map",
        description: r##"Checks for usage of `_.find(_).map(_)` that can be written more simply
as `find_map(_)`."##,
    },
    Lint {
        label: "clippy::manual_flatten",
        description: r##"Checks for unnecessary `if let` usage in a for loop
where only the `Some` or `Ok` variant of the iterator element is used."##,
    },
    Lint {
        label: "clippy::manual_hash_one",
        description: r##"Checks for cases where [`BuildHasher::hash_one`] can be used.

[`BuildHasher::hash_one`]: https://doc.rust-lang.org/std/hash/trait.BuildHasher.html#method.hash_one"##,
    },
    Lint {
        label: "clippy::manual_inspect",
        description: r##"Checks for uses of `map` which return the original item."##,
    },
    Lint {
        label: "clippy::manual_instant_elapsed",
        description: r##"Lints subtraction between `Instant::now()` and another `Instant`."##,
    },
    Lint {
        label: "clippy::manual_is_ascii_check",
        description: r##"Suggests to use dedicated built-in methods,
`is_ascii_(lowercase|uppercase|digit|hexdigit)` for checking on corresponding
ascii range"##,
    },
    Lint {
        label: "clippy::manual_is_finite",
        description: r##"Checks for manual `is_finite` reimplementations
(i.e., `x != <float>::INFINITY && x != <float>::NEG_INFINITY`)."##,
    },
    Lint {
        label: "clippy::manual_is_infinite",
        description: r##"Checks for manual `is_infinite` reimplementations
(i.e., `x == <float>::INFINITY || x == <float>::NEG_INFINITY`)."##,
    },
    Lint {
        label: "clippy::manual_is_variant_and",
        description: r##"Checks for usage of `option.map(f).unwrap_or_default()` and `result.map(f).unwrap_or_default()` where f is a function or closure that returns the `bool` type."##,
    },
    Lint {
        label: "clippy::manual_let_else",
        description: r##"Warn of cases where `let...else` could be used"##,
    },
    Lint {
        label: "clippy::manual_main_separator_str",
        description: r##"Checks for references on `std::path::MAIN_SEPARATOR.to_string()` used
to build a `&str`."##,
    },
    Lint {
        label: "clippy::manual_map",
        description: r##"Checks for usage of `match` which could be implemented using `map`"##,
    },
    Lint {
        label: "clippy::manual_memcpy",
        description: r##"Checks for for-loops that manually copy items between
slices that could be optimized by having a memcpy."##,
    },
    Lint {
        label: "clippy::manual_next_back",
        description: r##"Checks for `.rev().next()` on a `DoubleEndedIterator`"##,
    },
    Lint {
        label: "clippy::manual_non_exhaustive",
        description: r##"Checks for manual implementations of the non-exhaustive pattern."##,
    },
    Lint {
        label: "clippy::manual_ok_or",
        description: r##"Finds patterns that reimplement `Option::ok_or`."##,
    },
    Lint {
        label: "clippy::manual_pattern_char_comparison",
        description: r##"Checks for manual `char` comparison in string patterns"##,
    },
    Lint {
        label: "clippy::manual_range_contains",
        description: r##"Checks for expressions like `x >= 3 && x < 8` that could
be more readably expressed as `(3..8).contains(x)`."##,
    },
    Lint {
        label: "clippy::manual_range_patterns",
        description: r##"Looks for combined OR patterns that are all contained in a specific range,
e.g. `6 | 4 | 5 | 9 | 7 | 8` can be rewritten as `4..=9`."##,
    },
    Lint {
        label: "clippy::manual_rem_euclid",
        description: r##"Checks for an expression like `((x % 4) + 4) % 4` which is a common manual reimplementation
of `x.rem_euclid(4)`."##,
    },
    Lint {
        label: "clippy::manual_retain",
        description: r##"Checks for code to be replaced by `.retain()`."##,
    },
    Lint {
        label: "clippy::manual_rotate",
        description: r##"It detects manual bit rotations that could be rewritten using standard
functions `rotate_left` or `rotate_right`."##,
    },
    Lint {
        label: "clippy::manual_saturating_arithmetic",
        description: r##"Checks for `.checked_add/sub(x).unwrap_or(MAX/MIN)`."##,
    },
    Lint {
        label: "clippy::manual_slice_size_calculation",
        description: r##"When `a` is `&[T]`, detect `a.len() * size_of::<T>()` and suggest `size_of_val(a)`
instead."##,
    },
    Lint {
        label: "clippy::manual_split_once",
        description: r##"Checks for usage of `str::splitn(2, _)`"##,
    },
    Lint {
        label: "clippy::manual_str_repeat",
        description: r##"Checks for manual implementations of `str::repeat`"##,
    },
    Lint {
        label: "clippy::manual_string_new",
        description: r##"Checks for usage of `` to create a `String`, such as `.to_string()`, `.to_owned()`,
`String::from()` and others."##,
    },
    Lint {
        label: "clippy::manual_strip",
        description: r##"Suggests using `strip_{prefix,suffix}` over `str::{starts,ends}_with` and slicing using
the pattern's length."##,
    },
    Lint {
        label: "clippy::manual_swap",
        description: r##"Checks for manual swapping.

Note that the lint will not be emitted in const blocks, as the suggestion would not be applicable."##,
    },
    Lint {
        label: "clippy::manual_try_fold",
        description: r##"Checks for usage of `Iterator::fold` with a type that implements `Try`."##,
    },
    Lint {
        label: "clippy::manual_unwrap_or",
        description: r##"Finds patterns that reimplement `Option::unwrap_or` or `Result::unwrap_or`."##,
    },
    Lint {
        label: "clippy::manual_unwrap_or_default",
        description: r##"Checks if a `match` or `if let` expression can be simplified using
`.unwrap_or_default()`."##,
    },
    Lint {
        label: "clippy::manual_while_let_some",
        description: r##"Looks for loops that check for emptiness of a `Vec` in the condition and pop an element
in the body as a separate operation."##,
    },
    Lint {
        label: "clippy::many_single_char_names",
        description: r##"Checks for too many variables whose name consists of a
single character."##,
    },
    Lint {
        label: "clippy::map_clone",
        description: r##"Checks for usage of `map(|x| x.clone())` or
dereferencing closures for `Copy` types, on `Iterator` or `Option`,
and suggests `cloned()` or `copied()` instead"##,
    },
    Lint {
        label: "clippy::map_collect_result_unit",
        description: r##"Checks for usage of `_.map(_).collect::<Result<(), _>()`."##,
    },
    Lint {
        label: "clippy::map_entry",
        description: r##"Checks for usage of `contains_key` + `insert` on `HashMap`
or `BTreeMap`."##,
    },
    Lint {
        label: "clippy::map_err_ignore",
        description: r##"Checks for instances of `map_err(|_| Some::Enum)`"##,
    },
    Lint {
        label: "clippy::map_flatten",
        description: r##"Checks for usage of `_.map(_).flatten(_)` on `Iterator` and `Option`"##,
    },
    Lint {
        label: "clippy::map_identity",
        description: r##"Checks for instances of `map(f)` where `f` is the identity function."##,
    },
    Lint {
        label: "clippy::map_unwrap_or",
        description: r##"Checks for usage of `option.map(_).unwrap_or(_)` or `option.map(_).unwrap_or_else(_)` or
`result.map(_).unwrap_or_else(_)`."##,
    },
    Lint {
        label: "clippy::match_as_ref",
        description: r##"Checks for match which is used to add a reference to an
`Option` value."##,
    },
    Lint {
        label: "clippy::match_bool",
        description: r##"Checks for matches where match expression is a `bool`. It
suggests to replace the expression with an `if...else` block."##,
    },
    Lint {
        label: "clippy::match_like_matches_macro",
        description: r##"Checks for `match`  or `if let` expressions producing a
`bool` that could be written using `matches!`"##,
    },
    Lint {
        label: "clippy::match_on_vec_items",
        description: r##"Checks for `match vec[idx]` or `match vec[n..m]`."##,
    },
    Lint {
        label: "clippy::match_overlapping_arm",
        description: r##"Checks for overlapping match arms."##,
    },
    Lint {
        label: "clippy::match_ref_pats",
        description: r##"Checks for matches where all arms match a reference,
suggesting to remove the reference and deref the matched expression
instead. It also checks for `if let &foo = bar` blocks."##,
    },
    Lint {
        label: "clippy::match_result_ok",
        description: r##"Checks for unnecessary `ok()` in `while let`."##,
    },
    Lint {
        label: "clippy::match_same_arms",
        description: r##"Checks for `match` with identical arm bodies.

Note: Does not lint on wildcards if the `non_exhaustive_omitted_patterns_lint` feature is
enabled and disallowed."##,
    },
    Lint {
        label: "clippy::match_single_binding",
        description: r##"Checks for useless match that binds to only one value."##,
    },
    Lint {
        label: "clippy::match_str_case_mismatch",
        description: r##"Checks for `match` expressions modifying the case of a string with non-compliant arms"##,
    },
    Lint {
        label: "clippy::match_wild_err_arm",
        description: r##"Checks for arm which matches all errors with `Err(_)`
and take drastic actions like `panic!`."##,
    },
    Lint {
        label: "clippy::match_wildcard_for_single_variants",
        description: r##"Checks for wildcard enum matches for a single variant."##,
    },
    Lint {
        label: "clippy::maybe_infinite_iter",
        description: r##"Checks for iteration that may be infinite."##,
    },
    Lint {
        label: "clippy::maybe_misused_cfg",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::mem_forget",
        description: r##"Checks for usage of `std::mem::forget(t)` where `t` is
`Drop` or has a field that implements `Drop`."##,
    },
    Lint {
        label: "clippy::mem_replace_option_with_none",
        description: r##"Checks for `mem::replace()` on an `Option` with
`None`."##,
    },
    Lint {
        label: "clippy::mem_replace_with_default",
        description: r##"Checks for `std::mem::replace` on a value of type
`T` with `T::default()`."##,
    },
    Lint {
        label: "clippy::mem_replace_with_uninit",
        description: r##"Checks for `mem::replace(&mut _, mem::uninitialized())`
and `mem::replace(&mut _, mem::zeroed())`."##,
    },
    Lint {
        label: "clippy::min_ident_chars",
        description: r##"Checks for identifiers which consist of a single character (or fewer than the configured threshold).

Note: This lint can be very noisy when enabled; it may be desirable to only enable it
temporarily."##,
    },
    Lint {
        label: "clippy::min_max",
        description: r##"Checks for expressions where `std::cmp::min` and `max` are
used to clamp values, but switched so that the result is constant."##,
    },
    Lint {
        label: "clippy::misaligned_transmute",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::mismatched_target_os",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::mismatching_type_param_order",
        description: r##"Checks for type parameters which are positioned inconsistently between
a type definition and impl block. Specifically, a parameter in an impl
block which has the same name as a parameter in the type def, but is in
a different place."##,
    },
    Lint {
        label: "clippy::misnamed_getters",
        description: r##"Checks for getter methods that return a field that doesn't correspond
to the name of the method, when there is a field's whose name matches that of the method."##,
    },
    Lint {
        label: "clippy::misrefactored_assign_op",
        description: r##"Checks for `a op= a op b` or `a op= b op a` patterns."##,
    },
    Lint {
        label: "clippy::missing_assert_message",
        description: r##"Checks assertions without a custom panic message."##,
    },
    Lint {
        label: "clippy::missing_asserts_for_indexing",
        description: r##"Checks for repeated slice indexing without asserting beforehand that the length
is greater than the largest index used to index into the slice."##,
    },
    Lint {
        label: "clippy::missing_const_for_fn",
        description: r##"Suggests the use of `const` in functions and methods where possible."##,
    },
    Lint {
        label: "clippy::missing_const_for_thread_local",
        description: r##"Suggests to use `const` in `thread_local!` macro if possible."##,
    },
    Lint {
        label: "clippy::missing_docs_in_private_items",
        description: r##"Warns if there is missing documentation for any private documentable item."##,
    },
    Lint {
        label: "clippy::missing_enforced_import_renames",
        description: r##"Checks for imports that do not rename the item as specified
in the `enforced-import-renames` config option.

Note: Even though this lint is warn-by-default, it will only trigger if
import renames are defined in the `clippy.toml` file."##,
    },
    Lint {
        label: "clippy::missing_errors_doc",
        description: r##"Checks the doc comments of publicly visible functions that
return a `Result` type and warns if there is no `# Errors` section."##,
    },
    Lint {
        label: "clippy::missing_fields_in_debug",
        description: r##"Checks for manual [`core::fmt::Debug`](https://doc.rust-lang.org/core/fmt/trait.Debug.html) implementations that do not use all fields."##,
    },
    Lint {
        label: "clippy::missing_inline_in_public_items",
        description: r##"It lints if an exported function, method, trait method with default impl,
or trait method impl is not `#[inline]`."##,
    },
    Lint {
        label: "clippy::missing_panics_doc",
        description: r##"Checks the doc comments of publicly visible functions that
may panic and warns if there is no `# Panics` section."##,
    },
    Lint {
        label: "clippy::missing_safety_doc",
        description: r##"Checks for the doc comments of publicly visible
unsafe functions and warns if there is no `# Safety` section."##,
    },
    Lint { label: "clippy::missing_spin_loop", description: r##"Checks for empty spin loops"## },
    Lint {
        label: "clippy::missing_trait_methods",
        description: r##"Checks if a provided method is used implicitly by a trait
implementation."##,
    },
    Lint {
        label: "clippy::missing_transmute_annotations",
        description: r##"Checks if transmute calls have all generics specified."##,
    },
    Lint {
        label: "clippy::mistyped_literal_suffixes",
        description: r##"Warns for mistyped suffix in literals"##,
    },
    Lint {
        label: "clippy::mixed_attributes_style",
        description: r##"Checks for items that have the same kind of attributes with mixed styles (inner/outer)."##,
    },
    Lint {
        label: "clippy::mixed_case_hex_literals",
        description: r##"Warns on hexadecimal literals with mixed-case letter
digits."##,
    },
    Lint {
        label: "clippy::mixed_read_write_in_expression",
        description: r##"Checks for a read and a write to the same variable where
whether the read occurs before or after the write depends on the evaluation
order of sub-expressions."##,
    },
    Lint {
        label: "clippy::mod_module_files",
        description: r##"Checks that module layout uses only self named module files; bans `mod.rs` files."##,
    },
    Lint {
        label: "clippy::module_inception",
        description: r##"Checks for modules that have the same name as their
parent module"##,
    },
    Lint {
        label: "clippy::module_name_repetitions",
        description: r##"Detects type names that are prefixed or suffixed by the
containing module's name."##,
    },
    Lint { label: "clippy::modulo_arithmetic", description: r##"Checks for modulo arithmetic."## },
    Lint {
        label: "clippy::modulo_one",
        description: r##"Checks for getting the remainder of a division by one or minus
one."##,
    },
    Lint { label: "clippy::multi_assignments", description: r##"Checks for nested assignments."## },
    Lint {
        label: "clippy::multiple_bound_locations",
        description: r##"Check if a generic is defined both in the bound predicate and in the `where` clause."##,
    },
    Lint {
        label: "clippy::multiple_crate_versions",
        description: r##"Checks to see if multiple versions of a crate are being
used."##,
    },
    Lint {
        label: "clippy::multiple_inherent_impl",
        description: r##"Checks for multiple inherent implementations of a struct"##,
    },
    Lint {
        label: "clippy::multiple_unsafe_ops_per_block",
        description: r##"Checks for `unsafe` blocks that contain more than one unsafe operation."##,
    },
    Lint {
        label: "clippy::must_use_candidate",
        description: r##"Checks for public functions that have no
`#[must_use]` attribute, but return something not already marked
must-use, have no mutable arg and mutate no statics."##,
    },
    Lint {
        label: "clippy::must_use_unit",
        description: r##"Checks for a `#[must_use]` attribute on
unit-returning functions and methods."##,
    },
    Lint {
        label: "clippy::mut_from_ref",
        description: r##"This lint checks for functions that take immutable references and return
mutable ones. This will not trigger if no unsafe code exists as there
are multiple safe functions which will do this transformation

To be on the conservative side, if there's at least one mutable
reference with the output lifetime, this lint will not trigger."##,
    },
    Lint {
        label: "clippy::mut_mut",
        description: r##"Checks for instances of `mut mut` references."##,
    },
    Lint {
        label: "clippy::mut_mutex_lock",
        description: r##"Checks for `&mut Mutex::lock` calls"##,
    },
    Lint {
        label: "clippy::mut_range_bound",
        description: r##"Checks for loops with a range bound that is a mutable variable."##,
    },
    Lint {
        label: "clippy::mutable_key_type",
        description: r##"Checks for sets/maps with mutable key types."##,
    },
    Lint {
        label: "clippy::mutex_atomic",
        description: r##"Checks for usage of `Mutex<X>` where an atomic will do."##,
    },
    Lint {
        label: "clippy::mutex_integer",
        description: r##"Checks for usage of `Mutex<X>` where `X` is an integral
type."##,
    },
    Lint { label: "clippy::naive_bytecount", description: r##"Checks for naive byte counts"## },
    Lint {
        label: "clippy::needless_arbitrary_self_type",
        description: r##"The lint checks for `self` in fn parameters that
specify the `Self`-type explicitly"##,
    },
    Lint {
        label: "clippy::needless_bitwise_bool",
        description: r##"Checks for usage of bitwise and/or operators between booleans, where performance may be improved by using
a lazy and."##,
    },
    Lint {
        label: "clippy::needless_bool",
        description: r##"Checks for expressions of the form `if c { true } else {
false }` (or vice versa) and suggests using the condition directly."##,
    },
    Lint {
        label: "clippy::needless_bool_assign",
        description: r##"Checks for expressions of the form `if c { x = true } else { x = false }`
(or vice versa) and suggest assigning the variable directly from the
condition."##,
    },
    Lint {
        label: "clippy::needless_borrow",
        description: r##"Checks for address of operations (`&`) that are going to
be dereferenced immediately by the compiler."##,
    },
    Lint {
        label: "clippy::needless_borrowed_reference",
        description: r##"Checks for bindings that needlessly destructure a reference and borrow the inner
value with `&ref`."##,
    },
    Lint {
        label: "clippy::needless_borrows_for_generic_args",
        description: r##"Checks for borrow operations (`&`) that are used as a generic argument to a
function when the borrowed value could be used."##,
    },
    Lint {
        label: "clippy::needless_character_iteration",
        description: r##"Checks if an iterator is used to check if a string is ascii."##,
    },
    Lint {
        label: "clippy::needless_collect",
        description: r##"Checks for functions collecting an iterator when collect
is not needed."##,
    },
    Lint {
        label: "clippy::needless_continue",
        description: r##"The lint checks for `if`-statements appearing in loops
that contain a `continue` statement in either their main blocks or their
`else`-blocks, when omitting the `else`-block possibly with some
rearrangement of code can make the code easier to understand."##,
    },
    Lint {
        label: "clippy::needless_doctest_main",
        description: r##"Checks for `fn main() { .. }` in doctests"##,
    },
    Lint { label: "clippy::needless_else", description: r##"Checks for empty `else` branches."## },
    Lint {
        label: "clippy::needless_for_each",
        description: r##"Checks for usage of `for_each` that would be more simply written as a
`for` loop."##,
    },
    Lint {
        label: "clippy::needless_if",
        description: r##"Checks for empty `if` branches with no else branch."##,
    },
    Lint {
        label: "clippy::needless_late_init",
        description: r##"Checks for late initializations that can be replaced by a `let` statement
with an initializer."##,
    },
    Lint {
        label: "clippy::needless_lifetimes",
        description: r##"Checks for lifetime annotations which can be removed by
relying on lifetime elision."##,
    },
    Lint {
        label: "clippy::needless_match",
        description: r##"Checks for unnecessary `match` or match-like `if let` returns for `Option` and `Result`
when function signatures are the same."##,
    },
    Lint {
        label: "clippy::needless_maybe_sized",
        description: r##"Lints `?Sized` bounds applied to type parameters that cannot be unsized"##,
    },
    Lint {
        label: "clippy::needless_option_as_deref",
        description: r##"Checks for no-op uses of `Option::{as_deref, as_deref_mut}`,
for example, `Option<&T>::as_deref()` returns the same type."##,
    },
    Lint {
        label: "clippy::needless_option_take",
        description: r##"Checks for calling `take` function after `as_ref`."##,
    },
    Lint {
        label: "clippy::needless_parens_on_range_literals",
        description: r##"The lint checks for parenthesis on literals in range statements that are
superfluous."##,
    },
    Lint {
        label: "clippy::needless_pass_by_ref_mut",
        description: r##"Check if a `&mut` function argument is actually used mutably.

Be careful if the function is publicly reexported as it would break compatibility with
users of this function, when the users pass this function as an argument."##,
    },
    Lint {
        label: "clippy::needless_pass_by_value",
        description: r##"Checks for functions taking arguments by value, but not
consuming them in its
body."##,
    },
    Lint {
        label: "clippy::needless_pub_self",
        description: r##"Checks for usage of `pub(self)` and `pub(in self)`."##,
    },
    Lint {
        label: "clippy::needless_question_mark",
        description: r##"Suggests alternatives for useless applications of `?` in terminating expressions"##,
    },
    Lint {
        label: "clippy::needless_range_loop",
        description: r##"Checks for looping over the range of `0..len` of some
collection just to get the values by index."##,
    },
    Lint {
        label: "clippy::needless_raw_string_hashes",
        description: r##"Checks for raw string literals with an unnecessary amount of hashes around them."##,
    },
    Lint {
        label: "clippy::needless_raw_strings",
        description: r##"Checks for raw string literals where a string literal can be used instead."##,
    },
    Lint {
        label: "clippy::needless_return",
        description: r##"Checks for return statements at the end of a block."##,
    },
    Lint {
        label: "clippy::needless_return_with_question_mark",
        description: r##"Checks for return statements on `Err` paired with the `?` operator."##,
    },
    Lint {
        label: "clippy::needless_splitn",
        description: r##"Checks for usage of `str::splitn` (or `str::rsplitn`) where using `str::split` would be the same."##,
    },
    Lint {
        label: "clippy::needless_update",
        description: r##"Checks for needlessly including a base struct on update
when all fields are changed anyway.

This lint is not applied to structs marked with
[non_exhaustive](https://doc.rust-lang.org/reference/attributes/type_system.html)."##,
    },
    Lint {
        label: "clippy::neg_cmp_op_on_partial_ord",
        description: r##"Checks for the usage of negated comparison operators on types which only implement
`PartialOrd` (e.g., `f64`)."##,
    },
    Lint {
        label: "clippy::neg_multiply",
        description: r##"Checks for multiplication by -1 as a form of negation."##,
    },
    Lint {
        label: "clippy::negative_feature_names",
        description: r##"Checks for negative feature names with prefix `no-` or `not-`"##,
    },
    Lint {
        label: "clippy::never_loop",
        description: r##"Checks for loops that will always `break`, `return` or
`continue` an outer loop."##,
    },
    Lint {
        label: "clippy::new_ret_no_self",
        description: r##"Checks for `new` not returning a type that contains `Self`."##,
    },
    Lint {
        label: "clippy::new_without_default",
        description: r##"Checks for public types with a `pub fn new() -> Self` method and no
implementation of
[`Default`](https://doc.rust-lang.org/std/default/trait.Default.html)."##,
    },
    Lint {
        label: "clippy::no_effect",
        description: r##"Checks for statements which have no effect."##,
    },
    Lint {
        label: "clippy::no_effect_replace",
        description: r##"Checks for `replace` statements which have no effect."##,
    },
    Lint {
        label: "clippy::no_effect_underscore_binding",
        description: r##"Checks for binding to underscore prefixed variable without side-effects."##,
    },
    Lint {
        label: "clippy::no_mangle_with_rust_abi",
        description: r##"Checks for Rust ABI functions with the `#[no_mangle]` attribute."##,
    },
    Lint {
        label: "clippy::non_ascii_literal",
        description: r##"Checks for non-ASCII characters in string and char literals."##,
    },
    Lint {
        label: "clippy::non_canonical_clone_impl",
        description: r##"Checks for non-canonical implementations of `Clone` when `Copy` is already implemented."##,
    },
    Lint {
        label: "clippy::non_canonical_partial_ord_impl",
        description: r##"Checks for non-canonical implementations of `PartialOrd` when `Ord` is already implemented."##,
    },
    Lint {
        label: "clippy::non_minimal_cfg",
        description: r##"Checks for `any` and `all` combinators in `cfg` with only one condition."##,
    },
    Lint {
        label: "clippy::non_octal_unix_permissions",
        description: r##"Checks for non-octal values used to set Unix file permissions."##,
    },
    Lint {
        label: "clippy::non_send_fields_in_send_ty",
        description: r##"This lint warns about a `Send` implementation for a type that
contains fields that are not safe to be sent across threads.
It tries to detect fields that can cause a soundness issue
when sent to another thread (e.g., `Rc`) while allowing `!Send` fields
that are expected to exist in a `Send` type, such as raw pointers."##,
    },
    Lint {
        label: "clippy::nonminimal_bool",
        description: r##"Checks for boolean expressions that can be written more
concisely."##,
    },
    Lint {
        label: "clippy::nonsensical_open_options",
        description: r##"Checks for duplicate open options as well as combinations
that make no sense."##,
    },
    Lint {
        label: "clippy::nonstandard_macro_braces",
        description: r##"Checks that common macros are used with consistent bracing."##,
    },
    Lint {
        label: "clippy::not_unsafe_ptr_arg_deref",
        description: r##"Checks for public functions that dereference raw pointer
arguments but are not marked `unsafe`."##,
    },
    Lint {
        label: "clippy::obfuscated_if_else",
        description: r##"Checks for usage of `.then_some(..).unwrap_or(..)`"##,
    },
    Lint {
        label: "clippy::octal_escapes",
        description: r##"Checks for `\\0` escapes in string and byte literals that look like octal
character escapes in C."##,
    },
    Lint { label: "clippy::ok_expect", description: r##"Checks for usage of `ok().expect(..)`."## },
    Lint {
        label: "clippy::only_used_in_recursion",
        description: r##"Checks for arguments that are only used in recursion with no side-effects."##,
    },
    Lint {
        label: "clippy::op_ref",
        description: r##"Checks for arguments to `==` which have their address
taken to satisfy a bound
and suggests to dereference the other argument instead"##,
    },
    Lint {
        label: "clippy::option_as_ref_cloned",
        description: r##"Checks for usage of `.as_ref().cloned()` and `.as_mut().cloned()` on `Option`s"##,
    },
    Lint {
        label: "clippy::option_as_ref_deref",
        description: r##"Checks for usage of `_.as_ref().map(Deref::deref)` or its aliases (such as String::as_str)."##,
    },
    Lint {
        label: "clippy::option_env_unwrap",
        description: r##"Checks for usage of `option_env!(...).unwrap()` and
suggests usage of the `env!` macro."##,
    },
    Lint {
        label: "clippy::option_filter_map",
        description: r##"Checks for iterators of `Option`s using `.filter(Option::is_some).map(Option::unwrap)` that may
be replaced with a `.flatten()` call."##,
    },
    Lint {
        label: "clippy::option_if_let_else",
        description: r##"Lints usage of `if let Some(v) = ... { y } else { x }` and
`match .. { Some(v) => y, None/_ => x }` which are more
idiomatically done with `Option::map_or` (if the else bit is a pure
expression) or `Option::map_or_else` (if the else bit is an impure
expression)."##,
    },
    Lint {
        label: "clippy::option_map_or_err_ok",
        description: r##"Checks for usage of `_.map_or(Err(_), Ok)`."##,
    },
    Lint {
        label: "clippy::option_map_or_none",
        description: r##"Checks for usage of `_.map_or(None, _)`."##,
    },
    Lint {
        label: "clippy::option_map_unit_fn",
        description: r##"Checks for usage of `option.map(f)` where f is a function
or closure that returns the unit type `()`."##,
    },
    Lint {
        label: "clippy::option_option",
        description: r##"Checks for usage of `Option<Option<_>>` in function signatures and type
definitions"##,
    },
    Lint {
        label: "clippy::or_fun_call",
        description: r##"Checks for calls to `.or(foo(..))`, `.unwrap_or(foo(..))`,
`.or_insert(foo(..))` etc., and suggests to use `.or_else(|| foo(..))`,
`.unwrap_or_else(|| foo(..))`, `.unwrap_or_default()` or `.or_default()`
etc. instead."##,
    },
    Lint {
        label: "clippy::or_then_unwrap",
        description: r##"Checks for `.or(…).unwrap()` calls to Options and Results."##,
    },
    Lint {
        label: "clippy::out_of_bounds_indexing",
        description: r##"Checks for out of bounds array indexing with a constant
index."##,
    },
    Lint {
        label: "clippy::overflow_check_conditional",
        description: r##"Detects classic underflow/overflow checks."##,
    },
    Lint {
        label: "clippy::overly_complex_bool_expr",
        description: r##"Checks for boolean expressions that contain terminals that
can be eliminated."##,
    },
    Lint { label: "clippy::panic", description: r##"Checks for usage of `panic!`."## },
    Lint {
        label: "clippy::panic_in_result_fn",
        description: r##"Checks for usage of `panic!` or assertions in a function whose return type is `Result`."##,
    },
    Lint {
        label: "clippy::panicking_unwrap",
        description: r##"Checks for calls of `unwrap[_err]()` that will always fail."##,
    },
    Lint {
        label: "clippy::partial_pub_fields",
        description: r##"Checks whether some but not all fields of a `struct` are public.

Either make all fields of a type public, or make none of them public"##,
    },
    Lint {
        label: "clippy::partialeq_ne_impl",
        description: r##"Checks for manual re-implementations of `PartialEq::ne`."##,
    },
    Lint {
        label: "clippy::partialeq_to_none",
        description: r##"Checks for binary comparisons to a literal `Option::None`."##,
    },
    Lint {
        label: "clippy::path_buf_push_overwrite",
        description: r##"* Checks for [push](https://doc.rust-lang.org/std/path/struct.PathBuf.html#method.push)
calls on `PathBuf` that can cause overwrites."##,
    },
    Lint {
        label: "clippy::path_ends_with_ext",
        description: r##"Looks for calls to `Path::ends_with` calls where the argument looks like a file extension.

By default, Clippy has a short list of known filenames that start with a dot
but aren't necessarily file extensions (e.g. the `.git` folder), which are allowed by default.
The `allowed-dotfiles` configuration can be used to allow additional
file extensions that Clippy should not lint."##,
    },
    Lint {
        label: "clippy::pattern_type_mismatch",
        description: r##"Checks for patterns that aren't exact representations of the types
they are applied to.

To satisfy this lint, you will have to adjust either the expression that is matched
against or the pattern itself, as well as the bindings that are introduced by the
adjusted patterns. For matching you will have to either dereference the expression
with the `*` operator, or amend the patterns to explicitly match against `&<pattern>`
or `&mut <pattern>` depending on the reference mutability. For the bindings you need
to use the inverse. You can leave them as plain bindings if you wish for the value
to be copied, but you must use `ref mut <variable>` or `ref <variable>` to construct
a reference into the matched structure.

If you are looking for a way to learn about ownership semantics in more detail, it
is recommended to look at IDE options available to you to highlight types, lifetimes
and reference semantics in your code. The available tooling would expose these things
in a general way even outside of the various pattern matching mechanics. Of course
this lint can still be used to highlight areas of interest and ensure a good understanding
of ownership semantics."##,
    },
    Lint {
        label: "clippy::permissions_set_readonly_false",
        description: r##"Checks for calls to `std::fs::Permissions.set_readonly` with argument `false`."##,
    },
    Lint {
        label: "clippy::possible_missing_comma",
        description: r##"Checks for possible missing comma in an array. It lints if
an array element is a binary operator expression and it lies on two lines."##,
    },
    Lint {
        label: "clippy::precedence",
        description: r##"Checks for operations where precedence may be unclear
and suggests to add parentheses. Currently it catches the following:
* mixed usage of arithmetic and bit shifting/combining operators without
parentheses
* a negative numeric literal (which is really a unary `-` followed by a
numeric literal)
  followed by a method call"##,
    },
    Lint {
        label: "clippy::print_in_format_impl",
        description: r##"Checks for usage of `println`, `print`, `eprintln` or `eprint` in an
implementation of a formatting trait."##,
    },
    Lint {
        label: "clippy::print_literal",
        description: r##"This lint warns about the use of literals as `print!`/`println!` args."##,
    },
    Lint {
        label: "clippy::print_stderr",
        description: r##"Checks for printing on *stderr*. The purpose of this lint
is to catch debugging remnants."##,
    },
    Lint {
        label: "clippy::print_stdout",
        description: r##"Checks for printing on *stdout*. The purpose of this lint
is to catch debugging remnants."##,
    },
    Lint {
        label: "clippy::print_with_newline",
        description: r##"This lint warns when you use `print!()` with a format
string that ends in a newline."##,
    },
    Lint {
        label: "clippy::println_empty_string",
        description: r##"This lint warns when you use `println!()` to
print a newline."##,
    },
    Lint {
        label: "clippy::ptr_arg",
        description: r##"This lint checks for function arguments of type `&String`, `&Vec`,
`&PathBuf`, and `Cow<_>`. It will also suggest you replace `.clone()` calls
with the appropriate `.to_owned()`/`to_string()` calls."##,
    },
    Lint {
        label: "clippy::ptr_as_ptr",
        description: r##"Checks for `as` casts between raw pointers without changing its mutability,
namely `*const T` to `*const U` and `*mut T` to `*mut U`."##,
    },
    Lint {
        label: "clippy::ptr_cast_constness",
        description: r##"Checks for `as` casts between raw pointers which change its constness, namely `*const T` to
`*mut T` and `*mut T` to `*const T`."##,
    },
    Lint { label: "clippy::ptr_eq", description: r##"Use `std::ptr::eq` when applicable"## },
    Lint {
        label: "clippy::ptr_offset_with_cast",
        description: r##"Checks for usage of the `offset` pointer method with a `usize` casted to an
`isize`."##,
    },
    Lint {
        label: "clippy::pub_enum_variant_names",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::pub_underscore_fields",
        description: r##"Checks whether any field of the struct is prefixed with an `_` (underscore) and also marked
`pub` (public)"##,
    },
    Lint { label: "clippy::pub_use", description: r##"Restricts the usage of `pub use ...`"## },
    Lint {
        label: "clippy::pub_with_shorthand",
        description: r##"Checks for usage of `pub(<loc>)` with `in`."##,
    },
    Lint {
        label: "clippy::pub_without_shorthand",
        description: r##"Checks for usage of `pub(<loc>)` without `in`.

Note: As you cannot write a module's path in `pub(<loc>)`, this will only trigger on
`pub(super)` and the like."##,
    },
    Lint {
        label: "clippy::question_mark",
        description: r##"Checks for expressions that could be replaced by the question mark operator."##,
    },
    Lint {
        label: "clippy::question_mark_used",
        description: r##"Checks for expressions that use the question mark operator and rejects them."##,
    },
    Lint {
        label: "clippy::range_minus_one",
        description: r##"Checks for inclusive ranges where 1 is subtracted from
the upper bound, e.g., `x..=(y-1)`."##,
    },
    Lint {
        label: "clippy::range_plus_one",
        description: r##"Checks for exclusive ranges where 1 is added to the
upper bound, e.g., `x..(y+1)`."##,
    },
    Lint {
        label: "clippy::range_step_by_zero",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::range_zip_with_len",
        description: r##"Checks for zipping a collection with the range of
`0.._.len()`."##,
    },
    Lint {
        label: "clippy::rc_buffer",
        description: r##"Checks for `Rc<T>` and `Arc<T>` when `T` is a mutable buffer type such as `String` or `Vec`."##,
    },
    Lint {
        label: "clippy::rc_clone_in_vec_init",
        description: r##"Checks for reference-counted pointers (`Arc`, `Rc`, `rc::Weak`, and `sync::Weak`)
in `vec![elem; len]`"##,
    },
    Lint { label: "clippy::rc_mutex", description: r##"Checks for `Rc<Mutex<T>>`."## },
    Lint {
        label: "clippy::read_line_without_trim",
        description: r##"Looks for calls to [`Stdin::read_line`] to read a line from the standard input
into a string, then later attempting to use that string for an operation that will never
work for strings with a trailing newline character in it (e.g. parsing into a `i32`)."##,
    },
    Lint {
        label: "clippy::read_zero_byte_vec",
        description: r##"This lint catches reads into a zero-length `Vec`.
Especially in the case of a call to `with_capacity`, this lint warns that read
gets the number of bytes from the `Vec`'s length, not its capacity."##,
    },
    Lint {
        label: "clippy::readonly_write_lock",
        description: r##"Looks for calls to `RwLock::write` where the lock is only used for reading."##,
    },
    Lint {
        label: "clippy::recursive_format_impl",
        description: r##"Checks for format trait implementations (e.g. `Display`) with a recursive call to itself
which uses `self` as a parameter.
This is typically done indirectly with the `write!` macro or with `to_string()`."##,
    },
    Lint {
        label: "clippy::redundant_allocation",
        description: r##"Checks for usage of redundant allocations anywhere in the code."##,
    },
    Lint {
        label: "clippy::redundant_as_str",
        description: r##"Checks for usage of `as_str()` on a `String` chained with a method available on the `String` itself."##,
    },
    Lint {
        label: "clippy::redundant_async_block",
        description: r##"Checks for `async` block that only returns `await` on a future."##,
    },
    Lint {
        label: "clippy::redundant_at_rest_pattern",
        description: r##"Checks for `[all @ ..]` patterns."##,
    },
    Lint {
        label: "clippy::redundant_clone",
        description: r##"Checks for a redundant `clone()` (and its relatives) which clones an owned
value that is going to be dropped without further use."##,
    },
    Lint {
        label: "clippy::redundant_closure",
        description: r##"Checks for closures which just call another function where
the function can be called directly. `unsafe` functions, calls where types
get adjusted or where the callee is marked `#[track_caller]` are ignored."##,
    },
    Lint {
        label: "clippy::redundant_closure_call",
        description: r##"Detects closures called in the same expression where they
are defined."##,
    },
    Lint {
        label: "clippy::redundant_closure_for_method_calls",
        description: r##"Checks for closures which only invoke a method on the closure
argument and can be replaced by referencing the method directly."##,
    },
    Lint {
        label: "clippy::redundant_comparisons",
        description: r##"Checks for ineffective double comparisons against constants."##,
    },
    Lint {
        label: "clippy::redundant_else",
        description: r##"Checks for `else` blocks that can be removed without changing semantics."##,
    },
    Lint {
        label: "clippy::redundant_feature_names",
        description: r##"Checks for feature names with prefix `use-`, `with-` or suffix `-support`"##,
    },
    Lint {
        label: "clippy::redundant_field_names",
        description: r##"Checks for fields in struct literals where shorthands
could be used."##,
    },
    Lint {
        label: "clippy::redundant_guards",
        description: r##"Checks for unnecessary guards in match expressions."##,
    },
    Lint {
        label: "clippy::redundant_locals",
        description: r##"Checks for redundant redefinitions of local bindings."##,
    },
    Lint {
        label: "clippy::redundant_pattern",
        description: r##"Checks for patterns in the form `name @ _`."##,
    },
    Lint {
        label: "clippy::redundant_pattern_matching",
        description: r##"Lint for redundant pattern matching over `Result`, `Option`,
`std::task::Poll`, `std::net::IpAddr` or `bool`s"##,
    },
    Lint {
        label: "clippy::redundant_pub_crate",
        description: r##"Checks for items declared `pub(crate)` that are not crate visible because they
are inside a private module."##,
    },
    Lint {
        label: "clippy::redundant_slicing",
        description: r##"Checks for redundant slicing expressions which use the full range, and
do not change the type."##,
    },
    Lint {
        label: "clippy::redundant_static_lifetimes",
        description: r##"Checks for constants and statics with an explicit `'static` lifetime."##,
    },
    Lint {
        label: "clippy::redundant_type_annotations",
        description: r##"Warns about needless / redundant type annotations."##,
    },
    Lint {
        label: "clippy::ref_as_ptr",
        description: r##"Checks for casts of references to pointer using `as`
and suggests `std::ptr::from_ref` and `std::ptr::from_mut` instead."##,
    },
    Lint {
        label: "clippy::ref_binding_to_reference",
        description: r##"Checks for `ref` bindings which create a reference to a reference."##,
    },
    Lint {
        label: "clippy::ref_option_ref",
        description: r##"Checks for usage of `&Option<&T>`."##,
    },
    Lint {
        label: "clippy::ref_patterns",
        description: r##"Checks for usages of the `ref` keyword."##,
    },
    Lint {
        label: "clippy::regex_macro",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::renamed_function_params",
        description: r##"Lints when the name of function parameters from trait impl is
different than its default implementation."##,
    },
    Lint {
        label: "clippy::repeat_once",
        description: r##"Checks for usage of `.repeat(1)` and suggest the following method for each types.
- `.to_string()` for `str`
- `.clone()` for `String`
- `.to_vec()` for `slice`

The lint will evaluate constant expressions and values as arguments of `.repeat(..)` and emit a message if
they are equivalent to `1`. (Related discussion in [rust-clippy#7306](https://github.com/rust-lang/rust-clippy/issues/7306))"##,
    },
    Lint {
        label: "clippy::repeat_vec_with_capacity",
        description: r##"Looks for patterns such as `vec![Vec::with_capacity(x); n]` or `iter::repeat(Vec::with_capacity(x))`."##,
    },
    Lint {
        label: "clippy::replace_consts",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::reserve_after_initialization",
        description: r##"Informs the user about a more concise way to create a vector with a known capacity."##,
    },
    Lint {
        label: "clippy::rest_pat_in_fully_bound_structs",
        description: r##"Checks for unnecessary '..' pattern binding on struct when all fields are explicitly matched."##,
    },
    Lint {
        label: "clippy::result_filter_map",
        description: r##"Checks for iterators of `Result`s using `.filter(Result::is_ok).map(Result::unwrap)` that may
be replaced with a `.flatten()` call."##,
    },
    Lint {
        label: "clippy::result_large_err",
        description: r##"Checks for functions that return `Result` with an unusually large
`Err`-variant."##,
    },
    Lint {
        label: "clippy::result_map_or_into_option",
        description: r##"Checks for usage of `_.map_or(None, Some)`."##,
    },
    Lint {
        label: "clippy::result_map_unit_fn",
        description: r##"Checks for usage of `result.map(f)` where f is a function
or closure that returns the unit type `()`."##,
    },
    Lint {
        label: "clippy::result_unit_err",
        description: r##"Checks for public functions that return a `Result`
with an `Err` type of `()`. It suggests using a custom type that
implements `std::error::Error`."##,
    },
    Lint {
        label: "clippy::return_self_not_must_use",
        description: r##"This lint warns when a method returning `Self` doesn't have the `#[must_use]` attribute."##,
    },
    Lint {
        label: "clippy::reversed_empty_ranges",
        description: r##"Checks for range expressions `x..y` where both `x` and `y`
are constant and `x` is greater to `y`. Also triggers if `x` is equal to `y` when they are conditions to a `for` loop."##,
    },
    Lint {
        label: "clippy::same_functions_in_if_condition",
        description: r##"Checks for consecutive `if`s with the same function call."##,
    },
    Lint {
        label: "clippy::same_item_push",
        description: r##"Checks whether a for loop is being used to push a constant
value into a Vec."##,
    },
    Lint {
        label: "clippy::same_name_method",
        description: r##"It lints if a struct has two methods with the same name:
one from a trait, another not from trait."##,
    },
    Lint {
        label: "clippy::search_is_some",
        description: r##"Checks for an iterator or string search (such as `find()`,
`position()`, or `rposition()`) followed by a call to `is_some()` or `is_none()`."##,
    },
    Lint {
        label: "clippy::seek_from_current",
        description: r##"Checks if the `seek` method of the `Seek` trait is called with `SeekFrom::Current(0)`,
and if it is, suggests using `stream_position` instead."##,
    },
    Lint {
        label: "clippy::seek_to_start_instead_of_rewind",
        description: r##"Checks for jumps to the start of a stream that implements `Seek`
and uses the `seek` method providing `Start` as parameter."##,
    },
    Lint {
        label: "clippy::self_assignment",
        description: r##"Checks for explicit self-assignments."##,
    },
    Lint {
        label: "clippy::self_named_constructors",
        description: r##"Warns when constructors have the same name as their types."##,
    },
    Lint {
        label: "clippy::self_named_module_files",
        description: r##"Checks that module layout uses only `mod.rs` files."##,
    },
    Lint {
        label: "clippy::semicolon_if_nothing_returned",
        description: r##"Looks for blocks of expressions and fires if the last expression returns
`()` but is not followed by a semicolon."##,
    },
    Lint {
        label: "clippy::semicolon_inside_block",
        description: r##"Suggests moving the semicolon after a block to the inside of the block, after its last
expression."##,
    },
    Lint {
        label: "clippy::semicolon_outside_block",
        description: r##"Suggests moving the semicolon from a block's final expression outside of the block."##,
    },
    Lint {
        label: "clippy::separated_literal_suffix",
        description: r##"Warns if literal suffixes are separated by an underscore.
To enforce separated literal suffix style,
see the `unseparated_literal_suffix` lint."##,
    },
    Lint {
        label: "clippy::serde_api_misuse",
        description: r##"Checks for misuses of the serde API."##,
    },
    Lint {
        label: "clippy::set_contains_or_insert",
        description: r##"Checks for usage of `contains` to see if a value is not
present on `HashSet` followed by a `insert`."##,
    },
    Lint {
        label: "clippy::shadow_reuse",
        description: r##"Checks for bindings that shadow other bindings already in
scope, while reusing the original value."##,
    },
    Lint {
        label: "clippy::shadow_same",
        description: r##"Checks for bindings that shadow other bindings already in
scope, while just changing reference level or mutability."##,
    },
    Lint {
        label: "clippy::shadow_unrelated",
        description: r##"Checks for bindings that shadow other bindings already in
scope, either without an initialization or with one that does not even use
the original value."##,
    },
    Lint {
        label: "clippy::short_circuit_statement",
        description: r##"Checks for the use of short circuit boolean conditions as
a
statement."##,
    },
    Lint {
        label: "clippy::should_assert_eq",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::should_implement_trait",
        description: r##"Checks for methods that should live in a trait
implementation of a `std` trait (see [llogiq's blog
post](http://llogiq.github.io/2015/07/30/traits.html) for further
information) instead of an inherent implementation."##,
    },
    Lint {
        label: "clippy::should_panic_without_expect",
        description: r##"Checks for `#[should_panic]` attributes without specifying the expected panic message."##,
    },
    Lint {
        label: "clippy::significant_drop_in_scrutinee",
        description: r##"Checks for temporaries returned from function calls in a match scrutinee that have the
`clippy::has_significant_drop` attribute."##,
    },
    Lint {
        label: "clippy::significant_drop_tightening",
        description: r##"Searches for elements marked with `#[clippy::has_significant_drop]` that could be early
dropped but are in fact dropped at the end of their scopes. In other words, enforces the
tightening of their possible lifetimes."##,
    },
    Lint {
        label: "clippy::similar_names",
        description: r##"Checks for names that are very similar and thus confusing.

Note: this lint looks for similar names throughout each
scope. To allow it, you need to allow it on the scope
level, not on the name that is reported."##,
    },
    Lint {
        label: "clippy::single_call_fn",
        description: r##"Checks for functions that are only used once. Does not lint tests."##,
    },
    Lint {
        label: "clippy::single_char_add_str",
        description: r##"Warns when using `push_str`/`insert_str` with a single-character string literal
where `push`/`insert` with a `char` would work fine."##,
    },
    Lint {
        label: "clippy::single_char_lifetime_names",
        description: r##"Checks for lifetimes with names which are one character
long."##,
    },
    Lint {
        label: "clippy::single_char_pattern",
        description: r##"Checks for string methods that receive a single-character
`str` as an argument, e.g., `_.split(x)`."##,
    },
    Lint {
        label: "clippy::single_component_path_imports",
        description: r##"Checking for imports with single component use path."##,
    },
    Lint {
        label: "clippy::single_element_loop",
        description: r##"Checks whether a for loop has a single element."##,
    },
    Lint {
        label: "clippy::single_match",
        description: r##"Checks for matches with a single arm where an `if let`
will usually suffice.

This intentionally does not lint if there are comments
inside of the other arm, so as to allow the user to document
why having another explicit pattern with an empty body is necessary,
or because the comments need to be preserved for other reasons."##,
    },
    Lint {
        label: "clippy::single_match_else",
        description: r##"Checks for matches with two arms where an `if let else` will
usually suffice."##,
    },
    Lint {
        label: "clippy::single_range_in_vec_init",
        description: r##"Checks for `Vec` or array initializations that contain only one range."##,
    },
    Lint {
        label: "clippy::size_of_in_element_count",
        description: r##"Detects expressions where
`size_of::<T>` or `size_of_val::<T>` is used as a
count of elements of type `T`"##,
    },
    Lint {
        label: "clippy::size_of_ref",
        description: r##"Checks for calls to `std::mem::size_of_val()` where the argument is
a reference to a reference."##,
    },
    Lint {
        label: "clippy::skip_while_next",
        description: r##"Checks for usage of `_.skip_while(condition).next()`."##,
    },
    Lint {
        label: "clippy::slow_vector_initialization",
        description: r##"Checks slow zero-filled vector initialization"##,
    },
    Lint {
        label: "clippy::stable_sort_primitive",
        description: r##"When sorting primitive values (integers, bools, chars, as well
as arrays, slices, and tuples of such items), it is typically better to
use an unstable sort than a stable sort."##,
    },
    Lint {
        label: "clippy::std_instead_of_alloc",
        description: r##"Finds items imported through `std` when available through `alloc`."##,
    },
    Lint {
        label: "clippy::std_instead_of_core",
        description: r##"Finds items imported through `std` when available through `core`."##,
    },
    Lint {
        label: "clippy::str_split_at_newline",
        description: r##"Checks for usages of `str.trim().split(\
)` and `str.trim().split(\\
)`."##,
    },
    Lint {
        label: "clippy::str_to_string",
        description: r##"This lint checks for `.to_string()` method calls on values of type `&str`."##,
    },
    Lint {
        label: "clippy::string_add",
        description: r##"Checks for all instances of `x + _` where `x` is of type
`String`, but only if [`string_add_assign`](#string_add_assign) does *not*
match."##,
    },
    Lint {
        label: "clippy::string_add_assign",
        description: r##"Checks for string appends of the form `x = x + y` (without
`let`!)."##,
    },
    Lint {
        label: "clippy::string_extend_chars",
        description: r##"Checks for the use of `.extend(s.chars())` where s is a
`&str` or `String`."##,
    },
    Lint {
        label: "clippy::string_from_utf8_as_bytes",
        description: r##"Check if the string is transformed to byte array and casted back to string."##,
    },
    Lint {
        label: "clippy::string_lit_as_bytes",
        description: r##"Checks for the `as_bytes` method called on string literals
that contain only ASCII characters."##,
    },
    Lint {
        label: "clippy::string_lit_chars_any",
        description: r##"Checks for `<string_lit>.chars().any(|i| i == c)`."##,
    },
    Lint {
        label: "clippy::string_slice",
        description: r##"Checks for slice operations on strings"##,
    },
    Lint {
        label: "clippy::string_to_string",
        description: r##"This lint checks for `.to_string()` method calls on values of type `String`."##,
    },
    Lint {
        label: "clippy::strlen_on_c_strings",
        description: r##"Checks for usage of `libc::strlen` on a `CString` or `CStr` value,
and suggest calling `as_bytes().len()` or `to_bytes().len()` respectively instead."##,
    },
    Lint {
        label: "clippy::struct_excessive_bools",
        description: r##"Checks for excessive
use of bools in structs."##,
    },
    Lint {
        label: "clippy::struct_field_names",
        description: r##"Detects struct fields that are prefixed or suffixed
by the same characters or the name of the struct itself."##,
    },
    Lint {
        label: "clippy::suboptimal_flops",
        description: r##"Looks for floating-point expressions that
can be expressed using built-in methods to improve both
accuracy and performance."##,
    },
    Lint {
        label: "clippy::suspicious_arithmetic_impl",
        description: r##"Lints for suspicious operations in impls of arithmetic operators, e.g.
subtracting elements in an Add impl."##,
    },
    Lint {
        label: "clippy::suspicious_assignment_formatting",
        description: r##"Checks for usage of the non-existent `=*`, `=!` and `=-`
operators."##,
    },
    Lint {
        label: "clippy::suspicious_command_arg_space",
        description: r##"Checks for `Command::arg()` invocations that look like they
should be multiple arguments instead, such as `arg(-t ext2)`."##,
    },
    Lint {
        label: "clippy::suspicious_doc_comments",
        description: r##"Detects the use of outer doc comments (`///`, `/**`) followed by a bang (`!`): `///!`"##,
    },
    Lint {
        label: "clippy::suspicious_else_formatting",
        description: r##"Checks for formatting of `else`. It lints if the `else`
is followed immediately by a newline or the `else` seems to be missing."##,
    },
    Lint {
        label: "clippy::suspicious_map",
        description: r##"Checks for calls to `map` followed by a `count`."##,
    },
    Lint {
        label: "clippy::suspicious_op_assign_impl",
        description: r##"Lints for suspicious operations in impls of OpAssign, e.g.
subtracting elements in an AddAssign impl."##,
    },
    Lint {
        label: "clippy::suspicious_open_options",
        description: r##"Checks for the suspicious use of `OpenOptions::create()`
without an explicit `OpenOptions::truncate()`."##,
    },
    Lint {
        label: "clippy::suspicious_operation_groupings",
        description: r##"Checks for unlikely usages of binary operators that are almost
certainly typos and/or copy/paste errors, given the other usages
of binary operators nearby."##,
    },
    Lint {
        label: "clippy::suspicious_splitn",
        description: r##"Checks for calls to [`splitn`]
(https://doc.rust-lang.org/std/primitive.str.html#method.splitn) and
related functions with either zero or one splits."##,
    },
    Lint {
        label: "clippy::suspicious_to_owned",
        description: r##"Checks for the usage of `_.to_owned()`, on a `Cow<'_, _>`."##,
    },
    Lint {
        label: "clippy::suspicious_unary_op_formatting",
        description: r##"Checks the formatting of a unary operator on the right hand side
of a binary operator. It lints if there is no space between the binary and unary operators,
but there is a space between the unary and its operand."##,
    },
    Lint {
        label: "clippy::suspicious_xor_used_as_pow",
        description: r##"Warns for a Bitwise XOR (`^`) operator being probably confused as a powering. It will not trigger if any of the numbers are not in decimal."##,
    },
    Lint {
        label: "clippy::swap_ptr_to_ref",
        description: r##"Checks for calls to `core::mem::swap` where either parameter is derived from a pointer"##,
    },
    Lint {
        label: "clippy::tabs_in_doc_comments",
        description: r##"Checks doc comments for usage of tab characters."##,
    },
    Lint {
        label: "clippy::temporary_assignment",
        description: r##"Checks for construction of a structure or tuple just to
assign a value in it."##,
    },
    Lint {
        label: "clippy::test_attr_in_doctest",
        description: r##"Checks for `#[test]` in doctests unless they are marked with
either `ignore`, `no_run` or `compile_fail`."##,
    },
    Lint {
        label: "clippy::tests_outside_test_module",
        description: r##"Triggers when a testing function (marked with the `#[test]` attribute) isn't inside a testing module
(marked with `#[cfg(test)]`)."##,
    },
    Lint {
        label: "clippy::to_digit_is_some",
        description: r##"Checks for `.to_digit(..).is_some()` on `char`s."##,
    },
    Lint {
        label: "clippy::to_string_in_format_args",
        description: r##"Checks for [`ToString::to_string`](https://doc.rust-lang.org/std/string/trait.ToString.html#tymethod.to_string)
applied to a type that implements [`Display`](https://doc.rust-lang.org/std/fmt/trait.Display.html)
in a macro that does formatting."##,
    },
    Lint {
        label: "clippy::to_string_trait_impl",
        description: r##"Checks for direct implementations of `ToString`."##,
    },
    Lint { label: "clippy::todo", description: r##"Checks for usage of `todo!`."## },
    Lint {
        label: "clippy::too_many_arguments",
        description: r##"Checks for functions with too many parameters."##,
    },
    Lint {
        label: "clippy::too_many_lines",
        description: r##"Checks for functions with a large amount of lines."##,
    },
    Lint {
        label: "clippy::toplevel_ref_arg",
        description: r##"Checks for function arguments and let bindings denoted as
`ref`."##,
    },
    Lint {
        label: "clippy::trailing_empty_array",
        description: r##"Displays a warning when a struct with a trailing zero-sized array is declared without a `repr` attribute."##,
    },
    Lint {
        label: "clippy::trait_duplication_in_bounds",
        description: r##"Checks for cases where generics or trait objects are being used and multiple
syntax specifications for trait bounds are used simultaneously."##,
    },
    Lint {
        label: "clippy::transmute_bytes_to_str",
        description: r##"Checks for transmutes from a `&[u8]` to a `&str`."##,
    },
    Lint {
        label: "clippy::transmute_float_to_int",
        description: r##"Checks for transmutes from a float to an integer."##,
    },
    Lint {
        label: "clippy::transmute_int_to_bool",
        description: r##"Checks for transmutes from an integer to a `bool`."##,
    },
    Lint {
        label: "clippy::transmute_int_to_char",
        description: r##"Checks for transmutes from an integer to a `char`."##,
    },
    Lint {
        label: "clippy::transmute_int_to_float",
        description: r##"Checks for transmutes from an integer to a float."##,
    },
    Lint {
        label: "clippy::transmute_int_to_non_zero",
        description: r##"Checks for transmutes from `T` to `NonZero<T>`, and suggests the `new_unchecked`
method instead."##,
    },
    Lint {
        label: "clippy::transmute_null_to_fn",
        description: r##"Checks for null function pointer creation through transmute."##,
    },
    Lint {
        label: "clippy::transmute_num_to_bytes",
        description: r##"Checks for transmutes from a number to an array of `u8`"##,
    },
    Lint {
        label: "clippy::transmute_ptr_to_ptr",
        description: r##"Checks for transmutes from a pointer to a pointer, or
from a reference to a reference."##,
    },
    Lint {
        label: "clippy::transmute_ptr_to_ref",
        description: r##"Checks for transmutes from a pointer to a reference."##,
    },
    Lint {
        label: "clippy::transmute_undefined_repr",
        description: r##"Checks for transmutes between types which do not have a representation defined relative to
each other."##,
    },
    Lint {
        label: "clippy::transmutes_expressible_as_ptr_casts",
        description: r##"Checks for transmutes that could be a pointer cast."##,
    },
    Lint {
        label: "clippy::transmuting_null",
        description: r##"Checks for transmute calls which would receive a null pointer."##,
    },
    Lint {
        label: "clippy::trim_split_whitespace",
        description: r##"Warns about calling `str::trim` (or variants) before `str::split_whitespace`."##,
    },
    Lint {
        label: "clippy::trivial_regex",
        description: r##"Checks for trivial [regex](https://crates.io/crates/regex)
creation (with `Regex::new`, `RegexBuilder::new`, or `RegexSet::new`)."##,
    },
    Lint {
        label: "clippy::trivially_copy_pass_by_ref",
        description: r##"Checks for functions taking arguments by reference, where
the argument type is `Copy` and small enough to be more efficient to always
pass by value."##,
    },
    Lint { label: "clippy::try_err", description: r##"Checks for usage of `Err(x)?`."## },
    Lint {
        label: "clippy::tuple_array_conversions",
        description: r##"Checks for tuple<=>array conversions that are not done with `.into()`."##,
    },
    Lint {
        label: "clippy::type_complexity",
        description: r##"Checks for types used in structs, parameters and `let`
declarations above a certain complexity threshold."##,
    },
    Lint {
        label: "clippy::type_id_on_box",
        description: r##"Looks for calls to `.type_id()` on a `Box<dyn _>`."##,
    },
    Lint {
        label: "clippy::type_repetition_in_bounds",
        description: r##"This lint warns about unnecessary type repetitions in trait bounds"##,
    },
    Lint {
        label: "clippy::unchecked_duration_subtraction",
        description: r##"Lints subtraction between an `Instant` and a `Duration`."##,
    },
    Lint {
        label: "clippy::unconditional_recursion",
        description: r##"Checks that there isn't an infinite recursion in trait
implementations."##,
    },
    Lint {
        label: "clippy::undocumented_unsafe_blocks",
        description: r##"Checks for `unsafe` blocks and impls without a `// SAFETY: ` comment
explaining why the unsafe operations performed inside
the block are safe.

Note the comment must appear on the line(s) preceding the unsafe block
with nothing appearing in between. The following is ok:
```rust
foo(
    // SAFETY:
    // This is a valid safety comment
    unsafe { *x }
)
```
But neither of these are:
```rust
// SAFETY:
// This is not a valid safety comment
foo(
    /* SAFETY: Neither is this */ unsafe { *x },
);
```"##,
    },
    Lint {
        label: "clippy::unicode_not_nfc",
        description: r##"Checks for string literals that contain Unicode in a form
that is not equal to its
[NFC-recomposition](http://www.unicode.org/reports/tr15/#Norm_Forms)."##,
    },
    Lint {
        label: "clippy::unimplemented",
        description: r##"Checks for usage of `unimplemented!`."##,
    },
    Lint {
        label: "clippy::uninhabited_references",
        description: r##"It detects references to uninhabited types, such as `!` and
warns when those are either dereferenced or returned from a function."##,
    },
    Lint {
        label: "clippy::uninit_assumed_init",
        description: r##"Checks for `MaybeUninit::uninit().assume_init()`."##,
    },
    Lint {
        label: "clippy::uninit_vec",
        description: r##"Checks for `set_len()` call that creates `Vec` with uninitialized elements.
This is commonly caused by calling `set_len()` right after allocating or
reserving a buffer with `new()`, `default()`, `with_capacity()`, or `reserve()`."##,
    },
    Lint {
        label: "clippy::uninlined_format_args",
        description: r##"Detect when a variable is not inlined in a format string,
and suggests to inline it."##,
    },
    Lint {
        label: "clippy::unit_arg",
        description: r##"Checks for passing a unit value as an argument to a function without using a
unit literal (`()`)."##,
    },
    Lint {
        label: "clippy::unit_cmp",
        description: r##"Checks for comparisons to unit. This includes all binary
comparisons (like `==` and `<`) and asserts."##,
    },
    Lint { label: "clippy::unit_hash", description: r##"Detects `().hash(_)`."## },
    Lint {
        label: "clippy::unit_return_expecting_ord",
        description: r##"Checks for functions that expect closures of type
Fn(...) -> Ord where the implemented closure returns the unit type.
The lint also suggests to remove the semi-colon at the end of the statement if present."##,
    },
    Lint {
        label: "clippy::unnecessary_box_returns",
        description: r##"Checks for a return type containing a `Box<T>` where `T` implements `Sized`

The lint ignores `Box<T>` where `T` is larger than `unnecessary_box_size`,
as returning a large `T` directly may be detrimental to performance."##,
    },
    Lint {
        label: "clippy::unnecessary_cast",
        description: r##"Checks for casts to the same type, casts of int literals to integer types, casts of float
literals to float types and casts between raw pointers without changing type or constness."##,
    },
    Lint {
        label: "clippy::unnecessary_clippy_cfg",
        description: r##"Checks for `#[cfg_attr(clippy, allow(clippy::lint))]`
and suggests to replace it with `#[allow(clippy::lint)]`."##,
    },
    Lint {
        label: "clippy::unnecessary_fallible_conversions",
        description: r##"Checks for calls to `TryInto::try_into` and `TryFrom::try_from` when their infallible counterparts
could be used."##,
    },
    Lint {
        label: "clippy::unnecessary_filter_map",
        description: r##"Checks for `filter_map` calls that could be replaced by `filter` or `map`.
More specifically it checks if the closure provided is only performing one of the
filter or map operations and suggests the appropriate option."##,
    },
    Lint {
        label: "clippy::unnecessary_find_map",
        description: r##"Checks for `find_map` calls that could be replaced by `find` or `map`. More
specifically it checks if the closure provided is only performing one of the
find or map operations and suggests the appropriate option."##,
    },
    Lint {
        label: "clippy::unnecessary_fold",
        description: r##"Checks for usage of `fold` when a more succinct alternative exists.
Specifically, this checks for `fold`s which could be replaced by `any`, `all`,
`sum` or `product`."##,
    },
    Lint {
        label: "clippy::unnecessary_get_then_check",
        description: r##"Checks the usage of `.get().is_some()` or `.get().is_none()` on std map types."##,
    },
    Lint {
        label: "clippy::unnecessary_join",
        description: r##"Checks for usage of `.collect::<Vec<String>>().join()` on iterators."##,
    },
    Lint {
        label: "clippy::unnecessary_lazy_evaluations",
        description: r##"As the counterpart to `or_fun_call`, this lint looks for unnecessary
lazily evaluated closures on `Option` and `Result`.

This lint suggests changing the following functions, when eager evaluation results in
simpler code:
 - `unwrap_or_else` to `unwrap_or`
 - `and_then` to `and`
 - `or_else` to `or`
 - `get_or_insert_with` to `get_or_insert`
 - `ok_or_else` to `ok_or`
 - `then` to `then_some` (for msrv >= 1.62.0)"##,
    },
    Lint {
        label: "clippy::unnecessary_literal_unwrap",
        description: r##"Checks for `.unwrap()` related calls on `Result`s and `Option`s that are constructed."##,
    },
    Lint {
        label: "clippy::unnecessary_map_on_constructor",
        description: r##"Suggests removing the use of a `map()` (or `map_err()`) method when an `Option` or `Result`
is being constructed."##,
    },
    Lint {
        label: "clippy::unnecessary_min_or_max",
        description: r##"Checks for unnecessary calls to `min()` or `max()` in the following cases
- Either both side is constant
- One side is clearly larger than the other, like i32::MIN and an i32 variable"##,
    },
    Lint {
        label: "clippy::unnecessary_mut_passed",
        description: r##"Detects passing a mutable reference to a function that only
requires an immutable reference."##,
    },
    Lint {
        label: "clippy::unnecessary_operation",
        description: r##"Checks for expression statements that can be reduced to a
sub-expression."##,
    },
    Lint {
        label: "clippy::unnecessary_owned_empty_strings",
        description: r##"Detects cases of owned empty strings being passed as an argument to a function expecting `&str`"##,
    },
    Lint {
        label: "clippy::unnecessary_result_map_or_else",
        description: r##"Checks for usage of `.map_or_else()` map closure for `Result` type."##,
    },
    Lint {
        label: "clippy::unnecessary_safety_comment",
        description: r##"Checks for `// SAFETY: ` comments on safe code."##,
    },
    Lint {
        label: "clippy::unnecessary_safety_doc",
        description: r##"Checks for the doc comments of publicly visible
safe functions and traits and warns if there is a `# Safety` section."##,
    },
    Lint {
        label: "clippy::unnecessary_self_imports",
        description: r##"Checks for imports ending in `::{self}`."##,
    },
    Lint {
        label: "clippy::unnecessary_sort_by",
        description: r##"Checks for usage of `Vec::sort_by` passing in a closure
which compares the two arguments, either directly or indirectly."##,
    },
    Lint {
        label: "clippy::unnecessary_struct_initialization",
        description: r##"Checks for initialization of a `struct` by copying a base without setting
any field."##,
    },
    Lint {
        label: "clippy::unnecessary_to_owned",
        description: r##"Checks for unnecessary calls to [`ToOwned::to_owned`](https://doc.rust-lang.org/std/borrow/trait.ToOwned.html#tymethod.to_owned)
and other `to_owned`-like functions."##,
    },
    Lint {
        label: "clippy::unnecessary_unwrap",
        description: r##"Checks for calls of `unwrap[_err]()` that cannot fail."##,
    },
    Lint {
        label: "clippy::unnecessary_wraps",
        description: r##"Checks for private functions that only return `Ok` or `Some`."##,
    },
    Lint {
        label: "clippy::unneeded_field_pattern",
        description: r##"Checks for structure field patterns bound to wildcards."##,
    },
    Lint {
        label: "clippy::unneeded_wildcard_pattern",
        description: r##"Checks for tuple patterns with a wildcard
pattern (`_`) is next to a rest pattern (`..`).

_NOTE_: While `_, ..` means there is at least one element left, `..`
means there are 0 or more elements left. This can make a difference
when refactoring, but shouldn't result in errors in the refactored code,
since the wildcard pattern isn't used anyway."##,
    },
    Lint {
        label: "clippy::unnested_or_patterns",
        description: r##"Checks for unnested or-patterns, e.g., `Some(0) | Some(2)` and
suggests replacing the pattern with a nested one, `Some(0 | 2)`.

Another way to think of this is that it rewrites patterns in
*disjunctive normal form (DNF)* into *conjunctive normal form (CNF)*."##,
    },
    Lint { label: "clippy::unreachable", description: r##"Checks for usage of `unreachable!`."## },
    Lint {
        label: "clippy::unreadable_literal",
        description: r##"Warns if a long integral or floating-point constant does
not contain underscores."##,
    },
    Lint {
        label: "clippy::unsafe_derive_deserialize",
        description: r##"Checks for deriving `serde::Deserialize` on a type that
has methods using `unsafe`."##,
    },
    Lint {
        label: "clippy::unsafe_removed_from_name",
        description: r##"Checks for imports that remove unsafe from an item's
name."##,
    },
    Lint {
        label: "clippy::unsafe_vector_initialization",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::unseparated_literal_suffix",
        description: r##"Warns if literal suffixes are not separated by an
underscore.
To enforce unseparated literal suffix style,
see the `separated_literal_suffix` lint."##,
    },
    Lint {
        label: "clippy::unsound_collection_transmute",
        description: r##"Checks for transmutes between collections whose
types have different ABI, size or alignment."##,
    },
    Lint {
        label: "clippy::unstable_as_mut_slice",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::unstable_as_slice",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::unused_async",
        description: r##"Checks for functions that are declared `async` but have no `.await`s inside of them."##,
    },
    Lint {
        label: "clippy::unused_collect",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::unused_enumerate_index",
        description: r##"Checks for uses of the `enumerate` method where the index is unused (`_`)"##,
    },
    Lint {
        label: "clippy::unused_format_specs",
        description: r##"Detects [formatting parameters] that have no effect on the output of
`format!()`, `println!()` or similar macros."##,
    },
    Lint {
        label: "clippy::unused_io_amount",
        description: r##"Checks for unused written/read amount."##,
    },
    Lint {
        label: "clippy::unused_peekable",
        description: r##"Checks for the creation of a `peekable` iterator that is never `.peek()`ed"##,
    },
    Lint {
        label: "clippy::unused_rounding",
        description: r##"Detects cases where a whole-number literal float is being rounded, using
the `floor`, `ceil`, or `round` methods."##,
    },
    Lint {
        label: "clippy::unused_self",
        description: r##"Checks methods that contain a `self` argument but don't use it"##,
    },
    Lint {
        label: "clippy::unused_unit",
        description: r##"Checks for unit (`()`) expressions that can be removed."##,
    },
    Lint {
        label: "clippy::unusual_byte_groupings",
        description: r##"Warns if hexadecimal or binary literals are not grouped
by nibble or byte."##,
    },
    Lint {
        label: "clippy::unwrap_in_result",
        description: r##"Checks for functions of type `Result` that contain `expect()` or `unwrap()`"##,
    },
    Lint {
        label: "clippy::unwrap_or_default",
        description: r##"Checks for usages of the following functions with an argument that constructs a default value
(e.g., `Default::default` or `String::new`):
- `unwrap_or`
- `unwrap_or_else`
- `or_insert`
- `or_insert_with`"##,
    },
    Lint {
        label: "clippy::unwrap_used",
        description: r##"Checks for `.unwrap()` or `.unwrap_err()` calls on `Result`s and `.unwrap()` call on `Option`s."##,
    },
    Lint {
        label: "clippy::upper_case_acronyms",
        description: r##"Checks for fully capitalized names and optionally names containing a capitalized acronym."##,
    },
    Lint {
        label: "clippy::use_debug",
        description: r##"Checks for usage of `Debug` formatting. The purpose of this
lint is to catch debugging remnants."##,
    },
    Lint {
        label: "clippy::use_self",
        description: r##"Checks for unnecessary repetition of structure name when a
replacement with `Self` is applicable."##,
    },
    Lint {
        label: "clippy::used_underscore_binding",
        description: r##"Checks for the use of bindings with a single leading
underscore."##,
    },
    Lint {
        label: "clippy::useless_asref",
        description: r##"Checks for usage of `.as_ref()` or `.as_mut()` where the
types before and after the call are the same."##,
    },
    Lint {
        label: "clippy::useless_attribute",
        description: r##"Checks for `extern crate` and `use` items annotated with
lint attributes.

This lint permits lint attributes for lints emitted on the items themself.
For `use` items these lints are:
* ambiguous_glob_reexports
* dead_code
* deprecated
* hidden_glob_reexports
* unreachable_pub
* unused
* unused_braces
* unused_import_braces
* clippy::disallowed_types
* clippy::enum_glob_use
* clippy::macro_use_imports
* clippy::module_name_repetitions
* clippy::redundant_pub_crate
* clippy::single_component_path_imports
* clippy::unsafe_removed_from_name
* clippy::wildcard_imports

For `extern crate` items these lints are:
* `unused_imports` on items with `#[macro_use]`"##,
    },
    Lint {
        label: "clippy::useless_conversion",
        description: r##"Checks for `Into`, `TryInto`, `From`, `TryFrom`, or `IntoIter` calls
which uselessly convert to the same type."##,
    },
    Lint {
        label: "clippy::useless_format",
        description: r##"Checks for the use of `format!(string literal with no
argument)` and `format!({}, foo)` where `foo` is a string."##,
    },
    Lint {
        label: "clippy::useless_let_if_seq",
        description: r##"Checks for variable declarations immediately followed by a
conditional affectation."##,
    },
    Lint {
        label: "clippy::useless_transmute",
        description: r##"Checks for transmutes to the original type of the object
and transmutes that could be a cast."##,
    },
    Lint {
        label: "clippy::useless_vec",
        description: r##"Checks for usage of `vec![..]` when using `[..]` would
be possible."##,
    },
    Lint {
        label: "clippy::vec_box",
        description: r##"Checks for usage of `Vec<Box<T>>` where T: Sized anywhere in the code.
Check the [Box documentation](https://doc.rust-lang.org/std/boxed/index.html) for more information."##,
    },
    Lint {
        label: "clippy::vec_init_then_push",
        description: r##"Checks for calls to `push` immediately after creating a new `Vec`.

If the `Vec` is created using `with_capacity` this will only lint if the capacity is a
constant and the number of pushes is greater than or equal to the initial capacity.

If the `Vec` is extended after the initial sequence of pushes and it was default initialized
then this will only lint after there were at least four pushes. This number may change in
the future."##,
    },
    Lint {
        label: "clippy::vec_resize_to_zero",
        description: r##"Finds occurrences of `Vec::resize(0, an_int)`"##,
    },
    Lint {
        label: "clippy::verbose_bit_mask",
        description: r##"Checks for bit masks that can be replaced by a call
to `trailing_zeros`"##,
    },
    Lint {
        label: "clippy::verbose_file_reads",
        description: r##"Checks for usage of File::read_to_end and File::read_to_string."##,
    },
    Lint {
        label: "clippy::waker_clone_wake",
        description: r##"Checks for usage of `waker.clone().wake()`"##,
    },
    Lint {
        label: "clippy::while_float",
        description: r##"Checks for while loops comparing floating point values."##,
    },
    Lint {
        label: "clippy::while_immutable_condition",
        description: r##"Checks whether variables used within while loop condition
can be (and are) mutated in the body."##,
    },
    Lint {
        label: "clippy::while_let_loop",
        description: r##"Detects `loop + match` combinations that are easier
written as a `while let` loop."##,
    },
    Lint {
        label: "clippy::while_let_on_iterator",
        description: r##"Checks for `while let` expressions on iterators."##,
    },
    Lint {
        label: "clippy::wildcard_dependencies",
        description: r##"Checks for wildcard dependencies in the `Cargo.toml`."##,
    },
    Lint {
        label: "clippy::wildcard_enum_match_arm",
        description: r##"Checks for wildcard enum matches using `_`."##,
    },
    Lint {
        label: "clippy::wildcard_imports",
        description: r##"Checks for wildcard imports `use _::*`."##,
    },
    Lint {
        label: "clippy::wildcard_in_or_patterns",
        description: r##"Checks for wildcard pattern used with others patterns in same match arm."##,
    },
    Lint {
        label: "clippy::write_literal",
        description: r##"This lint warns about the use of literals as `write!`/`writeln!` args."##,
    },
    Lint {
        label: "clippy::write_with_newline",
        description: r##"This lint warns when you use `write!()` with a format
string that
ends in a newline."##,
    },
    Lint {
        label: "clippy::writeln_empty_string",
        description: r##"This lint warns when you use `writeln!(buf, )` to
print a newline."##,
    },
    Lint {
        label: "clippy::wrong_pub_self_convention",
        description: r##"Nothing. This lint has been deprecated."##,
    },
    Lint {
        label: "clippy::wrong_self_convention",
        description: r##"Checks for methods with certain name prefixes or suffixes, and which
do not adhere to standard conventions regarding how `self` is taken.
The actual rules are:

|Prefix |Postfix     |`self` taken                   | `self` type  |
|-------|------------|-------------------------------|--------------|
|`as_`  | none       |`&self` or `&mut self`         | any          |
|`from_`| none       | none                          | any          |
|`into_`| none       |`self`                         | any          |
|`is_`  | none       |`&mut self` or `&self` or none | any          |
|`to_`  | `_mut`     |`&mut self`                    | any          |
|`to_`  | not `_mut` |`self`                         | `Copy`       |
|`to_`  | not `_mut` |`&self`                        | not `Copy`   |

Note: Clippy doesn't trigger methods with `to_` prefix in:
- Traits definition.
Clippy can not tell if a type that implements a trait is `Copy` or not.
- Traits implementation, when `&self` is taken.
The method signature is controlled by the trait and often `&self` is required for all types that implement the trait
(see e.g. the `std::string::ToString` trait).

Clippy allows `Pin<&Self>` and `Pin<&mut Self>` if `&self` and `&mut self` is required.

Please find more info here:
https://rust-lang.github.io/api-guidelines/naming.html#ad-hoc-conversions-follow-as_-to_-into_-conventions-c-conv"##,
    },
    Lint {
        label: "clippy::wrong_transmute",
        description: r##"Checks for transmutes that can't ever be correct on any
architecture."##,
    },
    Lint { label: "clippy::zero_divided_by_zero", description: r##"Checks for `0.0 / 0.0`."## },
    Lint {
        label: "clippy::zero_prefixed_literal",
        description: r##"Warns if an integral constant literal starts with `0`."##,
    },
    Lint {
        label: "clippy::zero_ptr",
        description: r##"Catch casts from `0` to some pointer type"##,
    },
    Lint {
        label: "clippy::zero_repeat_side_effects",
        description: r##"Checks for array or vec initializations which call a function or method,
but which have a repeat count of zero."##,
    },
    Lint {
        label: "clippy::zero_sized_map_values",
        description: r##"Checks for maps with zero-sized value types anywhere in the code."##,
    },
    Lint {
        label: "clippy::zst_offset",
        description: r##"Checks for `offset(_)`, `wrapping_`{`add`, `sub`}, etc. on raw pointers to
zero-sized types"##,
    },
];
pub const CLIPPY_LINT_GROUPS: &[LintGroup] = &[
    LintGroup {
        lint: Lint {
            label: "clippy::cargo",
            description: r##"lint group for: clippy::cargo_common_metadata, clippy::multiple_crate_versions, clippy::negative_feature_names, clippy::redundant_feature_names, clippy::wildcard_dependencies"##,
        },
        children: &[
            "clippy::cargo_common_metadata",
            "clippy::multiple_crate_versions",
            "clippy::negative_feature_names",
            "clippy::redundant_feature_names",
            "clippy::wildcard_dependencies",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::complexity",
            description: r##"lint group for: clippy::bind_instead_of_map, clippy::bool_comparison, clippy::borrow_deref_ref, clippy::borrowed_box, clippy::bytes_count_to_len, clippy::char_lit_as_u8, clippy::clone_on_copy, clippy::crosspointer_transmute, clippy::default_constructed_unit_structs, clippy::deprecated_cfg_attr, clippy::deref_addrof, clippy::derivable_impls, clippy::diverging_sub_expression, clippy::double_comparisons, clippy::double_parens, clippy::duration_subsec, clippy::excessive_nesting, clippy::explicit_auto_deref, clippy::explicit_counter_loop, clippy::explicit_write, clippy::extra_unused_lifetimes, clippy::extra_unused_type_parameters, clippy::filter_map_identity, clippy::filter_next, clippy::flat_map_identity, clippy::get_last_with_len, clippy::identity_op, clippy::implied_bounds_in_impls, clippy::inspect_for_each, clippy::int_plus_one, clippy::iter_count, clippy::iter_kv_map, clippy::let_with_type_underscore, clippy::manual_clamp, clippy::manual_filter, clippy::manual_filter_map, clippy::manual_find, clippy::manual_find_map, clippy::manual_flatten, clippy::manual_hash_one, clippy::manual_inspect, clippy::manual_main_separator_str, clippy::manual_range_patterns, clippy::manual_rem_euclid, clippy::manual_slice_size_calculation, clippy::manual_split_once, clippy::manual_strip, clippy::manual_swap, clippy::manual_unwrap_or, clippy::map_flatten, clippy::map_identity, clippy::match_as_ref, clippy::match_single_binding, clippy::needless_arbitrary_self_type, clippy::needless_bool, clippy::needless_bool_assign, clippy::needless_borrowed_reference, clippy::needless_if, clippy::needless_lifetimes, clippy::needless_match, clippy::needless_option_as_deref, clippy::needless_option_take, clippy::needless_question_mark, clippy::needless_splitn, clippy::needless_update, clippy::neg_cmp_op_on_partial_ord, clippy::no_effect, clippy::nonminimal_bool, clippy::only_used_in_recursion, clippy::option_as_ref_deref, clippy::option_filter_map, clippy::option_map_unit_fn, clippy::or_then_unwrap, clippy::overflow_check_conditional, clippy::partialeq_ne_impl, clippy::precedence, clippy::ptr_offset_with_cast, clippy::range_zip_with_len, clippy::redundant_as_str, clippy::redundant_async_block, clippy::redundant_at_rest_pattern, clippy::redundant_closure_call, clippy::redundant_guards, clippy::redundant_slicing, clippy::repeat_once, clippy::reserve_after_initialization, clippy::result_filter_map, clippy::result_map_unit_fn, clippy::search_is_some, clippy::seek_from_current, clippy::seek_to_start_instead_of_rewind, clippy::short_circuit_statement, clippy::single_element_loop, clippy::skip_while_next, clippy::string_from_utf8_as_bytes, clippy::strlen_on_c_strings, clippy::temporary_assignment, clippy::too_many_arguments, clippy::transmute_bytes_to_str, clippy::transmute_float_to_int, clippy::transmute_int_to_bool, clippy::transmute_int_to_char, clippy::transmute_int_to_float, clippy::transmute_int_to_non_zero, clippy::transmute_num_to_bytes, clippy::transmute_ptr_to_ref, clippy::transmutes_expressible_as_ptr_casts, clippy::type_complexity, clippy::unit_arg, clippy::unnecessary_cast, clippy::unnecessary_filter_map, clippy::unnecessary_find_map, clippy::unnecessary_literal_unwrap, clippy::unnecessary_map_on_constructor, clippy::unnecessary_min_or_max, clippy::unnecessary_operation, clippy::unnecessary_sort_by, clippy::unnecessary_unwrap, clippy::unneeded_wildcard_pattern, clippy::unused_format_specs, clippy::useless_asref, clippy::useless_conversion, clippy::useless_format, clippy::useless_transmute, clippy::vec_box, clippy::while_let_loop, clippy::wildcard_in_or_patterns, clippy::zero_divided_by_zero, clippy::zero_prefixed_literal"##,
        },
        children: &[
            "clippy::bind_instead_of_map",
            "clippy::bool_comparison",
            "clippy::borrow_deref_ref",
            "clippy::borrowed_box",
            "clippy::bytes_count_to_len",
            "clippy::char_lit_as_u8",
            "clippy::clone_on_copy",
            "clippy::crosspointer_transmute",
            "clippy::default_constructed_unit_structs",
            "clippy::deprecated_cfg_attr",
            "clippy::deref_addrof",
            "clippy::derivable_impls",
            "clippy::diverging_sub_expression",
            "clippy::double_comparisons",
            "clippy::double_parens",
            "clippy::duration_subsec",
            "clippy::excessive_nesting",
            "clippy::explicit_auto_deref",
            "clippy::explicit_counter_loop",
            "clippy::explicit_write",
            "clippy::extra_unused_lifetimes",
            "clippy::extra_unused_type_parameters",
            "clippy::filter_map_identity",
            "clippy::filter_next",
            "clippy::flat_map_identity",
            "clippy::get_last_with_len",
            "clippy::identity_op",
            "clippy::implied_bounds_in_impls",
            "clippy::inspect_for_each",
            "clippy::int_plus_one",
            "clippy::iter_count",
            "clippy::iter_kv_map",
            "clippy::let_with_type_underscore",
            "clippy::manual_clamp",
            "clippy::manual_filter",
            "clippy::manual_filter_map",
            "clippy::manual_find",
            "clippy::manual_find_map",
            "clippy::manual_flatten",
            "clippy::manual_hash_one",
            "clippy::manual_inspect",
            "clippy::manual_main_separator_str",
            "clippy::manual_range_patterns",
            "clippy::manual_rem_euclid",
            "clippy::manual_slice_size_calculation",
            "clippy::manual_split_once",
            "clippy::manual_strip",
            "clippy::manual_swap",
            "clippy::manual_unwrap_or",
            "clippy::map_flatten",
            "clippy::map_identity",
            "clippy::match_as_ref",
            "clippy::match_single_binding",
            "clippy::needless_arbitrary_self_type",
            "clippy::needless_bool",
            "clippy::needless_bool_assign",
            "clippy::needless_borrowed_reference",
            "clippy::needless_if",
            "clippy::needless_lifetimes",
            "clippy::needless_match",
            "clippy::needless_option_as_deref",
            "clippy::needless_option_take",
            "clippy::needless_question_mark",
            "clippy::needless_splitn",
            "clippy::needless_update",
            "clippy::neg_cmp_op_on_partial_ord",
            "clippy::no_effect",
            "clippy::nonminimal_bool",
            "clippy::only_used_in_recursion",
            "clippy::option_as_ref_deref",
            "clippy::option_filter_map",
            "clippy::option_map_unit_fn",
            "clippy::or_then_unwrap",
            "clippy::overflow_check_conditional",
            "clippy::partialeq_ne_impl",
            "clippy::precedence",
            "clippy::ptr_offset_with_cast",
            "clippy::range_zip_with_len",
            "clippy::redundant_as_str",
            "clippy::redundant_async_block",
            "clippy::redundant_at_rest_pattern",
            "clippy::redundant_closure_call",
            "clippy::redundant_guards",
            "clippy::redundant_slicing",
            "clippy::repeat_once",
            "clippy::reserve_after_initialization",
            "clippy::result_filter_map",
            "clippy::result_map_unit_fn",
            "clippy::search_is_some",
            "clippy::seek_from_current",
            "clippy::seek_to_start_instead_of_rewind",
            "clippy::short_circuit_statement",
            "clippy::single_element_loop",
            "clippy::skip_while_next",
            "clippy::string_from_utf8_as_bytes",
            "clippy::strlen_on_c_strings",
            "clippy::temporary_assignment",
            "clippy::too_many_arguments",
            "clippy::transmute_bytes_to_str",
            "clippy::transmute_float_to_int",
            "clippy::transmute_int_to_bool",
            "clippy::transmute_int_to_char",
            "clippy::transmute_int_to_float",
            "clippy::transmute_int_to_non_zero",
            "clippy::transmute_num_to_bytes",
            "clippy::transmute_ptr_to_ref",
            "clippy::transmutes_expressible_as_ptr_casts",
            "clippy::type_complexity",
            "clippy::unit_arg",
            "clippy::unnecessary_cast",
            "clippy::unnecessary_filter_map",
            "clippy::unnecessary_find_map",
            "clippy::unnecessary_literal_unwrap",
            "clippy::unnecessary_map_on_constructor",
            "clippy::unnecessary_min_or_max",
            "clippy::unnecessary_operation",
            "clippy::unnecessary_sort_by",
            "clippy::unnecessary_unwrap",
            "clippy::unneeded_wildcard_pattern",
            "clippy::unused_format_specs",
            "clippy::useless_asref",
            "clippy::useless_conversion",
            "clippy::useless_format",
            "clippy::useless_transmute",
            "clippy::vec_box",
            "clippy::while_let_loop",
            "clippy::wildcard_in_or_patterns",
            "clippy::zero_divided_by_zero",
            "clippy::zero_prefixed_literal",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::correctness",
            description: r##"lint group for: clippy::absurd_extreme_comparisons, clippy::almost_swapped, clippy::approx_constant, clippy::async_yields_async, clippy::bad_bit_mask, clippy::cast_slice_different_sizes, clippy::deprecated_semver, clippy::derive_ord_xor_partial_ord, clippy::derived_hash_with_manual_eq, clippy::eager_transmute, clippy::enum_clike_unportable_variant, clippy::eq_op, clippy::erasing_op, clippy::fn_address_comparisons, clippy::if_let_mutex, clippy::ifs_same_cond, clippy::impl_hash_borrow_with_str_and_bytes, clippy::impossible_comparisons, clippy::ineffective_bit_mask, clippy::infinite_iter, clippy::inherent_to_string_shadow_display, clippy::inline_fn_without_body, clippy::invalid_null_ptr_usage, clippy::invalid_regex, clippy::invisible_characters, clippy::iter_next_loop, clippy::iter_skip_zero, clippy::iterator_step_by_zero, clippy::let_underscore_lock, clippy::lint_groups_priority, clippy::match_str_case_mismatch, clippy::mem_replace_with_uninit, clippy::min_max, clippy::mistyped_literal_suffixes, clippy::modulo_one, clippy::mut_from_ref, clippy::never_loop, clippy::non_octal_unix_permissions, clippy::nonsensical_open_options, clippy::not_unsafe_ptr_arg_deref, clippy::option_env_unwrap, clippy::out_of_bounds_indexing, clippy::overly_complex_bool_expr, clippy::panicking_unwrap, clippy::possible_missing_comma, clippy::read_line_without_trim, clippy::recursive_format_impl, clippy::redundant_comparisons, clippy::redundant_locals, clippy::reversed_empty_ranges, clippy::self_assignment, clippy::serde_api_misuse, clippy::size_of_in_element_count, clippy::suspicious_splitn, clippy::transmute_null_to_fn, clippy::transmuting_null, clippy::uninit_assumed_init, clippy::uninit_vec, clippy::unit_cmp, clippy::unit_hash, clippy::unit_return_expecting_ord, clippy::unsound_collection_transmute, clippy::unused_io_amount, clippy::useless_attribute, clippy::vec_resize_to_zero, clippy::while_immutable_condition, clippy::wrong_transmute, clippy::zst_offset"##,
        },
        children: &[
            "clippy::absurd_extreme_comparisons",
            "clippy::almost_swapped",
            "clippy::approx_constant",
            "clippy::async_yields_async",
            "clippy::bad_bit_mask",
            "clippy::cast_slice_different_sizes",
            "clippy::deprecated_semver",
            "clippy::derive_ord_xor_partial_ord",
            "clippy::derived_hash_with_manual_eq",
            "clippy::eager_transmute",
            "clippy::enum_clike_unportable_variant",
            "clippy::eq_op",
            "clippy::erasing_op",
            "clippy::fn_address_comparisons",
            "clippy::if_let_mutex",
            "clippy::ifs_same_cond",
            "clippy::impl_hash_borrow_with_str_and_bytes",
            "clippy::impossible_comparisons",
            "clippy::ineffective_bit_mask",
            "clippy::infinite_iter",
            "clippy::inherent_to_string_shadow_display",
            "clippy::inline_fn_without_body",
            "clippy::invalid_null_ptr_usage",
            "clippy::invalid_regex",
            "clippy::invisible_characters",
            "clippy::iter_next_loop",
            "clippy::iter_skip_zero",
            "clippy::iterator_step_by_zero",
            "clippy::let_underscore_lock",
            "clippy::lint_groups_priority",
            "clippy::match_str_case_mismatch",
            "clippy::mem_replace_with_uninit",
            "clippy::min_max",
            "clippy::mistyped_literal_suffixes",
            "clippy::modulo_one",
            "clippy::mut_from_ref",
            "clippy::never_loop",
            "clippy::non_octal_unix_permissions",
            "clippy::nonsensical_open_options",
            "clippy::not_unsafe_ptr_arg_deref",
            "clippy::option_env_unwrap",
            "clippy::out_of_bounds_indexing",
            "clippy::overly_complex_bool_expr",
            "clippy::panicking_unwrap",
            "clippy::possible_missing_comma",
            "clippy::read_line_without_trim",
            "clippy::recursive_format_impl",
            "clippy::redundant_comparisons",
            "clippy::redundant_locals",
            "clippy::reversed_empty_ranges",
            "clippy::self_assignment",
            "clippy::serde_api_misuse",
            "clippy::size_of_in_element_count",
            "clippy::suspicious_splitn",
            "clippy::transmute_null_to_fn",
            "clippy::transmuting_null",
            "clippy::uninit_assumed_init",
            "clippy::uninit_vec",
            "clippy::unit_cmp",
            "clippy::unit_hash",
            "clippy::unit_return_expecting_ord",
            "clippy::unsound_collection_transmute",
            "clippy::unused_io_amount",
            "clippy::useless_attribute",
            "clippy::vec_resize_to_zero",
            "clippy::while_immutable_condition",
            "clippy::wrong_transmute",
            "clippy::zst_offset",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::deprecated",
            description: r##"lint group for: clippy::assign_ops, clippy::extend_from_slice, clippy::filter_map, clippy::find_map, clippy::if_let_redundant_pattern_matching, clippy::maybe_misused_cfg, clippy::misaligned_transmute, clippy::mismatched_target_os, clippy::pub_enum_variant_names, clippy::range_step_by_zero, clippy::regex_macro, clippy::replace_consts, clippy::should_assert_eq, clippy::unsafe_vector_initialization, clippy::unstable_as_mut_slice, clippy::unstable_as_slice, clippy::unused_collect, clippy::wrong_pub_self_convention"##,
        },
        children: &[
            "clippy::assign_ops",
            "clippy::extend_from_slice",
            "clippy::filter_map",
            "clippy::find_map",
            "clippy::if_let_redundant_pattern_matching",
            "clippy::maybe_misused_cfg",
            "clippy::misaligned_transmute",
            "clippy::mismatched_target_os",
            "clippy::pub_enum_variant_names",
            "clippy::range_step_by_zero",
            "clippy::regex_macro",
            "clippy::replace_consts",
            "clippy::should_assert_eq",
            "clippy::unsafe_vector_initialization",
            "clippy::unstable_as_mut_slice",
            "clippy::unstable_as_slice",
            "clippy::unused_collect",
            "clippy::wrong_pub_self_convention",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::nursery",
            description: r##"lint group for: clippy::as_ptr_cast_mut, clippy::branches_sharing_code, clippy::clear_with_drain, clippy::cognitive_complexity, clippy::collection_is_never_read, clippy::debug_assert_with_mut_call, clippy::derive_partial_eq_without_eq, clippy::empty_line_after_doc_comments, clippy::empty_line_after_outer_attr, clippy::equatable_if_let, clippy::fallible_impl_from, clippy::future_not_send, clippy::imprecise_flops, clippy::iter_on_empty_collections, clippy::iter_on_single_items, clippy::iter_with_drain, clippy::large_stack_frames, clippy::missing_const_for_fn, clippy::mutex_integer, clippy::needless_collect, clippy::needless_pass_by_ref_mut, clippy::non_send_fields_in_send_ty, clippy::nonstandard_macro_braces, clippy::option_if_let_else, clippy::or_fun_call, clippy::path_buf_push_overwrite, clippy::read_zero_byte_vec, clippy::redundant_clone, clippy::redundant_pub_crate, clippy::set_contains_or_insert, clippy::significant_drop_in_scrutinee, clippy::significant_drop_tightening, clippy::string_lit_as_bytes, clippy::suboptimal_flops, clippy::suspicious_operation_groupings, clippy::trailing_empty_array, clippy::trait_duplication_in_bounds, clippy::transmute_undefined_repr, clippy::trivial_regex, clippy::tuple_array_conversions, clippy::type_repetition_in_bounds, clippy::uninhabited_references, clippy::unnecessary_struct_initialization, clippy::unused_peekable, clippy::unused_rounding, clippy::use_self, clippy::useless_let_if_seq, clippy::while_float"##,
        },
        children: &[
            "clippy::as_ptr_cast_mut",
            "clippy::branches_sharing_code",
            "clippy::clear_with_drain",
            "clippy::cognitive_complexity",
            "clippy::collection_is_never_read",
            "clippy::debug_assert_with_mut_call",
            "clippy::derive_partial_eq_without_eq",
            "clippy::empty_line_after_doc_comments",
            "clippy::empty_line_after_outer_attr",
            "clippy::equatable_if_let",
            "clippy::fallible_impl_from",
            "clippy::future_not_send",
            "clippy::imprecise_flops",
            "clippy::iter_on_empty_collections",
            "clippy::iter_on_single_items",
            "clippy::iter_with_drain",
            "clippy::large_stack_frames",
            "clippy::missing_const_for_fn",
            "clippy::mutex_integer",
            "clippy::needless_collect",
            "clippy::needless_pass_by_ref_mut",
            "clippy::non_send_fields_in_send_ty",
            "clippy::nonstandard_macro_braces",
            "clippy::option_if_let_else",
            "clippy::or_fun_call",
            "clippy::path_buf_push_overwrite",
            "clippy::read_zero_byte_vec",
            "clippy::redundant_clone",
            "clippy::redundant_pub_crate",
            "clippy::set_contains_or_insert",
            "clippy::significant_drop_in_scrutinee",
            "clippy::significant_drop_tightening",
            "clippy::string_lit_as_bytes",
            "clippy::suboptimal_flops",
            "clippy::suspicious_operation_groupings",
            "clippy::trailing_empty_array",
            "clippy::trait_duplication_in_bounds",
            "clippy::transmute_undefined_repr",
            "clippy::trivial_regex",
            "clippy::tuple_array_conversions",
            "clippy::type_repetition_in_bounds",
            "clippy::uninhabited_references",
            "clippy::unnecessary_struct_initialization",
            "clippy::unused_peekable",
            "clippy::unused_rounding",
            "clippy::use_self",
            "clippy::useless_let_if_seq",
            "clippy::while_float",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::pedantic",
            description: r##"lint group for: clippy::assigning_clones, clippy::bool_to_int_with_if, clippy::borrow_as_ptr, clippy::case_sensitive_file_extension_comparisons, clippy::cast_lossless, clippy::cast_possible_truncation, clippy::cast_possible_wrap, clippy::cast_precision_loss, clippy::cast_ptr_alignment, clippy::cast_sign_loss, clippy::checked_conversions, clippy::cloned_instead_of_copied, clippy::copy_iterator, clippy::default_trait_access, clippy::doc_link_with_quotes, clippy::doc_markdown, clippy::empty_enum, clippy::enum_glob_use, clippy::expl_impl_clone_on_copy, clippy::explicit_deref_methods, clippy::explicit_into_iter_loop, clippy::explicit_iter_loop, clippy::filter_map_next, clippy::flat_map_option, clippy::float_cmp, clippy::fn_params_excessive_bools, clippy::from_iter_instead_of_collect, clippy::if_not_else, clippy::ignored_unit_patterns, clippy::implicit_clone, clippy::implicit_hasher, clippy::inconsistent_struct_constructor, clippy::index_refutable_slice, clippy::inefficient_to_string, clippy::inline_always, clippy::into_iter_without_iter, clippy::invalid_upcast_comparisons, clippy::items_after_statements, clippy::iter_filter_is_ok, clippy::iter_filter_is_some, clippy::iter_not_returning_iterator, clippy::iter_without_into_iter, clippy::large_digit_groups, clippy::large_futures, clippy::large_stack_arrays, clippy::large_types_passed_by_value, clippy::linkedlist, clippy::macro_use_imports, clippy::manual_assert, clippy::manual_c_str_literals, clippy::manual_instant_elapsed, clippy::manual_is_variant_and, clippy::manual_let_else, clippy::manual_ok_or, clippy::manual_string_new, clippy::many_single_char_names, clippy::map_unwrap_or, clippy::match_bool, clippy::match_on_vec_items, clippy::match_same_arms, clippy::match_wild_err_arm, clippy::match_wildcard_for_single_variants, clippy::maybe_infinite_iter, clippy::mismatching_type_param_order, clippy::missing_errors_doc, clippy::missing_fields_in_debug, clippy::missing_panics_doc, clippy::module_name_repetitions, clippy::must_use_candidate, clippy::mut_mut, clippy::naive_bytecount, clippy::needless_bitwise_bool, clippy::needless_continue, clippy::needless_for_each, clippy::needless_pass_by_value, clippy::needless_raw_string_hashes, clippy::no_effect_underscore_binding, clippy::no_mangle_with_rust_abi, clippy::option_as_ref_cloned, clippy::option_option, clippy::ptr_as_ptr, clippy::ptr_cast_constness, clippy::pub_underscore_fields, clippy::range_minus_one, clippy::range_plus_one, clippy::redundant_closure_for_method_calls, clippy::redundant_else, clippy::ref_as_ptr, clippy::ref_binding_to_reference, clippy::ref_option_ref, clippy::return_self_not_must_use, clippy::same_functions_in_if_condition, clippy::semicolon_if_nothing_returned, clippy::should_panic_without_expect, clippy::similar_names, clippy::single_char_pattern, clippy::single_match_else, clippy::stable_sort_primitive, clippy::str_split_at_newline, clippy::string_add_assign, clippy::struct_excessive_bools, clippy::struct_field_names, clippy::too_many_lines, clippy::transmute_ptr_to_ptr, clippy::trivially_copy_pass_by_ref, clippy::unchecked_duration_subtraction, clippy::unicode_not_nfc, clippy::uninlined_format_args, clippy::unnecessary_box_returns, clippy::unnecessary_join, clippy::unnecessary_wraps, clippy::unnested_or_patterns, clippy::unreadable_literal, clippy::unsafe_derive_deserialize, clippy::unused_async, clippy::unused_self, clippy::used_underscore_binding, clippy::verbose_bit_mask, clippy::wildcard_imports, clippy::zero_sized_map_values"##,
        },
        children: &[
            "clippy::assigning_clones",
            "clippy::bool_to_int_with_if",
            "clippy::borrow_as_ptr",
            "clippy::case_sensitive_file_extension_comparisons",
            "clippy::cast_lossless",
            "clippy::cast_possible_truncation",
            "clippy::cast_possible_wrap",
            "clippy::cast_precision_loss",
            "clippy::cast_ptr_alignment",
            "clippy::cast_sign_loss",
            "clippy::checked_conversions",
            "clippy::cloned_instead_of_copied",
            "clippy::copy_iterator",
            "clippy::default_trait_access",
            "clippy::doc_link_with_quotes",
            "clippy::doc_markdown",
            "clippy::empty_enum",
            "clippy::enum_glob_use",
            "clippy::expl_impl_clone_on_copy",
            "clippy::explicit_deref_methods",
            "clippy::explicit_into_iter_loop",
            "clippy::explicit_iter_loop",
            "clippy::filter_map_next",
            "clippy::flat_map_option",
            "clippy::float_cmp",
            "clippy::fn_params_excessive_bools",
            "clippy::from_iter_instead_of_collect",
            "clippy::if_not_else",
            "clippy::ignored_unit_patterns",
            "clippy::implicit_clone",
            "clippy::implicit_hasher",
            "clippy::inconsistent_struct_constructor",
            "clippy::index_refutable_slice",
            "clippy::inefficient_to_string",
            "clippy::inline_always",
            "clippy::into_iter_without_iter",
            "clippy::invalid_upcast_comparisons",
            "clippy::items_after_statements",
            "clippy::iter_filter_is_ok",
            "clippy::iter_filter_is_some",
            "clippy::iter_not_returning_iterator",
            "clippy::iter_without_into_iter",
            "clippy::large_digit_groups",
            "clippy::large_futures",
            "clippy::large_stack_arrays",
            "clippy::large_types_passed_by_value",
            "clippy::linkedlist",
            "clippy::macro_use_imports",
            "clippy::manual_assert",
            "clippy::manual_c_str_literals",
            "clippy::manual_instant_elapsed",
            "clippy::manual_is_variant_and",
            "clippy::manual_let_else",
            "clippy::manual_ok_or",
            "clippy::manual_string_new",
            "clippy::many_single_char_names",
            "clippy::map_unwrap_or",
            "clippy::match_bool",
            "clippy::match_on_vec_items",
            "clippy::match_same_arms",
            "clippy::match_wild_err_arm",
            "clippy::match_wildcard_for_single_variants",
            "clippy::maybe_infinite_iter",
            "clippy::mismatching_type_param_order",
            "clippy::missing_errors_doc",
            "clippy::missing_fields_in_debug",
            "clippy::missing_panics_doc",
            "clippy::module_name_repetitions",
            "clippy::must_use_candidate",
            "clippy::mut_mut",
            "clippy::naive_bytecount",
            "clippy::needless_bitwise_bool",
            "clippy::needless_continue",
            "clippy::needless_for_each",
            "clippy::needless_pass_by_value",
            "clippy::needless_raw_string_hashes",
            "clippy::no_effect_underscore_binding",
            "clippy::no_mangle_with_rust_abi",
            "clippy::option_as_ref_cloned",
            "clippy::option_option",
            "clippy::ptr_as_ptr",
            "clippy::ptr_cast_constness",
            "clippy::pub_underscore_fields",
            "clippy::range_minus_one",
            "clippy::range_plus_one",
            "clippy::redundant_closure_for_method_calls",
            "clippy::redundant_else",
            "clippy::ref_as_ptr",
            "clippy::ref_binding_to_reference",
            "clippy::ref_option_ref",
            "clippy::return_self_not_must_use",
            "clippy::same_functions_in_if_condition",
            "clippy::semicolon_if_nothing_returned",
            "clippy::should_panic_without_expect",
            "clippy::similar_names",
            "clippy::single_char_pattern",
            "clippy::single_match_else",
            "clippy::stable_sort_primitive",
            "clippy::str_split_at_newline",
            "clippy::string_add_assign",
            "clippy::struct_excessive_bools",
            "clippy::struct_field_names",
            "clippy::too_many_lines",
            "clippy::transmute_ptr_to_ptr",
            "clippy::trivially_copy_pass_by_ref",
            "clippy::unchecked_duration_subtraction",
            "clippy::unicode_not_nfc",
            "clippy::uninlined_format_args",
            "clippy::unnecessary_box_returns",
            "clippy::unnecessary_join",
            "clippy::unnecessary_wraps",
            "clippy::unnested_or_patterns",
            "clippy::unreadable_literal",
            "clippy::unsafe_derive_deserialize",
            "clippy::unused_async",
            "clippy::unused_self",
            "clippy::used_underscore_binding",
            "clippy::verbose_bit_mask",
            "clippy::wildcard_imports",
            "clippy::zero_sized_map_values",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::perf",
            description: r##"lint group for: clippy::box_collection, clippy::boxed_local, clippy::cmp_owned, clippy::collapsible_str_replace, clippy::drain_collect, clippy::expect_fun_call, clippy::extend_with_drain, clippy::format_collect, clippy::format_in_format_args, clippy::iter_overeager_cloned, clippy::large_const_arrays, clippy::large_enum_variant, clippy::manual_memcpy, clippy::manual_retain, clippy::manual_str_repeat, clippy::manual_try_fold, clippy::map_entry, clippy::missing_const_for_thread_local, clippy::missing_spin_loop, clippy::readonly_write_lock, clippy::redundant_allocation, clippy::result_large_err, clippy::slow_vector_initialization, clippy::to_string_in_format_args, clippy::unnecessary_to_owned, clippy::useless_vec, clippy::vec_init_then_push, clippy::waker_clone_wake"##,
        },
        children: &[
            "clippy::box_collection",
            "clippy::boxed_local",
            "clippy::cmp_owned",
            "clippy::collapsible_str_replace",
            "clippy::drain_collect",
            "clippy::expect_fun_call",
            "clippy::extend_with_drain",
            "clippy::format_collect",
            "clippy::format_in_format_args",
            "clippy::iter_overeager_cloned",
            "clippy::large_const_arrays",
            "clippy::large_enum_variant",
            "clippy::manual_memcpy",
            "clippy::manual_retain",
            "clippy::manual_str_repeat",
            "clippy::manual_try_fold",
            "clippy::map_entry",
            "clippy::missing_const_for_thread_local",
            "clippy::missing_spin_loop",
            "clippy::readonly_write_lock",
            "clippy::redundant_allocation",
            "clippy::result_large_err",
            "clippy::slow_vector_initialization",
            "clippy::to_string_in_format_args",
            "clippy::unnecessary_to_owned",
            "clippy::useless_vec",
            "clippy::vec_init_then_push",
            "clippy::waker_clone_wake",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::restriction",
            description: r##"lint group for: clippy::absolute_paths, clippy::alloc_instead_of_core, clippy::allow_attributes, clippy::allow_attributes_without_reason, clippy::arithmetic_side_effects, clippy::as_conversions, clippy::as_underscore, clippy::assertions_on_result_states, clippy::big_endian_bytes, clippy::cfg_not_test, clippy::clone_on_ref_ptr, clippy::create_dir, clippy::dbg_macro, clippy::decimal_literal_representation, clippy::default_numeric_fallback, clippy::default_union_representation, clippy::deref_by_slicing, clippy::disallowed_script_idents, clippy::else_if_without_else, clippy::empty_drop, clippy::empty_enum_variants_with_brackets, clippy::empty_structs_with_brackets, clippy::error_impl_error, clippy::exhaustive_enums, clippy::exhaustive_structs, clippy::exit, clippy::expect_used, clippy::field_scoped_visibility_modifiers, clippy::filetype_is_file, clippy::float_arithmetic, clippy::float_cmp_const, clippy::fn_to_numeric_cast_any, clippy::format_push_string, clippy::get_unwrap, clippy::host_endian_bytes, clippy::if_then_some_else_none, clippy::impl_trait_in_params, clippy::implicit_return, clippy::indexing_slicing, clippy::infinite_loop, clippy::inline_asm_x86_att_syntax, clippy::inline_asm_x86_intel_syntax, clippy::integer_division, clippy::integer_division_remainder_used, clippy::iter_over_hash_type, clippy::large_include_file, clippy::let_underscore_must_use, clippy::let_underscore_untyped, clippy::little_endian_bytes, clippy::lossy_float_literal, clippy::map_err_ignore, clippy::mem_forget, clippy::min_ident_chars, clippy::missing_assert_message, clippy::missing_asserts_for_indexing, clippy::missing_docs_in_private_items, clippy::missing_inline_in_public_items, clippy::missing_trait_methods, clippy::mixed_read_write_in_expression, clippy::mod_module_files, clippy::modulo_arithmetic, clippy::multiple_inherent_impl, clippy::multiple_unsafe_ops_per_block, clippy::mutex_atomic, clippy::needless_raw_strings, clippy::non_ascii_literal, clippy::panic, clippy::panic_in_result_fn, clippy::partial_pub_fields, clippy::pattern_type_mismatch, clippy::print_stderr, clippy::print_stdout, clippy::pub_use, clippy::pub_with_shorthand, clippy::pub_without_shorthand, clippy::question_mark_used, clippy::rc_buffer, clippy::rc_mutex, clippy::redundant_type_annotations, clippy::ref_patterns, clippy::renamed_function_params, clippy::rest_pat_in_fully_bound_structs, clippy::same_name_method, clippy::self_named_module_files, clippy::semicolon_inside_block, clippy::semicolon_outside_block, clippy::separated_literal_suffix, clippy::shadow_reuse, clippy::shadow_same, clippy::shadow_unrelated, clippy::single_call_fn, clippy::single_char_lifetime_names, clippy::std_instead_of_alloc, clippy::std_instead_of_core, clippy::str_to_string, clippy::string_add, clippy::string_lit_chars_any, clippy::string_slice, clippy::string_to_string, clippy::suspicious_xor_used_as_pow, clippy::tests_outside_test_module, clippy::todo, clippy::try_err, clippy::undocumented_unsafe_blocks, clippy::unimplemented, clippy::unnecessary_safety_comment, clippy::unnecessary_safety_doc, clippy::unnecessary_self_imports, clippy::unneeded_field_pattern, clippy::unreachable, clippy::unseparated_literal_suffix, clippy::unwrap_in_result, clippy::unwrap_used, clippy::use_debug, clippy::verbose_file_reads, clippy::wildcard_enum_match_arm"##,
        },
        children: &[
            "clippy::absolute_paths",
            "clippy::alloc_instead_of_core",
            "clippy::allow_attributes",
            "clippy::allow_attributes_without_reason",
            "clippy::arithmetic_side_effects",
            "clippy::as_conversions",
            "clippy::as_underscore",
            "clippy::assertions_on_result_states",
            "clippy::big_endian_bytes",
            "clippy::cfg_not_test",
            "clippy::clone_on_ref_ptr",
            "clippy::create_dir",
            "clippy::dbg_macro",
            "clippy::decimal_literal_representation",
            "clippy::default_numeric_fallback",
            "clippy::default_union_representation",
            "clippy::deref_by_slicing",
            "clippy::disallowed_script_idents",
            "clippy::else_if_without_else",
            "clippy::empty_drop",
            "clippy::empty_enum_variants_with_brackets",
            "clippy::empty_structs_with_brackets",
            "clippy::error_impl_error",
            "clippy::exhaustive_enums",
            "clippy::exhaustive_structs",
            "clippy::exit",
            "clippy::expect_used",
            "clippy::field_scoped_visibility_modifiers",
            "clippy::filetype_is_file",
            "clippy::float_arithmetic",
            "clippy::float_cmp_const",
            "clippy::fn_to_numeric_cast_any",
            "clippy::format_push_string",
            "clippy::get_unwrap",
            "clippy::host_endian_bytes",
            "clippy::if_then_some_else_none",
            "clippy::impl_trait_in_params",
            "clippy::implicit_return",
            "clippy::indexing_slicing",
            "clippy::infinite_loop",
            "clippy::inline_asm_x86_att_syntax",
            "clippy::inline_asm_x86_intel_syntax",
            "clippy::integer_division",
            "clippy::integer_division_remainder_used",
            "clippy::iter_over_hash_type",
            "clippy::large_include_file",
            "clippy::let_underscore_must_use",
            "clippy::let_underscore_untyped",
            "clippy::little_endian_bytes",
            "clippy::lossy_float_literal",
            "clippy::map_err_ignore",
            "clippy::mem_forget",
            "clippy::min_ident_chars",
            "clippy::missing_assert_message",
            "clippy::missing_asserts_for_indexing",
            "clippy::missing_docs_in_private_items",
            "clippy::missing_inline_in_public_items",
            "clippy::missing_trait_methods",
            "clippy::mixed_read_write_in_expression",
            "clippy::mod_module_files",
            "clippy::modulo_arithmetic",
            "clippy::multiple_inherent_impl",
            "clippy::multiple_unsafe_ops_per_block",
            "clippy::mutex_atomic",
            "clippy::needless_raw_strings",
            "clippy::non_ascii_literal",
            "clippy::panic",
            "clippy::panic_in_result_fn",
            "clippy::partial_pub_fields",
            "clippy::pattern_type_mismatch",
            "clippy::print_stderr",
            "clippy::print_stdout",
            "clippy::pub_use",
            "clippy::pub_with_shorthand",
            "clippy::pub_without_shorthand",
            "clippy::question_mark_used",
            "clippy::rc_buffer",
            "clippy::rc_mutex",
            "clippy::redundant_type_annotations",
            "clippy::ref_patterns",
            "clippy::renamed_function_params",
            "clippy::rest_pat_in_fully_bound_structs",
            "clippy::same_name_method",
            "clippy::self_named_module_files",
            "clippy::semicolon_inside_block",
            "clippy::semicolon_outside_block",
            "clippy::separated_literal_suffix",
            "clippy::shadow_reuse",
            "clippy::shadow_same",
            "clippy::shadow_unrelated",
            "clippy::single_call_fn",
            "clippy::single_char_lifetime_names",
            "clippy::std_instead_of_alloc",
            "clippy::std_instead_of_core",
            "clippy::str_to_string",
            "clippy::string_add",
            "clippy::string_lit_chars_any",
            "clippy::string_slice",
            "clippy::string_to_string",
            "clippy::suspicious_xor_used_as_pow",
            "clippy::tests_outside_test_module",
            "clippy::todo",
            "clippy::try_err",
            "clippy::undocumented_unsafe_blocks",
            "clippy::unimplemented",
            "clippy::unnecessary_safety_comment",
            "clippy::unnecessary_safety_doc",
            "clippy::unnecessary_self_imports",
            "clippy::unneeded_field_pattern",
            "clippy::unreachable",
            "clippy::unseparated_literal_suffix",
            "clippy::unwrap_in_result",
            "clippy::unwrap_used",
            "clippy::use_debug",
            "clippy::verbose_file_reads",
            "clippy::wildcard_enum_match_arm",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::style",
            description: r##"lint group for: clippy::assertions_on_constants, clippy::assign_op_pattern, clippy::blocks_in_conditions, clippy::bool_assert_comparison, clippy::borrow_interior_mutable_const, clippy::box_default, clippy::builtin_type_shadow, clippy::byte_char_slices, clippy::bytes_nth, clippy::chars_last_cmp, clippy::chars_next_cmp, clippy::cmp_null, clippy::collapsible_else_if, clippy::collapsible_if, clippy::collapsible_match, clippy::comparison_chain, clippy::comparison_to_empty, clippy::declare_interior_mutable_const, clippy::default_instead_of_iter_empty, clippy::disallowed_macros, clippy::disallowed_methods, clippy::disallowed_names, clippy::disallowed_types, clippy::doc_lazy_continuation, clippy::double_must_use, clippy::double_neg, clippy::duplicate_underscore_argument, clippy::enum_variant_names, clippy::err_expect, clippy::excessive_precision, clippy::field_reassign_with_default, clippy::filter_map_bool_then, clippy::fn_to_numeric_cast, clippy::fn_to_numeric_cast_with_truncation, clippy::for_kv_map, clippy::from_over_into, clippy::from_str_radix_10, clippy::get_first, clippy::if_same_then_else, clippy::implicit_saturating_add, clippy::implicit_saturating_sub, clippy::inconsistent_digit_grouping, clippy::infallible_destructuring_match, clippy::inherent_to_string, clippy::init_numbered_fields, clippy::into_iter_on_ref, clippy::is_digit_ascii_radix, clippy::items_after_test_module, clippy::iter_cloned_collect, clippy::iter_next_slice, clippy::iter_nth, clippy::iter_nth_zero, clippy::iter_skip_next, clippy::just_underscores_and_digits, clippy::legacy_numeric_constants, clippy::len_without_is_empty, clippy::len_zero, clippy::let_and_return, clippy::let_unit_value, clippy::main_recursion, clippy::manual_async_fn, clippy::manual_bits, clippy::manual_is_ascii_check, clippy::manual_is_finite, clippy::manual_is_infinite, clippy::manual_map, clippy::manual_next_back, clippy::manual_non_exhaustive, clippy::manual_pattern_char_comparison, clippy::manual_range_contains, clippy::manual_rotate, clippy::manual_saturating_arithmetic, clippy::manual_while_let_some, clippy::map_clone, clippy::map_collect_result_unit, clippy::match_like_matches_macro, clippy::match_overlapping_arm, clippy::match_ref_pats, clippy::match_result_ok, clippy::mem_replace_option_with_none, clippy::mem_replace_with_default, clippy::missing_enforced_import_renames, clippy::missing_safety_doc, clippy::mixed_attributes_style, clippy::mixed_case_hex_literals, clippy::module_inception, clippy::must_use_unit, clippy::mut_mutex_lock, clippy::needless_borrow, clippy::needless_borrows_for_generic_args, clippy::needless_doctest_main, clippy::needless_else, clippy::needless_late_init, clippy::needless_parens_on_range_literals, clippy::needless_pub_self, clippy::needless_range_loop, clippy::needless_return, clippy::needless_return_with_question_mark, clippy::neg_multiply, clippy::new_ret_no_self, clippy::new_without_default, clippy::non_minimal_cfg, clippy::obfuscated_if_else, clippy::ok_expect, clippy::op_ref, clippy::option_map_or_err_ok, clippy::option_map_or_none, clippy::partialeq_to_none, clippy::print_literal, clippy::print_with_newline, clippy::println_empty_string, clippy::ptr_arg, clippy::ptr_eq, clippy::question_mark, clippy::redundant_closure, clippy::redundant_field_names, clippy::redundant_pattern, clippy::redundant_pattern_matching, clippy::redundant_static_lifetimes, clippy::result_map_or_into_option, clippy::result_unit_err, clippy::same_item_push, clippy::self_named_constructors, clippy::should_implement_trait, clippy::single_char_add_str, clippy::single_component_path_imports, clippy::single_match, clippy::string_extend_chars, clippy::tabs_in_doc_comments, clippy::to_digit_is_some, clippy::to_string_trait_impl, clippy::toplevel_ref_arg, clippy::trim_split_whitespace, clippy::unnecessary_fallible_conversions, clippy::unnecessary_fold, clippy::unnecessary_lazy_evaluations, clippy::unnecessary_mut_passed, clippy::unnecessary_owned_empty_strings, clippy::unsafe_removed_from_name, clippy::unused_enumerate_index, clippy::unused_unit, clippy::unusual_byte_groupings, clippy::unwrap_or_default, clippy::upper_case_acronyms, clippy::while_let_on_iterator, clippy::write_literal, clippy::write_with_newline, clippy::writeln_empty_string, clippy::wrong_self_convention, clippy::zero_ptr"##,
        },
        children: &[
            "clippy::assertions_on_constants",
            "clippy::assign_op_pattern",
            "clippy::blocks_in_conditions",
            "clippy::bool_assert_comparison",
            "clippy::borrow_interior_mutable_const",
            "clippy::box_default",
            "clippy::builtin_type_shadow",
            "clippy::byte_char_slices",
            "clippy::bytes_nth",
            "clippy::chars_last_cmp",
            "clippy::chars_next_cmp",
            "clippy::cmp_null",
            "clippy::collapsible_else_if",
            "clippy::collapsible_if",
            "clippy::collapsible_match",
            "clippy::comparison_chain",
            "clippy::comparison_to_empty",
            "clippy::declare_interior_mutable_const",
            "clippy::default_instead_of_iter_empty",
            "clippy::disallowed_macros",
            "clippy::disallowed_methods",
            "clippy::disallowed_names",
            "clippy::disallowed_types",
            "clippy::doc_lazy_continuation",
            "clippy::double_must_use",
            "clippy::double_neg",
            "clippy::duplicate_underscore_argument",
            "clippy::enum_variant_names",
            "clippy::err_expect",
            "clippy::excessive_precision",
            "clippy::field_reassign_with_default",
            "clippy::filter_map_bool_then",
            "clippy::fn_to_numeric_cast",
            "clippy::fn_to_numeric_cast_with_truncation",
            "clippy::for_kv_map",
            "clippy::from_over_into",
            "clippy::from_str_radix_10",
            "clippy::get_first",
            "clippy::if_same_then_else",
            "clippy::implicit_saturating_add",
            "clippy::implicit_saturating_sub",
            "clippy::inconsistent_digit_grouping",
            "clippy::infallible_destructuring_match",
            "clippy::inherent_to_string",
            "clippy::init_numbered_fields",
            "clippy::into_iter_on_ref",
            "clippy::is_digit_ascii_radix",
            "clippy::items_after_test_module",
            "clippy::iter_cloned_collect",
            "clippy::iter_next_slice",
            "clippy::iter_nth",
            "clippy::iter_nth_zero",
            "clippy::iter_skip_next",
            "clippy::just_underscores_and_digits",
            "clippy::legacy_numeric_constants",
            "clippy::len_without_is_empty",
            "clippy::len_zero",
            "clippy::let_and_return",
            "clippy::let_unit_value",
            "clippy::main_recursion",
            "clippy::manual_async_fn",
            "clippy::manual_bits",
            "clippy::manual_is_ascii_check",
            "clippy::manual_is_finite",
            "clippy::manual_is_infinite",
            "clippy::manual_map",
            "clippy::manual_next_back",
            "clippy::manual_non_exhaustive",
            "clippy::manual_pattern_char_comparison",
            "clippy::manual_range_contains",
            "clippy::manual_rotate",
            "clippy::manual_saturating_arithmetic",
            "clippy::manual_while_let_some",
            "clippy::map_clone",
            "clippy::map_collect_result_unit",
            "clippy::match_like_matches_macro",
            "clippy::match_overlapping_arm",
            "clippy::match_ref_pats",
            "clippy::match_result_ok",
            "clippy::mem_replace_option_with_none",
            "clippy::mem_replace_with_default",
            "clippy::missing_enforced_import_renames",
            "clippy::missing_safety_doc",
            "clippy::mixed_attributes_style",
            "clippy::mixed_case_hex_literals",
            "clippy::module_inception",
            "clippy::must_use_unit",
            "clippy::mut_mutex_lock",
            "clippy::needless_borrow",
            "clippy::needless_borrows_for_generic_args",
            "clippy::needless_doctest_main",
            "clippy::needless_else",
            "clippy::needless_late_init",
            "clippy::needless_parens_on_range_literals",
            "clippy::needless_pub_self",
            "clippy::needless_range_loop",
            "clippy::needless_return",
            "clippy::needless_return_with_question_mark",
            "clippy::neg_multiply",
            "clippy::new_ret_no_self",
            "clippy::new_without_default",
            "clippy::non_minimal_cfg",
            "clippy::obfuscated_if_else",
            "clippy::ok_expect",
            "clippy::op_ref",
            "clippy::option_map_or_err_ok",
            "clippy::option_map_or_none",
            "clippy::partialeq_to_none",
            "clippy::print_literal",
            "clippy::print_with_newline",
            "clippy::println_empty_string",
            "clippy::ptr_arg",
            "clippy::ptr_eq",
            "clippy::question_mark",
            "clippy::redundant_closure",
            "clippy::redundant_field_names",
            "clippy::redundant_pattern",
            "clippy::redundant_pattern_matching",
            "clippy::redundant_static_lifetimes",
            "clippy::result_map_or_into_option",
            "clippy::result_unit_err",
            "clippy::same_item_push",
            "clippy::self_named_constructors",
            "clippy::should_implement_trait",
            "clippy::single_char_add_str",
            "clippy::single_component_path_imports",
            "clippy::single_match",
            "clippy::string_extend_chars",
            "clippy::tabs_in_doc_comments",
            "clippy::to_digit_is_some",
            "clippy::to_string_trait_impl",
            "clippy::toplevel_ref_arg",
            "clippy::trim_split_whitespace",
            "clippy::unnecessary_fallible_conversions",
            "clippy::unnecessary_fold",
            "clippy::unnecessary_lazy_evaluations",
            "clippy::unnecessary_mut_passed",
            "clippy::unnecessary_owned_empty_strings",
            "clippy::unsafe_removed_from_name",
            "clippy::unused_enumerate_index",
            "clippy::unused_unit",
            "clippy::unusual_byte_groupings",
            "clippy::unwrap_or_default",
            "clippy::upper_case_acronyms",
            "clippy::while_let_on_iterator",
            "clippy::write_literal",
            "clippy::write_with_newline",
            "clippy::writeln_empty_string",
            "clippy::wrong_self_convention",
            "clippy::zero_ptr",
        ],
    },
    LintGroup {
        lint: Lint {
            label: "clippy::suspicious",
            description: r##"lint group for: clippy::almost_complete_range, clippy::arc_with_non_send_sync, clippy::await_holding_invalid_type, clippy::await_holding_lock, clippy::await_holding_refcell_ref, clippy::blanket_clippy_restriction_lints, clippy::cast_abs_to_unsigned, clippy::cast_enum_constructor, clippy::cast_enum_truncation, clippy::cast_nan_to_int, clippy::cast_slice_from_raw_parts, clippy::const_is_empty, clippy::crate_in_macro_def, clippy::deprecated_clippy_cfg_attr, clippy::drop_non_drop, clippy::duplicate_mod, clippy::duplicated_attributes, clippy::empty_docs, clippy::empty_loop, clippy::float_equality_without_abs, clippy::forget_non_drop, clippy::four_forward_slashes, clippy::from_raw_with_void_ptr, clippy::incompatible_msrv, clippy::ineffective_open_options, clippy::iter_out_of_bounds, clippy::join_absolute_paths, clippy::let_underscore_future, clippy::lines_filter_map_ok, clippy::macro_metavars_in_unsafe, clippy::manual_unwrap_or_default, clippy::misnamed_getters, clippy::misrefactored_assign_op, clippy::missing_transmute_annotations, clippy::multi_assignments, clippy::multiple_bound_locations, clippy::mut_range_bound, clippy::mutable_key_type, clippy::needless_character_iteration, clippy::needless_maybe_sized, clippy::no_effect_replace, clippy::non_canonical_clone_impl, clippy::non_canonical_partial_ord_impl, clippy::octal_escapes, clippy::path_ends_with_ext, clippy::permissions_set_readonly_false, clippy::print_in_format_impl, clippy::rc_clone_in_vec_init, clippy::repeat_vec_with_capacity, clippy::single_range_in_vec_init, clippy::size_of_ref, clippy::suspicious_arithmetic_impl, clippy::suspicious_assignment_formatting, clippy::suspicious_command_arg_space, clippy::suspicious_doc_comments, clippy::suspicious_else_formatting, clippy::suspicious_map, clippy::suspicious_op_assign_impl, clippy::suspicious_open_options, clippy::suspicious_to_owned, clippy::suspicious_unary_op_formatting, clippy::swap_ptr_to_ref, clippy::test_attr_in_doctest, clippy::type_id_on_box, clippy::unconditional_recursion, clippy::unnecessary_clippy_cfg, clippy::unnecessary_get_then_check, clippy::unnecessary_result_map_or_else, clippy::zero_repeat_side_effects"##,
        },
        children: &[
            "clippy::almost_complete_range",
            "clippy::arc_with_non_send_sync",
            "clippy::await_holding_invalid_type",
            "clippy::await_holding_lock",
            "clippy::await_holding_refcell_ref",
            "clippy::blanket_clippy_restriction_lints",
            "clippy::cast_abs_to_unsigned",
            "clippy::cast_enum_constructor",
            "clippy::cast_enum_truncation",
            "clippy::cast_nan_to_int",
            "clippy::cast_slice_from_raw_parts",
            "clippy::const_is_empty",
            "clippy::crate_in_macro_def",
            "clippy::deprecated_clippy_cfg_attr",
            "clippy::drop_non_drop",
            "clippy::duplicate_mod",
            "clippy::duplicated_attributes",
            "clippy::empty_docs",
            "clippy::empty_loop",
            "clippy::float_equality_without_abs",
            "clippy::forget_non_drop",
            "clippy::four_forward_slashes",
            "clippy::from_raw_with_void_ptr",
            "clippy::incompatible_msrv",
            "clippy::ineffective_open_options",
            "clippy::iter_out_of_bounds",
            "clippy::join_absolute_paths",
            "clippy::let_underscore_future",
            "clippy::lines_filter_map_ok",
            "clippy::macro_metavars_in_unsafe",
            "clippy::manual_unwrap_or_default",
            "clippy::misnamed_getters",
            "clippy::misrefactored_assign_op",
            "clippy::missing_transmute_annotations",
            "clippy::multi_assignments",
            "clippy::multiple_bound_locations",
            "clippy::mut_range_bound",
            "clippy::mutable_key_type",
            "clippy::needless_character_iteration",
            "clippy::needless_maybe_sized",
            "clippy::no_effect_replace",
            "clippy::non_canonical_clone_impl",
            "clippy::non_canonical_partial_ord_impl",
            "clippy::octal_escapes",
            "clippy::path_ends_with_ext",
            "clippy::permissions_set_readonly_false",
            "clippy::print_in_format_impl",
            "clippy::rc_clone_in_vec_init",
            "clippy::repeat_vec_with_capacity",
            "clippy::single_range_in_vec_init",
            "clippy::size_of_ref",
            "clippy::suspicious_arithmetic_impl",
            "clippy::suspicious_assignment_formatting",
            "clippy::suspicious_command_arg_space",
            "clippy::suspicious_doc_comments",
            "clippy::suspicious_else_formatting",
            "clippy::suspicious_map",
            "clippy::suspicious_op_assign_impl",
            "clippy::suspicious_open_options",
            "clippy::suspicious_to_owned",
            "clippy::suspicious_unary_op_formatting",
            "clippy::swap_ptr_to_ref",
            "clippy::test_attr_in_doctest",
            "clippy::type_id_on_box",
            "clippy::unconditional_recursion",
            "clippy::unnecessary_clippy_cfg",
            "clippy::unnecessary_get_then_check",
            "clippy::unnecessary_result_map_or_else",
            "clippy::zero_repeat_side_effects",
        ],
    },
];
