\name{rweibull}
\alias{drweibull}
\alias{prweibull}
\alias{qrweibull}
\alias{rrweibull}
\alias{dnweibull}
\alias{pnweibull}
\alias{qnweibull}
\alias{rnweibull}
\title{The Reverse Weibull Distribution}
\description{
  Density function, distribution function, quantile function and
  random generation for the reverse (or negative) Weibull 
  distribution with location, scale and shape parameters. 
}
\usage{
drweibull(x, loc=0, scale=1, shape=1, log = FALSE) 
prweibull(q, loc=0, scale=1, shape=1, lower.tail = TRUE) 
qrweibull(p, loc=0, scale=1, shape=1, lower.tail = TRUE)
rrweibull(n, loc=0, scale=1, shape=1)

dnweibull(x, loc=0, scale=1, shape=1, log = FALSE) 
pnweibull(q, loc=0, scale=1, shape=1, lower.tail = TRUE) 
qnweibull(p, loc=0, scale=1, shape=1, lower.tail = TRUE)
rnweibull(n, loc=0, scale=1, shape=1)
}
\arguments{
  \item{x, q}{Vector of quantiles.}
  \item{p}{Vector of probabilities.}
  \item{n}{Number of observations.}
  \item{loc, scale, shape}{Location, scale and shape parameters (can be
    given as vectors).}
  \item{log}{Logical; if \code{TRUE}, the log density is returned.}
  \item{lower.tail}{Logical; if \code{TRUE} (default), probabilities
    are P[X <= x], otherwise, P[X > x]}
}
\details{
  The reverse (or negative) Weibull distribution function with parameters
  \eqn{\code{loc} = a}, \eqn{\code{scale} = b} and
  \eqn{\code{shape} = s} is
  \deqn{G(z) = \exp\left\{-\left[-\left(\frac{z-a}{b}\right)
    \right]^s\right\}}{G(x) = exp{-[-(z-a)/b]^s}}
  for \eqn{z < a} and one otherwise, where \eqn{b > 0} and
  \eqn{s > 0}.
}
\note{
  Within extreme value theory the reverse Weibull distibution (also
  known as the negative Weibull distribution) is often referred to 
  as the Weibull distribution.
  We make a distinction to avoid confusion with the three-parameter
  distribution used in survival analysis, which is related by a
  change of sign to the distribution given above.
}
\value{
  \code{drweibull} and \code{dnweibull} give the density function, 
  \code{prweibull} and \code{pnweibull} give the distribution function, 
  \code{qrweibull} and \code{qnweibull} give the quantile function, 
  \code{rrweibull} and \code{rnweibull} generate random deviates.
}

\seealso{\code{\link{rfrechet}}, \code{\link{rgev}}, \code{\link{rgumbel}}}

\examples{
drweibull(-5:-3, -1, 0.5, 0.8)
prweibull(-5:-3, -1, 0.5, 0.8)
qrweibull(seq(0.9, 0.6, -0.1), 2, 0.5, 0.8)
rrweibull(6, -1, 0.5, 0.8)
p <- (1:9)/10
prweibull(qrweibull(p, -1, 2, 0.8), -1, 2, 0.8)
## [1] 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9
}
\keyword{distribution}




