/*
 * Copyright 1997-98 by Pawel Krawczyk <kravietz@ceti.com.pl>
 *
 * See http://www.ceti.com.pl/~kravietz/progs/tacacs.html
 * for details.
 *
 * authen_r.c  Read PAP authentication reply from server.
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>

#include "tacplus.h"
#include "libtac.h"
#include "messages.h"
#include "../server.h"

/* reads packet from TACACS+ server; returns:
 *            NULL    if the authentication succeded
 *  string pointer    if it failed
 */
char *tac_authen_pap_read(int fd) {
 	HDR th;
 	struct authen_reply *tb;
 	int len_from_header, r, len_from_body;
	char *msg = NULL;
	int msg_len,data_len;

 	/* read the reply header */
 	r=read(fd, &th, TAC_PLUS_HDR_SIZE);
 	if(r < TAC_PLUS_HDR_SIZE) {
  		nsyslog(LOG_ERR,
 			"error reading PAP authen header, read %d of %d: %m",
		 	r, TAC_PLUS_HDR_SIZE);
  		return(strdup(system_err_msg));
 	}

 	/* check the reply fields in header */
	msg = _tac_check_header(&th, TAC_PLUS_AUTHEN);
	if(msg != NULL)
			return(strdup(msg));
 
 	len_from_header=ntohl(th.datalength);
 	tb=(struct authen_reply *) xmalloc(len_from_header);

 	/* read reply packet body */
 	r=read(fd, tb, len_from_header);
 	if(r < len_from_header) {
  		nsyslog(LOG_ERR,
			 "incomplete message body, %d bytes, expected %d: %m",
			 r, len_from_header);
  		return(strdup(system_err_msg));
 	}

 	/* decrypt the body */
 	_tac_crypt((u_char *) tb, &th, len_from_header);

	msg_len = ntohs(tb->msg_len);
	data_len = ntohs(tb->data_len);

 	/* check the length fields */
 	len_from_body=sizeof(tb->status) + sizeof(tb->flags) +
            sizeof(tb->msg_len) + sizeof(tb->data_len) +
            msg_len + data_len;

 	if(len_from_header != len_from_body) {
  		nsyslog(LOG_ERR,
			"invalid reply content, incorrect key?");
  		return(strdup(system_err_msg));
 	}


 	/* save status and clean up */
 	r=tb->status;
	if(msg_len) {
		msg=(char *) xmalloc(msg_len + 1);
		bcopy((char *) tb + TAC_AUTHEN_REPLY_FIXED_FIELDS_SIZE,
						msg, msg_len); 
	} else
		msg=xstrdup("Login incorrect");
/* I hope msg is freed somewhere */

 	free(tb);

 	/* server authenticated username and password successfully */
 	if(r == TAC_PLUS_AUTHEN_STATUS_PASS) {
		TACDEBUG((LOG_DEBUG, "%s: authentication ok", __FUNCTION__))
		return(NULL);
	}
		
	/* return pointer to server message */
	nsyslog(LOG_DEBUG, "authentication failed, server reply was %d (%s)", 
								r, msg);
 	return(strdup(msg));

} /* tac_authen_pap_read */
