/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFDocument;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFOutline;
import gnu.jpdf.PDFPageList;
import java.io.IOException;
import java.io.OutputStream;

public class PDFCatalog
extends PDFObject {
    private final PDFPageList pdfPageList;
    private PDFOutline outlines;
    private final int pagemode;

    public PDFCatalog(PDFPageList pDFPageList, int n) {
        super("/Catalog");
        this.pdfPageList = pDFPageList;
        this.pagemode = n;
    }

    protected void setOutline(PDFOutline pDFOutline) {
        this.outlines = pDFOutline;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        outputStream.write("/Pages ".getBytes());
        outputStream.write(this.pdfPageList.toString().getBytes());
        outputStream.write("\n".getBytes());
        if (this.outlines != null) {
            outputStream.write("/Outlines ".getBytes());
            outputStream.write(this.outlines.toString().getBytes());
            outputStream.write("\n".getBytes());
        }
        outputStream.write("/PageMode ".getBytes());
        outputStream.write(PDFDocument.PDF_PAGE_MODES[this.pagemode].getBytes());
        outputStream.write("\n".getBytes());
        this.writeEnd(outputStream);
    }
}

