create table t_lfn (
  id int primary key,
  name varchar(500) not null,
  ref int default 0 not null
);
create sequence s_lfn_id start with 1 increment by 1;
create or replace trigger tr_lfn
  before insert on t_lfn
  for each row
  begin
    select s_lfn_id.nextval into :new.id from dual;
  end tr_lfn;
/
create unique index t_lfn_name on t_lfn(name);

create table t_lrc (
  id int primary key,
  name varchar(500) not null,
  ref int default 0 not null
);
create sequence s_lrc_id start with 1 increment by 1;
create or replace trigger tr_lrc
  before insert on t_lrc
  for each row
  begin
    select s_lrc_id.nextval into :new.id from dual;
  end tr_lrc;
/
create unique index t_lrc_name on t_lrc(name);

create table t_sender (
  id int primary key,
  name varchar(500) not null,
  ref int default 0 not null
);
create sequence s_sender_id start with 1 increment by 1;
create or replace trigger tr_sender
  before insert on t_sender
  for each row
  begin
    select s_sender_id.nextval into :new.id from dual;
  end tr_sender;
/
create unique index t_sender_name on t_sender(name);

create table t_map (
  lfn_id int not null references t_lfn(id),
  lrc_id int not null references t_lrc(id),
  sender_id int not null references t_sender(id),
  updatetime timestamp not null
);
alter table t_map add constraint pk_map primary key(lfn_id, lrc_id, sender_id);
create index t_map_lrc_id on t_map(lrc_id);
create index t_map_sender_id on t_map(sender_id);
create index t_map_updatetime on t_map(updatetime);

create table t_rli (
  id int primary key,
  flags int default 0 not null,
  name varchar(500) not null
);
create sequence s_rli_id start with 1 increment by 1;
create or replace trigger tr_rli
  before insert on t_rli
  for each row
  begin
    select s_rli_id.nextval into :new.id from dual;
  end tr_rli;
/
create unique index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id int not null references t_rli(id),
  pattern varchar(500) not null
);
alter table t_rlipartition add constraint pk_rlipartition primary key(rli_id, pattern);
create index t_rlipartition_pattern on t_rlipartition(pattern);
