% JTeX change file by Yaski Saito
% ported to UNIX by Takafumi Sakurai (inijtex.ch)
% inijtex.ch and ctex.ch are merged to cjtex.ch by Shigeyuki Takagi
% 0.96 (88 May) EUC/shift-jis code support and some new features added
%	by Takafumi Sakurai and Shouichi Matsui
% 1.0  (88 Dec) japanese subfont autoload by Takafumi Sakurai
% 1.04 (89 Dec) by Takafumi Sakurai
% 1.05 (90 Feb) by Takafumi Sakurai
% 1.11 (90 May) delayed font by Takafumi Sakurai
% 1.2  (91 Feb) To version 3.0, some new features added
%	by Takafumi Sakurai
% 1.21 (91 Sep) bug fixes by Takafumi Sakurai
% 1.3  (92 Aug) To version 3.14 by Takafumi Sakurai
% 1.33 (93 Jun) more than 256 fonts by Takafumi Sakurai
% 1.4  (93 Jun) distiction of kanji and 8-bit char by Takafumi Sakurai
% 1.5  (93 Sep) To version 3.141 by Takafumi Sakurai

% tex.ch for C compilation with web2c, derived from various other change files.
% By Tim Morgan, UC Irvine ICS Department, and many others.
%
%
% Modification history:
% (05/28/86) ETM Started with TeX 2.0
% (06/03/87) ETM Brought up to TeX 2.2
% (09/26/87) ETM Brought up to TeX 2.3
% (10/01/87) ETM Brought up to TeX 2.5
% (12/21/87) ETM Brought up to TeX 2.7
% (01/14/88) ETM Brought up to TeX 2.9
% (02/20/88) PAM Revised format and module numbers
% (03/01/88) ETM Eliminated some unused variables and unnecesary tests
% (05/09/88) ETM Added yet another casting bug fix
% (06/21/88) ETM Brought up to TeX version 2.93
% (12/11/88) ETM Brought up to TeX version 2.94
% (01/12/89) PAM Brought up to TeX version 2.95
% (02/14/89) ETM Brought up to TeX version 2.96
% (03/10/89) ETM Brought up to TeX version 2.98
% (07/06/89) ETM Brought up to TeX version 2.991
% (11/30/89) KB  To version 2.992 (8-bit).
% (01/10/90) SR  To version 2.993.
% (03/27/90) KY  To version 3.0.
% (more recent changes in ChangeLog)
% 
% The module numbers in this change file refer to the published text in
% TeX: The Program, Volume B of Computers&Typesetting.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [0] WEAVE: print changes only.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
  \def\?##1]{\hbox to 1in{\hfil##1.\ }}
  }
@y
  \def\?##1]{\hbox{Changes to \hbox to 1em{\hfil##1}.\ }}
  }
\let\maybe=\iffalse
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.2] banner line
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d banner=='This is TeX, Version 3.1415' {printed when \TeX\ starts}
@y
@d banner=='This is JTeX, Version 1.6, based on TeX Version 3.1415'
						{printed when \TeX\ starts}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.4] program header
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
Actually the heading shown here is not quite normal: The |program| line
does not mention any |output| file, because \ph\ would ask the \TeX\ user
to specify a file name if |output| were specified here.
@^system dependencies@>

@d mtype==t@&y@&p@&e {this is a \.{WEB} coding trick:}
@f mtype==type {`\&{mtype}' will be equivalent to `\&{type}'}
@f type==true {but `|type|' will not be treated as a reserved word}

@p @t\4@>@<Compiler directives@>@/
program TEX; {all file names are defined dynamically}
label @<Labels in the outer block@>@/
@y

@d mtype==t@&y@&p@&e {this is a \.{WEB} coding trick:}
@f mtype==type {`\&{mtype}' will be equivalent to `\&{type}'}
@f type==true {but `|type|' will not be treated as a reserved word}

@p @t\4@>@<Compiler directives@>@/
program TEX; {all file names are defined dynamically}
@z

@x Changes for JTeX: [4]
@t\4@>@<Basic printing procedures@>@/
@t\4@>@<Error handling procedures@>@/
@y
@t\4@>@<Basic printing procedures@>@/
@t\4@>@<Error handling procedures@>@/
@t\4@>@<Utility functions and procedures for Japanese@>@/
@z

@x
@<Labels in the out...@>=
start_of_TEX@t\hskip-2pt@>, end_of_TEX@t\hskip-2pt@>,@,final_end;
  {key control points}
@y
@<Labels in the outer block@>=
start_of_TEX@t\hskip-2pt@>, end_of_TEX@t\hskip-2pt@>,@,final_end;
  {key control points}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.7] debug..gubed, stat..tats
% Here we change these WEB symbols, which are used much as #ifdef's
% are in C, into something which will get translated into actual #ifdef's.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d debug==@{ {change this to `$\\{debug}\equiv\null$' when debugging}
@d gubed==@t@>@} {change this to `$\\{gubed}\equiv\null$' when debugging}
@y
@d debug==ifdef('DEBUG')
@d gubed==endif('DEBUG')
@z
@x
@d stat==@{ {change this to `$\\{stat}\equiv\null$' when gathering
  usage statistics}
@d tats==@t@>@} {change this to `$\\{tats}\equiv\null$' when gathering
  usage statistics}
@y
@d stat==ifdef('STAT')
@d tats==endif('STAT')
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.8] Same, for `init..tini'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d init== {change this to `$\\{init}\equiv\.{@@\{}$' in the production version}
@d tini== {change this to `$\\{tini}\equiv\.{@@\}}$' in the production version}
@y
@d init==ifdef('INITEX')
@d tini==endif('INITEX')
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.9] Turn off all compiler directives.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@{@&$C-,A+,D-@} {no range check, catch arithmetic overflow, no debug overhead}
@!debug @{@&$C+,D+@}@+ gubed {but turn everything on when debugging}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.11] Compile-time constants: some enlarged, dvi_buf_size 16K for
% BSD I/O, file_name_size is set from the system constant.
% JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@<Constants...@>=
@!mem_max=30000; {greatest index in \TeX's internal |mem| array;
  must be strictly less than |max_halfword|;
  must be equal to |mem_top| in \.{INITEX}, otherwise |>=mem_top|}
@!mem_min=0; {smallest index in \TeX's internal |mem| array;
  must be |min_halfword| or more;
  must be equal to |mem_bot| in \.{INITEX}, otherwise |<=mem_bot|}
@!buf_size=500; {maximum number of characters simultaneously present in
  current lines of open files and in control sequences between
  \.{\\csname} and \.{\\endcsname}; must not exceed |max_halfword|}
@!error_line=72; {width of context lines on terminal error messages}
@!half_error_line=42; {width of first lines of contexts in terminal
  error messages; should be between 30 and |error_line-15|}
@!max_print_line=79; {width of longest text lines output; should be at least 60}
@!stack_size=200; {maximum number of simultaneous input sources}
@!max_in_open=6; {maximum number of input files and error insertions that
  can be going on simultaneously}
@!font_max=75; {maximum internal font number; must not exceed |max_quarterword|
  and must be at most |font_base+256|}
@!font_mem_size=20000; {number of words of |font_info| for all fonts}
@!param_size=60; {maximum number of simultaneous macro parameters}
@!nest_size=40; {maximum number of semantic levels simultaneously active}
@!max_strings=3000; {maximum number of strings; must not exceed |max_halfword|}
@!string_vacancies=8000; {the minimum number of characters that should be
  available for the user's control sequences and font names,
  after \TeX's own error messages are stored}
@!pool_size=32000; {maximum number of characters in strings, including all
  error messages and help texts, and the names of all fonts and
  control sequences; must exceed |string_vacancies| by the total
  length of \TeX's own strings, which is currently about 23000}
@!save_size=600; {space for saving values outside of current group; must be
  at most |max_halfword|}
@!trie_size=8000; {space for hyphenation patterns; should be larger for
  \.{INITEX} than it is in production versions of \TeX}
@!trie_op_size=500; {space for ``opcodes'' in the hyphenation patterns}
@!dvi_buf_size=800; {size of the output buffer; must be a multiple of 8}
@!file_name_size=40; {file names shouldn't be longer than this}
@!pool_name='TeXformats:TEX.POOL                     ';
  {string of length |file_name_size|; tells where the string pool appears}
@y
@d file_name_size == PATH_MAX
@d error_line_def=79
@d trick_line=error_line_def+error_line_def-1
@^JTeX constant@>
@<Constants...@>=
@!mem_max=262140; {greatest index in \TeX's internal |mem| array;
  must be strictly less than |max_halfword|;
  must be equal to |mem_top| in \.{INITEX}, otherwise |>=mem_top|}
@!mem_min=0; {smallest index in \TeX's internal |mem| array;
  must be |min_halfword| or more;
  must be equal to |mem_bot| in \.{INITEX}, otherwise |<=mem_bot|}
@!buf_size=3000; {maximum number of characters simultaneously present in
  current lines of open files and in control sequences between
  \.{\\csname} and \.{\\endcsname}; must not exceed |max_halfword|}
@!error_line=error_line_def; {width of context lines on terminal error messages}
@!half_error_line=50; {width of first lines of contexts in terminal
  error messages; should be between 30 and |error_line-15|}
@!max_print_line=79; {width of longest text lines output; should be at least 60}
@!stack_size=300; {maximum number of simultaneous input sources}
@!max_in_open=15; {maximum number of input files and error insertions that
  can be going on simultaneously}
@!font_max=511; {maximum internal font number; must not exceed |max_quarterword|
  and must be at most |font_base+font_max_limit|}
@!font_mem_size=100000; {number of words of |font_info| for all fonts}
@!param_size=60; {maximum number of simultaneous macro parameters}
@!nest_size=80; {maximum number of semantic levels simultaneously active}
@!max_strings=15000; {maximum number of strings; must not exceed |max_halfword|}
@!string_vacancies=100000; {the minimum number of characters that should be
  available for the user's control sequences and font names,
  after \TeX's own error messages are stored}
@!pool_size=126000; {maximum number of characters in strings, including all
  error messages and help texts, and the names of all fonts and
  control sequences; must exceed |string_vacancies| by the total
  length of \TeX's own strings, which is currently about 23000}
@!save_size=4000; {space for saving values outside of current group; must be
  at most |max_halfword|}
@!trie_size=24000; {space for hyphenation patterns; should be larger for
  \.{INITEX} than it is in production versions of \TeX}
@!trie_op_size=750; {space for ``opcodes'' in the hyphenation patterns}
@!neg_trie_op_size=-750; {for lower trie_op_hash array bound}
@!min_trie_op=0; {first possible trie op code for any language}
@!max_trie_op=500; {largest possible trie op code for any language}
@!dvi_buf_size=16384; {size of the output buffer; must be a multiple of 8}
@!pool_name=TEX_POOL_NAME; {name comes from \.{site.h}.}
  {string of length |file_name_size|; tells where the string pool appears}
@!mem_top=262140; {largest index in the |mem| array dumped by \.{INITEX};
  must be substantially larger than |mem_bot|,
  equal to |mem_max| in \.{INITEX}, else not greater than |mem_max|}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.12] Sensitive compile-time constants.  For C we change mem_base and
% hi_mem_base to reflect our use of 0-origin vs pc's use of
% negative-origin.  Despite the fact that it is a ``sensitive''
% constant, we're going to make mem_top a #define in the C code for
% readability and ease of modification (it's up above) -- it needs
% to be changed for the trip test.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d mem_bot=0 {smallest index in the |mem| array dumped by \.{INITEX};
  must not be less than |mem_min|}
@d mem_top==30000 {largest index in the |mem| array dumped by \.{INITEX};
  must be substantially larger than |mem_bot|
  and not greater than |mem_max|}
@d font_base=0 {smallest internal font number; must not be less
  than |min_quarterword|}
@d hash_size=2100 {maximum number of control sequences; it should be at most
  about |(mem_max-mem_min)/10|}
@d hash_prime=1777 {a prime number equal to about 85\pct! of |hash_size|}
@d hyph_size=307 {another prime; the number of \.{\\hyphenation} exceptions}
@y
@d mem_bot=0 {smallest index in the |mem| array dumped by \.{INITEX};
  must not be less than |mem_min|}
@d font_base=0 {smallest internal font number; must not be less
  than |min_quarterword|}
@d hash_size=9500 {maximum number of control sequences; it should be at most
  about |(mem_max-mem_min)/10|}
@d hash_prime=7919 {a prime number equal to about 85\pct! of |hash_size|}
@d hyph_size=607 {another prime; the number of \.{\\hyphenation} exceptions}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.16] Use C macros for `incr' and `decr'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d incr(#) == #:=#+1 {increase a variable by unity}
@d decr(#) == #:=#-1 {decrease a variable by unity}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [1.18] JTeX: Internal representation of kanji and 8bit char
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ Characters of text that have been converted to \TeX's internal form
are said to be of type |ASCII_code|, which is a subrange of the integers.
@y
@ Characters of text that have been converted to \TeX's internal form
are said to be of type |ASCII_code|, which is a subrange of the integers.

In |buffer|, |str_pool|, and |trick_buf|, a japanese char (kanji) is
represented by two bytes: |firstbyte+EXTCHARBIT| and |secondbyte|,
where |firstbyte| and |secondbyte| is the JIS-code of the japanese char.
Furthermore, the internal representation of an eighbit char (an ascii char
with eighth bit on) different from that of \Tex, that is, it is represented
by two bytes: |EXTCHARBIT| and |thebyte-128|. The reason for this complication
is to save memory needed for |str_pool|.

@d EXTCHARBIT = 128
@d is_ext_char(#) == ((#)>=EXTCHARBIT)
@d is_ext_eightbit(#) == ((#)=EXTCHARBIT)
@d ext_eightbit == EXTCHARBIT
@d is_eightbit(#) == ((#)>=128)
@d make_eightbit(#) == ((#)+128)
@d de_eightbit(#) == ((#)-128)
@d is_ext_kanji(#) == ((#)>EXTCHARBIT)
@d make_ext_kanji(#) == ((#)+EXTCHARBIT)
@d de_ext_kanji(#) == ((#)-EXTCHARBIT)

@d repos_char(#) == begin
  if (#>start) and (is_ext_char(buffer[#-1])) then decr(#);
  end
@d backward_onechar(#) == begin decr(#); repos_char(#) end
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [??] The text_char type is used as an array index into xord.  The
% default type `char' produces signed integers, which are bad array
% indices in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d text_char == char {the data type of characters in text files}
@y
@d text_char == ASCII_code {the data type of characters in text files}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [2.23] Allow any character as input.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
for i:=0 to @'37 do xchr[i]:=' ';
for i:=@'177 to @'377 do xchr[i]:=' ';
@y
for i:=0 to @'37 do xchr[i]:=chr(i);
for i:=@'177 to @'377 do xchr[i]:=chr(i);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.25] Remove file types we don't need.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
The program actually makes use also of a third kind of file, called a
|word_file|, when dumping and reloading base information for its own
initialization.  We shall define a word file later; but it will be possible
for us to specify simple operations on word files before they are defined.
  
@y
I/O in C is done using standard I/O.  We will define the path numbers
in an include file for C which are used in searching for files to be
read.  We'll define all the file types in C also.
@z

@x
@!alpha_file=packed file of text_char; {files that contain textual data}
@!byte_file=packed file of eight_bits; {files that contain binary data}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.27] Do file opening in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ The \ph\ compiler with which the present version of \TeX\ was prepared has
extended the rules of \PASCAL\ in a very convenient way. To open file~|f|,
we can write
$$\vbox{\halign{#\hfil\qquad&#\hfil\cr
|reset(f,@t\\{name}@>,'/O')|&for input;\cr
|rewrite(f,@t\\{name}@>,'/O')|&for output.\cr}}$$
The `\\{name}' parameter, which is of type `{\bf packed array
$[\langle\\{any}\rangle]$ of \\{char}}', stands for the name of
the external file that is being opened for input or output.
Blank spaces that might appear in \\{name} are ignored.

The `\.{/O}' parameter tells the operating system not to issue its own
error messages if something goes wrong. If a file of the specified name
cannot be found, or if such a file cannot be opened for some other reason
(e.g., someone may already be trying to write the same file), we will have
|@!erstat(f)<>0| after an unsuccessful |reset| or |rewrite|.  This allows
\TeX\ to undertake appropriate corrective action.
@:PASCAL H}{\ph@>
@^system dependencies@>

\TeX's file-opening procedures return |false| if no file identified by
|name_of_file| could be opened.

@d reset_OK(#)==erstat(#)=0
@d rewrite_OK(#)==erstat(#)=0

@p function a_open_in(var f:alpha_file):boolean;
  {open a text file for input}
begin reset(f,name_of_file,'/O'); a_open_in:=reset_OK(f);
end;
@#
function a_open_out(var f:alpha_file):boolean;
  {open a text file for output}
begin rewrite(f,name_of_file,'/O'); a_open_out:=rewrite_OK(f);
end;
@#
function b_open_in(var f:byte_file):boolean;
  {open a binary file for input}
begin reset(f,name_of_file,'/O'); b_open_in:=reset_OK(f);
end;
@#
function b_open_out(var f:byte_file):boolean;
  {open a binary file for output}
begin rewrite(f,name_of_file,'/O'); b_open_out:=rewrite_OK(f);
end;
@#
function w_open_in(var f:word_file):boolean;
  {open a word file for input}
begin reset(f,name_of_file,'/O'); w_open_in:=reset_OK(f);
end;
@#
function w_open_out(var f:word_file):boolean;
  {open a word file for output}
begin rewrite(f,name_of_file,'/O'); w_open_out:=rewrite_OK(f);
end;
@y
@ All of the file opening functions are defined in C.
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.28] Do file closing in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ Files can be closed with the \ph\ routine `|close(f)|', which
@^system dependencies@>
should be used when all input or output with respect to |f| has been completed.
This makes |f| available to be opened again, if desired; and if |f| was used for
output, the |close| operation makes the corresponding external file appear
on the user's area, ready to be read.

These procedures should not generate error messages if a file is
being closed before it has been successfully opened.

@p procedure a_close(var f:alpha_file); {close a text file}
begin close(f);
end;
@#
procedure b_close(var f:byte_file); {close a binary file}
begin close(f);
end;
@#
procedure w_close(var f:word_file); {close a word file}
begin close(f);
end;
@y
@ And all the file closing routines as well.
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.31] Do `input_ln' in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@p function input_ln(var f:alpha_file;@!bypass_eoln:boolean):boolean;
  {inputs the next line or returns |false|}
var last_nonblank:0..buf_size; {|last| with trailing blanks removed}
begin if bypass_eoln then if not eof(f) then get(f);
  {input the first character of the line into |f^|}
last:=first; {cf.\ Matthew 19\thinspace:\thinspace30}
if eof(f) then input_ln:=false
else  begin last_nonblank:=first;
  while not eoln(f) do
    begin if last>=max_buf_stack then
      begin max_buf_stack:=last+1;
      if max_buf_stack=buf_size then
        @<Report overflow of the input buffer, and abort@>;
      end;
    buffer[last]:=xord[f^]; get(f); incr(last);
    if buffer[last-1]<>" " then last_nonblank:=last;
    end;
  last:=last_nonblank; input_ln:=true;
  end;
end;
@y
We define |input_ln| in C, for efficiency.
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.32] `term_in' and `term_out' are standard input and output.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@<Glob...@>=
@!term_in:alpha_file; {the terminal as an input file}
@!term_out:alpha_file; {the terminal as an output file}
@y
@d term_in==stdin {the terminal as an input file}
@d term_out==stdout {the terminal as an output file}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.33] We don't need to open terminal files.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ Here is how to open the terminal files
in \ph. The `\.{/I}' switch suppresses the first |get|.
@^system dependencies@>

@d t_open_in==reset(term_in,'TTY:','/O/I') {open the terminal for text input}
@d t_open_out==rewrite(term_out,'TTY:','/O') {open the terminal for text output}
@y
@ Here is how to open the terminal files.  |t_open_out| does nothing.
|t_open_in|, on the other hand, does the work of ``rescanning,'' or getting
any command line arguments the user has provided.  It's defined in C.

@d t_open_out == {output already open for text output}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.34] Flushing output.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
these operations can be specified in \ph:
@^system dependencies@>

@d update_terminal == break(term_out) {empty the terminal output buffer}
@d clear_terminal == break_in(term_in,true) {clear the terminal input buffer}
@y
these operations can be specified with {\mc UNIX}.  |update_terminal|
does an |fflush| (via the macro |flush|). |clear_terminal| is redefined
to do nothing, since the user should control the terminal.
@^system dependencies@>

@d update_terminal == flush (term_out)
@d clear_terminal == do_nothing
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [3.37] Reading the command line.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ The following program does the required initialization
without retrieving a possible command line.
It should be clear how to modify this routine to deal with command lines,
if the system permits them.
@^system dependencies@>

@p function init_terminal:boolean; {gets the terminal input started}
label exit;
begin t_open_in;
loop@+begin wake_up_terminal; write(term_out,'**'); update_terminal;
@.**@>
  if not input_ln(term_in,true) then {this shouldn't happen}
    begin write_ln(term_out);
    write(term_out,'! End of file on the terminal... why?');
@.End of file on the terminal@>
    init_terminal:=false; return;
    end;
  loc:=first;
  while (loc<last)and(buffer[loc]=" ") do incr(loc);
  if loc<last then
    begin init_terminal:=true;
    return; {return unless the line was all blank}
    end;
  write_ln(term_out,'Please type the name of your input file.');
  end;
exit:end;
@y
@ The following program does the required initialization.
Iff anything has been specified on the command line, then |t_open_in|
will return with |last > first|.
@^system dependencies@>

@p
function init_terminal:boolean; {gets the terminal input started}
label exit;
begin
    t_open_in;
    if last > first then begin
        loc := first;
        while (loc < last) and (buffer[loc]=' ') do
	    incr(loc);
        if loc < last then begin
            init_terminal := true;
            goto exit;
        end;
    end;
    loop@+begin
        wake_up_terminal; write(term_out, '**'); update_terminal;
@.**@>
        if not input_ln(term_in,true) then begin {this shouldn't happen}
            write_ln(term_out);
            write(term_out, '! End of file on the terminal... why?');
@.End of file on the terminal@>
            init_terminal:=false;
	    return;
        end;

        loc:=first;
        while (loc<last)and(buffer[loc]=" ") do
            incr(loc);

        if loc<last then begin
           init_terminal:=true;
           return; {return unless the line was all blank}
        end;
        write_ln(term_out, 'Please type the name of your input file.');
    end;
exit:
end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [4.51] Open the pool file using a path, and can't do string
% assignments directly.  (`strcpy' and `strlen' work here because
% `pool_name' is a constant string, and thus ends in a null and doesn't
% start with a space.)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
name_of_file:=pool_name; {we needn't set |name_length|}
if a_open_in(pool_file) then
@y
vstrcpy (name_of_file+1, pool_name); {copy the string}
name_of_file[0] := ' ';
name_of_file[strlen (pool_name) +1 ] := ' ';
name_length := strlen (pool_name);
if a_open_in (pool_file, TEX_POOL_PATH) then
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [4.51,52,53] Make `TEX.POOL' lowercase in messages, and change how
% it's read.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
else  bad_pool('! I can''t read TEX.POOL.')
@y
else begin
   {Like |bad_pool|, but must not close file if we never opened it}
   wake_up_terminal; write_ln(term_out, '! I can''t read jtex.pool.');
   get_strings_started:= false; return;
end
@z
@x
begin if eof(pool_file) then bad_pool('! TEX.POOL has no check sum.');
@.TEX.POOL has no check sum@>
read(pool_file,m,n); {read two digits of string length}
@y
begin if eof(pool_file) then bad_pool('! jtex.pool has no check sum.');
@.TEX.POOL has no check sum@>
read(pool_file,m); read(pool_file,n); {read two digits of string length}
@z
@x
    bad_pool('! TEX.POOL line doesn''t begin with two digits.');
@y
    bad_pool('! jtex.pool line doesn''t begin with two digits.');
@z
@x
  bad_pool('! TEX.POOL check sum doesn''t have nine digits.');
@y
  bad_pool('! jtex.pool check sum doesn''t have nine digits.');
@z
@x
done: if a<>@$ then bad_pool('! TEX.POOL doesn''t match; TANGLE me again.');
@y
done: if a<>@$ then bad_pool('! jtex.pool doesn''t match; tangle me again.');
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [5.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [54]
@!trick_buf:array[0..error_line] of ASCII_code; {circular buffer for
  pseudoprinting}
@y
@!trick_buf:array[0..trick_line] of ASCII_code; {circular buffer for
  pseudoprinting}
@!tally_disp: integer;
@!first_count_disp: integer;
@z

@x
@ @<Initialize the output routines@>=
selector:=term_only; tally:=0; term_offset:=0; file_offset:=0;
@y
@ @<Initialize the output routines@>=
selector:=term_only; tally:=0; term_offset:=0; file_offset:=0;
tally_disp:=0;
@z

@x Changes for JTeX: [58] Japanese two bytes code may overshoot max_print_line
procedure print_char(@!s:ASCII_code); {prints a single character}
label exit;
begin if @<Character |s| is the current new-line character@> then
 if selector<pseudo then
  begin print_ln; return;
  end;
case selector of
term_and_log: begin wterm(xchr[s]); wlog(xchr[s]);
  incr(term_offset); incr(file_offset);
  if term_offset=max_print_line then
    begin wterm_cr; term_offset:=0;
    end;
  if file_offset=max_print_line then
    begin wlog_cr; file_offset:=0;
    end;
  end;
log_only: begin wlog(xchr[s]); incr(file_offset);
  if file_offset=max_print_line then print_ln;
  end;
term_only: begin wterm(xchr[s]); incr(term_offset);
  if term_offset=max_print_line then print_ln;
  end;
no_print: do_nothing;
pseudo: if tally<trick_count then trick_buf[tally mod error_line]:=s;
new_string: begin if pool_ptr<pool_size then append_char(s);
  end; {we drop characters if the string space is full}
othercases write(write_file[selector],xchr[s])
endcases;@/
incr(tally);
exit:end;
@y
@<Declare procedures used by |print_char|@>
procedure print_char(@!s:ASCII_code); {prints a single character}
label exit;
var is_newline:boolean;
begin
case selector of
term_and_log: begin
  if print_char_term(s) then do_nothing;
  if print_char_log(s) then return;
  end;
log_only: if print_char_log(s) then return;
term_only: if print_char_term(s) then return;
no_print: do_nothing;
pseudo: if tally_disp<trick_count then @<Store char in |trick_buf|@>;
new_string: begin if pool_ptr<pool_size then append_char(s);
  end; {we drop characters if the string space is full}
othercases @<Print char to |write_file|@>
endcases;@/
incr(tally);
exit:end;
@z

% dummy necessary because |print| and |slow_print| are similar
%@x Changes for JTeX: [60]
%procedure slow_print(@!s:integer); {prints string |s|}
%@y
%procedure slow_print(@!s:integer); {prints string |s|}
%@z

@x Changes for JTeX: [60]
  while j<str_start[s+1] do
    begin print(so(str_pool[j])); incr(j);
    end;
@y
  @<Print chars in |str_pool| in printable form@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [5.61] Eliminate the misleading message ``(no format preloaded)''.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
wterm(banner);
if format_ident=0 then wterm_ln(' (no format preloaded)')
else  begin slow_print(format_ident); print_ln;
  end;
@y
wterm (banner);
wterm (version_string);
if format_ident>0 then slow_print(format_ident); 
print_ln;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [6.81] Eliminate nonlocal goto, since C doesn't have them.
% Plus, it's nicer just to do an exit with the appropriate status code
% under Unix.  We call it `uexit' because there's a WEB symbol called
% `exit' already.  We use a C macro to change `uexit' back to `exit'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@<Error hand...@>=
procedure jump_out;
begin goto end_of_TEX;
end;
@y
@d do_final_end==begin
   update_terminal;
   ready_already:=0;
   if (history <> spotless) and (history <> warning_issued) then
       uexit(1)
   else
       uexit(0);
   end
@<Error hand...@>=
procedure jump_out;
begin
close_files_and_terminate;
do_final_end;
end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [6.84] Implement the switch-to-editor option.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
line ready to be edited. But such an extension requires some system
wizardry, so the present implementation simply types out the name of the
file that should be
edited and the relevant line number.
@^system dependencies@>

There is a secret `\.D' option available when the debugging routines haven't 
been commented~out.
@^debugging@>
@y
line ready to be edited.
We do this by calling the external procedure |call_edit| with a pointer to
the filename, its length, and the line number.
However, here we just set up the variables that will be used as arguments,
since we don't want to do the switch-to-editor until after TeX has closed
its files.
@^system dependencies@>

There is a secret `\.D' option available when the debugging routines haven't
been commented~out.
@^debugging@>
@d edit_file==input_stack[base_ptr]
@z
@x
"E": if base_ptr>0 then
  begin print_nl("You want to edit file ");
@.You want to edit file x@>
  slow_print(input_stack[base_ptr].name_field);
  print(" at line "); print_int(line);
  interaction:=scroll_mode; jump_out;
@y
"E": if base_ptr>0 then
    begin
    edit_name_start:=str_start[edit_file.name_field];
    edit_name_length:=str_start[edit_file.name_field+1] -
    		      str_start[edit_file.name_field];
    edit_line:=line;
    jump_out;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [7.104] `remainder' is a library routine on some systems, so change
% its name to avoid conflicts.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@<Glob...@>=
@!arith_error:boolean; {has arithmetic overflow occurred recently?}
@!remainder:scaled; {amount subtracted to get an exact division}
@y
@d remainder == tex_remainder
@<Glob...@>=
@!arith_error:boolean; {has arithmetic overflow occurred recently?}
@!remainder:scaled; {amount subtracted to get an exact division}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [7.109] Define glue_ratio in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!glue_ratio=real; {one-word representation of a glue expansion factor}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [8.110] Make it easy to change constants.  Do not increase
% max_quarterword without changing the memoryword structure in
% `texmfmem.h'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d min_quarterword=0 {smallest allowable value in a |quarterword|}
@d max_quarterword=255 {largest allowable value in a |quarterword|}
@d min_halfword==0 {smallest allowable value in a |halfword|}
@d max_halfword==65535 {largest allowable value in a |halfword|}
@y
@d min_quarterword=0 {smallest allowable value in a |quarterword|}
@d max_quarterword==65535 {largest allowable value in a |quarterword|}
@d min_halfword==0 {smallest allowable value in a |halfword|}
@d max_halfword==33554431 {largest allowable value in a |halfword|}
@d font_max_limit=512
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [8.111] More fonts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if font_max>font_base+256 then bad:=16;
@y
if font_max>font_base+font_max_limit then bad:=16;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [8.112] Efficiency.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
The inner loop of \TeX\ will run faster with respect to compilers
that don't optimize expressions like `|x+0|' and `|x-0|', if these
macros are simplified in the obvious way when |min_quarterword=0|.
@^inner loop@>@^system dependencies@>

@d qi(#)==#+min_quarterword
  {to put an |eight_bits| item into a quarterword}
@d qo(#)==#-min_quarterword
  {to take an |eight_bits| item out of a quarterword}
@d hi(#)==#+min_halfword
  {to put a sixteen-bit item into a halfword}
@d ho(#)==#-min_halfword
  {to take a sixteen-bit item from a halfword}
@y
The inner loop of \TeX\ will run faster with respect to compilers
that don't optimize expressions like `|x+0|' and `|x-0|', if these
macros are simplified in the obvious way when |min_quarterword=0|.
So they have been simplified here in the obvious way.
@^inner loop@>@^system dependencies@>

@d qi(#)==# {to put an |eight_bits| item into a quarterword}
@d qo(#)==# {to take an |eight_bits| item from a quarterword}
@d hi(#)==# {to put a sixteen-bit item into a halfword}
@d ho(#)==# {to take a sixteen-bit item from a halfword}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [8.113] Put the memory structure into an include file, since it's too
% hard to translate automatically.  Also, remove the `word_file' type.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!quarterword = min_quarterword..max_quarterword; {1/4 of a word}
@!halfword=min_halfword..max_halfword; {1/2 of a word}
@!two_choices = 1..2; {used when there are two variants in a record}
@!four_choices = 1..4; {used when there are four variants in a record}
@!two_halves = packed record@;@/
  @!rh:halfword;
  case two_choices of
  1: (@!lh:halfword);
  2: (@!b0:quarterword; @!b1:quarterword);
  end;
@!four_quarters = packed record@;@/
  @!b0:quarterword;
  @!b1:quarterword;
  @!b2:quarterword;
  @!b3:quarterword;
  end;
@!memory_word = record@;@/
  case four_choices of
  1: (@!int:integer);
  2: (@!gr:glue_ratio);
  3: (@!hh:two_halves);
  4: (@!qqqq:four_quarters);
  end;
@!word_file = file of memory_word;
@y
@!quarterword=min_quarterword..max_quarterword;
@!halfword=min_halfword..max_halfword;
@!two_choices = 1..2; {used when there are two variants in a record}
@!four_choices = 1..4; {used when there are four variants in a record}
@=#include "texmfmem.h";@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [9.116] Change `mem' to `zmem', so we can define mem to be a register
% pointer to the memory array for speed.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!mem : array[mem_min..mem_max] of memory_word; {the big dynamic storage area}
@y
@!zmem : array[mem_min..mem_max] of memory_word; {the big dynamic storage area}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [9.127] Fix casting problem in C.
% There are several of these.  They come from the rules C uses for
% comparing signed and unsigned quantities.  Just doing the comparison
% can result in incorrect evaluation wrt the way Pascal would do it.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if r>p+1 then @<Allocate from the top of node |p| and |goto found|@>;
@y
if r>toint(p+1) then @<Allocate from the top of node |p| and |goto found|@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [10.X] delayed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [160]
@ In fact, there are still more types coming. When we get to math formula
processing we will see that a |style_node| has |type=14|; and a number
of larger type codes will also be defined, for use in math mode only.
@y
@ In fact, there are still more types coming. When we get to math formula
processing we will see that a |style_node| has |type=14|; and a number
of larger type codes will also be defined, for use in math mode only.
So this is a good point for inserting definitios of new kinds of ref-type
box.

@p @<Define additional ref-type box@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [11.165] Fix the word `free' so that it doesn't conflict with the
% standard C library routine of the same name.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
been included. (You may want to decrease the size of |mem| while you
@^debugging@>
are debugging.)
@y
been included. (You may want to decrease the size of |mem| while you
@^debugging@>
are debugging.)

@d free==free_arr
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [12.174,176] Eliminate some unsigned comparisons to zero.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%@x
%        begin if (font(p)<font_base)or(font(p)>font_max) then
%          print_char("*")
%@y
%        begin if (font(p)>font_max) then
%          print_char("*")
%@z
%
%@x
%@p procedure print_font_and_char(@!p:integer); {prints |char_node| data}
%begin if p>mem_end then print_esc("CLOBBERED.")
%else  begin if (font(p)<font_base)or(font(p)>font_max) then print_char("*")
%@y
%@p procedure print_font_and_char(@!p:integer); {prints |char_node| data}
%begin if p>mem_end then print_esc("CLOBBERED.")
%else  begin if (font(p)>font_max) then print_char("*")
%@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [12.174,176] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [174] show japanese |char_node| properly on kanji tty
var n:integer; {for replacement counts}
begin while p>mem_min do
  begin if is_char_node(p) then
    begin if p<=mem_end then
      begin if font(p)<>font_in_short_display then
        begin if (font(p)<font_base)or(font(p)>font_max) then
          print_char("*")
@.*\relax@>
        else @<Print the font identifier for |font(p)|@>;
        print_char(" "); font_in_short_display:=font(p);
        end;
      print_ASCII(qo(character(p)));
      end;
    end
  else @<Print a short indication of the contents of node |p|@>;
  p:=link(p);
  end;
end;
@y
var n:integer; {for replacement counts}
jfont_index:s_f_range0; {to hold return value of |j_font_p|}
begin while p>mem_min do
  begin if is_char_node(p) then
    begin if p<=mem_end then
     begin
      jfont_index:=j_font_p(font(p));
      if (jfont_index<>0)
        then print_j_char(jfont_index,qo(character(p)))
      else
      begin
      if font(p)<>font_in_short_display then
        begin if (font(p)>font_max) then
          print_char("*")
@.*\relax@>
        else @<Print the font identifier for |font(p)|@>;
        print_char(" "); font_in_short_display:=font(p);
        end;
      print_ASCII(qo(character(p)));
      end;
     end
    end
  else begin
    @<Print a short indication of the contents of node |p|@>;
    end;
  p:=link(p);
  end;
end;
@z

@x Changes for JTeX: [176] Printing of Japanese character in |show_node_list|
begin if p>mem_end then print_esc("CLOBBERED.")
else  begin if (font(p)<font_base)or(font(p)>font_max) then print_char("*")
@.*\relax@>
  else @<Print the font identifier for |font(p)|@>;
  print_char(" "); print_ASCII(qo(character(p)));
  end;
end;
@y
var jfont_index:s_f_range0; {to hold return value of |j_font_p|}
begin if p>mem_end then print_esc("CLOBBERED.")
else  begin if (font(p)>font_max) then print_char("*")
@.*\relax@>
  else @<Print the font identifier for |font(p)|@>;
  print_char(" "); jfont_index:=j_font_p(font(p));
  if (jfont_index<>0) then
     print_j_char(jfont_index,qo(character(p)))
  else print_ASCII(qo(character(p)));
  end;
end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [12.186] Don't worry about strange floating point values.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
  if glue_sign(p)=shrinking then print("- ");
  if abs(mem[p+glue_offset].int)<@'4000000 then print("?.?")
  else if abs(g)>float_constant(20000) then
@y
  if glue_sign(p)=shrinking then print("- ");
  { The Unix |pc| folks removed this restriction with a remark that
    invalid bit patterns were vanishingly improbable, so we follow
    their example without really understanding it.
  |if abs(mem[p+glue_offset].int)<@'4000000 then print('?.?')|
  |else| }
  if fabs(g)>float_constant(20000) then
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [13.X] delayed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [201]
@p procedure delete_glue_ref(@!p:pointer); {|p| points to a glue specification}
fast_delete_glue_ref(p);
@y
@p procedure delete_glue_ref(@!p:pointer); {|p| points to a glue specification}
fast_delete_glue_ref(p);
@<Destroy additional ref-type box@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [14.X] delayed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [203] Add reference count of additional ref-type box
@d add_token_ref(#)==incr(token_ref_count(#)) {new reference to a token list}
@d add_glue_ref(#)==incr(glue_ref_count(#)) {new reference to a glue spec}
@y
@d add_token_ref(#)==incr(token_ref_count(#)) {new reference to a token list}
@d add_glue_ref(#)==incr(glue_ref_count(#)) {new reference to a glue spec}
@d add_df_ref(#)==incr(df_ref_count(#)) {new reference to a df spec}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [15.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [207] define new char code for jletter but not assignable
@d max_char_code=15 {largest catcode for individual characters}
@y
@d jletter=16 {characters regarded as japanese letters}
@d max_char_code=16 {largest catcode for individual characters}
@z

@x Changes for JTeX: [208] you must shift command code
@d char_num=16 {character specified numerically ( \.{\\char} )}
@d math_char_num=17 {explicit math code ( \.{\\mathchar} )}
@d mark=18 {mark definition ( \.{\\mark} )}
@d xray=19 {peek inside of \TeX\ ( \.{\\show}, \.{\\showbox}, etc.~)}
@d make_box=20 {make a box ( \.{\\box}, \.{\\copy}, \.{\\hbox}, etc.~)}
@d hmove=21 {horizontal motion ( \.{\\moveleft}, \.{\\moveright} )}
@d vmove=22 {vertical motion ( \.{\\raise}, \.{\\lower} )}
@d un_hbox=23 {unglue a box ( \.{\\unhbox}, \.{\\unhcopy} )}
@d un_vbox=24 {unglue a box ( \.{\\unvbox}, \.{\\unvcopy} )}
@d remove_item=25 {nullify last item ( \.{\\unpenalty},
  \.{\\unkern}, \.{\\unskip} )}
@d hskip=26 {horizontal glue ( \.{\\hskip}, \.{\\hfil}, etc.~)}
@d vskip=27 {vertical glue ( \.{\\vskip}, \.{\\vfil}, etc.~)}
@d mskip=28 {math glue ( \.{\\mskip} )}
@d kern=29 {fixed space ( \.{\\kern})}
@d mkern=30 {math kern ( \.{\\mkern} )}
@d leader_ship=31 {use a box ( \.{\\shipout}, \.{\\leaders}, etc.~)}
@d halign=32 {horizontal table alignment ( \.{\\halign} )}
@d valign=33 {vertical table alignment ( \.{\\valign} )}
@d no_align=34 {temporary escape from alignment ( \.{\\noalign} )}
@d vrule=35 {vertical rule ( \.{\\vrule} )}
@d hrule=36 {horizontal rule ( \.{\\hrule} )}
@d insert=37 {vlist inserted in box ( \.{\\insert} )}
@d vadjust=38 {vlist inserted in enclosing paragraph ( \.{\\vadjust} )}
@d ignore_spaces=39 {gobble |spacer| tokens ( \.{\\ignorespaces} )}
@d after_assignment=40 {save till assignment is done ( \.{\\afterassignment} )}
@d after_group=41 {save till group is done ( \.{\\aftergroup} )}
@d break_penalty=42 {additional badness ( \.{\\penalty} )}
@d start_par=43 {begin paragraph ( \.{\\indent}, \.{\\noindent} )}
@d ital_corr=44 {italic correction ( \.{\\/} )}
@d accent=45 {attach accent in text ( \.{\\accent} )}
@d math_accent=46 {attach accent in math ( \.{\\mathaccent} )}
@d discretionary=47 {discretionary texts ( \.{\\-}, \.{\\discretionary} )}
@d eq_no=48 {equation number ( \.{\\eqno}, \.{\\leqno} )}
@d left_right=49 {variable delimiter ( \.{\\left}, \.{\\right} )}
@d math_comp=50 {component of formula ( \.{\\mathbin}, etc.~)}
@d limit_switch=51 {diddle limit conventions ( \.{\\displaylimits}, etc.~)}
@d above=52 {generalized fraction ( \.{\\above}, \.{\\atop}, etc.~)}
@d math_style=53 {style specification ( \.{\\displaystyle}, etc.~)}
@d math_choice=54 {choice specification ( \.{\\mathchoice} )}
@d non_script=55 {conditional math glue ( \.{\\nonscript} )}
@d vcenter=56 {vertically center a vbox ( \.{\\vcenter} )}
@d case_shift=57 {force specific case ( \.{\\lowercase}, \.{\\uppercase}~)}
@d message=58 {send to user ( \.{\\message}, \.{\\errmessage} )}
@d extension=59 {extensions to \TeX\ ( \.{\\write}, \.{\\special}, etc.~)}
@d in_stream=60 {files for reading ( \.{\\openin}, \.{\\closein} )}
@d begin_group=61 {begin local grouping ( \.{\\begingroup} )}
@d end_group=62 {end local grouping ( \.{\\endgroup} )}
@d omit=63 {omit alignment template ( \.{\\omit} )}
@d ex_space=64 {explicit space ( \.{\\\ } )}
@d no_boundary=65 {suppress boundary ligatures ( \.{\\noboundary} )}
@d radical=66 {square root and similar signs ( \.{\\radical} )}
@d end_cs_name=67 {end control sequence ( \.{\\endcsname} )}
@d min_internal=68 {the smallest code that can follow \.{\\the}}
@d char_given=68 {character code defined by \.{\\chardef}}
@d math_given=69 {math code defined by \.{\\mathchardef}}
@d last_item=70 {most recent item ( \.{\\lastpenalty},
  \.{\\lastkern}, \.{\\lastskip} )}
@d max_non_prefixed_command=70 {largest command code that can't be \.{\\global}}
@y
@d char_num=17 {character specified numerically ( \.{\\char} )}
@d math_char_num=18 {explicit math code ( \.{\\mathchar} )}
@d mark=19 {mark definition ( \.{\\mark} )}
@d xray=20 {peek inside of \TeX\ ( \.{\\show}, \.{\\showbox}, etc.~)}
@d make_box=21 {make a box ( \.{\\box}, \.{\\copy}, \.{\\hbox}, etc.~)}
@d hmove=22 {horizontal motion ( \.{\\moveleft}, \.{\\moveright} )}
@d vmove=23 {vertical motion ( \.{\\raise}, \.{\\lower} )}
@d un_hbox=24 {unglue a box ( \.{\\unhbox}, \.{\\unhcopy} )}
@d un_vbox=25 {unglue a box ( \.{\\unvbox}, \.{\\unvcopy} )}
@d remove_item=26 {nullify last item ( \.{\\unpenalty},
  \.{\\unkern}, \.{\\unskip} )}
@d hskip=27 {horizontal glue ( \.{\\hskip}, \.{\\hfil}, etc.~)}
@d vskip=28 {vertical glue ( \.{\\vskip}, \.{\\vfil}, etc.~)}
@d mskip=29 {math glue ( \.{\\mskip} )}
@d kern=30 {fixed space ( \.{\\kern})}
@d mkern=31 {math kern ( \.{\\mkern} )}
@d leader_ship=32 {use a box ( \.{\\shipout}, \.{\\leaders}, etc.~)}
@d halign=33 {horizontal table alignment ( \.{\\halign} )}
@d valign=34 {vertical table alignment ( \.{\\valign} )}
@d no_align=35 {temporary escape from alignment ( \.{\\noalign} )}
@d vrule=36 {vertical rule ( \.{\\vrule} )}
@d hrule=37 {horizontal rule ( \.{\\hrule} )}
@d insert=38 {vlist inserted in box ( \.{\\insert} )}
@d vadjust=39 {vlist inserted in enclosing paragraph ( \.{\\vadjust} )}
@d ignore_spaces=40 {gobble |spacer| tokens ( \.{\\ignorespaces} )}
@d after_assignment=41 {save till assignment is done ( \.{\\afterassignment} )}
@d after_group=42 {save till group is done ( \.{\\aftergroup} )}
@d break_penalty=43 {additional badness ( \.{\\penalty} )}
@d start_par=44 {begin paragraph ( \.{\\indent}, \.{\\noindent} )}
@d ital_corr=45 {italic correction ( \.{\\/} )}
@d accent=46 {attach accent in text ( \.{\\accent} )}
@d math_accent=47 {attach accent in math ( \.{\\mathaccent} )}
@d discretionary=48 {discretionary texts ( \.{\\-}, \.{\\discretionary} )}
@d eq_no=49 {equation number ( \.{\\eqno}, \.{\\leqno} )}
@d left_right=50 {variable delimiter ( \.{\\left}, \.{\\right} )}
@d math_comp=51 {component of formula ( \.{\\mathbin}, etc.~)}
@d limit_switch=52 {diddle limit conventions ( \.{\\displaylimits}, etc.~)}
@d above=53 {generalized fraction ( \.{\\above}, \.{\\atop}, etc.~)}
@d math_style=54 {style specification ( \.{\\displaystyle}, etc.~)}
@d math_choice=55 {choice specification ( \.{\\mathchoice} )}
@d non_script=56 {conditional math glue ( \.{\\nonscript} )}
@d vcenter=57 {vertically center a vbox ( \.{\\vcenter} )}
@d case_shift=58 {force specific case ( \.{\\lowercase}, \.{\\uppercase}~)}
@d message=59 {send to user ( \.{\\message}, \.{\\errmessage} )}
@d extension=60 {extensions to \TeX\ ( \.{\\write}, \.{\\special}, etc.~)}
@d in_stream=61 {files for reading ( \.{\\openin}, \.{\\closein} )}
@d begin_group=62 {begin local grouping ( \.{\\begingroup} )}
@d end_group=63 {end local grouping ( \.{\\endgroup} )}
@d omit=64 {omit alignment template ( \.{\\omit} )}
@d ex_space=65 {explicit space ( \.{\\\ } )}
@d no_boundary=66 {suppress boundary ligatures ( \.{\\noboundary} )}
@d radical=67 {square root and similar signs ( \.{\\radical} )}
@d end_cs_name=68 {end control sequence ( \.{\\endcsname} )}
@d min_internal=68 {the smallest code that can follow \.{\\the}}
@d char_given=69 {character code defined by \.{\\chardef}}
@d math_given=70 {math code defined by \.{\\mathchardef}}
@d last_item=71 {most recent item ( \.{\\lastpenalty},
  \.{\\lastkern}, \.{\\lastskip} )}
@d max_non_prefixed_command=71 {largest command code that can't be \.{\\global}}
@z

@x Changes for JTeX: [209] 
@d toks_register=71 {token list register ( \.{\\toks} )}
@d assign_toks=72 {special token list ( \.{\\output}, \.{\\everypar}, etc.~)}
@d assign_int=73 {user-defined integer ( \.{\\tolerance}, \.{\\day}, etc.~)}
@d assign_dimen=74 {user-defined length ( \.{\\hsize}, etc.~)}
@d assign_glue=75 {user-defined glue ( \.{\\baselineskip}, etc.~)}
@d assign_mu_glue=76 {user-defined muglue ( \.{\\thinmuskip}, etc.~)}
@d assign_font_dimen=77 {user-defined font dimension ( \.{\\fontdimen} )}
@d assign_font_int=78 {user-defined font integer ( \.{\\hyphenchar},
  \.{\\skewchar} )}
@d set_aux=79 {specify state info ( \.{\\spacefactor}, \.{\\prevdepth} )}
@d set_prev_graf=80 {specify state info ( \.{\\prevgraf} )}
@d set_page_dimen=81 {specify state info ( \.{\\pagegoal}, etc.~)}
@d set_page_int=82 {specify state info ( \.{\\deadcycles},
  \.{\\insertpenalties} )}
@d set_box_dimen=83 {change dimension of box ( \.{\\wd}, \.{\\ht}, \.{\\dp} )}
@d set_shape=84 {specify fancy paragraph shape ( \.{\\parshape} )}
@d def_code=85 {define a character code ( \.{\\catcode}, etc.~)}
@d def_family=86 {declare math fonts ( \.{\\textfont}, etc.~)}
@d set_font=87 {set current font ( font identifiers )}
@d def_font=88 {define a font file ( \.{\\font} )}
@d register=89 {internal register ( \.{\\count}, \.{\\dimen}, etc.~)}
@d max_internal=89 {the largest code that can follow \.{\\the}}
@d advance=90 {advance a register or parameter ( \.{\\advance} )}
@d multiply=91 {multiply a register or parameter ( \.{\\multiply} )}
@d divide=92 {divide a register or parameter ( \.{\\divide} )}
@d prefix=93 {qualify a definition ( \.{\\global}, \.{\\long}, \.{\\outer} )}
@d let=94 {assign a command code ( \.{\\let}, \.{\\futurelet} )}
@d shorthand_def=95 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
@d read_to_cs=96 {read into a control sequence ( \.{\\read} )}
@d def=97 {macro definition ( \.{\\def}, \.{\\gdef}, \.{\\xdef}, \.{\\edef} )}
@d set_box=98 {set a box ( \.{\\setbox} )}
@d hyph_data=99 {hyphenation data ( \.{\\hyphenation}, \.{\\patterns} )}
@d set_interaction=100 {define level of interaction ( \.{\\batchmode}, etc.~)}
@d max_command=100 {the largest command code seen at |big_switch|}
@y
@d toks_register=72 {token list register ( \.{\\toks} )}
@d assign_toks=73 {special token list ( \.{\\output}, \.{\\everypar}, etc.~)}
@d assign_int=74 {user-defined integer ( \.{\\tolerance}, \.{\\day}, etc.~)}
@d assign_dimen=75 {user-defined length ( \.{\\hsize}, etc.~)}
@d assign_glue=76 {user-defined glue ( \.{\\baselineskip}, etc.~)}
@d assign_mu_glue=77 {user-defined muglue ( \.{\\thinmuskip}, etc.~)}
@d assign_font_dimen=78 {user-defined font dimension ( \.{\\fontdimen} )}
@d assign_font_int=79 {user-defined font integer ( \.{\\hyphenchar},  \.{\\skewchar} )}
@d set_aux=80 {specify state info ( \.{\\spacefactor}, \.{\\prevdepth} )}
@d set_prev_graf=81 {specify state info ( \.{\\prevgraf} )}
@d set_page_dimen=82 {specify state info ( \.{\\pagegoal}, etc.~)}
@d set_page_int=83 {specify state info ( \.{\\deadcycles},  \.{\\insertpenalties} )}
@d set_box_dimen=84 {change dimension of box ( \.{\\wd}, \.{\\ht}, \.{\\dp} )}
@d set_shape=85 {specify fancy paragraph shape ( \.{\\parshape} )}
@d def_code=86 {define a character code ( \.{\\catcode}, etc.~)}
@d def_family=87 {declare math fonts ( \.{\\textfont}, etc.~)}
@d set_font=88 {set current font ( font identifiers )}
@d def_font=89 {define a font file ( \.{\\font} )}
@d def_dfont=90 {define a on-demmand-load font file ( \.{\\delayedfont} )}
@d def_jfont=91 {define japanese font file ( \.{\\jfont} )}
@d register=92 {internal register ( \.{\\count}, \.{\\dimen}, etc.~)}
@d min_refbox=93 {the smallest code that have the refbox type value}
@d demmand_font=93 {load demmanded font and set current font to it ( font identifiers )}
@d set_jfont=94 {set current japanese font ( font identifiers )}
@d max_internal=94 {the largest code that can follow \.{\\the}}
@d max_refbox=94 {the largest code that have the refbox type value}
@d advance=95 {advance a register or parameter ( \.{\\advance} )}
@d multiply=96 {multiply a register or parameter ( \.{\\multiply} )}
@d divide=97 {divide a register or parameter ( \.{\\divide} )}
@d prefix=98 {qualify a definition ( \.{\\global}, \.{\\long}, \.{\\outer} )}
@d let=99 {assign a command code ( \.{\\let}, \.{\\futurelet} )}
@d shorthand_def=100 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
@d read_to_cs=101 {read into a control sequence ( \.{\\read} )}
@d def=102 {macro definition ( \.{\\def}, \.{\\gdef}, \.{\\xdef}, \.{\\edef} )}
@d set_box=103 {set a box ( \.{\\setbox} )}
@d hyph_data=104 {hyphenation data ( \.{\\hyphenation}, \.{\\patterns} )}
@d set_interaction=105 {define level of interaction ( \.{\\batchmode}, etc.~)}
@d set_kinsoku_code=106 {set Kinsoku table data}
@d set_burasage=107 {set burasage table data}
@d set_jkern=108 {set jkern table data}
@d set_asciipunct=109
@d faker=110
@d max_command=110 {the largest command code seen at |big_switch|}
@z COMMAND END

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [17.222] More fonts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d font_id_base=frozen_null_font-font_base
  {begins table of 257 permanent font identifiers}
@d undefined_control_sequence=frozen_null_font+257 {dummy location}
@y
@d font_id_base=frozen_null_font-font_base
  {begins table of |font_max_limit+1| permanent font identifiers}
@d undefined_control_sequence=frozen_null_font+font_max_limit+1 {dummy location}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [17.X] JTeX: New glue params
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [224] define new skip code for japanese interchar glue
@d glue_pars=18 {total number of glue parameters}
@y
@d j_interchar_skip_code=18 {glue between japanese characters}
@d j_ascii_kanji_skip_code=19 {glue between ascii string and kanji string}
@d j_math_kanji_skip_code=20 {glue between ascii string and kanji string}
@d j_space_skip_code=21 {glue corresponding to JIS space(!!)}
@d def_j_interchar_skip_code=22 {will disappear in the future version}
@d def_j_ascii_kanji_skip_code=23 {will disappear in the future version}
@d def_j_math_kanji_skip_code=24 {will disappear in the future version}
@d def_j_space_skip_code=25 {will disappear in the future version?}
@d glue_pars=26 {total number of glue parameters}
@z

@x Changes for JTeX: [224]
@d thick_mu_skip==glue_par(thick_mu_skip_code)
@y
@d thick_mu_skip==glue_par(thick_mu_skip_code)
@d j_interchar_skip==glue_par(j_interchar_skip_code)
@d j_ascii_kanji_skip==glue_par(j_ascii_kanji_skip_code)
@d j_math_kanji_skip==glue_par(j_math_kanji_skip_code)
@d j_space_skip==glue_par(j_space_skip_code)
@z

@x Changes for JTeX: [225] add new case for print_skip_param
thick_mu_skip_code: print_esc("thickmuskip");
@y
thick_mu_skip_code: print_esc("thickmuskip");
j_interchar_skip_code: print_esc("jintercharskip");
j_ascii_kanji_skip_code: print_esc("jasciikanjiskip");
j_math_kanji_skip_code: print_esc("jmathkanjiskip");
j_space_skip_code: print_esc("jisspaceskip");
def_j_interchar_skip_code: print_esc("@@@@jintercharskip");
def_j_ascii_kanji_skip_code: print_esc("@@@@jasciikanjiskip");
def_j_math_kanji_skip_code: print_esc("@@@@jmathkanjiskip");
def_j_space_skip_code: print_esc("@@@@jisspaceskip");
@z

@x Changes for JTeX: [226] put new skip name into hash table
primitive("thickmuskip",assign_mu_glue,glue_base+thick_mu_skip_code);@/
@!@:thick_mu_skip_}{\.{\\thickmuskip} primitive@>
@y
primitive("thickmuskip",assign_mu_glue,glue_base+thick_mu_skip_code);@/
@!@:thick_mu_skip_}{\.{\\thickmuskip} primitive@>
primitive("jintercharskip",assign_glue,glue_base+j_interchar_skip_code);@/
@!@:j_interchar_skip_}{\.{\\jintercharskip} primitive@>
primitive("jasciikanjiskip",assign_glue,glue_base+j_ascii_kanji_skip_code);@/
@!@:j_ascii_kanji_skip_}{\.{\\jasciikanjiskip} primitive@>
primitive("jmathkanjiskip",assign_glue,glue_base+j_math_kanji_skip_code);@/
@!@:j_math_kanji_skip_}{\.{\\jmathkanjiskip} primitive@>
primitive("jisspaceskip",assign_glue,glue_base+j_space_skip_code);@/
@!@:j_space_skip_}{\.{\\jisspaceskip} primitive@>
primitive("@@@@jintercharskip",assign_glue,glue_base+def_j_interchar_skip_code);@/
@!@:def_j_interchar_skip_}{\.{\\@@@@jintercharskip} primitive@>
primitive("@@@@jasciikanjiskip",assign_glue,glue_base+def_j_ascii_kanji_skip_code);@/
@!@:def_j_ascii_kanji_skip_}{\.{\\@@@@jasciikanjiskip} primitive@>
primitive("@@@@jmathkanjiskip",assign_glue,glue_base+def_j_math_kanji_skip_code);@/
@!@:def_j_math_kanji_skip_}{\.{\\@@@@jmathkanjiskip} primitive@>
primitive("@@@@jisspaceskip",assign_glue,glue_base+def_j_space_skip_code);@/
@!@:def_j_space_skip_}{\.{\\@@@@jisspaceskip} primitive@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [17.X] JTeX: New int params
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [236] new integer param for file and terminal type
@d int_pars=55 {total number of integer parameters}
@y
@d kanji_terminal_type_code=55 {type code for kanji terminal}
@d kanji_file_type_code=56 {type code for kanji file}
@d jendline_type_code=57
@d int_pars=58 {total number of integer parameters}
@z

@x Changes for JTeX: [236] 
@d new_line_char==int_par(new_line_char_code)
@y
@d new_line_char==int_par(new_line_char_code)
@d kanji_terminal_type==int_par(kanji_terminal_type_code)
@d kanji_file_type==int_par(kanji_file_type_code)
@d jendline_type==int_par(jendline_type_code)
@z

@x Changes for JTeX: [237] changes in print routine
new_line_char_code:print_esc("newlinechar");
@y
new_line_char_code:print_esc("newlinechar");
kanji_terminal_type_code:print_esc("kanjiterminaltype");
kanji_file_type_code:print_esc("kanjifiletype");
jendline_type_code:print_esc("jendlinetype");
@z

@x Changes for JTeX: [238] enter them into a hash table
primitive("newlinechar",assign_int,int_base+new_line_char_code);@/
@!@:new_line_char_}{\.{\\newlinechar} primitive@>
@y
primitive("newlinechar",assign_int,int_base+new_line_char_code);@/
@!@:new_line_char_}{\.{\\newlinechar} primitive@>
primitive("kanjiterminaltype",assign_int,int_base+kanji_terminal_type_code);@/
@!@:kanji_terminal_type_}{\.{\\kanjiterminaltype} primitive@>
primitive("kanjifiletype",assign_int,int_base+kanji_file_type_code);@/
@!@:kanji_file_type_}{\.{\\kanjifiletype} primitive@>
primitive("jendlinetype",assign_int,int_base+jendline_type_code);@/
@!@:jendline_type_}{\.{\\jendlinetype} primitive@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [17.241] Do `fix_date_and_time' in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ The following procedure, which is called just before \TeX\ initializes its
input and output, establishes the initial values of the date and time.
@^system dependencies@>
Since standard \PASCAL\ cannot provide such information, something special
is needed. The program here simply specifies July 4, 1776, at noon; but
users probably want a better approximation to the truth.

@p procedure fix_date_and_time;
begin time:=12*60; {minutes since midnight}
day:=4; {fourth day of the month}
month:=7; {seventh month of the year}
year:=1776; {Anno Domini}
end;
@y
@ The following procedure, which is called just before \TeX\ initializes its
input and output, establishes the initial values of the date and time.
It calls a macro-defined |date_and_time| routine.  |date_and_time|
in turn is a C macro, which calls |get_date_and_time|, passing
it the addresses of the day, month, etc., so they can be set by the
routine.  |get_date_and_time| also sets up interrupt catching if that
is conditionally compiled in the C code.
@^system dependencies@>

@d fix_date_and_time==date_and_time(time,day,month,year)
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [17.253] Change eqtb to zeqtb.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!eqtb:array[active_base..eqtb_size] of memory_word;
@y
@!zeqtb:array[active_base..eqtb_size] of memory_word;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [18.262] Remove more unsigned comparisons to zero.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
else if (text(p)<0)or(text(p)>=str_ptr) then print_esc("NONEXISTENT.")
@y
else if (text(p)>=str_ptr) then print_esc("NONEXISTENT.")
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [19.X] delayed, JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [275]
box_ref: flush_node_list(equiv_field(w));
othercases do_nothing
@y
box_ref: flush_node_list(equiv_field(w));
@<Cases of |eq_destroy| for additional ref-type box in |equiv_field|@>
othercases do_nothing
@z

@x [279]
Global definitions are done in almost the same way, but there is no need
to save old values, and the new value is associated with |level_one|.
@y
Global definitions are done in almost the same way, but there is no need
to save old values, and the new value is associated with |level_one|.
We also introduce destructive definition |deq_define|.
@z

@x [279]
procedure geq_word_define(@!p:pointer;@!w:integer); {global |eq_word_define|}
begin eqtb[p].int:=w; xeq_level[p]:=level_one;
end;
@y
procedure geq_word_define(@!p:pointer;@!w:integer); {global |eq_word_define|}
begin eqtb[p].int:=w; xeq_level[p]:=level_one;
end;
@#
procedure deq_define(@!p:pointer;@!t:quarterword;@!e:halfword);
begin eq_destroy(eqtb[p]);
eq_type(p):=t; equiv(p):=e;
end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [20.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [289] new token flag for japanese character
The following definitions take care of these token-oriented constants
and a few others.

@y
The following definitions take care of these token-oriented constants
and a few others.

To represent a japanese character in a token list new token flag is introduced.
The value of this |j_letter-token| is set to $2^{14}$ so that you can accomodate
$2^8f+c$ (where $1\le f\le 33$ and $0\le c\le 255$) into a halfword without
interferring other tokens.  Verify this by the following:
\item{} $2^8m+c$ (where $1\le m\le 14$, $0\le c\le 255$) ranges from 256 to 3839
\item{} $2^{12}+p$ (where $0\le p\le |undefined_control_sequence|$)
ranges from 4096 to $4096+258+|hash_size|+267$
\item{} $2^{14}+2^8f+c$ (where $1\le f\le 33$, $0\le c\le 255$) ranges from 16640
to 25087 (which is less than $2^{16}$)

@d j_letter_token_flag==@'40000 {amount added to packed jletter ($2^8f+c$)}
@d jchr_cons_end(#)==(#)
@d jchr_cons(#)==(#)*256+jchr_cons_end
@d jchr_subfont(#)==((#) div 256)
@d jchr_char(#)==((#) mod 256)
@z

@x Changes for JTeX: [290]
@ @<Check the ``constant''...@>=
if cs_token_flag+undefined_control_sequence>max_halfword then bad:=21;
@y
@ @<Check the ``constant''...@>=
if cs_token_flag+undefined_control_sequence>=j_letter_token_flag then bad:=21;
@z

@x Changes for JTeX: [292] add a variable to be used in Japanese output
var m,@!c:integer; {pieces of a token}
@!match_chr:ASCII_code; {character used in a `|match|'}
@!n:ASCII_code; {the highest parameter number, as an ASCII digit}
@y
var m,@!c:integer; {pieces of a token}
@!match_chr:ASCII_code; {character used in a `|match|'}
@!n:ASCII_code; {the highest parameter number, as an ASCII digit}
@!ku_ten:integer; {to hold ku*256+ten}
@z

@x Changes for JTeX: [292]
begin match_chr:="#"; n:="0"; tally:=0;
while (p<>null) and (tally<l) do
  begin if p=q then @<Do magic computation@>;
@y
begin match_chr:="#"; n:="0"; tally:=0; tally_disp:=0;
while (p<>null) and (tally<l) do
  begin if p=q then @<Do magic computation@>;
@z

@x Changes for JTeX: [293] insert printing of japanese letter token
@ @<Display token |p|...@>=
if (p<hi_mem_min) or (p>mem_end) then
  begin print_esc("CLOBBERED."); return;
@.CLOBBERED@>
  end;
if info(p)>=cs_token_flag then print_cs(info(p)-cs_token_flag)
@y
@ @<Display token |p|...@>=
if (p<hi_mem_min) or (p>mem_end) then
  begin print_esc("CLOBBERED."); return;
@.CLOBBERED@>
  end;
if info(p)>=j_letter_token_flag then
  begin m:=jchr_subfont(info(p) mod j_letter_token_flag);
        c:=jchr_char(info(p) mod j_letter_token_flag);
        @<Display japanese letter $(|m|,|c|)$@>; end
else if info(p)>=cs_token_flag then print_cs(info(p)-cs_token_flag)
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [21.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [298] new cases for |print_cmd_chr|
other_char: chr_cmd("the character ");
@y
other_char: chr_cmd("the character ");
jletter: begin print("japanese letter ");
  print_j_char(jchr_subfont(chr_code mod j_letter_token_flag),
               jchr_char(chr_code mod j_letter_token_flag));
  print_char("(");
  print_esc(font_id_text(equiv(j_s_font_pointer
                                 [jchr_subfont(chr_code mod j_letter_token_flag)])));
  print_esc("char"); print_int(jchr_char(chr_code mod j_letter_token_flag));
  print_char(")"); end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [22.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [312]
  begin tally:=0; {get ready to count characters}
  old_setting:=selector;
@y
  begin tally:=0; tally_disp:=0; {get ready to count characters}
  old_setting:=selector;
@z

@x Changes for JTeX: [315]
@!p: integer; {starting or ending place in |trick_buf|}
@!q: integer; {temporary index}
@y
@!p: integer; {starting or ending place in |trick_buf|}
@!q,r: integer; {temporary index}
@z

@x Changes for JTeX: [316]
@d set_trick_count==
  begin first_count:=tally;
  trick_count:=tally+1+error_line-half_error_line;
  if trick_count<error_line then trick_count:=error_line;
  end
@y
@d set_trick_count==
  begin first_count:=tally; first_count_disp:=tally_disp;
  trick_count:=tally_disp+1+error_line-half_error_line;
  if trick_count<error_line then trick_count:=error_line;
  end
@z

@x Changes for JTeX: [317]
if tally<trick_count then m:=tally-first_count
else m:=trick_count-first_count; {context on line 2}
if l+first_count<=half_error_line then
  begin p:=0; n:=l+first_count;
  end
else  begin print("..."); p:=l+first_count-half_error_line+3;
  n:=half_error_line;
  end;
for q:=p to first_count-1 do print_char(trick_buf[q mod error_line]);
print_ln;
for q:=1 to n do print_char(" "); {print |n| spaces to begin line~2}
if m+n<=error_line then p:=first_count+m else p:=first_count+(error_line-n-3);
for q:=first_count to p-1 do print_char(trick_buf[q mod error_line]);
if m+n>error_line then print("...")
@y
if tally_disp<trick_count then m:=tally_disp-first_count_disp
else m:=trick_count-first_count_disp; {context on line 2}
{l=displayed length of chars before first_count}
if l+first_count_disp<=half_error_line then
  begin n:=l+first_count_disp; r:=n-l;
  end
else  begin print("...");
  n:=half_error_line; r:=n-3-l;
  end;
@<Print the first line of tricky pseudoprint@>;
print_ln;
for q:=1 to r do print_char(" "); {print |n| or |n-1| spaces to begin line~2}
if m+n<=error_line then r:=m else r:=error_line-n-3;
@<Print the second line of tricky pseudoprint@>;
if m+n>error_line then print("...")
@z

@x Changes for JTeX: [318]
@<Pseudoprint the line@>=
begin_pseudoprint;
if buffer[limit]=end_line_char then j:=limit
else j:=limit+1; {determine the effective end of the line}
if j>0 then for i:=start to j-1 do
  begin if i=loc then set_trick_count;
  print(buffer[i]);
  end
@y
@<Pseudoprint the line@>=
begin_pseudoprint; @<Reset |pseudo_kanji_stat|@>;
@<Determin the effective end of the line@>;
if j>0 then @<Pseudo print chars in |buffer| in printable form@>
@z

@x Changes for JTeX: [319]
@ @<Pseudoprint the token list@>=
begin_pseudoprint;
@y
@ @<Pseudoprint the token list@>=
begin_pseudoprint; @<Reset |pseudo_kanji_stat|@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [24.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [341] procedure get_next
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!cat:0..15; {|cat_code(cur_chr)|, usually}
@!c,@!cc:ASCII_code; {constituents of a possible expanded code}
@!d:2..3; {number of excess characters in an expanded code}
@y
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!cat:escape..max_char_code; {|cat_code(cur_chr)|, usually}
@!c,@!cc:ASCII_code; {constituents of a possible expanded code}
@!d:2..3; {number of excess characters in an expanded code}
@!same_chr:boolean;
@!e:0..1; {shift for eightbit sup_mark}
@!jletter_endline:boolean; {true when a line ends with jletter}
@z

@x Changes for JTeX: [343] process delayed cat_ret
begin switch: if loc<=limit then {current line not yet finished}
  begin cur_chr:=buffer[loc]; incr(loc);
  reswitch: cur_cmd:=cat_code(cur_chr);
@y
begin switch: if loc<=limit then {current line not yet finished}
  begin cur_chr:=buffer[loc]; incr(loc);
    @<Read an extended char and reset |cur_cmd| and |cur_chr| appropriately@>;
    @<Restore delayed |cat_ret| and return, if appropriate@>;
  reswitch:
@z

@x Changes for JTeX: [347] ignore or delay |car_ret|
mid_line+car_ret:@<Finish line, emit a space@>;
@y
mid_line+car_ret:@<Check if the last character of the line is japanese,
  change state, and finish line@>;
@z

@x Changes for JTeX: [352]
begin if cur_chr=buffer[loc] then if loc<limit then
  begin c:=buffer[loc+1]; @+if c<@'200 then {yes we have an expanded char}
    begin loc:=loc+2; 
    if is_hex(c) then if loc<=limit then
      begin cc:=buffer[loc]; @+if is_hex(cc) then
        begin incr(loc); hex_to_cur_chr; goto reswitch;
        end;
      end;
    if c<@'100 then cur_chr:=c+@'100 @+else cur_chr:=c-@'100;
    goto reswitch;
@y
begin if (not is_ext_char(buffer[loc]) and (buffer[loc]=cur_chr)) then begin
  same_chr:=true; e:=0;
  end
else if (is_ext_eightbit(buffer[loc]) and
         (make_eightbit(buffer[loc+1])=cur_chr)) then begin
  same_chr:=true; e:=1;
  end
else same_chr:=false;
if same_chr then if loc+e<limit then
  begin c:=buffer[loc+e+1]; @+if c<@'200 then {yes we have an expanded char}
    begin loc:=loc+e+2; 
    if is_hex(c) then if loc<=limit then
      begin cc:=buffer[loc]; @+if is_hex(cc) then
        begin incr(loc); hex_to_cur_chr;
          cur_cmd:=cat_code(cur_chr); goto reswitch;
        end;
      end;
    if c<@'100 then cur_chr:=c+@'100 @+else cur_chr:=c-@'100;
    cur_cmd:=cat_code(cur_chr); goto reswitch;
@z

@x Changes for JTeX: [354] allow japanese letters in control sequence name
else  begin start_cs: k:=loc; cur_chr:=buffer[k]; cat:=cat_code(cur_chr);
  incr(k);
  if cat=letter then state:=skip_blanks
  else if cat=spacer then state:=skip_blanks
  else state:=mid_line;
  if (cat=letter)and(k<=limit) then
@y
else  begin start_cs: k:=loc; cur_chr:=buffer[k];
  @<Check an extended char in control sequence name@>;
  if cat=jletter then repos_char(k)
  else incr(k);
  if (cat=letter) or (cat=jletter) then state:=skip_blanks
  else if cat=spacer then state:=skip_blanks
  else state:=mid_line;
  if ((cat=letter) or (cat=jletter)) and (k<=limit) then
@z

@x 8bit: [354]
  cur_cs:=single_base+buffer[loc]; incr(loc);
@y
  if is_ext_eightbit(buffer[loc]) then begin incr(loc);
    cur_cs:=single_base+make_eightbit(buffer[loc]);
    end
  else
    cur_cs:=single_base+buffer[loc];
  incr(loc);
@z

@x 8bit: [355]
begin if buffer[k]=cur_chr then @+if cat=sup_mark then @+if k<limit then
  begin c:=buffer[k+1]; @+if c<@'200 then {yes, one is indeed present}
    begin d:=2;
    if is_hex(c) then @+if k+2<=limit then
      begin cc:=buffer[k+2]; @+if is_hex(cc) then incr(d);
      end;
    if d>2 then
      begin hex_to_cur_chr; buffer[k-1]:=cur_chr;
      end
    else if c<@'100 then buffer[k-1]:=c+@'100
    else buffer[k-1]:=c-@'100;
@y
begin if (not is_ext_char(buffer[k]) and (buffer[k]=cur_chr)) then begin
  same_chr:=true; e:=0;
  end
else if (is_ext_eightbit(buffer[k]) and
         (make_eightbit(buffer[k+1])=cur_chr)) then begin
  same_chr:=true; e:=1;
  end
else same_chr:=false;
if same_chr then @+if cat=sup_mark then @+if k+e<limit then
  begin c:=buffer[k+e+1]; @+if c<@'200 then {yes, one is indeed present}
    begin d:=2;
    if is_hex(c) then @+if k+e+2<=limit then
      begin cc:=buffer[k+e+2]; @+if is_hex(cc) then incr(d);
      end;
    if d>2 then
      begin hex_to_cur_chr; buffer[k-e-1]:=cur_chr;
      end
    else if c<@'100 then buffer[k-e-1]:=c+@'100
    else buffer[k-e-1]:=c-@'100;
    if is_eightbit(buffer[k-e-1]) then begin
      buffer[k-e]:=de_eightbit(buffer[k-e-1]);
      buffer[k-e-1]:=ext_eightbit;
      incr(k); decr(d);
      end;
    k:=k-e;
@z

@x Changes for JTeX: [356] allow japanese letters in control sequence name
begin repeat cur_chr:=buffer[k]; cat:=cat_code(cur_chr); incr(k);
until (cat<>letter)or(k>limit);
@<If an expanded...@>;
if cat<>letter then decr(k);
@y
begin repeat cur_chr:=buffer[k];
 @<Check an extended char in control sequence name@>;
 incr(k);
until ((cat<>letter) and (cat<>jletter)) or (k>limit);
@<If an expanded...@>;
if (cat<>letter) and (cat<>jletter) then backward_onechar(k);
@z

@x Changes for JTeX: [357] you must count for japanese letter token
  begin t:=info(loc); loc:=link(loc); {move to next}
  if t>=cs_token_flag then {a control sequence token}
@y
  begin t:=info(loc); loc:=link(loc); {move to next}
  if t>=j_letter_token_flag then begin
        cur_cmd:=jletter; cur_chr:=t mod j_letter_token_flag end
  else if t>=cs_token_flag then {a control sequence token}
@z

@x Changes for JTeX: [360]
else  begin if not terminal_input then {\.{\\read} line has ended}
    begin cur_cmd:=0; cur_chr:=0; return;
    end;
@y
else  begin
    if delayed_cat_ret then
      @<Emit a space, |delayed_cat_ret:=false|, and return@>;
    if not terminal_input then {\.{\\read} line has ended}
    begin cur_cmd:=0; cur_chr:=0; return;
    end;
@z

@x 8bit: [360]
    if end_line_char_inactive then decr(limit)
    else  buffer[limit]:=end_line_char;
@y
    @<Put the the end-of-line-char if it is active@>;
@z

@x Changes for JTeX: [362]
if not force_eof then
  begin if input_ln(cur_file,true) then {not end of file}
    firm_up_the_line {this sets |limit|}
  else force_eof:=true;
  end;
@y
if not force_eof then
  begin if input_ln(cur_file,true) then {not end of file}
    firm_up_the_line {this sets |limit|}
  else if delayed_cat_ret {and (scanner_status=matching)} then begin
    decr(line); loc:=limit+1;
    @<Emit a space, |delayed_cat_ret:=false|, and return@>;
    end
  else force_eof:=true;
  end;
@z

@x 8bit: [362]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the the end-of-line-char if it is active@>;
@z

@x Changes for JTeX: [365] modify the computation of |cur_tok|
begin no_new_control_sequence:=false; get_next; no_new_control_sequence:=true;
@^inner loop@>
if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
begin no_new_control_sequence:=false; get_next; no_new_control_sequence:=true;
@^inner loop@>
if cur_cs=0 then begin
  if (cur_cmd=jletter)
    then cur_tok:=j_letter_token_flag+cur_chr
  else cur_tok:=(cur_cmd*@'400)+cur_chr end
else cur_tok:=cs_token_flag+cur_cs;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [25.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [366] variable declarations for [374]
var t:halfword; {token that is being ``expanded after''}
@!p,@!q,@!r:pointer; {for list manipulation}
@!j:0..buf_size; {index into |buffer|}
@y
var t:halfword; {token that is being ``expanded after''}
@!p,@!q,@!r:pointer; {for list manipulation}
@!j:0..buf_size; {index into |buffer|}
@!fc:halfword;
@!ku_ten:halfword;
@z

@x Changes for JTeX, 8bit: [374] take into account japanese letter csname
while p<>null do
  begin if j>=max_buf_stack then
    begin max_buf_stack:=j+1;
    if max_buf_stack=buf_size then
      overflow("buffer size",buf_size);
@:TeX capacity exceeded buffer size}{\quad buffer size@>
    end;
  buffer[j]:=info(p) mod @'400; incr(j); p:=link(p);
  end;
@y
while p<>null do
  begin if j+1>=max_buf_stack then
    begin max_buf_stack:=j+2;
    if max_buf_stack=buf_size then
      overflow("buffer size",buf_size);
@:TeX capacity exceeded buffer size}{\quad buffer size@>
    end;
  if info(p)>=j_letter_token_flag then begin
    fc:=info(p) mod j_letter_token_flag;
    @<Put the internal representation of |fc| in |buffer|@>;
    end
  else begin
    buffer[j]:=info(p) mod @'400;
    @<Put the internal representation of char in |buffer|@>;
    end;
  incr(j); p:=link(p);
  end;
@z

@x Changes for JTeX: [380] take into account japanese letter token
done: if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
done: if cur_cs=0 then begin
  if (cur_cmd=jletter)
    then cur_tok:=j_letter_token_flag+cur_chr
  else cur_tok:=(cur_cmd*@'400)+cur_chr end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x Changes for JTeX: [381] take into account japanese letter token
  begin expand;
  get_next;
  end;
if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
  begin expand;
  get_next;
  end;
if cur_cs=0 then begin
  if (cur_cmd=jletter)
    then cur_tok:=j_letter_token_flag+cur_chr
  else cur_tok:=(cur_cmd*@'400)+cur_chr end
else cur_tok:=cs_token_flag+cur_cs;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [26.X] delayed, JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [413]
toks_register,assign_toks,def_family,set_font,def_font: @<Fetch a token list or
  font identifier, provided that |level=tok_val|@>;
@y
toks_register,assign_toks,def_family,set_font,def_font,def_dfont:
  @<Fetch a token list or font identifier, provided that |level=tok_val|@>;
demmand_font: scanned_result(cur_cs)(ident_val);
@z

@x Changes for JTeX: [440]
@!OK_so_far:boolean; {has an error message been issued?}
@y
@!OK_so_far:boolean; {has an error message been issued?}
@!jletter_const:boolean;
@z

@x Changes for JTeX: [442] allow Japanese after `
begin get_token; {suppress macro expansion}
if cur_tok<cs_token_flag then
  begin cur_val:=cur_chr;
  if cur_cmd<=right_brace then
    if cur_cmd=right_brace then incr(align_state)
    else decr(align_state);
  end
else if cur_tok<cs_token_flag+single_base then
  cur_val:=cur_tok-cs_token_flag-active_base
else cur_val:=cur_tok-cs_token_flag-single_base;
if cur_val>255 then
  begin print_err("Improper alphabetic constant");
@.Improper alphabetic constant@>
  help2("A one-character control sequence belongs after a ` mark.")@/
    ("So I'm essentially inserting \0 here.");
  cur_val:="0"; back_error;
  end
else @<Scan an optional space@>;
end
@y
begin get_token; {suppress macro expansion}
jletter_const:=false;
if cur_tok>=j_letter_token_flag then begin
  cur_val:= cur_chr;
  jletter_const:=true
  end
else if cur_tok<cs_token_flag then
  begin cur_val:=cur_chr;
  if cur_cmd<=right_brace then
    if cur_cmd=right_brace then incr(align_state)
    else decr(align_state);
  end
else if cur_tok<cs_token_flag+single_base then
  cur_val:=cur_tok-cs_token_flag-active_base
else cur_val:=cur_tok-cs_token_flag-single_base;
if (not jletter_const) and (cur_val>255) then
  begin print_err("Improper alphabetic or japanese constant");
@.Improper alphabetic or japanese constant@>
  help2("A one-character control sequence belongs after a ` mark.")@/
    ("So I'm essentially inserting \0 here.");
  cur_val:="0"; back_error;
  end
else @<Scan an optional space@>;
end
@z

@x Changes for JTeX: [455] zw, zh
if scan_keyword("em") then v:=(@<The em width for |cur_font|@>)
@.em@>
else if scan_keyword("ex") then v:=(@<The x-height for |cur_font|@>)
@.ex@>
@y
if scan_keyword("em") then v:=(@<The em width for |cur_font|@>)
@.em@>
else if scan_keyword("ex") then v:=(@<The x-height for |cur_font|@>)
@.ex@>
else if scan_keyword("zw") then v:=(@<The zw width for current jfont@>)
@.zw@>
else if scan_keyword("zh") then v:=(@<The zh height for current jfont@>)
@.zh@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [27.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [464] convert japanese string into a token list
  if t=" " then t:=space_token
  else t:=other_token+t;
@y
  @<get token of a char from |str_pool|@>;
@z

@x Changes for JTeX: [468] number returning primitives for JTeX
@d job_name_code=5 {command code for \.{\\jobname}}

@<Put each...@>=
primitive("number",convert,number_code);@/
@!@:number_}{\.{\\number} primitive@>
primitive("romannumeral",convert,roman_numeral_code);@/
@!@:roman_numeral_}{\.{\\romannumeral} primitive@>
primitive("string",convert,string_code);@/
@!@:string_}{\.{\\string} primitive@>
primitive("meaning",convert,meaning_code);@/
@!@:meaning_}{\.{\\meaning} primitive@>
primitive("fontname",convert,font_name_code);@/
@!@:font_name_}{\.{\\fontname} primitive@>
primitive("jobname",convert,job_name_code);@/
@!@:job_name_}{\.{\\jobname} primitive@>
@y
@d job_name_code=5 {command code for \.{\\jobname}}
@d j_internal_code_code=6 {command code for \.{\\jinternalcode}}
@d j_subfont_num_code=7 {command code for \.{\\jsubfontnum}}
@d j_char_num_code=8 {command code for \.{\\jcharnum}}
@d jis_code_code=9 {command code for \.{\\jiscode}}
@d jis_ku_code=10 {command code for \.{\\jisku}}
@d jis_ten_code=11 {command code for \.{\\jisten}}

@<Put each...@>=
primitive("number",convert,number_code);@/
@!@:number_}{\.{\\number} primitive@>
primitive("romannumeral",convert,roman_numeral_code);@/
@!@:roman_numeral_}{\.{\\romannumeral} primitive@>
primitive("string",convert,string_code);@/
@!@:string_}{\.{\\string} primitive@>
primitive("meaning",convert,meaning_code);@/
@!@:meaning_}{\.{\\meaning} primitive@>
primitive("fontname",convert,font_name_code);@/
@!@:font_name_}{\.{\\fontname} primitive@>
primitive("jobname",convert,job_name_code);@/
@!@:job_name_}{\.{\\jobname} primitive@>
primitive("jinternalcode",convert,j_internal_code_code);@/
@!@:j_internal_code_}{\.{\\jinternalcode} primitive@>
primitive("jsubfontnum",convert,j_subfont_num_code);@/
@!@:j_subfont_num_}{\.{\\jsubfontnum} primitive@>
primitive("jcharnum",convert,j_char_num_code);@/
@!@:j_char_num_}{\.{\\jcharnum} primitive@>
primitive("jiscode",convert,jis_code_code);@/
@!@:jis_code_}{\.{\\jiscode} primitive@>
primitive("jisku",convert,jis_ku_code);@/
@!@:jis_ku_}{\.{\\jisku} primitive@>
primitive("jisten",convert,jis_ten_code);@/
@!@:jis_ten_}{\.{\\jisten} primitive@>
@z

@x Changes for JTeX: [469] print routine
  othercases print_esc("jobname")
@y
  job_name_code: print_esc("jobname");
  j_internal_code_code: print_esc("jinternalcode");
  j_subfont_num_code: print_esc("jsubfontnum");
  j_char_num_code: print_esc("jcharnum");
  jis_code_code: print_esc("jiscode");
  jis_ku_code: print_esc("jisku");
  jis_ten_code: print_esc("jisten");
  othercases print_esc("unknown")
@z

@x Changes for JTeX: [470] variable range change
@!c:number_code..job_name_code; {desired type of conversion}
@y
@!c:number_code..jis_ten_code; {desired type of conversion}
@z

@x Changes for JTeX: [471] new addition to cases
number_code,roman_numeral_code: scan_int;
@y
number_code,roman_numeral_code,j_internal_code_code,
j_subfont_num_code,j_char_num_code,
jis_code_code,jis_ku_code,jis_ten_code: scan_int;
@z

@x Changes for JTeX: [472] \string may be followed by a japanese letter
string_code:if cur_cs<>0 then sprint_cs(cur_cs)
  else print_char(cur_chr);
@y
string_code:if cur_cs<>0 then sprint_cs(cur_cs)
  else if cur_cmd=jletter then
    print_j_char(jchr_subfont(cur_chr mod j_letter_token_flag),
                 jchr_char(cur_chr mod j_letter_token_flag))
  else print_char(cur_chr);
@z

@x Changes for JTeX: [472] result of added command
job_name_code: print(job_name);
@y
job_name_code: print(job_name);
j_internal_code_code: print_int(cur_val);
j_subfont_num_code: print_int(jchr_subfont(cur_val));
j_char_num_code: print_int(jchr_char(cur_val));
jis_code_code:
  print_int(ku_ten_compute(jchr_subfont(cur_val),jchr_char(cur_val)));
jis_ku_code:
  print_int(ku_ten_compute(jchr_subfont(cur_val),jchr_char(cur_val)) div 256);
jis_ten_code:
  print_int(ku_ten_compute(jchr_subfont(cur_val),jchr_char(cur_val)) mod 256);
@z

@x 8bit: [483]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the the end-of-line-char if it is active@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [28.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [506] make \ifcat & \if work for kanji(added on 28-Jan-88)
if (cur_cmd>active_char)or(cur_chr>255) then {not a character}
  begin m:=relax; n:=256;
  end
else  begin m:=cur_cmd; n:=cur_chr;
  end;
get_x_token_or_active_char;
if (cur_cmd>active_char)or(cur_chr>255) then
  begin cur_cmd:=relax; cur_chr:=256;
  end;
@y
if (cur_cmd<>jletter)and((cur_cmd>active_char)or(cur_chr>255)) then
  begin m:=relax; n:=256;
  end
else  begin m:=cur_cmd; n:=cur_chr;
  end;
get_x_token_or_active_char;
if (cur_cmd<>jletter)and((cur_cmd>active_char)or(cur_chr>255)) then
  begin cur_cmd:=relax; cur_chr:=256;
  end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.513] Area and extension rules for filenames.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ The file names we shall deal with for illustrative purposes have the
following structure:  If the name contains `\.>' or `\.:', the file area
consists of all characters up to and including the final such character;
otherwise the file area is null.  If the remaining file name contains
`\..', the file extension consists of all such characters from the first
remaining `\..' to the end, otherwise the file extension is null.
@^system dependencies@>

We can scan such file names easily by using two global variables that keep track
of the occurrences of area and extension delimiters:

@<Glob...@>=
@!area_delimiter:pool_pointer; {the most recent `\.>' or `\.:', if any}
@!ext_delimiter:pool_pointer; {the relevant `\..', if any}
@y
@ The file names we shall deal with for illustrative purposes have the
following structure:  If the name contains `\./', the file area
consists of all characters up to and including the final such character;
otherwise the file area is null.  If the remaining file name contains
`\..', the file extension consists of all such characters from the last
`\..' to the end, otherwise the file extension is null.
@^system dependencies@>

We can scan such file names easily by using two global variables that keep
track of the occurrences of area and extension delimiters:

@<Glob...@>=
@!area_delimiter:pool_pointer; {the most recent `\./', if any}
@!ext_delimiter:pool_pointer; {the most recent `\..', if any}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.514] TeX area directories.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d TEX_area=="TeXinputs:"
@.TeXinputs@>
@d TEX_font_area=="TeXfonts:"
@.TeXfonts@>
@y
In C, the default paths are specified in a separate
file, \.{site.h}.  The file opening procedures do path searching
based either on those default paths, or on paths given by the user
in environment variables.
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.516] more_name
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
else  begin str_room(1); append_char(c); {contribute |c| to the current string}
  if (c=">")or(c=":") then
    begin area_delimiter:=cur_length; ext_delimiter:=0;
    end
  else if (c=".")and(ext_delimiter=0) then ext_delimiter:=cur_length;
@y
else  begin str_room(1); append_char(c); {contribute |c| to the current string}
  if (c="/") then
    begin area_delimiter:=cur_length; ext_delimiter:=0;
    end
  else if c="." then ext_delimiter:=cur_length;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.519] In pack_file_name, leave room for the extra null we append at
% the end of a filename in make_c_string.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if k<=file_name_size then name_length:=k@+else name_length:=file_name_size;
@y
if k<file_name_size then name_length:=k@+else name_length:=file_name_size-1;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.520] The default format.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d format_default_length=20 {length of the |TEX_format_default| string}
@d format_area_length=11 {length of its area part}
@d format_ext_length=4 {length of its `\.{.fmt}' part}
@y
Under {\mc UNIX} we don't give the area part, instead depending
on the path searching that will happen during file opening.  Also, the
length will be set in the main program.

@d format_area_length=0 {length of its area part}
@d format_ext_length=4 {length of its `\.{.fmt}' part}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.521] Where `plain.fmt' is.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!TEX_format_default:packed array[1..format_default_length] of char;

@ @<Set init...@>=
TEX_format_default:='TeXformats:plain.fmt';
@y
@!format_default_length: integer;
@!TEX_format_default: c_char_pointer;

@ We set the name of the default format file and the length of that name
in C, instead of Pascal, since we want them to depend on the name of the
program.
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.523] Change to pack_buffered_name as with pack_file_name.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if k<=file_name_size then name_length:=k@+else name_length:=file_name_size;
@y
if k<file_name_size then name_length:=k@+else name_length:=file_name_size-1;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.524] Format file opening: only try once, with path searching.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
  pack_buffered_name(0,loc,j-1); {try first without the system file area}
  if w_open_in(fmt_file) then goto found;
  pack_buffered_name(format_area_length,loc,j-1);
    {now try the system format file area}
  if w_open_in(fmt_file) then goto found;
@y
  pack_buffered_name(0,loc,j-1);
  if w_open_in(fmt_file) then goto found;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (still [29.524]) replace `PLAIN' in error messages with `default'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
  wterm_ln('Sorry, I can''t find that format;',' will try PLAIN.');
@y
  wterm_ln('Sorry, I can''t find that format;',' will try the default.');
@z
@x
  wterm_ln('I can''t find the PLAIN format file!');
@.I can't find PLAIN...@>
@y
  wterm_ln('I can''t find the default format file!');
@.I can't find default format...@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.526] JTeX: filename and jendlinetype
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [526]
@p procedure scan_file_name;
label done;
begin name_in_progress:=true; begin_name;
@y
@p procedure scan_file_name;
label done;
var save_jendline_type:integer;
begin name_in_progress:=true;
save_jendlinetype:=jendline_type; jendline_type:=jend_ascii;
begin_name;
@z
@x Changes for JTeX: [526]
done: end_name; name_in_progress:=false;
@y
done: end_name; name_in_progress:=false; jendline_type:=save_jendline_type;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.532] `logname' is declared in <unistd.h> on some systems.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
ship out a box of stuff, we shall use the macro |ensure_dvi_open|.
@y
ship out a box of stuff, we shall use the macro |ensure_dvi_open|.

@d log_name == texmf_log_name
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.536] Adjust for C string conventions.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!months:packed array [1..36] of char; {abbreviations of month names}
@y
@!months:c_char_pointer;
@z

@x JTeX: [534]
while not a_open_out(log_file) do @<Try to get a different log file name@>;
log_name:=a_make_name_string(log_file);
@y
while not a_open_out(log_file) do @<Try to get a different log file name@>;
log_name:=a_make_name_string(log_file);
@<Set kanji log type@>;
@z

@x 8bit: [534]
if buffer[l]=end_line_char then decr(l);
@y
@<Remove the end-of-line-char@>;
@z

@x [536]
begin wlog(banner);
slow_print(format_ident); print("  ");
print_int(day); print_char(" ");
months:='JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';
@y
begin wlog (banner);
wlog (version_string);
slow_print(format_ident); print("  ");
print_int(day); print_char(" ");
months := ' JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.537] Use a path when calling a_open_in to do a \input; also, try
% to open the file with and without the `.tex' extension, regardless of
% whether the file already has an extension.  This allows filenames like
% `foo' and `foo.bar.tex', as well as `foo.tex' and `foo.bar'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if cur_ext="" then cur_ext:=".tex";
pack_cur_name;
loop@+  begin begin_file_reading; {set up |cur_file| and new level of input}
  if a_open_in(cur_file) then goto done;
  if cur_area="" then
    begin pack_file_name(cur_name,TEX_area,cur_ext);
    if a_open_in(cur_file) then goto done;
    end;
@y
pack_cur_name;
loop@+begin
  begin_file_reading; {set up |cur_file| and new level of input}
  {If we have an extension try the current name first, to avoid looking
   for names like |"article.sty.tex"|.}
  if (cur_ext <> "") and a_open_in (cur_file, TEX_INPUT_PATH) then goto done;

  {That failed. Next, append |".tex"| if (1)~it's not already there; and
   (2)~it doesn't overflow |name_of_file|, and
   (3)~it changes the actual file looked for (e.g., |"afourteenlongf"|
   and |"afourteenlongf.tex"| are the same file under System V).
   
   We ignore the presence or absence of an extension, because we want to
   allow input files like |"foo.bar.tex"|.}
  if (cur_ext <> ".tex") and (name_length + 5 < file_name_size)
     and (not extension_irrelevant_p (name_of_file, 'tex'))
  then begin
    name_of_file[name_length + 1] := ".";
    name_of_file[name_length + 2] := "t";
    name_of_file[name_length + 3] := "e";
    name_of_file[name_length + 4] := "x";
    name_length := name_length + 4;
    if a_open_in (cur_file, TEX_INPUT_PATH) then goto done;
    {If failed, take away our addition.}
    name_length := name_length - 4;
    name_of_file[name_length + 1] := " ";
  end;
  
  {That failed too. If there was no extension, try the name just as it
   was given, so we will find an input file |"foo"|. We do this after
   trying with |".tex"| appended, because if someone is writing a
   program |foo|, they might like to call their documentation
   |"foo.tex"|, and we don't want to input the binary executable |foo|.}
  if (cur_ext = "") and a_open_in (cur_file, TEX_INPUT_PATH) then goto done;
  
  {Couldn't find the file.  Possibly invoke an external program to
   create it.  If that claims success, try one last open.}
  if make_tex_tex and a_open_in (cur_file, TEX_INPUT_PATH) then goto done;
@z

@x JTeX
done: name:=a_make_name_string(cur_file);
@y
done: name:=a_make_name_string(cur_file);
@<Set kanji |cur_file| type@>;
@z

% Knuth should fix this -- sometimes lines go over the |max_print_line|.
% ... But now I don't remember what caused this, so I'll comment this
% out until it happens again.
% @x
% if term_offset+length(name)>max_print_line-2 then print_ln
% @y
% if term_offset+length(name)>max_print_line-3 then print_ln
% @z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [29.537] Get rid of return of filename to string pool.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if name=str_ptr-1 then {we can conserve string pool space now}
  begin flush_string; name:=cur_name;
  end;
@y
@z

@x 8bit: [538]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the the end-of-line-char if it is active@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [30.559] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [559] a variable used in reading header info ([568])
@!z:scaled; {the design size or the ``at'' size}
@!alpha:integer;@!beta:1..16;
  {auxiliary quantities used in fixed-point multiplication}
@y
@!z:scaled; {the design size or the ``at'' size}
@!alpha:integer;@!beta:1..16;
  {auxiliary quantities used in fixed-point multiplication}
@!temp:integer; {store possible japanese font identifying number}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [30.563] Don't use font_area's in TFM opening, and invoke an external
% program if the first open fails.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
file_opened:=false;
if aire="" then pack_file_name(nom,TEX_font_area,".tfm")
else pack_file_name(nom,aire,".tfm");
if not b_open_in(tfm_file) then abort;
file_opened:=true
@y
file_opened := false;
pack_file_name (nom, aire, ".tfm");
if not b_open_in(tfm_file) then begin
  if make_tex_tfm then begin
    if not b_open_in(tfm_file) then abort;
  end else
    abort;
end;
file_opened:=true
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [30.564] Reading the tfm file.  As a special case, whenever we open a
% tfm file, we read its first byte into `tfm_temp' right away.  TeX
% looks at `fbyte' before calling `fget', so it ends up seeing every
% byte.  This is Pascal-like I/O.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%!!!10942
@x
@d fget==get(tfm_file)
@d fbyte==tfm_file^
@y
@d fget==tfm_temp:=getc(tfm_file)
@d fbyte==tfm_temp
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [30.568] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%!!!11016
@x Changes for JTeX: [568] Read in extra header info for japanese fonts
while lh>2 do
  begin fget;fget;fget;fget;decr(lh); {ignore the rest of the header}
  end;
@y
if lh>2 then begin fget; temp:=fbyte; fget; temp:=temp*@'400+fbyte;
fget; temp:=temp*@'400+fbyte; fget; temp:=temp*@'400+fbyte; decr(lh); end;
if temp=142857 then {this is a japanese sub fonts!}
 begin fget; fget; fget; fget; j_font_table[f]:=fbyte; decr(lh); end;
	{sub font number in |j_font_table| if this is a japanese sub font}
while lh>2 do
  begin fget;fget;fget;fget;decr(lh); {ignore the rest of the header}
  end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [32.597] We only want `eof' on the TFM file to be true if we
% previously had EOF, not if we're at EOF now.  This is like `feof', and
% unlike our implementation of `eof' elsewhere.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%!!!!11147
@x
if eof(tfm_file) then abort;
@y
if feof(tfm_file) then abort;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [30.577] delayed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%!!!11180
@x [577]
@<Declare procedures that scan font-related stuff@>=
procedure scan_font_ident;
@y
@<Declare procedures that scan font-related stuff@>=
procedure load_dfont_proc; forward;
procedure scan_font_ident;
@z

@x [577]
else if cur_cmd=def_family then
  begin m:=cur_chr; scan_four_bit_int; f:=equiv(m+cur_val);
  end
@y
else if cur_cmd=def_family then
  begin m:=cur_chr; scan_four_bit_int; f:=equiv(m+cur_val);
  end
else if cur_cmd=def_dfont then f:=cur_font
else if cur_cmd=demmand_font then
  begin load_dfont_proc; f:=cur_chr;
  end
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [31] More fonts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d fnt1=235 {set current font}
@d xxx1=239 {extension to \.{DVI} primitives}
@d xxx4=242 {potentially long extension to \.{DVI} primitives}
@d fnt_def1=243 {define the meaning of a font number}
@y
@d fnt1=235 {set current font}
@d fnt2=236 {set current font}
@d xxx1=239 {extension to \.{DVI} primitives}
@d xxx4=242 {potentially long extension to \.{DVI} primitives}
@d fnt_def1=243 {define the meaning of a font number}
@d fnt_def2=244 {define the meaning of a font number}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [32.597] write_dvi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@p procedure write_dvi(@!a,@!b:dvi_index);
var k:dvi_index;
begin for k:=a to b do write(dvi_file,dvi_buf[k]);
end;
@y
In C, we use a macro to call |fwrite| or |write| directly, writing all
the bytes to be written in one shot.  Much better even than writing four
bytes at a time.
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [32] More fonts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@p procedure dvi_font_def(@!f:internal_font_number);
var k:pool_pointer; {index into |str_pool|}
begin dvi_out(fnt_def1);
dvi_out(f-font_base-1);@/
@y
@p procedure dvi_font_def(@!f:internal_font_number);
var k:pool_pointer; {index into |str_pool|}
begin
if f<=256+font_base then begin
 dvi_out(fnt_def1); dvi_out(f-font_base-1);
 end
else begin dvi_out(fnt_def2);
 dvi_out((f-font_base-1) div 256); dvi_out((f-font_base-1) mod 256);
 end;
@z

@x
if f<=64+font_base then dvi_out(f-font_base-1+fnt_num_0)
else  begin dvi_out(fnt1); dvi_out(f-font_base-1);
  end;
@y
if f<=64+font_base then dvi_out(f-font_base-1+fnt_num_0)
else if f<=256+font_base then begin dvi_out(fnt1); dvi_out(f-font_base-1);
  end
else  begin dvi_out(fnt2);
  dvi_out((f-font_base-1) div 256); dvi_out((f-font_base-1) mod 256);
  end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [38.859] Fix a casting/expression evaluation problem.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if abs(fit_class-fitness(r))>1 then d:=d+adj_demerits;
@y
if abs(toint(fit_class)-toint(fitness(r)))>1 then d:=d+adj_demerits;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [39.875] Another casting problem.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
repeat if type(r)<>delta_node then
  begin line_diff:=line_number(r)-best_line;
@y
repeat if type(r)<>delta_node then
  begin line_diff:=toint(line_number(r))-toint(best_line);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [42.920,921,923,924] Allow larger hyphenation tries.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
Comparatively few different number sequences $n_0\ldots n_k$ actually occur,
since most of the |n|'s are generally zero. Therefore the number sequences
are encoded in such a way that |trie_op|$(z_k)$ is only one byte long.
If |trie_op(@t$z_k$@>)<>min_quarterword|, when $p_1\ldots p_k$ has matched
the letters in |hc[(l-k+1)..l@,]| of language |t|,
we perform all of the required operations
for this pattern by carrying out the following little program: Set
|v:=trie_op(@t$z_k$@>)|. Then set |v:=v+op_start[t]|,
|hyf[l-hyf_distance[v]]:=@tmax@>(hyf[l-hyf_distance[v]], hyf_num[v])|,
and |v:=hyf_next[v]|; repeat, if necessary, until |v=min_quarterword|.
@y
The theory that comparatively few different number sequences $n_0\ldots n_k$
actually occur, since most of the |n|'s are generally zero, seems to fail
at least for the large German hyphenation patterns.
Therefore the number sequences cannot any longer be encoded in such a way
that |trie_op|$(z_k)$ is only one byte long.
We have introduced a new constant |max_trie_op| for the maximum allowable
hyphenation operation code value; |max_trie_op| might be different for
\TeX\ and \.{INITEX} and must not exceed |max_halfword|.
An opcode will occupy a halfword if |max_trie_op| exceeds |max_quarterword|
or a quarterword otherwise.
@^system dependencies@>
If |trie_op(@t$z_k$@>)<>min_trie_op|, when $p_1\ldots p_k$ has matched
the letters in |hc[(l-k+1)..l@,]| of language |t|,
we perform all of the required operations
for this pattern by carrying out the following little program: Set
|v:=trie_op(@t$z_k$@>)|. Then set |v:=v+op_start[t]|,
|hyf[l-hyf_distance[v]]:=@tmax@>(hyf[l-hyf_distance[v]], hyf_num[v])|,
and |v:=hyf_next[v]|; repeat, if necessary, until |v=min_trie_op|.
@z
@x
@!trie_pointer=0..trie_size; {an index into |trie|}
@y
@!trie_opcode=min_trie_op..max_trie_op;  {a trie opcode}
@!trie_pointer=0..trie_size; {an index into |trie|}
@z
@x
@ @d trie_link(#)==trie[#].rh {``downward'' link in a trie}
@d trie_char(#)==trie[#].b1 {character matched at this trie location}
@d trie_op(#)==trie[#].b0 {program for hyphenation at this trie location}
@y
@ For more than 255 trie op codes, the three fields |trie_link|, |trie_char|,
and |trie_op| will no longer fit into one memory word; thus using web2c
we define |trie| as three array instead of an array of records.
The variant will be implented by reusing the opcode field later on with
another macro.
@d trie_link(#)==trie_trl[#] {``downward'' link in a trie}
@d trie_char(#)==trie_trc[#] {character matched at this trie location}
@d trie_op(#)==trie_tro[#] {program for hyphenation at this trie location}
@z
@x
@!trie:array[trie_pointer] of two_halves; {|trie_link|, |trie_char|, |trie_op|}
@y
@!trie_trl:array[trie_pointer] of halfword; {|trie_link|}
@!trie_tro:array[trie_pointer] of halfword; {|trie_op| and |trie_link|}
@!trie_trc:array[trie_pointer] of quarterword; {|trie_char|}
@z
@x
@!hyf_next:array[1..trie_op_size] of quarterword; {continuation code}
@y
@!hyf_next:array[1..trie_op_size] of trie_opcode; {continuation code}
@z
@x
    begin if trie_op(z)<>min_quarterword then
@y
    begin if trie_op(z)<>min_trie_op then
@z
@x
until v=min_quarterword;
@y
until v=min_trie_op;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.943] Larger tries, also in documentation parts.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
|hyf_next[@t$v^\prime$@>]=min_quarterword|.
@y
|hyf_next[@t$v^\prime$@>]=min_trie_op|.
@z
@x
$$\hbox{|@t$v^\prime$@>:=new_trie_op(0,1,min_quarterword)|,\qquad
@y
$$\hbox{|@t$v^\prime$@>:=new_trie_op(0,1,min_trie_op)|,\qquad
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.943] web2c can't parse negative lower bounds in arrays.  Sorry.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!init@! trie_op_hash:array[-trie_op_size..trie_op_size] of 0..trie_op_size;
@y
@!init@! trie_op_hash:array[neg_trie_op_size..trie_op_size] of 0..trie_op_size;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.943,944] Larger hyphenation tries.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!trie_used:array[ASCII_code] of quarterword;
@y
@!trie_used:array[ASCII_code] of trie_opcode;
@z
@x
@!trie_op_val:array[1..trie_op_size] of quarterword;
@y
@!trie_op_val:array[1..trie_op_size] of trie_opcode;
@z
@x
tini
@y
tini@;
@!max_op_used:trie_opcode; {largest opcode used for any language}
@!small_op:boolean; {flag used while dumping or undumping}
@z
@x
|new_trie_op| could return |min_quarterword| (thereby simply ignoring
@y
|new_trie_op| could return |min_trie_op| (thereby simply ignoring
@z
@x
function new_trie_op(@!d,@!n:small_number;@!v:quarterword):quarterword;
label exit;
var h:-trie_op_size..trie_op_size; {trial hash location}
@!u:quarterword; {trial op code}
@y
function new_trie_op(@!d,@!n:small_number;@!v:trie_opcode):trie_opcode;
label exit;
var h:neg_trie_op_size..trie_op_size; {trial hash location}
@!u:trie_opcode; {trial op code}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.944] Another casting problem, and use |neg_trie_op_size|.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
begin h:=abs(n+313*d+361*v+1009*cur_lang) mod (trie_op_size+trie_op_size)
  - trie_op_size;
@y
begin h:=abs(toint(n)+313*toint(d)+361*toint(v)+1009*toint(cur_lang))
  mod (trie_op_size - neg_trie_op_size)
  + neg_trie_op_size;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.944,945,946] And larger tries again.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
    if u=max_quarterword then
      overflow("pattern memory ops per language",
        max_quarterword-min_quarterword);
    incr(trie_op_ptr); incr(u); trie_used[cur_lang]:=u;
@y
    if u=max_trie_op then
      overflow("pattern memory ops per language",
      max_trie_op-min_trie_op);
    incr(trie_op_ptr); incr(u); trie_used[cur_lang]:=u;
    if u>max_op_used then max_op_used:=u;
@z
@x
op_start[0]:=-min_quarterword;
@y
op_start[0]:=-min_trie_op;
@z
@x
for k:=0 to 255 do trie_used[k]:=min_quarterword;
@y
for k:=0 to 255 do trie_used[k]:=min_trie_op;
@z
@x
trie_op_ptr:=0;
@y
max_op_used:=min_trie_op;
trie_op_ptr:=0;
@z
@x
@t\hskip10pt@>@!trie_o:packed array[trie_pointer] of quarterword;
@y
@t\hskip10pt@>@!trie_o:packed array[trie_pointer] of trie_opcode;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.947] A casting problem.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
begin h:=abs(trie_c[p]+1009*trie_o[p]+@|
    2718*trie_l[p]+3142*trie_r[p]) mod trie_size;
@y
begin h:=abs(toint(trie_c[p])+1009*toint(trie_o[p])+@|
    2718*toint(trie_l[p])+3142*toint(trie_r[p])) mod trie_size;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [43.950,958,960,963] Larger tries.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d trie_back(#)==trie[#].lh {backward links in |trie| holes}
@y
@d trie_back(#)==trie_tro[#] {use the opcode field now for backward links}
@z
@x
@<Move the data into |trie|@>=
h.rh:=0; h.b0:=min_quarterword; h.b1:=min_quarterword; {|trie_link:=0|,
  |trie_op:=min_quarterword|, |trie_char:=qi(0)|}
if trie_root=0 then {no patterns were given}
  begin for r:=0 to 256 do trie[r]:=h;
@y
@d clear_trie == {clear |trie[r]|}
  begin trie_link(r):=0;
  trie_op(r):=min_trie_op;
  trie_char(r):=min_quarterword; {|trie_char:=qi(0)|}
  end
@<Move the data into |trie|@>=
if trie_root=0 then {no patterns were given}
  begin for r:=0 to 256 do clear_trie;
@z
@x
  repeat s:=trie_link(r); trie[r]:=h; r:=s;
@y
  repeat s:=trie_link(r); clear_trie; r:=s;
@z
@x
@!v:quarterword; {trie op code}
@y
@!v:trie_opcode; {trie op code}
@z
@x
if trie_o[q]<>min_quarterword then
@y
if trie_o[q]<>min_trie_op then
@z
@x
trie_c[p]:=si(c); trie_o[p]:=min_quarterword;
@y
trie_c[p]:=si(c); trie_o[p]:=min_trie_op;
@z
@x
l:=k; v:=min_quarterword;
@y
l:=k; v:=min_trie_op;
@z
@x
@!h:two_halves; {template used to zero out |trie|'s holes}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [46.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [1030]
@p @t\4@>@<Declare action procedures for use by |main_control|@>@;
@y
@p @t\4@>@<Declare subprocedures needed for delayed font@>@;@/
@t\4@>@<Declare action procedures for use by |main_control|@>@;
@z

@x Changes for JTeX: [1030] new case for jletter
var@!t:integer; {general-purpose temporary variable}
begin if every_job<>null then begin_token_list(every_job,every_job_text);
big_switch: get_x_token;@/
reswitch: @<Give diagnostic information, if requested@>;
case abs(mode)+cur_cmd of
hmode+letter,hmode+other_char,hmode+char_given: goto main_loop;
hmode+char_num: begin scan_char_num; cur_chr:=cur_val; goto main_loop;@+end;
@y
var@!t:integer; {general-purpose temporary variable}
@!p:pointer; {general-purpose temporary variable}
@!prev_cmd:eight_bits; {the previous command}
@!temp_cmd:eight_bits; {to restore right |cur_cmd| after |scan_char_num|}
begin if every_job<>null then begin_token_list(every_job,every_job_text);
big_switch: get_x_token;@/
reswitch: @<Give diagnostic information, if requested@>;
case abs(mode)+cur_cmd of
hmode+letter,hmode+jletter,hmode+other_char,hmode+char_given: goto main_loop;
hmode+char_num: begin temp_cmd:=cur_cmd;
 scan_j_char_num; if cur_val>=256 then cur_cmd:=jletter else
 cur_cmd:=temp_cmd; cur_chr:=cur_val; goto main_loop;@+end;
hmode+faker: goto main_loop_lookahead;
vmode+faker,mmode+faker: do_nothing;
@z

@x Changes for JTeX: [1034] space factor for japanese
  main_s:=sf_code(cur_chr);
  if main_s=1000 then space_factor:=1000
  else if main_s<1000 then
    begin if main_s>0 then space_factor:=main_s;
    end
  else if space_factor<1000 then space_factor:=1000
  else space_factor:=main_s
@y
  if cur_cmd=jletter then space_factor:=1000
  else begin
  main_s:=sf_code(cur_chr);
  if main_s=1000 then space_factor:=1000
  else if main_s<1000 then
    begin if main_s>0 then space_factor:=main_s;
    end
  else if space_factor<1000 then space_factor:=1000
  else space_factor:=main_s
  end
@z

% The following cases are not considered.
%	hyphen jletter (how we should treat this case?)
%	jletter lig (where lig is kinsoku char)
@x Changes for JTeX: [???]
main_f:=cur_font;
bchar:=font_bchar[main_f]; false_bchar:=font_false_bchar[main_f];
if mode>0 then if language<>clang then fix_language;
fast_get_avail(lig_stack); font(lig_stack):=main_f; cur_l:=qi(cur_chr);
character(lig_stack):=cur_l;@/
@y
if cur_cmd=jletter then begin
  main_f:=font_jsubf(jchr_subfont(cur_chr));
  cur_l:=jchr_char(cur_chr); main_c:=qo(cur_l);
  @<Kinsoku shori; insert or omit glue before jletter@>;
  end
else begin
  main_f:=cur_font; cur_l:=qi(cur_chr); main_c:=cur_chr;
  @<Kinsoku shori; insert or omit glue after jletter@>;
  end;
bchar:=font_bchar[main_f]; false_bchar:=font_false_bchar[main_f];
if mode>0 then if language<>clang then fix_language;
fast_get_avail(lig_stack); font(lig_stack):=main_f;
character(lig_stack):=cur_l;@/
@z

@x Changes for JTeX: [???]
@d pack_lig(#)== {the parameter is either |rt_hit| or |false|}
  begin main_p:=new_ligature(main_f,cur_l,link(cur_q));
@y
@d pack_lig(#)== {the parameter is either |rt_hit| or |false|}
  begin main_p:=new_ligature(cur_font,cur_l,link(cur_q));
@z

@x Changes for JTeX: [???]
main_loop_move+1:if not is_char_node(lig_stack) then goto main_loop_move_lig;
main_loop_move+2:if(cur_chr<font_bc[main_f])or(cur_chr>font_ec[main_f]) then
  begin char_warning(main_f,cur_chr); free_avail(lig_stack); goto big_switch;
  end;
main_i:=char_info(main_f)(cur_l);
if not char_exists(main_i) then
  begin char_warning(main_f,cur_chr); free_avail(lig_stack); goto big_switch;
  end;
@y
main_loop_move+1:if not is_char_node(lig_stack) then goto main_loop_move_lig;
main_loop_move+2:if(main_c<font_bc[main_f])or(main_c>font_ec[main_f]) then
  if @<|cur_chr| is jis space@> then begin {treat JIS space (!!) specially}
    @<Insert |jspaceskip|@>;
    @<set |main_i| for JIS space@>;
    free_avail(lig_stack);
    goto main_loop_lookahead;
    end
  else begin char_warning(main_f,main_c); free_avail(lig_stack);
    goto big_switch;
    end;
main_i:=char_info(main_f)(cur_l);
if not char_exists(main_i) then
  begin char_warning(main_f,main_c); free_avail(lig_stack); goto big_switch;
  end;
@z

@x Changes for JTeX: [???]
get_next; {set only |cur_cmd| and |cur_chr|, for speed}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
x_token; {now expand and set |cur_cmd|, |cur_chr|, |cur_tok|}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
if cur_cmd=char_num then
  begin scan_char_num; cur_chr:=cur_val; goto main_loop_lookahead+1;
  end;
if cur_cmd=no_boundary then bchar:=non_char;
cur_r:=bchar; lig_stack:=null; goto main_lig_loop;
main_loop_lookahead+1: adjust_space_factor;
fast_get_avail(lig_stack); font(lig_stack):=main_f;
cur_r:=qi(cur_chr); character(lig_stack):=cur_r;
if cur_r=false_bchar then cur_r:=non_char {this prevents spurious ligatures}
@y
prev_cmd:=cur_cmd; prev_c:=cur_chr;
get_next; {set only |cur_cmd| and |cur_chr|, for speed}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=jletter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
x_token; {now expand and set |cur_cmd|, |cur_chr|, |cur_tok|}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=jletter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
if cur_cmd=char_num then
  begin scan_j_char_num; 
    if cur_val>=256 then {japanese character specified by |char_num|}
      begin cur_cmd:=jletter; cur_chr:=cur_val;
      end
    else cur_chr:=cur_val;
    goto main_loop_lookahead+1;
  end;
if cur_cmd=no_boundary then bchar:=non_char;
if prev_cmd=jletter then @<Right boundary of japanese char@>
else if prev_cmd=faker then goto reswitch;
cur_r:=bchar; lig_stack:=null; goto main_lig_loop;
main_loop_lookahead+1: adjust_space_factor;
fast_get_avail(lig_stack);
if cur_cmd=jletter then begin
    main_f:=font_jsubf(jchr_subfont(cur_chr));
    cur_r:=jchr_char(cur_chr); main_c:=qo(cur_r);
  end
else begin
    if (prev_cmd=jletter) or (prev_cmd=faker) then main_f:=cur_font;
    cur_r:=qi(cur_chr); main_c:=cur_chr;
  end;
font(lig_stack):=main_f;
character(lig_stack):=cur_r;
if cur_r=false_bchar then cur_r:=non_char; {this prevents spurious ligatures}
@<Kinsoku shori; insert or omit glue and |goto main_loop_move|,
  if |prev_cmd=jletter| or |cur_cmd=jletter|@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [47.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [1090] new case for vmode+jletter
vmode+letter,vmode+other_char,vmode+char_num,vmode+char_given,
@y
vmode+letter,vmode+jletter,vmode+other_char,vmode+char_num,vmode+char_given,
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [47.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [1123] make accent workable for japanese char too
begin scan_char_num; f:=cur_font; p:=new_character(f,cur_val);
@y
begin scan_j_char_num; if cur_val>=256 then begin
f:=font_jsubf(jchr_subfont(cur_val));
p:=new_character(f,jchr_char(cur_val)); end else begin
f:=cur_font; p:=new_character(f,cur_val); end;
@z

@x Changes for JTeX: [1124] make accent workable for japanese character
if (cur_cmd=letter)or(cur_cmd=other_char)or(cur_cmd=char_given) then
  q:=new_character(f,cur_chr)
else if cur_cmd=char_num then
  begin scan_char_num; q:=new_character(f,cur_val);
  end
else back_input
@y
if (cur_cmd=letter)or(cur_cmd=other_char)or(cur_cmd=char_given) then
  q:=new_character(f,cur_chr)
else if cur_cmd=jletter then begin
    f:=font_jsubf(jchr_subfont(cur_chr));
    q:=new_character(f,jchr_char(cur_chr)); end
  else if cur_cmd=char_num then
      begin scan_j_char_num;
        if cur_val>=256 then begin
          f:=font_jsubf(jchr_subfont(cur_val));
	  q:=new_character(f,jchr_char(cur_val)); end
        else q:=new_character(f,cur_val); end
  else back_input
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [48.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [???] new case for mmode+jletter
mmode+letter,mmode+other_char,mmode+char_given:
  set_math_char(ho(math_code(cur_chr)));
@y
mmode+letter,mmode+other_char,mmode+char_given:
  set_math_char(ho(math_code(cur_chr)));
mmode+jletter:
  if @<|cur_chr| is jis space@> then {treat JIS space (!!) specially}
    @<Insert |jspaceskip|@>
  else begin p:=new_noad;
    math_type(nucleus(p)):=sub_box;
    info(nucleus(p)):=
      char_box(font_jsubf(jchr_subfont(cur_chr)),jchr_char(cur_chr));
    tail_append(p);
  end;
@z

@x Changes for JTeX: [1196]
@<Finish math in text@>=
begin tail_append(new_math(math_surround,before));
@y
@<Finish math in text@>=
begin
@<Kinsoku shori; insert or omit glue between jletter and math@>;
tail_append(new_math(math_surround,before));
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [49.X] delayed, JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x [1210] hook for new prefixed commands
any_mode(def_font),
@y
any_mode(def_font),
@<New prefixed commands@>
@z

@x [1221] add ref count of box in let
  if cur_cmd>=call then add_token_ref(cur_chr);
  define(p,cur_cmd,cur_chr);
@y
  if cur_cmd>=call then add_token_ref(cur_chr)
  else if cur_cmd=demmand_font then add_df_ref(cur_chr);
  define(p,cur_cmd,cur_chr);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [49.1257,1258] JTeX: filename and jendlinetype
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x Changes for JTeX: [1257]
procedure new_font(@!a:small_number);
label common_ending;
var u:pointer; {user's font identifier}
@y
procedure new_font(@!a:small_number);
label common_ending;
var u:pointer; {user's font identifier}
@!save_jendline_type:integer;
@z
@x Changes for JTeX: [1258]
@ @<Scan the font size specification@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
@y
@ @<Scan the font size specification@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
save_jendlinetype:=jendline_type; jendline_type:=jend_ascii;
@z
@x Changes for JTeX: [1258]
else s:=-1000;
name_in_progress:=false
@y
else s:=-1000;
name_in_progress:=false; jendline_type:=save_jendline_type
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [49.1275] Same stuff as for \input, this time for \openin. There seems
% to be no reasonable way to make this into a subroutine ...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
  if cur_ext="" then cur_ext:=".tex";
  pack_cur_name;
  if a_open_in(read_file[n]) then read_open[n]:=just_open;
@y
  pack_cur_name;
  if (cur_ext <> "") and a_open_in (read_file[n], TEX_INPUT_PATH)
  then begin read_open[n] := just_open;
    @<Set kanji |read_file| type@>;
    end

  else if (cur_ext <> ".tex") and (name_length + 5 < file_name_size)
     and (not extension_irrelevant_p (name_of_file, 'tex'))
  then begin
    name_of_file[name_length + 1] := ".";
    name_of_file[name_length + 2] := "t";
    name_of_file[name_length + 3] := "e";
    name_of_file[name_length + 4] := "x";
    name_length := name_length + 4;
    if a_open_in (read_file[n], TEX_INPUT_PATH)
    then begin read_open[n] := just_open;
      @<Set kanji |read_file| type@>;
      end

    else begin
      name_length := name_length - 4;
      name_of_file[name_length + 1] := " ";
      if (cur_ext = "") and a_open_in (read_file[n], TEX_INPUT_PATH)
      then begin read_open[n] := just_open;
        @<Set kanji |read_file| type@>;
        end
  
      else if make_tex_tex and a_open_in (read_file[n], TEX_INPUT_PATH)
      then begin read_open[n] := just_open;
        @<Set kanji |read_file| type@>;
        end;
    end;
  end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.X] JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.1302] Eliminate now-unused variable `w' in `store_fmt_file'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!x: integer; {something to dump}
@!w: four_quarters; {four ASCII codes}
@y
@!x: integer; {something to dump}
@z

@x Changes for JTeX: [1302] you need to dump j_s_font_pointer too
@<Dump the hyphenation tables@>;
@y
@<Dump the hyphenation tables@>;
@<Dump the japanese sub font pointer@>;
@<Dump the Kinsoku tables@>;
@<Dump the |j_font_table|@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.1303] Ditto, for `load_fmt_file'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@!x: integer; {something undumped}
@!w: four_quarters; {four ASCII codes}
@y
@!x: integer; {something undumped}
@z

@x Changes for JTeX: [1303] corresponding undump
@<Undump the hyphenation tables@>;
@y
@<Undump the hyphenation tables@>;
@<Undump the japanese sub font pointer@>;
@<Undump the Kinsoku tables@>;
@<Undump the |j_font_table|@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.??] Do reading and writing of `fmt_file' in C.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@d dump_wd(#)==begin fmt_file^:=#; put(fmt_file);@+end
@d dump_int(#)==begin fmt_file^.int:=#; put(fmt_file);@+end
@d dump_hh(#)==begin fmt_file^.hh:=#; put(fmt_file);@+end
@d dump_qqqq(#)==begin fmt_file^.qqqq:=#; put(fmt_file);@+end
@y
@z

@x
@d undump_wd(#)==begin get(fmt_file); #:=fmt_file^;@+end
@d undump_int(#)==begin get(fmt_file); #:=fmt_file^.int;@+end
@d undump_hh(#)==begin get(fmt_file); #:=fmt_file^.hh;@+end
@d undump_qqqq(#)==begin get(fmt_file); #:=fmt_file^.qqqq;@+end
@y
@z

@x
x:=fmt_file^.int;
@y
undump_int(x);		{This reads the first word of the \.{.fmt} file}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [??] Make dumping/undumping more efficient.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
for k:=0 to str_ptr do dump_int(str_start[k]);
k:=0;
while k+4<pool_ptr do
  begin dump_four_ASCII; k:=k+4;
  end;
k:=pool_ptr-4; dump_four_ASCII;
@y
dump_things(str_start[0], str_ptr+1);
dump_things(str_pool[0], pool_ptr);
@z

@x
for k:=0 to str_ptr do undump(0)(pool_ptr)(str_start[k]);
k:=0;
while k+4<pool_ptr do
  begin undump_four_ASCII; k:=k+4;
  end;
k:=pool_ptr-4; undump_four_ASCII;
@y
undump_things(str_start[0], str_ptr+1);
undump_things(str_pool[0], pool_ptr);
@z

@x
repeat for k:=p to q+1 do dump_wd(mem[k]);
x:=x+q+2-p; var_used:=var_used+q-p;
p:=q+node_size(q); q:=rlink(q);
until q=rover;
var_used:=var_used+lo_mem_max-p; dyn_used:=mem_end+1-hi_mem_min;@/
for k:=p to lo_mem_max do dump_wd(mem[k]);
x:=x+lo_mem_max+1-p;
dump_int(hi_mem_min); dump_int(avail);
for k:=hi_mem_min to mem_end do dump_wd(mem[k]);
@y
repeat
 dump_things(mem[p], q+2-p);
x:=x+q+2-p; var_used:=var_used+q-p;
p:=q+node_size(q); q:=rlink(q);
until q=rover;
var_used:=var_used+lo_mem_max-p; dyn_used:=mem_end+1-hi_mem_min;@/
dump_things(mem[p], lo_mem_max+1-p);
x:=x+lo_mem_max+1-p;
dump_int(hi_mem_min); dump_int(avail);
dump_things(mem[hi_mem_min], mem_end+1-hi_mem_min);
@z

@x
repeat for k:=p to q+1 do undump_wd(mem[k]);
p:=q+node_size(q);
if (p>lo_mem_max)or((q>=rlink(q))and(rlink(q)<>rover)) then goto bad_fmt;
q:=rlink(q);
until q=rover;
for k:=p to lo_mem_max do undump_wd(mem[k]);
@y
repeat
  undump_things(mem[p], q+2-p);
p:=q+node_size(q);
if (p>lo_mem_max)or((q>=rlink(q))and(rlink(q)<>rover)) then goto bad_fmt;
q:=rlink(q);
until q=rover;
undump_things(mem[p], lo_mem_max+1-p);
@z

@x
for k:=hi_mem_min to mem_end do undump_wd(mem[k]);
@y
undump_things(mem[hi_mem_min], mem_end+1-hi_mem_min);
@z

@x
while k<l do
  begin dump_wd(eqtb[k]); incr(k);
  end;
@y
dump_things(eqtb[k], l-k);
@z

@x
while k<l do
  begin dump_wd(eqtb[k]); incr(k);
  end;
@y
dump_things(eqtb[k], l-k);
@z

@x
for j:=k to k+x-1 do undump_wd(eqtb[j]);
@y
undump_things(eqtb[k], x);
@z

@x
for p:=hash_used+1 to undefined_control_sequence-1 do dump_hh(hash[p]);
@y
dump_things(hash[hash_used+1], undefined_control_sequence-1-hash_used);
@z

@x
for p:=hash_used+1 to undefined_control_sequence-1 do undump_hh(hash[p]);
@y
undump_things(hash[hash_used+1], undefined_control_sequence-1-hash_used);
@z

@x
for k:=0 to fmem_ptr-1 do dump_wd(font_info[k]);
dump_int(font_ptr);
for k:=null_font to font_ptr do
  @<Dump the array info for internal font number |k|@>;
@y
@<Dump the array info for internal font number |k|@>;
@z

@x
for k:=0 to fmem_ptr-1 do undump_wd(font_info[k]);
undump_size(font_base)(font_max)('font max')(font_ptr);
for k:=null_font to font_ptr do
  @<Undump the array info for internal font number |k|@>
@y
@<Undump the array info for internal font number |k|@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.1322] Writing font info (almost at end of dump stuff).
% Knuth's code writes all the information relevant to a single font
% in the same section of the fmt file.  But it's a lot faster to
% write the arrays of information out, one whole array at a time.
% So that's the way we handle dumping and undumping font info.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ @<Dump the array info for internal font number |k|@>=
begin dump_qqqq(font_check[k]);
dump_int(font_size[k]);
dump_int(font_dsize[k]);
dump_int(font_params[k]);@/
dump_int(hyphen_char[k]);
dump_int(skew_char[k]);@/
dump_int(font_name[k]);
dump_int(font_area[k]);@/
dump_int(font_bc[k]);
dump_int(font_ec[k]);@/
dump_int(char_base[k]);
dump_int(width_base[k]);
dump_int(height_base[k]);@/
dump_int(depth_base[k]);
dump_int(italic_base[k]);
dump_int(lig_kern_base[k]);@/
dump_int(kern_base[k]);
dump_int(exten_base[k]);
dump_int(param_base[k]);@/
dump_int(font_glue[k]);@/
dump_int(bchar_label[k]);
dump_int(font_bchar[k]);
dump_int(font_false_bchar[k]);@/
print_nl("\font"); print_esc(font_id_text(k)); print_char("=");
print_file_name(font_name[k],font_area[k],"");
if font_size[k]<>font_dsize[k] then
  begin print(" at "); print_scaled(font_size[k]); print("pt");
  end;
end
@y
@ @<Dump the array info for internal font number |k|@>=
begin dump_things(font_info[0], fmem_ptr);
dump_int(font_ptr);
dump_things(font_check[null_font], font_ptr+1-null_font);
dump_things(font_size[null_font], font_ptr+1-null_font);
dump_things(font_dsize[null_font], font_ptr+1-null_font);
dump_things(font_params[null_font], font_ptr+1-null_font);
dump_things(hyphen_char[null_font], font_ptr+1-null_font);
dump_things(skew_char[null_font], font_ptr+1-null_font);
dump_things(font_name[null_font], font_ptr+1-null_font);
dump_things(font_area[null_font], font_ptr+1-null_font);
dump_things(font_bc[null_font], font_ptr+1-null_font);
dump_things(font_ec[null_font], font_ptr+1-null_font);
dump_things(char_base[null_font], font_ptr+1-null_font);
dump_things(width_base[null_font], font_ptr+1-null_font);
dump_things(height_base[null_font], font_ptr+1-null_font);
dump_things(depth_base[null_font], font_ptr+1-null_font);
dump_things(italic_base[null_font], font_ptr+1-null_font);
dump_things(lig_kern_base[null_font], font_ptr+1-null_font);
dump_things(kern_base[null_font], font_ptr+1-null_font);
dump_things(exten_base[null_font], font_ptr+1-null_font);
dump_things(param_base[null_font], font_ptr+1-null_font);
dump_things(font_glue[null_font], font_ptr+1-null_font);
dump_things(bchar_label[null_font], font_ptr+1-null_font);
dump_things(font_bchar[null_font], font_ptr+1-null_font);
dump_things(font_false_bchar[null_font], font_ptr+1-null_font);
for k:=null_font to font_ptr do begin
  print_nl("\font"); print_esc(font_id_text(k)); print_char("=");
  print_file_name(font_name[k],font_area[k],"");
  if font_size[k]<>font_dsize[k] then begin
    print(" at "); print_scaled(font_size[k]); print("pt");
  end;
end;
end
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.1322] Reading font info for C (nearly done with undump stuff).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@ @<Undump the array info for internal font number |k|@>=
begin undump_qqqq(font_check[k]);@/
undump_int(font_size[k]);
undump_int(font_dsize[k]);
undump(min_halfword)(max_halfword)(font_params[k]);@/
undump_int(hyphen_char[k]);
undump_int(skew_char[k]);@/
undump(0)(str_ptr)(font_name[k]);
undump(0)(str_ptr)(font_area[k]);@/
undump(0)(255)(font_bc[k]);
undump(0)(255)(font_ec[k]);@/
undump_int(char_base[k]);
undump_int(width_base[k]);
undump_int(height_base[k]);@/
undump_int(depth_base[k]);
undump_int(italic_base[k]);
undump_int(lig_kern_base[k]);@/
undump_int(kern_base[k]);
undump_int(exten_base[k]);
undump_int(param_base[k]);@/
undump(min_halfword)(lo_mem_max)(font_glue[k]);@/
undump(0)(font_mem_size)(bchar_label[k]);
undump(min_quarterword)(non_char)(font_bchar[k]);
undump(min_quarterword)(non_char)(font_false_bchar[k]);
end
@y
@  The way this is done in C makes the reference to
the internal font number meaningless, but putting the code
here preserves the association with the WEB modules.

@<Undump the array info for internal font number |k|@>=
begin undump_things(font_info[0], fmem_ptr);
undump_size(font_base)(font_max)('font max')(font_ptr);
undump_things(font_check[null_font], font_ptr+1-null_font);
undump_things(font_size[null_font], font_ptr+1-null_font);
undump_things(font_dsize[null_font], font_ptr+1-null_font);
undump_things(font_params[null_font], font_ptr+1-null_font);
undump_things(hyphen_char[null_font], font_ptr+1-null_font);
undump_things(skew_char[null_font], font_ptr+1-null_font);
undump_things(font_name[null_font], font_ptr+1-null_font);
undump_things(font_area[null_font], font_ptr+1-null_font);
undump_things(font_bc[null_font], font_ptr+1-null_font);
undump_things(font_ec[null_font], font_ptr+1-null_font);
undump_things(char_base[null_font], font_ptr+1-null_font);
undump_things(width_base[null_font], font_ptr+1-null_font);
undump_things(height_base[null_font], font_ptr+1-null_font);
undump_things(depth_base[null_font], font_ptr+1-null_font);
undump_things(italic_base[null_font], font_ptr+1-null_font);
undump_things(lig_kern_base[null_font], font_ptr+1-null_font);
undump_things(kern_base[null_font], font_ptr+1-null_font);
undump_things(exten_base[null_font], font_ptr+1-null_font);
undump_things(param_base[null_font], font_ptr+1-null_font);
undump_things(font_glue[null_font], font_ptr+1-null_font);
undump_things(bchar_label[null_font], font_ptr+1-null_font);
undump_things(font_bchar[null_font], font_ptr+1-null_font);
undump_things(font_false_bchar[null_font], font_ptr+1-null_font);
end
@z

% The hyphenation patterns.
% 
@x
for k:=0 to trie_max do dump_hh(trie[k]);
dump_int(trie_op_ptr);
for k:=1 to trie_op_ptr do
  begin dump_int(hyf_distance[k]);
  dump_int(hyf_num[k]);
  dump_int(hyf_next[k]);
  end;
@y
dump_things(trie_trl[0], trie_max+1);
dump_things(trie_tro[0], trie_max+1);
dump_things(trie_trc[0], trie_max+1);
dump_int(trie_op_ptr);
dump_things(hyf_distance[1], trie_op_ptr);
dump_things(hyf_num[1], trie_op_ptr);
dump_things(hyf_next[1], trie_op_ptr);
@z

@x
for k:=0 to j do undump_hh(trie[k]);
undump_size(0)(trie_op_size)('trie op size')(j); @+init trie_op_ptr:=j;@+tini
for k:=1 to j do
  begin undump(0)(63)(hyf_distance[k]); {a |small_number|}
  undump(0)(63)(hyf_num[k]);
  undump(min_quarterword)(max_quarterword)(hyf_next[k]);
  end;
@y
undump_things(trie_trl[0], j+1);
undump_things(trie_tro[0], j+1);
undump_things(trie_trc[0], j+1);
undump_size(0)(trie_op_size)('trie op size')(j); @+init trie_op_ptr:=j;@+tini
undump_things(hyf_distance[1], j);
undump_things(hyf_num[1], j);
undump_things(hyf_next[1], j);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.1327] As with TFM files, `eof' here means `have we previously
% encountered the end-of-file', not `are we at the end of the file'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
if (x<>69069)or eof(fmt_file) then goto bad_fmt
@y
if (x<>69069)or feof(fmt_file) then goto bad_fmt
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [50.1328] Eliminate possibly wrong word `preloaded' from format_idents.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
print(" (preloaded format="); print(job_name); print_char(" ");
@y
print(" (format="); print(job_name); print_char(" ");
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [51.1332] `uexit' argument depends on `history'; add call to
% set_paths; make the main program a procedure, so that uses of `eqtb'
% will work.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
@p begin @!{|start_here|}
@y
@p procedure tex_body;
begin @!{|start_here|}
@z

@x
t_open_out; {open the terminal for output}
@y
t_open_out; {open the terminal for output}
{get default file paths from the environment}
set_paths (TEX_FORMAT_PATH_BIT + TEX_INPUT_PATH_BIT + TEX_POOL_PATH_BIT
           + TFM_FILE_PATH_BIT);
@z

@x
start_of_TEX: @<Initialize the output routines@>;
@<Get the first line of input and prepare to start@>;
@y
{terminal kanji stat should be initialized before first output to terminal}
start_of_TEX: @<Initialize kanji stat@>;
@<Initialize the output routines@>;
@<Get the first line of input and prepare to start@>;
{terminal kanji type may be changed by format file}
@<Initialize kanji stat@>;
@z

@x
end_of_TEX: close_files_and_terminate;
final_end: ready_already:=0;
end.
@y
close_files_and_terminate;
final_end: do_final_end;
end {|tex_body|};
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [51.1333] Print new line before termination; switch to editor if
% necessary.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
    slow_print(log_name); print_char(".");
    end;
  end;
@y
    slow_print(log_name); print_char(".");
    end;
  end;
print_ln;
if (edit_name_start<>0) and (interaction>batch_mode) then
    call_edit(str_pool,edit_name_start,edit_name_length,edit_line);
@z

@x 8bit: [1337]
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the the end-of-line-char if it is active@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [52.1338] Core-dump in debugging mode on 0 input.  Under Unix, it's
% not possible to switch into the debugger while a program is running.
% The best approximation is to do a core dump, then run the debugger on
% it later.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
    begin goto breakpoint;@\ {go to every label at least once}
    breakpoint: m:=0; @{'BREAKPOINT'@}@\
    end
@y
    dump_core {Do something to cause a core dump}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% JTeX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
      while not a_open_out(write_file[j]) do
        prompt_file_name("output file name",".tex");
      write_open[j]:=true;
@y
      while not a_open_out(write_file[j]) do
        prompt_file_name("output file name",".tex");
      write_open[j]:=true;
      @<Set kanji |write_file| type@>;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% [54.1376] Add editor-switch variables to globals.
% JTeX modules
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@x
This section should be replaced, if necessary, by any special
modifications of the program
that are necessary to make \TeX\ work at a particular installation.
It is usually best to design your change file so that all changes to
previous sections preserve the section numbering; then everybody's version
will be consistent with the published program. More extensive changes,
which introduce new sections, can be inserted here; then only the index
itself will get a new section number.
@^system dependencies@>
@y
Here is a temporary integer, used as a holder during reading and writing of
TFM files, and a temporary |memory_word|, used in reading/writing format
files.
Also, the variables used to hold ``switch-to-editor'' information.
@^<system dependencies@>

@<Glob...@>=
@!edit_name_start: pool_pointer;
@!edit_name_length,@!edit_line,@!tfm_temp: integer;

@ The |edit_name_start| will be set to point into |str_pool| somewhere after
its beginning if \TeX\ is supposed to switch to an editor on exit.

@<Set init...@>=
edit_name_start:=0;


@ Various modules necessary for `delayed font'. The font defined as a delayed
font is not loaded when defined, but it is loaded when the font is first used.
In other words, it is an on-demmand-loaded font.

We define a new box to express the status of the delayed font. We call such
a box a df-box. It is similar to |glue_spec| but it can be an |equiv| value
of the command.
@d df_spec_size=4
@d df_ref_count(#) == link(#)
@d df_null=0
@d df_font=1
@d df_loaded=2
@d df_share=3
@d df_sharedelayed=4
@d df_fname(#) == mem[#+1].hh.rh
@d df_farea(#) == mem[#+1].hh.lh
@d df_fidtext(#) == mem[#+2].hh.rh
@d df_scaled(#) == mem[#+3].sc
@d df_fnum(#) == mem[#+3].int
@d df_dfref(#) == link(#+3)

@ @<Define additional ref-type box@>=
function new_df_spec(@!dt:small_number;@!fn,@!fa,@!t:str_number):pointer;
var q:pointer; {the new spec}
begin q:=get_node(df_spec_size);@/
type(q):=dt; df_ref_count(q):=null;
df_fname(q):=fn; df_farea(q):=fa; df_fidtext(q):=t;
new_df_spec:=q;
end;

@ @<Destroy additional ref-type box@>=
procedure delete_df_ref(@!p:pointer); {|p| points to a dfont specification}
begin if df_ref_count(p)=null then begin
  if type(p)=df_sharedelayed then delete_df_ref(df_dfref(p));
  free_node(p,df_spec_size);
  end
else decr(df_ref_count(p));
end;

@ @<Cases of |eq_destroy| for additional ref-type box in |equiv_field|@>=
demmand_font: delete_df_ref(equiv_field(w));

@ @<Put each...@>=
primitive("delayedfont",def_dfont,0);@/
@!@:delayedfont_}{\.{\\delayedfont} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
def_dfont: print_esc("delayedfont");

@ @<New prefixed commands@>=
any_mode(def_dfont),

@ The df-box is generated here. It contains the information for loading
the font when it is used.

@<Assignments@>=
def_dfont: new_dfont(a);

@ @<Declare subprocedures needed for delayed font@>=
procedure new_dfont(@!a:small_number);
label done,common_ending;
var u:pointer; {user's font identifier}
@!s:scaled; {stated ``at'' size, or negative of scaled magnification}
@!f:internal_font_number; {runs through existing fonts}
@!t:str_number; {name for the frozen font identifier}
@!old_setting:0..max_selector; {holds |selector| setting}
@!flushable_string:str_number; {string not yet referenced}
@!dftype:small_number;
@!p,@!q:pointer;
@!save_jendline_type:integer;
begin if job_name=0 then open_log_file;
  {avoid confusing \.{texput} with the font name}
@.texput@>
get_r_token; u:=cur_cs;
if u>=hash_base then t:=text(u)
else if u>=single_base then
  if u=null_cs then t:="FONT"@+else t:=u-single_base
else  begin old_setting:=selector; selector:=new_string;
  print("FONT"); print(u-active_base); selector:=old_setting;
@.FONTx@>
  str_room(1); t:=make_string;
  end;
scan_optional_equals; scan_file_name;
dftype:=df_font;
@<Scan the font size spec or the font to share and set |dftype|@>;
if dftype=df_font then begin
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  p:=new_df_spec(df_font,cur_name,cur_area,t); df_scaled(p):=s;
  define(u,demmand_font,p);
  goto done;
 common_ending: define(u,set_font,f);
  eqtb[font_id_base+f]:=eqtb[u]; font_id_text(f):=t;
 done:
  end
else if dftype=df_share then begin
  p:=new_df_spec(df_share,cur_name,cur_area,t); df_fnum(p):=cur_chr;
  define(u,demmand_font,p);
  end
else if dftype=df_sharedelayed then begin
  p:=new_df_spec(df_sharedelayed,cur_name,cur_area,t);
  if type(cur_chr)=df_sharedelayed then q:=df_dfref(cur_chr)
  else q:=cur_chr;
  add_df_ref(q); df_dfref(p):=q;
  define(u,demmand_font,p);
  end
else
  define(u,set_font,null_font);
end;

@ @<Scan the font size spec or the font to share and set |dftype|@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
save_jendlinetype:=jendline_type; jendline_type:=jend_ascii;
if scan_keyword("at") then @<Put the \(p)(positive) `at' size into |s|@>
@.at@>
else if scan_keyword("scaled") then
@.scaled@>
  begin scan_int; s:=-cur_val;
  if (cur_val<=0)or(cur_val>32768) then
    begin print_err("Illegal magnification has been changed to 1000");@/
@.Illegal magnification...@>
    help1("The magnification ratio must be between 1 and 32768.");
    int_error(cur_val); s:=-1000;
    end;
  end
else if scan_keyword("share") then @<Get the font to share@>
@.share@>
else s:=-1000;
name_in_progress:=false; jendline_type:=save_jendline_type

@ @<Get the font to share@>=
begin @<Get the next non-blank non-call token@>;
if cur_cmd=set_font then dftype:=df_share
else if cur_cmd=demmand_font then dftype:=df_sharedelayed
else begin print_err("Improper `share' font");@/
  help1("Delayed font can share tfm with font or delayed font");
  error; dftype:=df_null;
  end
end

@ @<Cases of |print_cmd_chr|...@>=
demmand_font: begin print("delayed font ");
  case type(chr_code) of
  df_font: print("not loaded");
  df_loaded: print("loaded");
  df_share: print("share");
  df_sharedelayed: print("sharedelayed");
  othercases print("ERROR");
  endcases;
  end;

@ @<New prefixed commands@>=
any_mode(demmand_font),

@ Execution of the df-box (|cur_chr|) changes the state of the box and
yields the font number. It is assigned to |cur_cs|.

@<Assignments@>=
demmand_font: load_set_dfont(a,cur_cs,cur_chr);

@ @<Declare subprocedures needed for delayed font@>=
function load_dfont(@!u,@!p:pointer):internal_font_number;
{|u| is used just to get command name in error reporting.}
label done,done1,common_ending;
var s:scaled;
@!tfm_f,@!f:internal_font_number;
@!nom,@!aire:str_number;
@!flushable_string:str_number; {string not yet referenced}
@!q:pointer;
begin
case type(p) of
df_font: begin cur_name:=df_fname(p); cur_area:=df_farea(p); s:=df_scaled(p);
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  f:=read_font_info(u,cur_name,cur_area,s);
  end;
df_loaded: begin f:=df_fnum(p); goto done1; end;
df_share: begin tfm_f:=df_fnum(p);
  cur_name:=df_fname(p); cur_area:=df_farea(p); s:=font_size[tfm_f];
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  nom:=cur_name; aire:=cur_area;
  @<Copy TFM infomation from |tfm_f| to new font |f|@>;
  end;
df_sharedelayed: begin q:=df_dfref(p);
  if type(q)=df_font then begin type(p):=df_font;
    nom:=df_fname(p); aire:=df_farea(p);
    df_fname(p):=df_fname(q); df_farea(p):=df_farea(q);
    df_scaled(p):=df_scaled(q);
    f:=load_dfont(u,p);
    df_fname(p):=nom; df_farea(p):=aire;
    font_name[f]:=nom; font_area[f]:=aire;
    type(q):=df_share; df_fnum(q):=f;
    end
  else begin type(p):=df_share; df_fnum(p):=df_fnum(q);
    f:=load_dfont(u,p);
    end;
  delete_df_ref(q); goto done;
  end;
endcases;
common_ending: type(p):=df_loaded; df_fnum(p):=f;
done1: eq_type(font_id_base+f):=set_font; equiv(font_id_base+f):=f;
font_id_text(f):=df_fidtext(p);
done: load_dfont:=f;
end;

@ @<Copy TFM infomation from |tfm_f| to new font |f|@>=
if (font_ptr=font_max) then begin f:=null_font;
  @<Apologize for not loading the font, |goto done|@>;
  end;
font_ptr:=font_ptr+1; f:=font_ptr; {new font pointer}
char_base[f]:=char_base[tfm_f];
width_base[f]:=width_base[tfm_f];
height_base[f]:=height_base[tfm_f];
depth_base[f]:=depth_base[tfm_f];
italic_base[f]:=italic_base[tfm_f];
lig_kern_base[f]:=lig_kern_base[tfm_f];
kern_base[f]:=kern_base[tfm_f];
exten_base[f]:=exten_base[tfm_f];
param_base[f]:=param_base[tfm_f];
font_check[f]:=font_check[tfm_f];
font_size[f]:=font_size[tfm_f];
font_dsize[f]:=font_dsize[tfm_f];
font_params[f]:=font_params[tfm_f];
font_name[f]:=nom; {This and area should be distinct from TFM file}
font_area[f]:=aire;
font_bc[f]:=font_bc[tfm_f];
font_ec[f]:=font_ec[tfm_f];
font_glue[f]:=font_glue[tfm_f];
bchar_label[f]:=bchar_label[tfm_f];
font_bchar[f]:=font_bchar[tfm_f];
font_false_bchar[f]:=font_false_bchar[tfm_f];
hyphen_char[f]:=hyphen_char[tfm_f];
skew_char[f]:=skew_char[tfm_f];

@ @<Declare subprocedures needed for delayed font@>=
procedure load_set_dfont(@!a,@!u,@!p:pointer);
var f:internal_font_number;
begin
  f:=load_dfont(u,p);
  deq_define(u,set_font,f);
  define(cur_font_loc,data,f);
end;

@ @<Declare subprocedures needed for delayed font@>=
procedure load_dfont_proc;
begin
  cur_chr:=load_dfont(cur_cs,cur_chr);
end;


@ Various modules necessary for JTeX.
From here to the end of the file, JTeX related modules are gathered.

First of all we need an array which holds a correspondence between generic
sub font identifier such as "jsy", "jhira", "ja" and the pointer to
|eqtb| entry which contains the current corresponding font number.

@d max_j_sub_font=33

@<Types ...@>=
s_f_range=1..max_j_sub_font;
s_f_range0=0..max_j_sub_font;

@ @<Glob...@>=
@!j_s_font_pointer: array [s_f_range] of halfword;

@ You need to initialize this array together with entering sub font identifier
into \TeX's hash table.

@d init_end(#) == j_s_font_pointer[#]:=cur_val
@d enter_and_init(#) == primitive(#,set_font,null_font); init_end
@d jsubfp_a = 8

@<Put each...@>=
enter_and_init("jsy")(1);@/
enter_and_init("jroma")(2);@/
enter_and_init("jhira")(3);@/
enter_and_init("jkata")(4);@/
enter_and_init("jgreek")(5);@/
enter_and_init("jrussian")(6);@/
enter_and_init("jkeisen")(7);@/
enter_and_init("ja")(8);@/
enter_and_init("jb")(9);@/
enter_and_init("jc")(10);@/
enter_and_init("jd")(11);@/
enter_and_init("je")(12);@/
enter_and_init("jf")(13);@/
enter_and_init("jg")(14);@/
enter_and_init("jh")(15);@/
enter_and_init("ji")(16);@/
enter_and_init("jj")(17);@/
enter_and_init("jk")(18);@/
enter_and_init("jl")(19);@/
enter_and_init("jm")(20);@/
enter_and_init("jn")(21);@/
enter_and_init("jo")(22);@/
enter_and_init("jp")(23);@/
enter_and_init("jq")(24);@/
enter_and_init("jr")(25);@/
enter_and_init("js")(26);@/
enter_and_init("jt")(27);@/
enter_and_init("ju")(28);@/
enter_and_init("jv")(29);@/
enter_and_init("jw")(30);@/
enter_and_init("jx")(31);@/
enter_and_init("jy")(32);@/
enter_and_init("jz")(33);@/

@ To compute sub font number |f| and character number |c| from JIS code
(ku and ten), we use the following function |compute_f_c|.  The result is
packed into a halfword so that it can be stored as |cur_chr| and can be
used in token list.

@<Utility functions and procedures for Japanese@>=
function compute_f_c(ku,ten:integer):halfword;
label exit;
var f:s_f_range;
    c:eight_bits;
    n:integer;
begin ku:=ku-32; ten:=ten-32;
 compute_f_c:=256+1; {treat invalid char as JIS space (1ku 1ten)}
 if (ku<=0)or((ku>=9)and(ku<=15))or(ku>84) then
   @<Report invalid ku in JIS code and |goto exit|@>;
 if (ten<1)or(ten>94) then @<Report invalid ten in JIS code and |goto exit|@>;
 if ku<=8 then begin case ku of
                     1: begin f:=1; c:=ten end;
                     2: begin f:=1; c:=ten+100 end;
                     3: begin f:=2; c:=ten+32 end;
                     othercases begin f:=ku-1; c:=ten end
                     endcases end
 else if ku<=47 then {Daiichi Suijun}
  begin n:=(ku-16)*94+ten-1; f:=(n div 256)+8; c:=n-(f-8)*256 end
 else {Daini Suijun}
  begin n:=(ku-48)*94+ten-1; f:=(n div 256)+20; c:=n-(f-20)*256 end;
 compute_f_c:=256*f+c;
exit: end;

@ @<Report invalid ku in JIS code and |goto exit|@>=
begin print_err("Japanese text contains an invalid character");
@.Japanese text...@>
help1("First byte of two bytes JIS code is out of proper range (1<=ku<=94)");@/
deletions_allowed:=false; error; deletions_allowed:=true;
goto exit;
end

@ @<Report invalid ten in JIS code and |goto exit|@>=
begin print_err("Japanese text contains an invalid character");
@.Japanese text...@>
help1("Second byte of two bytes JIS code is out of proper range (1<=ten<=94)");@/
deletions_allowed:=false; error; deletions_allowed:=true;
goto exit;
end

@ This is a function to compute ku and ten from internal font number and
character number.

@<Utility ...@>=
function ku_ten_compute(f,c:integer):halfword;
var ku:1..94;
    ten:1..94;
    n:integer;
begin 
 if f<=7 then begin case f of 
                    1: if c>=100 then begin ku:=2; ten:=c-100 end
                                 else begin ku:=1; ten:=c end;
                    2: begin ku:=3; ten:=c-32 end;
                    othercases begin ku:=f+1; ten:=c end
                    endcases end
 else if f<=19 then {Daiichi Suijun}
  begin n:=(f-8)*256+c; ku:=(n div 94)+16; ten:=(n mod 94)+1 end
 else {Daini Suijun}
  begin n:=(f-20)*256+c; ku:=(n div 94)+48; ten:=(n mod 94)+1 end;
 ku_ten_compute:=256*(ku+32)+(ten+32);
end;

@ We use the following table to get sub font number from the internal font
number.

@<Glob...@>=
@!j_font_table: array [internal_font_number] of s_f_range0;

@ @<Initialize table entries...@>=
for k:=font_base to font_max do j_font_table[k]:=0;

@ @<Utility ...@>=
function j_font_p(f:integer): s_f_range0;
begin
j_font_p:=j_font_table[f];
end;

@ Following code is used to specify kanji terminal type and kanji file type.
Kanji code of input and output is controlled by \.{\\kanjiterminaltype} and
\.{\\kanjifiletype}.

@d ascii_only = 0
@d jis_1 = 1 {The third byte for enter kanji is at sign and that for exit
                kanji is J}
@d jis_2 = 2 {at sign and H}
@d jis_3 = 3 {at sign and B}
@d jis_4 = 4 {B and J}
@d jis_5 = 5 {B and H}
@d jis_6 = 6 {B and B}
@d shift_jis = 10 {shift jis code}
@d EUC = 20 {Extended Unix Code, eighth bit is on for both bytes}

@d all_kanji_code == ascii_only,jis_1,jis_2,jis_3,jis_4,jis_5,jis_6,shift_jis,EUC

@ Initialize kanjiterminaltype and kanjifiletype.

@<Initialize table entries...@>=
kanji_terminal_type:=0; {|ascii_only|}
kanji_file_type:=0; {|ascii_only|}

@ @<Utility ...@>=
procedure check_kanji_terminal_type;
begin
  case kanji_terminal_type of
    all_kanji_code: do_nothing;
    othercases begin
      print_err("No such terminal type ");
      print_int(kanji_terminal_type);
      print(", I will change it to 1 (jis)");
      kanji_terminal_type := jis_1;
      help4("kanji terminal type code is one of the following:") @/
           (" 0:[ascii], 1:[JIS,$$@@-$(J], 2:[JIS,$$@@-$(H], 3:[JIS,$$@@-$(B],")@/
           (" 4:[JIS,$$B-$$(J], 5:[JIS,$$B-$(H], 6:[JIS,$$B-$(B],") @/
           ("10:[shift JIS], 20:[Extended Unix Code].");@/
@.kanji terminal type code...@>
      error;
      end;
  endcases;
end;
@#
procedure check_kanji_file_type;
begin
  case kanji_file_type of
    all_kanji_code: do_nothing;
    othercases begin
      print_err("No such file type ");
      print_int(kanji_file_type);
      print(", I will change it to 1 (jis)");
      kanji_file_type := jis_1;
      help4("kanji file type code is one of the following:") @/	
           (" 0:[ascii], 1:[JIS,$$@@-$(J], 2:[JIS,$$@@-$(H], 3:[JIS,$$@@-$(B],")@/
           (" 4:[JIS,$$B-$$(J], 5:[JIS,$$B-$(H], 6:[JIS,$$B-$(B],") @/
           ("10:[shift JIS], 20:[Extended Unix Code].");@/
@.kanji file type code...@>
      error;
      end;
  endcases;
end;

@ The following two functions are called from the external C functions.

@<Utility ...@>=
function get_kanji_terminal_type: integer;
begin
  check_kanji_terminal_type;
  get_kanji_terminal_type := kanji_terminal_type;
end;
@#
function get_kanji_file_type: integer;
begin
  check_kanji_file_type;
  get_kanji_file_type := kanji_file_type;
end;

@ Printing Japanese.

We need to know whether we have printed the first byte of KANJI
or the second.

@d KAN_ASCII = 0
@d KAN_FIRST = 1
@d KAN_SECOND = 2
@d KAN_EIGHT1 = 3
@d KAN_EIGHT2 = 4

@<Types...@>=
@!kan_stat=KAN_ASCII..KAN_EIGHT2;

@ @<Glob...@>=
@!term_kanji_stat : kan_stat;
@!log_kanji_stat : kan_stat;
@!write_kanji_stat : array[0..15] of kan_stat;

@ @<Initialize kanji stat@>=
term_kanji_stat := KAN_ASCII; log_kanji_stat := KAN_ASCII;
@<Set kanji terminal type@>;

@ @<Set init...@>=
for k:=0 to 15 do write_kanji_stat[k] := KAN_ASCII;

@ @<Declare procedures used by |print_char|@>=
procedure check_kanji_terminal_type; forward;
@#
procedure check_kanji_file_type; forward;
@#
function print_char_term(@!s:ASCII_code):boolean;
label exit;
var is_newline:boolean;
begin
  is_newline:=false;
  @<Change term kanji state@>;
  if is_newline then begin
    wterm_cr; term_offset:=0; print_char_term:=true; return;
    end;
  print_char_term:=false;
  if (term_kanji_stat=KAN_FIRST) and
     (term_offset>=max_print_line-1) then begin
    wterm_cr; term_offset:=0;
    end
  else if term_kanji_stat=KAN_EIGHT1 then return
  else if term_kanji_stat=KAN_EIGHT2 then begin
    wterm(xchr[ext_eightbit]);
    term_kanji_stat:=KAN_ASCII;
    end;
  wterm(xchr[s]); incr(term_offset);
  if term_offset>=max_print_line then begin
    wterm_cr; term_offset:=0;
    end;
exit:end;
@#
function print_char_log(@!s:ASCII_code):boolean;
label exit;
var is_newline:boolean;
begin
  is_newline:=false;
  @<Change log kanji state@>;
  if is_newline then begin
    wlog_cr; file_offset:=0; print_char_log:=true; return;
    end;
  print_char_log:=false;
  if (log_kanji_stat=KAN_FIRST) and
     (file_offset>=max_print_line-1) then begin
    wlog_cr; file_offset:=0;
    end
  else if log_kanji_stat=KAN_EIGHT1 then return
  else if log_kanji_stat=KAN_EIGHT2 then begin
    wlog(xchr[ext_eightbit]);
    log_kanji_stat:=KAN_ASCII;
    end;
  wlog(xchr[s]); incr(file_offset);
  if file_offset>=max_print_line then begin
    wlog_cr; file_offset:=0;
    end;
exit:end;

@ @<Change term kanji state@>=
begin
if term_kanji_stat=KAN_FIRST then
  term_kanji_stat:=KAN_SECOND
else if term_kanji_stat=KAN_EIGHT1 then begin
  is_newline:= make_eightbit(s)=new_line_char;
  term_kanji_stat:=KAN_EIGHT2;
  end
else if is_ext_kanji(s) then begin
  if term_kanji_stat=KAN_ASCII then @<Set kanji terminal type@>;
  term_kanji_stat:=KAN_FIRST;
  end
else if is_ext_eightbit(s) then
  term_kanji_stat:=KAN_EIGHT1
else begin
  is_newline:=@<Character |s| is the current new-line character@>;
  term_kanji_stat:=KAN_ASCII;
  end;
end

@ @<Change log kanji state@>=
begin
if log_kanji_stat=KAN_FIRST then
  log_kanji_stat:=KAN_SECOND
else if log_kanji_stat=KAN_EIGHT1 then begin
  is_newline:= make_eightbit(s)=new_line_char;
  log_kanji_stat:=KAN_EIGHT2;
  end
else if is_ext_kanji(s) then begin
  if log_kanji_stat=KAN_ASCII then @<Set kanji log type@>;
  log_kanji_stat:=KAN_FIRST;
  end
else if is_ext_eightbit(s) then
  log_kanji_stat:=KAN_EIGHT1
else begin
  is_newline:=@<Character |s| is the current new-line character@>;
  log_kanji_stat:=KAN_ASCII;
  end;
end

@ @<Print char to |write_file|@>=
begin
is_newline:=false;
if write_kanji_stat[selector]=KAN_FIRST then
  write_kanji_stat[selector]:=KAN_SECOND
else if write_kanji_stat[selector]=KAN_EIGHT1 then begin
  is_newline:= make_eightbit(s)=new_line_char;
  write_kanji_stat[selector]:=KAN_EIGHT2;
  end
else if is_ext_kanji(s) then
  write_kanji_stat[selector]:=KAN_FIRST
else if is_ext_eightbit(s) then
  write_kanji_stat[selector]:=KAN_EIGHT1
else begin
  is_newline:=@<Character |s| is the current new-line character@>;
  write_kanji_stat[selector]:=KAN_ASCII;
  end;
if is_newline then begin
  write_ln(write_file[selector]); return;
  end
else if write_kanji_stat[selector]=KAN_EIGHT1 then
else if write_kanji_stat[selector]=KAN_EIGHT2 then begin
  write(write_file[selector],xchr[ext_eightbit]);
  write_kanji_stat[selector]:=KAN_ASCII;
  end
else
  write(write_file[selector],xchr[s])
end

@ @<Set kanji terminal type@>=
begin
check_kanji_terminal_type;
setoutkanjitype(term_out, kanji_terminal_type);
end

@ @<Set kanji |cur_file| type@>=
begin
check_kanji_file_type;
setinkanjitype(cur_file, kanji_file_type);
end

@ @<Set kanji |read_file| type@>=
begin
check_kanji_file_type;
setinkanjitype(read_file[n], kanji_file_type);
end

@ @<Set kanji log type@>=
begin
check_kanji_file_type;
setoutkanjitype(log_file, kanji_file_type);
end

@ @<Set kanji |write_file| type@>=
begin
check_kanji_file_type;
setoutkanjitype(write_file[j], kanji_file_type);
end

@ @<Print chars in |str_pool| in printable form@>=
while j<str_start[s+1] do begin
  if is_ext_kanji(so(str_pool[j])) then begin
    print_char(so(str_pool[j])); incr(j);
    print_char(so(str_pool[j]));
    end
  else if is_ext_eightbit(so(str_pool[j])) then begin incr(j);
    print(make_eightbit(so(str_pool[j])));
    end
  else
    print(so(str_pool[j]));
  incr(j);
  end

@ @<Utility ...@>=
procedure print_j_char(sub_font:s_f_range;char_no:eight_bits);      
var ku_ten:integer; {to hold ku*256+ten in japanese output}
begin
  ku_ten:=ku_ten_compute(sub_font,char_no);
  print_char(make_ext_kanji(ku_ten div 256));
  print_char(ku_ten mod 256);
end;

@ @<Utility ...@>=
procedure display_j_char(sub_font:s_f_range;char_no:eight_bits);
begin
 if kanji_terminal_type<>0 then print_j_char(sub_font,char_no)
 else begin
  print_char("{");
  print_esc(text(j_s_font_pointer[sub_font]));
  print_esc("char");
  print_int(char_no);
  print_char("}"); end
end;

@ @<Display japanese letter $(|m|,|c|)$@>=
begin {|m| contains sub font number and |c| contains character number}
 display_j_char(m,c)
end

@ Pseudo printing.

@ @<Glob...@>=
@!pseudo_kanji_stat : kan_stat; {|KAN_ASCII..KAN_EIGHT2|}

@ @<Reset |pseudo_kanji_stat|@>=
pseudo_kanji_stat:=KAN_ASCII

@ @<Store char in |trick_buf|@>=
begin
  if pseudo_kanji_stat=KAN_FIRST then begin
    trick_buf[tally mod trick_line] := s;
    tally_disp:=tally_disp+2;
    pseudo_kanji_stat:=KAN_ASCII;
    end
  else if pseudo_kanji_stat=KAN_EIGHT1 then begin
    trick_buf[tally mod trick_line] := s;
    incr(tally_disp);
    pseudo_kanji_stat:=KAN_ASCII;
    end
  else if is_ext_kanji(s) then begin
    trick_buf[tally mod trick_line] := s;
    pseudo_kanji_stat:=KAN_FIRST;
    end
  else if is_ext_eightbit(s) then
    pseudo_kanji_stat:=KAN_EIGHT1
  else begin
    trick_buf[tally mod trick_line] := s;
    incr(tally_disp);
    end
end

@ @<Print the first line of tricky pseudoprint@>=
begin
p:=first_count;
while r>0 do begin
  decr(p);
  if is_ext_eightbit(trick_buf[(p-1) mod trick_line]) then decr(p);
  decr(r);
  end;
if is_ext_char(trick_buf[(p-1) mod trick_line]) then begin
  incr(p); r:=n-1;
  end
else r:=n;
for q:=p to first_count-1 do print_char(trick_buf[q mod trick_line]);
end

@ @<Print the second line of tricky pseudoprint@>=
begin
q:=first_count;
while r>1 do begin
  if is_ext_kanji(trick_buf[q mod trick_line]) then begin
    print_char(trick_buf[q mod trick_line]); decr(r); incr(q);
    end
  else if is_ext_eightbit(trick_buf[q mod trick_line]) then incr(q);
  print_char(trick_buf[q mod trick_line]);
  decr(r); incr(q);
  end;
if (r>0) and not is_ext_char(trick_buf[q mod trick_line]) then
  print_char(trick_buf[q mod trick_line]);
end

@ @<Pseudo print chars in |buffer| in printable form@>=
begin
i:=start;
while i<=j-1 do begin
  if i=loc then set_trick_count;
  if is_ext_kanji(buffer[i]) then begin
    print_char(buffer[i]); incr(i);
    print_char(buffer[i]);
    end
  else if is_ext_eightbit(buffer[i]) then begin incr(i);
    print(make_eightbit(buffer[i]));
    end
  else
    print(buffer[i]);
  incr(i);
  end;
end

@ Reading Japanese.

Find the possibly 8bit char in current position.

@d char_in_cur_pos(#) == begin
  end

@ @<Glob...@>=
@!cur_ext_chr : ASCII_code;

@ @<Determin the effective end of the line@>=
begin
if is_ext_eightbit(buffer[limit-1]) and (limit>1) then
  if make_eightbit(buffer[limit])=end_line_char then j:=limit-1
  else j:=limit+1
else if buffer[limit]=end_line_char then j:=limit
else j:=limit+1
end

@ @<Put the the end-of-line-char if it is active@>=
begin
if end_line_char_inactive then decr(limit)
else if is_eightbit(end_line_char) then begin
  buffer[limit]:=ext_eightbit; incr(limit);
  buffer[limit]:=de_eightbit(end_line_char);
  end
else
  buffer[limit]:=end_line_char
end

@ @<Remove the end-of-line-char@>=
begin
if is_ext_eightbit(buffer[l-1]) and (l>1) then begin
  if make_eightbit(buffer[l])=end_line_char then l:=l-2
  end
else if buffer[l]=end_line_char then decr(l)
end

@ Following routine reset |cur_cmd| and |cur_chr| appropriately so that
japanese letters can readily be made into a token.

@<Read an extended char and reset |cur_cmd| and |cur_chr| appropriately@>=
if is_ext_kanji(cur_chr) then begin cur_cmd := jletter;
  cur_chr:=compute_f_c(de_ext_kanji(cur_chr),buffer[loc]);
  incr(loc);
  state:=mid_line; {while you are reading japanese letter, you are in |mid_line|}
  end
else begin if is_ext_eightbit(cur_chr) then begin
    cur_chr:=make_eightbit(buffer[loc]);
    incr(loc);
    end;
  cur_cmd:=cat_code(cur_chr);
  end

@ Whether the carriage return is regarded as space or not is controlled
by \.{\\jendlinetype}.

@d jend_ascii==0
@d jend_comment_bit==1
@d jend_ignore_bit==2
@d is_jend_comment(#)==odd(#)  {dirty}
@d is_jend_ignore(#)==((#)>=jend_ignore_bit)   {dirty}

@ @<Glob...@>=
@!delayed_cat_ret:boolean; {used to ignore CR after/before jletter}

@ @<Set init...@>=
delayed_cat_ret:=false;

@ @<Check if the last character of the line is japanese,
    change state, and finish line@>=
begin
if jendline_type>jend_ascii then begin
  k:=loc; backward_onechar(k); backward_onechar(k);
  jletter_endline:=is_ext_kanji(buffer[k]);
  if is_jend_comment(jendline_type) and jletter_endline then
    @<Finish line, |goto switch|@>;
  if is_jend_ignore(jendline_type) then begin
    if @<The last character is not ascii punctuation@> then begin
      delayed_cat_ret:=true;
      @<Finish line, |goto switch|@>;
      end;
    end;
  end;
@<Finish line, emit a space@>;
end

@ @<Restore delayed |cat_ret| and return, if appropriate@>=
if delayed_cat_ret then begin {|state=new_line| now}
  delayed_cat_ret:=false;
  if ({jletter_endline and} cur_cmd=spacer) or
     ((not jletter_endline) and cur_cmd<>jletter) then begin
    cur_cmd:=spacer; cur_chr:=" ";
    backward_onechar(loc); return;
    end
  end

@ @<Emit a space, |delayed_cat_ret:=false|, and return@>=
begin cur_cmd:=spacer; cur_chr:=" "; delayed_cat_ret:=false; return;
end

@ @<Check an extended char in control sequence name@>=
if is_ext_char(cur_chr) then begin incr(k);
  if is_ext_kanji(cur_chr) then cat:=jletter
  else cat:=cat_code(make_eightbit(buffer[k]));
  end
else
  cat:=cat_code(cur_chr)

@ @<Put the internal representation of |fc| in |buffer|@>=
ku_ten:=ku_ten_compute(jchr_subfont(fc),jchr_char(fc));
buffer[j]:=make_ext_kanji(ku_ten div 256);
incr(j);
buffer[j]:=ku_ten mod 256;

@ @<Put the internal representation of char in |buffer|@>=
if is_eightbit(buffer[j]) then begin
  buffer[j+1]:=de_eightbit(buffer[j]); buffer[j]:=ext_eightbit; incr(j);
  end

@ ascii cat_ret japanese

@d ascii_norm=0
@d ascii_punct=1

@<Glob...@>=
@!ascii_punct_table: array [0..max_ascii_tab] of 0..1;

@ @<Initialize table entries...@>=
for k:=0 to max_ascii_tab do ascii_punct_table[k]:=ascii_norm;

@ New primitive \.{\\asciipunct}.

@<Put each...@>=
primitive("asciipunct",set_asciipunct,0);@/
@!@:asciipunct_}{\.{\\asciipunct} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_asciipunct: print_esc("asciipunct");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_asciipunct): set_asciipunct_table;

@ Read a japanese or ascii char and set its asciipunct code.

@<Declare act...@>=
procedure set_asciipunct_table;
var c:halfword;
begin scan_char_num; c:=cur_val; scan_int; ascii_punct_table[c]:=cur_val;
end;

@ @<The last character is not ascii punctuation@>=
  (ascii_punct_table[buffer[loc-2]]<>ascii_punct)


@ This procedure is similar to |scan_chr_num| ([435]).

@<Declare procedures that scan restricted classes of integers@>=
procedure scan_j_char_num;
begin scan_int;
  if (cur_val<0) or (cur_val>8703) then {8703="21FF, subfont 33, char 255}
  begin print_err("Bad japanese character code");
  help3("Japanese character number (including ascii character) must be")@/
("less than 8703(=21FF in hexadecimal).")@/
("I changed this on to zero."); @/
int_error(cur_val); cur_val:=0; end;
end;

@ width and height+depth of japanese zenkaku character.

@<The zw width for current jfont@>=
param(16)(equiv(j_s_font_pointer[jsubfp_a]))

@ @<The zh height for current jfont@>=
param(17)(equiv(j_s_font_pointer[jsubfp_a]))

@ \.{\\string} and a japanese char ([464]).

@<get token of a char from |str_pool|@>=
if is_ext_char(t) then begin incr(k);
  if is_ext_kanji(t) then
    t:=j_letter_token_flag+compute_f_c(de_ext_kanji(t),so(str_pool[k]))
  else
    t:=other_token+make_eightbit(so(str_pool[k]));
  end
else if t=" " then t:=space_token
else t:=other_token+t


@ Pretend to autoload japanese subfonts.

@<Declare subprocedures needed for delayed font@>=
function font_jsubf(@!sf:s_f_range):internal_font_number;
var f:internal_font_number;
@!jsubf:pointer;
begin
jsubf := j_s_font_pointer[sf];
if eq_type(jsubf) = set_font then font_jsubf := equiv(jsubf)
else if eq_type(jsubf) = demmand_font then begin
  f := load_dfont(jsubf,equiv(jsubf));
  deq_define(jsubf,set_font,f);
  j_font_table[f] := sf;
  font_jsubf := f;
  end
else begin
  print_err("Improper japanese subfont "); print_cs(jsubf);
  help2("Commands that have the same name as japanese subfont")@/
  ("should not be defined");
  error; font_jsubf := null_font;
  end
end;

@ @<|cur_chr| is jis space@>=
cur_chr=256+1

@ @<set |main_i| for JIS space@>=
main_i.b2:=no_tag


@ Kinsoku shori.

Insertion of nobreak (maximum penalty) is forced when a japanese character
cannot appear at the beginning of a line or at the end of a line. (This is
called ``Kinsoku shori'' in japanese.
|jintercharskip| is inserted when both previous character and the current
character are japanese characters.

@ Some japanese characters cannot appear at the beginning of a line
(This is called "gyoutou-kinsoku") and several other characters cannot
appear at the end of a line ("gyoumatsu-kinsoku").  Special processing
of these characters is "Kinsoku shori".
This effect is realized by omitting the insertion of |jintercharskip| or
|jasciikanjiskip| before
gyoutou-kinsoku character and after a gyoumatsu-kinsoku character.

Following constants and Kinsoku table are used in Kinsoku shori.

@d no_kinsoku==0 {You don't need to worry about Kinsoku shori}
@d pre_kinsoku==1 {This character shouldn't appear at the beginning of a line}
@d post_kinsoku==2 {This shouldn't be the last character of a line}

@d max_ascii_tab==127
@d max_jsy_tab==255
@d max_jhira_tab==95
@d max_jkata_tab==95

@<Glob...@>=
@!ascii_kinsoku_table: array [0..max_ascii_tab] of 0..2; 
@!jsy_kinsoku_table: array [0..max_jsy_tab] of 0..2;
@!jhira_kinsoku_table: array [0..max_jhira_tab] of 0..2;
@!jkata_kinsoku_table: array [0..max_jkata_tab] of 0..2;

@ Initialization of Kinsoku table (temporary).  You must be able to change the
data in this table from plain file or on line using new primitive.
Also you need to dump the info when the primitive is introduced and used in
jplain.tex.

@<Initialize table entries...@>=
for k:=0 to max_ascii_tab do ascii_kinsoku_table[k]:=no_kinsoku;
for k:=0 to max_jsy_tab do jsy_kinsoku_table[k]:=no_kinsoku;
for k:=0 to max_jhira_tab do jhira_kinsoku_table[k]:=no_kinsoku;
for k:=0 to max_jkata_tab do jkata_kinsoku_table[k]:=no_kinsoku;

{These will be done in jplain.tex
|ascii_kinsoku_table[34]:=post_kinsoku|; {"}
|ascii_kinsoku_table[39]:=post_kinsoku|; {'}
|ascii_kinsoku_table[40]:=post_kinsoku|; {(}
|ascii_kinsoku_table[41]:=pre_kinsoku|; {)}
|ascii_kinsoku_table[44]:=pre_kinsoku|; {,}
|ascii_kinsoku_table[46]:=pre_kinsoku|; {.}
|ascii_kinsoku_table[58]:=pre_kinsoku|; {:}
|ascii_kinsoku_table[59]:=pre_kinsoku|; {;}
|ascii_kinsoku_table[60]:=post_kinsoku|; {<}
|ascii_kinsoku_table[62]:=pre_kinsoku|; {>}
|ascii_kinsoku_table[63]:=pre_kinsoku|; {?}
|ascii_kinsoku_table[91]:=post_kinsoku|; {[}
|ascii_kinsoku_table[93]:=pre_kinsoku|; {]}
|ascii_kinsoku_table[96]:=post_kinsoku|; {`}
|ascii_kinsoku_table[123]:=post_kinsoku|; {curly open bracket}
|ascii_kinsoku_table[125]:=pre_kinsoku|; {curly close bracket}

|jsy_kinsoku_table[38]:=post_kinsoku|;
|jsy_kinsoku_table[40]:=post_kinsoku|;
|jsy_kinsoku_table[42]:=post_kinsoku|;
|jsy_kinsoku_table[44]:=post_kinsoku|;
|jsy_kinsoku_table[46]:=post_kinsoku|;
|jsy_kinsoku_table[48]:=post_kinsoku|;
|jsy_kinsoku_table[50]:=post_kinsoku|;
|jsy_kinsoku_table[52]:=post_kinsoku|;
|jsy_kinsoku_table[54]:=post_kinsoku|;
|jsy_kinsoku_table[56]:=post_kinsoku|;
|jsy_kinsoku_table[58]:=post_kinsoku|;
|jsy_kinsoku_table[79]:=post_kinsoku|;
|jsy_kinsoku_table[80]:=post_kinsoku|;
|jsy_kinsoku_table[81]:=post_kinsoku|;
|jsy_kinsoku_table[82]:=post_kinsoku|;
|jsy_kinsoku_table[87]:=post_kinsoku|;
|jsy_kinsoku_table[88]:=post_kinsoku|;

|jsy_kinsoku_table[2]:=pre_kinsoku|;
|jsy_kinsoku_table[3]:=pre_kinsoku|;
|jsy_kinsoku_table[4]:=pre_kinsoku|;
|jsy_kinsoku_table[5]:=pre_kinsoku|;
|jsy_kinsoku_table[6]:=pre_kinsoku|;
|jsy_kinsoku_table[7]:=pre_kinsoku|;
|jsy_kinsoku_table[8]:=pre_kinsoku|;
|jsy_kinsoku_table[9]:=pre_kinsoku|;
|jsy_kinsoku_table[10]:=pre_kinsoku|;
|jsy_kinsoku_table[11]:=pre_kinsoku|;
|jsy_kinsoku_table[12]:=pre_kinsoku|;
|jsy_kinsoku_table[19]:=pre_kinsoku|;
|jsy_kinsoku_table[20]:=pre_kinsoku|;
|jsy_kinsoku_table[21]:=pre_kinsoku|;
|jsy_kinsoku_table[22]:=pre_kinsoku|;
|jsy_kinsoku_table[23]:=pre_kinsoku|;
|jsy_kinsoku_table[25]:=pre_kinsoku|;
|jsy_kinsoku_table[28]:=pre_kinsoku|;
|jsy_kinsoku_table[29]:=pre_kinsoku|;
|jsy_kinsoku_table[30]:=pre_kinsoku|;
|jsy_kinsoku_table[39]:=pre_kinsoku|;
|jsy_kinsoku_table[41]:=pre_kinsoku|;
|jsy_kinsoku_table[43]:=pre_kinsoku|;
|jsy_kinsoku_table[45]:=pre_kinsoku|;
|jsy_kinsoku_table[47]:=pre_kinsoku|;
|jsy_kinsoku_table[49]:=pre_kinsoku|;
|jsy_kinsoku_table[51]:=pre_kinsoku|;
|jsy_kinsoku_table[53]:=pre_kinsoku|;
|jsy_kinsoku_table[55]:=pre_kinsoku|;
|jsy_kinsoku_table[57]:=pre_kinsoku|;
|jsy_kinsoku_table[59]:=pre_kinsoku|;
|jsy_kinsoku_table[75]:=pre_kinsoku|;
|jsy_kinsoku_table[76]:=pre_kinsoku|;
|jsy_kinsoku_table[77]:=pre_kinsoku|;
|jsy_kinsoku_table[78]:=pre_kinsoku|;

|jhira_kinsoku_table[1]:=pre_kinsoku|;
|jhira_kinsoku_table[3]:=pre_kinsoku|;
|jhira_kinsoku_table[5]:=pre_kinsoku|;
|jhira_kinsoku_table[7]:=pre_kinsoku|;
|jhira_kinsoku_table[9]:=pre_kinsoku|;
|jhira_kinsoku_table[35]:=pre_kinsoku|;
|jhira_kinsoku_table[67]:=pre_kinsoku|;
|jhira_kinsoku_table[69]:=pre_kinsoku|;
|jhira_kinsoku_table[71]:=pre_kinsoku|;
|jhira_kinsoku_table[78]:=pre_kinsoku|;

|jkata_kinsoku_table[1]:=pre_kinsoku|;
|jkata_kinsoku_table[3]:=pre_kinsoku|;
|jkata_kinsoku_table[5]:=pre_kinsoku|;
|jkata_kinsoku_table[7]:=pre_kinsoku|;
|jkata_kinsoku_table[9]:=pre_kinsoku|;
|jkata_kinsoku_table[35]:=pre_kinsoku|;
|jkata_kinsoku_table[67]:=pre_kinsoku|;
|jkata_kinsoku_table[69]:=pre_kinsoku|;
|jkata_kinsoku_table[71]:=pre_kinsoku|;
|jkata_kinsoku_table[78]:=pre_kinsoku|;
|jkata_kinsoku_table[85]:=pre_kinsoku|;
|jkata_kinsoku_table[86]:=pre_kinsoku|;}

@ New primitive \.{\\kinsokucode}.

@<Put each...@>=
primitive("kinsokucode",set_kinsoku_code,0);@/
@!@:kinsokucode_}{\.{\\kinsokucode} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_kinsoku_code: print_esc("kinsokucode");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_kinsoku_code): set_kinsoku_table;

@ Read a japanese or ascii char and set its kinsoku code.

@<Declare act...@>=
procedure set_kinsoku_table;
var @!p,@!q:pointer; {for temporary short-term use}
@!n:integer; {ditto}
begin
scan_j_char_num; p:=cur_val; scan_optional_equals; scan_int;
if ((cur_val<0) or (cur_val>2)) then begin
 print_err("Invalid Kinsoku code ("); print_int(cur_val); print_char(")");@/
 help2("Kinsoku code must be 0(no kinsoku), 1(pre kinsoku) or 2(post kinsoku).")@/
("I'm going to use 0 instead of that illegal code value.");@/
 error; cur_val:=0; end;
if p<=max_ascii_tab then {set Kinsoku code for an ASCII character}
 ascii_kinsoku_table[p]:=cur_val
else begin
 n:=p div 256; q:=p mod 256; {subfont number in n and character number in q}
 if ((n<=0)or(n=2)or(n>4)) then begin
  print_err("You cannot set Kinsoku code for this character:");
  display_j_char(n,q);
  help2("Kinsoku code can be set only for ascii character, japanese symbols,")@/
       ("hiragana and katakana.  So I will ignore this.");@/
  error; end
 else if n=1 then jsy_kinsoku_table[q]:=cur_val
        else if n=3 then jhira_kinsoku_table[q]:=cur_val
          else if n=4 then jkata_kinsoku_table[q]:=cur_val;
 end;
end;

@ Fake chars.

@d no_fake==0
@d fake_jchar==1
@d fake_char==2
@d fake_math==3

@ New primitive \.{\\fakejchar}, \.{\\fakechar}.

@<Put each...@>=
primitive("fakejchar",faker,fake_jchar);@/
@!@:fakejchar_}{\.{\\fakejchar} primitive@>
primitive("fakechar",faker,fake_char);@/
@!@:fakechar_}{\.{\\fakechar} primitive@>
primitive("fakemath",faker,fake_math);@/
@!@:fakemath_}{\.{\\fakemath} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
faker: case chr_code of
  fake_jchar: print_esc("fakejchar");
  fake_char: print_esc("fakechar");
  fake_math: print_esc("fakemath");
  endcases;

@ Kinsoku shori.

@<Glob...@>=
@!main_c:halfword;
@!prev_sf:sf_range0; {subfont of the previous character}
@!prev_c:halfword; {the previous character}
@!kinsoku_shori:boolean; {used in Kinsoku shori routine}
@!burasage_shori:boolean; {used in Burasage shori routine}
@!prev_jkern,cur_jkern:eight_bits;
@!prev_jkern_info:integer;

@ @<Kinsoku shori; insert or omit glue before jletter@>=
begin
if tail <> head then
  if is_char_node(tail) then
    if j_font_p(font(tail)) <> 0 then begin
      prev_sf:=j_font_p(font(tail)); prev_c:=character(tail);
      @<Insert or omit |jintercharskip| using Kinsoku table@>;
      end
    else begin prev_sf:=0; prev_c:=character(tail);
      @<Insert or omit |jasciikanjiskip| before jletter using Kinsoku table@>;
      end
  else if type(tail) = math_node then
    @<Insert or omit |jmathkanjiskip| before jletter using Kinsoku table@>
else {or the case tail is space}
  @<Left boundary of japanese char@>
end

@ @<Kinsoku shori; insert or omit glue after jletter@>=
begin
if tail <> head then
  if is_char_node(tail) and j_font_p(font(tail)) <> 0 then  begin
    prev_sf:=j_font_p(font(tail)); prev_c:=character(tail);
    @<Insert or omit |jasciikanjiskip| after jletter using Kinsoku table@>;
    end
end

@ @<Kinsoku shori; insert or omit glue and |goto main_loop_move|,...@>=
if prev_cmd=faker then begin
  if prev_c=fake_jchar then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |jintercharskip|@>;
      end
    else begin
      kinsoku_shori:=false;
      if ascii_kinsoku_table[cur_chr]=pre_kinsoku then kinsoku_shori:=true;
      if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
      end;
    goto main_loop_move;
    end
  else if prev_c=fake_char then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
      goto main_loop_move;
      end
    end
  else if prev_c=fake_math then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |jmathkanjiskip|@>;
      goto main_loop_move;
      end
    end
  end
else if cur_cmd=jletter then begin
  if prev_cmd=jletter then begin
    prev_sf:=jchr_subfont(prev_c); prev_c:=jchr_char(prev_c);
    @<Insert or omit |jintercharskip| using Kinsoku table@>;
    end
  else begin wrapup(rt_hit); prev_sf:=0;
    @<Insert or omit |jasciikanjiskip| before jletter using Kinsoku table@>;
    end;
  goto main_loop_move;
  end
else if prev_cmd=jletter then begin
  prev_sf:=jchr_subfont(prev_c); prev_c:=jchr_char(prev_c);
  @<Insert or omit |jasciikanjiskip| after jletter using Kinsoku table@>;
  goto main_loop_move;
  end

@ Insertion of glue between jletter and math is done in |after_math| ([1194]).

@<Kinsoku shori; insert or omit glue between jletter and math@>=
if tail <> head then
  if is_char_node(tail) then if j_font_p(font(tail)) <> 0 then begin
    prev_sf:=j_font_p(font(tail)); prev_c:=character(tail);
    @<Insert or omit |jmathkanjiskip| after jletter using Kinsoku table@>;
    end

@ Kinsoku shori (between jletter and jletter)

@<Insert or omit |jintercharskip| using Kinsoku table@>=
begin
  kinsoku_shori:=false; burasage_shori:=false;
  prev_jkern:=no_jkern; cur_jkern:=no_jkern;
  @<Test of jletter post-kinsoku@>;
  @<Test of burasage and jkern@>;
  @<Test of jletter pre-kinsoku@>;
  if @<interchar jkern@> then @<Do interchar jkern@>
  else if burasage_shori then @<Burasage shori@>;
  if not kinsoku_shori then @<Insert |jintercharskip|@>;
end

@ Kinsoku shori (between jletter and ascii)

@<Insert or omit |jasciikanjiskip| after jletter using Kinsoku table@>=
begin
  kinsoku_shori:=false; burasage_shori:=false;
  prev_jkern:=no_jkern; cur_jkern:=no_jkern;
  @<Test of jletter post-kinsoku@>;
  @<Test of burasage and jkern@>;
  if ascii_kinsoku_table[cur_chr]=pre_kinsoku then kinsoku_shori:=true;
  if @<interchar jkern@> then @<Do interchar jkern@>
  else if burasage_shori then @<Burasage shori@>;
  if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
end

@ Kinsoku shori (between ascii and jletter)

@<Insert or omit |jasciikanjiskip| before jletter using Kinsoku table@>=
begin
  kinsoku_shori:=ascii_kinsoku_table[prev_c]=post_kinsoku;
  @<Test of jletter pre-kinsoku@>;
  if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
end

@ Kinsoku shori (between jletter and math)

@<Insert or omit |jmathkanjiskip| after jletter using Kinsoku table@>=
begin
  kinsoku_shori:=false;
  @<Test of jletter post-kinsoku@>;
  if not kinsoku_shori then @<Insert |jmathkanjiskip|@>;
end

@ Kinsoku shori (between math and jletter)

@<Insert or omit |jmathkanjiskip| before jletter using Kinsoku table@>=
begin
  kinsoku_shori:=false;
  @<Test of jletter pre-kinsoku@>;
  if not kinsoku_shori then @<Insert |jmathkanjiskip|@>;
end

@ @<Test of jletter pre-kinsoku@>=
case jchr_subfont(cur_chr) of
 1: if main_c<=255 then
      if jsy_kinsoku_table[main_c]=pre_kinsoku then kinsoku_shori:=true;
 3: if main_c<=94 then
      if jhira_kinsoku_table[main_c]=pre_kinsoku then kinsoku_shori:=true;
 4: if main_c<=94 then
      if jkata_kinsoku_table[main_c]=pre_kinsoku then kinsoku_shori:=true;
 othercases do_nothing
endcases

@ @<Test of jletter post-kinsoku@>=
case prev_sf of 
 1: if prev_c<=255 then
      if jsy_kinsoku_table[prev_c]=post_kinsoku then kinsoku_shori:=true;
 3: if prev_c<=94 then
      if jhira_kinsoku_table[prev_c]=post_kinsoku then kinsoku_shori:=true;
 4: if prev_c<=94 then
      if jkata_kinsoku_table[prev_c]=post_kinsoku then kinsoku_shori:=true;
 othercases do_nothing
endcases

@ @<Insert |jintercharskip|@>=
begin
if j_interchar_skip=zero_glue then
  tail_append(new_param_glue(def_j_interchar_skip_code))
else
  tail_append(new_param_glue(j_interchar_skip_code))
end

@ @<Insert |jasciikanjiskip|@>=
begin
if j_ascii_kanji_skip=zero_glue then
  tail_append(new_param_glue(def_j_ascii_kanji_skip_code))
else
  tail_append(new_param_glue(j_ascii_kanji_skip_code))
end

@ @<Insert |jmathkanjiskip|@>=
begin
if j_math_kanji_skip=zero_glue then
  tail_append(new_param_glue(def_j_math_kanji_skip_code))
else
  tail_append(new_param_glue(j_math_kanji_skip_code))
end

@ @<Insert |jspaceskip|@>=
begin
if j_space_skip=zero_glue then
  tail_append(new_param_glue(def_j_space_skip_code))
else
  tail_append(new_param_glue(j_space_skip_code))
end


@ Burasage shori.
This is an experimental hack.

@d no_burasage==0
@d burasage==1

@<Glob...@>=
@!jsy_burasage_table: array [0..max_jsy_tab] of 0..1;

@ @<Initialize table entries...@>=
for k:=0 to max_jsy_tab do jsy_burasage_table[k]:=no_burasage;

@ New primitive \.{\\burasage}.

@<Put each...@>=
primitive("burasage",set_burasage,0);@/
@!@:burasage_}{\.{\\burasage} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_burasage: print_esc("burasage");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_burasage): set_burasage_table;

@ Read a japanese or ascii char and set its burasage code.

@<Declare act...@>=
procedure set_burasage_table;
var p:halfword;
f:s_f_range;
c:eight_bits;
begin
scan_j_char_num; p:=cur_val; scan_optional_equals; scan_int;
if ((cur_val<0) or (cur_val>1)) then begin
 print_err("Invalid Burasage code ("); print_int(cur_val); print_char(")");@/
 help2("Burasage code must be 0(no burasage) or 1(burasage).")@/
      ("I'm going to use 0 instead of that illegal code value.");@/
 error; cur_val:=0; end;
if p<=max_ascii_tab then {set Burasage code for an ASCII character}
 print_err("You cannot set Burasage code for ascii character.")
else begin
 f:=jchr_subfont(p); c:= jchr_char(p);
 if f<>1 then begin
  print_err("You cannot set Burasage code for this character:");
  display_j_char(f,c);
  help2("Burasage code can be set only for japanese symbols.")@/
       ("So I will ignore this.");@/
  error;
  end
 else jsy_burasage_table[c]:=cur_val;
 end;
end;

@ burasage flag
@d br_kin==0
@d br_norm==1
@d br_bnd==2
@<Types...@>=
@!br_stat=br_kin..br_bnd;

@ @<Declare act...@>=
procedure burasage_char(@!p:pointer;@!br:br_stat);
var q:four_quarters;
@!hd:eight_bits; {|height_depth| byte}
@!b:pointer; {the new box and its character node}
@!f:internal_font_number;
@!c:quarterword;
begin c:=character(p); f:=font(p);
q:=char_info(f)(c);
tail_append(p);
if br=br_kin then
else begin tail_append(new_kern(-char_width(f)(q)));
  tail_append(new_penalty(1));
  b:=new_spec(zero_glue);
  width(b):=char_width(f)(q);
  tail_append(new_glue(b));
  if br=br_norm then tail_append(new_penalty(0));
  end;
end;


@ Kerning for japanese char.
This is an experimental hack.

@d no_jkern==0
@d pre_jkern==1
@d post_jkern==2
@d inter_jkern==3
@d bpre_jkern==4
@d bpost_jkern==5
@d pre_jkern_bit==1
@d post_jkern_bit==2
@d inter_jkern_bit==4
@d bpre_jkern_bit==8
@d bpost_jkern_bit==16
@d is_pre_jkern(#)==odd((#) div  pre_jkern_bit)
@d is_post_jkern(#)==odd((#) div  post_jkern_bit)
@d is_inter_jkern(#)==odd((#) div  inter_jkern_bit)
@d is_bpre_jkern(#)==odd((#) div  bpre_jkern_bit)
@d is_bpost_jkern(#)==odd((#) div  bpost_jkern_bit)
@d max_jkern_info=100

@<Glob...@>=
@!jsy_jkern_table: array [0..max_jsy_tab] of eight_bits;
@!jsy_bpre_jkern: array [0..max_jsy_tab] of pointer;
@!jkern_info: array [0..max_jkern_info] of integer;
@!jkern_inter_glue1: array [0..max_jkern_info] of pointer;
@!jkern_inter_glue2: array [0..max_jkern_info] of pointer;
@!last_jkern_info: integer;

@ @<Initialize table entries...@>=
for k:=0 to max_jsy_tab do jsy_jkern_table[k]:=no_jkern;
last_jkern_info:=0;

@ New primitive \.{\\jkern}.

@<Put each...@>=
primitive("jkern",set_jkern,0);@/
@!@:jkern_}{\.{\\jkern} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_jkern: print_esc("jkern");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_jkern): set_jkern_table;

@ Read a japanese or ascii char and set its jkern code.

@<Declare act...@>=
procedure set_jkern_table;
label exit;
var c1,c2:halfword;
cc:integer;
p,q:pointer;
begin scan_int;
if (cur_val<no_jkern) or (bpost_jkern<cur_val) then begin
  print_err("Invalid jkern code ("); print_int(cur_val); print_char(")");@/
  error; help0; return;
  end;
case cur_val of
no_jkern: begin scan_j_char_num;
  if jchr_subfont(cur_val)=1 then
    jsy_jkern_table[jchr_char(cur_val)]:=no_jkern;
  end;
inter_jkern: begin scan_j_char_num; c1:=cur_val;
  scan_glue(glue_val); p:=cur_val;
  scan_j_char_num; c2:=cur_val;
  scan_glue(glue_val); q:=cur_val;
  if jchr_subfont(c1)=1 then begin cc:=(256*256)*c1+c2;
    c1:=jchr_char(c1);
    jsy_jkern_table[c1]:=inter_jkern_bit;
    jkern_info[last_jkern_info]:=cc;
    jkern_inter_glue1[last_jkern_info]:=p;
    jkern_inter_glue2[last_jkern_info]:=q;
    incr(last_jkern_info);
    end;
  end;
bpre_jkern: begin scan_glue(glue_val); p:=cur_val;
  scan_j_char_num;
  if jchr_subfont(cur_val)=1 then begin c1:=jchr_char(cur_val);
    jsy_jkern_table[c1]:=bpre_jkern_bit;
    jsy_bpre_jkern[c1]:=p;
    end;
  end;
othercases begin
  print_err("Sorry, this case of jkern not implemented");
  help0; error
  end
endcases;
exit: end;

@ @<Declare act...@>=
function get_jkern_info_index(cc:integer):integer;
label exit;
var i:integer;
begin i:=last_jkern_info-1;
  while i>=0 do begin
    if jkern_info[i]=cc then begin
      get_jkern_info_index:=i; return;
      end;
    decr(i)
  end;
  get_jkern_info_index:=-1;
exit: end;

@ @<Burasage shori@>=
begin tail:=cur_q;
  {|link(cur_q)| points prev char}
  if kinsoku_shori then burasage_char(link(cur_q),br_kin)
  else burasage_char(link(cur_q),br_norm);
  if is_bpre_jkern(cur_jkern) then begin
    tail_append(new_glue(jsy_bpre_jkern[main_c]));
    goto main_loop_move;
  end;
end

@ @<Test of burasage and jkern@>=
begin
if prev_sf=1 then
  if prev_c<=255 then begin
    if jsy_burasage_table[prev_c]=burasage then burasage_shori:=true;
    prev_jkern:=jsy_jkern_table[prev_c];
    if @<interchar jkern@> then begin
      prev_jkern_info:=
        get_jkern_info_index((prev_sf*256+prev_c)*(256*256)+cur_chr);
      if prev_jkern_info<0 then prev_jkern:=prev_jkern-inter_jkern_bit;
      end;
    end;
if jchr_subfont(cur_chr)=1 then
  if main_c<=255 then begin
    cur_jkern:=jsy_jkern_table[main_c];
    end;
end

@ @<interchar jkern@>=is_inter_jkern(prev_jkern)

@ @<Do interchar jkern@>=
begin
  tail_append(new_glue(jkern_inter_glue1[prev_jkern_info]));
  tail_append(lig_stack);
  tail_append(new_glue(jkern_inter_glue2[prev_jkern_info]));
  goto big_switch;
end

@ @<Left boundary of japanese char@>=
begin
if jchr_subfont(cur_chr)=1 then
  if is_bpre_jkern(jsy_jkern_table[jchr_char(cur_chr)]) then
    tail_append(new_glue(jsy_bpre_jkern[jchr_char(cur_chr)]))
end

@ @<Right boundary of japanese char@>=
begin
if jchr_subfont(prev_c)=1 then
if jsy_burasage_table[jchr_char(prev_c)]=burasage then begin
  tail:=cur_q;
  {|link(cur_q)| points prev char}
  if cur_cmd=par_end then burasage_char(link(cur_q),br_bnd)
  else burasage_char(link(cur_q),br_norm);
  goto reswitch;
  end
end


@ Dump.

@<Dump the japanese sub font pointer@>=
dump_things(j_s_font_pointer[1], max_j_sub_font)

@ @<Undump the japanese sub font pointer@>=
undump_things(j_s_font_pointer[1], max_j_sub_font)

@ @<Dump the Kinsoku tables@>=
dump_things(ascii_punct_table[0], max_ascii_tab+1);
dump_things(ascii_kinsoku_table[0], max_ascii_tab+1);
dump_things(jsy_kinsoku_table[0], max_jsy_tab+1);
dump_things(jhira_kinsoku_table[0], max_jhira_tab+1);
dump_things(jkata_kinsoku_table[0], max_jkata_tab+1);
dump_things(jsy_burasage_table[0], max_jsy_tab+1);
dump_things(jsy_jkern_table[0], max_jsy_tab+1);

@ @<Undump the Kinsoku tables@>=
undump_things(ascii_punct_table[0], max_ascii_tab+1);
undump_things(ascii_kinsoku_table[0], max_ascii_tab+1);
undump_things(jsy_kinsoku_table[0], max_jsy_tab+1);
undump_things(jhira_kinsoku_table[0], max_jhira_tab+1);
undump_things(jkata_kinsoku_table[0], max_jkata_tab+1);
undump_things(jsy_burasage_table[0], max_jsy_tab+1);
undump_things(jsy_jkern_table[0], max_jsy_tab+1);

@ @<Dump the |j_font_table|@>=
dump_things(j_font_table[null_font], font_ptr+1-null_font)

@ @<Undump the |j_font_table|@>=
undump_things(j_font_table[null_font], font_ptr+1-null_font)

@z
