<%
' Dec 14, 2002 use new convert to plain logic
' VP-ASP 5.00
   ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   ':::                                                             :::
   ':::  This script performs 'RC4' Stream Encryption               :::
   ':::  (Based on what is widely thought to be RSA's RC4           :::
   ':::  algorithm. It produces output streams that are identical   :::
   ':::  to the commercial products)                                :::
   ':::                                                             :::
   ':::  This script is Copyright  1999 by Mike Shaffer            :::
   ':::  ALL RIGHTS RESERVED WORLDWIDE 
   ':::  Used with permission of the Author
   ':::  mshaffer@nkn.net at www.noumenonlabs.com
   ':::                                                             :::
   ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   Dim sbox(255)
   Dim key(255)
  
   Sub EnDeCryptInit(strPwd)
   ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   ':::  This routine called by EnDeCrypt function. Initializes the :::
   ':::  sbox and the key array)                                    :::
   ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

      dim tempSwap
      dim a
      dim b, intLength

      intLength = len(strPwd)
      For a = 0 To 255
         key(a) = asc(mid(strpwd, (a mod intLength)+1, 1))
         sbox(a) = a
      next

      b = 0
      For a = 0 To 255
         b = (b + sbox(a) + key(a)) Mod 256
         tempSwap = sbox(a)
         sbox(a) = sbox(b)
         sbox(b) = tempSwap
      Next
   
   End Sub
   
   Function EnDeCrypt(plaintxt, psw)
   ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   ':::  This routine does all the work. Call it both to ENcrypt    :::
   ':::  and to DEcrypt your data.                                  :::
   ':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

      dim temp
      dim a
      dim i
      dim j
      dim k
      dim cipherby
      dim cipher

      i = 0
      j = 0
      EnDecryptInit psw

      For a = 1 To Len(plaintxt)
         i = (i + 1) Mod 256
         j = (j + sbox(i)) Mod 256
         temp = sbox(i)
         sbox(i) = sbox(j)
         sbox(j) = temp
   
         k = sbox((sbox(i) + sbox(j)) Mod 256)

         cipherby = Asc(Mid(plaintxt, a, 1)) Xor k
         cipher = cipher & Chr(cipherby)
      Next

      EnDeCrypt = cipher

   End Function

Function PrintHex (idata)
dim fieldvalue, i
for x = 1 to len(txt)
      Fieldvalue=Fieldvalue & right(string(2,"0") & hex(asc(mid(idata, x, 1))),2) & " "
      if x mod 26 = 0 then response.write vbCRLF
next
Printhex=fieldvalue
end function

Function PrintBrowser (idata)
   PrintBrowser=server.urlencode(idata)
end function   

Function GetEncryptKey
GetEncryptKey=xencryptkey
end Function
Function Converttoplain(Message)
dim temp, char, i, num
		Temp=""
		For i = 1 to Len(Message)
			Char = Mid(Message,i,1)
			Num = Asc(Char)
			If i <> 1 Then
				Temp = Temp & "." & Num
			Else
				Temp = Temp & Num
			End If
		Next
		Converttoplain=Temp
End Function
%>

