﻿/**
	_________________________________________________________________________________________________________________

	UploadQueue uploads multiple files selected by a user to the remote server and dispatches unified progress events
	for them.

	@class UploadQueue (public)
	@author Oinam Software, http://www.oinam.com/
	@version 1.00 (7/17/2005)
	__________________________________________________________________________________________________________________

*/

import flash.net.*;
import mx.events.*;

class UploadQueue 
{


	public static var symbolName:String = "UploadQueue";
	static private var classRegistered = EventDispatcher.initialize (UploadQueue.prototype);

	private var files:Array = null;

	private var currentFile:Number = null;

	private var url:String = null;

	// EventDispatcher mixin methods
	public var addEventListener:Function;
	public var removeEventListener:Function;
	public var dispatchEvent:Function;


	public function UploadQueue (url:String) 
	{
		super ();

		this.url = url;
	};


	public function toString ():String 
	{
		return "[object UploadQueue]";
	};

	public function start (files:Array):Void
	{
		this.files = files;
		currentFile = 0;

		dispatchEvent ({type:"start"});
		uploadNext ();
	};

	private function uploadNext ():Void
	{
		if (currentFile < files.length) 
		{
			var oldFileReference:FileReference = files [currentFile - 1];
			if (oldFileReference != null) 
			{
				oldFileReference.removeListener (this);
			};

			var fileReference:FileReference = files [currentFile];		
			fileReference.addListener (this);
			fileReference.upload (url);
		} 
		else 
		{
			dispatchEvent ({type:"complete"});
		};
	};

	private function onProgress (fileRef:FileReference, bytesLoaded:Number, bytesTotal:Number):Void
	{
		var currentPercent:Number = bytesLoaded/bytesTotal*100;
		var totalFiles:Number = files.length;
		var percentComplete:Number = currentFile/totalFiles*100
		var unitPercent:Number = 1/totalFiles*100;
		var unitPercentComplete:Number = currentPercent*unitPercent/100;
		var currentPercentTotal:Number = (percentComplete + unitPercentComplete);

		dispatchEvent ({type:"progress", percent:currentPercentTotal});
	};

	
	private function onComplete (fileRef:FileReference):Void
	{
		currentFile++;
		uploadNext ();
	};

	private function onSecurityError (fileRef:FileReference, errorString:String):Void
	{
		onError (errorString);
	};

	private function onIOError (fileRef:FileReference):Void
	{
		onError ("An IO Error occurred.");
	};

	private function onHTTPError (fileRef:FileReference, httpError:String):Void
	{
		onError ("HTTP Error, " + httpError + " occurred.");
	};

	private function onError (errorString:String):Void
	{
		dispatchEvent ({type:"error", info:errorString});
	};

};