//dom
class DOMException {
	static const INDEX_SIZE_ERR:Number=1;
	static const DOMSTRING_SIZE_ERR:Number=2;
	static const HIERARCHY_REQUEST_ERR:Number=3;
	static const WRONG_DOCUMENT_ERR:Number=4;
	static const INVALID_CHARACTER_ERR:Number=5;
	static const NO_DATA_ALLOWED_ERR:Number=6;
	static const NO_MODIFICATION_ALLOWED_ERR:Number=7;
	static const NOT_FOUND_ERR:Number=8;
	static const NOT_SUPPORTED_ERR:Number=9;
	static const INUSE_ATTRIBUTE_ERR:Number=10;
	static const INVALID_STATE_ERR:Number=11;
	static const SYNTAX_ERR:Number=12;
	static const INVALID_MODIFICATION_ERR:Number=13;
	static const NAMESPACE_ERR:Number=14;
	static const INVALID_ACCESS_ERR:Number=15;
	
	var code:Number;
}

interface DOMImplementation {
	function hasFeature(feature:String, version:String):Boolean;
	throws(DOMException) function createDocumentType(qualifiedName:String, publicId:String, systemId:String):DocumentType;
	throws(DOMException) function createDocument(namespaceURI:String, qualifiedName:String, doctype:DocumentType):Document;
}

interface Node {
	static const ELEMENT_NODE:Number=1;
	static const ATTRIBUTE_NODE:Number=2;
	static const TEXT_NODE:Number=3;
	static const CDATA_SECTION_NODE:Number=4;
	static const ENTITY_REFERENCE_NODE:Number=5;
	static const ENTITY_NODE:Number=6;
	static const PROCESSING_INSTRUCTION_NODE:Number=7;
	static const COMMENT_NODE:Number=8;
	static const DOCUMENT_NODE:Number=9;
	static const DOCUMENT_TYPE_NODE:Number=10;
	static const DOCUMENT_FRAGMENT_NODE:Number=11;
	static const NOTATION_NODE:Number=12;
	
	const nodeName:String;
	var nodeValue:String;
	const nodeType:Number;
	const parentNode:Node;
	const childNodes:NodeList;
	const firstChild:Node;
	const lastChild:Node;
	const previousSibling:Node;
	const nextSibling:Node;
	const attributes:NamedNodeMap;
	const ownerDocument:Document;
	throws(DOMException) function insertBefore(newChild:Node, refChild:Node):Node;
	throws(DOMException) function replaceChild(newChild:Node, oldChild:Node):Node;
	throws(DOMException) function removeChild(oldChild:Node):Node;
	throws(DOMException) function appendChild(newChild:Node):Node;
	function hasChildNodes():Boolean;
	function cloneNode(deep:Boolean):Node;
	function normalize():void;
	function isSupported(feature:String, version:String):Boolean;
	const namespaceURI:String;
	var prefix:String;
	const localName:String;
	function hasAttributes():Boolean;
}

interface NodeList {
	function item(index:Number):Node;
	const length:Number;
}

interface NamedNodeMap {
	function getNamedItem(name:String):Node;
	throws(DOMException) function setNamedItem(arg:Node):Node;
	throws(DOMException) function removeNamedItem(name:String):Node;
	function item(index:Number):Node;
	const length:Number;
	function getNamedItemNS(namespaceURI:String, localName:String):Node;
	throws(DOMException) function setNamedItemNS(arg:Node):Node;
	throws(DOMException) function removeNamedItemNS(namespaceURI:String, localName:String):Node;
}

interface CharacterData extends Node {
	var data:String;
	const length:Number;
	throws(DOMException) function substringData(offset:Number, count:Number):String;
	throws(DOMException) function appendData(arg:String):void;
	throws(DOMException) function insertData(offset:Number, arg:String):void;
	throws(DOMException) function deleteData(offset:Number, count:Number):void;
	throws(DOMException) function replaceData(offset:Number, count:Number, arg:String):void;
}

interface Attr extends Node {
	const name:String;
	const specified:Boolean;
	var value:String;
	const ownerElement:Element;
}

interface Element extends Node {
	const tagName:String;
	function getAttribute(name:String):String;
	throws(DOMException) function setAttribute(name:String, value:String):void;
	throws(DOMException) function removeAttribute(name:String):void;
	function getAttributeNode(name:String):Attr;
	throws(DOMException) function setAttributeNode(newAttr:Attr):Attr;
	throws(DOMException) function removeAttributeNode(oldAttr:Attr):Attr;
	function getElementsByTagName(name:String):NodeList;
	function getAttributeNS(namespaceURI:String, localName:String):String;
	throws(DOMException) function setAttributeNS(namespaceURI:String, qualifiedName:String, value:String):void;
	throws(DOMException) function removeAttributeNS(namespaceURI:String, localName:String):void;
	function getAttributeNodeNS(namespaceURI:String, localName:String):Attr;
	throws(DOMException) function setAttributeNodeNS(newAttr:Attr):Attr;
	function getElementsByTagNameNS(namespaceURI:String, localName:String):NodeList;
	function hasAttribute(name:String):Boolean;
	function hasAttributeNS(namespaceURI:String, localName:String):Boolean;
}

interface Text extends CharacterData {
	throws(DOMException) function splitText(offset:Number):Text;
}

interface Comment extends CharacterData {
}

interface CDATASection extends Text {
}

interface DocumentType extends Node {
	const name:String;
	const entities:NamedNodeMap;
	const notations:NamedNodeMap;
	const publicId:String;
	const systemId:String;
	const internalSubset:String;
}

interface Notation extends Node {
	const publicId:String;
	const systemId:String;
}

interface Entity extends Node {
	const publicId:String;
	const systemId:String;
	const notationName:String;
}

interface EntityReference extends Node {
}

interface ProcessingInstruction extends Node {
	const target:String;
	var data:String;
}

interface DocumentFragment extends Node {
}

interface Document extends Node {
	const doctype:DocumentType;
	const implementation:DOMImplementation;
	const documentElement:Element;
	throws(DOMException) function createElement(tagName:String):Element;
	function createDocumentFragment():DocumentFragment;
	function createTextNode(data:String):Text;
	function createComment(data:String):Comment;
	throws(DOMException) function createCDATASection(data:String):CDATASection;
	throws(DOMException) function createProcessingInstruction(target:String, data:String):ProcessingInstruction;
	throws(DOMException) function createAttribute(name:String):Attr;
	throws(DOMException) function createEntityReference(name:String):EntityReference;
	function getElementsByTagName(tagname:String):NodeList;
	throws(DOMException) function importNode(importedNode:Node, deep:Boolean):Node;
	throws(DOMException) function createElementNS(namespaceURI:String, qualifiedName:String):Element;
	throws(DOMException) function createAttributeNS(namespaceURI:String, qualifiedName:String):Attr;
	function getElementsByTagNameNS(namespaceURI:String, localName:String):NodeList;
	function getElementById(elementId:String):Element;
}

