class Object {
	var prototype:Object;
	var constructor:Object;

	function toString():String;
	function toLocaleString():String;
	function valueOf():Object;
	function toSource(object:Object):String;
	function isPrototypeOf(object:Object):Boolean;
	function hasOwnProperty(name:String):Boolean;
	function propertyIsEnumerable(name:String):Boolean;
}

class Arguments {
	var caller:Object;
	var callee:Object;
	var length:Number;
}

class Function {
	var name:String;
	var arity:Number;
	var length:Number;
	var arguments:Arguments;
	
	function apply(thisObj:Object, args:Array):Object;
	function call(thisObj:Object, ... args):Object;
}

class Math {
	static var E:Number;
	static var LN2:Number;
	static var LOG2E:Number;
	static var PI:Number;
	static var SQRT1_2:Number;
	static var SQRT2:Number;

	static function abs(x:Number):Number;
	static function acos(x:Number):Number;
	static function asin(x:Number):Number;
	static function atan(x:Number):Number;
	static function atan2(y:Number,x:Number):Number;
	static function ceil(x:Number):Number;
	static function cos(x:Number):Number;
	static function exp(x:Number):Number;
	static function floor(x:Number):Number;
	static function log(x:Number):Number;
	static function max(... values):Number;
	static function min(... values):Number;
	static function pow(x:Number,y:Number):Number;
	static function random():Number;
	static function round(x:Number):Number;
	static function sin(x:Number):Number;
	static function sqrt(x:Number):Number;
	static function tan(x:Number):Number;
}

class Array {
	var length:Number;

	function concat(... items):Array;
	function join(delimiter:String):String;
	function pop():Object;
	function push(... items):Number;
	function reverse();
	function shift():Object;
	function slice(startIndex:Number, endIndex:Number):Array;
	function sort(compare:Object, options:Number):Array;
	function splice(startIndex:Number, deleteCount:Number, ... items):Array;
	function unshift(... items):Number;
}

class Boolean {
	function Boolean(value:Object);
}

class Date {
	function Date(year:Number,month:Number,date:Number,hour:Number,min:Number,sec:Number,ms:Number);
	function getDate():Number;
	function getDay():Number;
	function getFullYear():Number;
	function getHours():Number;
	function getMilliseconds():Number;
	function getMinutes():Number;
	function getMonth():Number;
	function getSeconds():Number;
	function getTime():Number;
	function getTimezoneOffset():Number;
	function getYear():Number;
	function getUTCDate():Number;
	function getUTCDay():Number;
	function getUTCFullYear():Number;
	function getUTCHours():Number;
	function getUTCMilliseconds():Number;
	function getUTCMinutes():Number;
	function getUTCMonth():Number;
	function getUTCSeconds():Number;
	function setDate(value:Number);
	function setFullYear(value:Number);
	function setHours(value:Number);
	function setMilliseconds(value:Number);
	function setMinutes(value:Number);
	function setMonth(value:Number);
	function setSeconds(value:Number);
	function setTime(value:Number);
	function setYear(value:Number);
	function setUTCDate(value:Number);
	function setUTCFullYear(value:Number);
	function setUTCHours(value:Number);
	function setUTCMilliseconds(value:Number);
	function setUTCMinutes(value:Number);
	function setUTCMonth(value:Number);
	function setUTCSeconds(value:Number);
	static function UTC(year:Number,month:Number,date:Number,hour:Number,min:Number,sec:Number,ms:Number):Number;
}

class Number {
	static var MAX_VALUE:Number;
	static var MIN_VALUE:Number;
	static var NaN:Number;
	static var NEGATIVE_INFINITY:Number;
	static var POSITIVE_INFINITY:Number;

	function Number(num:Object);
	
	function toPrecision(precision:Number):String;
	function toFixed(fractionDigits:Number):String;
	function toExponential(fractionDigits:Number):String;
}

class String {
	var length:Number;

	static function fromCharCode(... chars):String;

	function String(string:String);
	function charAt(index:Number):String;
	function charCodeAt(index:Number):Number;
	function concat(... strings):String;
	function indexOf(value:String, startIndex:Number):Number;
	function lastIndexOf(value:String, startIndex:Number):Number;
	function slice(index1:Number,index2:Number):String;
	function split(delimiter:String):Array;
	function substring(index1:Number,index2:Number):String;
	function toUpperCase():String;
	function toLowerCase():String;
}

class RegExp {
	function RegExp(pattern:String, flags:String);
	
	var source:String;
	var global:Boolean;
	var ignoreCase:Boolean;
	var multiline:Boolean;
	var lastIndex:Number;
	
	function exec(string:String):Array;
	function test(string:String):Boolean;
}

class Global {
	function alert(string:String, button1:String=null, button2:String=null, button3:String=null):void;
	function appleScript(appleScriptCode:String, timeout:Number=2):void;
	function beep():void;
	function bytesToUIString(integer:Number):String;
	function chooseColor(string:String=void 0):String;
	function chooseFile(extensions:String||String[]=void 0):String;
	function chooseFolder():String;
	function convertPathToHFS(myPath:String, localize:Boolean=false):String;
	function convertPathToPlatform(myPath:String, forDisplay:Boolean=false):String;
	function closeWidget():void;
	function escape(string:String):String;
	function focusWidget():String;
	function form(fields:FormField[], dialogTitle:String=null, confirmButtonLabel:String=null,cancelButtonLabel:String=null):String[];
	function _include(string:String):void;
	function isApplicationRunning(string:String):Boolean;
	function konfabulatorVersion():String;
	function log(string:String):void;
	function openURL(validURL:String):void;
	function play(pathToSound:String, truncate:Boolean=false):void;
	/**
	 * @since 2.1
	 */
	function popupMenu(menuItems:MenuItem[], x:Number, y:Number):void;
	function print(string:String):void;
	function prompt(promptText:String=null, defaultValue:String=null, dialogTitle:String=null, confirmButtonLabel:String=null, cancelButtonLabel:String=null):String;
	function random(lower_limit:Number=0, upper_limit:Number=64*1024):Number;
	function reloadWidget():void;
	function resolvePath(pathToFile:String):String;
	function resumeUpdates():void;
	function runCommand(string:String):String;
	function runCommandInBg(string:String, tag:String):String;
	function saveAs(extensions:String||String[]=void 0):String;
	function savePreferences():void;
	function showWidgetPreferences():void;
	function sleep(millis:Number):void;
	function speak(string:String):void;
	function suppressUpdates():void;
	function tellWidget(nameOrPath:String, message:String):void;
	function unescape(string:String):void;
	function updateNow():void;
	function yahooCheckLogin():Boolean;
	function yahooLogin():Boolean;
	function yahooLogout():void;
}
