/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.editors;

import com.spket.ui.text.IReconcilingParticipant;
import com.spket.widget.UIUtils;
import com.spket.xml.IModelChangedListener;
import com.spket.xml.ModelChangedEvent;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.editors.XMLContentProvider;
import com.spket.xml.editors.XMLEditor;
import com.spket.xml.editors.XMLLabelProvider;
import com.spket.xml.internal.XMLImages;
import com.spket.xml.internal.XMLPlugin;
import com.spket.xml.preferences.XPMessages;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class XMLOutlinePage
extends ContentOutlinePage
implements IModelChangedListener,
IReconcilingParticipant {
    private static final String P_SHOW_ATTR = "l.attr";
    private static final String P_FILTER_FLAGS = "l.filters";
    private XMLModel fModel;
    private boolean fChanged;
    private XMLEditor fEditor;
    private int flags;
    private XMLFilter fViewFilter;
    private XMLLabelProvider fLabelProvider;
    static /* synthetic */ Class class$com$spket$xml$ModelChangedEvent;

    public XMLOutlinePage(XMLEditor xMLEditor) {
        this.fEditor = xMLEditor;
    }

    public void dispose() {
        if (this.fModel != null) {
            this.fModel.removeModelChangedListener(this);
            this.fModel = null;
        }
        super.dispose();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean(P_SHOW_ATTR);
        this.flags = iPreferenceStore.getInt(P_FILTER_FLAGS);
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        if (this.fLabelProvider != null) {
            this.fLabelProvider.setShowAttribute(bl);
        }
        if (this.flags != 0) {
            this.fViewFilter = new XMLFilter();
            this.fViewFilter.setFlags(this.flags);
            treeViewer.addFilter((ViewerFilter)this.fViewFilter);
        }
        this.fModel = this.fEditor.getModel();
        if (this.fModel != null) {
            treeViewer.setInput((Object)this.fModel);
            this.fModel.addModelChangedListener(this);
        }
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        Action action = new ShowAttributeAction();
        action.setChecked(bl);
        iToolBarManager.add((IAction)action);
        iToolBarManager.add((IContributionItem)new Separator());
        action = new FilterAction(5, XPMessages.Outline_ShowComment_label, XMLImages.DESC_OBJS_COMMENT);
        action.setChecked((this.flags & 0x20) != 0);
        iToolBarManager.add((IAction)action);
        action = new FilterAction(4, XPMessages.Outline_ShowCDATA_label, XMLImages.DESC_OBJS_CDATA);
        action.setChecked((this.flags & 0x10) != 0);
        iToolBarManager.add((IAction)action);
        action = new FilterAction(6, XPMessages.Outline_ShowDocType_label, XMLImages.DESC_OBJS_DOCTYPE);
        action.setChecked((this.flags & 0x40) != 0);
        iToolBarManager.add((IAction)action);
        action = new FilterAction(7, XPMessages.Outline_ShowPI_label, XMLImages.DESC_OBJS_PROC_INSTR);
        action.setChecked((this.flags & 0x80) != 0);
        iToolBarManager.add((IAction)action);
    }

    protected ITreeContentProvider createContentProvider() {
        return new XMLContentProvider();
    }

    protected ILabelProvider createLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new XMLLabelProvider(this.fEditor.getModel());
        }
        return this.fLabelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(ModelChangedEvent modelChangedEvent) {
        if (modelChangedEvent.getSource() == (class$com$spket$xml$ModelChangedEvent == null ? (class$com$spket$xml$ModelChangedEvent = XMLOutlinePage.class$("com.spket.xml.ModelChangedEvent")) : class$com$spket$xml$ModelChangedEvent)) {
            return;
        }
        if (!this.fChanged) {
            XMLOutlinePage xMLOutlinePage = this;
            synchronized (xMLOutlinePage) {
                this.fChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile() {
        if (this.fChanged) {
            Tree tree;
            XMLOutlinePage xMLOutlinePage = this;
            synchronized (xMLOutlinePage) {
                this.fChanged = false;
            }
            xMLOutlinePage = this.getTreeViewer();
            if (xMLOutlinePage != null && UIUtils.okToUse((Widget)(tree = xMLOutlinePage.getTree()))) {
                Display display = tree.getDisplay();
                if (!this.fChanged && display != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (XMLOutlinePage.this.fModel != null) {
                                TreeViewer treeViewer = XMLOutlinePage.this.getTreeViewer();
                                if (!XMLOutlinePage.this.fChanged && treeViewer != null) {
                                    treeViewer.refresh((Object)XMLOutlinePage.this.fModel);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    public void setSelection(ISelection iSelection) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            boolean bl = true;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
            if (!iStructuredSelection.isEmpty()) {
                List list = iStructuredSelection.toList();
                boolean bl2 = bl = !list.containsAll(((IStructuredSelection)iSelection).toList());
            }
            if (bl) {
                treeViewer.setSelection(iSelection);
            }
        }
    }

    protected void updateFilter(int n, boolean bl) {
        int n2 = bl ? this.flags | 1 << n : this.flags & ~(1 << n);
        if (n2 != this.flags) {
            this.flags = n2;
            XMLPlugin.getDefault().getPreferenceStore().setValue(P_FILTER_FLAGS, this.flags);
            TreeViewer treeViewer = this.getTreeViewer();
            if (this.flags == 0) {
                if (this.fViewFilter != null) {
                    treeViewer.removeFilter((ViewerFilter)this.fViewFilter);
                    this.fViewFilter = null;
                }
            } else if (this.fViewFilter == null) {
                this.fViewFilter = new XMLFilter();
                this.fViewFilter.setFlags(this.flags);
                treeViewer.addFilter((ViewerFilter)this.fViewFilter);
            } else {
                this.fViewFilter.setFlags(this.flags);
                treeViewer.refresh();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class FilterAction
    extends Action {
        private int fNodeType;

        public FilterAction(int n, String string, ImageDescriptor imageDescriptor) {
            super(string, imageDescriptor);
            this.fNodeType = n;
            this.setText(string);
            this.setDescription(string);
        }

        public void run() {
            XMLOutlinePage.this.updateFilter(this.fNodeType, this.isChecked());
        }
    }

    private final class ShowAttributeAction
    extends Action {
        public ShowAttributeAction() {
            this.setText(XPMessages.Outline_ShowAttr_label);
            this.setToolTipText(XPMessages.Outline_ShowAttr_label);
            this.setDescription(XPMessages.Outline_ShowAttr_label);
            this.setImageDescriptor(XMLImages.DESC_OBJS_ATTR);
        }

        public void run() {
            boolean bl = this.isChecked();
            IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.setValue(XMLOutlinePage.P_SHOW_ATTR, bl);
            if (XMLOutlinePage.this.fLabelProvider != null) {
                XMLOutlinePage.this.fLabelProvider.setShowAttribute(bl);
                XMLOutlinePage.this.getTreeViewer().refresh(true);
            }
        }
    }

    private static final class XMLFilter
    extends ViewerFilter {
        private int flags;

        private XMLFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof XMLNode) {
                XMLNode xMLNode = (XMLNode)object2;
                return (this.flags & 1 << xMLNode.getNodeType()) == 0;
            }
            return true;
        }

        public void setFlags(int n) {
            this.flags = n;
        }
    }
}

