/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.buffer.IBuffer;
import com.spket.util.Debug;
import com.spket.util.IntStack;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.NamespaceContextImpl;
import com.spket.xml.ParentNode;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLConstants;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLModelParser;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xni.NamespaceContext;

public class StructureTracker {
    private int fOffset;
    private int fLength;
    private String fText;
    private PositionInfo fStartInfo;
    private PositionInfo fEndInfo;
    private IBuffer fBuffer;
    private XMLModel fXMLModel;
    protected XMLModelParser fModelParser;
    protected NamespaceContext fNamespaceContext;

    public StructureTracker(XMLModel xMLModel) {
        this.fXMLModel = xMLModel;
        this.fStartInfo = new PositionInfo();
        this.fEndInfo = new PositionInfo();
        this.fNamespaceContext = new NamespaceContextImpl();
        this.fModelParser = new XMLModelParser(this.fXMLModel.getSymbolTable());
    }

    public void dispose() {
        if (this.fModelParser != null) {
            this.fModelParser.dispose();
            this.fModelParser = null;
        }
        if (this.fNamespaceContext != null) {
            this.fNamespaceContext.reset();
            this.fNamespaceContext = null;
        }
        this.fText = null;
        this.fStartInfo = null;
        this.fEndInfo = null;
        this.fXMLModel = null;
        this.fBuffer = null;
    }

    public void prepare(int n, int n2, String string) {
        this.reset();
        this.fOffset = n;
        this.fLength = n2;
        this.fText = string;
        this.fBuffer = this.fXMLModel.getBuffer();
        XMLUtils.findNode(this.fXMLModel, n, this.fStartInfo);
        if (n2 == 0) {
            this.fEndInfo = this.fStartInfo;
        } else {
            XMLUtils.findNode(this.fXMLModel, n + n2, this.fEndInfo);
        }
    }

    public XMLDocument reparse() {
        this.fBuffer = this.fXMLModel.getBuffer();
        this.fModelParser.parse(this.fBuffer);
        this.fXMLModel.acceptProblems(0, this.fBuffer.getLength(), this.fModelParser.getProblems());
        return this.fModelParser.getDocument();
    }

    public XMLNode update() {
        int n = -this.fLength;
        if (this.fText != null) {
            n += this.fText.length();
        }
        return this.updateStructure(n);
    }

    protected void reset() {
        this.fText = null;
        this.fStartInfo.reset();
        if (this.fEndInfo == this.fStartInfo) {
            this.fEndInfo = new PositionInfo();
        } else {
            this.fEndInfo.reset();
        }
    }

    protected void list(XMLNode xMLNode, int n, int n2, INodeRegion[] iNodeRegionArray, XMLNode[] xMLNodeArray, boolean[] blArray, int n3, int n4) {
        IntStack intStack = new IntStack();
        int n5 = n4;
        int n6 = 0;
        boolean bl = false;
        XMLNode xMLNode2 = xMLNode;
        block0: while (xMLNode2 != null) {
            INodeRegion iNodeRegion;
            if (!bl && xMLNode2.getNodeType() == 1 && (iNodeRegion = ((XMLElement)xMLNode2).getStartTagRegion()) != null) {
                if (iNodeRegion.getEnd() <= n) {
                    iNodeRegionArray[n5] = iNodeRegion;
                    xMLNodeArray[n5] = xMLNode2;
                    blArray[n5] = true;
                    ++n5;
                } else if (iNodeRegion.getStart() >= n2) {
                    iNodeRegionArray[n5 + n3] = iNodeRegion;
                    xMLNodeArray[n5 + n3] = xMLNode2;
                    blArray[n5 + n3] = true;
                    ++n5;
                }
            }
            bl = false;
            int n7 = xMLNode2.getChildrenCount();
            if (n7 > 0) {
                XMLNode[] xMLNodeArray2 = xMLNode2.getChildren();
                for (int i = n6; i < n7; ++i) {
                    XMLElement xMLElement;
                    XMLNode xMLNode3 = xMLNodeArray2[i];
                    if (xMLNode3.getNodeType() == 1 && !(xMLElement = (XMLElement)xMLNode3).isEmptyTag() && (iNodeRegion = xMLElement.getStartTagRegion()) != null) {
                        int n8 = iNodeRegion.getStart();
                        iNodeRegion = xMLElement.getEndTagRegion();
                        if (iNodeRegion != null && n8 >= n && iNodeRegion.getEnd() <= n2) continue;
                        n6 = 0;
                        xMLNode2 = xMLNode3;
                        intStack.push(i + 1);
                        continue block0;
                    }
                    iNodeRegion = xMLNode3.getRegion();
                    if (iNodeRegion.getEnd() <= n) {
                        iNodeRegionArray[n5] = iNodeRegion;
                        xMLNodeArray[n5] = xMLNode3;
                        ++n5;
                        continue;
                    }
                    if (iNodeRegion.getStart() < n2) continue;
                    iNodeRegionArray[n5 + n3] = iNodeRegion;
                    xMLNodeArray[n5 + n3] = xMLNode3;
                    ++n5;
                }
            }
            if (xMLNode2.getNodeType() == 1 && (iNodeRegion = ((XMLElement)xMLNode2).getEndTagRegion()) != null) {
                if (iNodeRegion.getEnd() <= n) {
                    iNodeRegionArray[n5] = iNodeRegion;
                    xMLNodeArray[n5] = xMLNode2;
                    ++n5;
                } else if (iNodeRegion.getStart() >= n2) {
                    iNodeRegionArray[n5 + n3] = iNodeRegion;
                    xMLNodeArray[n5 + n3] = xMLNode2;
                    ++n5;
                }
            }
            if (intStack.size() == 0) break;
            xMLNode2 = xMLNode2.getParent();
            n6 = intStack.pop();
            bl = true;
        }
    }

    protected String getValue(INodeRegion iNodeRegion, int n) {
        if (iNodeRegion != null) {
            int n2 = iNodeRegion.getStart() + n;
            int n3 = iNodeRegion.getEnd() + n;
            int n4 = this.fBuffer.getLength();
            if (n2 > 0 && n3 > n2 && n3 < n4) {
                String string = this.fBuffer.get(n2, n3 - n2);
                if (string != null) {
                    n2 = 1;
                    n4 = string.length();
                    char c = string.charAt(0);
                    string = n4 > 1 && c == string.charAt(n4 - 1) ? string.substring(1, n4 - 1).trim() : string.substring(1).trim();
                }
                return string != null ? string : XMLConstants.EMPTY_STRING;
            }
        }
        return XMLConstants.EMPTY_STRING;
    }

    protected void pushContext(XMLElement xMLElement) {
        this.fNamespaceContext.pushContext();
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            int n2 = xMLElement.getStartTagRegion().getStart();
            for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                String string = xMLAttr.getName();
                if (string == null) continue;
                String string2 = null;
                if (string.length() == 5 && XMLConstants.PREFIX_XMLNS.equals(string)) {
                    string2 = XMLConstants.EMPTY_STRING;
                } else if (string.length() > 6 && string.charAt(5) == ':' && string.startsWith(XMLConstants.PREFIX_XMLNS)) {
                    string2 = string.substring(6);
                }
                if (string2 == null) continue;
                String string3 = this.getValue(xMLAttr.getValueRegion(), n2);
                this.fNamespaceContext.declarePrefix(string2, string3.length() != 0 ? string3 : null);
            }
        }
    }

    protected int[] findDrityNode(int n, int n2, List list) {
        int n3;
        int n4;
        IntStack intStack = new IntStack();
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        INodeRegion iNodeRegion = null;
        int n7 = n4 = this.fBuffer.getLength() + this.fLength - (this.fText == null ? 0 : this.fText.length());
        XMLNode xMLNode = this.fXMLModel.getXMLDocument();
        block0: while (xMLNode != null) {
            INodeRegion iNodeRegion2;
            if (!bl && ((XMLNode)xMLNode).getNodeType() == 1 && (iNodeRegion2 = ((XMLElement)xMLNode).getStartTagRegion()) != null) {
                if (iNodeRegion2.getEnd() <= n) {
                    n6 = iNodeRegion2.getEnd();
                    iNodeRegion = iNodeRegion2;
                }
                if (list.size() < 2 && iNodeRegion2.getEnd() > n && iNodeRegion2.getStart() < n2) {
                    list.add(xMLNode);
                }
                if (iNodeRegion2.getStart() >= n2 && iNodeRegion2.getStart() < n4) {
                    n4 = iNodeRegion2.getStart();
                    break;
                }
                if (iNodeRegion2.getEnd() == n7) break;
            }
            bl = false;
            n3 = ((XMLNode)xMLNode).getChildrenCount();
            if (n3 > 0) {
                XMLNode[] xMLNodeArray = ((XMLNode)xMLNode).getChildren();
                for (int i = n5; i < n3; ++i) {
                    XMLElement xMLElement;
                    XMLNode xMLNode2 = xMLNodeArray[i];
                    if (xMLNode2.getNodeType() == 1 && !(xMLElement = (XMLElement)xMLNode2).isEmptyTag() && (iNodeRegion2 = xMLElement.getStartTagRegion()) != null) {
                        int n8 = iNodeRegion2.getStart();
                        iNodeRegion2 = xMLElement.getEndTagRegion();
                        if (iNodeRegion2 != null && n8 >= n && iNodeRegion2.getEnd() <= n2) {
                            if (list.size() >= 2) continue;
                            list.add(xMLElement);
                            if (xMLElement.getChildrenCount() <= 0) continue;
                            list.add(xMLElement.getChildren()[0]);
                            continue;
                        }
                        n5 = 0;
                        xMLNode = xMLNode2;
                        intStack.push(i + 1);
                        continue block0;
                    }
                    iNodeRegion2 = xMLNode2.getRegion();
                    if (iNodeRegion2.getEnd() <= n) {
                        n6 = iNodeRegion2.getEnd();
                        iNodeRegion = iNodeRegion2;
                    }
                    if (list.size() < 2 && iNodeRegion2.getEnd() > n && iNodeRegion2.getStart() < n2) {
                        list.add(xMLNode2);
                    }
                    if (iNodeRegion2.getStart() >= n2 && iNodeRegion2.getStart() < n4) {
                        n4 = iNodeRegion2.getStart();
                        break;
                    }
                    if (iNodeRegion2.getEnd() == n7) break;
                }
            }
            if (((XMLNode)xMLNode).getNodeType() == 1 && (iNodeRegion2 = ((XMLElement)xMLNode).getEndTagRegion()) != null) {
                if (iNodeRegion2.getEnd() <= n) {
                    n6 = iNodeRegion2.getEnd();
                    iNodeRegion = iNodeRegion2;
                }
                if (list.size() < 2 && iNodeRegion2.getEnd() > n && iNodeRegion2.getStart() < n2) {
                    list.add(xMLNode);
                }
                if (iNodeRegion2.getStart() >= n2 && iNodeRegion2.getStart() < n4) {
                    n4 = iNodeRegion2.getStart();
                    break;
                }
                if (iNodeRegion2.getEnd() == n7) break;
            }
            if (intStack.size() == 0) break;
            xMLNode = ((XMLNode)xMLNode).getParent();
            n5 = intStack.pop();
            bl = true;
        }
        if (n6 > 0 && iNodeRegion != null && (n3 = (int)this.fBuffer.get(n6 - 1)) != 62) {
            n6 = iNodeRegion.getStart();
        }
        int[] nArray = new int[]{n6, n4};
        return nArray;
    }

    protected boolean quickMerge(XMLNode xMLNode, List list, int n, int n2, int n3) {
        int[] nArray;
        int n4;
        boolean bl = false;
        int n5 = list.size();
        if (n5 < 2 && (n4 = (nArray = this.count(xMLNode, -1, -1))[0] + nArray[1]) < 2) {
            bl = true;
            if (n5 == 0) {
                if (n4 == 0) {
                    this.updatePosition(this.fXMLModel.getXMLDocument(), n2, n);
                } else {
                    XMLNode xMLNode2 = xMLNode.getChildren()[0];
                    if (xMLNode2.getNodeType() == 1) {
                        bl = ((XMLElement)xMLNode2).isEmptyTag();
                    }
                    if (bl) {
                        XMLNode xMLNode3 = this.fStartInfo.node;
                        if (this.fStartInfo.nodeType != 3 && xMLNode3 != null) {
                            xMLNode3 = xMLNode3.getParent();
                        }
                        if (xMLNode3 == null) {
                            bl = false;
                            Debug.assertTrue((boolean)bl);
                        } else {
                            this.updatePosition(this.fXMLModel.getXMLDocument(), n2, n);
                            xMLNode3.insertChild(this.fStartInfo.index, xMLNode2);
                        }
                    }
                }
            } else {
                XMLNode xMLNode4 = (XMLNode)list.get(0);
                if (n4 == 0) {
                    if (xMLNode4.getNodeType() == 1) {
                        XMLElement xMLElement = (XMLElement)xMLNode4;
                        boolean bl2 = bl = xMLElement.isEmptyTag() || xMLElement.getStartTagRegion() == null;
                    }
                    if (bl) {
                        this.updatePosition(this.fXMLModel.getXMLDocument(), n2, n);
                        xMLNode4.getParent().removeChild(xMLNode4);
                    }
                } else {
                    XMLNode xMLNode5 = xMLNode.getChildren()[0];
                    if (xMLNode4.getNodeType() == 1) {
                        XMLElement xMLElement = (XMLElement)xMLNode4;
                        if (xMLNode5.getNodeType() == 1) {
                            XMLElement xMLElement2 = (XMLElement)xMLNode5;
                            bl = this.checkSameRegion(xMLElement, xMLElement2, n2, n3);
                            if (bl) {
                                this.updatePosition(this.fXMLModel.getXMLDocument(), n2, n);
                                if (xMLElement.isEmptyTag()) {
                                    xMLNode4.getParent().replaceChild(xMLNode4, xMLNode5);
                                } else {
                                    INodeRegion iNodeRegion = xMLElement2.getEndTagRegion();
                                    if (iNodeRegion != null) {
                                        xMLElement.setEndTagRegion(iNodeRegion);
                                    } else {
                                        xMLElement.setStartTagRegion(xMLElement2.getStartTagRegion());
                                        xMLElement.fAttrCount = xMLElement2.fAttrCount;
                                        xMLElement.fAttrs = xMLElement2.fAttrs;
                                        for (int i = 0; i < xMLElement.fAttrCount; ++i) {
                                            xMLElement.fAttrs[i].fParent = xMLElement;
                                        }
                                    }
                                }
                            }
                            return bl;
                        }
                        bl = xMLElement.isEmptyTag();
                    } else if (xMLNode5.getNodeType() == 1) {
                        bl = ((XMLElement)xMLNode5).isEmptyTag();
                    }
                    if (bl) {
                        this.updatePosition(this.fXMLModel.getXMLDocument(), n2, n);
                        xMLNode4.getParent().replaceChild(xMLNode4, xMLNode5);
                    }
                }
            }
        }
        return bl;
    }

    protected boolean checkSameRegion(XMLElement xMLElement, XMLElement xMLElement2, int n, int n2) {
        boolean bl = false;
        if (xMLElement.isEmptyTag() && xMLElement2.isEmptyTag()) {
            return true;
        }
        if (xMLElement.isEmptyTag() != xMLElement2.isEmptyTag()) {
            return false;
        }
        if (xMLElement.getName().equals(xMLElement2.getName())) {
            INodeRegion iNodeRegion = xMLElement.getStartTagRegion();
            if (xMLElement2.getEndTagRegion() != null) {
                if (iNodeRegion == null) {
                    bl = true;
                } else {
                    iNodeRegion = xMLElement.getEndTagRegion();
                    if (iNodeRegion != null && iNodeRegion.getStart() >= n && iNodeRegion.getEnd() <= n2) {
                        bl = true;
                    }
                }
            } else if (iNodeRegion != null && iNodeRegion.getStart() >= n && iNodeRegion.getEnd() <= n2) {
                String string;
                XMLAttr xMLAttr;
                int n3;
                boolean bl2 = false;
                int n4 = xMLElement.getAttrCount();
                XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
                for (n3 = 0; n3 < n4; ++n3) {
                    xMLAttr = xMLAttrArray[n3];
                    string = xMLAttr.getName();
                    if (string == null) continue;
                    if (string.length() == 5 && XMLConstants.PREFIX_XMLNS.equals(string)) {
                        bl2 = true;
                    } else if (string.length() > 6 && string.charAt(5) == ':' && string.startsWith(XMLConstants.PREFIX_XMLNS)) {
                        bl2 = true;
                    }
                    if (bl2) break;
                }
                if (!bl2) {
                    n4 = xMLElement2.getAttrCount();
                    xMLAttrArray = xMLElement2.getAttrs();
                    for (n3 = 0; n3 < n4; ++n3) {
                        xMLAttr = xMLAttrArray[n3];
                        string = xMLAttr.getName();
                        if (string == null) continue;
                        if (string.length() == 5 && XMLConstants.PREFIX_XMLNS.equals(string)) {
                            bl2 = true;
                        } else if (string.length() > 6 && string.charAt(5) == ':' && string.startsWith(XMLConstants.PREFIX_XMLNS)) {
                            bl2 = true;
                        }
                        if (bl2) break;
                    }
                }
                bl = !bl2;
            }
        }
        return bl;
    }

    protected void merge(XMLNode xMLNode, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        XMLDocument xMLDocument = this.fXMLModel.getXMLDocument();
        int[] nArray = this.count(xMLDocument, n2, n3);
        int n7 = nArray[0];
        n5 = nArray[0] + nArray[1];
        n6 = (nArray = this.count(xMLNode, -1, -1))[0] + nArray[1];
        n4 = n5 + n6;
        if (n4 > 0) {
            INodeRegion[] iNodeRegionArray = new INodeRegion[n4];
            XMLNode[] xMLNodeArray = new XMLNode[n4];
            boolean[] blArray = new boolean[n4];
            if (n5 > 0) {
                this.list(xMLDocument, n2, n3, iNodeRegionArray, xMLNodeArray, blArray, n6, 0);
                int n8 = n7 + n6;
                if (n8 < n4 && n != 0) {
                    for (int i = n8; i < n4; ++i) {
                        iNodeRegionArray[i].adjustStart(n);
                    }
                }
            }
            if (n6 > 0) {
                this.list(xMLNode, -1, -1, iNodeRegionArray, xMLNodeArray, blArray, 0, n7);
            }
            xMLDocument.reset();
            XMLNode xMLNode2 = xMLDocument;
            this.fNamespaceContext.reset();
            for (int i = 0; i < n4; ++i) {
                XMLNode xMLNode3 = xMLNodeArray[i];
                if (xMLNode3.getNodeType() == 1) {
                    XMLElement xMLElement = (XMLElement)xMLNode3;
                    if (xMLElement.isEmptyTag()) {
                        xMLNode2.appendChild(xMLNode3);
                        this.pushContext(xMLElement);
                        String string = xMLElement.getPrefix();
                        if (string == null) {
                            string = XMLConstants.EMPTY_STRING;
                        }
                        xMLElement.setNamespace(this.fNamespaceContext.getURI(string));
                        this.fNamespaceContext.popContext();
                        continue;
                    }
                    if (blArray[i]) {
                        xMLElement.reset();
                        xMLElement.setEndTagRegion(null);
                        xMLNode2.appendChild(xMLNode3);
                        xMLNode2 = xMLNode3;
                        this.pushContext(xMLElement);
                        String string = xMLElement.getPrefix();
                        if (string == null) {
                            string = XMLConstants.EMPTY_STRING;
                        }
                        xMLElement.setNamespace(this.fNamespaceContext.getURI(string));
                        continue;
                    }
                    int n9 = 0;
                    boolean bl = false;
                    String string = xMLElement.getName();
                    XMLNode xMLNode4 = xMLNode2;
                    int n10 = string.indexOf(58);
                    String string2 = XMLConstants.EMPTY_STRING;
                    if (n10 != -1) {
                        string2 = string.substring(0, n10);
                    }
                    String string3 = this.fNamespaceContext.getURI(string2);
                    while (xMLNode4 != null && xMLNode4.getNodeType() == 1) {
                        if (StringUtils.equals((Object)string, (Object)xMLNode4.getName()) && StringUtils.equals((Object)string3, (Object)xMLNode4.getNamespace())) {
                            bl = true;
                            xMLElement = (XMLElement)xMLNode4;
                            xMLElement.setEndTagRegion(iNodeRegionArray[i]);
                            xMLNode4 = xMLNode2;
                            xMLNode2 = xMLElement.getParent();
                            do {
                                ((ParentNode)xMLNode4).shrink();
                                xMLNode4 = xMLNode4.getParent();
                                this.fNamespaceContext.popContext();
                            } while (--n9 > 0);
                            break;
                        }
                        xMLNode4 = xMLNode4.getParent();
                    }
                    if (bl) continue;
                    xMLElement = new XMLElement();
                    xMLElement.setName(string);
                    xMLElement.setNamespace(string3);
                    xMLElement.setEndTagRegion(iNodeRegionArray[i]);
                    xMLNode2.appendChild(xMLElement);
                    continue;
                }
                xMLNode2.appendChild(xMLNode3);
            }
            xMLDocument.shrink();
        } else {
            xMLDocument.reset();
            xMLDocument.shrink();
        }
    }

    protected int[] count(XMLNode xMLNode, int n, int n2) {
        IntStack intStack = new IntStack();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        XMLNode xMLNode2 = xMLNode;
        block0: while (xMLNode2 != null) {
            INodeRegion iNodeRegion;
            if (!bl && xMLNode2.getNodeType() == 1 && (iNodeRegion = ((XMLElement)xMLNode2).getStartTagRegion()) != null) {
                if (iNodeRegion.getEnd() <= n) {
                    ++n4;
                } else if (iNodeRegion.getStart() >= n2) {
                    ++n5;
                }
            }
            bl = false;
            int n6 = xMLNode2.getChildrenCount();
            if (n6 > 0) {
                XMLNode[] xMLNodeArray = xMLNode2.getChildren();
                for (int i = n3; i < n6; ++i) {
                    XMLElement xMLElement;
                    XMLNode xMLNode3 = xMLNodeArray[i];
                    if (xMLNode3.getNodeType() == 1 && !(xMLElement = (XMLElement)xMLNode3).isEmptyTag() && (iNodeRegion = xMLElement.getStartTagRegion()) != null) {
                        int n7 = iNodeRegion.getStart();
                        iNodeRegion = xMLElement.getEndTagRegion();
                        if (iNodeRegion != null && n7 >= n && iNodeRegion.getEnd() <= n2) continue;
                        n3 = 0;
                        xMLNode2 = xMLNode3;
                        intStack.push(i + 1);
                        continue block0;
                    }
                    iNodeRegion = xMLNode3.getRegion();
                    if (iNodeRegion.getEnd() <= n) {
                        ++n4;
                        continue;
                    }
                    if (iNodeRegion.getStart() < n2) continue;
                    ++n5;
                }
            }
            if (xMLNode2.getNodeType() == 1 && (iNodeRegion = ((XMLElement)xMLNode2).getEndTagRegion()) != null) {
                if (iNodeRegion.getEnd() <= n) {
                    ++n4;
                } else if (iNodeRegion.getStart() >= n2) {
                    ++n5;
                }
            }
            if (intStack.size() == 0) break;
            xMLNode2 = xMLNode2.getParent();
            n3 = intStack.pop();
            bl = true;
        }
        int[] nArray = new int[]{n4, n5};
        return nArray;
    }

    protected boolean quickCheck() {
        boolean bl = true;
        if (this.equals(this.fStartInfo, this.fEndInfo)) {
            XMLNode xMLNode = this.fStartInfo.node;
            switch (this.fStartInfo.nodeType) {
                case 1: 
                case 3: {
                    bl = this.checkForText();
                    break;
                }
                case 4: {
                    INodeRegion iNodeRegion = xMLNode.getRegion();
                    bl = this.checkForCDATA(iNodeRegion);
                    break;
                }
                case 5: {
                    INodeRegion iNodeRegion = xMLNode.getRegion();
                    bl = this.checkForComments(iNodeRegion);
                    break;
                }
                case 6: 
                case 7: 
                case 100: {
                    break;
                }
            }
        }
        return bl;
    }

    protected XMLNode updateStructure(int n) {
        XMLNode xMLNode = null;
        boolean bl = this.quickCheck();
        if (bl) {
            XMLNode xMLNode2;
            ArrayList arrayList = new ArrayList(4);
            int[] nArray = this.findDrityNode(this.fOffset, this.fOffset + this.fLength, arrayList);
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = n3 + n;
            int n5 = this.fBuffer.getLength();
            if (n4 > n5) {
                n4 = n5;
            }
            if ((xMLNode2 = this.fStartInfo.node) != null) {
                xMLNode2 = xMLNode2.getParent();
            }
            XMLDocument xMLDocument = null;
            int n6 = n4;
            if (n4 > n2) {
                this.fModelParser.parse(this.fBuffer, xMLNode2, n2, n4);
                xMLDocument = this.fModelParser.getDocument();
                n6 = this.fModelParser.getOffset();
            }
            boolean bl2 = true;
            if (n6 != n4) {
                if (n6 > n4 + 1) {
                    bl2 = false;
                }
                n3 += n6 - n4;
                n4 = n6;
                if (n6 != n5) {
                    --n4;
                    --n3;
                }
            }
            XMLDocument xMLDocument2 = this.fXMLModel.getXMLDocument();
            if (!bl2 || !this.quickMerge(xMLDocument, arrayList, n, n2, n3)) {
                this.merge(xMLDocument, n, n2, n3);
                xMLNode = xMLDocument2;
            } else {
                xMLNode = xMLNode2;
            }
            if (xMLDocument != null && xMLDocument2 != null && n2 == 0) {
                xMLDocument2.setEncoding(xMLDocument.getEncoding());
                xMLDocument2.setVersion(xMLDocument.getVersion());
            }
            this.fXMLModel.acceptProblems(n2, n3, this.fModelParser.getProblems());
        }
        return xMLNode;
    }

    protected boolean checkForText() {
        return true;
    }

    protected boolean checkForCDATA(INodeRegion iNodeRegion) {
        return true;
    }

    protected boolean checkForComments(INodeRegion iNodeRegion) {
        return true;
    }

    protected void updatePosition(XMLNode xMLNode, int n, int n2) {
        int n3 = 0;
        XMLNode xMLNode2 = xMLNode;
        IntStack intStack = new IntStack();
        block0: while (xMLNode2 != null) {
            int n4 = xMLNode2.getChildrenCount();
            if (n4 > 0) {
                XMLNode[] xMLNodeArray = xMLNode2.getChildren();
                for (int i = n3; i < n4; ++i) {
                    INodeRegion iNodeRegion;
                    XMLNode xMLNode3 = xMLNodeArray[i];
                    if (xMLNode3.getNodeType() == 1) {
                        XMLElement xMLElement = (XMLElement)xMLNode3;
                        iNodeRegion = xMLElement.getStartTagRegion();
                        if (iNodeRegion != null) {
                            if (iNodeRegion.getStart() >= n) {
                                iNodeRegion.adjustStart(n2);
                            }
                            if (xMLElement.isEmptyTag()) continue;
                            iNodeRegion = xMLElement.getEndTagRegion();
                            if (iNodeRegion != null) {
                                if (iNodeRegion.getEnd() <= n) continue;
                                iNodeRegion.adjustStart(n2);
                            }
                            n3 = 0;
                            xMLNode2 = xMLNode3;
                            intStack.push(i + 1);
                            continue block0;
                        }
                        iNodeRegion = xMLElement.getEndTagRegion();
                        if (iNodeRegion.getStart() < n) continue;
                        iNodeRegion.adjustStart(n2);
                        continue;
                    }
                    iNodeRegion = xMLNode3.getRegion();
                    if (iNodeRegion.getStart() < n) continue;
                    iNodeRegion.adjustStart(n2);
                }
            }
            if (intStack.size() == 0) break;
            xMLNode2 = xMLNode2.getParent();
            n3 = intStack.pop();
        }
    }

    protected boolean equals(PositionInfo positionInfo, PositionInfo positionInfo2) {
        if (positionInfo == positionInfo2) {
            return true;
        }
        if (positionInfo == null || positionInfo2 == null) {
            return false;
        }
        return positionInfo.node == positionInfo2.node && positionInfo.index == positionInfo2.index && positionInfo.nodeType == positionInfo2.nodeType;
    }
}

