/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.model;

import com.spket.buffer.BufferManager;
import com.spket.buffer.IBuffer;
import com.spket.laszlo.internal.LaszloPlugin;
import com.spket.laszlo.model.LzUnit;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.xml.DOMModel;
import com.spket.xml.IDOMModel;
import com.spket.xml.XMLModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class LzUnitManager {
    private static final int F_ERROR = 1;
    private static final int F_WORKING = 2;
    private static final String LZ_LIBRARY = "library.lzx";
    private static LzUnitManager manager;
    private static BufferManager gBufferManager;
    private String fLaszloPath;
    private IPath componentsPath;
    private Map states = new HashMap();
    private Map includes = new HashMap();

    public static LzUnitManager getDefault() {
        if (manager == null) {
            manager = new LzUnitManager();
        }
        return manager;
    }

    private LzUnitManager() {
        IPreferenceStore iPreferenceStore = LaszloPlugin.getDefault().getPreferenceStore();
        this.setLaszlo(iPreferenceStore);
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LzUnitManager.this.onPropertyChange(propertyChangeEvent);
            }
        });
    }

    public IDOMModel getModel(IPath iPath) {
        State state = this.getState(iPath, true);
        if (state != null) {
            if (state.model == null && state.status == 0) {
                IBuffer iBuffer = gBufferManager.getBuffer(iPath);
                if (iBuffer == null) {
                    state.status = 1;
                } else {
                    state.model = (IDOMModel)new DOMModel(iPath, iBuffer);
                }
            }
            return state.model;
        }
        return null;
    }

    public LzUnit getUnit(IPath iPath) {
        IDOMModel iDOMModel = this.getModel(iPath);
        if (iDOMModel != null) {
            return new LzUnit(iDOMModel);
        }
        return null;
    }

    public Map getIncludes() {
        return this.includes;
    }

    public void becomeWorkingCopy(XMLModel xMLModel) {
        if (xMLModel == null) {
            return;
        }
        IPath iPath = xMLModel.getPath();
        if (iPath == null) {
            return;
        }
        State state = this.getState(iPath, true);
        if (state != null) {
            state.model = (IDOMModel)xMLModel;
            state.status = 2;
        }
    }

    public void releaseWorkingCopy(XMLModel xMLModel) {
        if (xMLModel == null) {
            return;
        }
        IPath iPath = xMLModel.getPath();
        if (iPath == null) {
            return;
        }
        State state = this.getState(iPath, false);
        if (state != null) {
            state.status = 0;
            this.states.remove(iPath);
        }
    }

    protected State getState(IPath iPath, boolean bl) {
        State state = (State)this.states.get(iPath);
        if (state == null) {
            IPath iPath2 = gBufferManager.resolve(iPath);
            if (iPath2 != iPath) {
                iPath = iPath2;
                state = (State)this.states.get(iPath);
            }
            if (state == null && bl) {
                state = new State();
                this.states.put(iPath, state);
            }
        }
        return state;
    }

    public IPath resolve(IPath iPath, IPath iPath2) {
        IPath iPath3 = null;
        if (!iPath2.isAbsolute()) {
            Object object;
            if (iPath != null) {
                if (iPath.segmentCount() > 1 && ((String)(object = iPath.lastSegment())).indexOf(46) != -1) {
                    iPath = iPath.removeLastSegments(1);
                }
                if (this.componentsPath == null || !iPath.equals(this.componentsPath)) {
                    iPath3 = iPath.append(iPath2);
                    int n = this.exists(iPath3);
                    if (n == 1) {
                        return iPath3;
                    }
                    if (n == 2 && this.exists(iPath3 = iPath3.append(LZ_LIBRARY)) == 1) {
                        return iPath3;
                    }
                }
            }
            if (this.componentsPath != null) {
                iPath3 = this.componentsPath.append(iPath2);
                object = iPath3.toFile();
                if (((File)object).exists()) {
                    if (((File)object).isFile()) {
                        return iPath3;
                    }
                    if (((File)object).isDirectory() && ((File)(object = new File((File)object, LZ_LIBRARY))).exists() && ((File)object).isFile()) {
                        return iPath3.append(LZ_LIBRARY);
                    }
                }
                return iPath3;
            }
        }
        return iPath2;
    }

    protected int exists(IPath iPath) {
        File file;
        if (iPath.getDevice() == null) {
            file = null;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            file = iWorkspaceRoot.exists(iPath) ? iWorkspaceRoot.getFile(iPath) : iWorkspaceRoot.getFileForLocation(iPath);
            if (file != null && file.exists()) {
                return file.getType();
            }
        }
        if ((file = iPath.toFile()).exists()) {
            return file.isFile() ? 1 : 2;
        }
        return 0;
    }

    protected void onPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("laszlo.dir".equals(propertyChangeEvent.getProperty())) {
            if (this.includes.size() > 0) {
                this.includes.clear();
            }
            if (this.states.size() > 0) {
                HashMap hashMap = new HashMap(this.states.size());
                Iterator iterator = this.states.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    State state = (State)entry.getValue();
                    if ((state.status & 2) == 0) continue;
                    hashMap.put(entry.getKey(), state);
                }
                this.states.clear();
                this.states = hashMap;
            }
            this.setLaszlo(LaszloPlugin.getDefault().getPreferenceStore());
        }
    }

    protected void setLaszlo(IPreferenceStore iPreferenceStore) {
        File file;
        File file2;
        String string = StringUtils.makeNullIfEmpty((String)iPreferenceStore.getString("laszlo.dir"));
        if (StringUtils.equals((Object)this.fLaszloPath, (Object)string)) {
            return;
        }
        this.fLaszloPath = string;
        if (this.fLaszloPath != null && (file2 = new File(this.fLaszloPath)).exists() && file2.isDirectory() && (file = new File(file2, "lps/components".replace('/', File.separatorChar))).exists() && file.isDirectory()) {
            this.componentsPath = Path.fromOSString((String)file.getAbsolutePath());
            file = new File(file2, "WEB-INF/lps/misc".replace('/', File.separatorChar));
            if (file.exists() && file.isDirectory() && (file = new File(file, "lzx-autoincludes.properties")).exists() && file.isFile()) {
                this.parse(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(File file) {
        String string;
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            if ((string = string.trim()).length() == 0 || string.charAt(0) == '#' || (n = string.indexOf(58)) <= 0) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            this.includes.put(string2, this.componentsPath.append(string3));
        }
        Object var8_8 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            Debug.warn((Throwable)iOException);
        }
        return;
        {
            catch (IOException iOException) {
                Debug.error((Throwable)iOException);
                Object var8_9 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException2) {
                    Debug.warn((Throwable)iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.warn((Throwable)iOException);
            }
            throw throwable;
        }
    }

    static {
        gBufferManager = BufferManager.getDefault();
    }

    private class State {
        private int status;
        private IDOMModel model;

        private State() {
        }
    }
}

