/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.grammars;

import com.spket.laszlo.grammars.LzElement;
import com.spket.laszlo.grammars.LzNodeMap;
import com.spket.laszlo.model.LzHelper;
import com.spket.laszlo.model.LzUnitManager;
import com.spket.util.StringUtils;
import com.spket.xml.IDOMModel;
import com.spket.xml.XMLConstants;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xml.grammars.CMDocument;
import com.spket.xml.grammars.CMElement;
import com.spket.xml.grammars.CMNamedNodeMap;
import com.spket.xml.grammars.NodeMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSNamedMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LzDocument
implements CMDocument {
    private static LzUnitManager gManager = LzUnitManager.getDefault();
    SchemaGrammar grammar;
    private IDOMModel fModel;
    private Map fDecls;
    private Map fClasses;

    public LzDocument(IDOMModel iDOMModel, SchemaGrammar schemaGrammar) {
        this.fModel = iDOMModel;
        this.grammar = schemaGrammar;
    }

    public void clear() {
        if (this.fDecls != null) {
            if (this.fDecls.size() > 0) {
                this.fDecls.clear();
            }
            this.fDecls = null;
        }
        if (this.fClasses != null) {
            if (this.fClasses.size() > 0) {
                this.fClasses.clear();
            }
            this.fClasses = null;
        }
    }

    public CMDocument getDocument() {
        return this;
    }

    public String getNodeName() {
        return XMLConstants.EMPTY_STRING;
    }

    public int getNodeType() {
        return 4;
    }

    public String getNamespace() {
        return this.grammar.getTargetNamespace();
    }

    public Object getProperty(Object object) {
        return null;
    }

    public void setProperty(Object object, Object object2) {
    }

    public CMNamedNodeMap getAttributes() {
        return NodeMap.EMPTY_MAP;
    }

    public CMNamedNodeMap getElements() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.getDecls());
        hashMap.putAll(this.getClasses());
        return new LzNodeMap(this.getNamespace(), hashMap);
    }

    public CMNamedNodeMap getEntities() {
        return null;
    }

    public Map getClasses() {
        if (this.fClasses == null) {
            HashSet hashSet = new HashSet();
            this.fClasses = new HashMap();
            if (this.fModel != null) {
                this.visit(this.fModel, hashSet, this.fClasses);
            }
            Iterator iterator = gManager.getIncludes().entrySet().iterator();
            while (iterator.hasNext()) {
                IDOMModel iDOMModel;
                IPath iPath;
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (this.fClasses.containsKey(k) || hashSet.contains(iPath = (IPath)entry.getValue()) || (iDOMModel = gManager.getModel(iPath)) == null) continue;
                this.visit(iDOMModel, hashSet, this.fClasses);
            }
            if (this.fClasses == null || this.fClasses.size() == 0) {
                this.fClasses = Collections.EMPTY_MAP;
            }
        }
        return this.fClasses;
    }

    protected Map getDecls() {
        if (this.fDecls == null) {
            this.fDecls = new HashMap();
            XSNamedMap xSNamedMap = this.grammar.getComponents((short)2);
            for (int i = 0; i < xSNamedMap.getLength(); ++i) {
                XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSNamedMap.item(i);
                if (xSElementDeclaration.getAbstract()) continue;
                this.fDecls.put(xSElementDeclaration.getName(), new LzElement(this, xSElementDeclaration));
            }
            if (this.fDecls == null || this.fDecls.size() == 0) {
                this.fDecls = Collections.EMPTY_MAP;
            }
        }
        return this.fDecls;
    }

    protected void visit(IDOMModel iDOMModel, Set set, Map map) {
        XMLDocument xMLDocument = iDOMModel.getXMLDocument();
        if (xMLDocument == null) {
            return;
        }
        XMLElement xMLElement = xMLDocument.getDocumentElement();
        if (xMLElement == null) {
            return;
        }
        int n = xMLElement.getChildrenCount();
        if (n == 0) {
            return;
        }
        XMLNode[] xMLNodeArray = xMLElement.getChildren();
        block4: for (int i = 0; i < n; ++i) {
            XMLNode xMLNode = xMLNodeArray[i];
            if (1 != xMLNode.getNodeType()) continue;
            xMLElement = (XMLElement)xMLNode;
            int n2 = LzHelper.getTagId(xMLNode.getLocalName());
            switch (n2) {
                case 31: {
                    String string = StringUtils.makeNullIfEmpty((String)XMLUtils.getAttrValue((XMLElement)xMLElement, (String)"href"));
                    if (string == null) continue block4;
                    Path path = new Path(string);
                    path = gManager.resolve(iDOMModel.getPath(), (IPath)path);
                    if (path == null || set.contains(path)) continue block4;
                    set.add(path);
                    IDOMModel iDOMModel2 = gManager.getModel((IPath)path);
                    if (iDOMModel2 == null) continue block4;
                    this.visit(iDOMModel2, set, map);
                    continue block4;
                }
                case 11: {
                    String string = StringUtils.makeNullIfEmpty((String)XMLUtils.getAttrValue((XMLElement)xMLElement, (String)"name"));
                    if (string == null) continue block4;
                    map.put(string, new LzElement(this, string, xMLElement));
                }
            }
        }
    }

    protected CMElement getElement(IDOMModel iDOMModel, String string, boolean bl) {
        if (iDOMModel == null) {
            return null;
        }
        XMLDocument xMLDocument = iDOMModel.getXMLDocument();
        if (xMLDocument == null) {
            return null;
        }
        XMLElement xMLElement = xMLDocument.getDocumentElement();
        if (xMLElement == null) {
            return null;
        }
        int n = xMLElement.getChildrenCount();
        if (n == 0) {
            return null;
        }
        XMLNode[] xMLNodeArray = xMLElement.getChildren();
        for (int i = 0; i < n; ++i) {
            String string2;
            XMLNode xMLNode = xMLNodeArray[i];
            if (1 != xMLNode.getNodeType() || !"class".equals(xMLNode.getLocalName()) || (string2 = StringUtils.makeNullIfEmpty((String)XMLUtils.getAttrValue((XMLElement)(xMLElement = (XMLElement)xMLNode), (String)"name"))) == null || !string2.equals(string)) continue;
            return new LzElement(this, string, xMLElement);
        }
        return null;
    }
}

