/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.profile;

import com.spket.as.internal.compiler.DefaultErrorHandlingPolicies;
import com.spket.as.internal.compiler.IProblemFactory;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.IdentifierReference;
import com.spket.as.internal.compiler.ast.InclucdeStatement;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.ast.StringLiteral;
import com.spket.as.internal.compiler.ast.UseStatement;
import com.spket.as.internal.compiler.impl.CompilerOptions;
import com.spket.as.internal.compiler.parser.Scanner;
import com.spket.as.internal.compiler.problem.DefaultProblemFactory;
import com.spket.as.internal.compiler.problem.ProblemReporter;
import com.spket.js.internal.JSPlugin;
import com.spket.js.model.JSObject;
import com.spket.js.model.Profile;
import com.spket.js.model.Window;
import com.spket.js.profile.CoreVisitor;
import com.spket.js.profile.ExtVisitor;
import com.spket.js.profile.JQueryVisitor;
import com.spket.js.profile.JSVisitor;
import com.spket.js.profile.ProfileContext;
import com.spket.js.profile.ProfileParser;
import com.spket.js.profile.YUIVisitor;
import com.spket.util.Debug;
import com.spket.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProfileLoader {
    public static final String NS_YUI = "YUI";
    public static final String NS_ExtJS = "ExtJS";
    public static final String NS_JQUERY = "jQuery";
    private static final String JS_SUFFIX = ".js";
    public static final String JSB_SUFFIX = ".jsb";
    private static final String SUFFIX = "-debug.js";
    private static final String A_id = "id";
    public static final String A_name = "name";
    private static final String T_target = "target";
    private static final String T_include = "include";
    private static final String T_profile = "profile";
    private static final String T_profiles = "profiles";
    private static final String[] ORDERS = new String[]{"yahoo", "dom", "event", "datasource", "element", "dragdrop", "animation", "container"};

    private static void list(List list, File file) {
        String[] stringArray;
        if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null && stringArray.length > 0) {
            Object object;
            int n;
            int n2 = -1;
            if (ORDERS[ORDERS.length - 1].equals(file.getName())) {
                n = -1;
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if ("container-debug.js".equals(object)) {
                        n = i;
                        continue;
                    }
                    if (!"container_core-debug.js".equals(object)) continue;
                    n2 = i;
                }
                if (n == -1) {
                    n2 = -1;
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                String string;
                if (n == n2 || !(string = stringArray[n]).endsWith(SUFFIX) || !((File)(object = new File(file, string))).isFile() || !((File)(object = new File(file, string.substring(0, string.length() - SUFFIX.length()) + JS_SUFFIX))).exists() || !((File)object).isFile()) continue;
                list.add(((File)object).getAbsolutePath());
            }
        }
    }

    public static String[] list(String string, String string2) {
        ArrayList<String> arrayList;
        String[] stringArray;
        File file;
        if (NS_YUI.equalsIgnoreCase(string) && (file = new File(string2)).exists() && file.isDirectory()) {
            stringArray = file.list();
            arrayList = new ArrayList<String>();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < ORDERS.length; ++i) {
                    ProfileLoader.list(arrayList, new File(file, ORDERS[i]));
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.addAll(Arrays.asList(stringArray));
                arrayList2.removeAll(Arrays.asList(ORDERS));
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ProfileLoader.list(arrayList, new File(file, (String)arrayList2.get(i)));
                }
            }
            if (arrayList.size() > 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        if ((file = new File(string2)).exists() && file.isDirectory() && (stringArray = file.list()) != null && stringArray.length > 0) {
            arrayList = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                String string3 = stringArray[i];
                if (!string3.endsWith(JS_SUFFIX) || !(file2 = new File(file, string3)).isFile()) continue;
                arrayList.add(file2.getAbsolutePath());
            }
            if (arrayList.size() > 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        return null;
    }

    public static String getNamespace(Expression expression) {
        char[] cArray;
        if (expression instanceof InvokeExpression) {
            expression = ((InvokeExpression)expression).receiver;
        }
        if (expression instanceof IdentifierReference && (cArray = ((IdentifierReference)expression).token) != null && cArray.length > 0) {
            return new String(cArray);
        }
        return null;
    }

    public static CompilationUnitDeclaration parse(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            Scanner scanner = new Scanner(5139);
            scanner.setSource(cArray);
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.sourceLevel = scanner.sourceLevel;
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory());
            ProfileParser profileParser = new ProfileParser(problemReporter, scanner);
            return profileParser.parseProgram();
        }
        return null;
    }

    public static String[] getTargets(Expression[] expressionArray) {
        String[] stringArray = null;
        if (expressionArray != null && expressionArray.length > 0) {
            int n = 0;
            stringArray = new String[expressionArray.length];
            for (int i = 0; i < expressionArray.length; ++i) {
                char[] cArray;
                if (!(expressionArray[i] instanceof StringLiteral) || (cArray = ((StringLiteral)expressionArray[i]).source()) == null || cArray.length <= 0) continue;
                stringArray[n++] = ProfileLoader.decode(cArray);
            }
            if (n == 0) {
                stringArray = null;
            } else if (n < expressionArray.length) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    public static Document getDocument(String string) throws SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new File(string));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public static Element[] getTargets(Document document) {
        Element element;
        if (document != null && (element = document.getDocumentElement()) != null && element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !T_target.equals(node.getNodeName()) || (string = (element = (Element)node).getAttribute(A_name)) == null || string.length() <= 0) continue;
                arrayList.add(element);
            }
            if (arrayList.size() > 0) {
                Element[] elementArray = new Element[arrayList.size()];
                arrayList.toArray(elementArray);
                return elementArray;
            }
        }
        return null;
    }

    public static String[] getIncludes(Element element) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !T_include.equals(node.getNodeName()) || (string = ((Element)node).getAttribute(A_name)) == null || string.length() <= 0) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        return null;
    }

    public static String decode(char[] cArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        try {
            block9: while (n < cArray.length) {
                char c;
                if ((c = cArray[n++]) == '\\') {
                    c = cArray[n++];
                    switch (c) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block9;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block9;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block9;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block9;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block9;
                        }
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Debug.debug((Throwable)indexOutOfBoundsException);
        }
        return stringBuffer.toString();
    }

    public static String escape(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c || c2 == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer.length() != string.length()) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static IFileStore getProfileStore() {
        IPath iPath = JSPlugin.getDefault().getStateLocation().append("profiles.xml");
        return EFS.getLocalFileSystem().getStore(iPath);
    }

    private static String getContent(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (3 != node.getNodeType() && 4 != node.getNodeType()) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(node.getNodeValue());
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Profile[] loadProfiles() throws CoreException {
        InputStream inputStream;
        block13: {
            Profile[] profileArray;
            IFileStore iFileStore = ProfileLoader.getProfileStore();
            IFileInfo iFileInfo = iFileStore.fetchInfo();
            if (!iFileInfo.exists()) return null;
            if (iFileInfo.isDirectory()) return null;
            inputStream = iFileStore.openInputStream(0, null);
            try {
                try {
                    Element element;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(inputStream);
                    if (document == null || (element = document.getDocumentElement()) == null || !element.hasChildNodes()) break block13;
                    NodeList nodeList = element.getChildNodes();
                    ArrayList<Profile> arrayList = new ArrayList<Profile>(nodeList.getLength());
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        profileArray = nodeList.item(i);
                        if (1 != profileArray.getNodeType() || !T_profile.equals(profileArray.getNodeName())) continue;
                        Element element2 = (Element)profileArray;
                        Profile profile = new Profile();
                        profile.setCustom(true);
                        profile.setId(element2.getAttribute(A_id));
                        profile.setName(element2.getAttribute(A_name));
                        ProfileContext profileContext = new ProfileContext(ProfileLoader.getContent(element2), false);
                        profile.setContext(profileContext);
                        arrayList.add(profile);
                    }
                    if (arrayList.size() <= 0) break block13;
                    Profile[] profileArray2 = new Profile[arrayList.size()];
                    arrayList.toArray(profileArray2);
                    profileArray = profileArray2;
                    Object var15_18 = null;
                    if (inputStream == null) return profileArray;
                }
                catch (SAXException sAXException) {
                    throw new CoreException((IStatus)new Status(4, "com.spket.js", 4, sAXException.getLocalizedMessage(), (Throwable)sAXException));
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new CoreException((IStatus)new Status(4, "com.spket.js", 4, parserConfigurationException.getLocalizedMessage(), (Throwable)parserConfigurationException));
                }
                catch (IOException iOException) {
                    throw new CoreException((IStatus)new Status(4, "com.spket.js", 4, iOException.getLocalizedMessage(), (Throwable)iOException));
                }
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                // empty catch block
                return profileArray;
            }
            inputStream.close();
            return profileArray;
        }
        Object var15_19 = null;
        if (inputStream == null) return null;
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveProfiles(Profile[] profileArray, List list, List list2) throws CoreException {
        OutputStream outputStream = null;
        IFileStore iFileStore = ProfileLoader.getProfileStore();
        try {
            try {
                if (profileArray == null || profileArray.length == 0) {
                    iFileStore.delete(0, null);
                } else {
                    Object object;
                    Object object2;
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element element = document.createElement(T_profiles);
                    for (int i = 0; i < profileArray.length; ++i) {
                        object2 = profileArray[i];
                        object = document.createElement(T_profile);
                        object.setAttribute(A_id, ((Profile)object2).getId());
                        object.setAttribute(A_name, (String)list.get(i));
                        String string = (String)list2.get(i);
                        object.appendChild(document.createTextNode(string));
                        element.appendChild((Node)object);
                    }
                    document.appendChild(element);
                    outputStream = iFileStore.openOutputStream(2, null);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("indent", "yes");
                    object2 = new DOMSource(document);
                    object = new StreamResult(outputStream);
                    transformer.transform((Source)object2, (Result)object);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new CoreException((IStatus)new Status(4, "com.spket.js", 4, parserConfigurationException.getLocalizedMessage(), (Throwable)parserConfigurationException));
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                throw new CoreException((IStatus)new Status(4, "com.spket.js", 4, transformerFactoryConfigurationError.getLocalizedMessage(), (Throwable)transformerFactoryConfigurationError));
            }
            catch (TransformerException transformerException) {
                throw new CoreException((IStatus)new Status(4, "com.spket.js", 4, transformerException.getLocalizedMessage(), (Throwable)transformerException));
            }
            Object var14_17 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        outputStream.close();
        return;
    }

    public JSObject load(String string, boolean bl) throws IOException {
        return this.load(string, JSPlugin.getDefault().getBundle(), "dhtml.js", bl);
    }

    public JSObject load(String string, Bundle bundle, String string2, boolean bl) throws IOException {
        Statement[] statementArray;
        CompilationUnitDeclaration compilationUnitDeclaration;
        char[] cArray;
        Window window = new Window();
        CoreVisitor coreVisitor = new CoreVisitor();
        coreVisitor.load(window, bundle, string2);
        FileUtils fileUtils = new FileUtils();
        if (bl) {
            if ('/' != File.separatorChar) {
                string = string.replace('/', File.separatorChar);
            }
            if ('\\' != File.separatorChar) {
                string = string.replace('\\', File.separatorChar);
            }
            cArray = fileUtils.getContents(string);
        } else {
            cArray = string.toCharArray();
        }
        if (cArray != null && cArray.length > 0 && (compilationUnitDeclaration = ProfileLoader.parse(cArray)) != null && (statementArray = compilationUnitDeclaration.statements) != null && statementArray.length > 0) {
            String[] stringArray = null;
            JSVisitor jSVisitor = null;
            for (int i = 0; i < statementArray.length; ++i) {
                Object[] objectArray;
                String string3;
                InclucdeStatement inclucdeStatement;
                Statement statement = statementArray[i];
                if (statement instanceof InclucdeStatement) {
                    if (jSVisitor == null) {
                        jSVisitor = new JSVisitor();
                    }
                    inclucdeStatement = (InclucdeStatement)statement;
                    if (inclucdeStatement.filename == null || inclucdeStatement.filename.length <= 0) continue;
                    string3 = ProfileLoader.decode(inclucdeStatement.filename);
                    if (bl) {
                        string3 = fileUtils.resolve(string, string3, true);
                    }
                    jSVisitor.setScope(window);
                    if (string3.endsWith(JSB_SUFFIX)) {
                        try {
                            objectArray = this.getIncludes(string3, stringArray);
                        }
                        catch (SAXException sAXException) {
                            IOException iOException = new IOException(sAXException.getLocalizedMessage());
                            iOException.initCause(sAXException);
                            throw iOException;
                        }
                        if (objectArray == null) continue;
                        for (int j = 0; j < objectArray.length; ++j) {
                            jSVisitor.visit(fileUtils.resolve(string3, (String)objectArray[j], true));
                        }
                        continue;
                    }
                    jSVisitor.visit(string3);
                    continue;
                }
                if (!(statement instanceof UseStatement)) continue;
                stringArray = null;
                inclucdeStatement = ((UseStatement)statement).namespaces;
                string3 = ProfileLoader.getNamespace((Expression)inclucdeStatement);
                if (string3 == null) continue;
                if (NS_ExtJS.equalsIgnoreCase(string3)) {
                    jSVisitor = new ExtVisitor();
                } else if (NS_YUI.equalsIgnoreCase(string3)) {
                    jSVisitor = new YUIVisitor();
                } else if (NS_JQUERY.equalsIgnoreCase(string3)) {
                    jSVisitor = new JQueryVisitor();
                }
                if (!(inclucdeStatement instanceof InvokeExpression) || (objectArray = ((InvokeExpression)inclucdeStatement).arguments) == null || objectArray.length <= 0) continue;
                stringArray = ProfileLoader.getTargets(objectArray);
            }
        }
        return window;
    }

    private String[] getIncludes(String string, String[] stringArray) throws SAXException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element[] elementArray = ProfileLoader.getTargets(ProfileLoader.getDocument(string));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = false;
            for (int j = 0; j < elementArray.length; ++j) {
                String[] stringArray2;
                Element element = elementArray[j];
                if (!string2.equals(element.getAttribute(A_name))) continue;
                bl = true;
                if (!element.hasChildNodes() || (stringArray2 = ProfileLoader.getIncludes(element)) == null || stringArray2.length <= 0) break;
                arrayList.addAll(Arrays.asList(stringArray2));
                break;
            }
            if (bl) continue;
            throw new IOException("Target '" + string2 + "' not found!");
        }
        if (arrayList.size() > 0) {
            String[] stringArray3 = new String[arrayList.size()];
            arrayList.toArray(stringArray3);
            return stringArray3;
        }
        return null;
    }
}

