/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.preferences;

import com.spket.js.preferences.JSPMessages;
import com.spket.js.preferences.ProfileItem;
import com.spket.ui.internal.dialogfields.DialogField;
import com.spket.ui.internal.dialogfields.IDialogFieldListener;
import com.spket.ui.internal.dialogfields.LayoutUtil;
import com.spket.ui.internal.dialogfields.StringDialogField;
import com.spket.ui.util.StatusInfo;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProfileDialog
extends StatusDialog {
    private List fProfiles;
    private ProfileItem fProfile;
    private StringDialogField fNameField;

    public ProfileDialog(Shell shell, ProfileItem profileItem, List list) {
        super(shell);
        this.fProfile = profileItem;
        this.fProfiles = list;
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(JSPMessages.ProfileDialog_name_label);
        this.fNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                ProfileDialog.this.validation();
            }
        });
        if (profileItem == null) {
            this.setTitle(JSPMessages.ProfileDialog_new_title);
            this.fNameField.setText("");
        } else {
            this.setTitle(JSPMessages.ProfileDialog_edit_title);
            this.fNameField.setTextWithoutUpdate(profileItem.getName());
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fNameField.doFillIntoGrid(composite3, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fNameField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
        this.fNameField.postSetFocusOnDialogField(composite.getDisplay());
        ProfileDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public String getProfileName() {
        return this.fNameField.getText().trim();
    }

    private void validation() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fNameField.getText().trim();
        if (string.length() == 0) {
            statusInfo.setError(JSPMessages.ProfileDialog_error_enterName);
        } else {
            for (int i = 0; i < this.fProfiles.size(); ++i) {
                ProfileItem profileItem = (ProfileItem)((Object)this.fProfiles.get(i));
                if (profileItem == this.fProfile || !string.equals(profileItem.getName())) continue;
                statusInfo.setError(JSPMessages.ProfileDialog_error_entryExists);
                break;
            }
        }
        this.updateStatus((IStatus)statusInfo);
    }
}

