/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.preferences;

import com.spket.js.internal.JSPlugin;
import com.spket.js.preferences.JSPMessages;
import com.spket.ui.preferences.AbstractPreferencePage;
import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class JSEditorPreferencePage
extends AbstractPreferencePage {
    private Control[] proposeControls;
    private Control btnBlocks;
    private Control[] blockLines;

    protected IPreferenceStore doGetPreferenceStore() {
        return JSPlugin.getDefault().getPreferenceStore();
    }

    protected Plugin getPlugin() {
        return JSPlugin.getDefault();
    }

    protected String getPluginId() {
        return "com.spket.js";
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createHeader(composite2);
        this.createEditorPage(composite2);
        return composite2;
    }

    protected void initialize() {
        super.initialize();
        this.updateAutoactivationControls();
        this.updateBlockControls();
    }

    protected void onFieldChanged(String string, Control control) {
        if ("autoPropose".equals(string)) {
            this.updateAutoactivationControls();
        } else if ("js_folding".equals(string)) {
            this.updateBlockControls();
        } else if ("js_folding_blocks".equals(string)) {
            this.updateBlockLineControls(true);
        }
    }

    private void updateAutoactivationControls() {
        if (this.proposeControls != null) {
            boolean bl = this.getOverlayPreferenceStore().getBoolean("autoPropose");
            for (int i = 0; i < this.proposeControls.length; ++i) {
                this.proposeControls[i].setEnabled(bl);
            }
        }
    }

    private void updateBlockControls() {
        boolean bl = this.getOverlayPreferenceStore().getBoolean("js_folding");
        this.btnBlocks.setEnabled(bl);
        this.updateBlockLineControls(bl);
    }

    private void updateBlockLineControls(boolean bl) {
        if (this.blockLines != null) {
            if (bl) {
                bl = this.getOverlayPreferenceStore().getBoolean("js_folding_blocks");
            }
            for (int i = 0; i < this.blockLines.length; ++i) {
                this.blockLines[i].setEnabled(bl);
            }
        }
    }

    private void createHeader(Composite composite) {
        Link link = new Link(composite, 0);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        link.setText(JSPMessages.Page_TextEditor_link);
        link.setToolTipText(JSPMessages.Page_TextEditor_link_tooltip);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)JSEditorPreferencePage.this.getControl().getShell(), (String)event.text, null, null);
            }
        });
        this.createLable(composite, StringUtils.EMPTY_STRING, 1);
    }

    private void createEditorPage(Composite composite) {
        this.addCheckBox(composite, JSPMessages.Pre_showSyntaxError, "syx.error", 1, 0);
        this.addCheckBox(composite, JSPMessages.Pre_highlightMatchingBrackets, "matchingBrackets", 1, 0);
        this.createLable(composite, StringUtils.EMPTY_STRING, 1);
        Composite composite2 = this.createSubsection(composite, JSPMessages.Pre_autoactivationSection_title, 2);
        this.addCheckBox(composite2, JSPMessages.Pre_enableAutoActivation, "autoPropose", 2, 0);
        this.proposeControls = new Control[4];
        Control[] controlArray = this.addLabelledTextField(composite2, JSPMessages.Pre_autoActivationDelay, "autoDelay", 4, 0, true);
        this.proposeControls[0] = controlArray[0];
        this.proposeControls[1] = controlArray[1];
        controlArray = this.addLabelledTextField(composite2, JSPMessages.Pre_autoActivationTriggers, "autoProposeChar", 4, 0, false);
        this.proposeControls[2] = controlArray[0];
        this.proposeControls[3] = controlArray[1];
        composite2 = this.createSubsection(composite, JSPMessages.Pre_Folding_title, 2);
        this.addCheckBox(composite2, JSPMessages.Pre_Folding, "js_folding", 2, 0);
        this.btnBlocks = this.addCheckBox(composite2, JSPMessages.Pre_Folding_blocks, "js_folding_blocks", 2, 20);
        this.blockLines = this.addLabelledTextField(composite2, JSPMessages.Pre_Folding_blocks_label, "js_folding_lines", 4, 40, true);
        GridData gridData = (GridData)this.createLable(composite2, JSPMessages.Pre_Folding_initially, 2).getLayoutData();
        gridData.verticalIndent = 10;
        this.addCheckBox(composite2, JSPMessages.Pre_Folding_comments, "js_folding_comments", 2, 20);
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "syx.error"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "autoPropose"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "autoDelay"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "autoProposeChar"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "js_folding"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "js_folding_blocks"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "js_folding_lines"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "js_folding_comments"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "js.profile"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }
}

