/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.parser;

import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.as.internal.compiler.parser.ScannerHelper;
import com.spket.buffer.BufferChangedEvent;
import com.spket.buffer.BufferManager;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferListener;
import com.spket.js.parser.ScriptParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ScriptManager {
    private static final int F_ERROR = 1;
    private static BufferManager gBufferManager = BufferManager.getDefault();
    private static ScriptManager manager;
    private static Map managers;
    private static ScriptParser parser;
    private int sourceLevel;
    private Map states = new HashMap();

    public static ScriptManager getManager(int n) {
        if (manager == null) {
            manager = new ScriptManager(n);
        } else if (ScriptManager.manager.sourceLevel != n) {
            Integer n2 = new Integer(n);
            ScriptManager scriptManager = (ScriptManager)managers.get(n2);
            if (scriptManager == null) {
                scriptManager = new ScriptManager(n);
                managers.put(n2, scriptManager);
            }
            return scriptManager;
        }
        return manager;
    }

    private ScriptManager(int n) {
        this.sourceLevel = n;
    }

    public BufferedScanner getLexer(IPath iPath) {
        State state = this.getState(iPath, true);
        return state == null ? null : state.getLexer();
    }

    protected void searchInclude(List list, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        StringBuffer stringBuffer = null;
        block4: while (n4 < n2) {
            char c = cArray[n4++];
            switch (c) {
                case '@': {
                    if (n3 == 0 && n4 + 7 < n2) {
                        if (cArray[n4++] == 'i' && cArray[n4++] == 'n' && cArray[n4++] == 'c' && cArray[n4++] == 'l' && cArray[n4++] == 'u' && cArray[n4++] == 'd' && cArray[n4++] == 'e') {
                            n3 = 1;
                            continue block4;
                        }
                        --n4;
                        continue block4;
                    }
                    if (n3 != 2) continue block4;
                    stringBuffer.append(c);
                    continue block4;
                }
                case '\"': {
                    if (n3 == 1) {
                        n3 = 2;
                        stringBuffer = new StringBuffer();
                        continue block4;
                    }
                    if (n3 != 2) continue block4;
                    n3 = 0;
                    if (stringBuffer.length() > 0) {
                        list.add(stringBuffer.toString());
                    }
                    stringBuffer = null;
                    continue block4;
                }
            }
            if (n3 == 1) {
                if (ScannerHelper.isWhitespace((char)c)) continue;
                n3 = 0;
                continue;
            }
            if (n3 != 2) continue;
            stringBuffer.append(c);
        }
    }

    public List getIncludes(BufferedScanner bufferedScanner) {
        ArrayList arrayList = null;
        int n = bufferedScanner.eofPosition;
        int n2 = bufferedScanner.commentPtr;
        if (n2 >= 0) {
            if (bufferedScanner.getSize() > 0) {
                n = bufferedScanner.getTokenStart(0);
            }
            for (int i = 0; i <= n2; ++i) {
                int n3 = bufferedScanner.commentStarts[i];
                if (n3 < 0) continue;
                if (n3 > n) break;
                int n4 = bufferedScanner.commentTagStarts[i];
                if (n4 > n3) {
                    n3 = n4;
                }
                if ((n4 = bufferedScanner.commentStops[i]) < 0) {
                    n4 = -n4;
                }
                if (n4 <= n3) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList(4);
                }
                this.searchInclude(arrayList, bufferedScanner.source, n3, n4);
            }
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    public List getIncludes(String string) {
        BufferedScanner bufferedScanner;
        Path path = new Path(string);
        State state = this.getState((IPath)path, true);
        if (state != null && (bufferedScanner = state.getLexer()) != null) {
            bufferedScanner.prepare();
            return this.getIncludes(bufferedScanner);
        }
        return Collections.EMPTY_LIST;
    }

    public ASTNode[] getStatements(IPath iPath) {
        State state = this.getState(iPath, true);
        return state == null ? ScriptParser.NO_NODE : state.getNodes();
    }

    protected String resolve(String string, String string2) {
        char c;
        if (string2.length() == 0) {
            return null;
        }
        if (string != null && (c = string2.charAt(0)) != '/' && c != '\\' && string2.indexOf(58) <= 0) {
            string2 = string2.replace('\\', '/');
            try {
                URI uRI = new URI(string);
                uRI = uRI.resolve(string2);
                return uRI.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        return string2;
    }

    public Collection expandIncludes(List list, String string) {
        LinkedHashSet<String> linkedHashSet = Collections.EMPTY_SET;
        if (list != null && list.size() > 0) {
            String string2 = string;
            HashSet<String> hashSet = new HashSet<String>();
            if (string != null) {
                if (this.states.containsKey(string)) {
                    hashSet.add(string);
                } else {
                    string2 = string;
                    if (string != null) {
                        hashSet.add(string);
                    }
                }
            }
            Stack<String> stack = new Stack<String>();
            linkedHashSet = new LinkedHashSet<String>();
            while (true) {
                if (list != null && list.size() > 0) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        String string3 = this.resolve(string2, (String)list.get(i));
                        if (string3 == null) continue;
                        stack.push(string3);
                    }
                }
                if (stack.isEmpty()) break;
                string2 = (String)stack.peek();
                if (hashSet.contains(string2)) {
                    list = null;
                } else {
                    hashSet.add(string2);
                    list = this.getIncludes(string2);
                }
                if (list != null && list.size() != 0) continue;
                stack.pop();
                if (string2.equals(string)) continue;
                linkedHashSet.add(string2);
            }
        }
        return linkedHashSet;
    }

    protected State getState(IPath iPath, boolean bl) {
        State state = (State)this.states.get(iPath);
        if (state == null) {
            IPath iPath2 = gBufferManager.resolve(iPath);
            if (iPath2 != iPath) {
                iPath = iPath2;
                state = (State)this.states.get(iPath);
            }
            if (state == null && bl) {
                state = new State(this.sourceLevel);
                state.path = iPath;
                this.states.put(iPath, state);
            }
        }
        return state;
    }

    static {
        managers = new HashMap();
        parser = new ScriptParser();
    }

    private static final class State {
        public IPath path;
        public int state;
        public ASTNode[] nodes;
        private int sourceLevel;
        public IBuffer buffer;
        public BufferedScanner lexer;

        public State(int n) {
            this.sourceLevel = n;
        }

        public synchronized BufferedScanner getLexer() {
            if (this.lexer == null) {
                if ((this.state & 1) != 0 || this.path == null) {
                    return null;
                }
                char[] cArray = null;
                if (this.buffer == null) {
                    this.buffer = gBufferManager.getBuffer(this.path);
                    if (this.buffer != null) {
                        this.buffer.addBufferListener(new IBufferListener(this){
                            private final /* synthetic */ State this$0;
                            {
                                this.this$0 = state;
                            }

                            public void bufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
                            }

                            public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
                                this.this$0.setDirty();
                            }

                            public void bufferClosed(IBuffer iBuffer) {
                                this.this$0.buffer = null;
                                this.this$0.setDirty();
                            }
                        });
                    }
                }
                if (this.buffer != null) {
                    cArray = this.buffer.get();
                }
                if (cArray == null) {
                    this.state |= 1;
                } else {
                    this.lexer = new BufferedScanner(this.sourceLevel);
                    this.lexer.setSource(cArray);
                    this.lexer.prepare();
                }
            }
            return this.lexer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ASTNode[] getNodes() {
            if (this.nodes == null) {
                BufferedScanner bufferedScanner = this.getLexer();
                if (bufferedScanner != null) {
                    ScriptParser scriptParser = parser;
                    synchronized (scriptParser) {
                        parser.setLexer(bufferedScanner);
                        BufferedScanner bufferedScanner2 = bufferedScanner;
                        synchronized (bufferedScanner2) {
                            bufferedScanner.setRange(0, bufferedScanner.getLength());
                            this.nodes = parser.parse(4);
                        }
                    }
                }
                if (this.nodes == null) {
                    this.nodes = ScriptParser.NO_NODE;
                }
            }
            return this.nodes;
        }

        public synchronized void setDirty() {
            this.nodes = null;
            this.lexer = null;
            this.state &= 0xFFFFFFFE;
        }
    }
}

