/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.parser;

import com.spket.as.internal.compiler.CompilationResult;
import com.spket.as.internal.compiler.DefaultErrorHandlingPolicies;
import com.spket.as.internal.compiler.IProblemFactory;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.impl.CompilerOptions;
import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.as.internal.compiler.parser.IMonitor;
import com.spket.as.internal.compiler.parser.Scanner;
import com.spket.as.internal.compiler.problem.DefaultProblemFactory;
import com.spket.as.internal.compiler.problem.ProblemReporter;
import com.spket.js.model.Context;
import com.spket.js.model.IASTListener;
import com.spket.js.model.IASTProvider;
import com.spket.js.model.ILexerProvider;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Scope;
import com.spket.js.parser.AssistParser;
import com.spket.js.parser.ILexerListener;
import com.spket.js.parser.ScriptManager;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class LexerProvider
implements ILexerProvider,
IASTProvider,
IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final int DELAY = 500;
    private IPath fPath;
    private boolean running;
    private IDocument fDocument;
    private BufferedScanner fLexer;
    private CompilationUnitDeclaration fUnit;
    private Context fContext;
    private boolean fReportSyntaxError;
    private Monitor fMonitor = new Monitor();
    private ListenerList fListeners = new ListenerList(1);
    private ListenerList fASTListeners = new ListenerList(1);

    public void addLexerListener(ILexerListener iLexerListener) {
        if (this.fListeners != null) {
            this.fListeners.add((Object)iLexerListener);
        }
    }

    public void removeLexerListener(ILexerListener iLexerListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iLexerListener);
        }
    }

    public void addASTListener(IASTListener iASTListener) {
        if (this.fASTListeners != null) {
            this.fASTListeners.add((Object)iASTListener);
        }
    }

    public void removeASTListener(IASTListener iASTListener) {
        if (this.fASTListeners != null) {
            this.fASTListeners.remove((Object)iASTListener);
        }
    }

    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.fUnit;
    }

    public void dispose() {
        this.running = false;
        this.fDocument = null;
        this.fLexer = null;
        this.fUnit = null;
        if (this.fListeners != null) {
            this.fListeners.clear();
            this.fListeners = null;
        }
        if (this.fASTListeners != null) {
            this.fASTListeners.clear();
            this.fASTListeners = null;
        }
        this.fPath = null;
    }

    public String[] getIncludes() {
        return null;
    }

    public BufferedScanner[] getScripts() {
        return null;
    }

    public Context getContext() {
        return this.fContext;
    }

    public void setContext(Context context) {
        this.fContext = context;
    }

    public JSObject getGlobalForEdit() {
        JSObject jSObject = null;
        Context context = this.getContext();
        jSObject = context != null && context.isInitialized() ? ((jSObject = context.getGlobalForEdit()) == null ? new ObjectImpl() : new Scope(new ObjectImpl(jSObject.getClassName()), jSObject)) : new ObjectImpl();
        return jSObject;
    }

    public JSObject getThisScope(JSObject jSObject) {
        return jSObject;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public void setPath(IPath iPath) {
        this.fPath = iPath;
    }

    public void setReportSyntaxError(boolean bl) {
        this.fReportSyntaxError = bl;
    }

    public int getSourceLevel() {
        return this.fContext == null ? Context.JS_1_6 : this.fContext.getSourceLevel();
    }

    public ScriptManager getManager() {
        if (this.fContext == null) {
            ScriptManager.getManager(this.getSourceLevel());
        }
        return this.fContext.getManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedScanner getLexer() {
        BufferedScanner bufferedScanner;
        if (this.fDocument == null) {
            return null;
        }
        boolean bl = false;
        LexerProvider lexerProvider = this;
        synchronized (lexerProvider) {
            if (this.running) {
                int n = 0;
                while (this.running && n++ <= 2) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.running = false;
            }
            if (this.fLexer == null) {
                bl = true;
                this.fLexer = this.createLexer();
            }
            bufferedScanner = this.fLexer;
        }
        if (bl) {
            this.notifyLexerChanged(bufferedScanner, true);
        }
        return bufferedScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedScanner getLexer(boolean bl) {
        BufferedScanner bufferedScanner;
        if (bl) {
            return this.getLexer();
        }
        LexerProvider lexerProvider = this;
        synchronized (lexerProvider) {
            bufferedScanner = this.running ? null : this.fLexer;
        }
        return bufferedScanner;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IDocument iDocument) {
        if (this.fDocument == iDocument) {
            return;
        }
        this.fDocument = iDocument;
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty() {
        Object[] objectArray = this;
        synchronized (this) {
            int n;
            if (this.fLexer == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.fLexer = null;
            this.fMonitor.cancel();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.fListeners != null) {
                objectArray = this.fListeners.getListeners();
                for (n = 0; n < objectArray.length; ++n) {
                    ((ILexerListener)objectArray[n]).lexerAboutToBeChanged();
                }
            }
            if (this.fASTListeners != null) {
                objectArray = this.fASTListeners.getListeners();
                for (n = 0; n < objectArray.length; ++n) {
                    ((IASTListener)objectArray[n]).astAboutToBeChanged();
                }
            }
            return;
        }
    }

    public void initialReconcile() {
        this.internalReconcile();
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion iRegion) {
        this.internalReconcile();
    }

    public void reconcile(IRegion iRegion) {
        this.internalReconcile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalReconcile() {
        LexerProvider lexerProvider;
        if (this.fDocument == null) {
            return;
        }
        LexerProvider lexerProvider2 = this;
        synchronized (lexerProvider2) {
            if (this.fLexer != null) {
                return;
            }
            this.running = true;
            this.fMonitor.reset();
        }
        lexerProvider2 = null;
        try {
            lexerProvider2 = this.createLexer();
            Object var4_3 = null;
            lexerProvider = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            LexerProvider lexerProvider3 = this;
            synchronized (lexerProvider3) {
                this.fLexer = lexerProvider2;
                this.running = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (lexerProvider) {
            this.fLexer = lexerProvider2;
            this.running = false;
            this.notifyAll();
        }
        this.notifyLexerChanged(this.fLexer, false);
        this.fUnit = this.parse((BufferedScanner)lexerProvider2);
        this.notifyASTChanged(this.fUnit);
    }

    private char[] getFilename() {
        IPath iPath = this.getPath();
        if (iPath == null || iPath.segmentCount() == 0) {
            return null;
        }
        return iPath.lastSegment().toCharArray();
    }

    private CompilationUnitDeclaration parse(BufferedScanner bufferedScanner) {
        if (bufferedScanner == null) {
            return null;
        }
        bufferedScanner = new BufferedScanner(bufferedScanner, 0, bufferedScanner.getSize());
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.sourceLevel = bufferedScanner.sourceLevel;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory());
        AssistParser assistParser = new AssistParser(problemReporter);
        assistParser.setMonitor(this.fMonitor);
        assistParser.reportSyntaxErrorIsRequired = this.fReportSyntaxError;
        CompilationResult compilationResult = new CompilationResult(this.getFilename(), 1, 1, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        try {
            compilationUnitDeclaration = assistParser.parse((Scanner)bufferedScanner, compilationResult);
        }
        catch (RuntimeException runtimeException) {
            Debug.debug((Throwable)runtimeException);
        }
        return compilationUnitDeclaration;
    }

    private BufferedScanner createLexer() {
        BufferedScanner bufferedScanner = null;
        int n = this.getSourceLevel();
        if (this.fPath != null) {
            bufferedScanner = ScriptManager.getManager(n).getLexer(this.fPath);
        }
        if (bufferedScanner == null) {
            bufferedScanner = new BufferedScanner(n);
            if (this.fDocument.getLength() > 0) {
                bufferedScanner.setSource(this.fDocument.get().toCharArray());
            } else {
                bufferedScanner.setSource(StringUtils.EMPTY_CHARS);
            }
        }
        bufferedScanner.prepare();
        return bufferedScanner;
    }

    protected void notifyASTChanged(CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.fASTListeners != null && !this.fASTListeners.isEmpty() && this.fASTListeners != null) {
            Object[] objectArray = this.fASTListeners.getListeners();
            for (int i = 0; i < objectArray.length; ++i) {
                ((IASTListener)objectArray[i]).astChanged(compilationUnitDeclaration);
            }
        }
    }

    protected void notifyLexerChanged(final BufferedScanner bufferedScanner, boolean bl) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            if (bl) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (LexerProvider.this.fLexer == bufferedScanner) {
                            Object[] objectArray = LexerProvider.this.fListeners.getListeners();
                            for (int i = 0; i < objectArray.length; ++i) {
                                ((ILexerListener)objectArray[i]).lexerChanged(bufferedScanner);
                            }
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                thread.start();
            } else if (this.fLexer == bufferedScanner) {
                Object[] objectArray = this.fListeners.getListeners();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((ILexerListener)objectArray[i]).lexerChanged(bufferedScanner);
                }
            }
        }
    }

    private static class Monitor
    implements IMonitor {
        private boolean fCancelled;

        private Monitor() {
        }

        public void reset() {
            this.fCancelled = false;
        }

        public void cancel() {
            this.fCancelled = true;
        }

        public boolean isCancelled() {
            return this.fCancelled;
        }
    }
}

