/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.parser;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.ArrayInitializer;
import com.spket.as.internal.compiler.ast.Assignment;
import com.spket.as.internal.compiler.ast.BinaryExpression;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.BooleanLiteral;
import com.spket.as.internal.compiler.ast.BreakStatement;
import com.spket.as.internal.compiler.ast.CaseStatement;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.ast.CompoundAssignment;
import com.spket.as.internal.compiler.ast.ConditionalExpression;
import com.spket.as.internal.compiler.ast.ContinueStatement;
import com.spket.as.internal.compiler.ast.DefaultXMLNSStatement;
import com.spket.as.internal.compiler.ast.DoStatement;
import com.spket.as.internal.compiler.ast.EmptyStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.ExpressionStatement;
import com.spket.as.internal.compiler.ast.FieldLiteral;
import com.spket.as.internal.compiler.ast.ForStatement;
import com.spket.as.internal.compiler.ast.FunctionDeclaration;
import com.spket.as.internal.compiler.ast.FunctionExpression;
import com.spket.as.internal.compiler.ast.IdentifierReference;
import com.spket.as.internal.compiler.ast.IfStatement;
import com.spket.as.internal.compiler.ast.ImportStatement;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.LabelStatement;
import com.spket.as.internal.compiler.ast.NamespaceDeclaration;
import com.spket.as.internal.compiler.ast.NullLiteral;
import com.spket.as.internal.compiler.ast.NumberLiteral;
import com.spket.as.internal.compiler.ast.ObjectInitializer;
import com.spket.as.internal.compiler.ast.PackageDeclaration;
import com.spket.as.internal.compiler.ast.Parameter;
import com.spket.as.internal.compiler.ast.PostfixExpression;
import com.spket.as.internal.compiler.ast.PragmaStatement;
import com.spket.as.internal.compiler.ast.PrefixExpression;
import com.spket.as.internal.compiler.ast.QualifiedExpressionReference;
import com.spket.as.internal.compiler.ast.RegExpLiteral;
import com.spket.as.internal.compiler.ast.ReturnStatement;
import com.spket.as.internal.compiler.ast.StringLiteral;
import com.spket.as.internal.compiler.ast.SuperExpression;
import com.spket.as.internal.compiler.ast.SuperReference;
import com.spket.as.internal.compiler.ast.SwitchStatement;
import com.spket.as.internal.compiler.ast.ThisReference;
import com.spket.as.internal.compiler.ast.ThrowStatement;
import com.spket.as.internal.compiler.ast.TryStatement;
import com.spket.as.internal.compiler.ast.TypeDeclaration;
import com.spket.as.internal.compiler.ast.UnaryExpression;
import com.spket.as.internal.compiler.ast.UseStatement;
import com.spket.as.internal.compiler.ast.VariableBinding;
import com.spket.as.internal.compiler.ast.VariableDeclaration;
import com.spket.as.internal.compiler.ast.WhileStatement;
import com.spket.as.internal.compiler.ast.Wildcard;
import com.spket.as.internal.compiler.ast.WithStatement;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.js.model.Context;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSDocImpl;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.ScriptFunction;
import com.spket.util.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Point;

public class ExpressionEvaluator
extends ASTVisitor {
    private int count;
    private JSObject[] items = new JSObject[10];
    protected Context context;

    public ExpressionEvaluator(Context context) {
        this.context = context;
    }

    public List visit(String string, ASTNode[] aSTNodeArray, BufferedScanner bufferedScanner, JSObject jSObject, JSObject jSObject2) {
        if (aSTNodeArray == null || aSTNodeArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        ScopeFrame scopeFrame = new ScopeFrame(string, bufferedScanner, jSObject, jSObject2);
        for (int i = 0; i < aSTNodeArray.length; ++i) {
            Object object;
            Object object2;
            int n = this.size();
            ASTNode aSTNode = aSTNodeArray[i];
            if (aSTNode instanceof ReturnStatement) {
                object2 = ((ReturnStatement)aSTNode).expression;
                if (object2 == null) continue;
                object2.traverse((ASTVisitor)this, (Frame)scopeFrame);
                object = this.pop(n);
                if (object == null) continue;
                arrayList.add(object);
                continue;
            }
            aSTNode.traverse((ASTVisitor)this, (Frame)scopeFrame);
            if (!(aSTNode instanceof FunctionExpression) || !((object2 = this.pop(n)) instanceof JSFunction) || (object = object2.getClassName()) == null || ((String)object).length() <= 0) continue;
            JSDocImpl jSDocImpl = null;
            ISlot iSlot = this.setProperty(scopeFrame, aSTNode, jSObject, (String)object, (JSObject)object2, true);
            if (iSlot == null) continue;
            if (object2 instanceof ScriptFunction) {
                jSDocImpl = new JSDocImpl(aSTNode.sourceStart, bufferedScanner);
                ((ScriptFunction)object2).setDocument(jSDocImpl);
            }
            if (iSlot.getData(ISlot.P_COMMENT) != null) continue;
            if (jSDocImpl == null) {
                jSDocImpl = new JSDocImpl(aSTNode.sourceStart, bufferedScanner);
            }
            iSlot.setData(ISlot.P_COMMENT, jSDocImpl);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public JSObject eval(String string, Expression expression, BufferedScanner bufferedScanner, JSObject jSObject, JSObject jSObject2) {
        ScopeFrame scopeFrame = new ScopeFrame(string, bufferedScanner, jSObject, jSObject2);
        int n = this.size();
        try {
            expression.traverse((ASTVisitor)this, (Frame)scopeFrame);
            return this.pop(n);
        }
        catch (RuntimeException runtimeException) {
            Debug.debug((Throwable)runtimeException);
            return null;
        }
    }

    public boolean resolveParameters(BufferedScanner bufferedScanner, JSObject jSObject, String string, FunctionExpression functionExpression, JSDoc jSDoc, boolean bl) {
        return false;
    }

    protected int size() {
        return this.count;
    }

    protected void push(JSObject jSObject) {
        if (this.items == null) {
            this.items = new JSObject[10];
        } else if (this.count >= this.items.length) {
            JSObject[] jSObjectArray = new JSObject[this.count + 10];
            System.arraycopy(this.items, 0, jSObjectArray, 0, this.count);
            this.items = jSObjectArray;
        }
        this.items[this.count++] = jSObject;
    }

    protected JSObject pop(int n) {
        if (n + 1 == this.count) {
            --this.count;
            return this.items[this.count];
        }
        if (this.count < n) {
            throw new IllegalStateException("Stack Point: " + this.count + " - " + n);
        }
        this.count = n;
        return null;
    }

    protected void reset(int n) {
        if (this.count > n) {
            this.count = n;
        } else if (this.count < n) {
            throw new IllegalStateException("Stack Point: " + this.count + " - " + n);
        }
    }

    protected JSObject getProperty(Frame frame, JSObject jSObject, String string) {
        ISlot iSlot = jSObject.getSlot(string);
        if (iSlot != null) {
            JSObject jSObject2 = iSlot.getObject();
            if (jSObject2 == null && (jSObject2 = jSObject.createProperty(((ScopeFrame)frame).localScope, string)) != null) {
                iSlot.setObject(jSObject2);
            }
            return jSObject2;
        }
        return null;
    }

    protected ISlot setProperty(ScopeFrame scopeFrame, ASTNode aSTNode, JSObject jSObject, String string, JSObject jSObject2, boolean bl) {
        ISlot iSlot = jSObject.getSlot(string);
        if (bl || iSlot == null || jSObject2 != null) {
            jSObject.setProperty(string, jSObject2);
        }
        if ((iSlot = jSObject.getSlot(string)) != null && (bl || iSlot.getData(ISlot.P_SOURCE) == null)) {
            iSlot.setData(ISlot.P_SOURCE, scopeFrame.url);
            if (aSTNode != null && (bl || iSlot.getData(ISlot.P_RANGE) == null)) {
                int n = 0;
                if (scopeFrame.lexer != null) {
                    n = scopeFrame.lexer.getSourceOffset();
                }
                iSlot.setData(ISlot.P_RANGE, new Point(n + aSTNode.sourceStart, n + aSTNode.sourceEnd));
            } else {
                iSlot.removeData(ISlot.P_RANGE);
            }
        }
        return iSlot;
    }

    protected JSObject create(Frame frame, String string, Object object) {
        ScopeFrame scopeFrame = (ScopeFrame)frame;
        JSObject jSObject = scopeFrame.localScope;
        ISlot iSlot = jSObject.getSlot(string);
        if (iSlot != null) {
            JSObject jSObject2 = iSlot.getObject();
            if (jSObject2 instanceof JSFunction) {
                if ((jSObject2 = ((JSFunction)jSObject2).construct(this.context, jSObject, null)) != null) {
                    jSObject2.setValue(object);
                }
                return jSObject2;
            }
            Debug.warn((String)("The property {" + string + "} of {" + jSObject.getClassName() + "} is not function"));
        }
        return null;
    }

    protected JSObject invoke(JSFunction jSFunction, Expression[] expressionArray, Frame frame) {
        return null;
    }

    private JSObject createObject(String string) {
        Debug.warn((String)"Should not happend!");
        ObjectImpl objectImpl = new ObjectImpl();
        return objectImpl;
    }

    protected boolean isTypeOf(JSObject jSObject, String string) {
        return jSObject != null && !(jSObject instanceof JSFunction) && string.equals(jSObject.getClassName());
    }

    protected Object[] eval(Expression expression, Frame frame, int n) {
        Object object;
        int n2 = this.size();
        JSObject jSObject = null;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        if (expression instanceof InvokeExpression && (object = ((InvokeExpression)expression).receiver) instanceof FunctionExpression) {
            bl = true;
            object.traverse((ASTVisitor)this, frame);
            jSObject = this.pop(n2);
        }
        if (!bl) {
            expression.traverse((ASTVisitor)this, frame);
            jSObject = this.pop(n2);
        }
        if (n > 0 && jSObject instanceof ScriptFunction) {
            object = (ScopeFrame)frame;
            JSDocImpl jSDocImpl = new JSDocImpl(n, object.lexer);
            ScriptFunction scriptFunction = (ScriptFunction)jSObject;
            scriptFunction.setDocument(jSDocImpl);
            if (bl) {
                jSObject = scriptFunction.invoke(this.context, object.localScope, objectArray);
            }
            objectArray[1] = jSDocImpl;
        }
        objectArray[0] = jSObject;
        return objectArray;
    }

    protected JSObject eval(Assignment assignment, Frame frame, int n) {
        JSDoc jSDoc = null;
        JSObject jSObject = null;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(assignment.lhs);
        Expression expression = assignment.expression;
        while (expression instanceof Assignment) {
            assignment = (Assignment)expression;
            arrayList.add(assignment.lhs);
            expression = assignment.expression;
        }
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        block1: for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            arrayList2.clear();
            boolean bl = false;
            Expression expression2 = (Expression)arrayList.get(i);
            while (expression2 != null) {
                if (expression2 instanceof IdentifierReference || expression2 instanceof ThisReference) {
                    if (i == 0 && n == -1) {
                        n = expression2.sourceStart;
                    }
                    arrayList2.add(expression2);
                    break;
                }
                if (expression2.kind == 46 && expression2 instanceof InvokeExpression) {
                    object = (InvokeExpression)expression2;
                    if (object.arguments != null && object.arguments.length == 1) {
                        arrayList2.add(object.arguments[0]);
                        expression2 = object.receiver;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (expression2.kind == 44 && expression2 instanceof BinaryExpression) {
                    object = (BinaryExpression)expression2;
                    if (object.right instanceof IdentifierReference) {
                        arrayList2.add(object.right);
                        expression2 = object.left;
                        continue;
                    }
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (i == 0 && expression != null && (object = this.eval(expression, frame, n)) != null) {
                jSObject = (JSObject)object[0];
                jSDoc = (JSDoc)object[1];
            }
            if (bl || arrayList2.size() <= 0) continue;
            JSObject jSObject2 = null;
            int n2 = arrayList2.size() - 1;
            ScopeFrame scopeFrame = (ScopeFrame)frame;
            expression2 = (Expression)arrayList2.get(n2);
            if (expression2 instanceof IdentifierReference) {
                jSObject2 = scopeFrame.localScope;
            } else if (expression2 instanceof ThisReference && n2 > 0) {
                --n2;
                jSObject2 = scopeFrame.thisScope;
            }
            while (jSObject2 != null && n2 >= 0) {
                object = null;
                if ((expression2 = (Expression)arrayList2.get(n2--)) instanceof IdentifierReference) {
                    object = new String(((IdentifierReference)expression2).token);
                } else {
                    Object object2;
                    int n3 = this.size();
                    expression2.traverse((ASTVisitor)this, frame);
                    JSObject jSObject3 = this.pop(n3);
                    if (this.isTypeOf(jSObject3, "String") && (object2 = jSObject3.getValue()) instanceof String) {
                        object = (String)object2;
                    }
                }
                if (object == null) continue block1;
                if (n2 < 0) {
                    ISlot iSlot = this.setProperty(scopeFrame, (ASTNode)expression2, jSObject2, (String)object, jSObject, false);
                    if (n <= 0 || iSlot == null || iSlot.getData(ISlot.P_COMMENT) != null) continue;
                    if (jSDoc == null) {
                        jSDoc = new JSDocImpl(n, scopeFrame.lexer);
                    }
                    iSlot.setData(ISlot.P_COMMENT, jSDoc);
                    continue;
                }
                JSObject jSObject4 = this.getProperty(frame, jSObject2, (String)object);
                if (jSObject4 == null) {
                    jSObject4 = this.create(frame, "Object", null);
                    if (jSObject4 == null) {
                        jSObject4 = this.createObject((String)object);
                    }
                    this.setProperty(scopeFrame, (ASTNode)expression2, jSObject2, (String)object, jSObject4, false);
                }
                jSObject2 = jSObject4;
            }
        }
        return jSObject;
    }

    public boolean visit(ArrayInitializer arrayInitializer, Frame frame) {
        JSObject jSObject;
        Object object = null;
        Expression[] expressionArray = arrayInitializer.expressions;
        if (expressionArray != null && expressionArray.length > 0 && (jSObject = expressionArray[0]) != null) {
            int n = this.size();
            jSObject.traverse(this, frame);
            JSObject jSObject2 = this.pop(n);
            if (jSObject2 != null) {
                object = jSObject2;
                if (jSObject2 instanceof JSFunction) {
                    object = "Function";
                } else if (!"Array".equals(jSObject2.getClassName())) {
                    object = jSObject2.getClassName();
                }
            }
        }
        if ((jSObject = this.create(frame, "Array", object)) != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(Assignment assignment, Frame frame) {
        this.eval(assignment, frame, -1);
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression, Frame frame) {
        Object var3_3 = null;
        String string = "Boolean";
        int n = (binaryExpression.bits & 0xFC0) >> 6;
        switch (n) {
            case 44: {
                if (binaryExpression.right instanceof IdentifierReference) {
                    int n2 = this.size();
                    binaryExpression.left.traverse((ASTVisitor)this, frame);
                    JSObject jSObject = this.pop(n2);
                    if (jSObject != null && (jSObject = this.getProperty(frame, jSObject, new String(((IdentifierReference)binaryExpression.right).token))) != null) {
                        this.push(jSObject);
                    }
                }
                return false;
            }
            case 14: {
                string = "String";
                if (binaryExpression.left instanceof NumberLiteral && binaryExpression.right instanceof NumberLiteral) {
                    string = "Number";
                    break;
                }
                if (binaryExpression.left instanceof StringLiteral || binaryExpression.right instanceof StringLiteral) break;
                int n3 = this.size();
                binaryExpression.left.traverse((ASTVisitor)this, frame);
                JSObject jSObject = this.pop(n3);
                if (!this.isTypeOf(jSObject, "Number")) break;
                binaryExpression.right.traverse((ASTVisitor)this, frame);
                jSObject = this.pop(n3);
                if (!this.isTypeOf(jSObject, "Number")) break;
                string = "Number";
                break;
            }
            case 1: {
                if (binaryExpression.left instanceof BooleanLiteral || binaryExpression.right instanceof BooleanLiteral) break;
                int n3 = this.size();
                binaryExpression.left.traverse((ASTVisitor)this, frame);
                JSObject jSObject = this.pop(n3);
                if (jSObject == null) {
                    binaryExpression.right.traverse((ASTVisitor)this, frame);
                    jSObject = this.pop(n3);
                }
                if (jSObject == null) break;
                this.push(jSObject);
                return false;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "Number";
            }
        }
        JSObject jSObject = this.create(frame, string, var3_3);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral, Frame frame) {
        Boolean bl = booleanLiteral.value ? Boolean.TRUE : Boolean.FALSE;
        JSObject jSObject = this.create(frame, "Boolean", bl);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(CompoundAssignment compoundAssignment, Frame frame) {
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean visit(ConditionalExpression conditionalExpression, Frame frame) {
        int n = this.size();
        conditionalExpression.valueIfTrue.traverse((ASTVisitor)this, frame);
        if (n == this.size()) {
            conditionalExpression.valueIfFalse.traverse((ASTVisitor)this, frame);
        }
        return false;
    }

    public boolean visit(FieldLiteral fieldLiteral, Frame frame) {
        return false;
    }

    public boolean visit(FunctionExpression functionExpression, Frame frame) {
        ScopeFrame scopeFrame = (ScopeFrame)frame;
        BufferedScanner bufferedScanner = scopeFrame.lexer;
        JSObject jSObject = scopeFrame.localScope;
        ScriptFunction scriptFunction = new ScriptFunction(scopeFrame.url, functionExpression, bufferedScanner);
        scriptFunction.setParentScope(jSObject);
        scriptFunction.setPrototype(Context.getFunctionPrototype(jSObject));
        this.push(scriptFunction);
        return false;
    }

    public boolean visit(IdentifierReference identifierReference, Frame frame) {
        ScopeFrame scopeFrame = (ScopeFrame)frame;
        String string = new String(identifierReference.token);
        JSObject jSObject = this.getProperty(frame, scopeFrame.localScope, string);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(InvokeExpression invokeExpression, Frame frame) {
        int n = this.size();
        invokeExpression.receiver.traverse((ASTVisitor)this, frame);
        JSObject jSObject = this.pop(n);
        if (jSObject != null) {
            Expression[] expressionArray = invokeExpression.arguments;
            switch (invokeExpression.kind) {
                case 0: {
                    if (jSObject instanceof JSFunction) {
                        JSFunction jSFunction = (JSFunction)jSObject;
                        if ((jSObject = this.invoke(jSFunction, expressionArray, frame)) == null) {
                            jSObject = jSFunction.invoke(this.context, ((ScopeFrame)frame).localScope, null);
                        }
                        if (jSObject == null) break;
                        this.push(jSObject);
                        break;
                    }
                    Debug.warn((String)"The expression is not function");
                    break;
                }
                case 50: {
                    if (jSObject instanceof JSFunction) {
                        if ((jSObject = ((JSFunction)jSObject).construct(this.context, ((ScopeFrame)frame).localScope, null)) == null) break;
                        this.push(jSObject);
                        break;
                    }
                    Debug.warn((String)"The expression is not function");
                    break;
                }
                case 46: {
                    Object object;
                    JSObject jSObject2;
                    if (expressionArray != null && expressionArray.length == 1) {
                        n = this.size();
                        expressionArray[0].traverse((ASTVisitor)this, frame);
                        jSObject2 = this.pop(n);
                        if (this.isTypeOf(jSObject2, "String")) {
                            Object object2 = jSObject2.getValue();
                            if (!(object2 instanceof String) || (jSObject2 = this.getProperty(frame, jSObject, (String)object2)) == null) break;
                            this.push(jSObject2);
                            break;
                        }
                    }
                    if ((object = jSObject.getValue()) instanceof JSObject) {
                        this.push((JSObject)object);
                        break;
                    }
                    if (!(object instanceof String) || (jSObject2 = this.create(frame, (String)object, null)) == null) break;
                    this.push(jSObject2);
                }
            }
        }
        return false;
    }

    public boolean visit(NullLiteral nullLiteral, Frame frame) {
        this.push(null);
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral, Frame frame) {
        Object object = new String(numberLiteral.source());
        try {
            object = new Double(Double.parseDouble((String)object));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JSObject jSObject = this.create(frame, "Number", object);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(ObjectInitializer objectInitializer, Frame frame) {
        ScopeFrame scopeFrame = (ScopeFrame)frame;
        ObjectImpl objectImpl = new ObjectImpl();
        objectImpl.setPrototype(Context.getObjectPrototype(scopeFrame.localScope));
        Expression[] expressionArray = objectInitializer.expressions;
        if (expressionArray != null) {
            int n = this.size();
            for (int i = 0; i < expressionArray.length; ++i) {
                ISlot iSlot;
                if (!(expressionArray[i] instanceof FieldLiteral)) continue;
                String string = null;
                FieldLiteral fieldLiteral = (FieldLiteral)expressionArray[i];
                if (fieldLiteral.field instanceof IdentifierReference) {
                    string = new String(((IdentifierReference)fieldLiteral.field).token);
                } else if (fieldLiteral.field instanceof StringLiteral) {
                    string = new String(((StringLiteral)fieldLiteral.field).source());
                }
                if (string == null) continue;
                JSDocImpl jSDocImpl = null;
                JSObject jSObject = null;
                if (fieldLiteral.value != null) {
                    fieldLiteral.value.traverse((ASTVisitor)this, frame);
                    jSObject = this.pop(n);
                    if (jSObject instanceof ScriptFunction) {
                        jSDocImpl = new JSDocImpl(fieldLiteral.field.sourceStart, scopeFrame.lexer);
                        ((ScriptFunction)jSObject).setDocument(jSDocImpl);
                    }
                }
                if ((iSlot = this.setProperty(scopeFrame, (ASTNode)fieldLiteral.field, objectImpl, string, jSObject, true)) == null || iSlot.getData(ISlot.P_COMMENT) != null) continue;
                if (jSDocImpl == null) {
                    jSDocImpl = new JSDocImpl(fieldLiteral.field.sourceStart, scopeFrame.lexer);
                }
                iSlot.setData(ISlot.P_COMMENT, jSDocImpl);
            }
            this.reset(n);
        }
        this.push(objectImpl);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, Frame frame) {
        JSObject jSObject = this.create(frame, "Number", null);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression, Frame frame) {
        JSObject jSObject = this.create(frame, "Number", null);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(QualifiedExpressionReference qualifiedExpressionReference, Frame frame) {
        return false;
    }

    public boolean visit(RegExpLiteral regExpLiteral, Frame frame) {
        JSObject jSObject = this.create(frame, "RegExp", null);
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, Frame frame) {
        JSObject jSObject = this.create(frame, "String", new String(stringLiteral.source()));
        if (jSObject != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(SuperExpression superExpression, Frame frame) {
        throw new UnsupportedOperationException();
    }

    public boolean visit(SuperReference superReference, Frame frame) {
        this.push(((ScopeFrame)frame).thisScope);
        return false;
    }

    public boolean visit(ThisReference thisReference, Frame frame) {
        this.push(((ScopeFrame)frame).thisScope);
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression, Frame frame) {
        JSObject jSObject;
        String string = null;
        int n = (unaryExpression.bits & 0xFC0) >> 6;
        switch (n) {
            case 11: 
            case 41: 
            case 42: {
                string = "Boolean";
                break;
            }
            case 43: {
                string = "String";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 32: 
            case 33: {
                string = "Number";
            }
        }
        if (string != null && (jSObject = this.create(frame, string, null)) != null) {
            this.push(jSObject);
        }
        return false;
    }

    public boolean visit(Wildcard wildcard, Frame frame) {
        throw new UnsupportedOperationException();
    }

    public boolean visit(VariableBinding variableBinding, Frame frame) {
        Object[] objectArray;
        JSDoc jSDoc = null;
        JSObject jSObject = null;
        Expression expression = variableBinding.initializer;
        if (expression instanceof Assignment) {
            jSObject = this.eval((Assignment)expression, frame, variableBinding.sourceStart);
        } else if (expression != null && (objectArray = this.eval(expression, frame, variableBinding.sourceStart)) != null) {
            jSObject = (JSObject)objectArray[0];
            jSDoc = (JSDoc)objectArray[1];
        }
        objectArray = (Object[])frame;
        ISlot iSlot = this.setProperty((ScopeFrame)objectArray, (ASTNode)variableBinding, objectArray.localScope, new String(variableBinding.name), jSObject, true);
        if (iSlot != null && iSlot.getData(ISlot.P_COMMENT) == null) {
            if (jSDoc == null) {
                jSDoc = new JSDocImpl(variableBinding.sourceStart, ((ScopeFrame)frame).lexer);
            }
            iSlot.setData(ISlot.P_COMMENT, jSDoc);
        }
        return false;
    }

    public boolean visit(Block block, Frame frame) {
        return false;
    }

    public boolean visit(BreakStatement breakStatement, Frame frame) {
        return false;
    }

    public boolean visit(CaseStatement caseStatement, Frame frame) {
        return false;
    }

    public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, Frame frame) {
        return false;
    }

    public boolean visit(ContinueStatement continueStatement, Frame frame) {
        return false;
    }

    public boolean visit(DefaultXMLNSStatement defaultXMLNSStatement, Frame frame) {
        return false;
    }

    public boolean visit(DoStatement doStatement, Frame frame) {
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement, Frame frame) {
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement, Frame frame) {
        return false;
    }

    public boolean visit(ForStatement forStatement, Frame frame) {
        return false;
    }

    public boolean visit(FunctionDeclaration functionDeclaration, Frame frame) {
        return false;
    }

    public boolean visit(IfStatement ifStatement, Frame frame) {
        return false;
    }

    public boolean visit(ImportStatement importStatement, Frame frame) {
        return false;
    }

    public boolean visit(LabelStatement labelStatement, Frame frame) {
        return false;
    }

    public boolean visit(NamespaceDeclaration namespaceDeclaration, Frame frame) {
        return false;
    }

    public boolean visit(PackageDeclaration packageDeclaration, Frame frame) {
        return false;
    }

    public boolean visit(Parameter parameter, Frame frame) {
        return false;
    }

    public boolean visit(PragmaStatement pragmaStatement, Frame frame) {
        return false;
    }

    public boolean visit(ReturnStatement returnStatement, Frame frame) {
        return false;
    }

    public boolean visit(SwitchStatement switchStatement, Frame frame) {
        return false;
    }

    public boolean visit(ThrowStatement throwStatement, Frame frame) {
        return false;
    }

    public boolean visit(TryStatement tryStatement, Frame frame) {
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration, Frame frame) {
        return false;
    }

    public boolean visit(UseStatement useStatement, Frame frame) {
        return false;
    }

    public boolean visit(VariableDeclaration variableDeclaration, Frame frame) {
        return false;
    }

    public boolean visit(WhileStatement whileStatement, Frame frame) {
        return false;
    }

    public boolean visit(WithStatement withStatement, Frame frame) {
        return false;
    }

    protected static final class ScopeFrame
    extends Frame {
        public String url;
        public BufferedScanner lexer;
        public JSObject localScope;
        public JSObject thisScope;

        public ScopeFrame(String string, BufferedScanner bufferedScanner, JSObject jSObject, JSObject jSObject2) {
            this.url = string;
            this.lexer = bufferedScanner;
            this.localScope = jSObject;
            this.thisScope = jSObject2;
        }
    }
}

