/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;

public class Partitioner {
    private static final Position[] NONE = new Position[0];
    private String fCategory;
    private String fPartitioning;
    private String[] fContentTypes;
    private String[] fStopPartitions;
    private int fIndex;
    private int fOffset;
    private int fLength;
    private Position[] fPositions;
    private boolean fForward;
    private IDocument fDocument;
    private IDocumentListener fListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            Partitioner.access$002(Partitioner.this, null);
        }
    };

    public Partitioner(String string) {
        this(string, null);
    }

    public Partitioner(String string, String[] stringArray) {
        this.fIndex = Integer.MIN_VALUE;
        this.fPartitioning = string;
        this.fContentTypes = stringArray;
    }

    public String getPartitioning() {
        return this.fPartitioning;
    }

    public void dispose() {
        if (this.fDocument != null) {
            if (this.fListener != null) {
                this.fDocument.removeDocumentListener(this.fListener);
            }
            this.fDocument = null;
        }
        this.fListener = null;
    }

    public void reset(int n) {
        this.fOffset = n;
        this.fLength = 0;
        this.fIndex = Integer.MIN_VALUE;
    }

    public void setForward(boolean bl) {
        this.fForward = bl;
    }

    public void setStopPartitions(String[] stringArray) {
        this.fStopPartitions = stringArray;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void next() {
        if (this.fForward) {
            this.forward();
        } else {
            this.backward();
        }
    }

    public boolean valid(int n) {
        Position[] positionArray = this.getPositions();
        int n2 = this.getIndex(positionArray, n);
        if (n2 >= 0) {
            return this.accept(positionArray[n2]);
        }
        return true;
    }

    protected int getIndex(Position[] positionArray, int n) {
        int n2 = -1;
        if (positionArray.length > 0) {
            int n3 = 0;
            int n4 = 0;
            int n5 = positionArray.length - 1;
            while (n4 <= n5) {
                n3 = n4 + n5 >> 1;
                Position position = positionArray[n3];
                if (n < position.getOffset()) {
                    n5 = n3 - 1;
                    continue;
                }
                if (n >= position.getOffset() + position.getLength()) {
                    n4 = n3 + 1;
                    continue;
                }
                n2 = n3;
                break;
            }
        }
        return n2;
    }

    protected void forward() {
        Position[] positionArray = this.getPositions();
        if (positionArray.length > 0) {
            int n;
            int n2;
            block23: {
                Position position;
                boolean bl = false;
                if (this.fIndex == Integer.MIN_VALUE) {
                    int n3 = 0;
                    n2 = 0;
                    n = positionArray.length - 1;
                    int n4 = this.fOffset + this.fLength;
                    while (n2 <= n) {
                        n3 = n2 + n >> 1;
                        position = positionArray[n3];
                        if (n4 < position.getOffset()) {
                            n = n3 - 1;
                            continue;
                        }
                        if (n4 >= position.getOffset() + position.getLength()) {
                            n2 = n3 + 1;
                            continue;
                        }
                        this.fIndex = n3;
                        break;
                    }
                    n2 = n4;
                    if (this.fIndex == Integer.MIN_VALUE) {
                        this.fIndex = n3;
                        position = positionArray[n3];
                        if (position.getOffset() > n4) {
                            --this.fIndex;
                            n = position.getOffset();
                        } else {
                            n2 = position.getOffset() + position.getLength();
                            n = this.fIndex + 1 < positionArray.length ? positionArray[this.fIndex + 1].getOffset() : this.fDocument.getLength();
                        }
                    } else {
                        position = positionArray[this.fIndex];
                        if (this.accept(position)) {
                            n = position.getOffset() + position.getLength();
                        } else {
                            bl = true;
                            n2 = n = position.getOffset();
                            if (this.stop(position)) {
                                this.fIndex = positionArray.length;
                            }
                        }
                    }
                    n2 = Math.max(n4, n2);
                } else {
                    bl = true;
                    n2 = this.fOffset;
                    n = this.fOffset + this.fLength;
                }
                if (bl) {
                    while (true) {
                        ++this.fIndex;
                        if (this.fIndex >= positionArray.length) break;
                        n2 = n;
                        position = positionArray[this.fIndex];
                        if (this.accept(position)) {
                            n = position.getOffset() + position.getLength();
                            break block23;
                        }
                        if (n < position.getOffset()) {
                            n = position.getOffset();
                            break block23;
                        }
                        n = position.getOffset() + position.getLength();
                        if (this.fIndex == positionArray.length - 1) {
                            n2 = n;
                            n = this.fDocument.getLength();
                            break block23;
                        }
                        if (!this.stop(position)) continue;
                        this.fIndex = positionArray.length;
                    }
                    if (this.fIndex == positionArray.length) {
                        position = positionArray[this.fIndex - 1];
                        n2 = position.getOffset() + position.getLength();
                        n = this.fDocument.getLength();
                    } else {
                        n2 = n = this.fDocument.getLength();
                    }
                }
            }
            this.fOffset = n2;
            this.fLength = n - n2;
        } else if (this.fIndex == Integer.MIN_VALUE) {
            this.fIndex = 0;
            this.fLength = this.fDocument.getLength() - this.fOffset;
        } else {
            this.fOffset = this.fDocument.getLength();
            this.fLength = 0;
        }
    }

    protected void backward() {
        Position[] positionArray = this.getPositions();
        if (positionArray.length > 0) {
            Position position;
            int n;
            int n2;
            boolean bl = false;
            if (this.fIndex == Integer.MIN_VALUE) {
                int n3 = 0;
                int n4 = this.fOffset;
                n2 = 0;
                n = positionArray.length - 1;
                while (n2 <= n) {
                    n3 = n2 + n >> 1;
                    position = positionArray[n3];
                    if (n4 < position.getOffset()) {
                        n = n3 - 1;
                        continue;
                    }
                    if (n4 >= position.getOffset() + position.getLength()) {
                        n2 = n3 + 1;
                        continue;
                    }
                    this.fIndex = n3;
                    break;
                }
                n = n4;
                if (this.fIndex == Integer.MIN_VALUE) {
                    this.fIndex = n3;
                    position = positionArray[n3];
                    if (position.getOffset() > n4) {
                        if (n3 == 0) {
                            n2 = 0;
                        } else {
                            position = positionArray[n3 - 1];
                            n2 = position.getOffset() + position.getLength();
                        }
                    } else {
                        ++this.fIndex;
                        n2 = position.getOffset() + position.getLength();
                    }
                } else {
                    position = positionArray[this.fIndex];
                    if (this.accept(position)) {
                        n2 = position.getOffset();
                    } else {
                        bl = true;
                        n2 = n = position.getOffset();
                        if (this.stop(position)) {
                            this.fIndex = 0;
                        }
                    }
                }
                n = Math.min(n4, n);
            } else {
                bl = true;
                n2 = this.fOffset;
                n = this.fOffset + this.fLength;
            }
            if (bl) {
                while (true) {
                    --this.fIndex;
                    if (this.fIndex < 0) {
                        this.fOffset = 0;
                        this.fLength = 0;
                        return;
                    }
                    position = positionArray[this.fIndex];
                    if (this.accept(position)) {
                        n = n2 - 1;
                        n2 = position.getOffset();
                        break;
                    }
                    if (n2 > position.getOffset() + position.getLength()) {
                        n = n2 - 1;
                        n2 = position.getOffset() + position.getLength();
                        break;
                    }
                    if (this.fIndex <= 0) {
                        n2 = 0;
                        n = position.getOffset() - 1;
                        break;
                    }
                    n = n2 = position.getOffset();
                    if (!this.stop(position)) continue;
                    this.fIndex = 0;
                }
            }
            this.fOffset = n2;
            this.fLength = n - n2;
        } else if (this.fIndex == Integer.MIN_VALUE) {
            this.fIndex = 0;
            this.fLength = this.fOffset;
            this.fOffset = 0;
        } else {
            this.fOffset = 0;
            this.fLength = 0;
        }
    }

    public void setDocument(IDocument iDocument) {
        if (this.fDocument == iDocument) {
            return;
        }
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fListener);
        }
        this.fPositions = null;
        this.fDocument = iDocument;
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fListener);
        }
    }

    protected boolean accept(Position position) {
        if (position instanceof TypedPosition) {
            String string = ((TypedPosition)position).getType();
            if (this.fContentTypes == null) {
                return "__dftl_partition_content_type".equals(string);
            }
            for (int i = 0; i < this.fContentTypes.length; ++i) {
                if (!this.fContentTypes[i].equals(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean stop(Position position) {
        if (this.fStopPartitions != null && position instanceof TypedPosition) {
            String string = ((TypedPosition)position).getType();
            for (int i = 0; i < this.fStopPartitions.length; ++i) {
                if (!this.fStopPartitions[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected Position[] getPositions() {
        if (this.fPositions == null) {
            String string = this.getCategory();
            if (string != null) {
                try {
                    this.fPositions = this.fDocument.getPositions(string);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    // empty catch block
                }
            }
            if (this.fPositions == null) {
                this.fPositions = NONE;
            }
        }
        return this.fPositions;
    }

    protected String getCategory() {
        String[] stringArray;
        IDocumentPartitioner iDocumentPartitioner;
        if (this.fCategory == null && (iDocumentPartitioner = this.fDocument instanceof IDocumentExtension3 ? ((IDocumentExtension3)this.fDocument).getDocumentPartitioner(this.fPartitioning) : this.fDocument.getDocumentPartitioner()) instanceof IDocumentPartitionerExtension2 && (stringArray = ((IDocumentPartitionerExtension2)iDocumentPartitioner).getManagingPositionCategories()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.fDocument.containsPositionCategory(stringArray[i])) continue;
                this.fCategory = stringArray[i];
                break;
            }
        }
        return this.fCategory;
    }

    static /* synthetic */ Position[] access$002(Partitioner partitioner, Position[] positionArray) {
        partitioner.fPositions = positionArray;
        return positionArray;
    }
}

