/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;

public class JSStringDoubleClickSelector
implements ITextDoubleClickStrategy {
    private String fPartitioning;

    public JSStringDoubleClickSelector(String string) {
        this.fPartitioning = string;
    }

    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n < 0) {
            return;
        }
        IDocument iDocument = iTextViewer.getDocument();
        IRegion iRegion = this.match(iDocument, n);
        if (iRegion != null && iRegion.getLength() >= 2) {
            iTextViewer.setSelectedRange(iRegion.getOffset() + 1, iRegion.getLength() - 2);
        } else {
            this.selectWord(iTextViewer, iDocument, n);
        }
    }

    private void selectWord(ITextViewer iTextViewer, IDocument iDocument, int n) {
        try {
            char c;
            int n2;
            for (n2 = n; n2 >= 0 && Character.isJavaIdentifierPart(c = iDocument.getChar(n2)); --n2) {
            }
            int n3 = n2;
            int n4 = iDocument.getLength();
            for (n2 = n; n2 < n4 && Character.isJavaIdentifierPart(c = iDocument.getChar(n2)); ++n2) {
            }
            int n5 = n2;
            if (n3 == n5) {
                iTextViewer.setSelectedRange(n3, 0);
            } else {
                iTextViewer.setSelectedRange(n3 + 1, n5 - n3 - 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private IRegion match(IDocument iDocument, int n) {
        try {
            if (iDocument.getChar(n) == '\"' || iDocument.getChar(n) == '\'' || iDocument.getChar(n - 1) == '\"' || iDocument.getChar(n - 1) == '\'') {
                return TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)n, (boolean)true);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }
}

