/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.text.JSDoubleClickStrategy;
import com.spket.js.internal.text.Partitioner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class JSPairMatcher
implements ICharacterPairMatcher {
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;
    protected char[] fPairs;
    protected IDocument fDocument;
    protected Partitioner fPartitioner;

    public JSPairMatcher(Partitioner partitioner) {
        this(partitioner, JSDoubleClickStrategy.BRACKETS);
    }

    public JSPairMatcher(Partitioner partitioner, char[] cArray) {
        this.fPairs = cArray;
        this.fPartitioner = partitioner;
    }

    public IRegion match(IDocument iDocument, int n) {
        this.fOffset = n;
        if (this.fOffset < 0 || this.fPartitioner == null) {
            return null;
        }
        this.fDocument = iDocument;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
        this.fPartitioner = null;
    }

    public void clear() {
    }

    protected boolean matchPairsAt() {
        int n = this.fPairs.length;
        int n2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            int n3;
            char c = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            for (n3 = 0; n3 < this.fPairs.length; n3 += 2) {
                if (c != this.fPairs[n3]) continue;
                this.fStartPos = this.fOffset - 1;
                n = n3;
            }
            for (n3 = 1; n3 < this.fPairs.length; n3 += 2) {
                if (c != this.fPairs[n3]) continue;
                this.fEndPos = this.fOffset - 1;
                n2 = n3;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[n2 - 1], this.fPairs[n2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            } else if (this.fStartPos > -1) {
                this.fAnchor = 1;
                this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[n], this.fPairs[n + 1], this.fDocument);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    protected int searchForClosingPeer(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2;
        this.fPartitioner.setDocument(iDocument);
        this.fPartitioner.setForward(true);
        this.fPartitioner.reset(n + 1);
        if (!this.fPartitioner.valid(n)) {
            return -1;
        }
        int n3 = 1;
        do {
            this.fPartitioner.next();
            int n4 = this.fPartitioner.getLength();
            if (n4 < 0) break;
            for (int i = n2 = this.fPartitioner.getOffset(); i < n2 + n4; ++i) {
                char c3 = iDocument.getChar(i);
                if (c3 == c && c3 != c2) {
                    ++n3;
                } else if (c3 == c2) {
                    --n3;
                }
                if (n3 != 0) continue;
                return i;
            }
        } while (n2 != iDocument.getLength());
        return -1;
    }

    protected int searchForOpeningPeer(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2;
        this.fPartitioner.setDocument(iDocument);
        this.fPartitioner.setForward(false);
        this.fPartitioner.reset(n - 1);
        if (!this.fPartitioner.valid(n)) {
            return -1;
        }
        int n3 = 1;
        do {
            this.fPartitioner.next();
            int n4 = this.fPartitioner.getLength();
            if (n4 < 0) break;
            n2 = this.fPartitioner.getOffset();
            for (int i = n2 + n4; i >= n2; --i) {
                char c3 = iDocument.getChar(i);
                if (c3 == c2 && c3 != c) {
                    ++n3;
                } else if (c3 == c) {
                    --n3;
                }
                if (n3 != 0) continue;
                return i;
            }
        } while (n2 != 0);
        return -1;
    }
}

