/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.JSPlugin;
import com.spket.ui.text.AutoEditStrategy;
import com.spket.util.Debug;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class JSDocAutoIndentStrategy
extends AutoEditStrategy {
    private String[] fStopPartitions;

    public JSDocAutoIndentStrategy(String string) {
        super(string);
    }

    public JSDocAutoIndentStrategy(String string, String[] stringArray) {
        super(string);
        this.fStopPartitions = stringArray;
    }

    private void indentAfterCommentEnd(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset < 2 || iDocument.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(iDocument.get(documentCommand.offset - 2, 2))) {
                ++documentCommand.length;
                --documentCommand.offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isNewComment(IDocument iDocument, int n) {
        try {
            String string;
            int n2 = iDocument.getLineOfOffset(n) + 1;
            if (n2 >= iDocument.getNumberOfLines()) {
                return true;
            }
            IRegion iRegion = iDocument.getLineInformation(n2);
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)n, (boolean)false);
            int n3 = iTypedRegion.getOffset() + iTypedRegion.getLength();
            if (iRegion.getOffset() >= n3) {
                return false;
            }
            if (iDocument.getLength() == n3) {
                return true;
            }
            if (this.fStopPartitions != null && this.fStopPartitions.length > 0) {
                iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)n3, (boolean)false);
                if (iTypedRegion == null) {
                    return true;
                }
                string = iTypedRegion.getType();
                if ("__dftl_partition_content_type".equals(string)) {
                    return true;
                }
                for (int i = 0; i < this.fStopPartitions.length; ++i) {
                    if (!this.fStopPartitions[i].equals(string)) continue;
                    return true;
                }
            }
            return (string = iDocument.get(iTypedRegion.getOffset(), iTypedRegion.getLength())).indexOf("/*", 2) != -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private IRegion findPrefixRange(IDocument iDocument, IRegion iRegion) throws BadLocationException {
        int n;
        int n2 = iRegion.getOffset();
        int n3 = this.findEndOfWhiteSpace(iDocument, n2, n = n2 + iRegion.getLength());
        if (n3 < n && iDocument.getChar(n3) == '*') {
            ++n3;
            while (n3 < n && iDocument.getChar(n3) == ' ') {
                ++n3;
            }
        }
        return new Region(n2, n3 - n2);
    }

    private void indentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        int n = documentCommand.offset;
        if (n == -1 || iDocument.getLength() == 0) {
            return;
        }
        int n2 = n == iDocument.getLength() ? n - 1 : n;
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n2);
            int n3 = iRegion.getOffset();
            int n4 = this.findEndOfWhiteSpace(iDocument, n3, n);
            Debug.assertTrue((n4 >= n3 ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            IRegion iRegion2 = this.findPrefixRange(iDocument, iRegion);
            String string = iDocument.get(iRegion2.getOffset(), iRegion2.getLength());
            int n5 = Math.min(n - iRegion2.getOffset(), iRegion2.getLength());
            stringBuffer.append(string.substring(0, n5));
            if (n4 < n && iDocument.getChar(n4) == '/') {
                stringBuffer.append(" * ");
                IPreferenceStore iPreferenceStore = JSPlugin.getDefault().getPreferenceStore();
                if (iPreferenceStore.getBoolean("closeJSDocs") && this.isNewComment(iDocument, n)) {
                    documentCommand.shiftsCaret = false;
                    documentCommand.caretOffset = documentCommand.offset + stringBuffer.length();
                    stringBuffer.append(TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                    stringBuffer.append(string).append(" */");
                }
            }
            if (n5 < iRegion2.getLength()) {
                documentCommand.caretOffset = n + iRegion2.getLength() - n5;
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (!this.isSmartMode()) {
            return;
        }
        if (documentCommand.text != null) {
            String[] stringArray;
            int n;
            if (documentCommand.length == 0 && (n = TextUtilities.endsWith((String[])(stringArray = iDocument.getLegalLineDelimiters()), (String)documentCommand.text)) > -1) {
                if (stringArray[n].equals(documentCommand.text)) {
                    this.indentAfterNewLine(iDocument, documentCommand);
                }
                return;
            }
            if (documentCommand.text.length() == 1 && documentCommand.text.charAt(0) == '/') {
                this.indentAfterCommentEnd(iDocument, documentCommand);
            }
        }
    }
}

