/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.editors;

import com.spket.as.core.compiler.CharOperation;
import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.Assignment;
import com.spket.as.internal.compiler.ast.BinaryExpression;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.ExpressionStatement;
import com.spket.as.internal.compiler.ast.FieldLiteral;
import com.spket.as.internal.compiler.ast.FunctionDeclaration;
import com.spket.as.internal.compiler.ast.FunctionExpression;
import com.spket.as.internal.compiler.ast.IdentifierReference;
import com.spket.as.internal.compiler.ast.InvokeExpression;
import com.spket.as.internal.compiler.ast.ObjectInitializer;
import com.spket.as.internal.compiler.ast.Parameter;
import com.spket.as.internal.compiler.ast.ReturnStatement;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.ast.StringLiteral;
import com.spket.as.internal.compiler.ast.ThisReference;
import com.spket.as.internal.compiler.ast.VariableBinding;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.js.editors.JSItem;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;

public class OutlineVisitor
extends ASTVisitor {
    private static final char[] NS_Ext = "Ext".toCharArray();
    private static final char[] F_apply = "apply".toCharArray();
    private static final char[] F_applyIf = "applyIf".toCharArray();
    private static final char[] F_extend = "extend".toCharArray();
    private JSItem thisScope;
    private JSItem localScope;
    private JSItem globalScope;
    private boolean fCancelled;
    private int count;
    private JSItem[] items = JSItem.NO_ITEM;
    public boolean showLocalVariable = true;

    public OutlineVisitor(JSItem jSItem) {
        this.reset(jSItem);
    }

    public void reset(JSItem jSItem) {
        this.fCancelled = false;
        this.localScope = this.thisScope = jSItem;
        this.globalScope = this.thisScope;
        if (this.count > 0) {
            for (int i = 0; i < this.count; ++i) {
                this.items[i] = null;
            }
            this.count = 0;
        }
    }

    public void cancel() {
        this.fCancelled = true;
    }

    protected int size() {
        return this.count;
    }

    protected void push(JSItem jSItem) {
        if (this.items == null) {
            this.items = new JSItem[10];
        } else if (this.count >= this.items.length) {
            JSItem[] jSItemArray = new JSItem[this.count + 10];
            System.arraycopy(this.items, 0, jSItemArray, 0, this.count);
            this.items = jSItemArray;
        }
        this.items[this.count++] = jSItem;
    }

    protected JSItem pop(int n) {
        if (n + 1 == this.count) {
            --this.count;
            return this.items[this.count];
        }
        if (this.count < n) {
            throw new IllegalStateException("Stack Point: " + this.count + " - " + n);
        }
        this.count = n;
        return null;
    }

    protected void reset(int n) {
        if (this.count > n) {
            this.count = n;
        } else if (this.count < n) {
            throw new IllegalStateException("Stack Point: " + this.count + " - " + n);
        }
    }

    protected JSItem eval(Expression expression, Frame frame) {
        int n = this.size();
        JSItem jSItem = null;
        if (expression instanceof InvokeExpression) {
            InvokeExpression invokeExpression = (InvokeExpression)expression;
            Expression expression2 = invokeExpression.receiver;
            if (expression2 instanceof FunctionExpression) {
                Block block = ((FunctionExpression)expression2).body;
                if (block != null && block.statements != null && block.statements.length > 0) {
                    JSItem jSItem2;
                    JSItem jSItem3 = null;
                    JSItem jSItem4 = this.localScope;
                    this.localScope = new JSItem(jSItem4);
                    if (invokeExpression.kind == 50) {
                        jSItem3 = this.thisScope;
                        this.thisScope = jSItem = new JSItem();
                    }
                    Statement[] statementArray = block.statements;
                    for (int i = 0; i < statementArray.length; ++i) {
                        Statement statement = statementArray[i];
                        if (statement instanceof ReturnStatement) {
                            ReturnStatement returnStatement = (ReturnStatement)statement;
                            if (returnStatement.expression == null) continue;
                            int n2 = this.size();
                            returnStatement.expression.traverse((ASTVisitor)this, frame);
                            jSItem = this.pop(n2);
                            break;
                        }
                        statement.traverse((ASTVisitor)this, frame);
                    }
                    if (jSItem != null && (jSItem2 = this.collectLocalVariable(jSItem, this.localScope)) != null) {
                        jSItem.addChild(jSItem2);
                    }
                    this.localScope = jSItem4;
                    if (jSItem3 != null) {
                        this.thisScope = jSItem3;
                    }
                }
                this.reset(n);
                return jSItem;
            }
        } else if (expression instanceof FunctionExpression) {
            JSItem jSItem5 = this.thisScope;
            this.thisScope = null;
            expression.traverse((ASTVisitor)this, frame);
            this.thisScope = jSItem5;
        } else if (expression instanceof ObjectInitializer) {
            expression.traverse((ASTVisitor)this, frame);
        }
        jSItem = this.pop(n);
        return jSItem;
    }

    protected JSItem getItem(Expression expression, boolean bl) {
        Object object;
        boolean bl2 = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        while (expression != null) {
            if (expression instanceof IdentifierReference || expression instanceof ThisReference) {
                arrayList.add(expression);
                break;
            }
            if (expression.kind == 46 && expression instanceof InvokeExpression) {
                object = (InvokeExpression)expression;
                if (((InvokeExpression)object).arguments != null && ((InvokeExpression)object).arguments.length == 1 && ((InvokeExpression)object).arguments[0] instanceof StringLiteral) {
                    arrayList.add(((InvokeExpression)object).arguments[0]);
                    expression = ((InvokeExpression)object).receiver;
                    continue;
                }
                bl2 = true;
                break;
            }
            if (expression.kind == 44 && expression instanceof BinaryExpression) {
                object = (BinaryExpression)expression;
                if (((BinaryExpression)object).right instanceof IdentifierReference) {
                    arrayList.add(((BinaryExpression)object).right);
                    expression = ((BinaryExpression)object).left;
                    continue;
                }
                bl2 = true;
                break;
            }
            bl2 = true;
            break;
        }
        if (!bl2 && arrayList.size() > 1) {
            String string;
            object = null;
            int n = arrayList.size() - 1;
            expression = (Expression)arrayList.get(n);
            if (expression instanceof IdentifierReference) {
                object = this.localScope;
                string = new String(((IdentifierReference)expression).token);
                if (((JSItem)object).getChild(string) == null) {
                    object = this.globalScope;
                }
            } else if (expression instanceof ThisReference && n > 0) {
                --n;
                object = this.thisScope;
            }
            string = null;
            while (object != null && n >= 0) {
                JSItem jSItem;
                string = null;
                if ((expression = (Expression)arrayList.get(n--)) instanceof IdentifierReference) {
                    string = new String(((IdentifierReference)expression).token);
                } else if (expression instanceof StringLiteral) {
                    string = new String(((StringLiteral)expression).source());
                }
                if (string == null) {
                    object = null;
                    break;
                }
                if (bl) {
                    if (n == 0 && "prototype".equals(string)) {
                        return object;
                    }
                    if (n == -1) {
                        if (string.length() > 0 && Character.isUpperCase(string.charAt(0))) {
                            return new JSItem("prototype");
                        }
                        return null;
                    }
                }
                if ((jSItem = ((JSItem)object).getChild(string)) == null) {
                    jSItem = new JSItem(string);
                    this.setRange(jSItem, (ASTNode)expression);
                    ((JSItem)object).addChild(jSItem);
                }
                object = jSItem;
            }
            if (bl) {
                return null;
            }
            return object;
        }
        return null;
    }

    protected JSItem getThisScope(Expression expression) {
        return this.getItem(expression, true);
    }

    protected JSItem evalAssignment(Assignment assignment, Frame frame) {
        JSItem jSItem = null;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(assignment.lhs);
        Expression expression = assignment.expression;
        while (expression instanceof Assignment) {
            assignment = (Assignment)expression;
            arrayList.add(assignment.lhs);
            expression = assignment.expression;
        }
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        block1: for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            Object object;
            arrayList2.clear();
            boolean bl = false;
            Expression expression2 = (Expression)arrayList.get(i);
            while (expression2 != null) {
                if (expression2 instanceof IdentifierReference || expression2 instanceof ThisReference) {
                    arrayList2.add(expression2);
                    break;
                }
                if (expression2.kind == 46 && expression2 instanceof InvokeExpression) {
                    object = (InvokeExpression)expression2;
                    if (((InvokeExpression)object).arguments != null && ((InvokeExpression)object).arguments.length == 1 && ((InvokeExpression)object).arguments[0] instanceof StringLiteral) {
                        arrayList2.add(((InvokeExpression)object).arguments[0]);
                        expression2 = ((InvokeExpression)object).receiver;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (expression2.kind == 44 && expression2 instanceof BinaryExpression) {
                    object = (BinaryExpression)expression2;
                    if (((BinaryExpression)object).right instanceof IdentifierReference) {
                        arrayList2.add(((BinaryExpression)object).right);
                        expression2 = ((BinaryExpression)object).left;
                        continue;
                    }
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (bl || arrayList2.size() <= 0) continue;
            object = null;
            int n = arrayList2.size() - 1;
            expression2 = (Expression)arrayList2.get(n);
            if (expression2 instanceof IdentifierReference) {
                object = this.localScope;
                string = new String(((IdentifierReference)expression2).token);
                if (((JSItem)object).getChild(string) == null) {
                    object = this.globalScope;
                }
            } else if (expression2 instanceof ThisReference && n > 0) {
                --n;
                object = this.thisScope;
            }
            while (object != null && n >= 0) {
                JSItem jSItem2;
                string = null;
                if ((expression2 = (Expression)arrayList2.get(n--)) instanceof IdentifierReference) {
                    string = new String(((IdentifierReference)expression2).token);
                } else if (expression2 instanceof StringLiteral) {
                    string = new String(((StringLiteral)expression2).source());
                }
                if (string == null) continue block1;
                if (n < 0) {
                    if (i + 1 == arrayList.size()) {
                        jSItem2 = ((JSItem)object).getChild(string);
                        if (jSItem2 == null) {
                            if (expression != null) {
                                int n2 = this.size();
                                if (expression instanceof FunctionExpression) {
                                    JSItem jSItem3;
                                    JSItem jSItem4 = this.thisScope;
                                    this.thisScope = jSItem3 = this.getThisScope((Expression)arrayList.get(arrayList.size() - 1));
                                    expression.traverse((ASTVisitor)this, frame);
                                    this.thisScope = jSItem4;
                                    jSItem = this.pop(n2);
                                    if (jSItem3 != null && jSItem != null && "prototype".equals(jSItem3.name)) {
                                        JSItem jSItem5 = jSItem.getChild("prototype");
                                        if (jSItem5 == null) {
                                            jSItem.addChild(jSItem3);
                                        } else {
                                            jSItem5.merge(jSItem3, true);
                                        }
                                    }
                                } else if (expression instanceof ObjectInitializer) {
                                    expression.traverse((ASTVisitor)this, frame);
                                    jSItem = this.pop(n2);
                                } else if (expression instanceof InvokeExpression) {
                                    jSItem = this.eval(expression, frame);
                                }
                                this.reset(n2);
                            }
                            if (jSItem == null) {
                                jSItem = new JSItem();
                            }
                            jSItem.setName(string);
                            this.setRange(jSItem, (ASTNode)expression2);
                            ((JSItem)object).addChild(jSItem);
                            continue;
                        }
                        jSItem = jSItem2;
                        continue;
                    }
                    jSItem2 = new JSItem(string);
                    this.setRange(jSItem2, (ASTNode)expression2);
                    ((JSItem)object).addChild(jSItem2);
                    continue;
                }
                jSItem2 = ((JSItem)object).getChild(string);
                if (jSItem2 == null) {
                    jSItem2 = new JSItem(string);
                    this.setRange(jSItem2, (ASTNode)expression2);
                    ((JSItem)object).addChild(jSItem2);
                }
                object = jSItem2;
            }
        }
        return jSItem;
    }

    public boolean visit(Assignment assignment, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        this.evalAssignment(assignment, frame);
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        Expression[] expressionArray = expressionStatement.expressions;
        if (expressionArray != null && expressionArray.length > 0) {
            int n = this.size();
            JSItem jSItem = null;
            for (int i = 0; i < expressionArray.length; ++i) {
                JSItem jSItem2;
                expressionArray[i].traverse((ASTVisitor)this, frame);
                if (!this.showLocalVariable || (jSItem2 = this.pop(n)) == null || jSItem2.name != null || jSItem2.type != 1 && (jSItem2.type != 2 || !jSItem2.hasChildren())) continue;
                jSItem2.name = "anonymous" + i;
                if (jSItem == null && (jSItem = this.localScope.getChild("{...}")) == null) {
                    jSItem = new JSItem("{...}");
                    this.localScope.addChild(jSItem);
                }
                jSItem.addChild(jSItem2);
            }
            this.reset(n);
        }
        return false;
    }

    private void visit(JSItem jSItem, Parameter[] parameterArray) {
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                char[] cArray = parameterArray[i].name;
                if (cArray == null || cArray.length <= 0) continue;
                jSItem.addChild(new JSItem(new String(cArray)));
            }
        }
    }

    public boolean visit(FunctionDeclaration functionDeclaration, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        String string = new String(functionDeclaration.name);
        JSItem jSItem = new JSItem(string);
        this.setRange(jSItem, (ASTNode)functionDeclaration);
        jSItem.type = 1;
        this.localScope.addChild(jSItem);
        if (functionDeclaration.body != null) {
            JSItem jSItem2;
            JSItem jSItem3 = this.thisScope;
            JSItem jSItem4 = this.localScope;
            this.localScope = new JSItem(jSItem4);
            this.visit(this.localScope, functionDeclaration.parameters);
            this.thisScope = jSItem2 = new JSItem("prototype");
            jSItem.addChild(jSItem2);
            functionDeclaration.body.traverse((ASTVisitor)this, frame);
            if (!jSItem2.hasChildren()) {
                jSItem.remove(jSItem2);
            }
            this.thisScope = jSItem3;
            this.localScope = jSItem4;
        }
        return false;
    }

    private JSItem collectLocalVariable(JSItem jSItem, JSItem jSItem2) {
        if (!this.showLocalVariable) {
            return null;
        }
        JSItem jSItem3 = null;
        if (jSItem2.hasChildren()) {
            JSItem[] jSItemArray = jSItem2.getChildren();
            for (int i = 0; i < jSItemArray.length; ++i) {
                JSItem jSItem4 = jSItemArray[i];
                String string = jSItem4.getName();
                if (string == null || "prototype".equals(jSItem4.getName()) || jSItem4.type != 1 && (!jSItem4.hasChildren() || jSItem4.type != 2 && jSItem4.getChild("prototype") == null)) continue;
                if (jSItem3 == null) {
                    if (jSItem != null) {
                        jSItem3 = jSItem.getChild("{...}");
                    }
                    if (jSItem3 == null) {
                        jSItem3 = new JSItem("{...}");
                    }
                }
                jSItem3.addChild(jSItem4);
            }
        }
        return jSItem3;
    }

    public boolean visit(FunctionExpression functionExpression, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        JSItem jSItem = new JSItem();
        jSItem.type = 1;
        this.setRange(jSItem, (ASTNode)functionExpression);
        this.push(jSItem);
        if (functionExpression.body != null) {
            JSItem jSItem2 = this.localScope;
            this.localScope = new JSItem(jSItem2);
            this.visit(this.localScope, functionExpression.parameters);
            if (this.thisScope == null) {
                this.thisScope = jSItem;
            }
            functionExpression.body.traverse((ASTVisitor)this, frame);
            JSItem jSItem3 = this.collectLocalVariable(this.thisScope, this.localScope);
            if (jSItem3 != null) {
                jSItem.addChild(jSItem3);
            }
            this.localScope = jSItem2;
        }
        return false;
    }

    protected JSItem apply(Expression expression, Expression expression2, boolean bl) {
        JSItem jSItem = this.getItem(expression, false);
        if (jSItem != null) {
            this.apply(jSItem, expression2, bl);
        }
        return jSItem;
    }

    protected void apply(JSItem jSItem, Expression expression, boolean bl) {
        if (expression instanceof ObjectInitializer) {
            int n = this.size();
            expression.traverse((ASTVisitor)this, null);
            JSItem jSItem2 = this.pop(n);
            if (jSItem2 != null) {
                jSItem.merge(jSItem2, bl);
            }
        }
    }

    public boolean visit(InvokeExpression invokeExpression, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        if (invokeExpression.arguments != null && invokeExpression.receiver instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)invokeExpression.receiver;
            if (binaryExpression.left instanceof IdentifierReference && binaryExpression.right instanceof IdentifierReference && CharOperation.equals((char[])NS_Ext, (char[])((IdentifierReference)binaryExpression.left).token)) {
                Expression[] expressionArray = invokeExpression.arguments;
                char[] cArray = ((IdentifierReference)binaryExpression.right).token;
                if (CharOperation.equals((char[])F_apply, (char[])cArray)) {
                    JSItem jSItem;
                    if (expressionArray.length == 2) {
                        this.apply(expressionArray[0], expressionArray[1], true);
                    } else if (expressionArray.length == 3 && (jSItem = this.apply(expressionArray[0], expressionArray[2], true)) != null) {
                        this.apply(jSItem, expressionArray[1], true);
                    }
                    return false;
                }
                if (CharOperation.equals((char[])F_applyIf, (char[])cArray)) {
                    if (expressionArray.length == 2) {
                        this.apply(expressionArray[0], expressionArray[1], false);
                    }
                    return false;
                }
                if (CharOperation.equals((char[])F_extend, (char[])cArray)) {
                    Expression expression;
                    JSItem jSItem;
                    if ((expressionArray.length == 2 || expressionArray.length == 3) && (jSItem = this.getItem(expressionArray[0], false)) != null && (expression = expressionArray[expressionArray.length - 1]) instanceof ObjectInitializer) {
                        JSItem jSItem2 = jSItem.getChild("prototype");
                        if (jSItem2 == null) {
                            jSItem2 = new JSItem("prototype");
                            this.apply(jSItem2, expression, false);
                            if (jSItem2.hasChildren()) {
                                jSItem.addChild(jSItem2);
                            }
                        } else {
                            this.apply(jSItem2, expression, false);
                        }
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public boolean visit(ObjectInitializer objectInitializer, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        JSItem jSItem = new JSItem();
        jSItem.type = 2;
        this.push(jSItem);
        Expression[] expressionArray = objectInitializer.expressions;
        if (expressionArray != null && expressionArray.length > 0) {
            int n = this.size();
            JSItem jSItem2 = this.thisScope;
            JSItem jSItem3 = this.localScope;
            this.thisScope = jSItem;
            this.localScope = new JSItem(jSItem3);
            for (int i = 0; i < expressionArray.length; ++i) {
                if (this.fCancelled) {
                    return false;
                }
                if (!(expressionArray[i] instanceof FieldLiteral)) continue;
                String string = null;
                FieldLiteral fieldLiteral = (FieldLiteral)expressionArray[i];
                if (fieldLiteral.field instanceof IdentifierReference) {
                    string = new String(((IdentifierReference)fieldLiteral.field).token);
                } else if (fieldLiteral.field instanceof StringLiteral) {
                    string = new String(((StringLiteral)fieldLiteral.field).source());
                }
                if (string == null) continue;
                if (fieldLiteral.value instanceof FunctionExpression) {
                    fieldLiteral.value.traverse((ASTVisitor)this, frame);
                } else if (fieldLiteral.value instanceof ObjectInitializer) {
                    fieldLiteral.value.traverse((ASTVisitor)this, frame);
                }
                JSItem jSItem4 = this.pop(n);
                if (jSItem4 == null) {
                    jSItem4 = new JSItem(string);
                    if (fieldLiteral.value instanceof FunctionExpression) {
                        jSItem4.type = 1;
                    }
                } else {
                    jSItem4.setName(string);
                }
                this.setRange(jSItem4, (ASTNode)fieldLiteral.field);
                jSItem.addChild(jSItem4);
            }
            this.reset(n);
            this.thisScope = jSItem2;
            this.localScope = jSItem3;
        }
        return false;
    }

    public boolean visit(VariableBinding variableBinding, Frame frame) {
        if (this.fCancelled) {
            return false;
        }
        JSItem jSItem = null;
        Expression expression = variableBinding.initializer;
        if (expression instanceof Assignment) {
            this.evalAssignment((Assignment)expression, frame);
        } else if (expression != null) {
            jSItem = this.eval(expression, frame);
        }
        if (jSItem == null) {
            jSItem = new JSItem(new String(variableBinding.name));
        } else {
            jSItem.setName(new String(variableBinding.name));
        }
        this.setRange(jSItem, (ASTNode)variableBinding);
        this.localScope.addChild(jSItem);
        return false;
    }

    protected void setRange(JSItem jSItem, ASTNode aSTNode) {
        int n = 0;
        if (aSTNode instanceof IdentifierReference || aSTNode instanceof StringLiteral) {
            n = aSTNode.sourceEnd - aSTNode.sourceStart;
        } else if (jSItem.name != null) {
            n = jSItem.name.length() - 1;
        }
        if (jSItem.range == null) {
            jSItem.range = new Point(aSTNode.sourceStart, aSTNode.sourceStart + n);
        } else {
            jSItem.range.x = aSTNode.sourceStart;
            jSItem.range.y = aSTNode.sourceStart + n;
        }
    }
}

