/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.util;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionDispatcher
implements IPostSelectionProvider {
    private ISelectionProvider fProvider;
    private ListenerList fSelectionChangedListeners = new ListenerList(1);
    private ListenerList fPostSelectionChangedListeners = new ListenerList(1);
    private ISelectionChangedListener fSelListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            SelectionDispatcher.this.onSelectionChanged(selectionChangedEvent);
        }
    };
    private ISelectionChangedListener fPostSelListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            SelectionDispatcher.this.onPostSelectionChanged(selectionChangedEvent);
        }
    };

    public void dispose() {
        if (this.fProvider != null) {
            this.install(this.fProvider, false);
            this.fProvider = null;
        }
        this.fSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners.clear();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fProvider;
    }

    public void setSelectionProvider(ISelectionProvider object) {
        if (this.fProvider == object) {
            return;
        }
        if (this.fProvider != null) {
            this.install(this.fProvider, false);
        }
        this.fProvider = object;
        if (this.fProvider != null) {
            this.install(this.fProvider, true);
        }
        ISelection iSelection = null;
        if (this.fProvider != null) {
            iSelection = this.fProvider.getSelection();
        }
        if (iSelection == null) {
            iSelection = StructuredSelection.EMPTY;
        }
        if (object == null) {
            object = this;
        }
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(object, iSelection);
        this.onSelectionChanged(selectionChangedEvent);
        this.onPostSelectionChanged(selectionChangedEvent);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPostSelectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPostSelectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        if (this.fProvider != null) {
            return this.fProvider.getSelection();
        }
        return null;
    }

    public void setSelection(ISelection iSelection) {
        if (this.fProvider != null) {
            this.fProvider.setSelection(iSelection);
        }
    }

    protected void install(ISelectionProvider iSelectionProvider, boolean bl) {
        if (iSelectionProvider != null) {
            if (bl) {
                iSelectionProvider.addSelectionChangedListener(this.fSelListener);
                if (iSelectionProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener(this.fPostSelListener);
                } else {
                    iSelectionProvider.addSelectionChangedListener(this.fPostSelListener);
                }
            } else {
                iSelectionProvider.removeSelectionChangedListener(this.fSelListener);
                if (iSelectionProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)iSelectionProvider).removePostSelectionChangedListener(this.fPostSelListener);
                } else {
                    iSelectionProvider.removeSelectionChangedListener(this.fPostSelListener);
                }
            }
        }
    }

    protected void fireSelectionChanged(final SelectionChangedEvent selectionChangedEvent, ListenerList listenerList) {
        if (listenerList.isEmpty()) {
            return;
        }
        Object[] objectArray = listenerList.getListeners();
        for (int i = 0; i < objectArray.length; ++i) {
            final ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            });
        }
    }

    protected void onSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelectionChanged(selectionChangedEvent, this.fSelectionChangedListeners);
    }

    protected void onPostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelectionChanged(selectionChangedEvent, this.fPostSelectionChangedListeners);
    }
}

