/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.util;

import com.spket.palette.Palette;
import com.spket.palette.PaletteReader;
import com.spket.ui.internal.DefaultImageProvider;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.util.Descriptors;
import com.spket.util.Debug;
import com.spket.util.ImageProvider;
import com.spket.util.StringUtils;
import com.spket.util.Translator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExtensionReader {
    private static final String SNIPPETS_EXTENSION = "xml";
    private static final String EDITOR_EXTENSION_POINT = "com.spket.ui.editorConfigurations";
    private static final String T_SNIPPETS = "snippets";
    private static final String T_INCLUDE = "include";
    private static final String A_ID = "id";
    private static final String A_FILE = "file";
    private static final String A_TRANSLATIONS = "translations";
    private static final String A_IMAGE_PROVIDER = "imageProvider";
    private static final String T_DESCRIPTORS = "descriptors";
    private static final String T_CATEGORY = "category";
    private static final String T_DESCRIPTOR = "descriptor";
    private static final String T_ATTR = "attr";
    private static final String T_ATTR_GROUP = "attrGroup";
    private static final String A_NAME = "name";
    private static final String A_REF = "ref";
    private static final String A_LABEL = "label";
    private static final String A_SELECT = "select";
    private static final String A_TYPE = "type";
    private static final String A_EDITABLE = "editable";
    private static final String A_CATEGORY = "category";
    private static final String A_ENUM = "enumeration";
    private static final String A_GRAMMAR = "grammar";
    private static final String A_DEFAULT = "default";
    private static final String A_CASE_SENSITIVE = "casesensitive";
    private static Map imageDescs = new HashMap();

    public static ImageDescriptor getImageDescriptor(String string) {
        if (string == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = (ImageDescriptor)imageDescs.get(string);
        if (imageDescriptor == null) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
                UIPlugin.log(malformedURLException);
            }
            imageDescriptor = uRL != null ? ImageDescriptor.createFromURL((URL)uRL) : ImageDescriptor.getMissingImageDescriptor();
            imageDescs.put(string, imageDescriptor);
        }
        return imageDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Palette getPalette(String string) {
        Palette palette = null;
        IFileStore iFileStore = ExtensionReader.getPaletteStore(string);
        if (iFileStore.fetchInfo().exists() && !iFileStore.fetchInfo().isDirectory()) {
            InputStream inputStream = null;
            inputStream = iFileStore.openInputStream(0, null);
            palette = ExtensionReader.getPalette(string, inputStream);
            Object var6_5 = null;
            if (inputStream == null) return palette;
            try {
                inputStream.close();
                return palette;
            }
            catch (IOException iOException) {}
            return palette;
            {
                catch (CoreException coreException) {
                    UIPlugin.log(coreException.getStatus());
                    Object var6_6 = null;
                    if (inputStream == null) return palette;
                    try {
                        inputStream.close();
                        return palette;
                    }
                    catch (IOException iOException) {}
                    return palette;
                }
                catch (IOException iOException) {
                    UIPlugin.log(iOException);
                    Object var6_7 = null;
                    if (inputStream == null) return palette;
                    try {
                        inputStream.close();
                        return palette;
                    }
                    catch (IOException iOException2) {}
                    return palette;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IConfigurationElement[] iConfigurationElementArray = ExtensionReader.getConfiguration(string, T_SNIPPETS);
        if (iConfigurationElementArray == null) return palette;
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            try {
                palette = ExtensionReader.readSnippets(palette, iConfigurationElementArray[i]);
                continue;
            }
            catch (IOException iOException) {
                UIPlugin.log(iOException);
            }
        }
        if (palette == null) return palette;
        palette.setId(string);
        return palette;
    }

    public static Palette getPalette(String string, InputStream inputStream) throws CoreException, IOException {
        Object object;
        IConfigurationElement iConfigurationElement;
        ArrayList<ImageProvider> arrayList = null;
        IConfigurationElement[] iConfigurationElementArray = ExtensionReader.getConfiguration(string, T_SNIPPETS);
        if (iConfigurationElementArray != null) {
            arrayList = new ArrayList<ImageProvider>(iConfigurationElementArray.length);
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                ImageProvider imageProvider;
                iConfigurationElement = iConfigurationElementArray[i];
                object = iConfigurationElement.getAttribute(A_IMAGE_PROVIDER);
                if (object == null || (imageProvider = (ImageProvider)iConfigurationElement.createExecutableExtension(A_IMAGE_PROVIDER)) == null) continue;
                arrayList.add(imageProvider);
            }
        }
        Palette palette = null;
        iConfigurationElement = null;
        object = new PaletteReader();
        if (arrayList != null && arrayList.size() == 1) {
            iConfigurationElement = (ImageProvider)arrayList.get(0);
        }
        if ((palette = object.read(inputStream, null, iConfigurationElement)) != null) {
            palette.setId(string);
            if (iConfigurationElement != null) {
                palette.setImageProvider((ImageProvider)iConfigurationElement);
            }
        }
        return palette;
    }

    protected static IFileStore getPaletteStore(String string) {
        IPath iPath = UIPlugin.getDefault().getStateLocation().append(string).addFileExtension(SNIPPETS_EXTENSION);
        return EFS.getLocalFileSystem().getStore(iPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writePalette(Palette palette) throws CoreException, IOException {
        OutputStream outputStream = null;
        IFileStore iFileStore = ExtensionReader.getPaletteStore(palette.getId());
        iFileStore.getParent().mkdir(0, null);
        PaletteReader paletteReader = new PaletteReader();
        try {
            outputStream = iFileStore.openOutputStream(0, null);
            paletteReader.write(outputStream, palette);
            Object var5_4 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static Descriptors getDescriptors(String string) {
        Descriptors descriptors = null;
        IConfigurationElement[] iConfigurationElementArray = ExtensionReader.getConfiguration(string, T_DESCRIPTORS);
        if (iConfigurationElementArray != null) {
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                try {
                    descriptors = ExtensionReader.readDescriptors(descriptors, iConfigurationElementArray[i]);
                    continue;
                }
                catch (IOException iOException) {
                    UIPlugin.log(iOException);
                }
            }
        }
        return descriptors;
    }

    private static IConfigurationElement[] getConfiguration(String string, String string2) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EDITOR_EXTENSION_POINT);
        if (iConfigurationElementArray.length > 0) {
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                String string3 = iConfigurationElementArray[i].getAttribute(A_ID);
                if (!string.equals(string3)) continue;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[i].getChildren(string2);
                for (int j = 0; j < iConfigurationElementArray2.length; ++j) {
                    IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElementArray2[j].getChildren(T_INCLUDE);
                    for (int k = 0; k < iConfigurationElementArray3.length; ++k) {
                        arrayList.add(iConfigurationElementArray3[k]);
                    }
                }
            }
        }
        if (arrayList.size() > 0) {
            IConfigurationElement[] iConfigurationElementArray4 = new IConfigurationElement[arrayList.size()];
            arrayList.toArray(iConfigurationElementArray4);
            return iConfigurationElementArray4;
        }
        return null;
    }

    private static Descriptors readDescriptors(InputStream inputStream, ResourceBundle resourceBundle) throws IOException {
        Descriptors descriptors = null;
        try {
            XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            DescriptorHandler descriptorHandler = new DescriptorHandler(resourceBundle);
            xMLReader.setContentHandler(descriptorHandler);
            xMLReader.parse(new InputSource(inputStream));
            descriptors = descriptorHandler.getDescriptors();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            Throwable throwable = sAXException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable != null) {
                throw new IOException(throwable.getMessage());
            }
            throw new IOException(sAXException.getMessage());
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Descriptors readDescriptors(Descriptors object, IConfigurationElement iConfigurationElement) throws IOException {
        Bundle bundle;
        URL uRL;
        String string = iConfigurationElement.getAttribute(A_FILE);
        if (string != null && (uRL = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName())), (IPath)Path.fromOSString((String)string), null)) != null) {
            IOException iOException3;
            BufferedInputStream bufferedInputStream;
            block15: {
                bufferedInputStream = null;
                PropertyResourceBundle propertyResourceBundle = null;
                InputStream inputStream = null;
                String string2 = iConfigurationElement.getAttribute(A_TRANSLATIONS);
                try {
                    Object object2;
                    if (string2 != null && (object2 = FileLocator.find((Bundle)bundle, (IPath)Path.fromOSString((String)string2), null)) != null) {
                        inputStream = ((URL)object2).openStream();
                        propertyResourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                    object2 = ExtensionReader.readDescriptors(bufferedInputStream, propertyResourceBundle);
                    if (object == null) {
                        object = object2;
                    } else {
                        ((Descriptors)object).add((Descriptors)object2);
                    }
                    Object var11_10 = null;
                    if (inputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    IOException iOException22;
                    Object var11_11 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            Debug.warn((Throwable)iOException22);
                        }
                    }
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException22) {
                            Debug.warn((Throwable)iOException22);
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    Debug.warn((Throwable)iOException3);
                }
            }
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException3) {
                    Debug.warn((Throwable)iOException3);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Palette readSnippets(Palette palette, IConfigurationElement iConfigurationElement) throws IOException {
        Bundle bundle;
        URL uRL;
        String string = iConfigurationElement.getAttribute(A_FILE);
        if (string != null && (uRL = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName())), (IPath)Path.fromOSString((String)string), null)) != null) {
            IOException iOException3;
            BufferedInputStream bufferedInputStream;
            block20: {
                bufferedInputStream = null;
                PropertyResourceBundle propertyResourceBundle = null;
                DefaultImageProvider defaultImageProvider = null;
                ImageProvider imageProvider = null;
                InputStream inputStream = null;
                String string2 = iConfigurationElement.getAttribute(A_TRANSLATIONS);
                String string3 = iConfigurationElement.getAttribute(A_IMAGE_PROVIDER);
                if (string3 != null) {
                    try {
                        imageProvider = (ImageProvider)iConfigurationElement.createExecutableExtension(A_IMAGE_PROVIDER);
                        defaultImageProvider = imageProvider;
                    }
                    catch (CoreException coreException) {
                        UIPlugin.log(coreException.getStatus());
                    }
                    catch (RuntimeException runtimeException) {
                        UIPlugin.log(runtimeException);
                    }
                }
                defaultImageProvider = new DefaultImageProvider(bundle.getSymbolicName(), defaultImageProvider);
                try {
                    URL uRL2;
                    if (string2 != null && (uRL2 = FileLocator.find((Bundle)bundle, (IPath)Path.fromOSString((String)string2), null)) != null) {
                        inputStream = uRL2.openStream();
                        propertyResourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                    uRL2 = new PaletteReader();
                    Palette palette2 = uRL2.read(bufferedInputStream, propertyResourceBundle, defaultImageProvider);
                    if (palette == null) {
                        palette = palette2;
                        if (palette2 != null) {
                            palette2.setImageProvider(imageProvider);
                        }
                    } else {
                        palette.addCategories(palette2.getCategories());
                    }
                    Object var15_16 = null;
                    if (inputStream == null) break block20;
                }
                catch (Throwable throwable) {
                    IOException iOException22;
                    Object var15_17 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException22) {
                            Debug.warn((Throwable)iOException22);
                        }
                    }
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException22) {
                            Debug.warn((Throwable)iOException22);
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    Debug.warn((Throwable)iOException3);
                }
            }
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException3) {
                    Debug.warn((Throwable)iOException3);
                }
            }
        }
        return palette;
    }

    private static class DescriptorHandler
    implements ContentHandler {
        private String grammar;
        private String defaultCategory;
        private boolean isCaseSensitive;
        private Map categories = new HashMap();
        private Map descriptors = new HashMap();
        private Map attrGroups = new HashMap();
        private StringBuffer attrList;
        private Map groups = new HashMap();
        private Stack nodes = new Stack();
        private Descriptors.Node current;
        private Translator translator;

        public DescriptorHandler(ResourceBundle resourceBundle) {
            this.translator = new Translator(resourceBundle);
        }

        public Descriptors getDescriptors() {
            Descriptors descriptors = new Descriptors();
            descriptors.grammar = this.grammar;
            descriptors.defaultCategory = this.defaultCategory;
            descriptors.isCaseSensitive = this.isCaseSensitive;
            descriptors.categories.putAll(this.categories);
            descriptors.descriptors.putAll(this.descriptors);
            descriptors.attrGroups.putAll(this.attrGroups);
            return descriptors;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("category".equals(string3)) {
                if (this.current == null) {
                    String string4 = attributes.getValue(ExtensionReader.A_ID);
                    String string5 = this.translator.translate(attributes.getValue(ExtensionReader.A_LABEL));
                    this.categories.put(string4, string5);
                    if (StringUtils.toBoolean((String)attributes.getValue(ExtensionReader.A_DEFAULT))) {
                        this.defaultCategory = string4;
                    }
                } else {
                    String string6 = attributes.getValue(ExtensionReader.A_ID);
                    this.attrList = (StringBuffer)this.groups.get(string6);
                    if (this.attrList == null) {
                        this.attrList = new StringBuffer();
                        this.groups.put(string6, this.attrList);
                    } else {
                        this.attrList.append(',');
                    }
                }
            } else if (ExtensionReader.T_DESCRIPTOR.equals(string3)) {
                String string7 = attributes.getValue(ExtensionReader.A_NAME);
                if (!this.isCaseSensitive) {
                    string7 = string7.toLowerCase();
                }
                Descriptors.Descriptor descriptor = new Descriptors.Descriptor(string7);
                this.descriptors.put(string7, descriptor);
                this.current = descriptor;
            } else if (ExtensionReader.T_ATTR.equals(string3)) {
                Descriptors.Node node;
                String string8 = attributes.getValue(ExtensionReader.A_REF);
                String string9 = attributes.getValue(ExtensionReader.A_LABEL);
                if (string8 != null) {
                    if (!this.isCaseSensitive) {
                        string8 = string8.toLowerCase();
                    }
                    node = new Descriptors.AttributeRef(string8, string9);
                } else {
                    Descriptors.Attribute attribute = new Descriptors.Attribute(string9);
                    attribute.select = attributes.getValue(ExtensionReader.A_SELECT);
                    attribute.type = attributes.getValue(ExtensionReader.A_TYPE);
                    attribute.category = attributes.getValue("category");
                    attribute.enumeration = attributes.getValue(ExtensionReader.A_ENUM);
                    String string10 = attributes.getValue(ExtensionReader.A_EDITABLE);
                    if ("true".equals(string10)) {
                        attribute.editable = 1;
                    } else if ("false".equals(string10)) {
                        attribute.editable = -1;
                    }
                    node = attribute;
                }
                this.current.add(node);
                this.nodes.push(this.current);
                this.current = node;
            } else if (ExtensionReader.T_ATTR_GROUP.equals(string3)) {
                String string11 = attributes.getValue(ExtensionReader.A_NAME);
                if (!this.isCaseSensitive) {
                    string11 = string11.toLowerCase();
                }
                Descriptors.Descriptor descriptor = new Descriptors.Descriptor(string11);
                this.attrGroups.put(string11, descriptor);
                this.current = descriptor;
            } else if (ExtensionReader.T_DESCRIPTORS.equals(string3)) {
                this.grammar = attributes.getValue(ExtensionReader.A_GRAMMAR);
                String string12 = attributes.getValue(ExtensionReader.A_CASE_SENSITIVE);
                this.isCaseSensitive = string12 == null ? true : StringUtils.toBoolean((String)string12);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (ExtensionReader.T_DESCRIPTOR.equals(string3)) {
                if (this.groups.size() > 0) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Iterator iterator = this.groups.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        String[] stringArray = StringUtils.split((String)this.groups.get(string4).toString(), (char)',', (boolean)false);
                        for (int i = 0; i < stringArray.length; ++i) {
                            hashMap.put(stringArray[i], string4);
                        }
                    }
                    this.groups.clear();
                    ((Descriptors.Descriptor)this.current).setCategory(hashMap);
                }
                this.current = null;
            } else if (ExtensionReader.T_ATTR.equals(string3)) {
                this.current = (Descriptors.Node)this.nodes.pop();
            } else if ("category".equals(string3)) {
                this.attrList = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.attrList != null) {
                this.attrList.append(cArray, n, n2);
            }
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }
    }
}

