/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.DefaultUIContentProvider;
import com.spket.ui.DefaultUILabelProvider;
import com.spket.ui.internal.UIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ide.StringMatcher;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class TreeInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private int fTreeStyle;
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    private TreeItem fLastItem;
    protected StringMatcher fStringMatcher;

    public TreeInformationControl(Shell shell, int n, int n2) {
        this(shell, n, n2, null, false);
    }

    public TreeInformationControl(Shell shell, int n, int n2, String string, boolean bl) {
        super(shell, n, true, true, true, true, null, null);
        this.fTreeStyle = n2;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.getShell().addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.getShell().removeDisposeListener(disposeListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.getShell().addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.getShell().removeFocusListener(focusListener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void setBackgroundColor(Color color) {
        this.applyBackgroundColor(color, this.getContents());
    }

    public void setForegroundColor(Color color) {
        this.applyForegroundColor(color, this.getContents());
    }

    public void setInformation(String string) {
    }

    public void setLocation(Point point) {
        if (!this.getPersistBounds() || this.getDialogSettings() == null) {
            this.getShell().setLocation(point);
        }
    }

    public void setSize(int n, int n2) {
        this.getShell().setSize(n, n2);
    }

    public void setSizeConstraints(int n, int n2) {
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected String getStatusFieldText() {
        return "";
    }

    protected Control createDialogArea(Composite composite) {
        this.fTreeViewer = this.createTreeViewer(composite, this.fTreeStyle);
        Tree tree = this.fTreeViewer.getTree();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        TreeInformationControl.this.onMouseMove(event);
                        break;
                    }
                    case 4: {
                        TreeInformationControl.this.onMouseUp(event);
                        break;
                    }
                    case 1: {
                        if (event.character != '\u001b') break;
                        TreeInformationControl.this.dispose();
                        break;
                    }
                    case 14: {
                        TreeInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        };
        tree.addListener(5, listener);
        tree.addListener(4, listener);
        tree.addListener(1, listener);
        tree.addListener(2, listener);
        tree.addListener(14, listener);
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    protected Control createTitleControl(Composite composite) {
        if (this.hasHeader()) {
            return super.createTitleControl(composite);
        }
        this.fFilterText = this.createFilterText(composite);
        return this.fFilterText;
    }

    protected Text createFilterText(Composite composite) {
        this.fFilterText = new Text(composite, 0);
        GridData gridData = new GridData(768);
        GC gC = new GC((Drawable)composite);
        gC.setFont(composite.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 1) {
                    switch (event.keyCode) {
                        case 13: {
                            TreeInformationControl.this.gotoSelectedElement();
                            break;
                        }
                        case 27: {
                            TreeInformationControl.this.dispose();
                            break;
                        }
                        case 0x1000001: 
                        case 0x1000002: {
                            TreeInformationControl.this.fTreeViewer.getTree().setFocus();
                        }
                    }
                } else {
                    String string = ((Text)event.widget).getText();
                    int n = string.length();
                    if (n > 0 && string.charAt(n - 1) != '*') {
                        string = string + '*';
                    }
                    TreeInformationControl.this.setMatcherString(string, true);
                }
            }
        };
        this.fFilterText.addListener(24, listener);
        this.fFilterText.addListener(1, listener);
        return this.fFilterText;
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        Object object = this.findElement(tree.getItems());
        if (object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findElement(TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            Object object = treeItem.getData();
            if (object == null) continue;
            if (this.fStringMatcher == null) {
                return object;
            }
            if (this.fStringMatcher.match(treeItem.getText())) {
                return object;
            }
            object = this.findElement(treeItem.getItems());
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected void setMatcherString(String string, boolean bl) {
        if (string.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean bl2 = string.toLowerCase().equals(string);
            this.fStringMatcher = new StringMatcher(string, bl2, false);
        }
        if (bl) {
            this.stringMatcherUpdated();
        }
    }

    protected Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    protected void gotoSelectedElement() {
        Object object = this.getSelectedElement();
        if (object != null) {
            this.dispose();
            this.open(object);
        }
    }

    protected void onMouseUp(Event event) {
        Tree tree = this.fTreeViewer.getTree();
        if (tree.getSelectionCount() < 1) {
            return;
        }
        if (event.button != 1) {
            return;
        }
        if (tree == event.widget) {
            TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
            TreeItem treeItem2 = tree.getSelection()[0];
            if (treeItem2.equals(treeItem)) {
                this.gotoSelectedElement();
            }
        }
    }

    protected void onMouseMove(Event event) {
        TreeItem treeItem;
        Tree tree = this.fTreeViewer.getTree();
        if (tree == event.widget && (treeItem = tree.getItem(new Point(event.x, event.y))) instanceof TreeItem) {
            if (!treeItem.equals(this.fLastItem)) {
                this.fLastItem = treeItem;
                tree.setSelection(new TreeItem[]{this.fLastItem});
            } else if (event.y < tree.getItemHeight() / 4) {
                Point point = tree.toDisplay(event.x, event.y);
                Item item = this.fTreeViewer.scrollUp(point.x, point.y);
                if (item instanceof TreeItem) {
                    this.fLastItem = (TreeItem)item;
                    tree.setSelection(new TreeItem[]{this.fLastItem});
                }
            } else if (event.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                Point point = tree.toDisplay(event.x, event.y);
                Item item = this.fTreeViewer.scrollDown(point.x, point.y);
                if (item instanceof TreeItem) {
                    this.fLastItem = (TreeItem)item;
                    tree.setSelection(new TreeItem[]{this.fLastItem});
                }
            }
        }
    }

    protected void inputChanged(Object object, Object object2) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(object);
        if (object2 != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object2));
        }
    }

    protected TreeViewer createTreeViewer(Composite composite, int n) {
        TreeViewer treeViewer = new TreeViewer(composite, 4 | n & 0xFFFFFFFD);
        Tree tree = treeViewer.getTree();
        GridData gridData = new GridData(1808);
        gridData.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gridData);
        treeViewer.addFilter((ViewerFilter)new NamePatternFilter());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DefaultUILabelProvider());
        treeViewer.setContentProvider((IContentProvider)new DefaultUIContentProvider());
        return treeViewer;
    }

    protected void open(Object object) {
    }

    protected ITextEditor getEditor() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = UIPlugin.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage2 = iWorkbenchPage = iWorkbenchWindow == null ? null : iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof ITextEditor) {
            return (ITextEditor)iEditorPart;
        }
        return null;
    }

    protected abstract String getId();

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object object, Object object2) {
            StringMatcher stringMatcher = TreeInformationControl.this.getMatcher();
            if (stringMatcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String string = ((ILabelProvider)treeViewer.getLabelProvider()).getText(object2);
            if (string != null && stringMatcher.match(string)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, object2);
        }

        private boolean hasUnfilteredChild(TreeViewer treeViewer, Object object) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
            if (iTreeContentProvider.hasChildren(object)) {
                Object[] objectArray = iTreeContentProvider.getChildren(object);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!this.select((Viewer)treeViewer, object, objectArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

