/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.text.IColorManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager {
    protected Map fKeyTable = new HashMap(10);
    protected Map fDisplayTable = new HashMap(2);
    private boolean fAutoDisposeOnDisplayDispose;

    public ColorManager() {
        this(true);
    }

    public ColorManager(boolean bl) {
        this.fAutoDisposeOnDisplayDispose = bl;
    }

    public void dispose(Display display) {
        Map map = (Map)this.fDisplayTable.get(display);
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Color color = (Color)iterator.next();
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public void dispose() {
        if (!this.fAutoDisposeOnDisplayDispose) {
            this.dispose(Display.getCurrent());
        }
    }

    public Color getColor(RGB rGB) {
        Color color;
        if (rGB == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        HashMap<RGB, Color> hashMap = (HashMap<RGB, Color>)this.fDisplayTable.get(display);
        if (hashMap == null) {
            hashMap = new HashMap<RGB, Color>();
            this.fDisplayTable.put(display, hashMap);
            if (this.fAutoDisposeOnDisplayDispose) {
                display.disposeExec(new Runnable(){

                    public void run() {
                        ColorManager.this.dispose(display);
                    }
                });
            }
        }
        if ((color = (Color)hashMap.get(rGB)) == null) {
            color = new Color((Device)display, rGB);
            hashMap.put(rGB, color);
        }
        return color;
    }

    public Color getColor(String string) {
        if (string == null) {
            return null;
        }
        RGB rGB = (RGB)this.fKeyTable.get(string);
        return this.getColor(rGB);
    }

    public void bindColor(String string, RGB rGB) {
        Object v = this.fKeyTable.get(string);
        if (v != null) {
            throw new IllegalStateException();
        }
        this.fKeyTable.put(string, rGB);
    }

    public void unbindColor(String string) {
        this.fKeyTable.remove(string);
    }
}

