/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.tasks;

import com.spket.ui.tasks.ITaskScanner;
import com.spket.ui.tasks.Task;
import com.spket.util.FileUtils;
import com.spket.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;

public abstract class AbstractTaskScanner
implements ITaskScanner {
    protected static final String UTF_8 = "UTF-8";
    protected static final int DEFAULT_READING_SIZE = 8192;

    protected static Integer getPriority(char[] cArray) {
        if (cArray != null) {
            if (StringUtils.equals((String)"HIGH", (char[])cArray, (boolean)true)) {
                return Task.P_HIGH;
            }
            if (StringUtils.equals((String)"LOW", (char[])cArray, (boolean)true)) {
                return Task.P_LOW;
            }
        }
        return Task.P_NORMAL;
    }

    protected static int getLineNumber(int n, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return 1;
        }
        if (n3 == -1) {
            return 1;
        }
        int n4 = n2;
        while (n2 <= n3) {
            n4 = n2 + (n3 - n2) / 2;
            int n5 = nArray[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            return n4 + 1;
        }
        if (n < nArray[n4]) {
            return n4 + 1;
        }
        return n4 + 2;
    }

    protected char[] getResourceContentsAsCharArray(IFile iFile) throws CoreException {
        String string;
        try {
            string = iFile.getCharset();
        }
        catch (CoreException coreException) {
            string = null;
        }
        return this.getResourceContentsAsCharArray(iFile, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getResourceContentsAsCharArray(IFile iFile, String string) throws CoreException {
        IPath iPath = iFile.getLocation();
        long l = iPath == null ? EFS.getStore((URI)iFile.getLocationURI()).fetchInfo().getLength() : iPath.toFile().length();
        InputStream inputStream = iFile.getContents(true);
        try {
            Object[] objectArray;
            boolean bl = false;
            if (string == null) {
                inputStream = FileUtils.cache((InputStream)inputStream);
                try {
                    objectArray = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                    IContentDescription iContentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, iFile.getLocation().lastSegment(), (QualifiedName[])objectArray);
                    if (iContentDescription != null) {
                        bl = iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                        string = iContentDescription.getCharset();
                    }
                }
                finally {
                    inputStream.reset();
                }
            }
            if (string == null) {
                string = FileBuffers.getTextFileBufferManager().getDefaultEncoding();
            }
            if (bl && UTF_8.equals(string)) {
                int n = 0;
                do {
                    int n2;
                    if ((n2 = inputStream.read(new byte[IContentDescription.BOM_UTF_8.length])) == -1) {
                        throw new IOException();
                    }
                    n += n2;
                    if (l <= (long)n2) continue;
                    l -= (long)n2;
                } while (n < IContentDescription.BOM_UTF_8.length);
            }
            objectArray = AbstractTaskScanner.getInputStreamAsCharArray(inputStream, (int)l, string);
            return objectArray;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.spket.ui", 4, iOException.getLocalizedMessage(), null));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        int n2 = 0;
        char[] cArray = n == -1 ? new char[]{} : new char[n];
        while (true) {
            int n3;
            int n4;
            if (n2 < n) {
                n4 = n - n2;
            } else {
                n3 = inputStreamReader.read();
                if (n3 < 0) break;
                n4 = Math.max(inputStream.available(), 8192);
                if (n2 + 1 + n4 > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n2 + 1 + n4];
                    System.arraycopy(cArray2, 0, cArray, 0, n2);
                }
                cArray[n2++] = (char)n3;
            }
            n3 = inputStreamReader.read(cArray, n2, n4);
            if (n3 < 0) break;
            n2 += n3;
        }
        if (n2 < cArray.length) {
            char[] cArray3 = cArray;
            cArray = new char[n2];
            System.arraycopy(cArray3, 0, cArray, 0, n2);
        }
        return cArray;
    }
}

