/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.properties;

import com.spket.ui.properties.IPropertyDescription;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PropertyDescription {
    protected StyledText fText;
    protected Cursor fHandCursor;
    protected Cursor fBusyCursor;
    protected boolean fMouseDown;
    protected boolean fDragEvent;
    protected Object fInput;

    public void createControl(Composite composite, int n) {
        this.fText = new StyledText(composite, 0x8004A | n);
        this.fHandCursor = new Cursor((Device)composite.getDisplay(), 21);
        this.fText.setCaret(null);
        this.fText.setFont(composite.getFont());
        this.fText.setCursor(null);
        this.fText.setBackground(composite.getBackground());
        this.installListeners();
    }

    public Control getControl() {
        return this.fText;
    }

    public void setTitle(String string) {
    }

    public void setDescription(String string) {
    }

    public void setDescription(IPropertyDescription iPropertyDescription) {
    }

    public void setInput(Object object) {
        if (this.fInput == object) {
            return;
        }
        this.fInput = object;
    }

    public boolean isVisible() {
        if (this.fText == null || this.fText.isDisposed()) {
            return false;
        }
        return this.fText.isVisible();
    }

    public void setVisible(boolean bl) {
        if (this.fText == null || this.fText.isDisposed()) {
            return;
        }
        if (bl != this.fText.isVisible()) {
            this.fText.setVisible(bl);
        }
    }

    protected void onDispose() {
        if (this.fHandCursor != null) {
            this.fHandCursor.dispose();
            this.fHandCursor = null;
        }
        if (this.fBusyCursor != null) {
            this.fBusyCursor.dispose();
            this.fBusyCursor = null;
        }
        this.fInput = null;
        this.fText = null;
    }

    protected void onOpenHyperlink(Event event) {
    }

    protected void onMouseMove(Event event) {
        if (this.fInput == null) {
            return;
        }
        if (this.fMouseDown) {
            if (!this.fDragEvent) {
                StyledText styledText = (StyledText)event.widget;
                styledText.setCursor(null);
            }
            this.fDragEvent = true;
            return;
        }
        StyledText styledText = (StyledText)event.widget;
        int n = -1;
        try {
            n = styledText.getOffsetAtLocation(new Point(event.x, event.y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (n == -1) {
            styledText.setCursor(null);
        } else {
            styledText.setCursor(null);
        }
    }

    protected void onMouseDown(Event event) {
        if (this.fInput == null) {
            return;
        }
        if (event.button != 1) {
            return;
        }
        this.fMouseDown = true;
    }

    protected void onMouseUp(Event event) {
        this.fMouseDown = false;
        if (this.fInput == null) {
            return;
        }
        if (this.fDragEvent) {
            this.fDragEvent = false;
        }
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        PropertyDescription.this.onMouseMove(event);
                        break;
                    }
                    case 3: {
                        PropertyDescription.this.onMouseDown(event);
                        break;
                    }
                    case 4: {
                        PropertyDescription.this.onMouseUp(event);
                        break;
                    }
                    case 12: {
                        PropertyDescription.this.onDispose();
                    }
                }
            }
        };
        this.fText.addListener(5, listener);
        this.fText.addListener(3, listener);
        this.fText.addListener(4, listener);
        this.fText.addListener(12, listener);
    }
}

