/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.properties;

import com.spket.ui.properties.CellEditor;
import com.spket.ui.properties.IDropDownEditor;
import com.spket.ui.properties.IPropertyDescriptor;
import com.spket.ui.properties.IPropertyProvider;
import com.spket.widget.CItem;
import com.spket.widget.ColorList;
import com.spket.widget.Colors;
import com.spket.widget.UIUtils;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ColorCellEditor
extends CellEditor
implements IDropDownEditor {
    private Colors.NamedColor fColor;
    private ColorList fPicker;
    protected Listener fListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    ColorCellEditor.this.valueChanged();
                }
            }
        }
    };

    public void fill(Composite composite) {
        this.fPicker = new ColorList(composite, 0);
        this.fPicker.addDefaultItems();
        this.fPicker.setSelection(this.fColor == null ? ColorList.DEFAULT_ITEM : this.fColor);
        this.fPicker.addListener(13, this.fListener);
    }

    public void setFocus() {
        if (UIUtils.okToUse((Widget)this.fPicker)) {
            this.fPicker.setFocus();
        }
    }

    public void popup(Shell shell) {
        ColorDialog colorDialog = new ColorDialog(shell);
        RGB rGB = colorDialog.open();
        if (rGB == null) {
            this.fireCancelEditor();
        } else {
            int n = Colors.rgb((RGB)rGB);
            this.fColor = Colors.getColor((int)n);
            if (this.fColor == null) {
                this.fColor = new Colors.NamedColor(null, n);
            }
            this.fireApplyEditorValue();
        }
    }

    public boolean isFixedSize() {
        return true;
    }

    public void setValue(Object object) {
        this.fColor = this.toColor(object);
        if (this.fPicker != null) {
            this.fPicker.setSelection(this.fColor == null ? ColorList.DEFAULT_ITEM : this.fColor);
        }
    }

    public Object getValue() {
        return this.fColor;
    }

    public Object getNextValue(IPropertyProvider[] iPropertyProviderArray, IPropertyDescriptor iPropertyDescriptor, Object object) {
        if (object != null) {
            String string = null;
            int n = Colors.rgb((String)object.toString());
            if (n >= 0) {
                string = Colors.getColorNameByValue((int)n);
            }
            if (string != null) {
                Colors.NamedColor[] namedColorArray = Colors.getColors();
                for (int i = 0; i < namedColorArray.length; ++i) {
                    if (n != namedColorArray[i].getValue()) continue;
                    if (++i == namedColorArray.length) {
                        i = 0;
                    }
                    return namedColorArray[i];
                }
            }
        }
        return Colors.getColor((int)0);
    }

    protected Colors.NamedColor toColor(Object object) {
        Colors.NamedColor namedColor;
        int n = -1;
        if (object instanceof Colors.NamedColor) {
            return (Colors.NamedColor)object;
        }
        if (object instanceof RGB) {
            n = Colors.rgb((RGB)((RGB)object));
        } else if (object != null && (namedColor = Colors.getColor((int)(n = Colors.rgb((String)object.toString())))) != null) {
            return namedColor;
        }
        if (n != -1) {
            return new Colors.NamedColor(null, n);
        }
        return null;
    }

    protected void valueChanged() {
        CItem cItem = this.fPicker.getSelection();
        if (cItem == null) {
            this.fireCancelEditor();
        } else {
            Colors.NamedColor namedColor = (Colors.NamedColor)cItem.getData();
            if (namedColor == ColorList.CUSTOM_ITEM) {
                this.firePopup();
            } else if (namedColor == ColorList.DEFAULT_ITEM) {
                this.fColor = null;
                this.fireApplyEditorValue();
            } else {
                this.fColor = namedColor;
                this.fireApplyEditorValue();
            }
        }
    }
}

