/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.preferences.AbstractPreferencePage;
import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.ui.preferences.PrefMessages;
import com.spket.ui.text.ColorManager;
import com.spket.ui.text.IColorManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public abstract class ColoringConfigurationPage
extends AbstractPreferencePage {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String UNDERLINE = "_underline";
    private static final String STRIKETHROUGH = "_strikethrough";
    private Label fColorEditorLabel;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private Button fUnderlineCheckBox;
    private Button fStrikethroughCheckBox;
    private IColorManager fColorManager = new ColorManager(false);
    private StructuredViewer fListViewer;
    private SourceViewer fPreviewViewer;
    private List fListModel;

    public void dispose() {
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        super.dispose();
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void initialize() {
        super.initialize();
        List list = this.getListModel();
        this.fListViewer.setInput((Object)list);
        HighlightingColorListItem highlightingColorListItem = (HighlightingColorListItem)list.get(0);
        Object object = highlightingColorListItem.getCategory();
        if (object == null) {
            object = highlightingColorListItem;
        }
        this.fListViewer.setSelection((ISelection)new StructuredSelection(object));
    }

    protected Control createContents(Composite composite) {
        HighlightingColorListItem highlightingColorListItem;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 1, true, false);
        composite3.setLayoutData((Object)gridData);
        this.fListViewer = new TreeViewer(composite3, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        gridData = new GridData(1, 1, false, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(9);
        int n = 0;
        ScrollBar scrollBar = this.getListModel().iterator();
        while (scrollBar.hasNext()) {
            highlightingColorListItem = (HighlightingColorListItem)scrollBar.next();
            n = Math.max(n, this.convertWidthInCharsToPixels(highlightingColorListItem.getDisplayName().length()));
        }
        scrollBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (scrollBar != null) {
            n += scrollBar.getSize().x * 3;
        }
        gridData.widthHint = n;
        this.fListViewer.getControl().setLayoutData((Object)gridData);
        highlightingColorListItem = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        highlightingColorListItem.setLayout((Layout)gridLayout);
        highlightingColorListItem.setLayoutData(new GridData(1808));
        this.fColorEditorLabel = new Label((Composite)highlightingColorListItem, 16384);
        this.fColorEditorLabel.setText(PrefMessages.PreferencePage_color);
        gridData = new GridData(32);
        gridData.horizontalIndent = 10;
        this.fColorEditorLabel.setLayoutData((Object)gridData);
        this.fSyntaxForegroundColorEditor = new ColorSelector((Composite)highlightingColorListItem);
        Button button = this.fSyntaxForegroundColorEditor.getButton();
        gridData = new GridData(32);
        button.setLayoutData((Object)gridData);
        this.fBoldCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fBoldCheckBox.setText(PrefMessages.PreferencePage_bold);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gridData);
        this.fItalicCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fItalicCheckBox.setText(PrefMessages.PreferencePage_italic);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gridData);
        this.fStrikethroughCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fStrikethroughCheckBox.setText(PrefMessages.PreferencePage_strikethrough);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gridData);
        this.fUnderlineCheckBox = new Button((Composite)highlightingColorListItem, 32);
        this.fUnderlineCheckBox.setText(PrefMessages.PreferencePage_underline);
        gridData = new GridData(32);
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(PrefMessages.PreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        this.fPreviewViewer = this.createPreviewer(composite2);
        Control control = this.fPreviewViewer.getControl();
        gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(20);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ColoringConfigurationPage.this.handleSyntaxColorListSelection();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                String string = null;
                Button button = (Button)event.widget;
                HighlightingColorListItem highlightingColorListItem = ColoringConfigurationPage.this.getHighlightingColorListItem();
                if (button == ColoringConfigurationPage.this.fBoldCheckBox) {
                    string = highlightingColorListItem.getBoldKey();
                } else if (button == ColoringConfigurationPage.this.fItalicCheckBox) {
                    string = highlightingColorListItem.getItalicKey();
                } else if (button == ColoringConfigurationPage.this.fUnderlineCheckBox) {
                    string = highlightingColorListItem.getUnderlineKey();
                } else if (button == ColoringConfigurationPage.this.fStrikethroughCheckBox) {
                    string = highlightingColorListItem.getStrikethroughKey();
                } else if (button == ColoringConfigurationPage.this.fSyntaxForegroundColorEditor.getButton()) {
                    PreferenceConverter.setValue((IPreferenceStore)ColoringConfigurationPage.this.getOverlayPreferenceStore(), (String)highlightingColorListItem.getColorKey(), (RGB)ColoringConfigurationPage.this.fSyntaxForegroundColorEditor.getColorValue());
                    return;
                }
                if (string != null) {
                    ColoringConfigurationPage.this.getOverlayPreferenceStore().setValue(string, button.getSelection());
                }
            }
        };
        button.addListener(13, listener);
        this.fBoldCheckBox.addListener(13, listener);
        this.fItalicCheckBox.addListener(13, listener);
        this.fUnderlineCheckBox.addListener(13, listener);
        this.fStrikethroughCheckBox.addListener(13, listener);
        return composite2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String loadPreviewContentFromFile(String string) {
        String string2;
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(512);
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(string)));
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string3);
        }
        Object var8_6 = null;
        if (bufferedReader == null) return stringBuffer.toString();
        try {
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {}
        return stringBuffer.toString();
        {
            catch (IOException iOException) {
                UIPlugin.log(iOException);
                Object var8_7 = null;
                if (bufferedReader == null) return stringBuffer.toString();
                try {
                    bufferedReader.close();
                    return stringBuffer.toString();
                }
                catch (IOException iOException2) {}
                return stringBuffer.toString();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void handleSyntaxColorListSelection() {
        HighlightingColorListItem highlightingColorListItem = this.getHighlightingColorListItem();
        if (highlightingColorListItem == null) {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayPreferenceStore(), (String)highlightingColorListItem.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rGB);
        this.fBoldCheckBox.setSelection(this.getOverlayPreferenceStore().getBoolean(highlightingColorListItem.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getOverlayPreferenceStore().getBoolean(highlightingColorListItem.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getOverlayPreferenceStore().getBoolean(highlightingColorListItem.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getOverlayPreferenceStore().getBoolean(highlightingColorListItem.getUnderlineKey()));
        this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
        this.fColorEditorLabel.setEnabled(true);
        this.fBoldCheckBox.setEnabled(true);
        this.fItalicCheckBox.setEnabled(true);
        this.fStrikethroughCheckBox.setEnabled(true);
        this.fUnderlineCheckBox.setEnabled(true);
    }

    protected HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fListViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)object;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected List getListModel() {
        if (this.fListModel == null) {
            String string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[][] stringArray = this.getColorModel();
            this.fListModel = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i][1] == null) {
                    string = stringArray[i][0];
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                    continue;
                }
                this.fListModel.add(new HighlightingColorListItem(string, stringArray[i][0], stringArray[i][1]));
            }
        }
        return this.fListModel;
    }

    protected final OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        List list = this.getListModel();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            HighlightingColorListItem highlightingColorListItem = (HighlightingColorListItem)list.get(i);
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, highlightingColorListItem.getColorKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getBoldKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getItalicKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getStrikethroughKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, highlightingColorListItem.getUnderlineKey()));
        }
        this.addOverlayStoreKeys(arrayList);
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    protected void addOverlayStoreKeys(List list) {
    }

    protected abstract String[][] getColorModel();

    protected abstract SourceViewer createPreviewer(Composite var1);

    protected class ColorListContentProvider
    implements ITreeContentProvider {
        protected ColorListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = ColoringConfigurationPage.this.getListModel().iterator();
            while (iterator.hasNext()) {
                HighlightingColorListItem highlightingColorListItem = (HighlightingColorListItem)iterator.next();
                String string = highlightingColorListItem.getCategory();
                if (string == null) {
                    arrayList.add(highlightingColorListItem);
                    continue;
                }
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            if (object instanceof String) {
                ArrayList<HighlightingColorListItem> arrayList = new ArrayList<HighlightingColorListItem>();
                String string = (String)object;
                Iterator iterator = ColoringConfigurationPage.this.getListModel().iterator();
                while (iterator.hasNext()) {
                    HighlightingColorListItem highlightingColorListItem = (HighlightingColorListItem)iterator.next();
                    if (!string.equals(highlightingColorListItem.getCategory())) continue;
                    arrayList.add(highlightingColorListItem);
                }
                if (arrayList.size() > 0) {
                    return arrayList.toArray();
                }
            }
            return null;
        }

        public Object getParent(Object object) {
            if (object instanceof HighlightingColorListItem) {
                return ((HighlightingColorListItem)object).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return object instanceof String;
        }
    }

    protected static class ColorListLabelProvider
    extends LabelProvider {
        protected ColorListLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            return ((HighlightingColorListItem)object).getDisplayName();
        }
    }

    protected static class HighlightingColorListItem {
        private String fCatetory;
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fUnderlineKey;
        private String fStrikethroughKey;

        public HighlightingColorListItem(String string, String string2, String string3) {
            this.fCatetory = string;
            this.fDisplayName = string2;
            this.fColorKey = string3;
            this.fBoldKey = string3 + ColoringConfigurationPage.BOLD;
            this.fItalicKey = string3 + ColoringConfigurationPage.ITALIC;
            this.fUnderlineKey = string3 + ColoringConfigurationPage.UNDERLINE;
            this.fStrikethroughKey = string3 + ColoringConfigurationPage.STRIKETHROUGH;
        }

        public String getCategory() {
            return this.fCatetory;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }
    }
}

