/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.part;

import com.spket.ui.part.EditorPane;
import com.spket.ui.part.IPart;
import com.spket.ui.part.PartForm;
import com.spket.ui.part.PartPane;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class PartContext {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int AFTER = 5;
    public static final int BEFORE = 6;
    public static final int DOCUMENT = 7;
    static int SASH_WIDTH = 3;
    static int DRAG_MINIMUM = 20;
    private PartForm fSite;
    private PartContext fPrimary;
    private PartContext fSecondary;
    private int fPosition;
    private int fWeight = -1;
    private Sash fSash;
    private int fX;
    private int fY;
    private int fWidth;
    private int fHeight;
    protected PartPane fPartPane;
    protected Listener fSashListener = new Listener(){

        public void handleEvent(Event event) {
            PartContext.this.onDragSash(event);
        }
    };

    public PartContext(PartForm partForm) {
        this.fSite = partForm;
    }

    public PartPane add(IPart iPart, int n, int n2) {
        PartPane partPane = null;
        if (n == 7 || n == 0) {
            if (this.fPrimary == null) {
                if (this.fPartPane == null) {
                    this.fPartPane = n == 7 ? new EditorPane(this.fSite) : new PartPane(this.fSite, this.fSite.showTitle);
                }
                this.fPartPane.add(iPart);
                partPane = this.fPartPane;
            } else {
                partPane = this.fPrimary.add(iPart, n, n2);
            }
        } else {
            int n3 = 256;
            if (n == 3 || n == 4) {
                n3 = 512;
            }
            if (this.fPartPane != null) {
                this.fSecondary = new PartContext(this.fSite);
                this.fPrimary = new PartContext(this.fSite);
                this.fPosition = n;
                PartPane partPane2 = this.fPartPane;
                partPane = this.fSecondary.add(iPart, 0, n2);
                this.fPartPane = null;
                this.fPrimary.fPartPane = partPane2;
                this.fSash = new Sash((Composite)this.fSite, n3);
                this.fSash.addListener(13, this.fSashListener);
            } else if (this.fPrimary == null) {
                this.fPosition = n;
                this.fSecondary = new PartContext(this.fSite);
                this.fPrimary = new PartContext(this.fSite);
                partPane = this.fSecondary.add(iPart, 0, n2);
                this.fSash = new Sash((Composite)this.fSite, n3);
                this.fSash.addListener(13, this.fSashListener);
            } else {
                partPane = this.fPrimary.add(iPart, n, n2);
            }
        }
        return partPane;
    }

    public PartPane add(IPart iPart, IPart iPart2, int n, int n2) {
        if ((n == 5 || n == 6) && iPart2 != null) {
            PartPane partPane = this.getContainer(iPart2);
            if (partPane != null) {
                partPane.add(iPart, iPart2, n);
                return partPane;
            }
            return this.add(iPart, n, n2);
        }
        if (iPart2 == null || this.fPrimary == null) {
            return this.add(iPart, n, n2);
        }
        if (this.fPartPane != null) {
            return this.add(iPart, n, n2);
        }
        if (this.fSecondary != null && this.fSecondary.contains(iPart2)) {
            return this.fSecondary.add(iPart, iPart2, n, n2);
        }
        if (this.fPrimary.contains(iPart2)) {
            return this.fPrimary.add(iPart, iPart2, n, n2);
        }
        return null;
    }

    public boolean contains(IPart iPart) {
        boolean bl = false;
        if (this.fPartPane != null) {
            bl = this.fPartPane.contains(iPart);
        } else {
            if (this.fSecondary != null) {
                bl = this.fSecondary.contains(iPart);
            }
            if (!bl && this.fPrimary != null) {
                bl = this.fPrimary.contains(iPart);
            }
        }
        return bl;
    }

    public boolean isEditorPane() {
        if (this.fPartPane != null) {
            return this.fPartPane instanceof EditorPane;
        }
        if (this.fPrimary != null) {
            return this.fPrimary.isEditorPane();
        }
        return false;
    }

    public PartPane getContainer(IPart iPart) {
        PartPane partPane = null;
        if (this.fPartPane != null) {
            if (this.fPartPane.contains(iPart)) {
                partPane = this.fPartPane;
            }
        } else {
            if (this.fSecondary != null) {
                partPane = this.fSecondary.getContainer(iPart);
            }
            if (partPane == null && this.fPrimary != null) {
                partPane = this.fPrimary.getContainer(iPart);
            }
        }
        return partPane;
    }

    public boolean isVisible() {
        if (this.fPartPane != null) {
            return this.fPartPane.isVisible();
        }
        boolean bl = false;
        if (this.fPrimary != null) {
            bl = this.fPrimary.isVisible();
        }
        if (!bl && this.fSecondary != null) {
            bl = this.fSecondary.isVisible();
        }
        return bl;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.fX = n;
        this.fY = n2;
        this.fWidth = n3;
        this.fHeight = n4;
        this.layout();
    }

    void getPanes(List list) {
        if (this.fPartPane != null) {
            list.add(this.fPartPane);
        } else {
            if (this.fPrimary != null) {
                this.fPrimary.getPanes(list);
            }
            if (this.fSecondary != null) {
                this.fSecondary.getPanes(list);
            }
        }
    }

    void layout() {
        if (this.fPartPane != null) {
            if (this.fPartPane != this.fSite.fMaxPane) {
                this.fPartPane.setBounds(this.fX, this.fY, this.fWidth, this.fHeight);
            }
        } else if (this.fPrimary != null) {
            if (this.fWidth == 0 || this.fHeight == 0) {
                if (this.fSecondary != null) {
                    this.fSecondary.setBounds(0, 0, 0, 0);
                }
                if (this.fPrimary != null) {
                    this.fPrimary.setBounds(0, 0, 0, 0);
                }
                if (this.fSash != null) {
                    this.fSash.setBounds(0, 0, 0, 0);
                }
            } else {
                Rectangle rectangle = new Rectangle(this.fX, this.fY, this.fWidth, this.fHeight);
                if (this.fPrimary.isVisible()) {
                    if (this.fSecondary != null) {
                        if (this.fSecondary.isVisible()) {
                            this.layout(this.fSecondary, rectangle, this.fPosition);
                        } else {
                            this.fSecondary.setBounds(0, 0, 0, 0);
                            if (this.fSash != null) {
                                this.fSash.setBounds(0, 0, 0, 0);
                            }
                        }
                    }
                    this.layout(this.fPrimary, rectangle, 0);
                } else {
                    this.fPrimary.setBounds(0, 0, 0, 0);
                    if (this.fSecondary != null) {
                        if (this.fSecondary.isVisible()) {
                            this.layout(this.fSecondary, rectangle, 0);
                        } else {
                            this.fSecondary.setBounds(0, 0, 0, 0);
                        }
                    }
                    if (this.fSash != null) {
                        this.fSash.setBounds(0, 0, 0, 0);
                    }
                }
            }
        }
    }

    protected Point computeSize(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        if (this.fPartPane == null) {
            Point point;
            if (this.fSecondary != null) {
                if (this.fPosition == 1 || this.fPosition == 2) {
                    point = this.fSecondary.computeSize(n, -1, bl);
                    n3 = point.x;
                    n4 += Math.max(point.y, DRAG_MINIMUM) + SASH_WIDTH;
                } else {
                    point = this.fSecondary.computeSize(-1, n2, bl);
                    n3 += Math.max(point.x, DRAG_MINIMUM) + SASH_WIDTH;
                    n4 += point.y;
                }
            }
            if (this.fPrimary != null) {
                point = this.fPrimary.computeSize(n, n2, bl);
                n3 += point.x;
            }
        } else {
            Point point = this.fPartPane.computeSize(n, n2, bl);
            n3 = point.x;
            n4 = point.y;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    protected void onDragSash(Event event) {
        Sash sash = (Sash)event.widget;
        if (event.detail == 1) {
            switch (this.fPosition) {
                case 1: 
                case 2: {
                    event.y = Math.min(Math.max(this.fY + DRAG_MINIMUM, event.y), this.fHeight - DRAG_MINIMUM);
                    break;
                }
                case 3: 
                case 4: {
                    event.x = Math.min(Math.max(this.fX + DRAG_MINIMUM, event.x), this.fWidth - DRAG_MINIMUM);
                }
            }
            return;
        }
        Rectangle rectangle = sash.getBounds();
        int n = 0;
        int n2 = 0;
        switch (this.fPosition) {
            case 1: {
                n = event.y - rectangle.y;
                n2 = this.fHeight;
                break;
            }
            case 2: {
                n = -(event.y - rectangle.y);
                n2 = this.fHeight;
                break;
            }
            case 3: {
                n = event.x - rectangle.x;
                n2 = this.fWidth;
                break;
            }
            case 4: {
                n = -(event.x - rectangle.x);
                n2 = this.fWidth;
            }
        }
        if (n != 0) {
            if (this.isEditorPane()) {
                this.fWeight += n;
            } else if (n2 > 0) {
                this.fWeight += (n << 10) / n2;
            }
            this.layout();
            this.fSite.redraw(this.fX, this.fY, this.fWidth, this.fHeight, false);
        }
    }

    protected void layout(PartContext partContext, Rectangle rectangle, int n) {
        if (partContext == null) {
            return;
        }
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = n2;
        int n7 = n3;
        if (n != 0) {
            boolean bl;
            boolean bl2 = bl = !this.isEditorPane();
            if (this.fWeight == -1) {
                if (bl) {
                    this.fWeight = 512;
                } else {
                    Point point = partContext.computeSize(n2, -1, true);
                    this.fWeight = Math.max(point.y, DRAG_MINIMUM);
                }
            }
            int n8 = this.fWeight;
            if (bl) {
                n8 = (n == 1 || n == 2 ? n3 : n2) * this.fWeight;
                n8 = Math.max(n8 >> 10, DRAG_MINIMUM);
            }
            if (n == 1 || n == 2) {
                n7 = n8;
                n3 = n7 + SASH_WIDTH;
                if (n == 1) {
                    this.fSash.setBounds(n4, n5 + n7, n6, SASH_WIDTH);
                    rectangle.y += n3;
                } else {
                    if ((n5 += rectangle.height - n7) < 0) {
                        n5 = 0;
                    }
                    this.fSash.setBounds(n4, n5 - SASH_WIDTH, n6, SASH_WIDTH);
                }
            } else {
                n6 = n8;
                n2 = n6 + SASH_WIDTH;
                if (n == 3) {
                    this.fSash.setBounds(n4 + n6, n5, SASH_WIDTH, n7);
                    rectangle.x += n2;
                } else {
                    if ((n4 += rectangle.width - n6) < 0) {
                        n4 = 0;
                    }
                    this.fSash.setBounds(n4 - SASH_WIDTH, n5, SASH_WIDTH, n7);
                }
            }
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        partContext.setBounds(n4, n5, n6, n7);
        if (n == 1 || n == 2) {
            rectangle.height -= n3;
        } else {
            rectangle.width -= n2;
        }
    }
}

