/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.editors;

import com.spket.ui.editors.IDropAction;
import com.spket.ui.text.CodeIndenter;
import com.spket.ui.text.SnippetContextType;
import com.spket.util.Debug;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Point;

public class DropAction
implements IDropAction {
    private String fText;
    private int fOffset;
    private int fSelectionOffset;
    private int fSelectionLength;

    public DropAction(String string, int n) {
        this.fText = string;
        this.fOffset = n;
        this.fSelectionOffset = -1;
        this.fSelectionLength = this.fText.length();
    }

    public void apply(ITextViewer iTextViewer) {
        CodeIndenter codeIndenter;
        String string;
        IDocument iDocument = iTextViewer.getDocument();
        int n = this.fOffset;
        this.fSelectionOffset = -1;
        if (n >= 0 && (string = (codeIndenter = new CodeIndenter(iDocument, n)).format(this.fText)) != null && string.length() > 0 && string != null) {
            TemplateContext templateContext;
            int n2 = string.indexOf(36);
            if (n2 != -1 && (n2 + 1 >= string.length() || string.charAt(n2 + 1) != '{')) {
                n2 = -1;
            }
            if (n2 != -1 && (templateContext = this.createContext(iDocument, n, 0)) != null) {
                Template template = new Template("", "", templateContext.getContextType().getId(), string, true);
                TemplateProposal templateProposal = new TemplateProposal(template, templateContext, (IRegion)new Region(n, 0), null, 0);
                templateProposal.apply(iTextViewer, '\r', 0, n);
                Point point = templateProposal.getSelection(iDocument);
                this.fSelectionOffset = point.x;
                this.fSelectionLength = point.y;
            }
            if (this.fSelectionOffset == -1) {
                try {
                    iDocument.replace(n, 0, string);
                    this.fSelectionOffset = n;
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
            }
        }
    }

    public int getSelectionOffset() {
        return this.fSelectionOffset;
    }

    public int getSelectionLength() {
        return this.fSelectionLength;
    }

    protected TemplateContext createContext(IDocument iDocument, int n, int n2) {
        SnippetContextType snippetContextType = new SnippetContextType();
        return new DocumentTemplateContext((TemplateContextType)snippetContextType, iDocument, n, n2);
    }
}

