/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import com.spket.ui.actions.IRetargetAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class EditorActionGroup {
    protected ITextEditor editor;
    private Map actions = new HashMap();

    public void setEditor(ITextEditor iTextEditor) {
        if (this.editor == iTextEditor) {
            return;
        }
        this.editor = iTextEditor;
        this.updateActions();
    }

    public void dispose() {
        if (this.actions.size() > 0) {
            Iterator iterator = this.actions.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (!(v instanceof IRetargetAction)) continue;
                ((IRetargetAction)v).dispose();
            }
            this.actions.clear();
        }
    }

    public IAction getAction(String string) {
        return (IAction)this.actions.get(string);
    }

    public IContributionItem getContributionItem(String string, boolean bl) {
        IAction iAction = this.getAction(string);
        return iAction == null ? null : new ActionContributionItem(iAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
    }

    protected void registerAction(IAction iAction) {
        this.actions.put(iAction.getId(), iAction);
    }

    protected IAction getEditorAction(String string) {
        return this.editor == null ? null : this.editor.getAction(string);
    }

    protected void updateActions() {
        if (this.actions.size() == 0) {
            return;
        }
        Iterator iterator = this.actions.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof IRetargetAction)) continue;
            IRetargetAction iRetargetAction = (IRetargetAction)v;
            iRetargetAction.setAction(this.getEditorAction(iRetargetAction.getId()));
        }
    }
}

